#ifndef PROJECTILE_H
#define PROJECTILE_H

#include "MovingObjectBase.h"

class Ship;
class TurretBarrel;
class TurretBase;
class Missile;
class Tank;
class GrenadeBase;

#define PROJECTILE_VELOCITY 300


//----------------------------------------------------------------------------
class ProjectileSurfaces : public SingleSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(ProjectileSurfaces);
};


//----------------------------------------------------------------------------
class ProjectileBase : public MovingObjectBase
{
  public:
    //------------------------------------------------------------------------
    ProjectileBase(const unsigned creatorId);
    virtual ~ProjectileBase();

    //------------------------------------------------------------------------
    void update();

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();
};


//----------------------------------------------------------------------------
class ShipProjectile : public ProjectileBase
{
  public:
    ShipProjectile(const Ship *creator);
    ~ShipProjectile();
};

//----------------------------------------------------------------------------
class TurretProjectile : public ProjectileBase
{
  public:
    TurretProjectile(const TurretBase *creator, const TurretBarrel *barrel);
    ~TurretProjectile();
};

//----------------------------------------------------------------------------
class MissileProjectile : public ProjectileBase
{
  public:
    MissileProjectile(const Missile *creator, int angle);
    ~MissileProjectile();
};

//----------------------------------------------------------------------------
class TankProjectile : public ProjectileBase
{
  public:
    TankProjectile(const Tank *creator);
    ~TankProjectile();
};

//----------------------------------------------------------------------------
class GrenadeProjectile : public ProjectileBase
{
  public:
    GrenadeProjectile(const GrenadeBase *creator, int angle);
    ~GrenadeProjectile();
};

#endif //PROJECTILE_H
