#include <iostream>

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

#include "Configuration.h"
#include "Tiles.h"
#include "DecorationBase.h"
#include "GameControlBase.h"
#include "LevelReader.h"
#include "GameBridge.h"
#include "PlayerConfiguration.h"


//----------------------------------------------------------------------------
class LevelTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE(LevelTest);

    CPPUNIT_TEST(testXMLContentOfAllLevels);

    CPPUNIT_TEST_SUITE_END();

public:

    //------------------------------------------------------------------------
    void setUp()
    {
        Configuration::getInstance()->searchDataDir();

        TileCategories::init();
        SurfacesBase::init();

        PlayerConfiguration::create();

        GameInterface::setInstance(GameBridge::getInstance());
    }

    //------------------------------------------------------------------------
    void tearDown() 
    {
        PlayerConfiguration::destroy();

        SurfacesBase::destroy();
        TileCategories::destroy();
    }


protected:

    //------------------------------------------------------------------------
    void testXMLContentOfAllLevels()
    {
        MissionReader mr;
        LevelReader lr;

        MissionReader::const_iterator mIter;
        LevelReader::const_iterator lIter;

        try
        {
            for (mIter = mr.begin(); mIter != mr.end(); ++mIter)
            {
                lr.init(mIter->first.c_str());

                for (lIter = lr.begin(); lIter != lr.end(); ++lIter)
                {
                    GameControlBase::init(
                        lr.getMission().c_str(), lIter->c_str());
                }
            }
        }
        catch (Exception &e)
        {
            std::cerr << std::endl
                      << "Error in '" << mIter->first << "/" << *lIter
                      << "': " << e << "." << std::endl;
            throw;
        }

        GameControlBase::destroy();
    }
};

CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(LevelTest, "Level");
