#ifndef MOVINGDECORATIONBASE_H
#define MOVINGDECORATIONBASE_H

#include "MathTools.h"
#include "DecorationBase.h"

//----------------------------------------------------------------------------
/**
 * This is a base class for all moving decorations.
 */
class MovingDecorationBase : public DecorationBase
{
  public:
    //------------------------------------------------------------------------
    class InitializationData
    {
      public:
        InitializationData(const XMLNode *node)
            throw (XMLException);
        virtual ~InitializationData();
    };

    //------------------------------------------------------------------------
    virtual ~MovingDecorationBase();


    //------------------------------------------------------------------------
    inline void setPosition(Sint16 x, Sint16 y)
    {
        m_finePosition.set(1.0*x, 1.0*y);
        ObjectBase::setPosition(x, y);
    }

    //------------------------------------------------------------------------
    inline void updatePosition()
    {
        ObjectBase::setPosition(
            (Sint16)trunc(m_finePosition.getX()),
            (Sint16)trunc(m_finePosition.getY()));
    }

    //------------------------------------------------------------------------
    /**
     * @return The current fine scale position.
     */
    inline const MATH_TOOLS::Vector &getFinePosition() const
    {
        return m_finePosition;
    }

    /**
     * @return The current fine scale position.
     */
    inline MATH_TOOLS::Vector &getFinePosition()
    {
        return m_finePosition;
    }

    //------------------------------------------------------------------------
    /**
     * @return The current fine scale velocity.
     */
    inline const MATH_TOOLS::Vector &getFineVelocity() const
    {
        return m_fineVelocity;
    }

    /**
     * @return The current fine scale velocity.
     */
    inline MATH_TOOLS::Vector &getFineVelocity()
    {
        return m_fineVelocity;
    }

  protected:
    //------------------------------------------------------------------------
    MovingDecorationBase(const InitializationData &init);

  private:
    //------------------------------------------------------------------------
    /// The object's fine-scale position.
    MATH_TOOLS::Vector m_finePosition;

    /// The current fine-scale velocity of this object.
    MATH_TOOLS::Vector m_fineVelocity;
};

#endif //MOVINGDECORATIONBASE_H
