#ifndef BARRIERS_H
#define BARRIERS_H

#include <map>

#include "Tools.h"
#include "StaticDecorationBase.h"

//----------------------------------------------------------------------------
class BarrierSurfaces : public SurfacesBase
{
    SURFACES_SINGLETON_OBJECT(BarrierSurfaces);

    //------------------------------------------------------------------------
    class SurfaceKey
    {
      public:
        SurfaceKey(HVDecorationBase::Orientation o,
                   bool activated,
                   unsigned size)
            : m_o(o), m_activated(activated), m_size(size) {}
        ~SurfaceKey() {}

        friend bool operator<(const SurfaceKey &k1, const SurfaceKey &k2)
        {
            COMPARE_SURFACE_KEY_MEMBER(m_o);
            if (!k1.m_activated && k2.m_activated)  return true;
            if (k1.m_activated && !k2.m_activated)  return false;
            COMPARE_SURFACE_KEY_MEMBER(m_size);
            return false;
        }

      private:
        HVDecorationBase::Orientation m_o;
        bool m_activated;
        unsigned m_size;
    };

    typedef std::map<SurfaceKey, SDL_Surface*> SurfaceMap;
    typedef SurfaceMap::iterator SurfaceIter;
    typedef SurfaceMap::const_iterator SurfaceCIter;

  public:

    const SDL_Surface *getSurface(HVDecorationBase::Orientation o,
                                  bool activated, unsigned size);

  private:

    SDL_Surface *createSurface(HVDecorationBase::Orientation o,
                               bool activated, unsigned size) const;


    /// All barrier frames for the left bound.
    SDL_Surface *m_left[2];

    /// All barrier frames for the beam.
    SDL_Surface *m_beam[2];

    /// The surface for the deactivated beam.
    SDL_Surface *m_deactivated;

    /// All barrier frames for the right bound.
    SDL_Surface *m_right[2];


    /// A map for all dynamically created barrier surfaces via getSurface().
    SurfaceMap m_surfaceMap;
};



//----------------------------------------------------------------------------
#undef DECLARE_UPDATE_STATE
#define DECLARE_UPDATE_STATE(c) \
    class c; \
    friend class c; \
    class c : public UpdateState \
    { \
        STATE_OBJECT(c); \
      public: \
        c() {} \
        ~c() {} \
        void update(Barrier *barrier); \
    }


//----------------------------------------------------------------------------
class Barrier : public StaticDecorationBase,
                public AnimatedDecorationBase,
                public HVDecorationBase
{
    //------------------------------------------------------------------------
    class UpdateState
    {
      protected:
        UpdateState() {}
      public:
        virtual ~UpdateState() {}

        virtual void update(Barrier *barrier) = 0;
    };

    //------------------------------------------------------------------------
    DECLARE_UPDATE_STATE(Initial);
    DECLARE_UPDATE_STATE(InitialDelay);
    DECLARE_UPDATE_STATE(PermanentActivation);
    DECLARE_UPDATE_STATE(Activated);
    DECLARE_UPDATE_STATE(Deactivated);


  public:

    //------------------------------------------------------------------------
    class InitializationData
        : public StaticDecorationBase::InitializationData,
          public AnimatedDecorationBase::InitializationData,
          public HVDecorationBase::InitializationData
    {
      public:
        InitializationData(const XMLNode *magnetNode)
            throw (XMLException);

        ~InitializationData();
    };


    virtual ~Barrier();

    static Barrier *create(const XMLNode *barrierNode)
        throw (Exception);

    inline void setUpdateState(UpdateState *state)
    {
        m_updateState = state;
    }

    //------------------------------------------------------------------------
    void update();

  protected:
    Barrier(const InitializationData &init);

    static Barrier *create(const InitializationData &init);

    //------------------------------------------------------------------------
    unsigned m_frameCounter;

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    UpdateState *m_updateState;
};

#endif //BARRIERS_H
