#include "QuitMenu.h"

MENU_SINGLETON_INIT(Quit);

//----------------------------------------------------------------------
QuitMenu::QuitMenu() throw(GuiMenuException)
{
  getWidget(ID_QUIT_MENU_DO)->SetEventObject(
      MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&QuitMenu::onDo);
  getWidget(ID_QUIT_MENU_DONT)->SetEventObject(
      MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&QuitMenu::onDont);

  getWidget(ID_QUIT_MENU_LABEL)->Show();
  getWidget(ID_QUIT_MENU_DO)->Show();
  getWidget(ID_QUIT_MENU_DONT)->Show();
}

//----------------------------------------------------------------------
QuitMenu::~QuitMenu()
{
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(QuitMenu::onDo)
{
  PG_Application::GetApp()->Quit();
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(QuitMenu::onDont)
{
  MenuManager::getInstance()->changeTo(getPrevious());
  return true;
}

//----------------------------------------------------------------------
void QuitMenu::eventShow()
{
  getWidget(ID_QUIT_MENU)->Show();
}

//----------------------------------------------------------------------
void QuitMenu::eventHide()
{
  getWidget(ID_QUIT_MENU)->Hide();
}
