#ifndef MOAGG_MENU_H
#define MOAGG_MENU_H

#include <pgwidget.h>
#include <pgeventobject.h>

#include "GuiException.h"
#include "MenuSingleton.h"
#include "MenuManager.h"

//----------------------------------------------------------------------------
class Menu : public PG_Widget, public PG_EventObject
{
  public:
    virtual ~Menu(){};

    inline void setPrevious(Menu* previous) {
      m_previous = previous;
    }

    inline Menu* getPrevious() {
      return m_previous;
    }
    
  protected:

    Menu() throw(GuiMenuException) : PG_Widget(NULL, PG_Rect(0,0,640,480)) {}

    inline PG_Widget* getWidget(int id) throw(GuiMenuException)
    {
        return MenuManager::getWidgetById(id);
    }

    Menu* m_previous;
};

#endif // MOAGG_MENU_H
