#include <sstream>

#include "SDLFrameRate.h"

#include "SoundInterface.h"

#include "PlayerStatus.h"
#include "PlayGround.h"
#include "Ship.h"
#include "Platform.h"
#include "Projectile.h"
#include "Crates.h"
#include "ScoreTable.h"
#include "RaceGame.h"


//----------------------------------------------------------------------------
RaceGame::Running RaceGame::Running::sm_instance;


//----------------------------------------------------------------------------
void RaceGame::InitPlatformsVisitor::do_visit(const XMLProperty *a)
{
}

//----------------------------------------------------------------------------
void RaceGame::InitPlatformsVisitor::do_visit(const XMLNode *n)
{
    if (n->getName() == "gamecontrol")
    {
        n->acceptAllChilds(*this);
    }
    else if (n->getName() == "platform")
    {
        m_game->m_platformList.push_back(n->getIntProperty("number"));
    }
}


//----------------------------------------------------------------------------
void RaceGame::Running::onShipLanded(
    Ship *ship, const Platform *platform, GameControlBase *game)
{
    RaceGame *raceGame = static_cast<RaceGame*>(game);

    // Keep sure, that the ship's thrusters are turned off,
    // before changing to a game state with disabled ship steering.
    ship->setThrust(false);

    Crate *crate = PlayGround::getInstance()->hasCrateFor(ship);
    if (crate)
    {
        // Must be a bonus or fuel crate.

        PlayerStatus::getInstance()->addToScore(
            ScoreTable::getInstance()->getCratePickUp(crate));
        SoundInterface::getInstance()->onCratePickUp();

        switch (crate->getType())
        {
        case CrateSurfaces::T_BONUS:
            break;

        case CrateSurfaces::T_FUEL:
            ship->setFuel(game->getPlayerFuel());
            break;

        default:
            break;
        }

        PlayGround::getInstance()->markObjectToRemove(crate, false);
    }

    if (platform->getNumber() == raceGame->m_platformList.front())
    {
        raceGame->m_platformList.pop_front();

        if (raceGame->m_platformList.empty())
        {
            game->initAddFuelToScore();
            game->setState(AddFuelToScore::getInstance());
        }
    }
}


//----------------------------------------------------------------------------
RaceGame::RaceGame()
{
    setState(Running::getInstance());
}

//----------------------------------------------------------------------------
RaceGame::~RaceGame()
{
}


//----------------------------------------------------------------------------
void RaceGame::initGameControl(const XMLNode *gameControlNode)
    throw (Exception)
{
    PlayGround *playGround = PlayGround::getInstance();

    const XMLNode *startPositionNode =
        gameControlNode->getMandatoryNode("startposition");

    m_playerFuel = SDLFrameRate::getFrameRate() *
        startPositionNode->getUnsignedProperty("fuel", 100);

    m_player = createPlayerShip();

    int platform = startPositionNode->getIntProperty("platform", -1);
    if (platform != -1)
    {
        m_homePlatform = playGround->getPlatform(platform);
        if (m_homePlatform == NULL)
        {
            std::ostringstream s;
            s << "The platform with the number " << platform
              << " doesn't exist" << std::ends;
            throw XMLException(s.str());
        }

        const SDL_Rect &landingZone = m_homePlatform->getLandingZone();

        m_initialXPosition = landingZone.x + landingZone.w/2
            - m_player->getPosition().w/2;
        m_initialYPosition = landingZone.y - m_player->getBottomPixels().y;
        m_initialPositionIsPlatform = true;
    }
    else
    {
        m_initialXPosition = startPositionNode->getIntProperty("x");
        m_initialYPosition = startPositionNode->getIntProperty("y");

        m_initialXPosition -= m_player->getPosition().w/2;
        m_initialYPosition -= m_player->getPosition().h/2;
        m_initialPositionIsPlatform = false;
    }

    resetPlayerShip();

    InitPlatformsVisitor v(this);
    gameControlNode->accept(v);
}
