#include "PlayGround.h"
#include "GameControlBase.h"

#include "Ship.h"
#include "GameBridge.h"


//----------------------------------------------------------------------------
GameBridge GameBridge::sm_instance;


//----------------------------------------------------------------------------
GameBridge::GameBridge()
{
}

//----------------------------------------------------------------------------
GameBridge::~GameBridge()
{
}


//----------------------------------------------------------------------------
Uint16 GameBridge::getPlayGroundXTiles() const
{
    return PlayGround::getInstance()->getBoundingBox().w / 16;
}

//----------------------------------------------------------------------------
Uint16 GameBridge::getPlayGroundYTiles() const
{
    return PlayGround::getInstance()->getBoundingBox().h / 16;
}

//----------------------------------------------------------------------------
void GameBridge::addXGravityToPlayGround(Uint16 x, Uint16 y, int increment)
{
    PlayGround::getInstance()->addXGravity(x, y, increment);
}

//----------------------------------------------------------------------------
void GameBridge::addYGravityToPlayGround(Uint16 x, Uint16 y, int increment)
{
    PlayGround::getInstance()->addYGravity(x, y, increment);
}

//----------------------------------------------------------------------------
int GameBridge::getXGravity(const SDL_Rect &r) const
{
    return PlayGround::getInstance()->getXGravity(r);
}

//----------------------------------------------------------------------------
int GameBridge::getYGravity(const SDL_Rect &r) const
{
    return PlayGround::getInstance()->getYGravity(r);
}

//----------------------------------------------------------------------------
int GameBridge::getXVelocity(const SDL_Rect &r) const
{
    return PlayGround::getInstance()->getXVelocity(r);
}

//----------------------------------------------------------------------------
int GameBridge::getYVelocity(const SDL_Rect &r) const
{
    return PlayGround::getInstance()->getYVelocity(r);
}

//----------------------------------------------------------------------------
unsigned GameBridge::getFriction(const SDL_Rect &r) const
{
    return PlayGround::getInstance()->getFriction(r);
}

//----------------------------------------------------------------------------
void GameBridge::addObjectToPlayGround(ObjectBase *o)
{
    PlayGround::getInstance()->addObject(o);
}

//----------------------------------------------------------------------------
void GameBridge::addParticleToPlayGround(ParticleBase *p)
{
    PlayGround::getInstance()->addParticle(p);
}

//----------------------------------------------------------------------------
bool GameBridge::isBackgroundBetween(Uint16 x1, Uint16 y1,
                                     Uint16 x2, Uint16 y2) const
{
    return PlayGround::getInstance()->isBackgroundBetween(x1, y1, x2, y2);
}

//----------------------------------------------------------------------------
const Platform *GameBridge::isInLandingZone(const Ship *s) const
{
    return PlayGround::getInstance()->isInLandingZone(s);
}

//----------------------------------------------------------------------------
const Ship *GameBridge::getPlayerShip() const
{
    return GameControlBase::getInstance()->getPlayerShip();
}

//----------------------------------------------------------------------------
void GameBridge::onShipTakeoff(const Ship *s)
{
    GameControlBase::getInstance()->onShipTakeoff(s);
}

//----------------------------------------------------------------------------
void GameBridge::onShipLanded(Ship *s, const Platform *platform)
{
    GameControlBase::getInstance()->onShipLanded(s, platform);
}

//----------------------------------------------------------------------------
void GameBridge::onShipFiring(const Ship *s)
{
    GameControlBase::getInstance()->onShipFiring(s);
}

//----------------------------------------------------------------------------
void GameBridge::onShipOutOfFuel(const Ship *s)
{
    GameControlBase::getInstance()->onShipOutOfFuel(s);
}
