#ifndef RACEGAME_H
#define RACEGAME_H

#include <list>

#include "Tools.h"
#include "XMLVisitors.h"

#include "GameControlBase.h"


//----------------------------------------------------------------------------
class RaceGame : public GameControlBase
{
    //------------------------------------------------------------------------
    class InitPlatformsVisitor;
    friend class InitPlatformsVisitor;
    class InitPlatformsVisitor : public XMLConstVisitor
    {
      public:
        //--------------------------------------------------------------------
        InitPlatformsVisitor(RaceGame *game) : m_game(game) {}
        ~InitPlatformsVisitor() { m_game = NULL; }

      private:
        //--------------------------------------------------------------------
        void do_visit(const XMLProperty *a);
        void do_visit(const XMLNode *n);

        //--------------------------------------------------------------------
        RaceGame *m_game;
    };


    //------------------------------------------------------------------------
    typedef std::list<unsigned> PlatformList;
    typedef PlatformList::iterator PlatformListIter;
    typedef PlatformList::const_iterator PlatformListCIter;

    //------------------------------------------------------------------------
    class Running;
    friend class Running;
    class Running : public GameStateBase
    {
        STATE_OBJECT(Running);
      public:
        Running() {}
        ~Running() {}

        void onShipLanded(Ship *ship, const Platform *platform,
                          GameControlBase *game);
        
        
    };

  public:
    RaceGame();
    ~RaceGame();

    //------------------------------------------------------------------------
    void initGameControl(const XMLNode *gameControlNode)
        throw (Exception);

  protected:

    /// List of platform ids, that must be visited by the ship.
    PlatformList m_platformList;

  private:

    GameStateBase *getRunningState() const { return Running::getInstance(); }
    bool continueAfterExplosion() const { return true; }
};

#endif //RACEGAME_H
