#include <sstream>

#include "Configuration.h"
#include "File.h"
#include "LevelReader.h"


//----------------------------------------------------------------------------
LevelReader::LevelReader()
{
}

//----------------------------------------------------------------------------
LevelReader::~LevelReader()
{
}

//----------------------------------------------------------------------------
void LevelReader::init(const char *mission) throw (Exception)
{
    m_mission = mission;

    std::string full;
    full.append(Configuration::getInstance()->getDataDir())
        .append("/levels/").append(mission).append("/levels.idx");

    m_levels.clear();

    File f(full.c_str(), "r");
    while (!f.isEOF())
    {
        char buffer[128] = "";
        f.readline(buffer, 128);

        if (buffer[0] != '#' && strlen(buffer) > 0)
        {
            m_levels.push_back(buffer);
        }
    }
}



//----------------------------------------------------------------------------
MissionReader::MissionReader() throw (Exception)
{
    init();
}

//----------------------------------------------------------------------------
MissionReader::~MissionReader()
{
}

//----------------------------------------------------------------------------
void MissionReader::init() throw (Exception)
{
    std::string full;
    full.append(Configuration::getInstance()->getDataDir())
        .append("/levels/").append("missions.idx");

    m_missions.clear();

    File f(full.c_str(), "r");
    size_t line = 0;

    try
    {
        while (!f.isEOF())
        {
            char buffer[128] = "";
            char *name = NULL;

            ++line;
            f.readline(buffer, 128);
            if (buffer[0] != '#' && strlen(buffer) > 0)
            {
                name = strchr(buffer, ' ');
                if (name == NULL)
                {
                    throw Exception(
                        "The line must have the form 'directory description'");
                }

                *name++ = '\0';
                m_missions.push_back(
                    Entry(std::string(buffer), std::string(name)));
            }
        }
    }
    catch (Exception &e)
    {
        std::ostringstream os;
        os << "Error in '" << full << "'in line " << line << "': "
           << e.toString() << std::ends;
        throw Exception(os.str());
    }
}
