/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"
#include <stdio.h>
#include "udm_uniconv.h"


void __UDMCALL UdmConvInit(UDM_CONV *cnv,UDM_CHARSET *from,UDM_CHARSET *to, int fl)
{
  cnv->from= from;
  cnv->to= to;
  cnv->flags= fl;
  cnv->ibytes= 0;
  cnv->obytes= 0;
  cnv->icodes= cnv->ocodes = 1; /* default for old functions */
  cnv->istate= cnv->ostate = 0; /* default state */
}

int __UDMCALL UdmConv(UDM_CONV *c, char *d, size_t dlen,const char *s, size_t slen)
{
  size_t     i, codes;
  int        res, wc[16]; /* is 16 is enough? */
  int        zero= 0;
  char	     *d_o= d;
  const char *s_e= s+slen;
  char	     *d_e= d+dlen;
  const char *s_o= s;
  
  c->istate = 0; /* set default state */
  c->ostate = 0; /* set default state */
  
  while(s <s_e && d <d_e)
  {
    res= c->from->mb_wc(c, c->from, wc, (const unsigned char*)s,
                                        (const unsigned char*)s_e);
    if (res > 0)
    {
      s+=res;
    }
    else if ((res == UDM_CHARSET_ILSEQ)  || 
             (res == UDM_CHARSET_ILSEQ2) ||
             (res == UDM_CHARSET_ILSEQ3) ||
             (res == UDM_CHARSET_ILSEQ4) ||
             (res == UDM_CHARSET_ILSEQ5) ||
             (res == UDM_CHARSET_ILSEQ6))
    {
      switch (res)
      {
        case UDM_CHARSET_ILSEQ6: s++;
        case UDM_CHARSET_ILSEQ5: s++;
        case UDM_CHARSET_ILSEQ4: s++;
        case UDM_CHARSET_ILSEQ3: s++;
        case UDM_CHARSET_ILSEQ2: s++;
        case UDM_CHARSET_ILSEQ:
        default: s++; break;
      }
      wc[0] = '?';
    }
    else
      break;
    
    codes= c->ocodes;
    for(i= 0; i < codes; i+= c->icodes)
    {
outp:
      if (wc[i] == 0)
        goto outaway;
      res= c->to->wc_mb(c, c->to, &wc[i], (unsigned char*)d, (unsigned char*)d_e);
      if (res > 0)
      {
        d+= res;
      }
      else if (res == UDM_CHARSET_ILUNI && wc[i] != '?')
      {
        if (c->flags & UDM_RECODE_HTML_NONASCII)
        {
          if ( d_e - d > 8)
          {
            res = sprintf(d, "&#%d;", wc[i]);
            d+= res;
          }
          else
            break;
        }
        else
        {
          wc[i] = '?';
          goto outp;
        }
      }
      else
        goto outaway;
    }
  }

outaway:  
  if(d < d_e)
    res= c->to->wc_mb(c, c->to, &zero, (unsigned char*)d, (unsigned char*)d_e);
  c->ibytes= s-s_o;
  return (c->obytes= d - d_o);
}

__C_LINK const char * __UDMCALL UdmCsGroup(const UDM_CHARSET *cs)
{
  switch(cs->family)
  {
    case UDM_CHARSET_ARABIC             : return "Arabic";
    case UDM_CHARSET_ARMENIAN           : return "Armenian";
    case UDM_CHARSET_BALTIC             : return "Baltic";
    case UDM_CHARSET_CELTIC             : return "Celtic";
    case UDM_CHARSET_CENTRAL            : return "Central Eur";
    case UDM_CHARSET_CHINESE_SIMPLIFIED : return "Chinese Simplified";
    case UDM_CHARSET_CHINESE_TRADITIONAL: return "Chinese Traditional";
    case UDM_CHARSET_CYRILLIC           : return "Cyrillic";
    case UDM_CHARSET_GREEK              : return "Greek";
    case UDM_CHARSET_HEBREW             : return "Hebrew";
    case UDM_CHARSET_ICELANDIC          : return "Icelandic";
    case UDM_CHARSET_JAPANESE           : return "Japanese";
    case UDM_CHARSET_KOREAN             : return "Korean";
    case UDM_CHARSET_NORDIC             : return "Nordic";
    case UDM_CHARSET_SOUTHERN           : return "South Eur";
    case UDM_CHARSET_THAI               : return "Thai";
    case UDM_CHARSET_TURKISH            : return "Turkish";
    case UDM_CHARSET_UNICODE            : return "Unicode";
    case UDM_CHARSET_VIETNAMESE         : return "Vietnamese";
    case UDM_CHARSET_WESTERN            : return "Western";
    case UDM_CHARSET_GEORGIAN           : return "Georgian";
    case UDM_CHARSET_INDIAN             : return "Indian";
    default                             : return "Unknown";
  }
}
