/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>

#include "udm_common.h"
#include "udm_wild.h"

#define udm_tolower(c) (tolower(((unsigned char)(c))))

int UdmWildCmp(const char *str, const char *exp)
{
    int x, y;

    for (x = 0, y = 0; exp[y]; ++y, ++x) {
	if ((!str[x]) && (exp[y] != '*'))return -1;
	if (exp[y] == '*') {
	    while (exp[++y] == '*');
	    if (!exp[y])return 0;
	    while (str[x]) {
		int ret;
		if ((ret = UdmWildCmp(&str[x++], &exp[y])) != 1)return ret;
	    }
	    return -1;
	}else
	if ((exp[y] != '?') && (str[x] != exp[y]))return 1;
    }
    return (str[x] != '\0');
}

int __UDMCALL UdmWildCaseCmp(const char *str, const char *exp)
{
    int x, y;

    for (x = 0, y = 0; exp[y]; ++y, ++x) {
	if ((!str[x]) && (exp[y] != '*'))return -1;
	if (exp[y] == '*') {
	    while (exp[++y] == '*');
	    if (!exp[y])return 0;
	    while (str[x]) {
		int ret;
		if ((ret = UdmWildCaseCmp(&str[x++], &exp[y])) != 1)return ret;
	    }
	    return -1;
	}else
	if ((exp[y] != '?') && (udm_tolower(str[x]) != udm_tolower(exp[y])))return 1;
    }
    return (str[x] != '\0');
}
