/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_DBMS_H
#define _UDM_DBMS_H

/* Database type */
#define UDM_DB_UNK			0
#define UDM_DB_MSQL			1
#define UDM_DB_MYSQL			2
#define UDM_DB_PGSQL			3
#define UDM_DB_SOLID			4
#define UDM_DB_VIRT			6
#define UDM_DB_IBASE			7
#define UDM_DB_ORACLE8			8
#define UDM_DB_ORACLE7			9
#define UDM_DB_MSSQL			10
#define UDM_DB_SAPDB			11
#define UDM_DB_DB2			12
#define UDM_DB_SQLITE			13
#define UDM_DB_ACCESS			14
#define UDM_DB_SEARCHD			200
#define UDM_DB_CACHED                   400
#define UDM_DB_CACHE                    401


#define UDM_URL_ACTION_DELETE		1
#define UDM_URL_ACTION_ADD		2
#define UDM_URL_ACTION_SUPDATE		3
#define UDM_URL_ACTION_LUPDATE		4
#define UDM_URL_ACTION_INSWORDS		5
#define UDM_URL_ACTION_INSCWORDS	6
#define UDM_URL_ACTION_DELWORDS		7
#define UDM_URL_ACTION_DELCWORDS	8
#define UDM_URL_ACTION_UPDCLONE		9
#define UDM_URL_ACTION_REGCHILD		10
#define UDM_URL_ACTION_FINDBYURL	11
#define UDM_URL_ACTION_FINDBYMSG	12
#define UDM_URL_ACTION_FINDORIG		13
#define UDM_URL_ACTION_EXPIRE		14
#define UDM_URL_ACTION_REFERERS		15
#define UDM_URL_ACTION_SERVERTABLE	17
#define UDM_URL_ACTION_DOCCOUNT		18
#define UDM_URL_ACTION_FLUSH		19
#define UDM_URL_ACTION_WRITEDATA        20
#define UDM_URL_ACTION_LINKS_DELETE     21

#define UDM_RES_ACTION_DOCINFO		1
#define UDM_RES_ACTION_INSWORDS		2

#define UDM_CAT_ACTION_PATH		1
#define UDM_CAT_ACTION_LIST		2

#define UDM_SRV_ACTION_TABLE		1
#define UDM_SRV_ACTION_FLUSH            2
#define UDM_SRV_ACTION_ADD              3
#define UDM_SRV_ACTION_ID               4
#define UDM_SRV_ACTION_POPRANK          5

#define UDM_IFIELD_TYPE_HOUR     0
#define UDM_IFIELD_TYPE_MIN      1
#define UDM_IFIELD_TYPE_HOSTNAME 2
#define UDM_IFIELD_TYPE_STRCRC32 3
#define UDM_IFIELD_TYPE_INT      4
#define UDM_IFIELD_TYPE_HEX8STR  5

#define UDM_LIMTYPE_NESTED     0
#define UDM_LIMTYPE_TIME       1
#define UDM_LIMTYPE_LINEAR_INT 2
#define UDM_LIMTYPE_LINEAR_CRC 3

#define UDM_LIMFNAME_CAT   "lim_cat"
#define UDM_LIMFNAME_TAG   "lim_tag"
#define UDM_LIMFNAME_TIME  "lim_time"
#define UDM_LIMFNAME_HOST  "lim_host"
#define UDM_LIMFNAME_LANG  "lim_lang"
#define UDM_LIMFNAME_CTYPE "lim_ctype"
#define UDM_LIMFNAME_SITE  "lim_site"

extern void	*UdmDBInit(void *db);
extern void	UdmDBFree(void *db);

extern __C_LINK int __UDMCALL UdmURLAction(UDM_AGENT *A, UDM_DOCUMENT   *D, int cmd);
extern __C_LINK int __UDMCALL UdmResAction(UDM_AGENT *A, UDM_RESULT     *R, int cmd);
extern __C_LINK int __UDMCALL UdmCatAction(UDM_AGENT *A, UDM_CATEGORY   *C, int cmd);
extern __C_LINK int __UDMCALL UdmSrvAction(UDM_AGENT *A, UDM_SERVERLIST *S, int cmd);
extern __C_LINK int __UDMCALL UdmTargets(UDM_AGENT *Indexer);

extern __C_LINK int __UDMCALL UdmLimit8(UDM_ENV *Conf, UDM_UINT8URLIDLIST *L,const char *field, int type, void *db);
extern __C_LINK int __UDMCALL UdmLimit4(UDM_ENV *Conf, UDM_UINT4URLIDLIST *L,const char *field, int type, void *db);

extern __C_LINK UDM_RESULT * __UDMCALL UdmFind(UDM_AGENT *);
extern __C_LINK int __UDMCALL UdmClearDatabase(UDM_AGENT *A);
extern __C_LINK int __UDMCALL UdmStatAction(UDM_AGENT *A, UDM_STATLIST *S);

extern __C_LINK int __UDMCALL UdmTrack(UDM_AGENT * query, UDM_RESULT *Res);
extern __C_LINK UDM_RESULT * __UDMCALL UdmCloneList(UDM_AGENT * Indexer, UDM_DOCUMENT *Doc);

extern UDM_DBLIST	*UdmDBListInit(UDM_DBLIST *List);
extern size_t		UdmDBListAdd(UDM_DBLIST *List, const char * addr, int mode);
extern void		UdmDBListFree(UDM_DBLIST *List);
extern int UdmDBSetAddr(UDM_DB *db, const char *dbaddr, int mode);
extern unsigned int     UdmGetCategoryId(UDM_ENV *Conf, char *category);

extern int UdmFindWords(UDM_AGENT *A, UDM_RESULT *Res);
extern int UdmHTDBGet(UDM_AGENT *Indexer,UDM_DOCUMENT *Doc);

/******************/

#ifdef HAVE_SQL
extern int   UdmClearDBSQL(UDM_AGENT    *A, UDM_DB *db);
extern int   UdmURLActionSQL(UDM_AGENT  *A, UDM_DOCUMENT   *D, int cmd, UDM_DB *db);
extern int   UdmResActionSQL(UDM_AGENT  *A, UDM_RESULT     *R, int cmd, UDM_DB *db, size_t dbnum);
extern int   UdmCatActionSQL(UDM_AGENT  *A, UDM_CATEGORY   *C, int cmd, UDM_DB *db);
extern int   UdmSrvActionSQL(UDM_AGENT  *A, UDM_SERVERLIST *S, int cmd, UDM_DB *db);
extern int   UdmStatActionSQL(UDM_AGENT *A, UDM_STATLIST   *S, UDM_DB *db);
extern int   UdmFindWordsSQL(UDM_AGENT *, UDM_RESULT *Res, UDM_DB *db);
extern int   UdmURLDataSQL(UDM_ENV *Conf, UDM_URLDATALIST *L, UDM_DB *db);
extern int   UdmLimit8SQL(UDM_ENV *Conf, UDM_UINT8URLIDLIST *L,const char *field, int type, UDM_DB *db);
extern int   UdmLimit4SQL(UDM_ENV *Conf, UDM_UINT4URLIDLIST *L,const char *field, int type, UDM_DB *db);
extern unsigned int   UdmGetCategoryIdSQL(UDM_ENV *Conf, char *category, UDM_DB *db);
extern int UdmResAddDocInfoSQL(UDM_AGENT *query, UDM_DB *db, UDM_RESULT *Res, size_t i);
extern int UdmTrackSQL(UDM_AGENT * query, UDM_RESULT *Res, UDM_DB *db);
extern int UdmCloneListSQL(UDM_AGENT * Indexer, UDM_DOCUMENT *Doc, UDM_RESULT *Res, UDM_DB *db);
extern int UdmLoadURLDataSQL(UDM_AGENT *A, UDM_RESULT *R, UDM_DB *db);
extern int UdmTargetsSQL(UDM_AGENT *Indexer, UDM_DB *db);
#endif


extern int LogdInit(UDM_DB *db,const char *var_dir);
extern int LogdClose(UDM_DB *db);
extern int LogdSaveAllBufs(UDM_DB *db);
extern int LogdStoreDoc(UDM_DB *db,UDM_LOGD_CMD cmd,UDM_LOGD_WRD *wrd);

extern int UdmLogdClose(UDM_AGENT *Agent, UDM_DB *db, int shared);
extern int UdmLogdSaveAllBufs(UDM_AGENT *Agent);
extern int UdmLogdStoreDoc(UDM_AGENT *Agent, UDM_LOGD_CMD cmd, UDM_LOGD_WRD *wrd, UDM_DB *db);


extern int UdmClearCacheTree(UDM_ENV * Env);
extern __C_LINK int __UDMCALL UdmSplitCacheLog(UDM_ENV * Env, int lognum, UDM_LOGDEL *buf, int del_count);
extern __C_LINK int __UDMCALL UdmRemoveDelLogDups(UDM_LOGDEL *words, int n);
extern int UdmStoreWordsCache(UDM_AGENT * Indexer,UDM_DOCUMENT *Doc, UDM_DB *db);
extern int UdmFindWordsCache(UDM_AGENT * Indexer,UDM_RESULT *Res, UDM_DB *db);
extern int UdmDeleteURLFromCache(UDM_AGENT *Indexer, urlid_t url_id, UDM_DB *db);
extern int UdmURLDataWrite(UDM_AGENT *Indexer, UDM_DB *db);
extern int UdmURLData(UDM_ENV *Conf, UDM_URLDATALIST *L, UDM_DB *db);

extern void UdmDecodeHex8Str(const char *hex_str, uint4 *hi, uint4 *lo, uint4 *fhi, uint4 *flo);

extern __C_LINK int __UDMCALL UdmAddSearchLimit(UDM_AGENT *Agent, int type, const char *file_name, const char *val);





#endif
