<?php
/*
 * $Horde: mnemo/view.php,v 1.1.2.5 2005/01/03 11:25:59 jan Exp $
 *
 * Copyright 2001-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 */

define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';

/* If we aren't provided with a memo, redirect to the memo list. */
$memo_id = Horde::getFormData('memo');
if (!isset($memo_id)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Create a Mnemo storage instance. */
require_once MNEMO_BASE . '/lib/Driver.php';
$storage = &Mnemo_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                  $conf['storage']['params']);
$storage->retrieve();

/* Get the current memo list. */
$memos = Mnemo::listMemos($storage);

/* Set the page title to the current memo's name, if it exists. */
$title = (!empty($memos[$memo_id])) ? $memos[$memo_id]['desc'] : _("Note Details");

require MNEMO_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    include_once MNEMO_TEMPLATES . '/javascript/print.js';
} else {
    $print_link = Mnemo::addParameter('view.php', 'memo=' . $memo_id);
    $print_link = Mnemo::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        include_once MNEMO_TEMPLATES . '/javascript/open_print_win.js';
    }

    require MNEMO_BASE . '/menu.php';
    $notification->notify();
}

/* If the requested memo doesn't exist, display an error message. */
if (is_null($memos[$memo_id])) {
    include MNEMO_TEMPLATES . '/view/no-memo.inc';
} else {
    include MNEMO_TEMPLATES . '/view/headers.inc';
    include MNEMO_TEMPLATES . '/view/description.inc';
    if (!$print_view) {
        include MNEMO_TEMPLATES . '/view/navbar.inc';
    }
}

require MNEMO_TEMPLATES . '/common-footer.inc';
