      SUBROUTINE MN_SUM(COMAND,IDELIM)
C
C     Sums a histogram or integrates a function over a range
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnfun.inc"
#include "mnfit.inc"
#include "mnprs.inc"
#include "mnusr.inc"
#include "mnlun.inc"
C
      CHARACTER*(*) COMAND
C
      LOGICAL  QCHLG
      REAL AFLO(MDIMMX),AFHI(MDIMMX)
      real xbsav
C
      INTEGER IUSEE(20),lent
      integer lnblnk
      external lnblnk
C
      IF(COMAND.EQ.'SUM') THEN
          CALL WAITYQ('Give histogram number: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
          IF(NNID.LE.0) GOTO 9000
          IF(IDA.LE.0) GOTO 9000
C
          CALL MN_HGT(IDA,IDB,NH)
          IF(NH.LE.0) THEN
              WRITE(TXTERR,'(''Histogram'',I7,I4
     1         ,'' does not exist'')') IDA,IDB
              CALL MN_ERR('MN_CMD',TXTERR)
              GOTO 9000
          ENDIF
C
          IF(NDIM.LT.-1) THEN
              CALL MN_ERR('MN_SUM','I cannot sum Ntuples')
              GOTO 9000
          ELSEIF(NDIM.GT.2) THEN
              CALL MN_ERR('MN_SUM'
     +         ,'I cannot sum more than 2-d histogram')
              GOTO 9000
          ENDIF
C
          IF(NDIM.LT.0) THEN
              NBX = NPNT
              NBY = 1
          ELSEIF(NDIM.EQ.1) THEN
              NBX = IDBIN(1)
              NBY = 1
          ELSEIF(NDIM.EQ.2) THEN
              NBX = IDBIN(1)
              NBY = IDBIN(2)
          ENDIF
C
          DO 5600 II=1,IABS(NDIM)
            IF(IDELIM.LT.0) THEN
              lent = lnblnk(tdnam(ii,nh))
              WRITE(TXTMES,'(1X,A,'' axis: '')')
     +         TDNAM(II,NH)(:lent)
              CALL MN_MES(LUNTTO,'ME',TXTMES)
            ENDIF
            CALL MN_BLM(2,ntmode,IDELIM,COMAND
     +       ,NDUM,AFLO(II),AFHI(II),NNUM,IERR)
            IF(IERR.NE.0) GOTO 9000
C
            IF(AFLO(II).GT.ADHI(II) .OR. AFHI(II).LT.ADLO(II)) THEN
              CALL MN_MES(LUNTTO,'M'
     +         ,' WARNING: The summing range is' //
     +         ' outside the histogram limits')
              WRITE(TXTMES,'('' Histogram limits:'',2G11.4)')
     1         ADLO(II),ADHI(II)
              CALL MN_MES(LUNTTO,'E',TXTMES)
            ENDIF
 5600     CONTINUE
C
          NSUM = 0
          SUM  = 0.0
          NERR = 0
          NPT  = 0
          DO 5660 JJ=1,NBY
              DO 5650 II=1,NBX
                  NPT = NPT + 1
                  DO 5640 KK=1,IABS(NDIM)
                      IF(KK.EQ.1)THEN
                          XX = AMNP(II,NH,KK,1,NERR)
                      ELSE
                          XX = AMNP(JJ,NH,KK,1,NERR)
                      ENDIF
                      IF(XX.LT.AFLO(KK) .OR. XX.GT.AFHI(KK)) THEN
                          GOTO 5650
                      ENDIF
5640              CONTINUE
C
                  EE = AMNE(NPT,NH,NERR)
                  NSUM = NSUM + 1
                  SUM = SUM + EE
5650          CONTINUE
5660      CONTINUE
C
          REGIS(101) = SUM
          REGIS(102) = FLOAT(NSUM)
          IF(IABS(NDIM).GT.1) THEN
              DO 6000 II=1,IABS(NDIM)
                  IF(II.EQ.1) THEN
                      WRITE(TXTMES,'('' Sum from'',1X,A,'' axis''
     1                 ,1PG11.4,'' ->'',1PG11.4)') TDNAM(II,NH)
     2                 ,AFLO(II),AFHI(II)
                  ELSE IF(II.LT.IABS(NDIM)) THEN
                      WRITE(TXTMES,'(9X,1X,A,'' axis''
     1                 ,1PG11.4,'' ->'',1PG11.4)')
     2                 TDNAM(II,NH),AFLO(II),AFHI(II)
                  ELSE
                      WRITE(TXTMES,'(9X,1X,A,'' axis''
     1                 ,1PG11.4,'' ->'',1PG11.4,'' is'',1PG12.5)')
     2                 TDNAM(II,NH),AFLO(II),AFHI(II),SUM
                  ENDIF
                  CALL MN_MES(LUNTTO,'ME',TXTMES)
6000          CONTINUE
          ELSE
              WRITE(TXTMES,'('' Sum from'',1PG11.4,'' ->'',1PG11.4
     1         ,'' is'',1PG12.5)') AFLO(1),AFHI(1),SUM
              CALL MN_MES(LUNTTO,'ME',TXTMES)
          ENDIF
C
C     INTEGRATE A FUNCTION OVER A RANGE
C
      ELSEIF(COMAND.EQ.'INTEGRATE') THEN
C
          CALL WAITYQ('Give function number(s): ')
          CALL MN_FQU(IUSEE,0,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
C
          CALL MN_BLM(2,0,IDELIM,COMAND
     +     ,NDUM,AFLO(1),AFHI(1),NNUM,IERR)
          IF(IERR.NE.0) GOTO 9000
C
C         If you are integrating a Cheby or Legendre,  you don't want to
C         redefine XMINNM&XMAXNM.   DN Brown 06/02/92.
C         You don't want to redefine these limits at all! ICB 04/11/2005
C
          QCHLG = .FALSE.
          DO 7200 IF=1,NFUN_MN
              IF(IUSEF(IF).EQ.0) GOTO 7200
              IF(IUSEE(IF).EQ.0) GOTO 7200
              IF(TUSEF(IF)(1: 9).EQ.'Chebyshev' .OR.
     +           TUSEF(IF)(1: 8).EQ.'Legendre'  .OR.
     +           TUSEF(IF)(2:10).EQ.'Chebyshev' .OR.
     +           TUSEF(IF)(2: 9).EQ.'Legendre') QCHLG = .TRUE.
7200      CONTINUE
          IF(QCHLG .AND. XMINNM .GE. XMAXNM) QCHLG = .FALSE.
          xbsav = xbinnm
*ICB          IF(.NOT.QSORTH .AND. .NOT.QCHLG .AND. NHFIT.LE.0) THEN
*ICB              XMINNM = AFLO(1)
*ICB              XMAXNM = AFHI(1)
*ICB          ENDIF
          XBINNM = 1.0
*
*         Check that the integration limits do not exceed the
*         orthogonality limits
*
          IF(QCHLG .AND.
     +       (AFLO(1).LT.XMINNM .OR. AFHI(1).GT.XMAXNM)) THEN
              TXTERR = 'Integration limits are outside' //
     +         ' orthogonality limits for Chebyshev or Legendre'
              CALL M_EMSG('MN_SUM',TXTERR)
              WRITE(TXTERR,'('' Orthogonality limits'',2(1PG11.4))'
     +         ,IOSTAT=IOERR) XMINNM,XMAXNM
              CALL MN_ERR('MN_SUM',TXTERR)
              GOTO 9000
          ENDIF
C
          SUM = 0.0
          NH = 1
          DO 7500 IF=1,NFUN_MN
              IF(IUSEF(IF).EQ.0) GOTO 7500
              IF(IUSEE(IF).EQ.0) GOTO 7500
              SUM = SUM + AMNINT(IF,NH,AFLO(1),AFHI(1),IERR)
7500      CONTINUE
*
          xbinnm = xbsav
C
          REGIS(101) = SUM
          WRITE(TXTMES,'('' Integral from'',1PG11.4,'' ->'',1PG11.4
     1     ,'' is'',1PG12.5)') AFLO(1),AFHI(1),SUM
          CALL MN_MES(LUNTTO,'ME',TXTMES)
C
      ENDIF
C
9000  CONTINUE
      END
