      SUBROUTINE M_DBDSUB(ndate1,ndate2,ndate,ierr)
C
C-----------------------------------------------------------------------
C
C     Takes a date in the form yymmdd and subtracts years, months and days
C     also given in the form yymmdd
C     Checks that the result is legal
*     If not date is reduced until it is legal
C
C     Called by M_DBASE
C
C-----------------------------------------------------------------------
C
      implicit none
*
      integer ndate1,ndate2,ndate,ierr
*
#include "mnlun.inc"
*
      integer imnth(0:12),nyear1,nmnth1,nday1,nyear2,nmnth2,nday2
     + ,nyear,nmnth,nday,ioerr
*
      data imnth/31,31,28,31,30,31,30,31,31,30,31,30,31/
*
      ierr  = 0
      ndate = 0

      nyear1 = ndate1 / 10000
      nmnth1 = mod(ndate1,10000) / 100
      nday1  = mod(ndate1,100)
      nyear2 = ndate2 / 10000
      nmnth2 = mod(ndate2,10000) / 100
      nday2  = mod(ndate2,100)
C
      nyear = nyear1 - nyear2
      nmnth = nmnth1 - nmnth2
      nday  = nday1  - nday2
C
      if(nyear.le.0) then
          write(txterr,'(''Error in year:'',2I8)',iostat=ioerr)
     +     nyear1,nyear2
          call mn_err('M_DBDSUB',txterr)
          ierr = 1
          goto 9000
      endif
C
      if(nmnth.le.0) then
          nmnth = nmnth + 12
          nyear = nyear - 1
      endif
      if(nmnth.le.0 .or. nmnth.gt.12) then
          write(txterr,'(''Error in month:'',2I8)',iostat=ioerr)
     +     ndate1,ndate2
          call mn_err('M_DBDCHK',txterr)
          ierr = 1
          goto 9000
      endif
C
      if(nday.le.0) then
          nday = nday + imnth(nmnth-1)
          nmnth = nmnth - 1
          if(nmnth.le.0) then
              nmnth = nmnth + 12
              nyear = nyear -1
          endif
      endif
C
      if(nday.gt.imnth(nmnth)) then
          nday = max0(nday,imnth(nmnth))
      endif
*
      ndate = 10000*nyear + 100*nmnth + nday
      write(txtmes,'('' Input dates:'',2(1x,2(I2.2,''/''),I2.2)
     + ,'', Output date:'',2(i2.2,''/''),i2.2,3i8)'
     + ,iostat=ioerr) nday1,nmnth1,nyear1,nday2,nmnth2,nyear2
     + ,nday,nmnth,nyear,ndate1,ndate2,ndate
      call mn_mes(luntto,'ME',txtmes)
C
 9000 continue
      END

