      SUBROUTINE M_EXCL (NMODE,NH,LUN,IDELIM)
C
C     SUBROUTINE FOR SETTING, PRINTING AND DELETING EXCLUSIONS
C     NOTE THAT IF YOU SET OR DELETE EXCLUSIONS THEN THE FLAG ON
C     THE STATE OF FITTING MUST BE RESET
C
C     NMODE = -3 MEANS DELETE BOTH INC & EXC   (DN Brown 02-20-92)
C     NMODE = -2 MEANS DELETE INCLUSIONS ON HISTOGRAM
C     NMODE = -1 MEANS DELETE EXCLUSIONS ON HISTOGRAM
C     NMODE =  0 MEANS PRINT THE EXCLUSIONS
C     NMODE =  1 MEANS SET EXCLUSIONS
C     NMODE =  2 MEANS SET INCLUSIONS
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      CHARACTER*9 TTAG,TCTAG,TTTEM
      CHARACTER*32 TNAME(MDIMMX+1)
      LOGICAL QEXIT,QQCHGE
C
      IF(NH.GT.0) THEN
          IDA = IDFITA(NH)
          IDB = IDFITB(NH)
      ENDIF
      QEXIT = IDELIM.GE.0
      QQCHGE = .FALSE.
C
      IF(IABS(NMODE).EQ.2) THEN
          TTAG  = 'inclusion'
          TCTAG = 'Inclusion'
      ELSE
          TTAG  = 'exclusion'
          TCTAG = 'Exclusion'
      ENDIF
C
C     Delete the exclusions or inclusions on a plot
C
      IF(NMODE .LT. 0) THEN
          IF(NH.GT.0) THEN
              NH1 = NH
              NH2 = NH
          ELSE
              NH1 = 1
              NH2 = NHFIT
          ENDIF
          DO 1000 NNH=NH1,NH2
              IDA = IDFITA(NNH)
              IDB = IDFITB(NNH)
              IF((NMODE.EQ.-1 .OR. NMODE .EQ. -3) .AND.
     +         IXEXCL(NNH).GT.0 .OR. IYEXCL(NNH).GT.0) THEN
                  IXEXCL(NNH) = 0
                  IYEXCL(NNH) = 0
                  WRITE(TXTMES,'(1X,A,''s for plot'',I7,I4
     1             ,'' removed'')') TCTAG,IDA,IDB
                  CALL MN_MES(LUN,'ME',TXTMES)
                  QQCHGE = .TRUE.
              ENDIF
              IF((NMODE.EQ.-2 .OR. NMODE .EQ. -3) .AND.
     +         IXINCL(NNH).GT.0 .OR. IYINCL(NNH).GT.0) THEN
                  IXINCL(NNH) = 0
                  IYINCL(NNH) = 0
                  TTTEM = 'Inclusion'
                  WRITE(TXTMES,'(1X,A,''s for plot'',I7,I4
     1             ,'' removed'')') TTTEM,IDA,IDB
                  CALL MN_MES(LUN,'ME',TXTMES)
                  QQCHGE = .TRUE.
              ENDIF
              IF(NMODE.EQ.-1 .AND.IXEXCL(NNH).LE.0.AND.
     1           IYEXCL(NNH).LE.0) THEN
                  WRITE(TXTMES,'('' There are no '',A,''s for plot''
     1             ,I7,I4)') TTAG,IDA,IDB
                  CALL MN_MES(LUN,'ME',TXTMES)
              ENDIF
              IF(NMODE.EQ.-2 .AND.IXINCL(NNH).LE.0.AND.
     1           IYINCL(NNH).LE.0) THEN
                  TTTEM = 'inclusion'
                  WRITE(TXTMES,'('' There are no '',A,''s for plot''
     1             ,I7,I4)') TTTEM,IDA,IDB
                  CALL MN_MES(LUN,'ME',TXTMES)
              ENDIF
              IF(NMODE.EQ.-3 .AND.IXEXCL(NNH).LE.0.AND.
     1           IYEXCL(NNH).LE.0.AND.IXINCL(NNH).LE.0.AND.
     2           IYINCL(NNH).LE.0) THEN
                  WRITE(TXTMES,'('' There are no '',A,''s for plot''
     1             ,I7,I4)') TTAG,IDA,IDB
                  CALL MN_MES(LUN,'ME',TXTMES)
              ENDIF
1000      CONTINUE
C
C     Print the current exclusions and inclusions
C
      ELSE IF(NMODE.EQ.0) THEN
          NDIM = IFNDIM(NH)
          IF(IXEXCL(NH).GT.0) THEN
              WRITE(LUN,12000) TCTAG
     1         ,IDA,IDB,TFNAM(1,NH)(1:LENOCC(TFNAM(1,NH)))
     1         ,(XLEXCL(JJ,NH),XHEXCL(JJ,NH)
     1         ,JJ=1,IXEXCL(NH))
          ENDIF
          IF(IXINCL(NH).GT.0) THEN
              TTTEM = 'Inclusion'
              WRITE(LUN,12000) TTTEM
     1         ,IDA,IDB,TFNAM(1,NH)(1:LENOCC(TFNAM(1,NH)))
     1         ,(XLINCL(JJ,NH),XHINCL(JJ,NH)
     1         ,JJ=1,IXINCL(NH))
          ENDIF
          IF(IXEXCL(NH).LE.0 .AND. IXINCL(NH).LE.0) THEN
              WRITE(LUN,12050)
     1         IDA,IDB,TFNAM(1,NH)(1:LENOCC(TFNAM(1,NH)))
          ENDIF
C
          IF(IABS(NDIM).GT.1) THEN
              IF(IYEXCL(NH).GT.0) THEN
                  WRITE(LUN,12000) TCTAG
     1             ,IDA,IDB,TFNAM(2,NH)(1:LENOCC(TFNAM(2,NH)))
     1             ,(YLEXCL(JJ,NH),YHEXCL(JJ,NH)
     1             ,JJ=1,IYEXCL(NH))
              ENDIF
              IF(IYINCL(NH).GT.0) THEN
                  WRITE(LUN,12000) TCTAG
     1             ,IDA,IDB,TFNAM(2,NH)(1:LENOCC(TFNAM(2,NH)))
     1             ,(YLINCL(JJ,NH),YHINCL(JJ,NH)
     1             ,JJ=1,IYINCL(NH))
              ENDIF
              IF(IYEXCL(NH).LE.0 .AND. IYINCL(NH).LE.0) THEN
                  WRITE(LUN,12050)
     1             IDA,IDB,TFNAM(2,NH)(1:LENOCC(TFNAM(2,NH)))
              ENDIF
          ENDIF
12000     FORMAT(1X,A,'s for plot',I7,I4,2X,A,' axis are:'
     1     ,/,(T10,1X,1PG13.5,' ->',1PG13.5))
12050     FORMAT(' No exclusions or inclusions for plot',I7,I4
     1     ,2X,A,' axis')
C
C     SET SOME EXCLUSIONS
C
      ELSEIF(NMODE.EQ.1 .OR. NMODE.EQ.2) THEN
3000      CONTINUE
          NAX  = 1
          NNUM = 0
          NDIM = IFNDIM(NH)
          DO 3050 II=1,IABS(NDIM)
              TNAME(II) = TFNAM(II,NH)
3050      CONTINUE
          TNAME(IABS(NDIM)+1) = ' '
C
          IF(IABS(NDIM).EQ.1) THEN
              CALL WAITYQ(
     1         'EXCLUDE> Give lower and upper edges of ' //
     +         TTAG // ': ')
          ELSE
              IF(IABS(NMODE).EQ.2) THEN
                  CALL WAITYQ('INCLUDE> Give axis and' //
     1             ' lower and upper edges of ' // TTAG // ': ')
              ELSE
                  CALL WAITYQ('EXCLUDE> Give axis and' //
     1             ' lower and upper edges of ' // TTAG // ': ')
              ENDIF
C
C             SEE IF AXIS NAME OR NUMBER WAS SPECIFIED
C
              NVAL = INTTYQ(.TRUE.,IDELIM)
              IF(IDELIM.GT.0) THEN
                  CALL RESTYQ
                  JCMD = ICMTYQ(.TRUE.,IDELIM,TNAME)
                  IF(JCMD.GT.0 .AND. JCMD.LE.IABS(NDIM)) THEN
                      NAX  = JCMD
                      NNUM = 0
                      GOTO 3100
                  ENDIF
              ELSE
                  CALL MN_NCK(NVAL,IDELIM,IERR)
                  IF(IERR.EQ.2) GOTO 9000
              ENDIF
C
              IF(NVAL.GT.0 .AND. NVAL.LT.IABS(NDIM)) THEN
                  NAX = NVAL
              ELSE
                  CALL MN_ERR('M_EXCL'
     +             ,'Error specifying axis for ' // TTAG)
                  GOTO 9000
              ENDIF
          ENDIF
C
C         GET THE LIMITS HERE
C
3100      CONTINUE
          RVAL = VALTYQ(.TRUE.,IDELIM)
C
          CALL MN_RCK(RVAL,IDELIM,IERR)
          IF(IERR.EQ.2) GOTO 9000
          IF(IERR.GT.0) THEN
              IF(QRFILE) THEN
                  CALL RESTYQ
              ELSE
                  CALL ZERTYQ('.FALSE.')
              ENDIF
              GOTO 9000
          ENDIF
C
          NNUM = NNUM + 1
          IF(NNUM.EQ.1) THEN
              XFLO = RVAL
          ELSE IF(NNUM.EQ.2) THEN
              XFHI = RVAL
          ENDIF
          IF(NNUM.LT.2 .AND. IDELIM.EQ.0) GOTO 3100
C
          IF(NNUM.LT.2) THEN
              CALL MN_ERR('M_EXCL','You must give both lower' //
     1         ' and upper limits')
              GOTO 9000
          ELSE IF(XFHI.LE.XFLO) THEN
              WRITE(TXTERR,'(''Error in '',A,''.''
     1         ,'' Lower and upper limits'',F8.2,'' ->'',F8.2)')
     1         TTAG,XFLO,XFHI
              CALL MN_ERR('M_EXCL',TXTERR)
              GOTO 9000
          ENDIF
C
          IF(NHFIT.EQ.1) THEN
              IDA = IDFITA(1)
              IDB = IDFITB(1)
          ELSE
              CALL WAITYQ(
     1         'Give histogram number ' // TTAG // ' applies to' //
     1         ' (0 for all): ')
              CALL MN_HNO(IDA,IDB,IDELIM,NNID)
              IF(NNID.EQ.0) GOTO 9000
          ENDIF
C
          DO 3500 NNH=1,NHFIT
              IF(IDA.EQ.0 .OR.
     1           (IDFITA(NNH).EQ.IDA .AND. IDFITB(NNH).EQ.IDB)) THEN
                  IF(NAX.EQ.1) THEN
                      IF(NMODE.EQ.1 .AND. IXEXCL(NNH).LT.10) THEN
                          IXEXCL(NNH) = IXEXCL(NNH) + 1
                          XLEXCL(IXEXCL(NNH),NNH) = XFLO
                          XHEXCL(IXEXCL(NNH),NNH) = XFHI
                          QQCHGE = .TRUE.
                      ELSEIF(NMODE.EQ.2 .AND. IXINCL(NNH).LT.10) THEN
                          IXINCL(NNH) = IXINCL(NNH) + 1
                          XLINCL(IXINCL(NNH),NNH) = XFLO
                          XHINCL(IXINCL(NNH),NNH) = XFHI
                          QQCHGE = .TRUE.
                      ELSE
                          LENF = LENOCC(TFNAM(NAX,NNH))
                          WRITE(LUN,13500) IDA,IDB
     1                     ,TFNAM(NAX,NNH)(1:LENF),TTAG
                          GOTO 9000
                      ENDIF
                  ELSE IF(NAX.EQ.2) THEN
                      IF(NMODE.EQ.1 .AND. IYEXCL(NNH).LT.10) THEN
                          IYEXCL(NNH) = IYEXCL(NNH) + 1
                          YLEXCL(IYEXCL(NNH),NNH) = XFLO
                          YHEXCL(IYEXCL(NNH),NNH) = XFHI
                          QQCHGE = .TRUE.
                      ELSEIF(NMODE.EQ.2 .AND. IYINCL(NNH).LT.10) THEN
                          IYINCL(NNH) = IYINCL(NNH) + 1
                          YLINCL(IYINCL(NNH),NNH) = XFLO
                          YHINCL(IYINCL(NNH),NNH) = XFHI
                          QQCHGE = .TRUE.
                      ELSE
                          LENF = LENOCC(TFNAM(NAX,NNH))
                          WRITE(TXTERR,13500) IDA,IDB
     1                     ,TFNAM(NAX,NNH)(1:LENF),TTAG
                          CALL MN_ERR('M_EXCL',TXTERR)
                          GOTO 9000
                      ENDIF
                  ENDIF
13500             FORMAT('Plot',I7,I4,2X,A,' axis.'
     1              ,'  Too many ',A,'s. Only 10 allowed')
              ENDIF
3500      CONTINUE
          IF(.NOT.QEXIT) GOTO 3000
      ELSE
          CALL MN_ERR('M_EXCL','Unknown mode for ' // TTAG // 's')
      ENDIF
C
9000  CONTINUE
C
      END
