      SUBROUTINE M_ACMS(NF,IDELIM,CPAR,DCPAR,CPARLO,CPARHI,IERR)
C
C------------------------------------------------------------------------------
C     Routine to add a new COMIS function
C------------------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mnfun.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER NF,IDELIM,IERR
      REAL CPAR(*),DCPAR(*),CPARLO(*),CPARHI(*)
      CHARACTER*10 TCPAR(20)
C
      CHARACTER*255 TXT1,TXT2,CONCAT,TFILE
      CHARACTER*80  TITLE,TNAME
      LOGICAL QNEW
C
      INTEGER MRECO,MREC1,MREC2
      PARAMETER (MREC1 = 18)
      PARAMETER (MREC2 = 11)
      PARAMETER (MRECO =  MREC1 + MREC2)
      CHARACTER*72 TXTCM1(MREC1),TXTCM2(MREC2),TXTCMI(MRECO)
      EQUIVALENCE(TXTCMI( 1),TXTCM1(1))
      EQUIVALENCE(TXTCMI(MREC1+1),TXTCM2(1))
      DATA TXTCM1/
     +  '      FUNCTION XMNCMI(XX,YY,NP,DPAR,NUSER,WFERR)'
     + ,'C'
     + ,'C     Framework for a COMIS defined function'
     + ,'C     XX     is first variable'
     + ,'C     YY     is the second variable'
     + ,'C     NP     is number of parameters'
     + ,'C     DPAR   are the parameters in DOUBLE PRECISION'
     + ,'C     NUSER  is the user function number'
     + ,'C     WFERR  is the error on the function (0 in most cases)'
     + ,'C'
     + ,'      REAL          XMINNM,XMAXNM,XBINNM,YMINNM,YMAXNM,YBINNM'
     + ,'      COMMON/MNUSR/ XMINNM,XMAXNM,XBINNM,YMINNM,YMAXNM,YBINNM'
     + ,'      LOGICAL QDEBUG'
     + ,'      INTEGER NDEBUG'
     + ,'      COMMON/MNDBG/ QDEBUG,NDEBUG'
     + ,'C     Mn_Fit registers - Do not overwrite this common block'
     + ,'      REAL REGIS'
     + ,'      COMMON/MNREGI/REGIS(0:500)'
     + /
      DATA TXTCM2/
     +  'C'
     + ,'      DOUBLE PRECISION XMNCMI'
     + ,'      REAL XX,YY'
     + ,'      INTEGER NP,NUSER'
     + ,'      DOUBLE PRECISION DPAR(20),WFERR,WXX,WYY'
     + ,'C'
     + ,'      WXX = DBLE(XX)'
     + ,'      WYY = DBLE(YY)'
     + ,'      XMNCMI = 0.0D0'
     + ,'C'
     + ,'      END'
     + /
C
      IERR = 0
C
      TXT1 = ' '
      CALL WAITYQ('Give COMIS function filename: ')
      NCHAR = ISLTYQ(.TRUE.,IDELIM,TXT1)
      IF(NCHAR.LE.0 .OR. TXT1.EQ.' ') GOTO 9000
      NCHAR = MNLLEN(TXT1)
      TFILE = TXT1(1:NCHAR)
*
*     Convert any environment variables etc. and add the working directory
*
      call m_pfil(0,tfile,ierr)
      if(ierr.ne.0) goto 9000
C
C     SEE IF THE COMIS FUNCTION NUMBER WAS SPECIFIED
C
      XFXPAR(1,NF) = 0.0
      nfuser = 0
      IF(IDELIM.EQ.0) THEN
          NFUSER = IVLTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NFUSER,IDELIM,IERR)
          IF(IERR.NE.0) THEN
              CALL MN_ERR('M_ACMS'
     +         ,'Error specifying COMIS function number')
              GOTO 9000
          ENDIF
C
          XFXPAR(1,NF) = FLOAT(NFUSER)
      ENDIF
C
C     SEE IF THE FILE EXISTS AND IF NOT CREATE IT AND PUT IN THE EXAMPLE
C
      QNEW = .FALSE.
      TNAME = TFILE
      CALL MN_FIL(52,LUNTMP,TNAME,IDELIM,JERR)
      IF(JERR.NE.0) THEN
          QNEW = .TRUE.
          CALL CLEO_GETLUN(LUNO,'M_ACMS')
          TNAME = TFILE
          CALL MN_FIL(-43,LUNO,TNAME,IDELIM,JERR)
          IF(JERR.NE.0) THEN
              IERR = JERR
              GOTO 9000
          ENDIF
          DO 5200 I=1,MRECO
              LENT = LENOCC(TXTCMI(I))
              WRITE(LUNO,'(A)',ERR=5250) TXTCMI(I)(1:LENT)
5200      CONTINUE
5250      CONTINUE
          CLOSE(UNIT=LUNO)
          CALL CLEO_FRELUN(LUNO,'M_ACMS')
      ELSE
          CLOSE(UNIT=LUNTMP)
      ENDIF
*icb      TFILE = TNAME
C
C     EDIT THE FILE WITH THE COMIS FUNCTION
C
      IF(.NOT.QNEW) THEN
          CALL WAITYQ('Edit the COMIS function file [Y/N]: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
      ENDIF
      IF(QNEW .OR. MOD(KCMD,2).EQ.1) THEN
          CALL QUOTYQ(TFILE)
          TXT1 = 'EDIT'
          CALL MN_SPW(TXT1,IDELIM)
      ENDIF
C
C     COMPILE THE COMIS FUNCTION
C     GET THE FILE NAME AND FUNCTION NAME AND ADDRESS FOR THE
C     FUNCTION
C
      CALL M_FCMS(0,TFILE,TFILF(NF),TNAMF(NF),IADRF(NF),IERR)
      IF(IERR.NE.0) GOTO 9000
C
      TXT1 = CONCAT(TUSEF(NF),TNAMF(NF))
      TUSEF(NF) = TXT1
C
      IF(NFUSER.NE.0) THEN
          WRITE(TXT1,'(I4)') NFUSER
          TXT2 = CONCAT(TUSEF(NF),TXT1)
          TUSEF(NF) = TXT2
      ENDIF
C
      TITLE = TUSEF(NF)
      CALL M_USRI(NFUSER,NCPAR,TITLE,TCPAR
     1 ,CPAR,DCPAR,CPARLO,CPARHI)
      IF(NCPAR.GT.0 .AND. NCPAR.LE.20) THEN
          IPARF(NF) = NCPAR
          TUSEF(NF) = TITLE
          DO 5300 II=1,NCPAR
              TPARF(II,NF)  = TCPAR(II)
              FPAR(II,NF)   = CPAR(II)
              DFPAR(II,NF)  = DCPAR(II)
              FPARLO(II,NF) = CPARLO(II)
              FPARHI(II,NF) = CPARHI(II)
5300      CONTINUE
C
      ELSE
          WRITE(TXTERR,'(''Error in number of''
     1     ,'' parameters specified for the COMIS function'',I3)')
     +     NCPAR
          CALL M_EMSG('M_ACMS',TXTERR)
          CALL MN_ERR('M_ACMS','It must be between 1 and 20')
          IERR = 1
          GOTO 9000
      ENDIF
C
C     COMIS function is OK. Set the error flag to 0
C
      IERR = 0
C
9000  CONTINUE
      END
