array set config {
lib_dir .
version {1.5.1}
}

proc init {} {
    global auto_path argv argv0 config env
    
    package require Tcl 8.4

    foreach opt $argv {
	switch -exact -- $opt {
	    -h - -help - --help {
		puts "Usage: $argv0 \[INTERFACE\] OPTION..."
		puts ""
		puts "Interfaces:"
		puts "tk       - GUI  (requires Tk)"
		puts "gnome    - GUI  (requires tcl-gtk and Gnome)"
		puts "console  - text (requires ANSI terminal and unix)"
		puts "readline - text (requires tclreadline)"
		puts "text     - text (works on any terminal)"
		puts ""
		puts "INTERFACE defaults to tk."
		puts ""
		puts "Options:"
		puts "-h --help          print this message and exit"
		puts "-v --version       print the version and exit"
		puts "-e --eval SCRIPT   start mmucl and eval SCRIPT"
		puts ""
		puts "Enviroment variable TCLLIBPATH can be used to specify"
		puts "where Mmucl looks for Tcl extensions."
		puts ""
		puts "Report bugs to msp@users.sourceforge.net."
		
		exit 0
	    } -v - --version {
		puts "Mmucl $config(version)"
		exit 0
	    }
	}
    }
    
    set interfaces [list tk readline console text gnome]
    set interface [string tolower [lindex $argv 0]]
    
    if {[string match -* $interface] || [string equal $interface ""]} {
	set interface tk
    } else {
	set argv [lreplace $argv 0 0]
    }

    if {[lsearch -exact $interfaces $interface] == -1} {
	puts stderr "no such interface: $interface"
	puts stderr "for more info: $argv0 --help"
	exit 1
    }

    if {[info exists env(HOME)]} {
	set config(rc_dir) [file join $env(HOME) .mmucl2]
    } else {
	set config(rc_dir) [file join [pwd] .mmucl2]
    }

    foreach path {/usr/lib /usr/local/lib} {
        if {[lsearch $auto_path $path] == -1} {
            lappend auto_path $path
        }
    }

    set config(interface) $interface
    uplevel #0 [list source [file join $config(lib_dir) lib mmucl.tcl]]
    uplevel #0 [list source [file join $config(lib_dir) \
	interface $interface.tcl]]

    mmucl::init

    rename init ""
    return
}

init
vwait forever
