//
// =================================================================
//
//  MacroMolecular Data Base (MMDB)
//
//  File  m2.cpp
//
// =================================================================
//

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __MMDB_Manager__
#include "mmdb_manager.h"
#endif

#ifndef  __MMDB_Graph__
#include "mmdb_graph.h"
#endif

#ifndef  __MMDB_SBase__
#include "mmdb_sbase.h"
#endif


int main ( int argc, char ** argv, char ** env )  {
PCFile        f;
PCSBase       SBase;
PCSBStructure SBS;
PCSBAtom      Atom;
PCSBBond      Bond;
PCSBAngle     Angle;
char          S[100];
int           RC,i,l;


  //  1.  Make routine initializations, which must always be done
  //      before working with MMDB
  InitMatType();

  SBase  = new CSBase ();
  RC = SBase->LoadIndex("");
  if (RC!=SBASE_Ok)  {
    printf ( " ****** *.sbase files not dound.\n" );
    delete SBase;
    return 1;
  }

  l = SBase->GetNofStructures();
  f = SBase->GetStructFile();
  for (i=0;i<l;i++)  {
    SBS = SBase->GetStructure ( i,f );
    RC = 0;
    if (SBS)  {
      if (SBS->nAngles>0)  break;
    }
  }
  if (f)  delete f;

  if (SBS)  {
    printf ( "\n Compound: %s\n"
             " ~~~~~~~~~~~~~\n\n",SBS->compoundID );
    if (SBS->Formula)
      printf ( " Formula:\n%s\n",SBS->Formula );
    if (SBS->Name)
      printf ( " Name:\n%s\n",SBS->Name );
    if (SBS->Synonym)
      printf ( " Synonym:\n%s\n",SBS->Synonym );
    if (SBS->Charge)
      printf ( " Charge:\n%s\n",SBS->Charge );

    if (SBS->xyz_source=='N')
      printf ( "\n\n XYZ coordinate data unavailable\n" );
    else  {
      printf ( "\n\n XYZ coordinate data source: " );
      switch (SBS->xyz_source)  {
        case 'A' : printf ( "ACD Labs\n" );  break;
        case 'R' : printf ( "RCSB\n" );      break;
        case 'P' : printf ( "PDB\n" );       break;
        default  : printf ( "unknown, report as a bug\n" );
      }
    }

    printf ( "\n"
 "Atom|PDB |Chem| Energy |Chi| Lv|    X     |    Y     |     Z\n"
 " No |Name|elem|  Type  |   |   |          |          |\n"
 "====|====|====|========|===|===|==========|==========|============\n" );
    for (i=0;i<SBS->nAtoms;i++)  {
      Atom = SBS->Atom[i];
      printf ( " %3i|%4s| %2s |%8s| %1c | %1c ",i+1,Atom->pdb_name,
               Atom->element,Atom->energyType,Atom->chirality,
               Atom->leaving );
      if (Atom->x>-MaxReal)
            printf ( "|%10.3f|%10.3f|%10.3f\n",Atom->x,Atom->y,Atom->z );
      else  printf ( "|----------|----------|----------\n" );
    }

    printf ( "\n"
 "Bond|Atom|Atom|Bond |  Length  | Length ESD\n"
 " No | 1  | 2  |order|          |\n"
 "====|=========|=====|==========|=============\n" );
    for (i=0;i<SBS->nBonds;i++)  {
      Bond = SBS->Bond[i];
      switch (Bond->order)  {
        case BOND_SINGLE   : strcpy ( S,"sing" );  break;
        case BOND_DOUBLE   : strcpy ( S,"doub" );  break;
        case BOND_AROMATIC : strcpy ( S,"arom" );  break;
        case BOND_TRIPLE   : strcpy ( S,"trip" );  break;
        default            : strcpy ( S,"unkn" );
      }
      printf ( "%4i| %3i  %3i|%5s|%10.3f|%10.3f\n",
               i+1,Bond->atom1,Bond->atom2,S,
	       Bond->length,Bond->length_esd );
    }

    if (SBS->nAngles>0)  {
    printf ( "\n"
 "Angle|Atom|Atom|Atom|  Angle   |  Angle ESD\n"
 "  No | 1  | 2  | 3  |          |\n"
 "=====|==============|==========|=============\n" );
      for (i=0;i<SBS->nAngles;i++)  {
        Angle = SBS->Angle[i];
        printf ( " %4i| %2i   %2i   %2i |%10.3f|%10.3f\n",
                 i+1,Angle->atom1,Angle->atom2,Angle->atom3,
	         Angle->angle,Angle->angle_esd );
      }
    }

    if (SBS->nLeavingAtoms>0)  {
      printf ( "\n Leaving atoms:\n" );
      for (i=0;i<SBS->nLeavingAtoms;i++)
        printf ( " %2i.  %3i -> %3i\n",i+1,SBS->leavingAtom[i],
                 SBS->bondedAtom[i] );
    }

  }

  delete SBase;

  return 0;

}



