/*
     This code is distributed under the terms and conditions of the
     CCP4 licence agreement as `Part ii)' software.  See the conditions
     in the CCP4 manual for a copyright statement.
*/

/*   ccplib.c

     Header file for CCP4 library clones
     Peter Briggs CCP4 April 2001

     NB. These are placeholder functions to be replace by proper
     functions in the future.
*/

/*------------------------------------------------------------------*/

/* Macro definitions */

/*------------------------------------------------------------------*/


#ifndef __CCPLib__
#define __CCPLib__


#ifdef  __CPlusPlus
#define externC extern "C"
#else
#define externC
#endif



/* MAXLINE = maximum number of characters in lines read
   from environ.def and default.def files (ccp4fyp)
   MAXTOKS = maximum number of tokens in lines read from
   environ.def and default.def files (ccp4fyp)
   MAXNAMES = maximum number of logical names that can be
   read and stored from environ.def (ccp4fyp)
*/

/* NB these names should probably be made more specific
   e.g. prepended with something like "CCP4_"
*/
#define MAXLINE  200
#define MAXTOKS  3
#define MAXNAMES 150
#define MODULO   100000.0

/*------------------------------------------------------------------*/

/* Structures and typedefs */

/*------------------------------------------------------------------*/

/* <None declared> */

/*------------------------------------------------------------------*/

/* Function Prototypes */

/*------------------------------------------------------------------*/

externC int    ccperror(int ierr, const char* message);

externC int    ccp4printf(int level, char *format, ...);

externC int    ccp4fyp(int argc, char *argv[]);

externC void * p_ccp4malloc(size_t size, char *message);

externC int    ccp4setenv(char *logical_name, char* value, char **envname,
	       char **envtype, char **envext, int ienv, int no_overwrt);

externC float  ccp4modulo(float x, int y);

externC int    ccpexists(char *filename);

externC int    ccpputenv(char *logical_name, char *file_name);
/*
     This code is distributed under the terms and conditions of the
     CCP4 licence agreement as `Part ii)' software.  See the conditions
     in the CCP4 manual for a copyright statement.
*/

/*   ccp4program.h

     Header file for functions accessing CCP4 program info
*/

/*------------------------------------------------------------------*/

/* Function Prototypes */

/*------------------------------------------------------------------*/

externC char * ccp4ProgramName(char *progname);

externC int    ccp4VerbosityLevel(int level);

externC void   ccp4rcs(char *progname);

externC void * ccp4realloc(void *ptr, size_t size);


#endif
