//  $Id: machine_.cpp,v 1.3 2004/01/28 17:22:32 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    23.10.00   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :   machine_  <implementation>
//       ~~~~~~~~~
//  **** Functions : GetMachineID   - returns ID code for the machine
//       ~~~~~~~~~~~ GetMachineName - returns name of a machine
//
//  E. Krissinel 2000-2002
//
//  =================================================================
//

#ifndef  __Machine__
#include "machine_.h"
#endif


#ifdef CALL_LIKE_SUN

int GetMachineID()  {
int k = CALL_LIKE_SUN;
  switch (k)  {
    case 1  : return MACHINE_ALLIANT;
    case 2  : return MACHINE_CONVEX;
    case 3  : return MACHINE_ESV;
    case 4  : return MACHINE_SGI;
    case 5  : return MACHINE_SOLBOURNE;
    case 6  : return MACHINE_SOLARIS;
    case 7  : return MACHINE_ALPHA;
    case 8  : return MACHINE_F2C_G77;
    case 9  : return MACHINE_LINUX;
    default : return MACHINE_UNKNOWN;
  }
}

#elif defined(CALL_LIKE_HPUX)

int GetMachineID()  {
int k = CALL_LIKE_HPUX;
  switch (k)  {
    case 1  : return MACHINE_RS6000;
    case 2  : return MACHINE_HP9000;
    default : return MACHINE_UNKNOWN;
  }
}

#elif defined(CALL_LIKE_STARDENT)

int GetMachineID()  {
int k = CALL_LIKE_STARDENT;
  switch (k)  {
    case 1  : return MACHINE_ARDENT;
    case 2  : return MACHINE_TITAN;
    case 3  : return MACHINE_STARDENT;
    default : return MACHINE_UNKNOWN;
  }
}

#elif defined(CALL_LIKE_VMS)

int GetMachineID()  {
  return MACHINE_VMS;
}

#elif defined(CALL_LIKE_MVS)

int GetMachineID()  {
  return MACHINE_MVS;
}

#else

int GetMachineID()  {
  return MACHINE_UNKNOWN;
}

#endif

static pstr MCH_SGI       = pstr("Silicon Graphics");
static pstr MCH_RS6000    = pstr("IBM RS/6000");
static pstr MCH_ALLIANT   = pstr("Alliant");
static pstr MCH_ARDENT    = pstr("Ardent");
static pstr MCH_TITAN     = pstr("Titan");
static pstr MCH_STARDENT  = pstr("Stardent");
static pstr MCH_CONVEX    = pstr("Convex");
static pstr MCH_ESV       = pstr("Evans or Sutherland");
static pstr MCH_HP9000    = pstr("Hewlett Packard 9000");
static pstr MCH_SOLBOURNE = pstr("Solbourne");
static pstr MCH_SOLARIS   = pstr("Solaris");
static pstr MCH_ALPHA     = pstr("DEC Alpha");
static pstr MCH_VMS       = pstr("A VMS machine");
static pstr MCH_MVS       = pstr("MS Windows");
static pstr MCH_F2C_G77   = pstr("SUN compatible");
static pstr MCH_LINUX     = pstr("Linux");

pstr GetMachineName ( int MachineID )  {
  switch (MachineID)  {
    case MACHINE_SGI       : return MCH_SGI;
    case MACHINE_RS6000    : return MCH_RS6000;
    case MACHINE_ALLIANT   : return MCH_ALLIANT;
    case MACHINE_ARDENT    : return MCH_ARDENT;
    case MACHINE_TITAN     : return MCH_TITAN;
    case MACHINE_STARDENT  : return MCH_STARDENT;
    case MACHINE_CONVEX    : return MCH_CONVEX;
    case MACHINE_ESV       : return MCH_ESV;
    case MACHINE_HP9000    : return MCH_HP9000;
    case MACHINE_SOLBOURNE : return MCH_SOLBOURNE;
    case MACHINE_SOLARIS   : return MCH_SOLARIS;
    case MACHINE_ALPHA     : return MCH_ALPHA;
    case MACHINE_VMS       : return MCH_VMS;
    case MACHINE_MVS       : return MCH_MVS;
    case MACHINE_F2C_G77   : return MCH_F2C_G77;
    case MACHINE_LINUX     : return MCH_LINUX;
    default                :
    case MACHINE_UNKNOWN   : return pstr("Unidentified machine");
  }
}

pstr GetMachineName()  {
  return GetMachineName ( GetMachineID() );
}

