# DEFAULT LIBS
# ------------

import mspy

presets = {
    'operator':{},
    'processing':{
        'ESI-ICR Peptides':{
            'crop':{
                'lowMass': 200,
                'highMass': 4000,
            },
            'baseline':{
                'segments': 15,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'SG',
                'windowSize': 0.05,
                'cycles': 1,
            },
            'peakpicking':{
                'snThreshold': 4,
                'absIntThreshold': 0,
                'relIntThreshold': 0.001,
                'adaptiveNoise': 0,
                'pickingHeight': 0.9,
                'smoothing': 0,
                'deisotoping': 1,
                'monoisotopic': 1,
                'removeShoulders': 1,
            },
            'deisotoping':{
                'maxCharge': 5,
                'massTolerance': 0.02,
                'intTolerance': 0.5,
                'removeIsotopes': 1,
                'removeUnknown': 1,
            },
        },
        'MALDI-TOF Peptides':{
            'crop':{
                'lowMass': 750,
                'highMass': 4000,
            },
            'baseline':{
                'segments': 15,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'SG',
                'windowSize': 0.2,
                'cycles': 2,
            },
            'peakpicking':{
                'snThreshold': 3.5,
                'absIntThreshold': 0,
                'relIntThreshold': 0.005,
                'adaptiveNoise': 0,
                'pickingHeight': 0.75,
                'smoothing': 1,
                'deisotoping': 1,
                'monoisotopic': 1,
                'removeShoulders': 0,
            },
            'deisotoping':{
                'maxCharge': 1,
                'massTolerance': 0.15,
                'intTolerance': 0.5,
                'removeIsotopes': 1,
                'removeUnknown': 1,
            },
        },
        'MALDI-TOF Proteins 5-20 kDa':{
            'crop':{
                'lowMass': 5000,
                'highMass': 20000,
            },
            'baseline':{
                'segments': 20,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'MA',
                'windowSize': 5,
                'cycles': 2,
            },
            'peakpicking':{
                'snThreshold': 2,
                'absIntThreshold': 0,
                'relIntThreshold': 0.01,
                'adaptiveNoise': 1,
                'pickingHeight': 0.75,
                'smoothing': 1,
                'deisotoping': 0,
                'monoisotopic': 0,
                'removeShoulders': 0,
            },
            'deisotoping':{
                'maxCharge': 1,
                'massTolerance': 0.1,
                'intTolerance': 0.5,
                'removeIsotopes': 0,
                'removeUnknown': 0,
            },
        },
        'MALDI-TOF PSD':{
            'crop':{
                'lowMass': 0,
                'highMass': 4000,
            },
            'baseline':{
                'segments': 100,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'SG',
                'windowSize': 0.5,
                'cycles': 2,
            },
            'peakpicking':{
                'snThreshold': 3,
                'absIntThreshold': 0,
                'relIntThreshold': 0.005,
                'adaptiveNoise': 1,
                'pickingHeight': 0.75,
                'smoothing': 1,
                'deisotoping': 1,
                'monoisotopic': 0,
                'removeShoulders': 0,
            },
            'deisotoping':{
                'maxCharge': 1,
                'massTolerance': 0.2,
                'intTolerance': 0.5,
                'removeIsotopes': 1,
                'removeUnknown': 0,
            },
        },
        'MALDI-ICR Peptides':{
            'crop':{
                'lowMass': 750,
                'highMass': 4000,
            },
            'baseline':{
                'segments': 15,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'SG',
                'windowSize': 0.05,
                'cycles': 1,
            },
            'peakpicking':{
                'snThreshold': 4,
                'absIntThreshold': 0,
                'relIntThreshold': 0.001,
                'adaptiveNoise': 0,
                'pickingHeight': 0.9,
                'smoothing': 0,
                'deisotoping': 1,
                'monoisotopic': 1,
                'removeShoulders': 1,
            },
            'deisotoping':{
                'maxCharge': 1,
                'massTolerance': 0.02,
                'intTolerance': 0.5,
                'removeIsotopes': 1,
                'removeUnknown': 1,
            },
        },
    },
    'modifications':{
        'Carbamidomethyl (C) Oxidation (MW)':[
            ['Carbamidomethyl', 'C', 'f'],
            ['Oxidation', 'M', 'v'],
            ['Oxidation', 'W', 'v'],
        ],
        'Oxidation (MW)':[
            ['Oxidation', 'M', 'v'],
            ['Oxidation', 'W', 'v'],
        ],
    },
}

mascot = {
    'Matrix Science':{
            'host': 'www.matrixscience.com',
            'path': '/',
            'search': 'cgi/nph-mascot.exe',
            'results': 'cgi/master_results.pl',
            'export': 'cgi/export_dat_2.pl',
            'params': 'cgi/get_params.pl',
    },
}

references = {
    'PepMix Bruker - MALDI Pos Mo':[
        ('Bradykinin (1-7) [M+H]+', 757.399150),
        ('Angiotensin II [M+H]+', 1046.541792),
        ('Angiotensin I [M+H]+', 1296.684768),
        ('Substance P [M+H]+', 1347.735423),
        ('Bombesin [M+H]+', 1619.822341),
        ('ACTH clip (1-17) [M+H]+', 2093.086160),
        ('ACTH clip (18-39) [M+H]+', 2465.198332),
        ('Somatostatin 28 [M+H]+', 3147.470975),
    ],
    'PepMix Bruker - MALDI Neg Mo':[
        ('Angiotensin II [M-H]-', 1044.527247),
        ('Angiotensin I [M-H]-', 1294.670247),
        ('Substance P [M-H]-', 1345.720847),
        ('Bombesin [M-H]-', 1617.807747),
        ('ACTH clip (1-17) [M-H]-', 2091.071647),
        ('ACTH clip (18-39) [M-H]-', 2463.183747),
        ('Somatostatin 28 [M-H]-', 3145.456447),
    ],
    'PepMix Bruker PAC - MALDI Pos Mo':[
        ('Bradykinin (1-7) [M+H]+', 757.399160),
        ('Angiotensin III [M+H]+', 931.514849),
        ('Angiotensin II [M+H]+', 1046.541792),
        ('Angiotensin I [M+H]+', 1296.684768),
        ('Substance P [M+H]+', 1347.735423),
        ('Bombesin [M+H]+', 1619.822341),
        ('Neurotensin [M+H]+', 1672.917000),
        ('Renin Substrate [M+H]+', 1758.932610),
        ('ACTH clip (1-17) [M+H]+', 2093.086160),
        ('ACTH clip (18-39) [M+H]+', 2465.198332),
        ('ACTH clip (1-24) [M+H]+', 2932.587870),
        ('Somatostatin 28 [M+H]+', 3147.470975),
        ('ACTH clip (7-38) [M+H]+', 3657.928900),
    ],
    'ProtMix I Bruker - MALDI Pos Av':[
        ('Insulin [M+H]+', 5735),
        ('Cytochrome C [M+2H]2+', 6181),
        ('Myoglobin [M+2H]2+', 8477),
        ('Ubiquitin I [M+H]+', 8566),
        ('Cytochrom C [M+H]+', 12361),
        ('Myoglobin [M+H]+', 16953),
    ],
    'ProtMix I Bruker - MALDI Neg Av':[
        ('Insulin [M-H]-', 5733),
        ('Cytochrome C [M-2H]2-', 6179),
        ('Myoglobin [M-2H]2-', 8475),
        ('Ubiquitin I [M-H]-', 8564),
        ('Cytochrom C [M-H]-', 12359),
        ('Myoglobin [M-H]-', 16951),
    ],
    'ProtMix II Bruker - MALDI Pos Av':[
        ('Trypsinogen [M+H]+', 23982),
        ('Protein A [M+2H]2+', 22306),
        ('Albumin Bovine [M+2H]2+', 33216),
        ('Protein A [M+H]+', 44613),
        ('Albumin Bovine [M+H]+', 66431),
    ],
    'ProtMix II Bruker - MALDI Neg Av':[
        ('Trypsinogen [M+H]+', 23980),
        ('Protein A [M+2H]2+', 22304),
        ('Albumin Bovine [M+2H]2+', 33214),
        ('Protein A [M+H]+', 44611),
        ('Albumin Bovine [M+H]+', 66429),
    ],
    'Trypsin Promega (Porcine) - MALDI Pos Mo':[
        ('Trypsin (108-115) [M+H]+', 842.5094),
        ('Trypsin (209-216) [M+H]+', 906.5044),
        ('Trypsin (1-8) [M+H]+', 952.3894),
        ('Trypsin (148-157) [M+H]+', 1006.4874),
        ('Trypsin (98-107) [M+H]+', 1045.5637),
        ('Trypsin (134-147) [M+H]+', 1469.7305),
        ('Trypsin (58-72) [M+H]+', 1713.8084),
        ('Trypsin (217-231) [M+H]+', 1736.8425),
        ('Trypsin (116-133) [M+H]+', 1768.7993),
        ('Trypsin (62-77) [M+H]+', 1774.8975),
        ('Trypsin (58-76) [M+H]+', 2083.0096),
        ('Trypsin (158-178) [M+H]+', 2158.0307),
        ('Trypsin (58-77) [M+H]+', 2211.1040),
        ('Trypsin (78-97) [M+H]+', 2283.1802),
        ('Trypsin (179-208) [M+H]+', 3013.3237),
    ],
    'Trypsin Roche (Bovine) - MALDI Pos Mo':[
        ('Trypsin (112-119) [M+H]+', 805.4163),
        ('Trypsin (160-169) [M+H]+', 1020.503),
        ('Trypsin (229-237) [M+H]+', 1111.5605),
        ('Trypsin (207-220) [M+H]+', 1433.7206),
        ('Trypsin (70-89) [M+H]+', 2163.0564),
        ('Trypsin (90-109) [M+H]+', 2273.1595),
    ],
    'Trypsin Roche (Porcine) - MALDI Pos Mo':[
        ('Trypsin (108-115) [M+H]+', 842.5094),
        ('Trypsin (134-147) [M+H]+', 1469.7305),
        ('Trypsin (58-74) [M+H]+', 1940.9354),
        ('Trypsin (116-133) [M+H]+', 1768.7993),
        ('Trypsin (98-107) [M+H]+', 1045.5637),
        ('Trypsin (58-77) [M+H]+', 2211.104),
        ('Trypsin (148-157) [M+H]+', 1006.4874),
    ],
    'Keratin - MALDI Pos Mo':[
        ('Keratin 10 [M+H]+', 1165.5853),
        ('Keratin 1/II [M+H]+', 1179.6010),
        ('Keratin 1/II [M+H]+', 1300.5302),
        ('Keratin 1/II [M+H]+', 1716.8517),
        ('Keratin 1/II [M+H]+', 1993.9767),
        ('Keratin 1 [M+H]+', 2383.9520),
        ('Keratin 10 [M+H]+', 2825.4056),
    ],
    'HCCA Clusters - MALDI Pos Mo':[
        ('HCCA [M+H-H2O]+', 172.039304),
        ('HCCA [M+H]+', 190.049869),
        ('HCCA [M+Na-H2O]+', 194.021249),
        ('HCCA [M+Na]+', 212.031814),
        ('HCCA [M+K-H2O]+', 209.995186),
        ('HCCA [M+K]+', 228.005751),
        ('HCCA [2M+H-H2O]+', 361.081897),
        ('HCCA [2M+H]+', 379.092462),
        ('HCCA [2M+Na-H2O]+', 383.063842),
        ('HCCA [2M+Na]+', 401.074407),
        ('HCCA [2M+K-H2O]+', 399.037779),
        ('HCCA [2M+K]+', 417.048344),
        ('HCCA [2M+K+Na-H2O]+', 422.027),
        ('HCCA [3M+H-H2O]+', 550.12449),
        ('HCCA [3M+H]+', 568.135055),
        ('HCCA [3M+Na-H2O]+', 572.106435),
        ('HCCA [3M+Na]+', 590.117),
        ('HCCA [3M+K-H2O]+', 588.080372),
        ('HCCA [3M+K]+', 606.090937),
        ('HCCA [3M+K+Na-H2O]+', 611.069593),
        ('HCCA [4M+H-H2O]+', 739.167083),
        ('HCCA [4M+H]+', 757.177648),
        ('HCCA [4M+Na-H2O]+', 761.149028),
        ('HCCA [4M+Na]+', 779.159593),
        ('HCCA [4M+K-H2O]+', 777.122965),
        ('HCCA [4M+K]+', 795.13353),
        ('HCCA [4M+K+Na-H2O]+', 800.112186),
        ('HCCA [5M+H-H2O]+', 928.209676),
        ('HCCA [5M+H]+', 946.220241),
        ('HCCA [5M+Na-H2O]+', 950.191621),
        ('HCCA [5M+Na]+', 968.202186),
        ('HCCA [5M+K-H2O]+', 966.165558),
        ('HCCA [5M+K]+', 984.176123),
        ('HCCA [5M+K+Na-H2O]+', 989.154779),
        ('HCCA [6M+H-H2O]+', 1117.252269),
        ('HCCA [6M+H]+', 1135.262834),
        ('HCCA [6M+Na-H2O]+', 1139.234214),
        ('HCCA [6M+Na]+', 1157.244779),
        ('HCCA [6M+K-H2O]+', 1155.208151),
        ('HCCA [6M+K]+', 1173.218716),
        ('HCCA [6M+K+Na-H2O]+', 1178.197372),
        ('HCCA [7M+H-H2O]+', 1306.294862),
        ('HCCA [7M+H]+', 1324.305427),
        ('HCCA [7M+Na-H2O]+', 1328.276807),
        ('HCCA [7M+Na]+', 1346.287372),
        ('HCCA [7M+K-H2O]+', 1344.250744),
        ('HCCA [7M+K]+', 1362.261309),
        ('HCCA [7M+K+Na-H2O]+', 1367.239965),
    ],
    'DHB Clusters - MALDI Pos Mo':[
        ('DHB [M+H-H2O]+', 137.02332),
        ('DHB [M+H]+', 155.033885),
        ('DHB [M+Na-H2O]+', 159.005265),
        ('DHB [M+Na]+', 177.01583),
        ('DHB [M+K-H2O]+', 174.979202),
        ('DHB [M+K]+', 192.989767),
        ('DHB [2M+H-2H2O]+', 273.039364),
        ('DHB [2M+H-H2O]+', 291.049929),
        ('DHB [2M+H]+', 309.060494),
        ('DHB [2M+Na-2H2O]+', 295.021309),
        ('DHB [2M+Na-H2O]+', 313.031874),
        ('DHB [2M+Na]+', 331.042439),
        ('DHB [2M+K-H2O]+', 329.005811),
        ('DHB [2M+K]+', 347.016376),
        ('DHB [2M+K+Na-H2O]+', 351.995032),
        ('DHB [3M+H-3H2O]+', 409.055408),
        ('DHB [3M+H-H2O]+', 445.076538),
        ('DHB [3M+H]+', 463.087103),
        ('DHB [3M+Na-3H2O]+', 431.037353),
        ('DHB [3M+Na-H2O]+', 467.058483),
        ('DHB [3M+Na]+', 485.069048),
        ('DHB [3M+K-H2O]+', 483.03242),
        ('DHB [3M+K]+', 501.042985),
        ('DHB [3M+K+Na-H2O]+', 506.021641),
        ('DHB [4M+H-4H2O]+', 545.071452),
        ('DHB [4M+H-H2O]+', 599.103147),
        ('DHB [4M+H]+', 617.113712),
        ('DHB [4M+Na-4H2O]+', 567.053397),
        ('DHB [4M+Na-H2O]+', 621.085092),
        ('DHB [4M+Na]+', 639.095657),
        ('DHB [4M+K-H2O]+', 637.059029),
        ('DHB [4M+K]+', 655.069594),
        ('DHB [4M+K+Na-H2O]+', 660.04825),
        ('DHB [5M+H-5H2O]+', 681.087496),
        ('DHB [5M+H-H2O]+', 753.129756),
        ('DHB [5M+H]+', 771.140321),
        ('DHB [5M+Na-H2O]+', 775.111701),
        ('DHB [5M+Na]+', 793.122266),
        ('DHB [5M+K-H2O]+', 791.085638),
        ('DHB [5M+K]+', 809.096203),
        ('DHB [5M+K+Na-H2O]+', 814.074859),
        ('DHB [6M+H-6H2O]+', 817.103540),
        ('DHB [6M+H-H2O]+', 907.156365),
        ('DHB [6M+H]+', 925.16693),
        ('DHB [6M+Na-H2O]+', 929.13831),
        ('DHB [6M+Na]+', 947.148875),
        ('DHB [6M+K-H2O]+', 945.112247),
        ('DHB [6M+K]+', 963.122812),
        ('DHB [6M+K+Na-H2O]+', 968.101468),
        ('DHB [7M+H-7H2O]+', 953.119584),
        ('DHB [7M+H-H2O]+', 1061.182974),
        ('DHB [7M+H]+', 1079.193539),
        ('DHB [7M+Na-H2O]+', 1083.164919),
        ('DHB [7M+Na]+', 1101.175484),
        ('DHB [7M+K-H2O]+', 1099.138856),
        ('DHB [7M+K]+', 1117.149421),
        ('DHB [7M+K+Na-H2O]+', 1122.128077),
    ],
    'PEG - MALDI Pos':[
        ('C6H15O4 [M+H]+', 151.096485),
        ('C6H14O4 [M+Na]+', 173.078430),
        ('C8H19O5 [M+H]+', 195.122700),
        ('C8H18O5 [M+Na]+', 217.104645),
        ('C10H23O6 [M+H]+', 239.148915),
        ('C10H22O6 [M+Na]+', 261.130860),
        ('C12H27O7 [M+H]+', 283.175130),
        ('C12H26O7 [M+Na]+', 305.157074),
        ('C14H31O8 [M+H]+', 327.201344),
        ('C14H30O8 [M+Na]+', 349.183289),
        ('C16H35O9 [M+H]+', 371.227559),
        ('C16H34O9 [M+Na]+', 393.209504),
        ('C18H39O10 [M+H]+', 415.253774),
        ('C18H38O10 [M+Na]+', 437.235719),
        ('C20H43O11 [M+H]+', 459.279989),
        ('C20H42O11 [M+Na]+', 481.261933),
        ('C22H47O12 [M+H]+', 503.306203),
        ('C22H46O12 [M+Na]+', 525.288148),
        ('C24H51O13 [M+H]+', 547.332418),
        ('C24H50O13 [M+Na]+', 569.314363),
        ('C26H55O14 [M+H]+', 591.358633),
        ('C26H54O14 [M+Na]+', 613.340578),
        ('C28H59O15 [M+H]+', 635.384848),
        ('C28H58O15 [M+Na]+', 657.366792),
        ('C30H62O16 [M+Na]+', 701.393007),
        ('C32H66O17 [M+Na]+', 745.419222),
        ('C34H70O18 [M+Na]+', 789.445437),
        ('C36H74O19 [M+Na]+', 833.471651),
        ('C38H78O20 [M+Na]+', 877.497866),
        ('C40H82O21 [M+Na]+', 921.524081),
        ('C42H86O22 [M+Na]+', 965.550296),
        ('C44H90O23 [M+Na]+', 1009.576510),
        ('C46H94O24 [M+Na]+', 1053.602725),
        ('C48H98O25 [M+Na]+', 1097.628940),
        ('C50H102O26 [M+Na]+', 1141.655155),
        ('C52H106O27 [M+Na]+', 1185.681369),
        ('C54H110O28 [M+Na]+', 1229.707584),
        ('C56H114O29 [M+Na]+', 1273.733799),
        ('C58H118O30 [M+Na]+', 1317.760014),
        ('C60H122O31 [M+Na]+', 1361.786228),
        ('C62H126O32 [M+Na]+', 1405.812443),
        ('C64H130O33 [M+Na]+', 1449.838658),
        ('C66H134O34 [M+Na]+', 1493.864873),
        ('C68H138O35 [M+Na]+', 1537.891087),
        ('C70H142O36 [M+Na]+', 1581.917302),
        ('C72H146O37 [M+Na]+', 1625.943517),
        ('C74H150O38 [M+Na]+', 1669.969732),
        ('C76H154O39 [M+Na]+', 1713.995946),
        ('C78H158O40 [M+Na]+', 1758.022161),
        ('C80H162O41 [M+Na]+', 1802.048376),
        ('C82H166O42 [M+Na]+', 1846.074591),
        ('C84H170O43 [M+Na]+', 1890.100805),
        ('C86H174O44 [M+Na]+', 1934.127020),
        ('C88H178O45 [M+Na]+', 1978.153235),
        ('C90H182O46 [M+Na]+', 2022.179450),
        ('C92H186O47 [M+Na]+', 2066.205664),
        ('C94H190O48 [M+Na]+', 2110.231879),
        ('C96H194O49 [M+Na]+', 2154.258094),
        ('C98H198O50 [M+Na]+', 2198.284309),
        ('C100H2O2O51 [M+Na]+', 2242.310523),
        ('C104H210O53 [M+Na]+', 2330.362953),
        ('C108H218O55 [M+Na]+', 2418.415382),
        ('C112H226O57 [M+Na]+', 2506.467812),
        ('C116H234O59 [M+Na]+', 2594.520241),
        ('C120H242O61 [M+Na]+', 2682.572671),
        ('C124H250O63 [M+Na]+', 2770.652100),
        ('C128H258O65 [M+Na]+', 2858.677530),
        ('C132H266O67 [M+Na]+', 2946.729959),
        ('C136H274O69 [M+Na]+', 3034.782389),
        ('C140H282O71 [M+Na]+', 3122.834828),
    ],
}

compounds = {
    'Prenol Lipids [PR]': {
        "LMPR03070004 (Dolichol-20)": ["C100H164O", "Prenol Lipids [PR] with formula: C100H164O"],
        "LMPR0102110001 (beta-Dolabrin)": ["C10H10O2", "Prenol Lipids [PR] with formula: C10H10O2"],
        "LMPR0102030001": ["C10H11BrCl4", "Prenol Lipids [PR] with formula: C10H11BrCl4"],
        "LMPR0102090014 (p-Cymene)": ["C10H14", "Prenol Lipids [PR] with formula: C10H14"],
        "LMPR0102080001; LMPR0102090010 (Perillyl aldehyde); LMPR0102090017 (Carvacrol); LMPR0102090056 (piperitenone); LMPR0102090007 ((-)-Carvone); LMPR0102120049 ((+)-sabinone); LMPR0102090009 ((-)-Isopiperitenone); LMPR0102090020 (Menthofuran); LMPR0102090023 (Pinocarvone); LMPR0102090029 (Thymol); LMPR0102120023 (Myrtenal)": ["C10H14O", "Prenol Lipids [PR] with formula: C10H14O"],
        "LMPR0102090018 (Carvone oxide); LMPR0102070037 (dolichodial); LMPR0102120008 ((+)-Bornane-2,5-dione); LMPR0102090041 (Perillic acid); LMPR0102120045 ((1R)-bornane-2,5-dione); LMPR0102120034 ((1R)-bornane-2,3-dione); LMPR0102120032 ((1S)-bornane-2,5-dione); LMPR0102120033 ((1S)-bornane-2,3-dione); LMPR0102120030 (bornane-2,3-dione); LMPR0102070013 (Nepetalactone cis-trans-form); LMPR0102070014 (Nepetalactone trans-cis-form); LMPR0102120024 (Myrtenic acid)": ["C10H14O2", "Prenol Lipids [PR] with formula: C10H14O2"],
        "LMPR0102070004 (Iridotrial); LMPR0102120042 ((-)-5-oxo-1,2-campholide)": ["C10H14O3", "Prenol Lipids [PR] with formula: C10H14O3"],
        "LMPR0102090062 (terpinolene); LMPR0102010021 ((E)-beta-ocimene); LMPR0102010020 ((Z)-beta-ocimene); LMPR0102010023 ((E)-alpha-ocimene); LMPR0102010022 ((Z)-alpha-ocimene); LMPR0102090013 ((+)-Limonene); LMPR0102130001 (Tricyclene); LMPR0102120018 (beta-Pinene); LMPR0102120011 ((+)-Comphene); LMPR0102120012 ((+)-alpha-Pinene); LMPR0102120013 ((-)-beta-Pinene); LMPR0102120015 ((-)-3-Carene); LMPR0102120017 (alpha-Pinene); LMPR0102090002 ((-)-Limonene); LMPR0102120038 ((-)-alpha-thujene); LMPR0102120036 ((+)-sabinene); LMPR0102120037 ((+)-alpha-thujene); LMPR0102120035 ((-)-sabinene); LMPR0102010005 (Myrcene); LMPR0102090027 (gamma-Terpinene); LMPR0102090026 (alpha-Terpinene); LMPR0102090021 ((R)-(-)-alpha-Phellandrene); LMPR0102090022 ((+)-beta-Phellandrene); LMPR0102120021 ((+)-3-Carene)": ["C10H16", "Prenol Lipids [PR] with formula: C10H16"],
        "LMPR0102020001 (2-Methyl-5-isopropylhexa-2Z,5-dienal); LMPR0102090015 (Limonene-1,2-epoxide); LMPR0102120019 (Thujone); LMPR0102120016 (Fenchone); LMPR0102010006 (Neral); LMPR0102090008 ((-)-Perillyl alcohol); LMPR0102090006 ((-)-trans-Isopiperitenol); LMPR0102090005 ((-)-trans-Carveol); LMPR0102120007 (alpha-Pinene-oxide); LMPR0102120001 ((+)-Camphor); LMPR0102090043 ((+)-cis-Isopulegone); LMPR0102090048 ((4R)-limonene 1alpha,2alpha-epoxide); LMPR0102120040 ((-)-beta-thujone); LMPR0102120044 ((+)-cis-sabinol); LMPR0102090036 ((1S,4R)-Iso-dihydrocarvone); LMPR0102090033 ((1R,4R)-Dihydrocarvone); LMPR0102090030 ((4R,6R)-cis-Carveol); LMPR0102090039 ((1S,4S)-Dihydrocarvone); LMPR0102120039 ((+)-beta-thujone); LMPR0102120031 ((1R,4S)-fenchone); LMPR0102090037 ((1R,4S)-Iso-dihydrocarvone); LMPR0102010003 (Geranial); LMPR0102060020 ((-)-cis-sabinol); LMPR0102060021 (sabinol); LMPR0102100001; LMPR0102090025 ((+)-Pulegone); LMPR0102090024 ((+)-Piperitone); LMPR0102120025 (Pinocarveol); LMPR0102120022 (Myrtenol)": ["C10H16O", "Prenol Lipids [PR] with formula: C10H16O"],
        "LMPR0102090061 (diosphenol); LMPR0102090064 (6-oxocineole); LMPR0102070003 (Iridodial); LMPR0102120010 ((+)-exo-5-Hydroxycamphor); LMPR0102060001 (Chrysanthemic acid); LMPR0102060002 ((+)-cis-chrysanthemic acid); LMPR0102060003 ((-)-cis-chrysanthemic acid); LMPR0102090058 ((4R,7R)-4-isopropenyl-7-methyloxepan-2-one); LMPR0102090059 ((4S,7R)-4-isopropenyl-7-methyloxepan-2-one); LMPR0102090042 ((1S,4R)-1-Hydroxy-2-oxolimonene); LMPR0102120048 ((+)-exo-5-hydroxycamphor); LMPR0102120043 (1,2-campholide); LMPR0102120041 ((-)-1,2-campholide); LMPR0102070022 (8-Epiiridodial); LMPR0102070011 ((+)-Iridodial); LMPR0102070017 ((+)-Iridodial)": ["C10H16O2", "Prenol Lipids [PR] with formula: C10H16O2"],
        "LMPR0102090019 (1,8-Cineol); LMPR0102010018 ((S)-lavandulol); LMPR0102010019 ((R)-lavandulol); LMPR0102010010 (Nerol); LMPR0102010011 ((S)-(-)-Citronellal); LMPR0102010013 ((-)-Linalool); LMPR0102010016 (2E-geraniol); LMPR0102090004 ((-)-Menthone); LMPR0102120006 (Sabinene hydrate); LMPR0102120005 ((-)-endo-Fenchol); LMPR0102120004 ((-)-Borneol); LMPR0102120003 ((+)-Borneol); LMPR0102090040 ((1S,2R,4S)-Neo-dihydrocarveol); LMPR0102090044 ((+)-Isomenthone); LMPR0102090034 ((1S,2S,4R)-Iso-dihydrocarveol); LMPR0102090035 ((1S,2R,4R)-Neoiso-dihydrocarveol); LMPR0102090032 ((1R,2S,4R)-Neo-dihydrocarveol); LMPR0102090031 ((1R,2R,4R)-Dihydrocarveol); LMPR0102090038 ((1S,2S,4S)-Dihydrocarveol); LMPR0102010007 ((R)-(+)-Citronellal); LMPR0102010004 (Linalool); LMPR0102090028 ((R)-(+)-alpha-Terpineol)": ["C10H18O", "Prenol Lipids [PR] with formula: C10H18O"],
        "LMPR0102090065 (6-endo-hydroxycineole); LMPR0102090016 (Limonene-1,2-diol); LMPR0102090054 ((4R,7S)-7-isopropyl-4-methyloxepan-2-one); LMPR0102090055 ((4R,7R)-7-isopropyl-4-methyloxepan-2-one)": ["C10H18O2", "Prenol Lipids [PR] with formula: C10H18O2"],
        "LMPR0102090057 (neoisomenthol); LMPR0102010012 ((-)-Citronellol); LMPR0102090003 ((+)-Neomenthol); LMPR0102090001 ((-)-Menthol); LMPR0102010008 (beta-Citronellol)": ["C10H20O", "Prenol Lipids [PR] with formula: C10H20O"],
        "LMPR0102090063 (1beta,3beta,4alpha-p-menthane-3,8-diol); LMPR0102090011 (p-Menthane-3,8-diol); LMPR0102090050 (1alpha,3beta,4beta-p-menthane-3,8-diol); LMPR0102090051 (1beta,3alpha,4alpha-p-menthane-3,8-diol); LMPR0102090052 (1beta,3beta,4beta-p-menthane-3,8-diol); LMPR0102090053 (1beta,3alpha,4beta-p-menthane-3,8-diol); LMPR0102090049 (1alpha,3alpha,4beta-p-menthane-3,8-diol)": ["C10H20O2", "Prenol Lipids [PR] with formula: C10H20O2"],
        "LMPR0102010017 ((R)-lavandulyl diphosphate); LMPR0102120009 ((+)-Bornyl-diphosphate); LMPR0102060019 ((R,R)-chrysanthemyl diphosphate); LMPR0102060018 (chrysanthemyl diphosphate); LMPR0102010002 (Neryl diphosphate); LMPR0102010001 (Geranyl diphosphate)": ["C10H20O7P2", "Prenol Lipids [PR] with formula: C10H20O7P2"],
        "LMPR0102010014 (Citronellyl formate)": ["C11H20O2", "Prenol Lipids [PR] with formula: C11H20O2"],
        "LMPR0102120014 ((1S,2R,4S)-(-)-Bornyl acetate); LMPR0102090047 (gamma-Terpinyl acetate); LMPR0102090046 (beta-Terpinyl acetate); LMPR0102090045 (alpha-Terpinyl acetate); LMPR0102010009 (Linalyl acetate); LMPR0102120020 ((1R,2S,4R)-(+)-Bornyl acetate)": ["C12H20O2", "Prenol Lipids [PR] with formula: C12H20O2"],
        "LMPR0103090008 ((+)-geosmin)": ["C12H22O", "Prenol Lipids [PR] with formula: C12H22O"],
        "LMPR0102010015 (Citronellyl acetate)": ["C12H22O2", "Prenol Lipids [PR] with formula: C12H22O2"],
        "LMPR0103050009 ((6S)-dehydrovomifoliol)": ["C13H18O3", "Prenol Lipids [PR] with formula: C13H18O3"],
        "LMPR0103410002 (Chamazulene)": ["C14H16", "Prenol Lipids [PR] with formula: C14H16"],
        "LMPR0103860002 ((+)-Mayurone)": ["C14H22O", "Prenol Lipids [PR] with formula: C14H22O"],
        "LMPR0103390002 (Sundiversifolide)": ["C14H22O3", "Prenol Lipids [PR] with formula: C14H22O3"],
        "LMPR0103030001": ["C14H24O", "Prenol Lipids [PR] with formula: C14H24O"],
        "LMPR0103300001 (Cacalol)": ["C15H16O2", "Prenol Lipids [PR] with formula: C15H16O2"],
        "LMPR0103330004 (Hemigossypol)": ["C15H16O4", "Prenol Lipids [PR] with formula: C15H16O4"],
        "LMPR0103540001 ((-)-Picrotoxinin)": ["C15H16O6", "Prenol Lipids [PR] with formula: C15H16O6"],
        "LMPR0103410006 (guaiazulene); LMPR0103330007 (Cadalene)": ["C15H18", "Prenol Lipids [PR] with formula: C15H18"],
        "LMPR0103220001 (Farfugin A)": ["C15H18O", "Prenol Lipids [PR] with formula: C15H18O"],
        "LMPR0103190001 (alpha-Santonin); LMPR0103190004 (beta-Santonin)": ["C15H18O3", "Prenol Lipids [PR] with formula: C15H18O3"],
        "LMPR0103620002 ((+)-Marmasmic acid); LMPR0103420001 (Parthenin)": ["C15H18O4", "Prenol Lipids [PR] with formula: C15H18O4"],
        "LMPR0103150001 (iso-Debromo-laurinterol); LMPR0103630002 (Furodysinin); LMPR0103630001 (Furodysin); LMPR0103650002 ((+)-Anhydro-beta-rotunol); LMPR0103170001 (10-Hydroxy-isolaurene); LMPR0103360001 (Mutisianthol)": ["C15H20O", "Prenol Lipids [PR] with formula: C15H20O"],
        "LMPR0103190013 (alantolactone)": ["C15H20O2", "Prenol Lipids [PR] with formula: C15H20O2"],
        "LMPR0103190002 (1,2-Dihydrosantonin); LMPR0103620001 ((-)-Merulidial); LMPR0103050002 ((-)-abscisic aldehyde); LMPR0103050004 (abscisic aldehyde); LMPR0103590001 ((-)-Illudin M); LMPR0103090002 (Parthenolide)": ["C15H20O3", "Prenol Lipids [PR] with formula: C15H20O3"],
        "LMPR0103380001 (7alpha,11alpha-Dihydroxy-4(13),8-coloratadien-12,11-olide); LMPR0103050008 ((-)-abscisic acid); LMPR0103050001 ((S)-(+)-Abscisic acid); LMPR0103420002 (amaralin); LMPR0103590002 ((-)-Illudin S); LMPR0103340001 (Alliacol A)": ["C15H20O4", "Prenol Lipids [PR] with formula: C15H20O4"],
        "LMPR0103540002 (Flakinin A); LMPR0103730002 ((+)-Hirusten-12-oic acid)": ["C15H20O5", "Prenol Lipids [PR] with formula: C15H20O5"],
        "LMPR0103180002 (Vomitoxin)": ["C15H20O6", "Prenol Lipids [PR] with formula: C15H20O6"],
        "LMPR0103670001 ((-)-Obtusadiene)": ["C15H21BrO", "Prenol Lipids [PR] with formula: C15H21BrO"],
        "LMPR0103060015 (alpha-curcumene); LMPR0103450001 (Patchoula-2,4-diene); LMPR0103140001 (Cuparene)": ["C15H22", "Prenol Lipids [PR] with formula: C15H22"],
        "LMPR0103670002 (Laurencenone A)": ["C15H22BrClO", "Prenol Lipids [PR] with formula: C15H22BrClO"],
        "LMPR0103040001 (Valerenal); LMPR0103660002 ((+)-3,7(11)-Acoradiene); LMPR0103100002 (Kissoones A); LMPR0103210001 (4(15),7(11)-Oppositadien-12-al); LMPR0103700006 (albaflavenone); LMPR0103330006 ((+)-8-hydroxycalamenene); LMPR0103880002 (3-Gymnomitren-15-al); LMPR0103080001 (beta-Elemenone); LMPR0103650001 ((-)-Solavetivone); LMPR0103690004 ((+)-4-Isocedren-15-al); LMPR0103760001 ((+)-Arnicenone); LMPR0103740001 (Pentalen-13-al)": ["C15H22O", "Prenol Lipids [PR] with formula: C15H22O"],
        "LMPR0102070007 (Catalpol)": ["C15H22O10", "Prenol Lipids [PR] with formula: C15H22O10"],
        "LMPR0103260001 (12-Hydroxy-chiloscyphone); LMPR0103400001 (Curcumenone); LMPR0103160001 (1,13-Dihydroxy-herbertene); LMPR0103320001 (Macrophyllic acid A); LMPR0103490002 (8beta-Hydroxy-3-longipinen-5-one); LMPR0103610001 (Onitin); LMPR0103610002 (Alcyopterosins O); LMPR0103390001 (Curmadione); LMPR0103450003 (Sugeonol); LMPR0103460001 (Valerenic acid)": ["C15H22O2", "Prenol Lipids [PR] with formula: C15H22O2"],
        "LMPR0103020001 (Ngaione (-)); LMPR0103590003 ((+)-Armillarin)": ["C15H22O3", "Prenol Lipids [PR] with formula: C15H22O3"],
        "LMPR0103620003 ((+)-Blennin D)": ["C15H22O4", "Prenol Lipids [PR] with formula: C15H22O4"],
        "LMPR0103190003 (Artemisin); LMPR0103050007 (epi-dihydrophaseic acid); LMPR0103050005 (dihydrophaseic acid)": ["C15H22O5", "Prenol Lipids [PR] with formula: C15H22O5"],
        "LMPR0102070006 (Aucubin); LMPR0102070036 (Deutzioside)": ["C15H22O9", "Prenol Lipids [PR] with formula: C15H22O9"],
        "LMPR0103190009 ((5xi,7xi,10xi)-eudesma-4(14),11-diene); LMPR0103190008 (5beta,10beta-sibirene); LMPR0103830002 (3-Copaene); LMPR0103190005 (sibirene); LMPR0103190007 (5beta,10alpha-sibirene); LMPR0103190006 (5alpha,10beta-sibirene); LMPR0103510001 ((+)-beta-Isolongibornene); LMPR0103600001 ((+)-2-Sterpurene); LMPR0103680001 ((-)-Spirolepechinene); LMPR0103090011 ((1Z,4Z)-germacrene B); LMPR0103090010 ((1E,4Z)-germacrene B); LMPR0103090012 ((1Z,4E)-germacrene B); LMPR0103770001 (beta-Panasinsane); LMPR0103750003 ((-)-5-Silphiperfolene); LMPR0103520001 ((+)-alpha-Pinguisene); LMPR0103480009 ((1R,6S)-gamma-himachalene); LMPR0103480008 ((1S,6S)-gamma-himachalene); LMPR0103480001 ((-)-alpha-Himachalene); LMPR0103480007 (gamma-himachalene); LMPR0103480006 ((S)-beta-himachalene); LMPR0103480005 (beta-himachalene); LMPR0103480004 (1,3-Himachaladiene); LMPR0103410004 ((+)-guaia-6,9-diene); LMPR0103410005 ((-)-guaia-6,9-diene); LMPR0103100001 (Bicyclogermacrene); LMPR0103860001 ((-)-Thujopsene); LMPR0103470002 (3(15)-Africanene); LMPR0103500017 ((+)-longifolene); LMPR0103070001 ((-)-Sesquicarene); LMPR0103480011 ((1R,6R)-gamma-himachalene); LMPR0103580001 (Asterisc-3(15)-6-diene); LMPR0103060012 (beta-bisabolene); LMPR0103060013 ((S)-beta-bisabolene); LMPR0103060010 ((R,Z)-alpha-bisabolene); LMPR0103060011 ((S,Z)-alpha-bisabolene); LMPR0103060014 ((R)-beta-bisabolene); LMPR0103750004 ((-)-1-Silphinene); LMPR0103750001 (Presilphiperfol-7(8)-ene); LMPR0103430001 (alpha-Aromadendrene); LMPR0103430002 (beta-Aromadendrene); LMPR0103430003 (allo-Aromadendrene); LMPR0103550002 ((+)-Trans-4(11),8-aucadiene); LMPR0103730001 (4(15)-Hirsutene); LMPR0103500001 ((+)-Longifolene); LMPR0103700003 ((+)-6(13)-Zizene); LMPR0103700001 ((+)-Prezizene); LMPR0103700005 ((+)-epi-isozizaene); LMPR0103330005 (amorpha-4,11-diene); LMPR0103330001 ((+)-delta-Cadinene); LMPR0103330003 (beta-Cadinene); LMPR0103120002 (Isocaryophyllene); LMPR0103120001 (beta-Caryophyllene); LMPR0103180001 (Trichodiene); LMPR0103650003 (vetispiradiene); LMPR0103880003 ((+)-delta-selinene); LMPR0103880001 (3-Gymnomitrene); LMPR0103060002 (Zingiberene); LMPR0103060005 ((E)-gamma-bisabolene); LMPR0103060004 ((Z)-gamma-bisabolene); LMPR0103060009 ((E,S)-alpha-bisabolene); LMPR0103060008 ((E,R)-alpha-bisabolene); LMPR0103500018 ((-)-longifolene); LMPR0103490001 ((+)-alpha-Longipinene); LMPR0103270003 ((+)-aristolochene); LMPR0103270001 ((+)-1(10)-Aristolene); LMPR0103270004 ((+)-5-epi-aristolochene); LMPR0103060007 ((E)-alpha-bisabolene); LMPR0103060006 ((Z)-alpha-bisabolene); LMPR0103190012 ((-)-delta-selinene); LMPR0103190010 ((-)-beta-selinene); LMPR0103190011 (delta-selinene); LMPR0103190014 ((+)-beta-selinene); LMPR0103850001 ((-)-Isorotundene); LMPR0103780001 ((-)-Modhephene); LMPR0103440002 (beta-Cubebene); LMPR0103440001 (alpha-Cubebene); LMPR0103450002 (Cyperene); LMPR0103690001 ((-)-alpha-Cedrene); LMPR0103690002 ((+)-beta-Cedrene); LMPR0103090007 (Germacrene B); LMPR0103090001 ((+) Germacrene A); LMPR0103480010 ((1S,6R)-gamma-himachalene); LMPR0103290001 (Brasila-5,10-diene); LMPR0103760002 ((-)-Isocomene); LMPR0103870001 (beta-Bourbonene); LMPR0103110001 (Humulene); LMPR0103110003 ((1E,6Z)-gamma-humulene); LMPR0103110002 ((1E,6E)-gamma-humulene); LMPR0103110005 ((4E,8E)-beta-humulene); LMPR0103110004 ((1Z,6E)-gamma-humulene); LMPR0103690006 (cedr-8-ene)": ["C15H24", "Prenol Lipids [PR] with formula: C15H24"],
        "LMPR0103830001 (5,10-Epoxy-muurolane); LMPR0103830003 (3-Copaene-2-ol); LMPR0103660001 ((-)-4-Acoren-3-one); LMPR0103600002 ((+)-2-Sterpurene-6-ol); LMPR0103010007 (2E,6Z-farnesal); LMPR0103280002 (1beta,10beta-Epoxy-nardosinane); LMPR0103560001 (7(14)-Isodaucen-10-one); LMPR0103250001 ((-)-1(10),11-Eremophiladien-9beta-ol); LMPR0103370002 ((+)-8-Drimen-7-one); LMPR0103840001 (Ishwarol); LMPR0103700008 ((5R)-albaflavenol); LMPR0103700009 ((5S)-albaflavenol); LMPR0103700007 (albaflavenol); LMPR0103700004 ((+)-Khusimol); LMPR0103010012 ((2-trans,6-trans)-farnesal); LMPR0103800003 (beta-santalol); LMPR0103800002 (alpha-santalol); LMPR0103230001; LMPR0103270002 (ent-9-Aristen-8alpha-ol); LMPR0103790001 (Suberosanone); LMPR0103780002 (14-Hydroxy-modhephene); LMPR0103130001 ((+)-Bicyclohumulenone); LMPR0103140002 ((+)-delta-Cuprenen-4alpha-ol)": ["C15H24O", "Prenol Lipids [PR] with formula: C15H24O"],
        "LMPR0103720001 (Capnell-9(12)-ene-8beta,10alpha-diol); LMPR0103280001 ((-)-Kanshone A); LMPR0103250002 (capsidiol); LMPR0103050003 (Latia luciferin)": ["C15H24O2", "Prenol Lipids [PR] with formula: C15H24O2"],
        "LMPR0103600003 ((+)-2-Sterpurene-6,12,15-triol); LMPR0103810001 (9-Hydroxy-helminthosporol); LMPR0103820001 (Dendrobane A)": ["C15H24O3", "Prenol Lipids [PR] with formula: C15H24O3"],
        "LMPR0103310001 ((-)-Valeranone); LMPR0103480003 ((+)-2-Himachalen-7-ol); LMPR0103480002 (Himachalane-2-en-6-ol); LMPR0103410007 (guaiol); LMPR0103240001 (Argutenol); LMPR0103010008 ((2-cis,6-cis)-farnesol); LMPR0103010006 (2E,6Z-farnesol); LMPR0103010005 (Nerolidol); LMPR0103010001 (2E,6E-farnesol); LMPR0103470001 (2-Africananol); LMPR0103570001 ((-)-Tamariscol); LMPR0103550001 ((+)-8-Daucen-5-ol); LMPR0103750002 ((-)-8beta-Presilphiperfolanol); LMPR0103370001 ((-)-Drimenol); LMPR0103700002 ((-)-Prezizaanol); LMPR0103010013 ((2-cis,6-trans)-farnesol); LMPR0103060001 ((-)-alpha-Bisabolol); LMPR0103690003 ((+)-Cedrol); LMPR0103690005 (epi-cedrol); LMPR0103690007 (cedrol); LMPR0103090009 (germacradienol); LMPR0103460002 (6-Valerene-11-ol); LMPR0103030002 ((R)-Sesquilavandulol); LMPR0103870002 (Bourbonol)": ["C15H26O", "Prenol Lipids [PR] with formula: C15H26O"],
        "LMPR0103530001 ((+)-14,15-Epoxy-thapsan-14-ol); LMPR0103800001 (Campherene-2,13-diol); LMPR0103710001 (Clovane-2beta,9alpha-diol)": ["C15H26O2", "Prenol Lipids [PR] with formula: C15H26O2"],
        "LMPR0103010009 (2-cis,6-cis-farnesyl diphosphate); LMPR0103010002 (Farnesyl diphosphate); LMPR0103010003 (Nerolidyl diphosphate); LMPR0103010011 (2-trans,6-cis-farnesyl diphosphate); LMPR0103010010 (2-cis,6-trans-farnesyl diphosphate)": ["C15H28O7P2", "Prenol Lipids [PR] with formula: C15H28O7P2"],
        "LMPR03010006 (farnesyl triphosphate)": ["C15H29O10P3", "Prenol Lipids [PR] with formula: C15H29O10P3"],
        "LMPR0102070009 (Gentiopicrin)": ["C16H20O9", "Prenol Lipids [PR] with formula: C16H20O9"],
        "LMPR0102070012 (Monotropein)": ["C16H22O11", "Prenol Lipids [PR] with formula: C16H22O11"],
        "LMPR0103520002 (Acutifolane A)": ["C16H22O3", "Prenol Lipids [PR] with formula: C16H22O3"],
        "LMPR02020063 (alhpa-tocopheronolactone); LMPR0103200001 (Emmotin A)": ["C16H22O4", "Prenol Lipids [PR] with formula: C16H22O4"],
        "LMPR0103490003 ((+)-Vulgraon B)": ["C16H24", "Prenol Lipids [PR] with formula: C16H24"],
        "LMPR02020062 (alhpa-tocopheronic acid)": ["C16H24O5", "Prenol Lipids [PR] with formula: C16H24O5"],
        "LMPR0102070023 (8-Epiiridotrial glucoside); LMPR0102070024 (Iridotrial glucoside)": ["C16H24O8", "Prenol Lipids [PR] with formula: C16H24O8"],
        "LMPR0103010004 (Juvenile hormone III)": ["C16H26O3", "Prenol Lipids [PR] with formula: C16H26O3"],
        "LMPR0102070035 (Iridodial glucoside); LMPR0102070025 (8-Epiiridodial glucoside)": ["C16H26O7", "Prenol Lipids [PR] with formula: C16H26O7"],
        "LMPR0102090060 ((-)-menthyl beta-D-glucoside)": ["C16H30O6", "Prenol Lipids [PR] with formula: C16H30O6"],
        "LMPR0104120002 (podocarpic acid)": ["C17H22O3", "Prenol Lipids [PR] with formula: C17H22O3"],
        "LMPR0103410003 (Matricin)": ["C17H22O5", "Prenol Lipids [PR] with formula: C17H22O5"],
        "LMPR0102070002 (Secologanin); LMPR0102070016 (Verbenalin)": ["C17H24O10", "Prenol Lipids [PR] with formula: C17H24O10"],
        "LMPR0103450004 (Sugeonyl acetate)": ["C17H24O3", "Prenol Lipids [PR] with formula: C17H24O3"],
        "LMPR0102070001 (Loganin)": ["C17H26O10", "Prenol Lipids [PR] with formula: C17H26O10"],
        "LMPR0102070028 (10-Hydroxyloganin)": ["C17H26O11", "Prenol Lipids [PR] with formula: C17H26O11"],
        "LMPR0103640001 (Botrydial)": ["C17H26O5", "Prenol Lipids [PR] with formula: C17H26O5"],
        "LMPR0102070005 (Deoxyloganin); LMPR0102070020 (8-Epideoxyloganin)": ["C17H26O9", "Prenol Lipids [PR] with formula: C17H26O9"],
        "LMPR0103500005 (5-(2-hydroxyethyl)isolongifol-4-ene); LMPR0103500008 (5-(2-hydroxyethyl)isolongifol-5-ene)": ["C17H28O", "Prenol Lipids [PR] with formula: C17H28O"],
        "LMPR0103350001 (3beta-Acetoxy-4-oplopanone)": ["C17H28O4", "Prenol Lipids [PR] with formula: C17H28O4"],
        "LMPR0103500011 (5-(1-oxopropan-2-yl)isolongifol-5-ene); LMPR0103500012 (4,5-(methanoxyethano)isolongifol-4-ene)": ["C18H28O", "Prenol Lipids [PR] with formula: C18H28O"],
        "LMPR0102070018 (Lamioside)": ["C18H28O11", "Prenol Lipids [PR] with formula: C18H28O11"],
        "LMPR0103500002 (5-propylideneisolongifolane)": ["C18H30", "Prenol Lipids [PR] with formula: C18H30"],
        "LMPR0103500015 (5-(2-methoxyethyl)isolongifol-5-ene); LMPR0103500003 (5-(1-hydroxypropan-2-yl)isolongifol-5-ene); LMPR0103500004 (5-(1-hydroxypropan-2-yl)isolongifol-4-ene)": ["C18H30O", "Prenol Lipids [PR] with formula: C18H30O"],
        "LMPR0103500010 (5-(1-hydroxypropan-2-yl)isolongifolane)": ["C18H32O", "Prenol Lipids [PR] with formula: C18H32O"],
        "LMPR0103090003 (Deoxyelephantopin)": ["C19H20O6", "Prenol Lipids [PR] with formula: C19H20O6"],
        "LMPR0103090004 (Elephantopin)": ["C19H20O7", "Prenol Lipids [PR] with formula: C19H20O7"],
        "LMPR0104170023 (2,3-Didehydrogibberellin A9)": ["C19H22O4", "Prenol Lipids [PR] with formula: C19H22O4"],
        "LMPR0104170011 (Gibberellin A51-catabolite); LMPR0104170028 (Gibberellin A5); LMPR0104170024 (Gibberellin A7)": ["C19H22O5", "Prenol Lipids [PR] with formula: C19H22O5"],
        "LMPR0104170013 (Gibberellin A6); LMPR0104170012 (Gibberellin A29-catabolite); LMPR0104170026 (Gibberellin A34-catabolite); LMPR0104170002 (Gibberellin A3)": ["C19H22O6", "Prenol Lipids [PR] with formula: C19H22O6"],
        "LMPR0104170027 (Gibberellin A8-catabolite)": ["C19H22O7", "Prenol Lipids [PR] with formula: C19H22O7"],
        "LMPR0104170020 (Gibberellin A9)": ["C19H24O4", "Prenol Lipids [PR] with formula: C19H24O4"],
        "LMPR0104170022 (Gibberellin A51); LMPR0104170021 (Gibberellin A4); LMPR0104170004 (Gibberellin A20)": ["C19H24O5", "Prenol Lipids [PR] with formula: C19H24O5"],
        "LMPR0104170025 (Gibberellin A34); LMPR0104170009 (Gibberellin A29); LMPR0104170036 (gibberellin A29); LMPR0104170001 (Gibberellin A1)": ["C19H24O6", "Prenol Lipids [PR] with formula: C19H24O6"],
        "LMPR0104170005 (Gibberellin A8)": ["C19H24O7", "Prenol Lipids [PR] with formula: C19H24O7"],
        "LMPR0102060006 ((+)-trans-(S)-allethrin); LMPR0102060007 ((+)-trans-allethrin); LMPR0102060008 ((+)-trans-(R)-allethrin); LMPR0102060009 ((-)-trans-allethrin); LMPR0102060017 ((-)-cis-(R)-allethrin); LMPR0102060016 ((-)-cis-(S)-allethrin); LMPR0102060015 ((-)-cis-allethrin); LMPR0102060014 ((+)-cis-(R)-allethrin); LMPR0102060013 ((+)-cis-(S)-allethrin); LMPR0102060012 ((+)-cis-allethrin); LMPR0102060011 ((-)-trans-(S)-allethrin); LMPR0102060010 ((-)-trans-(R)-allethrin)": ["C19H26O3", "Prenol Lipids [PR] with formula: C19H26O3"],
        "LMPR0103090013 (alatolide); LMPR0104070003 (gibberellin A2)": ["C19H26O6", "Prenol Lipids [PR] with formula: C19H26O6"],
        "LMPR0103500013 (4,5-(methanoxy-2-methylethano)isolongifol-4-ene)": ["C19H30O", "Prenol Lipids [PR] with formula: C19H30O"],
        "LMPR0103500016 (5-(1-methoxypropan-2-yl)isolongifol-5-ene); LMPR0103500006 (5-(1-hydroxybutan-2-yl)isolongifol-4-ene); LMPR0103500007 (5-(1-hydroxybutan-2-yl)isolongifol-5-ene); LMPR0103500009 (5-(3-hydroxybutan-2-yl)isolongifol-5-ene)": ["C19H32O", "Prenol Lipids [PR] with formula: C19H32O"],
        "LMPR0104010012 (pristanal)": ["C19H38O", "Prenol Lipids [PR] with formula: C19H38O"],
        "LMPR0104010022 (Pristanic acid)": ["C19H38O2", "Prenol Lipids [PR] with formula: C19H38O2"],
        "LMPR0104540004 (Ginkgolide J); LMPR0104540002 (Ginkgolide B)": ["C20H24O10", "Prenol Lipids [PR] with formula: C20H24O10"],
        "LMPR0104540003 (Ginkgolide C)": ["C20H24O11", "Prenol Lipids [PR] with formula: C20H24O11"],
        "LMPR0104010021 (Crocetindial/ Crocetin dialdehyde)": ["C20H24O2", "Prenol Lipids [PR] with formula: C20H24O2"],
        "LMPR0104010020 (Crocetin)": ["C20H24O4", "Prenol Lipids [PR] with formula: C20H24O4"],
        "LMPR0104540001 (Ginkgolide A)": ["C20H24O9", "Prenol Lipids [PR] with formula: C20H24O9"],
        "LMPR01090007 (11-cis-Dehydroretinal); LMPR01090041 (11Z-6s-cis-fixed bicyclic retinal); LMPR01090040 (11-cis- and 12s-trans-fixed retinal); LMPR01090038; LMPR01090039 (6-s-cis-locked retinal); LMPR01090037 (8-18 bonded retinal); LMPR01090006 (all-trans-Dehydroretinal); LMPR01090042 (11Z-6s-trans-fixed bicyclic retinal)": ["C20H26O", "Prenol Lipids [PR] with formula: C20H26O"],
        "LMPR0104440001 (Eremolactone); LMPR01090020 (All-Trans-3,4-Didehydro-Retinoic acid)": ["C20H26O2", "Prenol Lipids [PR] with formula: C20H26O2"],
        "LMPR0104080002 (momilactone A); LMPR01090030 (19-Oxo-all-trans-retinoic acid); LMPR01090031 (19-Oxo-9-cis-retinoic acid); LMPR01090027 (DACP analog of retinoic acid); LMPR0104060002 (Lanugone A); LMPR01090026 (all-trans-4-oxoretinoic acid)": ["C20H26O3", "Prenol Lipids [PR] with formula: C20H26O3"],
        "LMPR0104170018 (Gibberellin A24); LMPR0104170038 (gibberellin A44); LMPR0104170031 (gibberellin A37); LMPR0104170030 (Gibberellin A44)": ["C20H26O5", "Prenol Lipids [PR] with formula: C20H26O5"],
        "LMPR0104170019 (Gibberellin A36); LMPR0104170039 (gibberellin A19); LMPR0104170003 (Gibberellin A19)": ["C20H26O6", "Prenol Lipids [PR] with formula: C20H26O6"],
        "LMPR0104170034 (gibberellin A17)": ["C20H26O7", "Prenol Lipids [PR] with formula: C20H26O7"],
        "LMPR0104170035 (gibberellin A28)": ["C20H26O8", "Prenol Lipids [PR] with formula: C20H26O8"],
        "LMPR01090003 (11-cis-retinal); LMPR01090035 (11-cis retro-gamma-retinal); LMPR01090036 (9-cis retro-gamma-retinal); LMPR0104050011 (dehydroabietadienal); LMPR01090008 (All-Trans-3,4-Didehydro Retinol); LMPR01090002 (Retinal); LMPR0104410002 (Sinulobatin B); LMPR01090018 (13-cis-retinal); LMPR01090017 (9-cis-retinal); LMPR01090010 (11-cis-3,4-didehydroretinol)": ["C20H28O", "Prenol Lipids [PR] with formula: C20H28O"],
        "LMPR01090049 ((3R)-all-trans-3-hydroxyretinal); LMPR01090048 ((3S)-11-cis-3-hydroxyretinal); LMPR0104100003 ((-)-Spruceanol); LMPR01090032 (20,14-retro-retinoic acid); LMPR0104450001 (Dysokusone D); LMPR0104050005 (Dehydroabietic acid); LMPR01090024 (11-cis-Retinoic acid); LMPR01090019 (Tretinoin/All-Trans Retinoic Acid); LMPR01090021 (13-cis-retinoic acid,Isotretinoin); LMPR01090023 (9,13-di-cis-retinoic acid); LMPR01090022 (9-cis-retinoic acid); LMPR01090050 ((3S)-all-trans-3-hydroxyretinal)": ["C20H28O2", "Prenol Lipids [PR] with formula: C20H28O2"],
        "LMPR0104170040 (gibberellin A12 aldehyde); LMPR0104100004 ((-)-Cleistanthol); LMPR01090028 (19-Hydroxy-all-trans-retinoic acid); LMPR0104350002 (Periconicin A); LMPR01090029 (19-Hydroxy-13-cis-retinoic acid); LMPR01090025 (all-trans-4-hydroxyretinoic acid); LMPR0104260001 (Cyrneine A); LMPR0104170006 (Gibberellin A12 aldehyde); LMPR0104080003 (3beta-hydroxy-9beta-pimara-7,15-dien-19,6beta-olide); LMPR0104340001 (Lagaspholones A)": ["C20H28O3", "Prenol Lipids [PR] with formula: C20H28O3"],
        "LMPR0104170014 (Gibberellin A12); LMPR0104170010 (Gibberellin A14 aldehyde); LMPR0104170029 (Gibberellin A53 aldehyde); LMPR0104420002 (Xeniolit A)": ["C20H28O4", "Prenol Lipids [PR] with formula: C20H28O4"],
        "LMPR0104170017 (Gibberellin A15); LMPR0104170015 (Gibberellin A14); LMPR0104420001 (Novaxenicins A); LMPR0104170007 (Gibberellin A53)": ["C20H28O5", "Prenol Lipids [PR] with formula: C20H28O5"],
        "LMPR0104170016 (Gibberellin A37); LMPR0104170008 (Gibberellin A44 diacid); LMPR0104330001 (Phorbol); LMPR0104040002 (terpentecin)": ["C20H28O6", "Prenol Lipids [PR] with formula: C20H28O6"],
        "LMPR0104480001 (Erogorgiaene); LMPR0104020002 (Axerophthene)": ["C20H30", "Prenol Lipids [PR] with formula: C20H30"],
        "LMPR01090009 (9-cis-retinol); LMPR0104140002 ((+)-15-Beyeren-3-one); LMPR01090001 (Retinol); LMPR0104080009 (isopimara-7,15-dienal); LMPR0104050010 (dehydroabietadienol); LMPR01090005 (11-cis-Retinol); LMPR0104130005 (ent-kaur-16-en-19-al); LMPR0104070001 ((+)-Totarol); LMPR0104050009 (levopimaradienal); LMPR0104110003 ((-)-13(16),14-Spongiadiene); LMPR01090011 (13-cis-retinol); LMPR0104020001 (Helicallenal)": ["C20H30O", "Prenol Lipids [PR] with formula: C20H30O"],
        "LMPR0104210001 (Magdalenic acid); LMPR0104100002 ((+)-Luricularic acid); LMPR0104080010 (isopimaric acid); LMPR0104500001 ((-)-Sacculatal); LMPR0104130004 (ent-kaur-16-en-19-oic acid); LMPR0104050004 (Neoabietic acid); LMPR0104050001 (Abietic acid); LMPR0104110001 ((+)-12-Isocopalene-15,16-dial); LMPR0104200001 (7,8-Epoxybasm-4-en-6-one); LMPR0104400004 (Kempene 1)": ["C20H30O2", "Prenol Lipids [PR] with formula: C20H30O2"],
        "LMPR0104140004 ((+)-7beta-Hydroxy-15-beyeren-19-oic acid); LMPR0104370001 (Spatol); LMPR0104540005 (ent-7alpha-hydroxykaur-16-en-19-oic acid); LMPR0104500002 ((+)-18-Hydroxy-7,16-sacculatadiene-11,12-dial)": ["C20H30O3", "Prenol Lipids [PR] with formula: C20H30O3"],
        "LMPR0104180004 ((-)-Leucothol C); LMPR0104090001 ((-)-Cassaic acid); LMPR0104310001 (7beta-Hydroxy-lathyrol); LMPR0104480003 ((-)-8,16-Dihydroxy-19-serrulatanoic acid)": ["C20H30O4", "Prenol Lipids [PR] with formula: C20H30O4"],
        "LMPR0104070002 (Pedunculatic acid)": ["C20H30O5", "Prenol Lipids [PR] with formula: C20H30O5"],
        "LMPR0104310002 (Ingol)": ["C20H30O6", "Prenol Lipids [PR] with formula: C20H30O6"],
        "LMPR0104140001 ((+)-15-Beyerene); LMPR0104160001 (Aphidicol-16-ene); LMPR0104100001 ((+)-13(17),15-Cleistanthadiene); LMPR0104240001 (Dolabella-3,7,18-triene); LMPR0104350003 (fusicocca-2,10(14)-diene); LMPR0104080001 ((+)-Sandaracopimaradiene); LMPR0104430001 (Viscida-4,11(18),14-triene); LMPR0104280001 (Verrucosanene); LMPR0104080005 (ent-pimara-9(11),15-diene); LMPR0104130001 (ent-Kaurene); LMPR0104130002 (ent-kaurene); LMPR0104080006 (9beta-pimara-7,15-diene); LMPR0104050007 (abieta-8(14),12-diene); LMPR0104050003 (Neoabietadiene); LMPR0104050002 ((-)-Abietadiene); LMPR0104410003 (elisabethatriene); LMPR0104150004 ((-)-16-Atisene); LMPR0104120001 (ent-cassa-12,15-diene); LMPR0104030007 (stemod-13(17)-ene); LMPR0104030008 (stemar-13-ene); LMPR0104080004 (ent-pimara-8(14),15-diene); LMPR0104080007 (isopimara-7,15-diene); LMPR0104480002 ((-)-4,10(20),14-Bifloratriene); LMPR0104290001 (Casbene); LMPR0104190002 (Cembrene); LMPR0104190001 (Neocembrene); LMPR0104390002 (Taxa-4(5),11(12)-diene)": ["C20H32", "Prenol Lipids [PR] with formula: C20H32"],
        "LMPR0104520001 (Iriediol)": ["C20H32Br2O2", "Prenol Lipids [PR] with formula: C20H32Br2O2"],
        "LMPR0104080008 (isopimara-7,15-dienol); LMPR01090047 (all-trans-13,14-dihydroretinol); LMPR0104420003 (Isoxeniaphyllenol); LMPR0104460001 (17,18-Epoxy-8,10,13(15)-lobatriene); LMPR0104450003 (Dictyolene); LMPR0104130003 (ent-kaur-16-en-19-ol); LMPR0104050006 (abietol); LMPR0104050008 (levopimaradienol); LMPR0104400002 (Isotrinerviol); LMPR0104390003 (Taxa-4(20),11(12)-dien-5alpha-ol)": ["C20H32O", "Prenol Lipids [PR] with formula: C20H32O"],
        "LMPR0104210003 ((-)-Cladielline); LMPR0104530002 ((-)-Reiswigin A); LMPR0104250002 ((-)-Isoamijiol); LMPR0104150006 ((+)-Serradiol); LMPR0104470001 (Acutilol A); LMPR0104250001 ((-)-Amijiol); LMPR0104400003 (Isotrinervidiol); LMPR0104390005 (Taxa-4(20),11(12)-dien-5alpha,13alpha-diol)": ["C20H32O2", "Prenol Lipids [PR] with formula: C20H32O2"],
        "LMPR0104140003 ((+)-Beyerol); LMPR0104490001 ((+-)-Trihydroxy-decipiadiene); LMPR0104150005 ((-)-16alpha,17-Dihydroxy-atisan-3-one); LMPR0104400001 (1(15),8(19)-Trinervitadiene-3alpha,5alpha,18-triol)": ["C20H32O3", "Prenol Lipids [PR] with formula: C20H32O3"],
        "LMPR0104240003 ((-)-Stolondiol)": ["C20H32O4", "Prenol Lipids [PR] with formula: C20H32O4"],
        "LMPR0104180001 (Grayanotoxin II); LMPR0104180002 (Isograyanotoxin II)": ["C20H32O5", "Prenol Lipids [PR] with formula: C20H32O5"],
        "LMPR0104180003 (Rhodojaponin III)": ["C20H32O6", "Prenol Lipids [PR] with formula: C20H32O6"],
        "LMPR0104510001 (Rogioldiol A)": ["C20H33BrO2", "Prenol Lipids [PR] with formula: C20H33BrO2"],
        "LMPR0104530001 ((+)-Tormesol); LMPR0104010018 ((Z,Z,Z)-geranylgeraniol); LMPR0104160002 (aphidicolan-16beta-ol); LMPR0103500014 (5-(1-methoxybutan-2-yl)isolongifol-5-ene); LMPR0104010009 (Geranylgeraniol); LMPR0104450002 ((-)-Dilophol); LMPR0104380001 ((+)-Verticillol); LMPR0104280002 (Verrucosan-2b-ol); LMPR0104220002 (Presphaerol); LMPR0104030005 (tuberculosinol)": ["C20H34O", "Prenol Lipids [PR] with formula: C20H34O"],
        "LMPR0104010010 (plaunotol)": ["C20H34O2", "Prenol Lipids [PR] with formula: C20H34O2"],
        "LMPR0104240002 ((-)-2,7-Dolabelladiene-6beta,10alpha,18-triol); LMPR0104110002 ((-)-Spongiane-15,16-diol); LMPR0104150001 ((+)-Villanovane-13alpha,19-diol)": ["C20H34O3", "Prenol Lipids [PR] with formula: C20H34O3"],
        "LMPR0104210002 ((-)-Enunicelline)": ["C20H34O5", "Prenol Lipids [PR] with formula: C20H34O5"],
        "LMPR0104220001 (Sphaerodiene)": ["C20H36", "Prenol Lipids [PR] with formula: C20H36"],
        "LMPR0104030010 (sclareol)": ["C20H36O2", "Prenol Lipids [PR] with formula: C20H36O2"],
        "LMPR0104030006 (tuberculosinyl diphosphate); LMPR0104010001 (Geranylgeranyl diphosphate); LMPR0104010003 (trans,trans,cis-Geranylgeranyl diphosphate); LMPR0104030003 (syn-Copalyl diphosphate); LMPR0104030002 (Copalyl diphosphate); LMPR0104030001 (ent-Copalyl diphosphate); LMPR0104010013 (2-trans,6-cis,10-trans-geranylgeranyl diphosphate); LMPR0104040003 (terpentedienyl diphosphate)": ["C20H36O7P2", "Prenol Lipids [PR] with formula: C20H36O7P2"],
        "LMPR0104010023 (2E-Phytenoic acid); LMPR0104010005 (Phytenoic Acid)": ["C20H38O2", "Prenol Lipids [PR] with formula: C20H38O2"],
        "LMPR0104010016 (2-oxophytanic acid)": ["C20H38O3", "Prenol Lipids [PR] with formula: C20H38O3"],
        "LMPR0104010002 (Phytol)": ["C20H40O", "Prenol Lipids [PR] with formula: C20H40O"],
        "LMPR0104010004 (Phytanic acid)": ["C20H40O2", "Prenol Lipids [PR] with formula: C20H40O2"],
        "LMPR0104010015 ((2S)-2-hydroxyphytanic acid); LMPR0104010011 (2-hydroxyphytanic acid)": ["C20H40O3", "Prenol Lipids [PR] with formula: C20H40O3"],
        "LMPR0104010014 (Phytophthora mating hormone alpha1)": ["C20H40O4", "Prenol Lipids [PR] with formula: C20H40O4"],
        "LMPR0104010007 (Phytyl phosphate)": ["C20H41O4P", "Prenol Lipids [PR] with formula: C20H41O4P"],
        "LMPR0104010019 (Phytane)": ["C20H42", "Prenol Lipids [PR] with formula: C20H42"],
        "LMPR0104010006 (Phytanol)": ["C20H42O", "Prenol Lipids [PR] with formula: C20H42O"],
        "LMPR0104010017 (phytyl diphosphate); LMPR0104010008 (Phytyl diphosphate)": ["C20H42O7P2", "Prenol Lipids [PR] with formula: C20H42O7P2"],
        "LMPR01090044 ((11Z)-8,18-methano-retinal)": ["C21H28O", "Prenol Lipids [PR] with formula: C21H28O"],
        "LMPR01090033 (14-methyl-20,14-retro-retinoic acid); LMPR01090034 (14-methyl-all-trans-retinoic acid)": ["C21H30O2", "Prenol Lipids [PR] with formula: C21H30O2"],
        "LMPR0102060004 (jasmolin I); LMPR0104040001 (Junceic acid)": ["C21H30O3", "Prenol Lipids [PR] with formula: C21H30O3"],
        "LMPR02020053 (gamma-CEHC Glc)": ["C21H30O9", "Prenol Lipids [PR] with formula: C21H30O9"],
        "LMPR0103050006 (dihydrophaseic acid 4-O-beta-D-glucoside)": ["C21H32O10", "Prenol Lipids [PR] with formula: C21H32O10"],
        "LMPR0104270001 (Tintinnadiol)": ["C21H32O3", "Prenol Lipids [PR] with formula: C21H32O3"],
        "LMPR0104360001 (13,14-dihydroxy-11-mulinen-20-oic acid)": ["C21H34O4", "Prenol Lipids [PR] with formula: C21H34O4"],
        "LMPR02020064 (Homophytanic acid)": ["C21H42O2", "Prenol Lipids [PR] with formula: C21H42O2"],
        "LMPR0102060022 (pyrethrin II); LMPR0104320001 ((-)-20-Acetoy-9-hydroxy-1,6,14-rhamnofolane-triene-3,13-dione)": ["C22H28O5", "Prenol Lipids [PR] with formula: C22H28O5"],
        "LMPR0106110002 (Quassin)": ["C22H28O6", "Prenol Lipids [PR] with formula: C22H28O6"],
        "LMPR01070297 (14'-apo-beta-carotenal); LMPR01090043 ((11Z)-8,18-ethanoretinal)": ["C22H30O", "Prenol Lipids [PR] with formula: C22H30O"],
        "LMPR0104410001 (Sinulobatin A)": ["C22H30O3", "Prenol Lipids [PR] with formula: C22H30O3"],
        "LMPR0102060005 (jasmolin II)": ["C22H30O5", "Prenol Lipids [PR] with formula: C22H30O5"],
        "LMPR0104060001 (Coleone P); LMPR0106110001 (Neoquassin)": ["C22H30O6", "Prenol Lipids [PR] with formula: C22H30O6"],
        "LMPR0104330003 (phorbol 13-acetate)": ["C22H30O7", "Prenol Lipids [PR] with formula: C22H30O7"],
        "LMPR0102070015 (Valtratum)": ["C22H30O8", "Prenol Lipids [PR] with formula: C22H30O8"],
        "LMPR01090012 (Retinol Acetate/All-trans-retinyl Acetate)": ["C22H32O2", "Prenol Lipids [PR] with formula: C22H32O2"],
        "LMPR0102070008 (Didrovaltratum)": ["C22H32O8", "Prenol Lipids [PR] with formula: C22H32O8"],
        "LMPR0104390004 (Taxa-4(20),11(12)-dien-5alpha-yl acetate)": ["C22H34O2", "Prenol Lipids [PR] with formula: C22H34O2"],
        "LMPR0104390006 (Taxa-4(20),11(12)-dien-5alpha-acetoxy-10beta-ol)": ["C22H34O3", "Prenol Lipids [PR] with formula: C22H34O3"],
        "LMPR0104030009 (1,9-dideoxyforskolin)": ["C22H34O5", "Prenol Lipids [PR] with formula: C22H34O5"],
        "LMPR0104030004 (forskolin)": ["C22H34O7", "Prenol Lipids [PR] with formula: C22H34O7"],
        "LMPR01090046 (Etretinate)": ["C23H30O3", "Prenol Lipids [PR] with formula: C23H30O3"],
        "LMPR0104320002 (Neoglabrescin A)": ["C23H30O9", "Prenol Lipids [PR] with formula: C23H30O9"],
        "LMPR01090045 ((11Z)-8,18-propano-retinal)": ["C23H32O", "Prenol Lipids [PR] with formula: C23H32O"],
        "LMPR0104090002 (Caesalpinin N)": ["C23H32O6", "Prenol Lipids [PR] with formula: C23H32O6"],
        "LMPR02010037 (plastoquinol-1)": ["C23H36O2", "Prenol Lipids [PR] with formula: C23H36O2"],
        "LMPR01070208 (Bixindial/ Bixin aldehyde)": ["C24H28O2", "Prenol Lipids [PR] with formula: C24H28O2"],
        "LMPR01070209 (Norbixin)": ["C24H28O4", "Prenol Lipids [PR] with formula: C24H28O4"],
        "LMPR0102070010 (Harpagoside)": ["C24H30O11", "Prenol Lipids [PR] with formula: C24H30O11"],
        "LMPR0104230002 (Brianthein X)": ["C24H31ClO9", "Prenol Lipids [PR] with formula: C24H31ClO9"],
        "LMPR0104230001 (Briantheine W)": ["C24H32O6", "Prenol Lipids [PR] with formula: C24H32O6"],
        "LMPR0102070027 (8-Epiiridodial glucoside tetraacetate); LMPR0102070026 (Iridodial glucoside tetraacetate)": ["C24H34O11", "Prenol Lipids [PR] with formula: C24H34O11"],
        "LMPR0105060003 (Hyrtial)": ["C24H38O2", "Prenol Lipids [PR] with formula: C24H38O2"],
        "LMPR0104350001 ((-)-Fusicoplagin A)": ["C24H38O7", "Prenol Lipids [PR] with formula: C24H38O7"],
        "LMPR01070210 (Bixin)": ["C25H30O4", "Prenol Lipids [PR] with formula: C25H30O4"],
        "LMPR0104170033 (gibberellin A3 O-beta-D-glucoside)": ["C25H32O11", "Prenol Lipids [PR] with formula: C25H32O11"],
        "LMPR0102070034 (Deutzioside pentaacetate); LMPR0102070033 (7-Dehydrologanin tetraacetate)": ["C25H32O14", "Prenol Lipids [PR] with formula: C25H32O14"],
        "LMPR0102070021 (8-Epideoxyloganin tetraacetate); LMPR0102070019 (Deoxyloganin tetraacetate)": ["C25H34O13", "Prenol Lipids [PR] with formula: C25H34O13"],
        "LMPR0102070029 (7-Epiloganin tetraacetate)": ["C25H34O14", "Prenol Lipids [PR] with formula: C25H34O14"],
        "LMPR01070293 ((3S,5R,6R)-3,5-dihydroxy-6,7-didehydro-5,6-dihydro-12'-apo-beta-caroten-12'-al); LMPR01070294 ((3S,5R,6S)-5,6-epoxy-3-hydroxy-5,6-dihydro-12'-apo-beta-caroten-12'-al)": ["C25H34O3", "Prenol Lipids [PR] with formula: C25H34O3"],
        "LMPR0104170037 (gibberellin A2 O-beta-D-glucoside)": ["C25H36O11", "Prenol Lipids [PR] with formula: C25H36O11"],
        "LMPR02020058 (didesmethyl tocotrienol)": ["C25H36O2", "Prenol Lipids [PR] with formula: C25H36O2"],
        "LMPR0105050001 (Ophiobolin A)": ["C25H36O4", "Prenol Lipids [PR] with formula: C25H36O4"],
        "LMPR0105020001 (Manoalide)": ["C25H36O5", "Prenol Lipids [PR] with formula: C25H36O5"],
        "LMPR0105060001 ((+)-Scalarin)": ["C25H38O4", "Prenol Lipids [PR] with formula: C25H38O4"],
        "LMPR0105030001 ((-)-Ceriferol 1)": ["C25H40O", "Prenol Lipids [PR] with formula: C25H40O"],
        "LMPR0105040001 ((+)-Dysideapalaunic acid)": ["C25H40O2", "Prenol Lipids [PR] with formula: C25H40O2"],
        "LMPR0105060002 ((+)-Desoxyscalarin)": ["C25H40O3", "Prenol Lipids [PR] with formula: C25H40O3"],
        "LMPR0105040002 ((-)-Salvisyriacolide)": ["C25H40O6", "Prenol Lipids [PR] with formula: C25H40O6"],
        "LMPR0104150003 (19-(3-methyl-butanoyloxy)-villanovane-13alpha,17-diol)": ["C25H42O5", "Prenol Lipids [PR] with formula: C25H42O5"],
        "LMPR0104150002 (3beta-(3-methyl-butanoyloxy)-villanovane-13alpha,17-diol)": ["C25H42O6", "Prenol Lipids [PR] with formula: C25H42O6"],
        "LMPR0105010006 (C25:4 Highly branched isoprenoid C); LMPR0105010004 (C25:4 Highly branched isoprenoid A); LMPR0105010005 (C25:4 Highly branched isoprenoid B); LMPR0105020003 (C25:3 Monocyclic highly branched isoprenoid)": ["C25H44", "Prenol Lipids [PR] with formula: C25H44"],
        "LMPR03070026 (Dolichol-16); LMPR0105010001 (C25:3 6,7-Epoxy highly branched isoprenoid)": ["C25H44O", "Prenol Lipids [PR] with formula: C25H44O"],
        "LMPR0105010014 (all-trans-pentaprenyl diphosphate)": ["C25H44O7P2", "Prenol Lipids [PR] with formula: C25H44O7P2"],
        "LMPR03080015 (dolichyl phosphate)": ["C25H45O4P", "Prenol Lipids [PR] with formula: C25H45O4P"],
        "LMPR0105010009 (C25:3 Highly branched isoprenoid C); LMPR0105010010 (C25:3 Highly branched isoprenoid D); LMPR0105010007 (C25:3 Highly branched isoprenoid A); LMPR0105010008 (C25:3 Highly branched isoprenoid B)": ["C25H46", "Prenol Lipids [PR] with formula: C25H46"],
        "LMPR0105010002 (C25:2 6,7-Epoxy highly branched isoprenoid)": ["C25H46O", "Prenol Lipids [PR] with formula: C25H46O"],
        "LMPR03090023 (dolichyl diphosphate)": ["C25H46O7P2", "Prenol Lipids [PR] with formula: C25H46O7P2"],
        "LMPR0105010011 (C25:2 Highly branched isoprenoid); LMPR0105020002 (C25:1 Monocyclic highly branched isoprenoid)": ["C25H48", "Prenol Lipids [PR] with formula: C25H48"],
        "LMPR0105010012 (C25:1 Highly branched isoprenoid); LMPR0105020004 (C25 Monocyclic highly branched isoprenoid)": ["C25H50", "Prenol Lipids [PR] with formula: C25H50"],
        "LMPR0105010003 (C25 6,7-Epoxy highly branched isoprenoid)": ["C25H50O", "Prenol Lipids [PR] with formula: C25H50O"],
        "LMPR0105010013 (C25 Highly branched isoprenoid)": ["C25H52", "Prenol Lipids [PR] with formula: C25H52"],
        "LMPR01070211 (Methyl bixin/ (Bixin dimethyl ester))": ["C26H32O4", "Prenol Lipids [PR] with formula: C26H32O4"],
        "LMPR0103060003 (fumagillin)": ["C26H34O7", "Prenol Lipids [PR] with formula: C26H34O7"],
        "LMPR0102070031 (11-Hydroxyiridodial glucoside pentaacetate); LMPR0102070032 (8-epi-11-Hydroxyiridodial glucoside pentaacetate)": ["C26H36O13", "Prenol Lipids [PR] with formula: C26H36O13"],
        "LMPR01090051 (1-O-all-trans-retinoyl-beta-glucuronic acid)": ["C26H36O8", "Prenol Lipids [PR] with formula: C26H36O8"],
        "LMPR0102070030 (Loganin pentaacetate)": ["C27H36O15", "Prenol Lipids [PR] with formula: C27H36O15"],
        "LMPR02020056 (delta-tocotrienol)": ["C27H40O2", "Prenol Lipids [PR] with formula: C27H40O2"],
        "LMPR0104230003 ((-)-Solenolide A)": ["C28H39ClO9", "Prenol Lipids [PR] with formula: C28H39ClO9"],
        "LMPR02020057 (gamma-tocotrienol); LMPR02020055 (beta-tocotrienol)": ["C28H42O2", "Prenol Lipids [PR] with formula: C28H42O2"],
        "LMPR0104210004 ((-)-Asbestinine 2)": ["C28H44O6", "Prenol Lipids [PR] with formula: C28H44O6"],
        "LMPR0104310004 ((-)-Jolkinol B)": ["C29H36O5", "Prenol Lipids [PR] with formula: C29H36O5"],
        "LMPR0104310003 ((-)-Jolkinol A)": ["C29H36O6", "Prenol Lipids [PR] with formula: C29H36O6"],
        "LMPR02010003 (Coenzyme Q4)": ["C29H42O4", "Prenol Lipids [PR] with formula: C29H42O4"],
        "LMPR02020054 (alpha-tocotrienol)": ["C29H44O2", "Prenol Lipids [PR] with formula: C29H44O2"],
        "LMPR02020001 (alpha-tocopherol)": ["C29H50O2", "Prenol Lipids [PR] with formula: C29H50O2"],
        "LMPR0103330002 (Gossypol)": ["C30H30O8", "Prenol Lipids [PR] with formula: C30H30O8"],
        "LMPR01070143 (4,4'-Diapolycopene)": ["C30H40", "Prenol Lipids [PR] with formula: C30H40"],
        "LMPR0104330004 (pedilstatin)": ["C30H40O7", "Prenol Lipids [PR] with formula: C30H40O7"],
        "LMPR01070132 (4,4'-Diaponeurosporene)": ["C30H42", "Prenol Lipids [PR] with formula: C30H42"],
        "LMPR01070298 (8'-apo-beta-carotenol)": ["C30H42O", "Prenol Lipids [PR] with formula: C30H42O"],
        "LMPR0104300002 ((-)-Euphomine A)": ["C30H42O7", "Prenol Lipids [PR] with formula: C30H42O7"],
        "LMPR01070142 (4,4'-Diapo-zeta-carotene)": ["C30H44", "Prenol Lipids [PR] with formula: C30H44"],
        "LMPR0106150012 (3-oxoglycyrrhetinic acid)": ["C30H44O4", "Prenol Lipids [PR] with formula: C30H44O4"],
        "LMPR01070141 (4,4'-Diapophytofluene)": ["C30H46", "Prenol Lipids [PR] with formula: C30H46"],
        "LMPR0106150002 (Moronic acid)": ["C30H46O3", "Prenol Lipids [PR] with formula: C30H46O3"],
        "LMPR0106150011 (3alpha-hydroxyglycyrrhetinic acid); LMPR0106150010 (gypsogenin); LMPR0106150014 (Glycyrrhetinic acid)": ["C30H46O4", "Prenol Lipids [PR] with formula: C30H46O4"],
        "LMPR01070131 (4,4'-Diapophytoene/ Dehydrosqualene)": ["C30H48", "Prenol Lipids [PR] with formula: C30H48"],
        "LMPR0106150004 (oleanolic acid); LMPR0106180004 ((+)-Ursolic acid); LMPR0106180007 (ursolic acid)": ["C30H48O3", "Prenol Lipids [PR] with formula: C30H48O3"],
        "LMPR0106150005 (spinosic acid A); LMPR0106230003 (16-Oxolycoclavanol)": ["C30H48O4", "Prenol Lipids [PR] with formula: C30H48O4"],
        "LMPR0106150007 (bayogenin)": ["C30H48O5", "Prenol Lipids [PR] with formula: C30H48O5"],
        "LMPR0106010005 (C30:6 Highly branched isoprenoid A); LMPR0106010002 (Squalene); LMPR0106020001 (C30:5 Monocyclic highly branched isoprenoid A); LMPR0106230002 ((-)-14-Serratene); LMPR04000001 (Diploptene); LMPR0106010006 (C30:6 Highly branched isoprenoid B); LMPR0106200004 ((-)-5-Adianene)": ["C30H50", "Prenol Lipids [PR] with formula: C30H50"],
        "LMPR0106090001 ((+)-Tirucallol); LMPR0106010010 (3S-squalene-2,3-epoxide); LMPR0106180005 ((-)-Ilexol); LMPR0106180006 (Taraxasterol); LMPR0106130001 (Lupeol); LMPR0106220003 ((+)-16-Gammaceren-3beta-ol); LMPR0106240002 (thalianol); LMPR0106090002 ((+)-Euphol); LMPR0106170001 (alpha-Amyrin); LMPR0106140001 (beta-Amyrin); LMPR0106160003 ((-)-Multiflorenol); LMPR0106200002 ((-)-7-Fernen-3beta-ol); LMPR0106200003 ((+)-12-Neophoen-3beta-ol); LMPR0106160002 ((+)-Taraxerol); LMPR0106180002 ((+)-20-Taraxasten-3beta-ol); LMPR0106200005 ((-)-Simiarenol); LMPR0106200006 ((+)-Filicenal); LMPR0106200001 ((-)-7-Fernen-3alpha-ol)": ["C30H50O", "Prenol Lipids [PR] with formula: C30H50O"],
        "LMPR0106240003 (thalianol epoxide); LMPR0106190002 ((+)-22(29)-Hopen-6alpha-21beta-diol)": ["C30H50O2", "Prenol Lipids [PR] with formula: C30H50O2"],
        "LMPR0106180003 ((+)-3beta-Hydroxy-ursan-28-oic acid)": ["C30H50O3", "Prenol Lipids [PR] with formula: C30H50O3"],
        "LMPR0106220002 ((+)-Gammacerane); LMPR0106020002 (C30:4 Monocyclic highly branched isoprenoid); LMPR0106010008 (C30:5 Highly branched isoprenoid); LMPR0106010007 (C30:5 Monocyclic highly branched isoprenoid B)": ["C30H52", "Prenol Lipids [PR] with formula: C30H52"],
        "LMPR0106210001 (Tetrahymanol); LMPR04000002 (22-Hopanol)": ["C30H52O", "Prenol Lipids [PR] with formula: C30H52O"],
        "LMPR0106080001 ((+)-24-Dammarene-3beta-20S-diol)": ["C30H52O2", "Prenol Lipids [PR] with formula: C30H52O2"],
        "LMPR0106180001 (Taraxastane-3beta,16beta,20beta-triol); LMPR0106240001 (Myrrhanol A); LMPR0106080002 ((+)-24-Dammarene-3alpha,12beta,20S-triol); LMPR0106080003 (Protopanaxadiol)": ["C30H52O3", "Prenol Lipids [PR] with formula: C30H52O3"],
        "LMPR0106010003 (Presqualene diphosphate); LMPR03030005 (all-trans-hexaprenyl diphosphate)": ["C30H52O7P2", "Prenol Lipids [PR] with formula: C30H52O7P2"],
        "LMPR03080011 (dolichyl D-xylosyl phosphates)": ["C30H53O8P", "Prenol Lipids [PR] with formula: C30H53O8P"],
        "LMPR0106010004 (Tetrahydrosqualene)": ["C30H54", "Prenol Lipids [PR] with formula: C30H54"],
        "LMPR0106020003 (C30 Monocyclic highly branched isoprenoid)": ["C30H60", "Prenol Lipids [PR] with formula: C30H60"],
        "LMPR0106010009 (C30 Highly branched isoprenoid); LMPR0106030001 (Botryococcane)": ["C30H62", "Prenol Lipids [PR] with formula: C30H62"],
        "LMPR02030028 (phylloquinone)": ["C31H46O2", "Prenol Lipids [PR] with formula: C31H46O2"],
        "LMPR02030031 (2,3-epoxyphylloquinone)": ["C31H46O3", "Prenol Lipids [PR] with formula: C31H46O3"],
        "LMPR02030030 (phyllohydroquinone)": ["C31H48O2", "Prenol Lipids [PR] with formula: C31H48O2"],
        "LMPR02030029 (3-hydroxy-2-methyl-3-phytyl-2,3-dihydro-1,4-naphthoquinone); LMPR0106050001 ((-)-Abieslactone)": ["C31H48O3", "Prenol Lipids [PR] with formula: C31H48O3"],
        "LMPR0106040001 ((-)-Fusidic acid)": ["C31H48O6", "Prenol Lipids [PR] with formula: C31H48O6"],
        "LMPR0106230001 (Japonicumins A)": ["C31H50O3", "Prenol Lipids [PR] with formula: C31H50O3"],
        "LMPR03020004 (Dodecaprenyl phosphate-galacturonic acid)": ["C31H51O10P", "Prenol Lipids [PR] with formula: C31H51O10P"],
        "LMPR0106230004 (Onocerin)": ["C31H52O2", "Prenol Lipids [PR] with formula: C31H52O2"],
        "LMPR0106220001 (Tetrahymanol)": ["C31H54O", "Prenol Lipids [PR] with formula: C31H54O"],
        "LMPR03080014 (dolichyl beta-D-glucosyl phosphate)": ["C31H55O9P", "Prenol Lipids [PR] with formula: C31H55O9P"],
        "LMPR0104300001 (Pubescenol)": ["C32H40O10", "Prenol Lipids [PR] with formula: C32H40O10"],
        "LMPR0104300003 ((-)-Euphomine)": ["C32H44O8", "Prenol Lipids [PR] with formula: C32H44O8"],
        "LMPR0106050002 ((+)-Ganoderic acid S)": ["C32H48O5", "Prenol Lipids [PR] with formula: C32H48O5"],
        "LMPR0106160001 (Acinospesigenin A)": ["C32H50O6", "Prenol Lipids [PR] with formula: C32H50O6"],
        "LMPR0106130002 (Lupeol acetate)": ["C32H52O2", "Prenol Lipids [PR] with formula: C32H52O2"],
        "LMPR04000030 (Bishomohopanoic acid); LMPR04000003 (Hopane-29-acetate)": ["C32H54O2", "Prenol Lipids [PR] with formula: C32H54O2"],
        "LMPR0106190001 (17beta,21beta-epoxy-16alpha-ethoxyhopan-3beta-ol)": ["C32H54O3", "Prenol Lipids [PR] with formula: C32H54O3"],
        "LMPR04000029 (2-methyl-hopane-17beta,21beta-homohopanol)": ["C32H56O", "Prenol Lipids [PR] with formula: C32H56O"],
        "LMPR04000026 (30,32-dihydroxy-2b-methyl-bishomohopane)": ["C33H58O2", "Prenol Lipids [PR] with formula: C33H58O2"],
        "LMPR0106040002 ((-)-Helvolic acid)": ["C34H48O7", "Prenol Lipids [PR] with formula: C34H48O7"],
        "LMPR0103410001 (Thapsigargin)": ["C34H50O12", "Prenol Lipids [PR] with formula: C34H50O12"],
        "LMPR0106030002 (Penta-unsaturated monocyclic botrycoccane); LMPR0106030004 (Botryococcene)": ["C34H58", "Prenol Lipids [PR] with formula: C34H58"],
        "LMPR0106030003 (Monocyclic botryococcane)": ["C34H68", "Prenol Lipids [PR] with formula: C34H68"],
        "LMPR0106100001 (Azadirachtin A); LMPR0106100002 (3-Acetyl-1-tigloylazadirachtinin)": ["C35H44O16", "Prenol Lipids [PR] with formula: C35H44O16"],
        "LMPR01070189 (4'-Apo-3,4-didehydrolycopene/ (4-Apo-3',4'-didehydrolycopene))": ["C35H46", "Prenol Lipids [PR] with formula: C35H46"],
        "LMPR01070206 (Neurosporaxanthin)": ["C35H46O2", "Prenol Lipids [PR] with formula: C35H46O2"],
        "LMPR04000023 (32,35-anhydrobacteriohopan-11-ene-tetrol)": ["C35H58O3", "Prenol Lipids [PR] with formula: C35H58O3"],
        "LMPR04000021 ((5-D-ribonyl)hopane)": ["C35H58O4", "Prenol Lipids [PR] with formula: C35H58O4"],
        "LMPR04000022 (32,35-anhydrobacteriohopaneterol)": ["C35H60O3", "Prenol Lipids [PR] with formula: C35H60O3"],
        "LMPR04000028 (Ribosylhopane); LMPR04000027 (31-hydroxy-32,35-anhydrobacteriohopanetetrol)": ["C35H60O4", "Prenol Lipids [PR] with formula: C35H60O4"],
        "LMPR03030006 (all-trans-heptaprenyl diphosphate)": ["C35H60O7P2", "Prenol Lipids [PR] with formula: C35H60O7P2"],
        "LMPR04000024 (30-(-2-(O-2-hydroxy-ethane)-3-hydroxy-propane)-hopane)": ["C35H62O3", "Prenol Lipids [PR] with formula: C35H62O3"],
        "LMPR04000004 (bacteriohopane-32,33,34,35-tetrol)": ["C35H62O4", "Prenol Lipids [PR] with formula: C35H62O4"],
        "LMPR04000006 (bacteriohopane-31,32,33,34,35-pentol)": ["C35H62O5", "Prenol Lipids [PR] with formula: C35H62O5"],
        "LMPR04000005 (35-aminobacteriohopane-32,33,34-triol)": ["C35H63NO3", "Prenol Lipids [PR] with formula: C35H63NO3"],
        "LMPR04000007 (35-aminobacteriohopane-31,32,33,34-tetrol)": ["C35H63NO4", "Prenol Lipids [PR] with formula: C35H63NO4"],
        "LMPR04000009 (35-aminobacteriohopane-30,31,32,33,34-pentol)": ["C35H63NO5", "Prenol Lipids [PR] with formula: C35H63NO5"],
        "LMPR01070224 (OH-Diaponeurosporene glucoside ester)": ["C36H54O6", "Prenol Lipids [PR] with formula: C36H54O6"],
        "LMPR0104330002 (phorbol 13-acetate 12-myristate)": ["C36H56O8", "Prenol Lipids [PR] with formula: C36H56O8"],
        "LMPR0106150003 (oleanolic acid 3-O-beta-D-glucosiduronic acid)": ["C36H56O9", "Prenol Lipids [PR] with formula: C36H56O9"],
        "LMPR0104350004 (Fusicoccin A)": ["C36H58O12", "Prenol Lipids [PR] with formula: C36H58O12"],
        "LMPR01090013 (all-trans-retinyl Palmitate); LMPR01090052 (11-cis-retinyl palmitate)": ["C36H60O2", "Prenol Lipids [PR] with formula: C36H60O2"],
        "LMPR04000025 (2-methyl-32,35-anhydrobacteriohopanetetrol)": ["C36H62O3", "Prenol Lipids [PR] with formula: C36H62O3"],
        "LMPR04000014 (bacteriohopane-32,33, 34-triol-35-carbamate)": ["C36H63NO5", "Prenol Lipids [PR] with formula: C36H63NO5"],
        "LMPR04000010 (2-methylbacteriohopane-32,33,34,35-tetrol)": ["C36H64O4", "Prenol Lipids [PR] with formula: C36H64O4"],
        "LMPR04000013 (bacteriohopane-32,33-diol-34,35-dicarbamate)": ["C37H64N2O6", "Prenol Lipids [PR] with formula: C37H64N2O6"],
        "LMPR01090016 (all-trans-retinyl linolate)": ["C38H58O2", "Prenol Lipids [PR] with formula: C38H58O2"],
        "LMPR01090015 (all-trans-retinyl oleate)": ["C38H62O2", "Prenol Lipids [PR] with formula: C38H62O2"],
        "LMPR01090014 (all-trans-retinyl stearate)": ["C38H64O2", "Prenol Lipids [PR] with formula: C38H64O2"],
        "LMPR01070008 (Pyrrhoxanthin)": ["C39H48O6", "Prenol Lipids [PR] with formula: C39H48O6"],
        "LMPR01070007 (Peridinin)": ["C39H50O7", "Prenol Lipids [PR] with formula: C39H50O7"],
        "LMPR02010002 (Coenzyme Q6)": ["C39H58O4", "Prenol Lipids [PR] with formula: C39H58O4"],
        "LMPR01070124 (Isorenieratene/ (Leprotene))": ["C40H48", "Prenol Lipids [PR] with formula: C40H48"],
        "LMPR01070052 (7,8,7',8'-Tetradehydroastaxanthin)": ["C40H48O4", "Prenol Lipids [PR] with formula: C40H48O4"],
        "LMPR01070025 (Anhydroeschscholtzxanthin)": ["C40H50", "Prenol Lipids [PR] with formula: C40H50"],
        "LMPR01070024 (Rhodoxanthin); LMPR01070280 (Rhodoxanthin)": ["C40H50O2", "Prenol Lipids [PR] with formula: C40H50O2"],
        "LMPR01070073 (4-Ketoalloxanthin)": ["C40H50O3", "Prenol Lipids [PR] with formula: C40H50O3"],
        "LMPR01070051 (7,8-Didehydroastaxanthin); LMPR01070077 (4-Keto-4'-hydroxyalloxanthin)": ["C40H50O4", "Prenol Lipids [PR] with formula: C40H50O4"],
        "LMPR01070163 (Chlorobactene); LMPR01070022 (Bisdehydro-beta-carotene/ Tetradehydro-beta-carotene); LMPR01070123 (beta-Isorenieratene); LMPR01070127 (Bisdehydrolycopene/ Tetradehydrolycopene)": ["C40H52", "Prenol Lipids [PR] with formula: C40H52"],
        "LMPR01070026 (Monoanhydroescholtzxanthin)": ["C40H52O", "Prenol Lipids [PR] with formula: C40H52O"],
        "LMPR01070053 (Alloxanthin/ Tetradehydrozeaxanthin / (Cynthiaxanthin)/ (Pectenoxanthin)); LMPR01070279 (Neurosporaxanthin); LMPR01070264 (Canthaxanthin); LMPR01070044 (Eschscholtzxanthone); LMPR01070197 (epsilon,epsilon-Carotene-3,3'-dione)": ["C40H52O2", "Prenol Lipids [PR] with formula: C40H52O2"],
        "LMPR01070096 (Phoenicoxanthin/ Adonirubin/ 3-Hydroxycanthaxanthin); LMPR01070068 (Pectenolone); LMPR01070071 ((3S,4R,3'R)-4-Hydroxyalloxanthin); LMPR01070072 ((3S,4S,3'R)-4-Hydroxyalloxanthin)": ["C40H52O3", "Prenol Lipids [PR] with formula: C40H52O3"],
        "LMPR01070020 (meso-Astaxanthin/ (3S,3'R)-Astaxanthin); LMPR01070215 (Phillipsiaxanthin/ 1,1'-(OH)2-2,2'-diketo-3,4,3',4'-tetradehydrolycopene); LMPR01070080 (Mytiloxanthinone); LMPR01070082 (4-Ketocapsanthin); LMPR01070263 (Astaxanthin); LMPR01070075 (4,4'-Dihydroxyalloxanthin); LMPR01070076 (4-Keto-4'-hydroxydiatoxanthin); LMPR01070079 (Amarouciaxanthin B/ Sidnyaxanthin)": ["C40H52O4", "Prenol Lipids [PR] with formula: C40H52O4"],
        "LMPR01070066 (4-Oxomytiloxanthin)": ["C40H52O5", "Prenol Lipids [PR] with formula: C40H52O5"],
        "LMPR01070160 (4-Ketonostoxanthin 3-sulfate)": ["C40H53NaO8S", "Prenol Lipids [PR] with formula: C40H53NaO8S"],
        "LMPR01070021 (3,4-Didehydro-beta-carotene); LMPR01070088 (Torulene); LMPR01070164 (1',2'-Dihydrochlorobactene); LMPR01070087 (3,4-Dehydrolycopene/ 3,4-Didehydrolycopene)": ["C40H54", "Prenol Lipids [PR] with formula: C40H54"],
        "LMPR01070060 (Echinenone/ (Myxoxanthin)); LMPR01070165 (OH-Chlorobactene); LMPR01070081 (alpha-Echinenone/ Phoenicopterone); LMPR01070171 (4-Keto-gamma-carotene/ Keto-gamma-carotene); LMPR01070181 (1-OH-3,4,3',4'-Tetradehydrolycopene)": ["C40H54O", "Prenol Lipids [PR] with formula: C40H54O"],
        "LMPR01070161 (Deoxyflexixanthin/ Keto-myxocoxanthin); LMPR01070196 (3'-Hydroxy-epsilon,epsilon-caroten-3-one/ 3'-OH-epsilon,epsilon-Caroten-3-one/ (3-Hydroxy-epsilon,epsilon-caroten-3'-one)); LMPR01070023 (Eschscholtzxanthin); LMPR01070098 (3'-Hydroxyechinenone/ 3'-OH-Echinenone); LMPR01070270 (Eschscholtzxanthin); LMPR01070097 (3-Hydroxyechinenone/ 3-OH-Echinenone); LMPR01070198 (3'-Dehydrolutein/ Philosamiaxanthin/ 3-Hydroxy-beta,epsilon-caroten-3'-one); LMPR01070054 (Diatoxanthin/ 7,8-Didehydrozeaxanthin)": ["C40H54O2", "Prenol Lipids [PR] with formula: C40H54O2"],
        "LMPR01070027 (Fritschiellaxanthin/ (3S,3'R,6'R)-4-Ketolutein); LMPR01070069 (Pectenol A/ (Pectenol)); LMPR01070191 (1',2'-Dihydro-1',2'-dihydroxy-4-ketotoruelene/ (4-Ketophleixanthophyll)); LMPR01070195 (7,8-Didehydrodeepoxysalmoxanthin/ Gobiusxanthin); LMPR01070028 (alpha-Doradexanthin/ (3S,3'S,6'R)-4-Ketolutein); LMPR01070102 (Flexixanthin/ 4-Oxosaproxanthin); LMPR01070016 (Adonixanthin/ 4-Ketozeaxanthin); LMPR01070045 (4-Ketolutein D); LMPR01070046 (4-Ketolutein F); LMPR01070216 (1,1'-(OH)2-2-keto-3,4,3',4'-tetradehydrolycopene); LMPR01070070 (Pectenol B); LMPR01070182 (Deinoxanthin)": ["C40H54O3", "Prenol Lipids [PR] with formula: C40H54O3"],
        "LMPR01070103 (Ketomyxol/ 2'-Hydroxyflexixanthin); LMPR01070010 (Mytiloxanthin); LMPR01070006 (Halocynthiaxanthin); LMPR01070074 (4,4'-Dihydroxydiatoxanthin); LMPR01070146 (Erythroxanthin)": ["C40H54O4", "Prenol Lipids [PR] with formula: C40H54O4"],
        "LMPR01070106 (4-Ketonostoxanthin); LMPR01070067 (4-Hydroxymytiloxanthin); LMPR01070203 (Uriolide); LMPR01070078 (Amarouciaxanthin A)": ["C40H54O5", "Prenol Lipids [PR] with formula: C40H54O5"],
        "LMPR01070147 (Erythroxanthin sulfate)": ["C40H54O7S", "Prenol Lipids [PR] with formula: C40H54O7S"],
        "LMPR01070105 (Nostoxanthin sulfate)": ["C40H55NaO7S", "Prenol Lipids [PR] with formula: C40H55NaO7S"],
        "LMPR01070220 (1,2-Dihydro-3,4-dehydrolycopene); LMPR01070260 (gamma-Carotene); LMPR01070266 (delta-Carotene); LMPR01070126 (epsilon-Carotene/ epsilon,epsilon-Carotene); LMPR01070011 (alpha-Carotene/ beta,epsilon-Carotene); LMPR01070258 (alpha-Carotene); LMPR01070257 (Lycopene); LMPR01070001 (Beta-carotene)": ["C40H56", "Prenol Lipids [PR] with formula: C40H56"],
        "LMPR01070292 ((5S,6R)-beta-carotene 5,6-epoxide); LMPR01070276 (Lycoxanthin); LMPR01070277 (Citroxanthin); LMPR01070268 (alpha-Cryptoxanthin); LMPR01070115 (1-Hydroxy-3,4-didehydrolycopene/ 3,4-Dehydrorhodopin/ 3,4-Didehydrorhodopin); LMPR01070281 (Rubixanthin); LMPR01070267 (beta-Carotene 5,6-epoxide); LMPR01070269 (beta-Cryptoxanthin); LMPR01070177 (1-OH-3',4'-Didehydrolycopene)": ["C40H56O", "Prenol Lipids [PR] with formula: C40H56O"],
        "LMPR01070186 (Plectaniaxanthin/ (2'R)-Plectaniaxanthin); LMPR01070029 (Lutein F); LMPR01070152 (Demethylspheroidenone); LMPR01070273 (Lactucaxanthin); LMPR01070274 (Lutein); LMPR01070035 (Tunaxanthin E); LMPR01070289 (15Z-beta,beta-Carotene-3R,3R'-diol); LMPR01070039 (Tunaxanthin B/ Oxyxanthin 51); LMPR01070013 (meso-Zeaxanthin/ (3R,3'S)-Zeaxanthin); LMPR01070261 (Zeaxanthin); LMPR01070303 (lycophyll); LMPR01070049 (Cryptocapsin); LMPR01070040 (Tunaxanthin G); LMPR01070043 (Lutein G); LMPR01070179 (1,1'-(OH)2-3,4,3',4'-Tetradehydrolycopene); LMPR01070172 (1'-OH-4-Keto-gamma-carotene/ (Carotenoid K)); LMPR01070288 (13Z-beta,beta-Carotene-3R,3R'-diol); LMPR01070038 (Tunaxanthin J/ Chiriquixanthin B); LMPR01070030 (Lutein B/ Calthaxanthin/ 3'-Epilutein); LMPR01070031 (Lutein D); LMPR01070033 (Tunaxanthin H); LMPR01070034 (Tunaxanthin I/ Chiriquixanthin A); LMPR01070036 (Tunaxanthin C/ Oxyxantin 58/ (ent. Chiriquixanthin B)); LMPR01070037 (Tunaxanthin D); LMPR01070185 (Deoxymyxol/ ((2'S)-Plectaniaxanthin))": ["C40H56O2", "Prenol Lipids [PR] with formula: C40H56O2"],
        "LMPR01070064 (Cucurbitaxanthin A); LMPR01070194 (Deepoxysalmoxanthin); LMPR01070156 (Loroxanthin/ 19-Hydroxylutein); LMPR01070271 (Flavoxanthin); LMPR01070275 (Lutein 5,6-epoxide); LMPR01070302 ((3S,5R,8R,3'R)-mutatoxanthin); LMPR01070262 (Antheraxanthin); LMPR01070265 (Capsanthin); LMPR01070202 (Micromonal); LMPR01070134 (Caloxanthin); LMPR01070183 (Myxol)": ["C40H56O3", "Prenol Lipids [PR] with formula: C40H56O3"],
        "LMPR01070104 (Nostoxanthin); LMPR01070201 (Preprasinoxanthin); LMPR01070200 (Prasinoxanthin); LMPR01070290 (all-trans-neoxanthin); LMPR01070063 (Cycloviolaxanthin); LMPR01070050 (Capsanthin 3,6-epoxide); LMPR01070065 (Cucurbitaxanthin B); LMPR01070158 (Siphonaxanthin); LMPR01070301 (Luteoxanthin); LMPR01070284 (9-cis-Violaxanthin); LMPR01070061 (Neoxanthin); LMPR01070291 (9'-cis-neoxanthin); LMPR01070048 (Capsorubin); LMPR01070193 (Salmoxanthin/ Trollixanthin); LMPR01070190 (4-Hydroxymyxol/ 4-OH-myxol/ (Aphanizophyll)); LMPR01070283 (9'-cis-Neoxanthin); LMPR01070282 (Violaxanthin); LMPR01070187 (Oscillol)": ["C40H56O4", "Prenol Lipids [PR] with formula: C40H56O4"],
        "LMPR01070204 (6'-Hydroxysiphonaxanthin); LMPR01070055 (Fucoxanthinol)": ["C40H56O5", "Prenol Lipids [PR] with formula: C40H56O5"],
        "LMPR01070148 (Caloxanthin sulfate)": ["C40H56O6S", "Prenol Lipids [PR] with formula: C40H56O6S"],
        "LMPR01070199 (alpha-Zeacarotene/ 7',8'-Dihydro-delta-carotene); LMPR01070091 (7,8-Dihydro-beta-carotene); LMPR01070086 (Neurosporene); LMPR01070259 (beta-Zeacarotene); LMPR01070219 (1,2-Dihydrolycopene); LMPR01070162 (1',2'-Dihydro-gamma-carotene); LMPR01070285 (alpha-Zeacarotene)": ["C40H58", "Prenol Lipids [PR] with formula: C40H58"],
        "LMPR01070117 (3-Hydroxy-beta-zeacarotene/ 3-OH-beta-Zeacarotene); LMPR01070114 (Rhodopin/ OH-Lycopene); LMPR01070120 (Demethylspheroidene/ (Demethylated spheroidene)); LMPR01070118 (1'-Hydroxy-gamma-carotene/ 1'-OH-gamma-Carotene/ (Carotenoid B))": ["C40H58O", "Prenol Lipids [PR] with formula: C40H58O"],
        "LMPR01070092 (Parasiloxanthin/ 7,8-Dihydrozeaxanthin); LMPR01070178 (3,1'-(OH)2-gamma-Carotene); LMPR01070180 (1,1'-(OH)2-3,4-Didehydrolycopene)": ["C40H58O2", "Prenol Lipids [PR] with formula: C40H58O2"],
        "LMPR01070217 (OH-Demethylspheroidenone)": ["C40H58O3", "Prenol Lipids [PR] with formula: C40H58O3"],
        "LMPR01070296 (9,9',15-tri-cis-zeta-carotene); LMPR01070085 (zeta-Carotene/ Symmetrical zeta-Carotene/ 7,8,7',8'-Tetrahydrolycopene); LMPR01070129 (Asymmetrical zeta-carotene/ Asym. zeta-carotene/ 7,8,11,12-Tetrahydrolycopene); LMPR01070256 (zeta-Carotene); LMPR01070133 (Tetrahydro-beta-carotene/ eta-Carotene); LMPR01070295 (9,9'-di-cis-zeta-carotene); LMPR01070218 (1,2-Dihydroneurosporene); LMPR01070221 (1,2,1',2'-Tetrahydrolycopene)": ["C40H60", "Prenol Lipids [PR] with formula: C40H60"],
        "LMPR01070113 (Chloroxanthin/ Hydroxyneurosporene/ OH-Neurosporene)": ["C40H60O", "Prenol Lipids [PR] with formula: C40H60O"],
        "LMPR01070116 (Dihydroxylycopene/ OH-Rhodopin); LMPR01070093 (Dihydroparasiloxanthin/ 7,8,7',8'-Tetrahydrozeaxanthin); LMPR01070213 (OH-Demethylspheroidene)": ["C40H60O2", "Prenol Lipids [PR] with formula: C40H60O2"],
        "LMPR01070299 (all-trans-phytofluene)": ["C40H62", "Prenol Lipids [PR] with formula: C40H62"],
        "LMPR01070212 (Dihydroxyneurosporene/ OH-Chloroxanthin)": ["C40H62O2", "Prenol Lipids [PR] with formula: C40H62O2"],
        "LMPR04000012 (adenosylhopane)": ["C40H63N5O3", "Prenol Lipids [PR] with formula: C40H63N5O3"],
        "LMPR01070255 (cis-Phytoene); LMPR01070254 (Phytoene)": ["C40H64", "Prenol Lipids [PR] with formula: C40H64"],
        "LMPR01070084 (Phytofluene)": ["C40H68", "Prenol Lipids [PR] with formula: C40H68"],
        "LMPR01070253 (Prephytoene diphosphate); LMPR01070226 (Octaprenyl diphosphate, trans-Octaprenyl diphosphate)": ["C40H68O7P2", "Prenol Lipids [PR] with formula: C40H68O7P2"],
        "LMPR01070286 (Beta-isorenieratane)": ["C40H72", "Prenol Lipids [PR] with formula: C40H72"],
        "LMPR04000015 (N-ornithinyl-35-aminobacteriohopane-32,33,34-triol)": ["C40H73N3O4", "Prenol Lipids [PR] with formula: C40H73N3O4"],
        "LMPR01070287 (Chlorobactane)": ["C40H74", "Prenol Lipids [PR] with formula: C40H74"],
        "LMPR02030001 (Vitamin K2)": ["C41H56O2", "Prenol Lipids [PR] with formula: C41H56O2"],
        "LMPR01070145 (Bacteriorubixanthinal)": ["C41H56O3", "Prenol Lipids [PR] with formula: C41H56O3"],
        "LMPR01070135 (Anhydrorhodovibrin)": ["C41H58O", "Prenol Lipids [PR] with formula: C41H58O"],
        "LMPR01070121 (Spheroidenone); LMPR01070137 (Hydroxyspirilloxanthin/ OH-Spirilloxanthin/ (Monometylated spirilloxanthin)); LMPR01070144 (Bacteriorubuxanthin)": ["C41H58O2", "Prenol Lipids [PR] with formula: C41H58O2"],
        "LMPR01070138 (Dihydroanhydrorhodovibrine/ Dihydromethoxylycopene); LMPR01070119 (Spheroidene)": ["C41H60O", "Prenol Lipids [PR] with formula: C41H60O"],
        "LMPR01070155 (3,4-Dihydrospheroidenone); LMPR01070136 (Rhodovibrin)": ["C41H60O2", "Prenol Lipids [PR] with formula: C41H60O2"],
        "LMPR01070151 (OH-Spheroidenone)": ["C41H60O3", "Prenol Lipids [PR] with formula: C41H60O3"],
        "LMPR01070149 (Dihydrospheroidene/ Methoxyneurosporene)": ["C41H62O", "Prenol Lipids [PR] with formula: C41H62O"],
        "LMPR01070150 (OH-Spheroidene); LMPR01070139 (3',4'-Dihydrorhodovibrin)": ["C41H62O2", "Prenol Lipids [PR] with formula: C41H62O2"],
        "LMPR04000018 (bacteriohopanetetrol cyclitol); LMPR04000011 (bacteriohopane-,32,33,34-triol-35-cyclitol)": ["C41H73NO8", "Prenol Lipids [PR] with formula: C41H73NO8"],
        "LMPR04000008 (bacteriohopane-31,32,33,34-tetrol-35-cyclitol)": ["C41H73NO9", "Prenol Lipids [PR] with formula: C41H73NO9"],
        "LMPR01070154 (Diketospirilloxanthin/ 2,2'-Diketospirilloxanthin)": ["C42H56O4", "Prenol Lipids [PR] with formula: C42H56O4"],
        "LMPR01070153 (Ketospirilloxanthin)": ["C42H58O3", "Prenol Lipids [PR] with formula: C42H58O3"],
        "LMPR01070272 (Fucoxanthin); LMPR01070300 (fucoxanthin)": ["C42H58O6", "Prenol Lipids [PR] with formula: C42H58O6"],
        "LMPR01070122 (Spirilloxanthin)": ["C42H60O2", "Prenol Lipids [PR] with formula: C42H60O2"],
        "LMPR01070207 (Neurosporaxanthin beta-D-glucopyranoside)": ["C42H60O7", "Prenol Lipids [PR] with formula: C42H60O7"],
        "LMPR0106150008 (glycyrrhizinic acid); LMPR0106150013 (Glycyrrhizin)": ["C42H62O16", "Prenol Lipids [PR] with formula: C42H62O16"],
        "LMPR01070176 (3,4-Dihydrospirilloxanthin)": ["C42H62O2", "Prenol Lipids [PR] with formula: C42H62O2"],
        "LMPR01070089 (gamma-Carotene/ beta,psi-Carotene)": ["C42H63", "Prenol Lipids [PR] with formula: C42H63"],
        "LMPR0106150006 (gypsogenin 3-O-rhamnosylglucosiduronic acid)": ["C42H64O14", "Prenol Lipids [PR] with formula: C42H64O14"],
        "LMPR01070140 (3,4,3',4'-Tetrahydrospirilloxanthin)": ["C42H64O2", "Prenol Lipids [PR] with formula: C42H64O2"],
        "LMPR0106150009 (bayogenin 3-O-cellobioside)": ["C42H68O15", "Prenol Lipids [PR] with formula: C42H68O15"],
        "LMPR04000019 (bacteriohopane-,32,33,34-triol-35-cyclitolguanine)": ["C42H75N3O8", "Prenol Lipids [PR] with formula: C42H75N3O8"],
        "LMPR03030007 (all-trans-nonaprenyl diphosphate)": ["C45H76O7P2", "Prenol Lipids [PR] with formula: C45H76O7P2"],
        "LMPR03040008 (Glycinoprenol-9)": ["C45H80O", "Prenol Lipids [PR] with formula: C45H80O"],
        "LMPR01070058 (19'-Hexanoyloxyisomytiloxanthin); LMPR01070166 (OH-Chlorobactene glucoside)": ["C46H64O6", "Prenol Lipids [PR] with formula: C46H64O6"],
        "LMPR01070059 (19'-Butanoyloxyfucoxanthin); LMPR01070101 (Adonixanthin 3'-beta-D-glucoside/ Adonixanthin 3'-glucoside); LMPR01070017 (Adonixanthin 3-glucoside)": ["C46H64O8", "Prenol Lipids [PR] with formula: C46H64O8"],
        "LMPR01070057 (19'-Hexanoyloxyfucoxanthinol); LMPR01070225 (Phleixanthophyll/ Deoxymyxol 1'-glucoside)": ["C46H66O7", "Prenol Lipids [PR] with formula: C46H66O7"],
        "LMPR01070184 (Myxol glycoside/ (Myxoxanthophyll))": ["C46H66O8", "Prenol Lipids [PR] with formula: C46H66O8"],
        "LMPR01070168 (1'-OH-gamma-carotene glucoside/ (Carotenoids B-G)); LMPR01070130 (Rhodopin beta-D-glucoside/ Rhodopin glucoside)": ["C46H68O6", "Prenol Lipids [PR] with formula: C46H68O6"],
        "LMPR04000016 (N-tryptophanyl-35-aminobacteriohopane-32,33,34-triol)": ["C46H73N3O4", "Prenol Lipids [PR] with formula: C46H73N3O4"],
        "LMPR0104390001 (Paclitaxel)": ["C47H51NO14", "Prenol Lipids [PR] with formula: C47H51NO14"],
        "LMPR01070015 (Astaxanthin glucoside)": ["C47H66O9", "Prenol Lipids [PR] with formula: C47H66O9"],
        "LMPR01070167 (OH-Chlorobactene glucoside ester)": ["C47H68O6", "Prenol Lipids [PR] with formula: C47H68O6"],
        "LMPR01070173 (1'-Hydroxy-4-keto-gamma-carotene glucoside/ 1'-OH-4-Keto-gamma-carotene glucoside/ (Carotenoid K-G))": ["C47H70O7", "Prenol Lipids [PR] with formula: C47H70O7"],
        "LMPR01070056 (19'-Hexanoyloxyfucoxanthin)": ["C48H68O8", "Prenol Lipids [PR] with formula: C48H68O8"],
        "LMPR02010005 (Coenzyme Q8)": ["C49H74O4", "Prenol Lipids [PR] with formula: C49H74O4"],
        "LMPR04000017 (N-hexadecanoyl-35-aminobacteriohopane-32,33,34-triol)": ["C49H91NO4", "Prenol Lipids [PR] with formula: C49H91NO4"],
        "LMPR02030027 (2-demethylmenaquinone-8)": ["C50H70O2", "Prenol Lipids [PR] with formula: C50H70O2"],
        "LMPR01080008 (Decaprenoxanthin)": ["C50H72", "Prenol Lipids [PR] with formula: C50H72"],
        "LMPR03020007 (all-trans decaprenyl phosphate); LMPR03020008 (Decaprenyl Diphosphate)": ["C50H83O4P", "Prenol Lipids [PR] with formula: C50H83O4P"],
        "LMPR03030009 (di-trans,poly-cis-decaprenyl diphosphate)": ["C50H84O7P2", "Prenol Lipids [PR] with formula: C50H84O7P2"],
        "LMPR01070100 (Astaxanthin diglucoside/ Astaxanthin beta-D-diglucoside)": ["C52H72O14", "Prenol Lipids [PR] with formula: C52H72O14"],
        "LMPR01070099 (Zeaxanthin diglucoside/ Zeaxanthin beta-D-diglucoside)": ["C52H76O12", "Prenol Lipids [PR] with formula: C52H76O12"],
        "LMPR01070188 (Oscillol diglycoside/ Oacillol bisglycoside/ (Oscillaxanthin))": ["C52H76O14", "Prenol Lipids [PR] with formula: C52H76O14"],
        "LMPR01070157 (Loroxanthin ester/ Loroxanthin dodecenoate)": ["C52H76O4", "Prenol Lipids [PR] with formula: C52H76O4"],
        "LMPR01070159 (Siphonaxanthin ester/ Siphonaxanthin dodecenoate/ (Siphonein))": ["C52H76O5", "Prenol Lipids [PR] with formula: C52H76O5"],
        "LMPR02010036 (3-demethylubiquinone-9)": ["C53H80O4", "Prenol Lipids [PR] with formula: C53H80O4"],
        "LMPR01070205 (6'-Hydroxysiphonaxanthin ester/ 6'-Hydroxysiphonaxanthin dodecenoate/ 6'-Hydroxysiphonaxanthin 19-(trans-delta2-dodecenoate))": ["C53H80O6", "Prenol Lipids [PR] with formula: C53H80O6"],
        "LMPR02010004 (Coenzyme Q9)": ["C54H82O4", "Prenol Lipids [PR] with formula: C54H82O4"],
        "LMPR03010005 (Undecaprenol); LMPR03010007 (undecaprenol)": ["C55H90O", "Prenol Lipids [PR] with formula: C55H90O"],
        "LMPR03020001 (undecaprenyl phosphate); LMPR03020006 (all-trans-Undecaprenyl phosphate)": ["C55H91O4P", "Prenol Lipids [PR] with formula: C55H91O4P"],
        "LMPR03030004 (undecaprenyl trihydrogen diphosphate); LMPR03030008 (di-trans,poly-cis-undecaprenyl diphosphate)": ["C55H92O7P2", "Prenol Lipids [PR] with formula: C55H92O7P2"],
        "LMPR04000020 (bacteriohopane-,32,33,34-triol-35-(N-(9-cyclohexyl-nonanoyl))-glucosamine)": ["C56H99NO9", "Prenol Lipids [PR] with formula: C56H99NO9"],
        "LMPR02010033 (2-decaprenyl-6-methoxy-1,4-benzoquinone)": ["C57H86O3", "Prenol Lipids [PR] with formula: C57H86O3"],
        "LMPR02010034 (3-decaprenyl-4,5-dihydroxybenzoic acid)": ["C57H86O4", "Prenol Lipids [PR] with formula: C57H86O4"],
        "LMPR02010032 (2-decaprenyl-6-methoxy-3-methyl-1,4-benzoquinone)": ["C58H88O3", "Prenol Lipids [PR] with formula: C58H88O3"],
        "LMPR02010035 (3-decaprenyl-4-hydroxy-5-methoxybenzoic acid); LMPR02010031 (2-decaprenyl-5-hydroxy-6-methoxy-3-methyl-1,4-benzoquinone)": ["C58H88O4", "Prenol Lipids [PR] with formula: C58H88O4"],
        "LMPR02010001 (Coenzyme Q10)": ["C59H90O4", "Prenol Lipids [PR] with formula: C59H90O4"],
        "LMPR01010001 (dimethylallyl-diphosphate); LMPR01010008 (Isopentenyl-diphosphate)": ["C5H12O7P2", "Prenol Lipids [PR] with formula: C5H12O7P2"],
        "LMPR01010009 ((2E)-4-hydroxy-3-methylbut-2-en-1-yl trihydrogen diphosphate)": ["C5H12O8P2", "Prenol Lipids [PR] with formula: C5H12O8P2"],
        "LMPR03020005 (4-amino-4-deoxy-alpha-L-arabinopyranosyl undecaprenyl phosphate)": ["C60H100NO7P", "Prenol Lipids [PR] with formula: C60H100NO7P"],
        "LMPR03020002 (Undecaprenyl phosphate mannose)": ["C61H101O9P", "Prenol Lipids [PR] with formula: C61H101O9P"],
        "LMPR03030010 (alpha-D-galactosyl undecaprenyl diphosphate)": ["C61H102O12P2", "Prenol Lipids [PR] with formula: C61H102O12P2"],
        "LMPR01070192 (Salinixanthin/ 1',2'-Dihydro-1',2'-dihydroxy-4-ketotorulene 1'-glucoside ester); LMPR01070108 (Thermozeaxanthin-15/ Zeaxanthin glucoside ester)": ["C61H94O8", "Prenol Lipids [PR] with formula: C61H94O8"],
        "LMPR01070109 (Thermozeaxanthin-17/ Zeaxanthin glucoside ester)": ["C63H98O8", "Prenol Lipids [PR] with formula: C63H98O8"],
        "LMPR03030002 (Undecaprenyl diphosphate-GlcNAc-ManNAcA)": ["C71H116N2O18P2", "Prenol Lipids [PR] with formula: C71H116N2O18P2"],
        "LMPR01070111 (Thermobiszeaxanthin-13-15/ Zeaxanthin diglucoside diester)": ["C80H128O14", "Prenol Lipids [PR] with formula: C80H128O14"],
        "LMPR01070112 (Thermobiszeaxanthin-15-15/ Zeaxanthin diglucoside diester)": ["C82H132O14", "Prenol Lipids [PR] with formula: C82H132O14"],
        "LMPR01070110 (Thermobiszeaxanthin-13-13/ Zeaxanthin diglucoside diester)": ["C82H134O14", "Prenol Lipids [PR] with formula: C82H134O14"],
        "LMPR03070002 (Dolichol-17)": ["C85H140O", "Prenol Lipids [PR] with formula: C85H140O"],
        "LMPR03070003 (Dolichol-18)": ["C90H148O", "Prenol Lipids [PR] with formula: C90H148O"],
        "LMPR03030003 (Lipid II (undecaprenyl diphosphate-MurNAc-pentapeptide-GlcNAc))": ["C95H156N8O28P2", "Prenol Lipids [PR] with formula: C95H156N8O28P2"],
        "LMPR03070001 (Dolichol-19)": ["C95H156O", "Prenol Lipids [PR] with formula: C95H156O"],
        "LMPR03080001 (Dolichyl-19 phosphate)": ["C95H157O4P", "Prenol Lipids [PR] with formula: C95H157O4P"],
    },
    'Fatty Acyls [FA]': {
        "LMFA01030783": ["C10H10O2", "Fatty Acyls [FA] with formula: C10H10O2"],
        "LMFA01030710; LMFA01030711; LMFA01030712; LMFA01030713; LMFA01060086": ["C10H10O3", "Fatty Acyls [FA] with formula: C10H10O3"],
        "LMFA01170005; LMFA01170004; LMFA01170003": ["C10H10O4", "Fatty Acyls [FA] with formula: C10H10O4"],
        "LMFA06000061": ["C10H12O", "Fatty Acyls [FA] with formula: C10H12O"],
        "LMFA01030456": ["C10H12O2", "Fatty Acyls [FA] with formula: C10H12O2"],
        "LMFA01030709; LMFA01030708; LMFA01030707": ["C10H12O3", "Fatty Acyls [FA] with formula: C10H12O3"],
        "LMFA06000060": ["C10H14O", "Fatty Acyls [FA] with formula: C10H14O"],
        "LMFA01030215; LMFA01030216": ["C10H14O2", "Fatty Acyls [FA] with formula: C10H14O2"],
        "LMFA01060085; LMFA01030579": ["C10H14O3", "Fatty Acyls [FA] with formula: C10H14O3"],
        "LMFA08030003": ["C10H15NO4", "Fatty Acyls [FA] with formula: C10H15NO4"],
        "LMFA06000143; LMFA06000146; LMFA06000057; LMFA06000059; LMFA06000058; LMFA05000123": ["C10H16O", "Fatty Acyls [FA] with formula: C10H16O"],
        "LMFA01030784; LMFA06000144; LMFA01030202; LMFA01030203; LMFA01030200; LMFA01030201; LMFA01030206; LMFA01030207; LMFA01030204; LMFA01030205; LMFA01030208; LMFA01030209; LMFA01030108; LMFA01030459; LMFA01030458; LMFA01030101 (cis, cis-stillingic acid); LMFA01030102; LMFA01030105; LMFA01030104; LMFA01030214; LMFA01030211; LMFA01030210; LMFA01030213; LMFA01030212; LMFA01030462; LMFA01030463; LMFA01030460; LMFA01030461; LMFA05000239; LMFA05000235; LMFA01030440; LMFA06000130; LMFA01030188 (Aleprestic acid); LMFA05000241; LMFA05000240; LMFA01030103 (trans, cis-stillingic acid); LMFA01030457; LMFA01030107; LMFA01030106": ["C10H16O2", "Fatty Acyls [FA] with formula: C10H16O2"],
        "LMFA01060084; LMFA01060083; LMFA01060082; LMFA01060179 ((3R)-3-isopropenyl-6-oxoheptanoic acid); LMFA01060180 ((3S)-3-isopropenyl-6-oxoheptanoic acid)": ["C10H16O3", "Fatty Acyls [FA] with formula: C10H16O3"],
        "LMFA01060079; LMFA01060080; LMFA01170032; LMFA01170045; LMFA01170044": ["C10H16O4", "Fatty Acyls [FA] with formula: C10H16O4"],
        "LMFA01060176": ["C10H17NO4", "Fatty Acyls [FA] with formula: C10H17NO4"],
        "LMFA06000148; LMFA06000147; LMFA06000053; LMFA06000056; LMFA06000055; LMFA06000054; LMFA05000127; LMFA05000141": ["C10H18O", "Fatty Acyls [FA] with formula: C10H18O"],
        "LMFA01030780 (cis-dec-2-enoic acid); LMFA05000236; LMFA01030029 (2-decylenic acid); LMFA01030031 (Obtusilic acid); LMFA01030030 (3-decylenic acid); LMFA01030033 (Caproleic acid); LMFA01030032 (Isodecenoic acid); LMFA01020128; LMFA01020129; LMFA01020104 (Citronellic acid); LMFA01020105; LMFA01030198; LMFA01030199; LMFA05000099 ((2E)-2,6-dimethylocta-2,7-diene-1,6-diol); LMFA05000243": ["C10H18O2", "Fatty Acyls [FA] with formula: C10H18O2"],
        "LMFA01050250; LMFA01060029 (4-oxo capric acid); LMFA01060028 (3-oxo capric acid); LMFA01060078; LMFA01060001 (2-oxo capric acid); LMFA01050157; LMFA01050158; LMFA01050159; LMFA05000018; LMFA01060081; LMFA01050371 (6-hydroxy-3-isopropenylheptanoic acid); LMFA01050160; LMFA01050249; LMFA01060030 (5-oxo capric acid); LMFA01060031 (6-oxo capric acid); LMFA01060032 (8-oxo capric acid); LMFA01060033 (9-oxo capric acid)": ["C10H18O3", "Fatty Acyls [FA] with formula: C10H18O3"],
        "LMFA01170006 (Sebacic acid)": ["C10H18O4", "Fatty Acyls [FA] with formula: C10H18O4"],
        "LMFA01170076 (2-hydroxy-decanedioic acid); LMFA01170092 (3-hydroxy-sebacic acid)": ["C10H18O5", "Fatty Acyls [FA] with formula: C10H18O5"],
        "LMFA01090002; LMFA01090003; LMFA01090004": ["C10H19BrO2", "Fatty Acyls [FA] with formula: C10H19BrO2"],
        "LMFA07070005": ["C10H19NO4", "Fatty Acyls [FA] with formula: C10H19NO4"],
        "LMFA06000052 (Capraldehyde); LMFA05000142; LMFA05000140; LMFA05000031; LMFA05000043; LMFA05000042; LMFA05000139": ["C10H20O", "Fatty Acyls [FA] with formula: C10H20O"],
        "LMFA01020247; LMFA01020246; LMFA01020089 (2-methyl nonaoic acid); LMFA01020154; LMFA01010010 (Capric acid); LMFA05000245": ["C10H20O2", "Fatty Acyls [FA] with formula: C10H20O2"],
        "LMFA01050029 (2-hydroxy capric acid); LMFA01050153; LMFA01050154; LMFA01050155; LMFA01050156; LMFA01050033 (10-hydroxy capric acid); LMFA01050032 (5-hydroxy capric acid); LMFA01050031 (4-hydroxy capric acid); LMFA01050370 (6-hydroxy-3,7-dimethyloctanoic acid); LMFA01050248; LMFA01050244; LMFA01050245; LMFA01050246; LMFA01050247": ["C10H20O3", "Fatty Acyls [FA] with formula: C10H20O3"],
        "LMFA08010005 (decanamide)": ["C10H21NO", "Fatty Acyls [FA] with formula: C10H21NO"],
        "LMFA01100002; LMFA01100003; LMFA01100012; LMFA01100011; LMFA00000007 (n-decanohydroxamic acid)": ["C10H21NO2", "Fatty Acyls [FA] with formula: C10H21NO2"],
        "LMFA05000062 (1-decanol); LMFA05000137": ["C10H22O", "Fatty Acyls [FA] with formula: C10H22O"],
        "LMFA06000063": ["C10H6O", "Fatty Acyls [FA] with formula: C10H6O"],
        "LMFA06000062": ["C10H8O", "Fatty Acyls [FA] with formula: C10H8O"],
        "LMFA01030714": ["C10H8O3", "Fatty Acyls [FA] with formula: C10H8O3"],
        "LMFA01050235": ["C10H8O4", "Fatty Acyls [FA] with formula: C10H8O4"],
        "LMFA01030751; LMFA01030752": ["C11H10O2", "Fatty Acyls [FA] with formula: C11H10O2"],
        "LMFA06000070": ["C11H14O", "Fatty Acyls [FA] with formula: C11H14O"],
        "LMFA02020009 (cis-Jasmone); LMFA06000069": ["C11H16O", "Fatty Acyls [FA] with formula: C11H16O"],
        "LMFA05000013 (Depdecin)": ["C11H16O5", "Fatty Acyls [FA] with formula: C11H16O5"],
        "LMFA06000068": ["C11H18O", "Fatty Acyls [FA] with formula: C11H18O"],
        "LMFA01030222; LMFA01030610; LMFA01030613; LMFA01030616; LMFA01030611; LMFA01030612; LMFA01030615; LMFA01030614; LMFA01030617; LMFA01030618": ["C11H18O2", "Fatty Acyls [FA] with formula: C11H18O2"],
        "LMFA05000143": ["C11H19ClO", "Fatty Acyls [FA] with formula: C11H19ClO"],
        "LMFA08030006": ["C11H19NO3", "Fatty Acyls [FA] with formula: C11H19NO3"],
        "LMFA06000066; LMFA06000067; LMFA06000065; LMFA05000125": ["C11H20O", "Fatty Acyls [FA] with formula: C11H20O"],
        "LMFA01020130; LMFA01030786; LMFA01030785; LMFA01020131; LMFA01030219; LMFA01030218; LMFA01030217; LMFA01030035 (9-hendecenoic acid); LMFA01030034 (2-hendecenoic acid); LMFA01030036 (10-hendecenoic acid); LMFA01030220; LMFA01030221; LMFA01030608; LMFA01030609; LMFA07040001; LMFA05000247; LMFA05000246; LMFA01030606; LMFA01030607": ["C11H20O2", "Fatty Acyls [FA] with formula: C11H20O2"],
        "LMFA01060087; LMFA01050164; LMFA01050329; LMFA01050328; LMFA01060038 (9-acetyl pelargonic acid); LMFA01060034 (Pelargonyl acetic acid); LMFA01060035 (3-capryl propionic acid); LMFA01060036 (4-heptanoyl butyric acid); LMFA01060037 (8-propionyl caprylic acid)": ["C11H20O3", "Fatty Acyls [FA] with formula: C11H20O3"],
        "LMFA01170007 (Undecanedioic acid)": ["C11H20O4", "Fatty Acyls [FA] with formula: C11H20O4"],
        "LMFA01090005": ["C11H21BrO2", "Fatty Acyls [FA] with formula: C11H21BrO2"],
        "LMFA07070003": ["C11H21NO4", "Fatty Acyls [FA] with formula: C11H21NO4"],
        "LMFA12000002; LMFA06000064": ["C11H22O", "Fatty Acyls [FA] with formula: C11H22O"],
        "LMFA01020090; LMFA01020261; LMFA01020182; LMFA01020183; LMFA01020184; LMFA01020185; LMFA01020186; LMFA01020187; LMFA01020188; LMFA01020155; LMFA05000248; LMFA01010011 (Undecylic acid); LMFA01020288 (4,8-dimethyl-nonanoic acid); LMFA05000244": ["C11H22O2", "Fatty Acyls [FA] with formula: C11H22O2"],
        "LMFA01050327; LMFA01050035 (omega-hydroxy hendecanoic acid); LMFA01050034 (2-hydroxy hendecanoic acid); LMFA01050163; LMFA01050162; LMFA01050161": ["C11H22O3", "Fatty Acyls [FA] with formula: C11H22O3"],
        "LMFA01100004": ["C11H23NO2", "Fatty Acyls [FA] with formula: C11H23NO2"],
        "LMFA05000144": ["C11H24O", "Fatty Acyls [FA] with formula: C11H24O"],
        "LMFA01030753; LMFA01030754": ["C11H8O2", "Fatty Acyls [FA] with formula: C11H8O2"],
        "LMFA01030465": ["C12H12O2", "Fatty Acyls [FA] with formula: C12H12O2"],
        "LMFA06000073": ["C12H14O", "Fatty Acyls [FA] with formula: C12H14O"],
        "LMFA01030243": ["C12H14O2", "Fatty Acyls [FA] with formula: C12H14O2"],
        "LMFA01170008": ["C12H14O4", "Fatty Acyls [FA] with formula: C12H14O4"],
        "LMFA01030464; LMFA01030242; LMFA01030240; LMFA01030241": ["C12H16O2", "Fatty Acyls [FA] with formula: C12H16O2"],
        "LMFA01060095": ["C12H16O3", "Fatty Acyls [FA] with formula: C12H16O3"],
        "LMFA01150004": ["C12H16O5", "Fatty Acyls [FA] with formula: C12H16O5"],
        "LMFA05000168": ["C12H18F4O", "Fatty Acyls [FA] with formula: C12H18F4O"],
        "LMFA02020017 ((3S,7S)-Jasmonic acid); LMFA02020003 ((3R,7S)-iso-jasmonic acid); LMFA02020001 (Jasmonic acid); LMFA02020004 ((3S,7R)-iso-jasmonic acid)": ["C12H18O3", "Fatty Acyls [FA] with formula: C12H18O3"],
        "LMFA02020008 (epi-4'-hydroxyjasmonic acid); LMFA02020011 (12-hydroxyjasmonic acid); LMFA02020007 (Tuberonic acid)": ["C12H18O4", "Fatty Acyls [FA] with formula: C12H18O4"],
        "LMFA08030004": ["C12H19NO4", "Fatty Acyls [FA] with formula: C12H19NO4"],
        "LMFA05000169; LMFA05000167": ["C12H20F2O", "Fatty Acyls [FA] with formula: C12H20F2O"],
        "LMFA06000153; LMFA06000157; LMFA06000155; LMFA05000058; LMFA05000166; LMFA05000162; LMFA05000097 ((3Z,6Z,9Z)-dodecatrienol); LMFA06000158; LMFA06000163; LMFA06000167; LMFA06000166; LMFA06000165; LMFA06000159": ["C12H20O", "Fatty Acyls [FA] with formula: C12H20O"],
        "LMFA01030237; LMFA01030236; LMFA01030234; LMFA01030233; LMFA06000145; LMFA01030232; LMFA01030231; LMFA01030230; LMFA01030239; LMFA01030235; LMFA01030238; LMFA01030466; LMFA01030467; LMFA01030468; LMFA01030469; LMFA05000237; LMFA01030471; LMFA01030470; LMFA01030473; LMFA01030472; LMFA01030474; LMFA05000259; LMFA05000257; LMFA05000253; LMFA01030189 (Aleprylic acid); LMFA01030769 (cis,cis-dodeca-3,6-dienoic acid); LMFA05000242": ["C12H20O2", "Fatty Acyls [FA] with formula: C12H20O2"],
        "LMFA01030787; LMFA01050373; LMFA01050171; LMFA05000238; LMFA02020006 ((-)-7-epi--9,10-dihydrojasmonic acid); LMFA02020005 ((+)-7-epi--9,10-dihydrojasmonic acid); LMFA01060094; LMFA01060167; LMFA01060182; LMFA01060093 (Traumatin); LMFA02020013 ((+)-cucurbic acid)": ["C12H20O3", "Fatty Acyls [FA] with formula: C12H20O3"],
        "LMFA01060092; LMFA02020015 ((-)-12-hydroxy-9,10-dihydrojasmonic acid); LMFA01170002 (Traumatic acid); LMFA01170033; LMFA02020012 ((-)-11-hydroxy-9,10-dihydrojasmonic acid)": ["C12H20O4", "Fatty Acyls [FA] with formula: C12H20O4"],
        "LMFA06000154; LMFA06000152; LMFA05000150; LMFA05000164; LMFA05000165; LMFA05000160; LMFA05000161; LMFA05000163; LMFA05000149; LMFA05000157; LMFA05000151; LMFA05000159; LMFA06000072; LMFA05000033; LMFA05000046; LMFA05000026; LMFA05000020; LMFA06000162; LMFA06000164; LMFA06000161; LMFA05000132": ["C12H22O", "Fatty Acyls [FA] with formula: C12H22O"],
        "LMFA01030788; LMFA01030224; LMFA01030225; LMFA01030226; LMFA01030227; LMFA01030223; LMFA01030228; LMFA01030040 (7-lauroleic acid); LMFA01030041 (9-lauroleic acid); LMFA01030042 (10-Lauroleic acid); LMFA01030043 (11-lauroleic acid); LMFA01030039 (6-lauroleic acid); LMFA01030038 (Linderic acid); LMFA01030037 (2-lauroleic acid); LMFA01030229; LMFA01020106; LMFA01030772 (trans-dodec-3-enoic acid); LMFA05000258; LMFA05000256; LMFA05000254; LMFA05000255; LMFA05000252; LMFA05000250; LMFA05000251; LMFA01030768 (cis-dodec-3-enoic acid); LMFA05000249": ["C12H22O2", "Fatty Acyls [FA] with formula: C12H22O2"],
        "LMFA01050254; LMFA01060091; LMFA01050170; LMFA01060089; LMFA01060088; LMFA01060040 (9-keto lauric acid); LMFA01050169; LMFA01050168; LMFA01060184; LMFA01060183; LMFA01060039 (4-keto lauric acid); LMFA01060090": ["C12H22O3", "Fatty Acyls [FA] with formula: C12H22O3"],
        "LMFA01170009 (Dodecanedioic acid)": ["C12H22O4", "Fatty Acyls [FA] with formula: C12H22O4"],
        "LMFA01170089 (3-hydroxy-dodecanedioic acid)": ["C12H22O5", "Fatty Acyls [FA] with formula: C12H22O5"],
        "LMFA01090009; LMFA01090006; LMFA01090007": ["C12H23BrO2", "Fatty Acyls [FA] with formula: C12H23BrO2"],
        "LMFA01090008": ["C12H23ClO2", "Fatty Acyls [FA] with formula: C12H23ClO2"],
        "LMFA00000009 (N-(6-aminohexanoyl)-6-aminohexanoic acid)": ["C12H24N2O3", "Fatty Acyls [FA] with formula: C12H24N2O3"],
        "LMFA06000150; LMFA06000151; LMFA06000141; LMFA06000142; LMFA05000148; LMFA05000146; LMFA05000049; LMFA05000155; LMFA05000154; LMFA05000156; LMFA05000153; LMFA05000158; LMFA06000071 (Laurylaldehyde); LMFA05000045; LMFA05000025; LMFA05000024; LMFA05000021; LMFA05000147": ["C12H24O", "Fatty Acyls [FA] with formula: C12H24O"],
        "LMFA01020053; LMFA01020056; LMFA01020057; LMFA01020054; LMFA01020055; LMFA01020058; LMFA01020059; LMFA01020156; LMFA01020004 (Isolauric acid); LMFA05000260; LMFA01010012 (Lauric acid)": ["C12H24O2", "Fatty Acyls [FA] with formula: C12H24O2"],
        "LMFA01050253; LMFA01050252; LMFA01050251; LMFA01050039 (12-hydroxy lauric acid); LMFA01050038 (4-hydroxy lauric acid); LMFA01050037 (beta-hydroxylauric acid); LMFA01050036 (alpha-hydroxy lauric acid); LMFA01050165; LMFA01050167; LMFA01050166; LMFA01050363 (4S-hydroxylauric acid); LMFA01050362 (2S-hydroxylauric acid); LMFA01050361 (2R-hydroxylauric acid); LMFA01050364 (4R-hydroxylauric acid)": ["C12H24O3", "Fatty Acyls [FA] with formula: C12H24O3"],
        "LMFA08010001": ["C12H25NO", "Fatty Acyls [FA] with formula: C12H25NO"],
        "LMFA01100005": ["C12H25NO2", "Fatty Acyls [FA] with formula: C12H25NO2"],
        "LMFA11000004 (dodecane)": ["C12H26", "Fatty Acyls [FA] with formula: C12H26"],
        "LMFA05000001": ["C12H26O", "Fatty Acyls [FA] with formula: C12H26O"],
        "LMFA06000077": ["C13H16O", "Fatty Acyls [FA] with formula: C13H16O"],
        "LMFA01050152": ["C13H18O5", "Fatty Acyls [FA] with formula: C13H18O5"],
        "LMFA06000076": ["C13H20O", "Fatty Acyls [FA] with formula: C13H20O"],
        "LMFA02020016 (methyl (+)-7-isojasmonate); LMFA02020010 (Methyl jasmonate)": ["C13H20O3", "Fatty Acyls [FA] with formula: C13H20O3"],
        "LMFA01030598; LMFA01030599; LMFA01030596; LMFA01030597; LMFA01030244; LMFA01030245; LMFA01030605; LMFA01030602; LMFA01030603; LMFA01030604; LMFA01030600; LMFA01030601": ["C13H22O2", "Fatty Acyls [FA] with formula: C13H22O2"],
        "LMFA06000075; LMFA06000170": ["C13H24O", "Fatty Acyls [FA] with formula: C13H24O"],
        "LMFA01030044 (3-n-decyl acrylic acid); LMFA01030045 (Isotridecenoic acid); LMFA01030046; LMFA01030595; LMFA01020143 (2-methylene dodecanoic acid); LMFA05000262; LMFA05000263; LMFA05000261; LMFA05000267; LMFA05000266; LMFA05000265; LMFA05000264; LMFA01020107": ["C13H24O2", "Fatty Acyls [FA] with formula: C13H24O2"],
        "LMFA01060097; LMFA01060041 (2-keto tridecanoic acid); LMFA01060043 (12-keto tridecanoic acid); LMFA01060042 (10-keto tridecanoic acid)": ["C13H24O3", "Fatty Acyls [FA] with formula: C13H24O3"],
        "LMFA01170014 (Tridecanedioic acid); LMFA01170010; LMFA01170011; LMFA01170012; LMFA01170013": ["C13H24O4", "Fatty Acyls [FA] with formula: C13H24O4"],
        "LMFA07070001": ["C13H25NO4", "Fatty Acyls [FA] with formula: C13H25NO4"],
        "LMFA00000002 (Serratamic acid)": ["C13H25NO5", "Fatty Acyls [FA] with formula: C13H25NO5"],
        "LMFA06000074": ["C13H26O", "Fatty Acyls [FA] with formula: C13H26O"],
        "LMFA01020262; LMFA01020067 (8-methyl lauric acid); LMFA01020066 (7-methyl lauric acid); LMFA01020065 (6-methyl lauric acid); LMFA01020064 (5-methyl lauric acid); LMFA01020063 (4-methyl lauric acid); LMFA01020062 (3-methyl lauric acid); LMFA01020061 (2-methyl lauric acid); LMFA01020068 (9-methyl lauric acid); LMFA01020034; LMFA01020157; LMFA01020005 ((+)-10-methyl lauric acid); LMFA01020006 (Isoundecylic acid); LMFA05000268; LMFA01010013 (Tridecylic acid)": ["C13H26O2", "Fatty Acyls [FA] with formula: C13H26O2"],
        "LMFA01050042; LMFA01050040; LMFA01050041; LMFA01050326; LMFA01050172": ["C13H26O3", "Fatty Acyls [FA] with formula: C13H26O3"],
        "LMFA01100001; LMFA01100006; LMFA01100026; LMFA01100024": ["C13H27NO2", "Fatty Acyls [FA] with formula: C13H27NO2"],
        "LMFA11000001 (tridecane)": ["C13H28", "Fatty Acyls [FA] with formula: C13H28"],
        "LMFA05000171; LMFA05000035": ["C13H28O", "Fatty Acyls [FA] with formula: C13H28O"],
        "LMFA01030583": ["C14H16O2", "Fatty Acyls [FA] with formula: C14H16O2"],
        "LMFA01030258": ["C14H18O2", "Fatty Acyls [FA] with formula: C14H18O2"],
        "LMFA06000156": ["C14H18O3", "Fatty Acyls [FA] with formula: C14H18O3"],
        "LMFA06000180; LMFA05000016": ["C14H20O", "Fatty Acyls [FA] with formula: C14H20O"],
        "LMFA05000306": ["C14H21F5O2", "Fatty Acyls [FA] with formula: C14H21F5O2"],
        "LMFA06000182": ["C14H22O", "Fatty Acyls [FA] with formula: C14H22O"],
        "LMFA05000299; LMFA05000281; LMFA05000286; LMFA05000295": ["C14H22O2", "Fatty Acyls [FA] with formula: C14H22O2"],
        "LMFA02010010 ((9R,13R)-1a,1b-dihomo-jasmonic acid); LMFA02010011 ((9S,13S)-1a,1b-dihomo-jasmonic acid); LMFA01060185": ["C14H22O3", "Fatty Acyls [FA] with formula: C14H22O3"],
        "LMFA05000309; LMFA05000307": ["C14H24F2O2", "Fatty Acyls [FA] with formula: C14H24F2O2"],
        "LMFA06000184; LMFA06000185; LMFA06000187; LMFA06000186; LMFA06000183; LMFA06000082; LMFA06000171; LMFA06000173; LMFA06000174; LMFA06000175; LMFA06000176": ["C14H24O", "Fatty Acyls [FA] with formula: C14H24O"],
        "LMFA01030789; LMFA05000298; LMFA05000287; LMFA05000280; LMFA05000282; LMFA05000288; LMFA01030592; LMFA01030593; LMFA01030590; LMFA01030591; LMFA01030594; LMFA05000305; LMFA05000303; LMFA05000285; LMFA01030585; LMFA01030584; LMFA01030587; LMFA01030586; LMFA01030589; LMFA01030588; LMFA06000188; LMFA05000284; LMFA05000283; LMFA05000297; LMFA01030253; LMFA01030252; LMFA01030255; LMFA01030254; LMFA01030257; LMFA01030256; LMFA01030251; LMFA05000276; LMFA05000279; LMFA05000304; LMFA05000300; LMFA05000301; LMFA05000294; LMFA01030191 (Alepric acid)": ["C14H24O2", "Fatty Acyls [FA] with formula: C14H24O2"],
        "LMFA02010017; LMFA01060186; LMFA01060187; LMFA02010016": ["C14H24O3", "Fatty Acyls [FA] with formula: C14H24O3"],
        "LMFA05000191; LMFA05000188; LMFA05000189; LMFA05000186; LMFA05000187; LMFA05000179; LMFA05000178; LMFA05000172; LMFA06000190; LMFA06000181; LMFA06000079; LMFA06000080; LMFA06000081; LMFA05000032; LMFA05000039; LMFA05000040; LMFA06000172; LMFA06000177; LMFA06000178; LMFA06000179; LMFA05000190": ["C14H26O", "Fatty Acyls [FA] with formula: C14H26O"],
        "LMFA01020132; LMFA01030048 (Tsuzuic acid); LMFA01030049 (Physeteric acid); LMFA01030047; LMFA05000289; LMFA01030051 (Myristoleic acid); LMFA01030050; LMFA06000189; LMFA01030246; LMFA01030247; LMFA01030248; LMFA01030249; LMFA01030250; LMFA05000270; LMFA05000271; LMFA05000272; LMFA05000273; LMFA05000274; LMFA05000275; LMFA05000277; LMFA05000308; LMFA05000292; LMFA05000293; LMFA05000290; LMFA05000291; LMFA05000296; LMFA01020108; LMFA01030770 (cis-tetradec-11-enoic acid); LMFA01030771 (trans-tetradec-11-enoic acid)": ["C14H26O2", "Fatty Acyls [FA] with formula: C14H26O2"],
        "LMFA01060099; LMFA01060100; LMFA01050178; LMFA01050179; LMFA01060045 (10-keto myristic acid); LMFA01060044 (4-keto myristic acid); LMFA01060046 (13-keto myristic acid); LMFA01050181; LMFA01050180; LMFA01060096; LMFA01060098; LMFA01060189": ["C14H26O3", "Fatty Acyls [FA] with formula: C14H26O3"],
        "LMFA01170018 (Tetradecanedioic acid); LMFA01170015; LMFA01170016; LMFA01170017": ["C14H26O4", "Fatty Acyls [FA] with formula: C14H26O4"],
        "LMFA01170094 (3-hydroxy-tetradecanedioic acid)": ["C14H26O5", "Fatty Acyls [FA] with formula: C14H26O5"],
        "LMFA05000184; LMFA05000177; LMFA05000176; LMFA05000175; LMFA05000174; LMFA05000173; LMFA05000183; LMFA05000180; LMFA05000182; LMFA05000181; LMFA06000078 (Myristaldehyde); LMFA05000185": ["C14H28O", "Fatty Acyls [FA] with formula: C14H28O"],
        "LMFA01020272; LMFA01020070; LMFA01020189; LMFA01020069; LMFA01020191; LMFA01020190; LMFA01020035; LMFA01020036; LMFA01020159; LMFA01020158; LMFA01020160; LMFA01020161; LMFA05000310; LMFA01020007 ((+)-Isomyristic acid); LMFA01010014 (Myristic acid); LMFA01020285 (2,6,10-trimethyl-undecanoic acid)": ["C14H28O2", "Fatty Acyls [FA] with formula: C14H28O2"],
        "LMFA01050044 (omega-hydroxy myristic acid); LMFA01050175; LMFA01050325; LMFA01050324; LMFA01050001 (alpha-hydroxy myristic acid); LMFA01050176; LMFA01050177; LMFA01050174; LMFA01050173; LMFA01050374; LMFA01050323; LMFA01050322": ["C14H28O3", "Fatty Acyls [FA] with formula: C14H28O3"],
        "LMFA01050081 (3,11-dihydroxy myristoic acid)": ["C14H28O4", "Fatty Acyls [FA] with formula: C14H28O4"],
        "LMFA01100007; LMFA08040041 (Lauroyl-EA)": ["C14H29NO2", "Fatty Acyls [FA] with formula: C14H29NO2"],
        "LMFA05000041": ["C14H30O", "Fatty Acyls [FA] with formula: C14H30O"],
        "LMFA05000017": ["C14H30O2", "Fatty Acyls [FA] with formula: C14H30O2"],
        "LMFA01030559": ["C15H18O2", "Fatty Acyls [FA] with formula: C15H18O2"],
        "LMFA06000087": ["C15H22O", "Fatty Acyls [FA] with formula: C15H22O"],
        "LMFA01140024 (Majusculoic acid)": ["C15H23BrO2", "Fatty Acyls [FA] with formula: C15H23BrO2"],
        "LMFA05000319": ["C15H24O2", "Fatty Acyls [FA] with formula: C15H24O2"],
        "LMFA06000191; LMFA06000085; LMFA06000086; LMFA06000168; LMFA06000160": ["C15H26O", "Fatty Acyls [FA] with formula: C15H26O"],
        "LMFA05000326; LMFA05000327; LMFA05000325; LMFA01030581; LMFA01030582; LMFA05000318; LMFA05000317; LMFA01030790": ["C15H26O2", "Fatty Acyls [FA] with formula: C15H26O2"],
        "LMFA05000193; LMFA05000145; LMFA06000192; LMFA05000152; LMFA06000084": ["C15H28O", "Fatty Acyls [FA] with formula: C15H28O"],
        "LMFA05000311; LMFA05000322; LMFA05000323; LMFA05000320; LMFA05000321; LMFA05000324; LMFA01030053; LMFA01030052; LMFA05000315; LMFA01030580; LMFA01030259; LMFA05000316; LMFA05000314; LMFA05000313; LMFA05000312; LMFA01020109; LMFA05000329": ["C15H28O2", "Fatty Acyls [FA] with formula: C15H28O2"],
        "LMFA01060102; LMFA01060103; LMFA01060049 (14-keto pentadecanoic acid); LMFA01060048 (11-keto pentadecanoic acid); LMFA01060047 (4-keto pentadecanoic acid)": ["C15H28O3", "Fatty Acyls [FA] with formula: C15H28O3"],
        "LMFA01170019; LMFA01170021 (Pentadecanedioic acid); LMFA01170020": ["C15H28O4", "Fatty Acyls [FA] with formula: C15H28O4"],
        "LMFA07070002": ["C15H29NO4", "Fatty Acyls [FA] with formula: C15H29NO4"],
        "LMFA05000050; LMFA06000083": ["C15H30O", "Fatty Acyls [FA] with formula: C15H30O"],
        "LMFA01020248; LMFA05000330; LMFA01020091; LMFA01020037; LMFA01020162; LMFA01020163; LMFA01020009 (Isopentadecylic acid); LMFA01020008 ((+)-12-methyl myristic acid); LMFA05000269; LMFA01010015 (Pentadecylic acid)": ["C15H30O2", "Fatty Acyls [FA] with formula: C15H30O2"],
        "LMFA01050318; LMFA01050319; LMFA01050046 (Convolvulinolic acid); LMFA01050045; LMFA01050320; LMFA01050185; LMFA01050183; LMFA01050182": ["C15H30O3", "Fatty Acyls [FA] with formula: C15H30O3"],
        "LMFA01050186; LMFA01050184; LMFA01050082 (2,15-dihydroxy-pentadecylic acid)": ["C15H30O4", "Fatty Acyls [FA] with formula: C15H30O4"],
        "LMFA11000006 (pentadecane)": ["C15H32", "Fatty Acyls [FA] with formula: C15H32"],
        "LMFA05000194; LMFA05000036": ["C15H32O", "Fatty Acyls [FA] with formula: C15H32O"],
        "LMFA05000014 (Gummiferol)": ["C16H14O5", "Fatty Acyls [FA] with formula: C16H14O5"],
        "LMFA01030705; LMFA01030704": ["C16H18O2", "Fatty Acyls [FA] with formula: C16H18O2"],
        "LMFA01030706; LMFA01030703": ["C16H20O2", "Fatty Acyls [FA] with formula: C16H20O2"],
        "LMFA01140011": ["C16H22O2", "Fatty Acyls [FA] with formula: C16H22O2"],
        "LMFA07080001": ["C16H24N5O8P", "Fatty Acyls [FA] with formula: C16H24N5O8P"],
        "LMFA01030279; LMFA01030278; LMFA01030277; LMFA01030493; LMFA01030492; LMFA01030491; LMFA01030280; LMFA01030281; LMFA01030166; LMFA01030165; LMFA01030164; LMFA01030163; LMFA01140010": ["C16H24O2", "Fatty Acyls [FA] with formula: C16H24O2"],
        "LMFA03010194 (Prostaglandin M); LMFA03010032 (Tetranor-PGEM)": ["C16H24O7", "Fatty Acyls [FA] with formula: C16H24O7"],
        "LMFA06000196; LMFA06000198; LMFA06000199; LMFA06000096; LMFA06000226; LMFA06000213": ["C16H26O", "Fatty Acyls [FA] with formula: C16H26O"],
        "LMFA05000354; LMFA01030134; LMFA01030135; LMFA01030136; LMFA01030137 (Hiragonic acid); LMFA01030138 (7,10,13-hexadecatrienoic acid); LMFA01030139; LMFA05000368; LMFA01030276 (Roughanic acid); LMFA01030702": ["C16H26O2", "Fatty Acyls [FA] with formula: C16H26O2"],
        "LMFA01070019 ((2E,6E,10R,11S)-10,11-epoxy-3,7,11-trimethyltrideca-2,6-dienoic acid); LMFA01020279; LMFA02010009 ((9S,13S)-1a,1b-dinor-10,11-dihydro-12-oxo-15-phytoenoic acid); LMFA01050143 (Tetranor-12(R)-HETE); LMFA02010008 ((9R,13R)-1a,1b-dinor-10,11-dihydro-12-oxo-15-phytoenoic acid)": ["C16H26O3", "Fatty Acyls [FA] with formula: C16H26O3"],
        "LMFA03010215 (Tetranor-PGD1); LMFA03010211 (Tetranor-PGE1)": ["C16H26O5", "Fatty Acyls [FA] with formula: C16H26O5"],
        "LMFA03010139 (Tetranor-PGFM)": ["C16H26O7", "Fatty Acyls [FA] with formula: C16H26O7"],
        "LMFA05000375; LMFA05000376": ["C16H27F3O2", "Fatty Acyls [FA] with formula: C16H27F3O2"],
        "LMFA08030001": ["C16H27NO4", "Fatty Acyls [FA] with formula: C16H27NO4"],
        "LMFA06000201; LMFA05000198; LMFA06000195; LMFA06000095; LMFA06000094; LMFA06000093; LMFA06000220; LMFA06000221; LMFA06000222; LMFA06000223; LMFA06000224; LMFA06000225; LMFA06000227; LMFA05000201; LMFA05000202; LMFA06000204; LMFA06000205; LMFA06000202; LMFA06000203; LMFA06000200; LMFA06000218; LMFA06000219": ["C16H28O", "Fatty Acyls [FA] with formula: C16H28O"],
        "LMFA05000369; LMFA05000353; LMFA05000352; LMFA05000351; LMFA05000350; LMFA05000356; LMFA05000366; LMFA05000367; LMFA05000365; LMFA05000373; LMFA05000371; LMFA05000370; LMFA01030109; LMFA01030268; LMFA01030269; LMFA01030273; LMFA01030272; LMFA01030271; LMFA01030270; LMFA01030275 (Palmitolinoleic acid); LMFA01030274; LMFA01030497; LMFA01030496; LMFA01030495; LMFA01030494; LMFA01030806 (7,10-hexadecadienoic acid); LMFA01030807 (7Z,10Z-hexadecadienoic acid); LMFA01140023 (Hydnocarpic acid); LMFA01030814; LMFA05000372; LMFA06000215; LMFA05000328; LMFA05000332; LMFA05000347; LMFA05000340; LMFA05000342; LMFA05000343; LMFA05000344; LMFA05000345; LMFA05000346; LMFA05000348; LMFA05000349": ["C16H28O2", "Fatty Acyls [FA] with formula: C16H28O2"],
        "LMFA02010015; LMFA02010014": ["C16H28O3", "Fatty Acyls [FA] with formula: C16H28O3"],
        "LMFA03010213 (Tetranor-PGF1alpha)": ["C16H28O5", "Fatty Acyls [FA] with formula: C16H28O5"],
        "LMFA01170074 ((2S,3S)-2-hydroxytridecane-1,2,3-tricarboxylic acid)": ["C16H28O7", "Fatty Acyls [FA] with formula: C16H28O7"],
        "LMFA01090012": ["C16H29BrO2", "Fatty Acyls [FA] with formula: C16H29BrO2"],
        "LMFA05000378; LMFA05000377": ["C16H29FO2", "Fatty Acyls [FA] with formula: C16H29FO2"],
        "LMFA01090042": ["C16H30F2O2", "Fatty Acyls [FA] with formula: C16H30F2O2"],
        "LMFA05000196; LMFA05000197; LMFA05000053; LMFA05000199; LMFA06000193; LMFA05000015; LMFA06000089; LMFA05000007 (Bombykol); LMFA06000092; LMFA06000091; LMFA06000090; LMFA05000023; LMFA05000205; LMFA05000207; LMFA05000206; LMFA05000200; LMFA05000209; LMFA05000208; LMFA06000112; LMFA06000211; LMFA06000210; LMFA06000212; LMFA06000217; LMFA06000216; LMFA05000054": ["C16H30O", "Fatty Acyls [FA] with formula: C16H30O"],
        "LMFA01020133; LMFA05000357; LMFA05000355; LMFA05000359; LMFA05000358; LMFA05000364; LMFA05000362; LMFA05000360; LMFA05000361; LMFA01030058 (cis-10-palmitoleic acid); LMFA01030057 (trans-9-palmitoleic acid); LMFA01030056 (cis-9-palmitoleic acid); LMFA01030055 (7-palmitoleic acid); LMFA01030054 (Gaidic acid); LMFA01030260; LMFA01030261; LMFA01030262 (cis-Palmitvaccenic acid); LMFA01030263; LMFA01030264; LMFA01030265; LMFA01030266; LMFA01030267 (Sapienic acid); LMFA01030808 (Hypogeic acid); LMFA01020140; LMFA01020141; LMFA01020142; LMFA05000363; LMFA01030766 (hexadec-7Z-enoic acid); LMFA05000335; LMFA05000334; LMFA05000337; LMFA05000336; LMFA05000331; LMFA05000333; LMFA05000339; LMFA05000338; LMFA05000341": ["C16H30O2", "Fatty Acyls [FA] with formula: C16H30O2"],
        "LMFA01050271; LMFA01050270; LMFA01050272; LMFA01050106 (Ambrettolic acid); LMFA01060104; LMFA01060105; LMFA01060101; LMFA01060058 (11-keto palmitic acid); LMFA01060056 (9-keto palmitic acid); LMFA01060057 (10-keto palmitic acid); LMFA01060054 (7-keto palmitic acid); LMFA01060055 (8-keto palmitic acid); LMFA01060052 (4-keto palmitic acid); LMFA01060053 (5-keto palmitic acid); LMFA01060050 (2-keto palmitic acid); LMFA01060051 (3-keto palmitic acid); LMFA01050192; LMFA01050193": ["C16H30O3", "Fatty Acyls [FA] with formula: C16H30O3"],
        "LMFA01170060; LMFA01170022 (Hexadecanedioic acid); LMFA01170059": ["C16H30O4", "Fatty Acyls [FA] with formula: C16H30O4"],
        "LMFA01170058; LMFA01170057": ["C16H30O5", "Fatty Acyls [FA] with formula: C16H30O5"],
        "LMFA06000115 (2-bromopalmitaldehyde)": ["C16H31BrO", "Fatty Acyls [FA] with formula: C16H31BrO"],
        "LMFA01030674; LMFA01090011; LMFA01090010": ["C16H31BrO2", "Fatty Acyls [FA] with formula: C16H31BrO2"],
        "LMFA06000114 (2-chloropalmitaldehyde)": ["C16H31ClO", "Fatty Acyls [FA] with formula: C16H31ClO"],
        "LMFA01090044": ["C16H31ClO3", "Fatty Acyls [FA] with formula: C16H31ClO3"],
        "LMFA01090034; LMFA01090041": ["C16H31FO2", "Fatty Acyls [FA] with formula: C16H31FO2"],
        "LMFA01090039; LMFA01090038; LMFA01090037": ["C16H31IO2", "Fatty Acyls [FA] with formula: C16H31IO2"],
        "LMFA05000195; LMFA05000056; LMFA05000211; LMFA05000055; LMFA06000088 (Palmitaldehyde); LMFA05000030; LMFA05000204; LMFA06000116 (2-methylpentadecanal)": ["C16H32O", "Fatty Acyls [FA] with formula: C16H32O"],
        "LMFA01020249; LMFA05000379; LMFA01020192; LMFA01020173; LMFA01020172; LMFA01020038; LMFA01020039; LMFA01020010 (Isopalmitic acid); LMFA01020166; LMFA01020167; LMFA01020164; LMFA01020165; LMFA01020168; LMFA01020169; LMFA01020171; LMFA01020170; LMFA01010001 (Palmitic acid); LMFA01020289": ["C16H32O2", "Fatty Acyls [FA] with formula: C16H32O2"],
        "LMFA01050414; LMFA01050266; LMFA01050267; LMFA01050264; LMFA01050265; LMFA01050268; LMFA01050269; LMFA01050047 (2-hydroxy palmitic acid); LMFA01050048 (4-hydroxy palmitic acid); LMFA01050049 (11-hydroxy palmitic acid); LMFA01050051 (Juniperic acid); LMFA01050050 (14-hydroxy palmitic acid); LMFA01050187; LMFA01050188; LMFA01050366 (3R-hydroxypalmitic acid); LMFA01050365 (3S-hydroxypalmitic acid); LMFA01050190": ["C16H32O3", "Fatty Acyls [FA] with formula: C16H32O3"],
        "LMFA01050189; LMFA01050191; LMFA01050341 (10,16-dihydroxy-palmitic acid); LMFA01050340 (9,16-dihydroxy-palmitic acid); LMFA01050084 (Ustilic acid A); LMFA01050083 (3,12-dihydroxy palmitic acid)": ["C16H32O4", "Fatty Acyls [FA] with formula: C16H32O4"],
        "LMFA01050099 (2,15,16-trihydroxy palmitic acid); LMFA01050100 (8,9,16-trihydroxy palmitic acid); LMFA01050102 (11,12,15-trihydroxy palmitic acid); LMFA01050101 (9,10,16-trihydroxy palmitic acid)": ["C16H32O5", "Fatty Acyls [FA] with formula: C16H32O5"],
        "LMFA01100017; LMFA01100016; LMFA01100018; LMFA08040042 (Myristoyl-EA)": ["C16H33NO2", "Fatty Acyls [FA] with formula: C16H33NO2"],
        "LMFA05000010; LMFA05000038; LMFA05000061 (Cetyl alcohol)": ["C16H34O", "Fatty Acyls [FA] with formula: C16H34O"],
        "LMFA01030479; LMFA05000029": ["C17H22O2", "Fatty Acyls [FA] with formula: C17H22O2"],
        "LMFA03120026 (clavirin II); LMFA03120025 (clavirin I)": ["C17H22O4", "Fatty Acyls [FA] with formula: C17H22O4"],
        "LMFA05000019 (Panaxynol)": ["C17H24O", "Fatty Acyls [FA] with formula: C17H24O"],
        "LMFA05000005 (Falcarindiol); LMFA05000028 (Panaxydol); LMFA05000022": ["C17H24O2", "Fatty Acyls [FA] with formula: C17H24O2"],
        "LMFA05000037 (Panaxydol chlorohydrine)": ["C17H25ClO2", "Fatty Acyls [FA] with formula: C17H25ClO2"],
        "LMFA01030475; LMFA01030477; LMFA01030476; LMFA01030478": ["C17H26O2", "Fatty Acyls [FA] with formula: C17H26O2"],
        "LMFA01050258; LMFA01060111; LMFA05000027 (Panaxytriol)": ["C17H26O3", "Fatty Acyls [FA] with formula: C17H26O3"],
        "LMFA01050151": ["C17H26O5", "Fatty Acyls [FA] with formula: C17H26O5"],
        "LMFA06000111": ["C17H28O", "Fatty Acyls [FA] with formula: C17H28O"],
        "LMFA01030482; LMFA01030756 (Norlinolenic acid); LMFA05000278; LMFA05000302": ["C17H28O2", "Fatty Acyls [FA] with formula: C17H28O2"],
        "LMFA03050002 (12S-HHTrE); LMFA01070020 (methyl (2E,6E,10R,11S)-10,11-epoxy-3,7,11-trimethyltrideca-2,6-dienoate); LMFA01050195": ["C17H28O3", "Fatty Acyls [FA] with formula: C17H28O3"],
        "LMFA06000169": ["C17H30O", "Fatty Acyls [FA] with formula: C17H30O"],
        "LMFA05000382; LMFA05000383; LMFA01030484; LMFA01030485; LMFA01030486; LMFA01030487; LMFA01030483; LMFA05000388; LMFA05000389": ["C17H30O2", "Fatty Acyls [FA] with formula: C17H30O2"],
        "LMFA01050260; LMFA01050146; LMFA01050194": ["C17H30O3", "Fatty Acyls [FA] with formula: C17H30O3"],
        "LMFA01170053": ["C17H30O4", "Fatty Acyls [FA] with formula: C17H30O4"],
        "LMFA01170075 ((3S,4S)-3-hydroxytetradecane-1,3,4-tricarboxylic acid)": ["C17H30O7", "Fatty Acyls [FA] with formula: C17H30O7"],
        "LMFA06000214; LMFA05000170; LMFA06000194; LMFA06000228; LMFA06000208; LMFA06000209; LMFA06000206; LMFA06000207": ["C17H32O", "Fatty Acyls [FA] with formula: C17H32O"],
        "LMFA01030288; LMFA01030286; LMFA01030287; LMFA01020267; LMFA01020266; LMFA01020268; LMFA01030059 (2-heptadecylenic acid); LMFA01030060 (9-heptadecylenic acid); LMFA05000384; LMFA05000385; LMFA05000380; LMFA05000381; LMFA01020203; LMFA01020204; LMFA01140007; LMFA01030480; LMFA01030481; LMFA01140026 (9,10-methanohexadecanoic acid); LMFA05000387; LMFA05000386; LMFA01030289; LMFA01030282; LMFA01030283; LMFA01030284; LMFA01030285": ["C17H32O2", "Fatty Acyls [FA] with formula: C17H32O2"],
        "LMFA01080008; LMFA01080001; LMFA01060108; LMFA01060109; LMFA01060107; LMFA01060059 (9-Keto heptadecylic acid)": ["C17H32O3", "Fatty Acyls [FA] with formula: C17H32O3"],
        "LMFA01170028 (Heptadecanedioic acid); LMFA01170026; LMFA01170025; LMFA01170024; LMFA01170027; LMFA01170023": ["C17H32O4", "Fatty Acyls [FA] with formula: C17H32O4"],
        "LMFA07070006": ["C17H33NO4", "Fatty Acyls [FA] with formula: C17H33NO4"],
        "LMFA05000052; LMFA06000097; LMFA05000034; LMFA05000203": ["C17H34O", "Fatty Acyls [FA] with formula: C17H34O"],
        "LMFA01020092; LMFA01020265; LMFA01020202; LMFA01020201; LMFA01020200; LMFA01020193; LMFA01020197; LMFA01020196; LMFA01020195; LMFA01020194; LMFA01020199; LMFA01020198; LMFA05000390; LMFA01020041; LMFA01020040; LMFA01020012 (15-methyl palmitic acid); LMFA01020011 ((+)-14-methyl palmitic acid); LMFA05000374; LMFA01020174; LMFA01010017 (Margaric acid); LMFA01020281": ["C17H34O2", "Fatty Acyls [FA] with formula: C17H34O2"],
        "LMFA01080010 ((R)-2-methoxyhexadecanoic acid); LMFA01080009; LMFA01050053; LMFA01050052; LMFA01050368 (2-hydroxy-3-methylhexadecanoic acid)": ["C17H34O3", "Fatty Acyls [FA] with formula: C17H34O3"],
        "LMFA08040045 (Pentadecanoyl-EA)": ["C17H35NO2", "Fatty Acyls [FA] with formula: C17H35NO2"],
        "LMFA11000003 (heptadecane)": ["C17H36", "Fatty Acyls [FA] with formula: C17H36"],
        "LMFA05000192; LMFA05000009": ["C17H36O", "Fatty Acyls [FA] with formula: C17H36O"],
        "LMFA05000069 (iso-1,2-heptadecanediol)": ["C17H36O2", "Fatty Acyls [FA] with formula: C17H36O2"],
        "LMFA01030725; LMFA01030724; LMFA01030723": ["C18H16O3", "Fatty Acyls [FA] with formula: C18H16O3"],
        "LMFA01030736": ["C18H20O2", "Fatty Acyls [FA] with formula: C18H20O2"],
        "LMFA01090031": ["C18H21BrO2", "Fatty Acyls [FA] with formula: C18H21BrO2"],
        "LMFA01030676; LMFA01030675": ["C18H23BrO2", "Fatty Acyls [FA] with formula: C18H23BrO2"],
        "LMFA01030553; LMFA01030554; LMFA01030555; LMFA01030510": ["C18H24O2", "Fatty Acyls [FA] with formula: C18H24O2"],
        "LMFA01050276": ["C18H24O3", "Fatty Acyls [FA] with formula: C18H24O3"],
        "LMFA01030360; LMFA01140003; LMFA01030738; LMFA01030739; LMFA01030737; LMFA01030556; LMFA01030557; LMFA01030558; LMFA01030740; LMFA01030359": ["C18H26O2", "Fatty Acyls [FA] with formula: C18H26O2"],
        "LMFA01050292; LMFA01050291; LMFA01050290; LMFA01060127; LMFA01060163": ["C18H26O3", "Fatty Acyls [FA] with formula: C18H26O3"],
        "LMFA05000063": ["C18H28O", "Fatty Acyls [FA] with formula: C18H28O"],
        "LMFA01030543; LMFA01030548; LMFA01030552; LMFA01030537; LMFA01030541; LMFA01030540; LMFA01030542; LMFA01030545; LMFA01030544; LMFA01030547; LMFA01030546; LMFA01030549; LMFA01140005; LMFA01030734; LMFA01030735; LMFA01030527; LMFA01030526; LMFA01030525; LMFA01030524; LMFA01030523; LMFA01030522; LMFA01030521; LMFA01030520; LMFA01030813; LMFA01030550; LMFA01030551; LMFA01030534; LMFA01030535; LMFA01030536; LMFA01030530; LMFA01030531; LMFA01030532; LMFA01030533; LMFA01030538; LMFA01030539; LMFA01030529; LMFA01030528; LMFA01030354; LMFA01030355; LMFA01030356; LMFA01030358; LMFA01030512; LMFA01030513; LMFA01030511; LMFA01030516; LMFA01030517; LMFA01030514; LMFA01030515; LMFA01030518; LMFA01030519; LMFA01030170 (alpha-parinaric acid); LMFA01030171 (beta-parinaric acid); LMFA01030172; LMFA01030764 (cis-parinaric acid); LMFA01030169; LMFA01030168 (Moroctic acid); LMFA01030167; LMFA01030357 (Stearidonic acid)": ["C18H28O2", "Fatty Acyls [FA] with formula: C18H28O2"],
        "LMFA01070016; LMFA10000002 (Colnelenic acid); LMFA02000053 ((9Z,13S,15Z)-12,13-epoxyoctadeca-9,11,15-trienoic acid); LMFA01050284; LMFA02000028; LMFA01050285; LMFA01050282; LMFA01050283; LMFA01060175 (alpha-licanic acid); LMFA02010001 (12-oxo-PDA)": ["C18H28O3", "Fatty Acyls [FA] with formula: C18H28O3"],
        "LMFA03010210 (Dinor-PGE2); LMFA01060126; LMFA03010214 (Dinor-PGD2)": ["C18H28O5", "Fatty Acyls [FA] with formula: C18H28O5"],
        "LMFA13010032 (Tuberonic acid glucoside)": ["C18H28O9", "Fatty Acyls [FA] with formula: C18H28O9"],
        "LMFA09000002": ["C18H29N", "Fatty Acyls [FA] with formula: C18H29N"],
        "LMFA08020085 (Capsaicin)": ["C18H29NO3", "Fatty Acyls [FA] with formula: C18H29NO3"],
        "LMFA06000243; LMFA06000102; LMFA05000065": ["C18H30O", "Fatty Acyls [FA] with formula: C18H30O"],
        "LMFA01030562; LMFA01030561; LMFA01030560; LMFA01030145 (beta-calendic acid); LMFA01030144 (alpha-calendic acid); LMFA01030146 (Punicic acid); LMFA01030141 (gamma-Linolenic acid); LMFA01030140; LMFA01030142; LMFA01030148 (beta-eleostearic acid); LMFA01030339; LMFA01030147 (alpha-eleostearic acid); LMFA01030143; LMFA01020209; LMFA01030347; LMFA01030344 (Pinolenic acid); LMFA01030343; LMFA01030342; LMFA01030341; LMFA05000398; LMFA01030815 (Columbinic acid); LMFA05000402; LMFA01030742 (Crepenynic acid); LMFA01030741; LMFA01030352; LMFA01030353; LMFA01030197 (Gorlic acid); LMFA01030778 (octadeca-9Z,11E,15Z-trienoic acid); LMFA01030776 ((S)-lamenallenic acid); LMFA01030777 (octadeca-11E,13E,15Z-trienoic acid); LMFA01030775 ((R)-lamenallenic acid); LMFA01030773 (octadeca-9Z,11E,14Z-trienoic acid); LMFA01030151; LMFA01030156; LMFA05000412; LMFA05000418; LMFA01030346; LMFA01030345; LMFA01030340; LMFA01030349; LMFA01030348; LMFA01030350; LMFA01030351; LMFA01140020 (Gorlic acid); LMFA05000401; LMFA05000400; LMFA05000408; LMFA01030152 (alpha-linolenic acid); LMFA01030153 (Elaidolinoleic acid); LMFA01030154; LMFA01030155 (Pseudoeleostearic acid)": ["C18H30O2", "Fatty Acyls [FA] with formula: C18H30O2"],
        "LMFA02000044 (gamma- 12(13)-EpODE); LMFA02000040 (alpha-12(13)-EpODE); LMFA02000042 (gamma- 6(7)-EpODE); LMFA02000043 (gamma- 9(10)-EpODE); LMFA01070015; LMFA01050115 (alpha-kamlolenic acid); LMFA01050116 (beta-kamlolenic acid); LMFA01060071; LMFA01060072; LMFA02000051 (13(S)-HOTrE); LMFA02000041 (alpha-15(16)-EpODE); LMFA02000016 (13-Oxo-ODE); LMFA02000015; LMFA02010002 ((9R,13R)-10-oxo-11-phytoenoic acid); LMFA01050145 (13(S)-HOTrE(gamma)); LMFA01150001; LMFA02000024 (9(S)-HOTrE); LMFA02000029 (13-HOTE); LMFA02000033; LMFA02000039 (alpha-9(10)-EpODE); LMFA10000001 (Colneleic acid); LMFA01050309; LMFA01050308; LMFA01050205; LMFA01050379 (17-hydroxy-linolenic acid); LMFA01060164; LMFA01060177 (9-OxoODE); LMFA02010005 ((9S,13S)-15,16-dihydro-12-oxo-10-phytoenoic acid); LMFA02010004 ((9R,13R)-15,16-dihydro-12-oxo-10-phytoenoic acid); LMFA02010007 ((9S,13S)-10,11-dihydro-12-oxo-15-phytoenoic acid); LMFA02010006 ((9R,13R)-10,11-dihydro-12-oxo-15-phytoenoic acid); LMFA02010003 ((9S,13S)-10-oxo-11-phytoenoic acid)": ["C18H30O3", "Fatty Acyls [FA] with formula: C18H30O3"],
        "LMFA01070005; LMFA01040014; LMFA01040015; LMFA01040016; LMFA01040013; LMFA01040034 (13(S)-HpOTrE(gamma)); LMFA02000019; LMFA02000018 (9(S)-HpOTrE); LMFA02000020; LMFA02000030; LMFA01040067; LMFA01050346; LMFA01060067; LMFA02000052 (13(S)-HpOTrE)": ["C18H30O4", "Fatty Acyls [FA] with formula: C18H30O4"],
        "LMFA03010169 (2,3-dinor-PGE1); LMFA03010212 (Dinor-PGF2alpha); LMFA02000031; LMFA03010011 (2,3-dinor-11b-PGF2alpha); LMFA03110010 (2,3-Dinor-8-iso-PGF2alpha)": ["C18H30O5", "Fatty Acyls [FA] with formula: C18H30O5"],
        "LMFA03030003 (2,3-Dinor-TXB2); LMFA03010089 (2,3-dinor, 6-keto-PGF1alpha)": ["C18H30O6", "Fatty Acyls [FA] with formula: C18H30O6"],
        "LMFA02020014 ((-)-11-hydroxy-9,10-dihydrojasmonic acid 11-beta-D-glucoside)": ["C18H30O9", "Fatty Acyls [FA] with formula: C18H30O9"],
        "LMFA01120002; LMFA01120001; LMFA08030007": ["C18H31NO4", "Fatty Acyls [FA] with formula: C18H31NO4"],
        "LMFA05000216; LMFA06000242; LMFA06000240; LMFA06000241; LMFA06000233; LMFA06000235; LMFA06000234; LMFA06000239; LMFA06000101": ["C18H32O", "Fatty Acyls [FA] with formula: C18H32O"],
        "LMFA01030569; LMFA01030568; LMFA01030563; LMFA01030567; LMFA01030566; LMFA01030565; LMFA01030564; LMFA05000421; LMFA05000420; LMFA05000423; LMFA05000422; LMFA05000425; LMFA05000424; LMFA01030318; LMFA01030319; LMFA01030310; LMFA01030311; LMFA01030312; LMFA01030313; LMFA01030314; LMFA01030315; LMFA01030316; LMFA01030317; LMFA01030309; LMFA01030308; LMFA01030303; LMFA01030302; LMFA01030301; LMFA01030300; LMFA01030307; LMFA01030306; LMFA01030305; LMFA01030304; LMFA01030123 (Linoelaidic acid); LMFA01030122; LMFA01030121; LMFA01030120 (Linoleic acid); LMFA01030127; LMFA01030126; LMFA01030125; LMFA01030124; LMFA01030128; LMFA01030336; LMFA01030337; LMFA01030334; LMFA01030335; LMFA01030332; LMFA01030333; LMFA01030330; LMFA01030331; LMFA01030338; LMFA01030118 (Rumenic acid); LMFA01030119; LMFA01030116; LMFA01030117; LMFA01030114; LMFA01030115; LMFA01030112; LMFA01030113; LMFA01030110; LMFA01030111; LMFA01020207; LMFA01020208; LMFA01030321; LMFA01030320; LMFA01030323 (Sebaleic acid); LMFA01030322; LMFA01030325 (Taxoleic acid); LMFA01030324; LMFA01030327; LMFA01030326; LMFA01030329; LMFA01030328; LMFA01030455 (Stearolic acid); LMFA01030454; LMFA05000397; LMFA05000396; LMFA01140002 (Malvalic acid); LMFA01140017 (Chaulmoogric acid); LMFA01030803 (10E,12Z-octadecadienoic acid); LMFA01030812 (7-trans,9-cis-octadecadienoic acid); LMFA05000404; LMFA01030297; LMFA01030299; LMFA01030298; LMFA01030774 ((R)-laballenic acid); LMFA05000417; LMFA05000419; LMFA05000403; LMFA05000407; LMFA05000406; LMFA05000405; LMFA01030570; LMFA01030571; LMFA01030572; LMFA01030573; LMFA01030574; LMFA01030575; LMFA01030453": ["C18H32O2", "Fatty Acyls [FA] with formula: C18H32O2"],
        "LMFA01070017 (12S,13R-EpOME); LMFA01070018 (9R,10S-EpOME); LMFA01050114 (alpha-artemisic acid); LMFA01050111 (Dimorphecolic acid); LMFA01050112 (Densipolic acid); LMFA01050113; LMFA01070002; LMFA01080011; LMFA02000057 (2R-hydroxy-linoleic acid); LMFA02000055 (10-keto-12Z-octadecenoic acid); LMFA02000054 (Avenoleic acid); LMFA01050277 (beta-Dimorphecolic acid); LMFA01050279; LMFA01050278 (9(S)-HODE); LMFA01050125; LMFA01050124; LMFA02010012; LMFA02010013; LMFA01060122; LMFA01060123; LMFA01060124; LMFA01060125; LMFA01050310; LMFA01050311; LMFA01070011; LMFA02000035 (13(R)-HODE); LMFA02000037 (9(10)-EpOME); LMFA02000036 (9(R)-HODE); LMFA02000038 (12(13)-EpOME); LMFA01050110; LMFA01050204; LMFA01050280; LMFA01050281; LMFA01050312; LMFA01050349 (13(S)-HODE); LMFA01050348": ["C18H32O3", "Fatty Acyls [FA] with formula: C18H32O3"],
        "LMFA02000046 (alpha-12,13-DiHODE); LMFA02000047 (alpha-15,16-DiHODE); LMFA02000048 (gamma- 6,7-DiHODE); LMFA02000049 (gamma- 9,10-DiHODE); LMFA01060068; LMFA01050119; LMFA01070004; LMFA01070003; LMFA02000050 (gamma- 12,13-DiHODE); LMFA01050132; LMFA01050136; LMFA01050137; LMFA01050135; LMFA01060070; LMFA01040007; LMFA01040006; LMFA01040004; LMFA01040001; LMFA01040009; LMFA01040008; LMFA01050120; LMFA02000009; LMFA01060121; LMFA02000013; LMFA02000012 (9(S)-HpODE); LMFA02000010; LMFA02000017; LMFA01050131; LMFA02000045 (alpha-9,10-DiHODE); LMFA02000034 (13(S)-HpODE); LMFA01040066; LMFA01040068; LMFA01170055; LMFA01170056; LMFA01050344; LMFA01060069": ["C18H32O4", "Fatty Acyls [FA] with formula: C18H32O4"],
        "LMFA03010154; LMFA01040010; LMFA01040011; LMFA01050331; LMFA02000022; LMFA02000021": ["C18H32O5", "Fatty Acyls [FA] with formula: C18H32O5"],
        "LMFA01090036; LMFA01090035": ["C18H33FO2", "Fatty Acyls [FA] with formula: C18H33FO2"],
        "LMFA08010008 (Linoleamide)": ["C18H33NO", "Fatty Acyls [FA] with formula: C18H33NO"],
        "LMFA01120003; LMFA01120004": ["C18H33NO4", "Fatty Acyls [FA] with formula: C18H33NO4"],
        "LMFA05000057; LMFA05000048; LMFA05000217; LMFA06000099; LMFA05000214; LMFA06000232; LMFA06000231; LMFA06000230; LMFA06000237; LMFA06000236; LMFA06000100; LMFA05000047; LMFA06000238": ["C18H34O", "Fatty Acyls [FA] with formula: C18H34O"],
        "LMFA05000392; LMFA05000426; LMFA01030068; LMFA01030069; LMFA01030062 (trans-2-oleic acid); LMFA01030063 (3-octadecylenic acid); LMFA01030061; LMFA01030066 (6-octadecylenic acid); LMFA01030067 (Petroselaidic acid); LMFA01030064 (4-octadecylenic acid); LMFA01030065 (5-octadecylenic acid); LMFA01020206; LMFA01030075; LMFA01030074 (cis-10-oleic acid); LMFA01030077 (trans-vaccenic acid); LMFA01030076 (cis-vaccenic acid); LMFA01030071 (trans-8-elaidic acid); LMFA01030070 (cis-8-oleic acid); LMFA01030073 (9-elaidic acid); LMFA01030079 (trans-12-elaidic acid); LMFA01030078 (cis-12-oleic acid); LMFA05000395; LMFA05000394; LMFA05000393; LMFA05000391; LMFA01030002 (Oleic acid); LMFA01140008; LMFA01030295; LMFA01030294; LMFA01030296; LMFA01030291; LMFA01030290; LMFA01030293; LMFA01030292; LMFA05000410; LMFA05000411; LMFA05000413; LMFA05000414; LMFA05000415; LMFA05000416; LMFA05000409; LMFA01030080; LMFA01030081": ["C18H34O2", "Fatty Acyls [FA] with formula: C18H34O2"],
        "LMFA01050107; LMFA01050298; LMFA01050293; LMFA02000056 (2R-hydroxy-oleic acid); LMFA01050297; LMFA01050296; LMFA01050295; LMFA01050294; LMFA01060106; LMFA01060119; LMFA01060118; LMFA01060117; LMFA01060116; LMFA01060115; LMFA01060114; LMFA01060113; LMFA01060112; LMFA01060110; LMFA02000001 (9S,10R-epoxy-stearic acid); LMFA02000002 (9R,10S-epoxy-stearic acid); LMFA01050233 (Ricinoleic acid); LMFA01060120; LMFA01050299; LMFA01050109 (Ricinelaidic acid); LMFA01050305; LMFA01050304; LMFA01050306; LMFA01050301; LMFA01050303; LMFA01050302; LMFA01070001; LMFA01050200; LMFA01050201; LMFA01050202; LMFA01050203; LMFA01050375; LMFA01050199; LMFA01060063 (6-keto stearic acid); LMFA01060062 (5-keto stearic acid); LMFA01060061 (4-keto stearic acid); LMFA01060060 (3-keto stearic acid); LMFA01060066 (10-keto stearic acid); LMFA01060065 (9-keto stearic acid); LMFA01060064 (7-keto-stearic acid)": ["C18H34O3", "Fatty Acyls [FA] with formula: C18H34O3"],
        "LMFA01050127; LMFA01050126; LMFA01050129; LMFA01050128; LMFA02000003 (18-hydroxy-9R,10S-epoxy-stearic acid); LMFA02000004 (18-hydroxy-9S,10R-epoxy-stearic acid); LMFA01170029 (Octadecanedioic acid); LMFA01050350 (9,10-DiHOME); LMFA01050351 (12,13-DiHOME); LMFA01050345": ["C18H34O4", "Fatty Acyls [FA] with formula: C18H34O4"],
        "LMFA01050133; LMFA01050134; LMFA01050336; LMFA01050337; LMFA01050338; LMFA02000011; LMFA02000014 (9,12,13-TriHOME); LMFA01050130": ["C18H34O5", "Fatty Acyls [FA] with formula: C18H34O5"],
        "LMFA01040012; LMFA01050123; LMFA01170030": ["C18H34O6", "Fatty Acyls [FA] with formula: C18H34O6"],
        "LMFA01090015; LMFA01090014; LMFA01090013": ["C18H35BrO2", "Fatty Acyls [FA] with formula: C18H35BrO2"],
        "LMFA01090045": ["C18H35FO2", "Fatty Acyls [FA] with formula: C18H35FO2"],
        "LMFA01090040": ["C18H35IO2", "Fatty Acyls [FA] with formula: C18H35IO2"],
        "LMFA08010004 (Oleamide)": ["C18H35NO", "Fatty Acyls [FA] with formula: C18H35NO"],
        "LMFA08040043 (Palmitoleoyl-EA)": ["C18H35NO2", "Fatty Acyls [FA] with formula: C18H35NO2"],
        "LMFA08020079 (N-palmitoyl glycine)": ["C18H35NO3", "Fatty Acyls [FA] with formula: C18H35NO3"],
        "LMFA05000213; LMFA05000212; LMFA05000215; LMFA06000098 (Stearaldehyde); LMFA05000095 (octadec-11Z-enol)": ["C18H36O", "Fatty Acyls [FA] with formula: C18H36O"],
        "LMFA05000427; LMFA01020094 (neostearic acid); LMFA01020093 (lambda isostearic acid); LMFA01020205; LMFA01020045; LMFA01020044; LMFA01020046; LMFA01020043; LMFA01020042; LMFA01020014 ((+)-Isostearic acid); LMFA01020013; LMFA01020175; LMFA01010018 (Stearic acid); LMFA01020292 (14-Methylheptadecanoic acid)": ["C18H36O2", "Fatty Acyls [FA] with formula: C18H36O2"],
        "LMFA01130002": ["C18H36O2S", "Fatty Acyls [FA] with formula: C18H36O2S"],
        "LMFA01050064 (DL-12-hydroxy stearic acid); LMFA01050065 (DL-13-hydroxy stearic acid); LMFA01050066 (14-hydroxy stearic acid); LMFA01050067 (15-hydroxy stearic acid); LMFA01050060 (DL-8-hydroxy stearic acid); LMFA01050061 (DL-9-hydroxy stearic acid); LMFA01050062 (DL-10-hydroxy stearic acid); LMFA01050063 (DL-11-hydroxy stearic acid); LMFA01050068 (16-hydroxy stearic acid); LMFA01050069 (17-hydroxy stearic acid); LMFA01050288; LMFA01050289; LMFA01050070 (18-hydroxy stearic acid); LMFA01050274; LMFA01050059 (DL-7-hydroxy stearic acid); LMFA01050058 (DL-6-hydroxy stearic acid); LMFA01050055 (DL-3-hydroxy stearic acid); LMFA01050054 (DL-2-hydroxy stearic acid); LMFA01050057 (DL-5-hydroxy stearic acid); LMFA01050056 (DL-4-hydroxy stearic acid); LMFA01050286 (2R-hydroxy-stearic acid); LMFA01050287; LMFA01050360 ((R)-10-hydroxystearic acid); LMFA01050354; LMFA01050355": ["C18H36O3", "Fatty Acyls [FA] with formula: C18H36O3"],
        "LMFA01050093 (11,12-dihydroxy stearic acid); LMFA01050092 (10,11-dihydroxy stearic acid); LMFA01050094 (12,13-dihydroxy stearic acid); LMFA01050091 (9,12-dihydroxy stearic acid); LMFA01050090 (9,10-dihydroxy stearic acid); LMFA02000008 (9S,10R-dihydroxy-stearic acid); LMFA02000007 (9R,10S-dihydroxy-stearic acid); LMFA01050196; LMFA01050197; LMFA01050198; LMFA01050088 (7,8-dihydroxy stearic acid); LMFA01050089 (8,9-dihydroxy stearic acid); LMFA01050369 ((9S,10S)-9,10-dihydroxyoctadecanoic acid); LMFA01050086 (5,6-dihydroxy stearic acid); LMFA01050087 (6,7-dihydroxy stearic acid); LMFA01050085 (2,3-dihydroxy stearic acid)": ["C18H36O4", "Fatty Acyls [FA] with formula: C18H36O4"],
        "LMFA01050103 (Phloionolic acid); LMFA02000005 (18-hydroxy-9S,10R-dihydroxy-stearic acid); LMFA02000006 (9R,10S,18-trihydroxy-stearic acid)": ["C18H36O5", "Fatty Acyls [FA] with formula: C18H36O5"],
        "LMFA01050105 (Sativic acid)": ["C18H36O6", "Fatty Acyls [FA] with formula: C18H36O6"],
        "LMFA08010003 (Stearamide)": ["C18H37NO", "Fatty Acyls [FA] with formula: C18H37NO"],
        "LMFA08040013 (Palmitoyl-EA); LMFA01100008; LMFA01100009": ["C18H37NO2", "Fatty Acyls [FA] with formula: C18H37NO2"],
        "LMFA08020080 (N-palmitoyl taurine)": ["C18H37NO4S", "Fatty Acyls [FA] with formula: C18H37NO4S"],
        "LMFA00000008 ((9S,10S)-10-hydroxy-9-(phosphonooxy)octadecanoic acid)": ["C18H37O7P", "Fatty Acyls [FA] with formula: C18H37O7P"],
        "LMFA05000044; LMFA05000085 (stearyl alcohol)": ["C18H38O", "Fatty Acyls [FA] with formula: C18H38O"],
        "LMFA05000072 (11-methyl-1,2-heptadecanediol); LMFA05000070 (iso-1,2-octadecanediol); LMFA05000071 (anteiso-1,2-octadecanediol)": ["C18H38O2", "Fatty Acyls [FA] with formula: C18H38O2"],
        "LMFA01030502": ["C19H26O2", "Fatty Acyls [FA] with formula: C19H26O2"],
        "LMFA01140016 (Sterculynic acid); LMFA01140025; LMFA01030501": ["C19H30O2", "Fatty Acyls [FA] with formula: C19H30O2"],
        "LMFA01040028": ["C19H30O6", "Fatty Acyls [FA] with formula: C19H30O6"],
        "LMFA09000001": ["C19H31N", "Fatty Acyls [FA] with formula: C19H31N"],
        "LMFA01050307": ["C19H32O2", "Fatty Acyls [FA] with formula: C19H32O2"],
        "LMFA01070014; LMFA01070013; LMFA01070012": ["C19H32O3", "Fatty Acyls [FA] with formula: C19H32O3"],
        "LMFA01040038; LMFA01040039": ["C19H32O4", "Fatty Acyls [FA] with formula: C19H32O4"],
        "LMFA01040046; LMFA01040050; LMFA01040053; LMFA01040055; LMFA01040056; LMFA01040049; LMFA01040048; LMFA01040043; LMFA01040042; LMFA01040041; LMFA01040040; LMFA01040047; LMFA01040045; LMFA01040044": ["C19H32O6", "Fatty Acyls [FA] with formula: C19H32O6"],
        "LMFA01040058; LMFA01040051; LMFA01040052; LMFA01040057": ["C19H32O8", "Fatty Acyls [FA] with formula: C19H32O8"],
        "LMFA01030365; LMFA01030129; LMFA01030503; LMFA01140018 (Sterculic acid)": ["C19H34O2", "Fatty Acyls [FA] with formula: C19H34O2"],
        "LMFA01080002; LMFA01080007; LMFA01170126 (Ceriporic acid A)": ["C19H34O4", "Fatty Acyls [FA] with formula: C19H34O4"],
        "LMFA03030012 (2,3-Dinor-TXB1); LMFA01050150; LMFA01050149": ["C19H34O5", "Fatty Acyls [FA] with formula: C19H34O5"],
        "LMFA06000246; LMFA06000245": ["C19H36O", "Fatty Acyls [FA] with formula: C19H36O"],
        "LMFA01020139; LMFA01020138; LMFA01030364; LMFA01030361; LMFA01030363; LMFA01030362; LMFA05000428; LMFA01020263; LMFA01140001 (Lactobacillic acid); LMFA01140009; LMFA01020001; LMFA01140019 (Dihydrosterculic acid); LMFA01030083": ["C19H36O2", "Fatty Acyls [FA] with formula: C19H36O2"],
        "LMFA01060128; LMFA01060129; LMFA01060131; LMFA01060130": ["C19H36O3", "Fatty Acyls [FA] with formula: C19H36O3"],
        "LMFA01080006": ["C19H36O5", "Fatty Acyls [FA] with formula: C19H36O5"],
        "LMFA06000247": ["C19H38O", "Fatty Acyls [FA] with formula: C19H38O"],
        "LMFA05000429; LMFA01020096; LMFA01020095; LMFA01020269; LMFA01020210; LMFA01020211; LMFA01020212; LMFA01020213; LMFA01020214; LMFA01020215; LMFA01020216; LMFA01020217; LMFA01020218; LMFA01020219; LMFA01020047; LMFA01020016 ((+)-16-methyl stearic acid); LMFA01020015 (Tuberculostearic acid); LMFA01020177; LMFA01020176; LMFA01010019 (Nonadecylic acid)": ["C19H38O2", "Fatty Acyls [FA] with formula: C19H38O2"],
        "LMFA01050072; LMFA01050071": ["C19H38O3", "Fatty Acyls [FA] with formula: C19H38O3"],
        "LMFA08040049 (Margaroyl-EA)": ["C19H39NO2", "Fatty Acyls [FA] with formula: C19H39NO2"],
        "LMFA05000073 (iso-1,2-nonadecanediol); LMFA05000074 (1,2-nonadecanediol)": ["C19H40O2", "Fatty Acyls [FA] with formula: C19H40O2"],
        "LMFA01030691; LMFA01030690": ["C20H24O2", "Fatty Acyls [FA] with formula: C20H24O2"],
        "LMFA03120019 (sodium chlorovulone II); LMFA03120020 (sodium chlorovulone III)": ["C20H27NaO5", "Fatty Acyls [FA] with formula: C20H27NaO5"],
        "LMFA01030699; LMFA01030698; LMFA01030692; LMFA01030697; LMFA01030696": ["C20H28O2", "Fatty Acyls [FA] with formula: C20H28O2"],
        "LMFA03010172 (15-deoxy-delta-12,14-PGA2); LMFA03010200 (PGA2 1,15-lactone); LMFA03120022 (preclavulone lactone II); LMFA03120021 (preclavulone lactone I); LMFA03010021 (15-deoxy-delta-12,14-PGJ2)": ["C20H28O3", "Fatty Acyls [FA] with formula: C20H28O3"],
        "LMFA03010199 (PGE3 1,15-lactone); LMFA03010180 (PGJ3); LMFA03010141 (PGB3); LMFA03010140 (PGA3); LMFA03070026 (5,6-epoxy-18R-HEPE)": ["C20H28O4", "Fatty Acyls [FA] with formula: C20H28O4"],
        "LMFA03020019 (20-trifluoro-LTB4)": ["C20H29F3O4", "Fatty Acyls [FA] with formula: C20H29F3O4"],
        "LMFA01140004; LMFA01030396; LMFA01030397; LMFA01030759 (EPA); LMFA01030180; LMFA01030760; LMFA01030693; LMFA01030695; LMFA01030694": ["C20H30O2", "Fatty Acyls [FA] with formula: C20H30O2"],
        "LMFA03010171 (15d-PGA1); LMFA03000003 (14(15)-EpETE); LMFA03000004 (17(18)-EpETE); LMFA03000006 (17R,18S-EpETE); LMFA03070002 (8R-HEPE); LMFA03070003 (8S-HEPE); LMFA03070008 (12S-HEPE); LMFA03070009 (15S-HEPE); LMFA01030717; LMFA03020023 (LTA4); LMFA03000002 (11(12)-EpETE); LMFA03070028 ((+/-)-8-HEPE); LMFA03070029 ((+/-)-9-HEPE); LMFA03070025 (18R-HEPE); LMFA03070027 ((+/-)-5-HEPE); LMFA03060051 (15-Oxo-ETE); LMFA03060057; LMFA03000001 (8(9)-EpETE); LMFA03070033 ((+/-)-18-HEPE); LMFA03070032 ((+/-)-15-HEPE); LMFA03070031 ((+/-)-12-HEPE); LMFA03070030 ((+/-)-11-HEPE); LMFA03060060; LMFA03060068; LMFA03070006 (11S-HEPE); LMFA03070007 (12R-HEPE); LMFA03070004 (9S-HEPE); LMFA03070005 (11R-HEPE); LMFA03060011 (5-Oxo-ETE); LMFA03060019 (12-oxo-ETE); LMFA03070010 (5S-HEPE); LMFA03020037 (14,15-LTA4); LMFA03020034 (4,5-LTA4)": ["C20H30O3", "Fatty Acyls [FA] with formula: C20H30O3"],
        "LMFA03010197 (PGF3alpha-1,15-lactone); LMFA03010198 (PGE2 1,15-lactone); LMFA03020010 (LTB5); LMFA03020017 (14,15-dehydro-LTB4); LMFA03010092 (15R-PGA2); LMFA03020024 (12-oxo-LTB4); LMFA03010133 (PGC2); LMFA03010051 (15-deoxy-delta-12,14-PGD2); LMFA03010100 (5-trans-PGA2); LMFA01170034; LMFA03010019 (PGJ2); LMFA03010018 (PGB2); LMFA03070020 (Resolvin E2); LMFA03010020 (delta-12-PGJ2); LMFA03070012 (12(S)-HpEPE); LMFA03010033 (13,14-dihydro-15-keto-PGA2); LMFA03010035 (PGA2); LMFA03010034 (bicyclo-PGE2); LMFA03070001 (5(S)-HpEPE); LMFA03060075 (5,6-Ep-15S-HETE); LMFA03070013 (15(S)-HpEPE); LMFA03070018": ["C20H30O4", "Fatty Acyls [FA] with formula: C20H30O4"],
        "LMFA03010167 (19(R)-hydroxy-PGB2); LMFA03010166 (19(R)-hydroxy-PGA2); LMFA03030005 (TXA3); LMFA03010142 (PGD3); LMFA03010130 (19-hydroxy-PGA2); LMFA03010132 (19-hydroxy-PGB2); LMFA03010135 (PGE3); LMFA03010045 (PGI3); LMFA03010206 (15-keto-PGD2); LMFA03010205 (15-dehydro-prostaglandin I2); LMFA03040009 (15-oxo-LXA4); LMFA01030748; LMFA03010023 (PGK2); LMFA03070034 (5S-Hp-18R-HEPE); LMFA03010030 (15-keto-PGE2); LMFA03110009 (8-iso-15-keto-PGE2); LMFA03070019 (Resolvin E1)": ["C20H30O5", "Fatty Acyls [FA] with formula: C20H30O5"],
        "LMFA03030009 (11-dehydro-TXB3); LMFA03020016 (20-carboxy-LTB4)": ["C20H30O6", "Fatty Acyls [FA] with formula: C20H30O6"],
        "LMFA06000197; LMFA05000064": ["C20H32O", "Fatty Acyls [FA] with formula: C20H32O"],
        "LMFA01030688; LMFA01030689; LMFA01030001 (Arachidonic acid); LMFA01140006; LMFA01020222; LMFA01030390; LMFA01030391; LMFA01030392; LMFA01030393; LMFA01030394 (Juniperonic acid); LMFA01030395; LMFA01030687; LMFA01030818 (omega-3-Arachidonic acid); LMFA01030817 (5(E)-Arachidonic acid); LMFA01030816; LMFA01030389; LMFA01030175; LMFA01030176; LMFA01030173": ["C20H32O2", "Fatty Acyls [FA] with formula: C20H32O2"],
        "LMFA03080001 (14R,15S-EpETrE); LMFA03080003 ((+/-)8,9-EpETrE); LMFA03080002 ((+/-)5,6-EpETrE); LMFA03080005 ((+/-)14,15-EpETrE); LMFA03080004 ((+/-)11,12-EpETrE); LMFA03060003 (11S-HETE); LMFA03060002 (5S-HETE); LMFA03060009 (20-HETE); LMFA03060008 (12R-HETE); LMFA01030719; LMFA03060093 (18-hydroxy-arachidonic acid); LMFA03060059; LMFA03060030 (15R-HETE); LMFA01030720; LMFA03060006 (8S-HETE); LMFA03060028 (11R-HETE); LMFA03060024 (5R-HETE); LMFA03060027 (9S-HETE); LMFA03060026 (9R-HETE); LMFA03060021 (8R-HETE); LMFA03060023 (3R-HETE); LMFA03060001 (15S-HETE); LMFA03060007 (12S-HETE); LMFA03060058; LMFA03060054; LMFA03060055; LMFA03060056; LMFA03060062; LMFA03060061; LMFA03060063; LMFA03060065; LMFA03060064; LMFA03060067; LMFA03060066; LMFA03060074 (19S-HETE); LMFA03060094 (20-hydroxy-eicosatetraenoic acid); LMFA03060091 (17-HETE); LMFA03060092 (18-HETE); LMFA03060069 (16R-HETE); LMFA03060084 (5-HETE); LMFA03060089 (9-HETE); LMFA03060088 (12-HETE); LMFA03060087 (15-HETE); LMFA03060086 (8-HETE); LMFA03060085 (11-HETE)": ["C20H32O3", "Fatty Acyls [FA] with formula: C20H32O3"],
        "LMFA03060041 (11-HpETE); LMFA03060045; LMFA03060044; LMFA03010196 (PGF2alpha-1,9-lactone); LMFA03080012 ((5Z,9E,14Z)-(8xi,11R,12S)-11,12-epoxy-8-hydroxyicosa-5,9,14-trienoic acid); LMFA03010131 (PGB1); LMFA03080007 ((+/-)11,12-Ep-15(S)-HETrE); LMFA03010160 (PGC1); LMFA03110008 (8-iso-PGA1); LMFA03020013 (6-trans-LTB4); LMFA03020014 (6-trans-12-epi-LTB4); LMFA03020015 (12-epi-LTB4); LMFA03090003 (Hepoxilin B3); LMFA03020001 (LTB4); LMFA03090005 (Hepoxilin A3); LMFA03010047 (15-epi-PGA1); LMFA03060040 (9-HpETE); LMFA03060076 (8,9-DiHETE); LMFA03060077 (14,15-DiHETE); LMFA03060078 (17,18-DiHETE); LMFA03060079 (11,12-DiHETE); LMFA03010061 (11-deoxy-PGE2); LMFA01170128; LMFA03060095 (5S,11R-DiHETE); LMFA03010071 (PGF2alpha-1,11-lactone); LMFA03010072 (PGF2alpha-1,15-lactone); LMFA03010005 (PGA1); LMFA03090001 (8S-hydroxy-11R,12S-epoxy-5Z,9E,14Z-eicosatrienoic acid); LMFA03060037 (8R-HpETE); LMFA03060050 (8S,15S-DiHETE); LMFA03060052 (5,12-DiHETE); LMFA03060053; LMFA03080008 (14,15-Ep-11-HETrE); LMFA03060013 (12S-HpETE); LMFA03060072 (9S-HpETE); LMFA03060073 (8S-HpETE); LMFA03060070 (12R-HpETE); LMFA03060071 (11R-HpETE); LMFA03060014 (15S-HpETE); LMFA03060017 (5S,6R-DiHETE); LMFA03060010 (5S,15S-DiHETE); LMFA03060018 (5S,6S-DiHETE); LMFA03060090; LMFA03060012 (5S-HpETE)": ["C20H32O4", "Fatty Acyls [FA] with formula: C20H32O4"],
        "LMFA03010170 (PGK1); LMFA03030001 (TXA2); LMFA03020018 (20-hydroxy LTB4); LMFA03100004 (isoLGE2); LMFA03100002 (LGD2); LMFA03100003 (isoLGD2); LMFA03100001 (LGE2); LMFA03010087 (PGI2); LMFA03010146 (15-keto-PGE1); LMFA03010143 (D17 PGE1); LMFA03010148 (5-trans-PGE2); LMFA03010094 (15R-PGE2); LMFA03010138 (PGF3alpha); LMFA03010102 (15R-PGD2); LMFA03010060 (11beta-PGE2); LMFA03040007 (epi-Lipoxin B4); LMFA03040001 (Lipoxin A4); LMFA03040003 (epi-Lipoxin A4); LMFA03040002 (LipoxinB4); LMFA03040008 (13,14-dihydro-15-keto-LXA4); LMFA03010101 (delta-12-PGD2); LMFA03010003 (PGE2); LMFA03010004 (PGD2); LMFA03010010 (PGH2); LMFA01030749; LMFA03010026 (15-keto-PGF2alpha); LMFA03010022 (13,14-dihydro-15-keto-PGD2); LMFA03010031 (13,14-dihydro-15-keto-PGE2); LMFA03110007 (8-iso-PGF3alpha); LMFA03110005 (8-iso-15-keto-PGF2alpha); LMFA03110003 (8-iso-PGE2)": ["C20H32O5", "Fatty Acyls [FA] with formula: C20H32O5"],
        "LMFA03060046; LMFA03030006 (TXB3); LMFA03030004 (11-dehydro-TXB2); LMFA03010149 (D17, 6-keto PGF1a); LMFA03060047; LMFA03010216 (20-hydroxy-PGD2); LMFA03010009 (PGG2); LMFA03010013 (13,14-dihydro-6,15-diketo-PGF1alpha); LMFA03010012 (6-keto PGE1); LMFA03010014 (20-hydroxy-PGE2); LMFA03010024 (19(R)-hydroxy-PGE2); LMFA03060048": ["C20H32O6", "Fatty Acyls [FA] with formula: C20H32O6"],
        "LMFA08010007 (Arachidonoyl amine)": ["C20H33NO", "Fatty Acyls [FA] with formula: C20H33NO"],
        "LMFA08040006 (Anandamide (18:4, n-3)); LMFA08020029 (N-hydroxy arachidonoyl amine)": ["C20H33NO2", "Fatty Acyls [FA] with formula: C20H33NO2"],
        "LMFA05000066": ["C20H34O", "Fatty Acyls [FA] with formula: C20H34O"],
        "LMFA01140021 (Oncobic acid); LMFA01020221; LMFA05000004 (Plaunotol); LMFA01030383; LMFA01030382; LMFA01030381 (ETrE(5Z, 8Z, 11Z)); LMFA01030380 (Sciadonic acid); LMFA01030386; LMFA01030385; LMFA01030384; LMFA01030388; LMFA05000444; LMFA05000443; LMFA01030157; LMFA01030765 ((5Z,9E,14Z)-icosa-5,9,14-trienoic acid); LMFA01030767 (eicosa-5Z,8Z,14Z-trienoic acid); LMFA01030378 (ETrE(11Z, 14Z, 17Z)); LMFA01030379; LMFA01030158 (bishomo-gamma-linolenic acid); LMFA01030159": ["C20H34O2", "Fatty Acyls [FA] with formula: C20H34O2"],
        "LMFA03050005 (5(S)-HETrE); LMFA03050007 (15(S)-HETrE); LMFA03050012 (12R-HETrE); LMFA03050011 (8(S)-HETrE); LMFA01060073; LMFA01150003": ["C20H34O3", "Fatty Acyls [FA] with formula: C20H34O3"],
        "LMFA03010164 (11-deoxy-PGF2beta); LMFA03020004 (12-keto-10,11,14,15-tetrahydro-LTB4); LMFA03050004 ((+/-)5,6-DiHETrE); LMFA03050006 ((+/-)8,9-DiHETrE); LMFA03050008 ((+/-)11,12-DiHETrE); LMFA03050016; LMFA03050015; LMFA03050010 ((+/-)14,15-DiHETrE); LMFA03010054 (11-deoxy-PGE1); LMFA03010078 (11-deoxy-PGF2a)": ["C20H34O4", "Fatty Acyls [FA] with formula: C20H34O4"],
        "LMFA03110029 (15-F2c-IsoP); LMFA03110028 (ent-15-F2c-IsoP); LMFA03110025 (8-F2t-IsoP); LMFA03110027 (ent-15-epi-15-F2c-IsoP); LMFA03110026 (15-epi-15-F2c-IsoP); LMFA03110021 (ent-8-epi-8-F2c-IsoP); LMFA03110020 (8-epi-8-F2c-IsoP); LMFA03110023 (ent-8-F2t-IsoP); LMFA03110024 (8-epi-8-F2t-IsoP); LMFA03110022 (ent-8-epi-8-F2t-IsoP); LMFA03110048 (12-F2c-IsoP); LMFA03110043 (ent-12-epi-12-F2c-IsoP); LMFA03110042 (12-F2t-IsoP); LMFA03110041 (ent-12-F2c-IsoP); LMFA03110040 (ent-5-epi-5-F2c-IsoP); LMFA03110047 (ent-12-epi-12-F2t-IsoP); LMFA03110046 (ent-12-F2t-IsoP); LMFA03110045 (12-epi-12-F2t-IsoP); LMFA03110044 (12-epi-12-F2c-IsoP); LMFA03090002 (Trioxilin A3); LMFA03110004 (8-iso-13,14-dihydro-15-keto-PGF2alpha); LMFA03010150 (15-keto-PGF1alpha); LMFA03010145 (13,14-dihydro-15-keto-PGE1); LMFA03010134 (PGE1); LMFA03010049 (PGD1); LMFA03010044 (PGH1); LMFA03010041 (15R-PGF2alpha); LMFA03050017; LMFA03050018; LMFA03010129 (6beta-PGI1); LMFA03010128 (6alpha-PGI1); LMFA03010055 (15R-PGE1); LMFA03010203 (11beta-13,14-dihydro-15-keto PGF2alpha); LMFA03010077 (5-trans-PGF2alpha); LMFA03010106 (11-beta-PGE1); LMFA03010002 (PGF2alpha); LMFA03090004 (Troxilin B3); LMFA03010027 (13,14-dihydro-15-keto-PGF2alpha); LMFA03010025 (PGF2beta); LMFA03110011 ((+/-) 5-iPF2alpha-VI); LMFA03110018 (ent-8-F2c-IsoP); LMFA03110019 (8-F2c-IsoP); LMFA03010036 (11beta-PGF2alpha); LMFA03110006 (8-iso-PGF2beta); LMFA03110002 (8-iso-PGE1); LMFA03110001 (15-F2t-IsoP); LMFA03110032 (ent-15-epi-15-F2t-IsoP); LMFA03110033 (5-epi-5-F2c-IsoP); LMFA03110030 (15-epi-15-F2t-IsoP); LMFA03110031 (ent-15-F2t-IsoP); LMFA03110036 (ent-5-F2c-IsoP); LMFA03110037 (ent-5-F2t-IsoP); LMFA03110034 (ent-5-epi-5-F2t-IsoP); LMFA03110035 (5-F2c-IsoP); LMFA03110038 (5-epi-5-F2t-IsoP); LMFA03110039 (5-F2t-IsoP)": ["C20H34O5", "Fatty Acyls [FA] with formula: C20H34O5"],
        "LMFA03030002 (TXB2); LMFA03010147 (19(R)-hydroxy-PGE1); LMFA03010042 (19(R)-hydroxy-PGF2alpha); LMFA03010001 (6-keto-PGF1alpha); LMFA03010029 (20-hydroxy-PGF2alpha)": ["C20H34O6", "Fatty Acyls [FA] with formula: C20H34O6"],
        "LMFA08040007 (Anandamide (18:3, n-3)); LMFA08040003 (Anandamide (18:3, n-6))": ["C20H35NO2", "Fatty Acyls [FA] with formula: C20H35NO2"],
        "LMFA05000210": ["C20H36O", "Fatty Acyls [FA] with formula: C20H36O"],
        "LMFA05000438; LMFA05000439; LMFA05000434; LMFA05000432; LMFA05000433; LMFA05000440; LMFA01030130; LMFA05000442; LMFA05000441; LMFA01030373; LMFA01030376; LMFA01030377; LMFA01030374; LMFA01030375": ["C20H36O2", "Fatty Acyls [FA] with formula: C20H36O2"],
        "LMFA03000005 (11(R)-HEDE); LMFA01070021 (Alchornoic acid); LMFA03000009 (11S-HEDE); LMFA03000008 (15(R)-HEDE)": ["C20H36O3", "Fatty Acyls [FA] with formula: C20H36O3"],
        "LMFA01040030 (15S-HpEDE); LMFA03010070 (11-deoxy-PGF1b); LMFA03010053 (PGE1 alcohol); LMFA03010068 (11-deoxy-PGF1a); LMFA03010113 (PGF2alpha alcohol)": ["C20H36O4", "Fatty Acyls [FA] with formula: C20H36O4"],
        "LMFA03010137 (PGF1alpha); LMFA03010168 (13,14-dihydro-15-keto-PGF1alpha); LMFA03010144 (13,14-dihydro-PGE1); LMFA03010069 (PGF1beta); LMFA03010079 (13,14-dihydro-PGF2alpha)": ["C20H36O5", "Fatty Acyls [FA] with formula: C20H36O5"],
        "LMFA03010165 (13,14-dihydro-19(R)-hydroxyPGE1); LMFA03030008 (TXB1); LMFA03010038 (19(R)-hydroxy-PGF1alpha)": ["C20H36O6", "Fatty Acyls [FA] with formula: C20H36O6"],
        "LMFA08040004 (Anandamide (18:2, n-6))": ["C20H37NO2", "Fatty Acyls [FA] with formula: C20H37NO2"],
        "LMFA08020082 (N-oleoyl glycine)": ["C20H37NO3", "Fatty Acyls [FA] with formula: C20H37NO3"],
        "LMFA06000248": ["C20H38O", "Fatty Acyls [FA] with formula: C20H38O"],
        "LMFA05000436; LMFA05000437; LMFA05000430; LMFA05000431; LMFA01030369; LMFA01030368; LMFA01030367; LMFA01030366; LMFA05000435; LMFA01030700; LMFA05000445; LMFA01030372; LMFA01030370; LMFA01030371; LMFA01030082; LMFA01030084 (cis-gadoleic acid); LMFA01030085 (cis-gondoic acid); LMFA01030086 (trans-gondoic acid); LMFA01030087": ["C20H38O2", "Fatty Acyls [FA] with formula: C20H38O2"],
        "LMFA01050257; LMFA01050256; LMFA01050117 (Lesquerolic acid); LMFA01060134; LMFA01060133; LMFA01060132": ["C20H38O3", "Fatty Acyls [FA] with formula: C20H38O3"],
        "LMFA03010173 (PGF1a alcohol); LMFA01170035 (Eicosanedioic acid)": ["C20H38O4", "Fatty Acyls [FA] with formula: C20H38O4"],
        "LMFA01080005; LMFA01080003; LMFA01080004; LMFA01050121; LMFA01050122": ["C20H38O5", "Fatty Acyls [FA] with formula: C20H38O5"],
        "LMFA08040015 (N-oleoyl ethanolamine)": ["C20H39NO2", "Fatty Acyls [FA] with formula: C20H39NO2"],
        "LMFA08020077 (N-stearoyl glycine)": ["C20H39NO3", "Fatty Acyls [FA] with formula: C20H39NO3"],
        "LMFA08020081 (N-oleoyl taurine)": ["C20H39NO4S", "Fatty Acyls [FA] with formula: C20H39NO4S"],
        "LMFA05000051; LMFA06000250; LMFA05000219; LMFA05000220": ["C20H40O", "Fatty Acyls [FA] with formula: C20H40O"],
        "LMFA05000446; LMFA01020052; LMFA01020050; LMFA01020051; LMFA01020049; LMFA01020048; LMFA01020220; LMFA01020017 (Isoarachidic acid); LMFA01010020 (Arachidic acid); LMFA01020287 (3L,7D,11D-hhytanic acid)": ["C20H40O2", "Fatty Acyls [FA] with formula: C20H40O2"],
        "LMFA01050255; LMFA01050075; LMFA01050074; LMFA01050073": ["C20H40O3", "Fatty Acyls [FA] with formula: C20H40O3"],
        "LMFA01050095 (11,12-dihydroxy arachidic acid)": ["C20H40O4", "Fatty Acyls [FA] with formula: C20H40O4"],
        "LMFA08040051 (Stearoyl-EA)": ["C20H41NO2", "Fatty Acyls [FA] with formula: C20H41NO2"],
        "LMFA08020078 (N-stearoyl taurine)": ["C20H41NO4S", "Fatty Acyls [FA] with formula: C20H41NO4S"],
        "LMFA05000221": ["C20H42O", "Fatty Acyls [FA] with formula: C20H42O"],
        "LMFA05000076 (1,2-eicosanediol); LMFA05000075 (13-methyl-1,2-nonadecanediol)": ["C20H42O2", "Fatty Acyls [FA] with formula: C20H42O2"],
        "LMFA03120013 (bromovulone I)": ["C21H29BrO4", "Fatty Acyls [FA] with formula: C21H29BrO4"],
        "LMFA03120008 (chlorovulone I); LMFA03120009 (chlorovulone II); LMFA03120011 (chlorovulone IV); LMFA03120010 (chlorovulone III)": ["C21H29ClO4", "Fatty Acyls [FA] with formula: C21H29ClO4"],
        "LMFA03120012 (10,11-epoxy-chlorovulone I)": ["C21H29ClO5", "Fatty Acyls [FA] with formula: C21H29ClO5"],
        "LMFA03120014 (iodovulone I)": ["C21H29IO4", "Fatty Acyls [FA] with formula: C21H29IO4"],
        "LMFA01030823": ["C21H32O2", "Fatty Acyls [FA] with formula: C21H32O2"],
        "LMFA03010104 (11-deoxy-11-methylene-15-keto-PGD2); LMFA03070015; LMFA03070014; LMFA03070017; LMFA03070016": ["C21H32O4", "Fatty Acyls [FA] with formula: C21H32O4"],
        "LMFA03010058 (9-deoxy-9-methylene-PGE2); LMFA03010103 (11-deoxy-11-methylene-PGD2)": ["C21H34O4", "Fatty Acyls [FA] with formula: C21H34O4"],
        "LMFA03010095 (15R-PGE2 methyl ester); LMFA03010050 (15-methyl-15S-PGD2); LMFA03010063 (15-methyl-15R-PGE2); LMFA03010064 (15-methyl-15S-PGE2); LMFA03010105 (15-methyl-15R-PGD2)": ["C21H34O5", "Fatty Acyls [FA] with formula: C21H34O5"],
        "LMFA03050014; LMFA03050013; LMFA01040061": ["C21H34O8", "Fatty Acyls [FA] with formula: C21H34O8"],
        "LMFA08020007 (N-methyl arachidonoyl amine)": ["C21H35NO", "Fatty Acyls [FA] with formula: C21H35NO"],
        "LMFA01170127 (Ceriporic acid C)": ["C21H36O4", "Fatty Acyls [FA] with formula: C21H36O4"],
        "LMFA03010080 (15-methyl-15S-PGF2alpha); LMFA03010121 (15-methyl-15R-PGF2alpha); LMFA03010056 (15-methyl-15S-PGE1); LMFA03010115 (PGF2alpha methyl ester)": ["C21H36O5", "Fatty Acyls [FA] with formula: C21H36O5"],
        "LMFA01020225; LMFA01020224; LMFA01020226; LMFA01030399": ["C21H38O2", "Fatty Acyls [FA] with formula: C21H38O2"],
        "LMFA01170125 (Ceriporic acid B); LMFA03010073 (PGF2alpha methyl ether)": ["C21H38O4", "Fatty Acyls [FA] with formula: C21H38O4"],
        "LMFA01020135; LMFA01020136; LMFA01030398": ["C21H40O2", "Fatty Acyls [FA] with formula: C21H40O2"],
        "LMFA01060135; LMFA01060137; LMFA01060136; LMFA01060138": ["C21H40O3", "Fatty Acyls [FA] with formula: C21H40O3"],
        "LMFA01170036 (Heneicosanedioic acid)": ["C21H40O4", "Fatty Acyls [FA] with formula: C21H40O4"],
        "LMFA01020033; LMFA01020018; LMFA01010021; LMFA01020223": ["C21H42O2", "Fatty Acyls [FA] with formula: C21H42O2"],
        "LMFA01050076; LMFA01050207; LMFA01050208; LMFA01050209": ["C21H42O3", "Fatty Acyls [FA] with formula: C21H42O3"],
        "LMFA05000078 (15-methyl-1,2-eicosanediol); LMFA05000079 (1,2-heneicosanediol); LMFA05000077 (13-methyl-1,2-eicosanediol)": ["C21H44O2", "Fatty Acyls [FA] with formula: C21H44O2"],
        "LMFA01030677": ["C22H20O2", "Fatty Acyls [FA] with formula: C22H20O2"],
        "LMFA01030679; LMFA01030678": ["C22H24O2", "Fatty Acyls [FA] with formula: C22H24O2"],
        "LMFA01030682; LMFA01030680; LMFA01030681": ["C22H28O2", "Fatty Acyls [FA] with formula: C22H28O2"],
        "LMFA03010066 (16-phenyl-tetranor-PGE2); LMFA03120017 (clavulolactone III); LMFA03120016 (clavulolactone II); LMFA03120015 (clavulolactone I)": ["C22H28O5", "Fatty Acyls [FA] with formula: C22H28O5"],
        "LMFA08040014": ["C22H29NO2", "Fatty Acyls [FA] with formula: C22H29NO2"],
        "LMFA04000014 (16,17-epoxy-DHA)": ["C22H30O3", "Fatty Acyls [FA] with formula: C22H30O3"],
        "LMFA04000001; LMFA04000013 (7,8-epoxy-17S-HDHA)": ["C22H30O4", "Fatty Acyls [FA] with formula: C22H30O4"],
        "LMFA01030684; LMFA01030685; LMFA01030683; LMFA01030185 (DHA)": ["C22H32O2", "Fatty Acyls [FA] with formula: C22H32O2"],
        "LMFA03010163 (1a,1b-dihomo-15-deoxy-delta-12,14-PGJ2); LMFA04000031 ((+/-)-16-HDoHE); LMFA04000036 (13(14)-EpDPE); LMFA04000024 ((+/-)-4-HDoHE); LMFA04000025 ((+/-)-7-HDoHE); LMFA04000026 ((+/-)-8-HDoHE); LMFA04000027 ((+/-)-10-HDoHE); LMFA04000028 ((+/-)-11-HDoHE); LMFA04000029 ((+/-)-13-HDoHE); LMFA04000033 ((+/-)-20-HDoHE); LMFA04000032 ((+/-)-17-HDoHE); LMFA04000037 (16(17)-EpDPE); LMFA04000035 (10(11)-EpDPE); LMFA04000034 (7(8)-EpDPE); LMFA04000038 (19(20)-EpDPE); LMFA04000012 (17S-HDHA); LMFA04000030 ((+/-)-14-HDoHE)": ["C22H32O3", "Fatty Acyls [FA] with formula: C22H32O3"],
        "LMFA04000048 (Maresin 1); LMFA04000047 (10S,17S-DiHDoHE); LMFA04000045 (15-trans-Neuroprotectin-D1); LMFA04000010 (Resolvin D5); LMFA04000011 (Neuroprotectin D1); LMFA01020290": ["C22H32O4", "Fatty Acyls [FA] with formula: C22H32O4"],
        "LMFA04000008 (Resolvin D3); LMFA04000009 (Resolvin D4); LMFA04000006 (Resolvin D1); LMFA04000007 (Resolvin D2)": ["C22H32O5", "Fatty Acyls [FA] with formula: C22H32O5"],
        "LMFA04000049 (docosapentaenoic acid); LMFA04000044 (DPA); LMFA01140013; LMFA01030183; LMFA01030182; LMFA01030184": ["C22H34O2", "Fatty Acyls [FA] with formula: C22H34O2"],
        "LMFA04000042 (16,17-DiHDPE); LMFA04000043 (19,20-DiHDPE); LMFA04000040 (10,11-DiHDPE); LMFA04000041 (13,14-DiHDPE); LMFA03010158 (1a,1b-dihomo-PGJ2); LMFA03010159 (1a,1b-dihomo-15-deoxy-delta-12,14-PGD2); LMFA03010086 (16,16-dimethyl-PGA2); LMFA04000039 (7,8-DiHDPE)": ["C22H34O4", "Fatty Acyls [FA] with formula: C22H34O4"],
        "LMFA04000046 (C22-PGF4alpha)": ["C22H34O5", "Fatty Acyls [FA] with formula: C22H34O5"],
        "LMFA08040008 (Anandamide (20:5, n-3))": ["C22H35NO2", "Fatty Acyls [FA] with formula: C22H35NO2"],
        "LMFA08020003 (N-arachidonoyl glycine)": ["C22H35NO3", "Fatty Acyls [FA] with formula: C22H35NO3"],
        "LMFA08020055 (N-(2-fluro-ethyl) arachidonoyl amine)": ["C22H36FNO", "Fatty Acyls [FA] with formula: C22H36FNO"],
        "LMFA04000050 (Adrenic acid); LMFA05000399; LMFA01140012; LMFA01030178 (Adrenic Acid); LMFA01030179; LMFA01030177": ["C22H36O2", "Fatty Acyls [FA] with formula: C22H36O2"],
        "LMFA03010085 (16,16-dimethyl-PGA1); LMFA03010062 (11-deoxy-16,16-dimethyl-PGE2)": ["C22H36O4", "Fatty Acyls [FA] with formula: C22H36O4"],
        "LMFA03010195 (Dihomo-PGI2); LMFA03010174 (20-ethyl-PGE2); LMFA03010156 (1a,1b-dihomo-PGD2); LMFA03010155 (1a,1b-dihomo-PGE2); LMFA03010052 (16,16-dimethyl-PGD2); LMFA03010065 (16,16-dimethyl-PGE2)": ["C22H36O5", "Fatty Acyls [FA] with formula: C22H36O5"],
        "LMFA03010096 (PGF2alpha-11-acetate); LMFA01040054": ["C22H36O6", "Fatty Acyls [FA] with formula: C22H36O6"],
        "LMFA08020006 (N-ethyl arachidonoyl amine); LMFA08020023 (N,N-dimethyl arachidonoyl amine)": ["C22H37NO", "Fatty Acyls [FA] with formula: C22H37NO"],
        "LMFA00000014 (Virodhamine); LMFA08040001 (Anandamide (20:4, n-6)); LMFA08040028": ["C22H37NO2", "Fatty Acyls [FA] with formula: C22H37NO2"],
        "LMFA08040039 (20-HETE-EA); LMFA08040033 (8(9)-EpETrE-EA); LMFA08040032 (5(6)-EpETrE-EA); LMFA08040035 (14(15)-EpETrE-EA); LMFA08040034 (11(12)-EpETrE-EA); LMFA03020011 (LTB4 dimethyl amide); LMFA08040040 (15-HETE-EA)": ["C22H37NO3", "Fatty Acyls [FA] with formula: C22H37NO3"],
        "LMFA03020012 (LTB4 ethanol amide)": ["C22H37NO4", "Fatty Acyls [FA] with formula: C22H37NO4"],
        "LMFA08020075 (N-arachidonoyl taurine)": ["C22H37NO4S", "Fatty Acyls [FA] with formula: C22H37NO4S"],
        "LMFA03010152 (PGD2-EA); LMFA03010151 (PGE2-EA)": ["C22H37NO5", "Fatty Acyls [FA] with formula: C22H37NO5"],
        "LMFA08020002 (Anandamide 0-phosphate)": ["C22H38NO5P", "Fatty Acyls [FA] with formula: C22H38NO5P"],
        "LMFA01030411; LMFA01030410; LMFA05000450; LMFA01030407; LMFA01030162; LMFA01030161; LMFA01020254; LMFA01020255; LMFA01030408 (DTrE); LMFA01030409": ["C22H38O2", "Fatty Acyls [FA] with formula: C22H38O2"],
        "LMFA01150002": ["C22H38O3", "Fatty Acyls [FA] with formula: C22H38O3"],
        "LMFA03010157 (1a,1b-dihomo-PGF2alpha); LMFA03010083 (16,16-dimethyl-PGF2beta); LMFA03010122 (15-methyl-15R-PGF2alpha methyl ester); LMFA03010120 (20-ethyl PGF2alpha); LMFA03010057 (16,16-dimethyl-PGE1); LMFA03010204 (unoprostone); LMFA03010108 (1a,1b-dihomo-PGE1)": ["C22H38O5", "Fatty Acyls [FA] with formula: C22H38O5"],
        "LMFA08040037 (Mead Acid-EA); LMFA08040005 (Anandamide (20:3, n-3)); LMFA08040011 (Dihomo-gamma-linolenoyl-EA)": ["C22H39NO2", "Fatty Acyls [FA] with formula: C22H39NO2"],
        "LMFA08040031 (14,15-DiHETrE-EA); LMFA08040030 (8,9-DiHETrE-EA); LMFA08040036 (11,12-DiHETrE-EA); LMFA03010074 (PGF2alpha dimethyl amide); LMFA08040029 (5,6-DiHETrE-EA)": ["C22H39NO4", "Fatty Acyls [FA] with formula: C22H39NO4"],
        "LMFA03010208 (11beta-PGF2alpha-EA); LMFA03010209 (PGE1-EA); LMFA03010075 (PGF2alpha-EA); LMFA03110015 (8-iso-PGF2alpha III-EA)": ["C22H39NO5", "Fatty Acyls [FA] with formula: C22H39NO5"],
        "LMFA01030131; LMFA01030132; LMFA01030686; LMFA05000449; LMFA05000447; LMFA01030406; LMFA01020253; LMFA01030405": ["C22H40O2", "Fatty Acyls [FA] with formula: C22H40O2"],
        "LMFA08040002 (Anandamide (20:2, n-6))": ["C22H41NO2", "Fatty Acyls [FA] with formula: C22H41NO2"],
        "LMFA03010114 (PGE2alpha dimethyl amine)": ["C22H41NO3", "Fatty Acyls [FA] with formula: C22H41NO3"],
        "LMFA01020134; LMFA01030090 (trans-brassidic acid); LMFA05000448; LMFA01030401; LMFA01030404; LMFA01030400; LMFA01030402; LMFA01030403; LMFA01030088 (cis-cetoleic acid); LMFA01030089 (cis-erucic acid)": ["C22H42O2", "Fatty Acyls [FA] with formula: C22H42O2"],
        "LMFA01060139; LMFA01060140; LMFA01060141; LMFA01060142; LMFA01060143": ["C22H42O3", "Fatty Acyls [FA] with formula: C22H42O3"],
        "LMFA01170037 (Docosanedioic acid)": ["C22H42O4", "Fatty Acyls [FA] with formula: C22H42O4"],
        "LMFA08040010 (Anandamide (20:l, n-9))": ["C22H43NO2", "Fatty Acyls [FA] with formula: C22H43NO2"],
        "LMFA08020049": ["C22H44FNO", "Fatty Acyls [FA] with formula: C22H44FNO"],
        "LMFA01010022 (Behenic acid); LMFA01020228; LMFA01020227; LMFA05000451; LMFA01020019 (Isobehenic acid)": ["C22H44O2", "Fatty Acyls [FA] with formula: C22H44O2"],
        "LMFA01050077 (2-hydroxy behenic); LMFA01050079 (omega-hydroxy behenic); LMFA01050078 ((+)-3-hydroxy behenic); LMFA01050210": ["C22H44O3", "Fatty Acyls [FA] with formula: C22H44O3"],
        "LMFA01050211": ["C22H44O4", "Fatty Acyls [FA] with formula: C22H44O4"],
        "LMFA08040038 (Eicosanoyl-EA)": ["C22H45NO2", "Fatty Acyls [FA] with formula: C22H45NO2"],
        "LMFA05000008 (Behenyl alcohol)": ["C22H46O", "Fatty Acyls [FA] with formula: C22H46O"],
        "LMFA05000080 (15-methyl-1,2-heneicosanediol)": ["C22H46O2", "Fatty Acyls [FA] with formula: C22H46O2"],
        "LMFA05000067": ["C22H46O8S2", "Fatty Acyls [FA] with formula: C22H46O8S2"],
        "LMFA03010067 (17-phenyl-trinor-PGE2)": ["C23H30O5", "Fatty Acyls [FA] with formula: C23H30O5"],
        "LMFA03120044 (punaglandin 7)": ["C23H31ClO6", "Fatty Acyls [FA] with formula: C23H31ClO6"],
        "LMFA03010081 (17-phenyl-trinor-PGF2alpha)": ["C23H32O5", "Fatty Acyls [FA] with formula: C23H32O5"],
        "LMFA03120045 (punaglandin 8)": ["C23H33ClO6", "Fatty Acyls [FA] with formula: C23H33ClO6"],
        "LMFA03010123 (17-phenyl-trinor-PGF2alpha amide)": ["C23H33NO4", "Fatty Acyls [FA] with formula: C23H33NO4"],
        "LMFA03010202 (15R-PGA2 methyl ester, 15-acetate)": ["C23H34O5", "Fatty Acyls [FA] with formula: C23H34O5"],
        "LMFA03010201 (15R-PGE2 methyl ester, 15-acetate)": ["C23H36O6", "Fatty Acyls [FA] with formula: C23H36O6"],
        "LMFA08020004 (N-arachidonoyl D-serine); LMFA08020073 (N-arachidonoyl L-serine)": ["C23H37NO4", "Fatty Acyls [FA] with formula: C23H37NO4"],
        "LMFA03020033 (14,15-LTE4); LMFA03020002 (LTE4); LMFA03020022 (11-trans-LTE4)": ["C23H37NO5S", "Fatty Acyls [FA] with formula: C23H37NO5S"],
        "LMFA03020025 (20-hydroxy-LTE4); LMFA03040006 (Lipoxin E4)": ["C23H37NO6S", "Fatty Acyls [FA] with formula: C23H37NO6S"],
        "LMFA08020056 (N-(2-fluro-ethyl) 2-methyl-arachidonoyl amine)": ["C23H38FNO", "Fatty Acyls [FA] with formula: C23H38FNO"],
        "LMFA00000004 (N-linolenoyl-glutamine)": ["C23H38N2O4", "Fatty Acyls [FA] with formula: C23H38N2O4"],
        "LMFA07050029 (Acetyl-CoA)": ["C23H38N7O17P3S", "Fatty Acyls [FA] with formula: C23H38N7O17P3S"],
        "LMFA03010059 (9-deoxy-9-methylene-16,16-dimethyl -PGE2)": ["C23H38O4", "Fatty Acyls [FA] with formula: C23H38O4"],
        "LMFA03010097 (PGF2alpha-11-acetate methyl ester)": ["C23H38O6", "Fatty Acyls [FA] with formula: C23H38O6"],
        "LMFA03010190 (1(3)-glyceryl-PGH2); LMFA03010183 (2-glyceryl-PGD2); LMFA03010185 (2-glyceryl-PGE2); LMFA03010186 (1(3)-glyceryl-PGE2); LMFA03010189 (2-glyceryl-PGH2); LMFA03010184 (1(3)-glyceryl-PGD2)": ["C23H38O7", "Fatty Acyls [FA] with formula: C23H38O7"],
        "LMFA08020009 (N-propyl arachidonoyl amine); LMFA08020010 (N-isopropyl arachidonoyl amine)": ["C23H39NO", "Fatty Acyls [FA] with formula: C23H39NO"],
        "LMFA08020018 (N-(3-hydroxy-propyl) arachidonoyl amine); LMFA08020025 (N-methyl N-(2-hydroxy-ethyl) arachidonoyl amine); LMFA08020021 (N-(2-methoxy-ethyl) arachidonoyl amine); LMFA08040016 (alpha-methyl anandamide); LMFA08020040 (N-(1R-methyl-2-hydroxy-ethyl) arachidonoyl amine); LMFA08020041 (N-(2-methyl-2S-hydroxy-ethyl) arachidonoyl amine); LMFA08040020": ["C23H39NO2", "Fatty Acyls [FA] with formula: C23H39NO2"],
        "LMFA08020072 (N-arachidonoyl dihydroxypropylamine)": ["C23H39NO3", "Fatty Acyls [FA] with formula: C23H39NO3"],
        "LMFA03010192 (PGE2-dihydroxypropanylamine); LMFA03010191 (PGD2-dihydroxypropanylamine)": ["C23H39NO6", "Fatty Acyls [FA] with formula: C23H39NO6"],
        "LMFA05000011 (Persin)": ["C23H40O4", "Fatty Acyls [FA] with formula: C23H40O4"],
        "LMFA03010076 (PGF2alpha isopropyl ester)": ["C23H40O5", "Fatty Acyls [FA] with formula: C23H40O5"],
        "LMFA03010181 (1(3)-glyceryl-PGF2alpha); LMFA03010182 (2-glyceryl-PGF2alpha)": ["C23H40O7", "Fatty Acyls [FA] with formula: C23H40O7"],
        "LMFA03010187 (1(3)-glyceryl-6-keto-PGF1alpha); LMFA03010188 (2-glyceryl-6-keto-PGF1alpha)": ["C23H40O8", "Fatty Acyls [FA] with formula: C23H40O8"],
        "LMFA03010193 (PGF2alpha-dihydroxypropanylamine)": ["C23H41NO6", "Fatty Acyls [FA] with formula: C23H41NO6"],
        "LMFA01040036; LMFA01040037": ["C23H42O4", "Fatty Acyls [FA] with formula: C23H42O4"],
        "LMFA07070007 (hexadecanedioic acid mono-L-carnitine ester)": ["C23H43NO6", "Fatty Acyls [FA] with formula: C23H43NO6"],
        "LMFA01030415; LMFA01030091; LMFA01030416; LMFA01030414; LMFA01030413; LMFA01030412": ["C23H44O2", "Fatty Acyls [FA] with formula: C23H44O2"],
        "LMFA01060144; LMFA01060145; LMFA01060146": ["C23H44O3", "Fatty Acyls [FA] with formula: C23H44O3"],
        "LMFA01170038 (Tricosanedioic acid)": ["C23H44O4", "Fatty Acyls [FA] with formula: C23H44O4"],
        "LMFA07070004 (Palmitoylcarnitine)": ["C23H45NO4", "Fatty Acyls [FA] with formula: C23H45NO4"],
        "LMFA01010023; LMFA01020230; LMFA01020020": ["C23H46O2", "Fatty Acyls [FA] with formula: C23H46O2"],
        "LMFA01050212": ["C23H46O3", "Fatty Acyls [FA] with formula: C23H46O3"],
        "LMFA05000082 (1,2-tricosanediol); LMFA05000081 (1,2-docasanediol)": ["C23H48O2", "Fatty Acyls [FA] with formula: C23H48O2"],
        "LMFA01030746": ["C24H24O2", "Fatty Acyls [FA] with formula: C24H24O2"],
        "LMFA01030747": ["C24H28O2", "Fatty Acyls [FA] with formula: C24H28O2"],
        "LMFA01030804 (tetracosahexaenoic acid); LMFA01030822 (Nisinic acid); LMFA01030186": ["C24H36O2", "Fatty Acyls [FA] with formula: C24H36O2"],
        "LMFA08040009 (Anandamide (22:6, n-3))": ["C24H37NO2", "Fatty Acyls [FA] with formula: C24H37NO2"],
        "LMFA07050031 (Malonyl CoA)": ["C24H38N7O19P3S", "Fatty Acyls [FA] with formula: C24H38N7O19P3S"],
        "LMFA01140015; LMFA01030820; LMFA01030821": ["C24H38O2", "Fatty Acyls [FA] with formula: C24H38O2"],
        "LMFA03010098 (18-acetoxy-PGF2alpha-11-acetate)": ["C24H38O8", "Fatty Acyls [FA] with formula: C24H38O8"],
        "LMFA08020052 (Arachidonoylmorpholine)": ["C24H39NO2", "Fatty Acyls [FA] with formula: C24H39NO2"],
        "LMFA08020074 (N-arachidonoyl L-GABA)": ["C24H39NO3", "Fatty Acyls [FA] with formula: C24H39NO3"],
        "LMFA01140014; LMFA01030805 (tetracosatetraenoic acid n-6); LMFA01030819": ["C24H40O2", "Fatty Acyls [FA] with formula: C24H40O2"],
        "LMFA08020012 (N-tert-butyl arachidonoyl amine); LMFA08020011 (N-butyl arachidonoyl amine); LMFA08020017 ((+)N-(1S-methyl-propyl) arachidonoyl amine); LMFA08020016 ((-)N-(1R-methyl-propyl) arachidonoyl amine); LMFA08020024 (N,N-diethyl arachidonoyl amine); LMFA08020035 (N-isopropyl alpha-methylarachidonoyl amine); LMFA08020033 (N-propyl alpha-methyl arachidonoyl amine)": ["C24H41NO", "Fatty Acyls [FA] with formula: C24H41NO"],
        "LMFA08020019 (N-(1,1-dimethyl-2-hydroxy-ethyl) arachidonoyl amine); LMFA08040017 (alpha,alpha-dimethyl anandamide); LMFA08020026 (N-ethyl N-(2-hydroxy-ethyl) arachidonoyl amine); LMFA08040047 (Adrenoyl-EA); LMFA08040021": ["C24H41NO2", "Fatty Acyls [FA] with formula: C24H41NO2"],
        "LMFA08020028 (N,N-(2,2-dihydroxy-ethyl) arachidonoyl amine)": ["C24H41NO3", "Fatty Acyls [FA] with formula: C24H41NO3"],
        "LMFA01030417": ["C24H44O2", "Fatty Acyls [FA] with formula: C24H44O2"],
        "LMFA01060148": ["C24H44O3", "Fatty Acyls [FA] with formula: C24H44O3"],
        "LMFA06000105; LMFA06000104": ["C24H46O", "Fatty Acyls [FA] with formula: C24H46O"],
        "LMFA01030093 (trans-selacholeic acid); LMFA01030092 (Nervonic acid); LMFA01020336 (Mycolipenic acid (C25)); LMFA05000452": ["C24H46O2", "Fatty Acyls [FA] with formula: C24H46O2"],
        "LMFA01060147; LMFA01050216; LMFA01050215": ["C24H46O3", "Fatty Acyls [FA] with formula: C24H46O3"],
        "LMFA01170039 (Tetracosanedioic acid)": ["C24H46O4", "Fatty Acyls [FA] with formula: C24H46O4"],
        "LMFA08040050 (Erucicoyl-EA)": ["C24H47NO2", "Fatty Acyls [FA] with formula: C24H47NO2"],
        "LMFA06000103": ["C24H48O", "Fatty Acyls [FA] with formula: C24H48O"],
        "LMFA01010024 (Lignoceric acid); LMFA01020232; LMFA01020231; LMFA01020308 (Mycocerosic acid (C24)); LMFA01020021; LMFA05000453; LMFA01020229; LMFA01020293 (Mycosanoic acid (C24))": ["C24H48O2", "Fatty Acyls [FA] with formula: C24H48O2"],
        "LMFA01020332 (Mycolipanolic acid (C24)); LMFA01050321; LMFA01050214; LMFA01050213; LMFA01050080 (DL-Cerebronic acid)": ["C24H48O3", "Fatty Acyls [FA] with formula: C24H48O3"],
        "LMFA08040052 (Behenoyl-EA)": ["C24H49NO2", "Fatty Acyls [FA] with formula: C24H49NO2"],
        "LMFA08020083 (N-docosanoyl taurine)": ["C24H49NO4S", "Fatty Acyls [FA] with formula: C24H49NO4S"],
        "LMFA05000222 (Lignoceryl alcohol)": ["C24H50O", "Fatty Acyls [FA] with formula: C24H50O"],
        "LMFA05000083 (1,2-tetracosanediol)": ["C24H50O2", "Fatty Acyls [FA] with formula: C24H50O2"],
        "LMFA03120018 (17,18-dehydro-clavulone I)": ["C25H32O7", "Fatty Acyls [FA] with formula: C25H32O7"],
        "LMFA03120035 (7Z-punaglandin 3); LMFA03120031 (punaglandin 3)": ["C25H33ClO8", "Fatty Acyls [FA] with formula: C25H33ClO8"],
        "LMFA03120039 (10S,11R-epoxy-punaglandin 3)": ["C25H33ClO9", "Fatty Acyls [FA] with formula: C25H33ClO9"],
        "LMFA03120004 (clavulone IV); LMFA03120001 (clavulone I); LMFA03120002 (clavulone II); LMFA03120003 (clavulone III); LMFA03120023 (4-epi-clavulone II); LMFA03120024 (4-epi-clavulone III)": ["C25H34O7", "Fatty Acyls [FA] with formula: C25H34O7"],
        "LMFA03120037 (7Z-punaglandin 4); LMFA03120033 (punaglandin 4); LMFA03120041 (punaglandin 5)": ["C25H35ClO8", "Fatty Acyls [FA] with formula: C25H35ClO8"],
        "LMFA03120040 (10S,11R-epoxy-punaglandin 4)": ["C25H35ClO9", "Fatty Acyls [FA] with formula: C25H35ClO9"],
        "LMFA03120043 (punaglandin 6)": ["C25H37ClO8", "Fatty Acyls [FA] with formula: C25H37ClO8"],
        "LMFA03020008 (N-acetyl-LTE4)": ["C25H39NO6S", "Fatty Acyls [FA] with formula: C25H39NO6S"],
        "LMFA03020032 (14,15-LTD4); LMFA03020006 (LTD4); LMFA03020021 (11-trans-LTD4)": ["C25H40N2O6S", "Fatty Acyls [FA] with formula: C25H40N2O6S"],
        "LMFA03040005 (Lipoxin D4)": ["C25H40N2O7S", "Fatty Acyls [FA] with formula: C25H40N2O7S"],
        "LMFA07050030 (Acetoacetyl-CoA)": ["C25H40N7O18P3S", "Fatty Acyls [FA] with formula: C25H40N7O18P3S"],
        "LMFA03010099 (18-acetoxy-PGF2alpha-11-acetate methyl ester)": ["C25H40O8", "Fatty Acyls [FA] with formula: C25H40O8"],
        "LMFA05000218": ["C25H42O", "Fatty Acyls [FA] with formula: C25H42O"],
        "LMFA01030745": ["C25H42O2", "Fatty Acyls [FA] with formula: C25H42O2"],
        "LMFA08020013 (N-amyl arachidohoyl amine); LMFA08020015 (N-(1,1-dimethyl-propyl) arachidonoyl amine); LMFA08020014 (N-(3-methyl-butyl) arachidonoyl amine); LMFA08020034 (N-propyl alpha,alpha-dimethylarachidonoyl amine); LMFA08020036 (N-isopropyl alpha,alpha-dimethylarachidonoyl amine)": ["C25H43NO", "Fatty Acyls [FA] with formula: C25H43NO"],
        "LMFA08020039 ((+)N-(1S-methyl-2-hydroxy-ethyl) alpha,alpha-dimethylarachidonoyl amine); LMFA08020020 (N-(5-hydroxy-pentyl) arachidonoyl amine); LMFA08020038 ((-)N-(1R-methyl-2-hydroxy-ethyl) alpha,alpha-dimethylarachidonoyl amine); LMFA08020037 ((+)N-(2S-hydroxy-propyl) alpha,alpha-dimethylarachidonoyl amine); LMFA08040019; LMFA08020047 ((-)N-(2R-hydroxy-propyl) alpha,alpha-dimethylarachidonoyl amine); LMFA08040022; LMFA08020027 (N-propyl N-(2-hydroxy-ethyl) arachidonoyl amine); LMFA08040026; LMFA08040027": ["C25H43NO2", "Fatty Acyls [FA] with formula: C25H43NO2"],
        "LMFA01110001 (Type IV cyanolipid eicosanoyl ester)": ["C25H45NO2", "Fatty Acyls [FA] with formula: C25H45NO2"],
        "LMFA01020233": ["C25H46O2", "Fatty Acyls [FA] with formula: C25H46O2"],
        "LMFA01030419; LMFA01030418; LMFA01030420; LMFA01030421": ["C25H48O2", "Fatty Acyls [FA] with formula: C25H48O2"],
        "LMFA01050118 (Hydroxynervonic acid)": ["C25H48O3", "Fatty Acyls [FA] with formula: C25H48O3"],
        "LMFA07070008 (Stearoylcarnitine)": ["C25H49NO4", "Fatty Acyls [FA] with formula: C25H49NO4"],
        "LMFA06000106": ["C25H50O", "Fatty Acyls [FA] with formula: C25H50O"],
        "LMFA01010025; LMFA01020309 (Mycocerosic acid (C25)); LMFA01020023 ((+)-Isopentacosanoic acid); LMFA01020294 (Mycosanoic acid (C25))": ["C25H50O2", "Fatty Acyls [FA] with formula: C25H50O2"],
        "LMFA01050217": ["C25H50O3", "Fatty Acyls [FA] with formula: C25H50O3"],
        "LMFA13010006": ["C25H50O7", "Fatty Acyls [FA] with formula: C25H50O7"],
        "LMFA08040053 (Tricosanoyl-EA)": ["C25H51NO2", "Fatty Acyls [FA] with formula: C25H51NO2"],
        "LMFA08020051 (N-(4-bromo-benzenesulfon) arachidonoyl amine)": ["C26H36BrNO3S", "Fatty Acyls [FA] with formula: C26H36BrNO3S"],
        "LMFA08020050 (N-(4-benzenesulfonamide) arachidonoyl amine)": ["C26H38N2O3S", "Fatty Acyls [FA] with formula: C26H38N2O3S"],
        "LMFA03010124 (17-phenyl-trinor-PGF2alpha isopropyl ester)": ["C26H38O5", "Fatty Acyls [FA] with formula: C26H38O5"],
        "LMFA08020068; LMFA08020071; LMFA08020070": ["C26H44FNO", "Fatty Acyls [FA] with formula: C26H44FNO"],
        "LMFA08040018; LMFA08040025; LMFA08040023": ["C26H45NO2", "Fatty Acyls [FA] with formula: C26H45NO2"],
        "LMFA08020022": ["C26H46N2O", "Fatty Acyls [FA] with formula: C26H46N2O"],
        "LMFA01030428; LMFA01030429; LMFA01030426; LMFA01030427": ["C26H46O2", "Fatty Acyls [FA] with formula: C26H46O2"],
        "LMFA01090017; LMFA01090016": ["C26H47BrO2", "Fatty Acyls [FA] with formula: C26H47BrO2"],
        "LMFA01030133; LMFA01030424; LMFA01030425": ["C26H48O2", "Fatty Acyls [FA] with formula: C26H48O2"],
        "LMFA01060149": ["C26H48O3", "Fatty Acyls [FA] with formula: C26H48O3"],
        "LMFA01030095 (Ximenic acid); LMFA01030094; LMFA01020337 (Mycolipenic acid (C27)); LMFA01030422; LMFA01030423": ["C26H50O2", "Fatty Acyls [FA] with formula: C26H50O2"],
        "LMFA01060181 (3-oxohexacosanoic acid)": ["C26H50O3", "Fatty Acyls [FA] with formula: C26H50O3"],
        "LMFA01170040 (Hexacosanedioic acid)": ["C26H50O4", "Fatty Acyls [FA] with formula: C26H50O4"],
        "LMFA08040055 (Nervonoyl-EA)": ["C26H51NO2", "Fatty Acyls [FA] with formula: C26H51NO2"],
        "LMFA05000223; LMFA06000107": ["C26H52O", "Fatty Acyls [FA] with formula: C26H52O"],
        "LMFA01010026 (Cerotic acid); LMFA01020310 (Mycocerosic acid (C26)); LMFA01020022; LMFA01020024 (Isocerotic acid); LMFA05000454; LMFA01020295 (Mycosanoic acid (C26))": ["C26H52O2", "Fatty Acyls [FA] with formula: C26H52O2"],
        "LMFA01050263; LMFA01020333 (Mycolipanolic acid (C26)); LMFA01050372 ((S)-3-hydroxyhexacosanoic acid); LMFA01050219; LMFA01050218; LMFA01050356": ["C26H52O3", "Fatty Acyls [FA] with formula: C26H52O3"],
        "LMFA13010005": ["C26H52O7", "Fatty Acyls [FA] with formula: C26H52O7"],
        "LMFA08040054 (Lignoceroyl-EA)": ["C26H53NO2", "Fatty Acyls [FA] with formula: C26H53NO2"],
        "LMFA05000002 (Ceryl alcohol)": ["C26H54O", "Fatty Acyls [FA] with formula: C26H54O"],
        "LMFA03120036 (12R-acetoxy-7Z-punaglandin 3); LMFA03120032 (12R-acetoxy-punaglandin 3)": ["C27H35ClO9", "Fatty Acyls [FA] with formula: C27H35ClO9"],
        "LMFA03120005 (20-acetoxy-clavulone I); LMFA03120006 (20-acetoxy-clavulone I); LMFA03120007 (20-acetoxy-clavulone III)": ["C27H36O9", "Fatty Acyls [FA] with formula: C27H36O9"],
        "LMFA03120027 (punaglandin 1)": ["C27H37ClO10", "Fatty Acyls [FA] with formula: C27H37ClO10"],
        "LMFA03120038 (12R-acetoxy-7Z-punaglandin 4); LMFA03120034 (12R-acetoxy-punaglandin 4); LMFA03120042 (12S-acetoxy-punaglandin 5)": ["C27H37ClO9", "Fatty Acyls [FA] with formula: C27H37ClO9"],
        "LMFA03120029 (punaglandin 2)": ["C27H39ClO10", "Fatty Acyls [FA] with formula: C27H39ClO10"],
        "LMFA05000455": ["C27H42O2", "Fatty Acyls [FA] with formula: C27H42O2"],
        "LMFA07050019": ["C27H44N7O17P3S", "Fatty Acyls [FA] with formula: C27H44N7O17P3S"],
        "LMFA07050018": ["C27H44N7O18P3S", "Fatty Acyls [FA] with formula: C27H44N7O18P3S"],
        "LMFA07050028 (HMG-CoA)": ["C27H44N7O20P3S", "Fatty Acyls [FA] with formula: C27H44N7O20P3S"],
        "LMFA08020069; LMFA08020066": ["C27H46FNO", "Fatty Acyls [FA] with formula: C27H46FNO"],
        "LMFA07050001": ["C27H46N7O17P3S", "Fatty Acyls [FA] with formula: C27H46N7O17P3S"],
        "LMFA07050017": ["C27H46N7O18P3S", "Fatty Acyls [FA] with formula: C27H46N7O18P3S"],
        "LMFA01030701": ["C27H46O2", "Fatty Acyls [FA] with formula: C27H46O2"],
        "LMFA08020046": ["C27H47NO", "Fatty Acyls [FA] with formula: C27H47NO"],
        "LMFA08020044; LMFA08020045; LMFA08020043": ["C27H47NO2", "Fatty Acyls [FA] with formula: C27H47NO2"],
        "LMFA01030750": ["C27H50O2", "Fatty Acyls [FA] with formula: C27H50O2"],
        "LMFA13030001": ["C27H50O9", "Fatty Acyls [FA] with formula: C27H50O9"],
        "LMFA01020264; LMFA01030430; LMFA01020338 (Mycolipenic acid (C28)); LMFA01020032 ((+)-C27-Phthienoic acid); LMFA01020256": ["C27H52O2", "Fatty Acyls [FA] with formula: C27H52O2"],
        "LMFA01010027 (Carboceric acid); LMFA01020311 (Mycocerosic acid (C27)); LMFA01020025": ["C27H54O2", "Fatty Acyls [FA] with formula: C27H54O2"],
        "LMFA01020334 (Mycolipanolic acid (C27))": ["C27H54O3", "Fatty Acyls [FA] with formula: C27H54O3"],
        "LMFA05000456 (Heptacosanol)": ["C27H56O", "Fatty Acyls [FA] with formula: C27H56O"],
        "LMFA01030811": ["C28H40O2", "Fatty Acyls [FA] with formula: C28H40O2"],
        "LMFA08020054 (N-(2-phenoxy-ethyl) arachidonoyl amine)": ["C28H41NO2", "Fatty Acyls [FA] with formula: C28H41NO2"],
        "LMFA08020084 (N-arachidonoyl-dopamine)": ["C28H41NO3", "Fatty Acyls [FA] with formula: C28H41NO3"],
        "LMFA08020053 (N-(2'-(4-benzenesulfonamide)-ethyl) arachidonoyl amine)": ["C28H42N2O3S", "Fatty Acyls [FA] with formula: C28H42N2O3S"],
        "LMFA03020009 (LTF4)": ["C28H44N2O8S", "Fatty Acyls [FA] with formula: C28H44N2O8S"],
        "LMFA08020067": ["C28H48FNO", "Fatty Acyls [FA] with formula: C28H48FNO"],
        "LMFA01060150": ["C28H52O3", "Fatty Acyls [FA] with formula: C28H52O3"],
        "LMFA01030096; LMFA01030431; LMFA01030433; LMFA01030432; LMFA01020339 (Mycolipenic acid (C29)); LMFA01030733": ["C28H54O2", "Fatty Acyls [FA] with formula: C28H54O2"],
        "LMFA06000108": ["C28H56O", "Fatty Acyls [FA] with formula: C28H56O"],
        "LMFA01010028 (Montanic acid); LMFA01020312 (Mycocerosic acid (C28)); LMFA01020026 (Isomontanic acid)": ["C28H56O2", "Fatty Acyls [FA] with formula: C28H56O2"],
        "LMFA01020335 (Mycolipanolic acid (C28)); LMFA01050220": ["C28H56O3", "Fatty Acyls [FA] with formula: C28H56O3"],
        "LMFA05000003 (Montanyl alcohol)": ["C28H58O", "Fatty Acyls [FA] with formula: C28H58O"],
        "LMFA03120028 (12S-acetoxy-punaglandin 1)": ["C29H39ClO11", "Fatty Acyls [FA] with formula: C29H39ClO11"],
        "LMFA03120030 (12S-acetoxy-punaglandin 2)": ["C29H41ClO11", "Fatty Acyls [FA] with formula: C29H41ClO11"],
        "LMFA08020076 (N-arachidonoyl tyrosine)": ["C29H41NO4", "Fatty Acyls [FA] with formula: C29H41NO4"],
        "LMFA08020030 ((+/-)N-(1-methyl-2-hydroxy-2-phenyl-ethyl) arachidonyl amine)": ["C29H43NO2", "Fatty Acyls [FA] with formula: C29H43NO2"],
        "LMFA07050024": ["C29H48N7O17P3S", "Fatty Acyls [FA] with formula: C29H48N7O17P3S"],
        "LMFA12000008 (nonacosan-10-one)": ["C29H58O", "Fatty Acyls [FA] with formula: C29H58O"],
        "LMFA01010029; LMFA01020313 (Mycocerosic acid (C29))": ["C29H58O2", "Fatty Acyls [FA] with formula: C29H58O2"],
        "LMFA11000005 (nonacosane)": ["C29H60", "Fatty Acyls [FA] with formula: C29H60"],
        "LMFA05000457 (Nonacosanol); LMFA05000098 (nonacosan-10-ol); LMFA05000088 ((S)-nonacosan-10-ol); LMFA05000087 ((R)-nonacosan-10-ol)": ["C29H60O", "Fatty Acyls [FA] with formula: C29H60O"],
        "LMFA01010002 (Acetic acid)": ["C2H4O2", "Fatty Acyls [FA] with formula: C2H4O2"],
        "LMFA03040004 (Lipoxin C4)": ["C30H47N3O10S", "Fatty Acyls [FA] with formula: C30H47N3O10S"],
        "LMFA03020031 (14,15-LTC4); LMFA03020003 (LTC4); LMFA03020020 (11-trans-LTC4)": ["C30H47N3O9S", "Fatty Acyls [FA] with formula: C30H47N3O9S"],
        "LMFA01030097 (Lumepueic acid)": ["C30H58O2", "Fatty Acyls [FA] with formula: C30H58O2"],
        "LMFA01170042 (Triacontanedioic acid)": ["C30H58O4", "Fatty Acyls [FA] with formula: C30H58O4"],
        "LMFA11000010": ["C30H60", "Fatty Acyls [FA] with formula: C30H60"],
        "LMFA01020234; LMFA01010030 (Melissic acid); LMFA07010002; LMFA01020314 (Mycocerosic acid (C30))": ["C30H60O2", "Fatty Acyls [FA] with formula: C30H60O2"],
        "LMFA01050221": ["C30H60O3", "Fatty Acyls [FA] with formula: C30H60O3"],
        "LMFA05000006 (Melissyl alcohol)": ["C30H62O", "Fatty Acyls [FA] with formula: C30H62O"],
        "LMFA05000068": ["C30H62O2", "Fatty Acyls [FA] with formula: C30H62O2"],
        "LMFA07050023": ["C31H52N7O17P3S", "Fatty Acyls [FA] with formula: C31H52N7O17P3S"],
        "LMFA07050022": ["C31H54N7O17P3S", "Fatty Acyls [FA] with formula: C31H54N7O17P3S"],
        "LMFA07050014": ["C31H54N7O18P3S", "Fatty Acyls [FA] with formula: C31H54N7O18P3S"],
        "LMFA11000008": ["C31H58", "Fatty Acyls [FA] with formula: C31H58"],
        "LMFA12000006 (hentriacontane-14,16-dione)": ["C31H60O2", "Fatty Acyls [FA] with formula: C31H60O2"],
        "LMFA12000005 (hentriacontan-16-one)": ["C31H62O", "Fatty Acyls [FA] with formula: C31H62O"],
        "LMFA01020028; LMFA01020027 (D-Mycoceranic acid); LMFA01010031; LMFA01020315 (Mycocerosic acid (C31)); LMFA01020296 (Phthioceranic acid (C31))": ["C31H62O2", "Fatty Acyls [FA] with formula: C31H62O2"],
        "LMFA01020320 (Hydroxyphthioceranic acid (C31))": ["C31H62O3", "Fatty Acyls [FA] with formula: C31H62O3"],
        "LMFA11000009": ["C31H64", "Fatty Acyls [FA] with formula: C31H64"],
        "LMFA05000096 (hentriacontan-1-ol); LMFA05000091 (hentriacontan-16-ol)": ["C31H64O", "Fatty Acyls [FA] with formula: C31H64O"],
        "LMFA07050034 (Dimethylnonanoyl-CoA)": ["C32H56N7O17P3S", "Fatty Acyls [FA] with formula: C32H56N7O17P3S"],
        "LMFA13020001": ["C32H58O13", "Fatty Acyls [FA] with formula: C32H58O13"],
        "LMFA01030098": ["C32H62O2", "Fatty Acyls [FA] with formula: C32H62O2"],
        "LMFA13010020": ["C32H62O8", "Fatty Acyls [FA] with formula: C32H62O8"],
        "LMFA01020316 (Mycocerosic acid (C32)); LMFA01010032 (Lacceroic acid); LMFA07010001 (Cetyl palmitate)": ["C32H64O2", "Fatty Acyls [FA] with formula: C32H64O2"],
        "LMFA13010025; LMFA13010010": ["C32H64O8", "Fatty Acyls [FA] with formula: C32H64O8"],
        "LMFA05000458 (Dotriacontanol)": ["C32H66O", "Fatty Acyls [FA] with formula: C32H66O"],
        "LMFA07050009; LMFA07050010": ["C33H56N7O17P3S", "Fatty Acyls [FA] with formula: C33H56N7O17P3S"],
        "LMFA07050013": ["C33H56N7O18P3S", "Fatty Acyls [FA] with formula: C33H56N7O18P3S"],
        "LMFA07050005": ["C33H58N7O17P3S", "Fatty Acyls [FA] with formula: C33H58N7O17P3S"],
        "LMFA07050012": ["C33H58N7O18P3S", "Fatty Acyls [FA] with formula: C33H58N7O18P3S"],
        "LMFA12000007 (tritriacontane-16,18-dione)": ["C33H64O2", "Fatty Acyls [FA] with formula: C33H64O2"],
        "LMFA01010033 (Psyllic acid); LMFA07010003 (Heptadecyl-palmitate); LMFA01020317 (Mycocerosic acid (C33)); LMFA01020297 (Phthioceranic acid (C33))": ["C33H66O2", "Fatty Acyls [FA] with formula: C33H66O2"],
        "LMFA01020321 (Hydroxyphthioceranic acid (C33))": ["C33H66O3", "Fatty Acyls [FA] with formula: C33H66O3"],
        "LMFA11000011": ["C33H68", "Fatty Acyls [FA] with formula: C33H68"],
        "LMFA07010015 (Mayolene-16)": ["C34H60O4", "Fatty Acyls [FA] with formula: C34H60O4"],
        "LMFA13020004 (13-sophorosyloxydocosanoic acid)": ["C34H64O13", "Fatty Acyls [FA] with formula: C34H64O13"],
        "LMFA07010004": ["C34H66O2", "Fatty Acyls [FA] with formula: C34H66O2"],
        "LMFA13010019; LMFA13010021": ["C34H66O8", "Fatty Acyls [FA] with formula: C34H66O8"],
        "LMFA13010027; LMFA13010028; LMFA13010023": ["C34H66O9", "Fatty Acyls [FA] with formula: C34H66O9"],
        "LMFA01020318 (Mycocerosic acid (C34)); LMFA01010034 (Gheddic acid); LMFA01020298 (Phthioceranic acid (C34))": ["C34H68O2", "Fatty Acyls [FA] with formula: C34H68O2"],
        "LMFA01020322 (Hydroxyphthioceranic acid (C34))": ["C34H68O3", "Fatty Acyls [FA] with formula: C34H68O3"],
        "LMFA13010012; LMFA13010026; LMFA13010009; LMFA13010011": ["C34H68O8", "Fatty Acyls [FA] with formula: C34H68O8"],
        "LMFA13010014; LMFA13010016": ["C34H68O9", "Fatty Acyls [FA] with formula: C34H68O9"],
        "LMFA05000459 (Geddyl alcohol)": ["C34H70O", "Fatty Acyls [FA] with formula: C34H70O"],
        "LMFA07050026; LMFA07050025; LMFA07050021": ["C35H60N7O17P3S", "Fatty Acyls [FA] with formula: C35H60N7O17P3S"],
        "LMFA07050008": ["C35H62N7O17P3S", "Fatty Acyls [FA] with formula: C35H62N7O17P3S"],
        "LMFA07050033 (3-hydroxymyristoyl-CoA)": ["C35H62N7O18P3S", "Fatty Acyls [FA] with formula: C35H62N7O18P3S"],
        "LMFA13020002 (methyl 13-sophorosyloxydocosanoate)": ["C35H66O13", "Fatty Acyls [FA] with formula: C35H66O13"],
        "LMFA07010005": ["C35H68O2", "Fatty Acyls [FA] with formula: C35H68O2"],
        "LMFA01020319 (Mycocerosic acid (C35)); LMFA01010035 (Ceroplastic acid); LMFA07010006": ["C35H70O2", "Fatty Acyls [FA] with formula: C35H70O2"],
        "LMFA13010033 (Ustilagic acid)": ["C36H64O18", "Fatty Acyls [FA] with formula: C36H64O18"],
        "LMFA07010014 (Mayolene-18)": ["C36H64O4", "Fatty Acyls [FA] with formula: C36H64O4"],
        "LMFA13010022; LMFA13010024; LMFA13010029": ["C36H70O9", "Fatty Acyls [FA] with formula: C36H70O9"],
        "LMFA01010036 (Hexatriacontylic acid); LMFA01020299 (Phthioceranic acid (C36))": ["C36H72O2", "Fatty Acyls [FA] with formula: C36H72O2"],
        "LMFA01020323 (Hydroxyphthioceranic acid (C36))": ["C36H72O3", "Fatty Acyls [FA] with formula: C36H72O3"],
        "LMFA13010013; LMFA13010015": ["C36H72O9", "Fatty Acyls [FA] with formula: C36H72O9"],
        "LMFA07050059 (CoA(16:1(9Z))); LMFA07050020": ["C37H64N7O17P3S", "Fatty Acyls [FA] with formula: C37H64N7O17P3S"],
        "LMFA07050016": ["C37H64N7O18P3S", "Fatty Acyls [FA] with formula: C37H64N7O18P3S"],
        "LMFA07050002 (Palmitoyl CoA / CoA(16:0))": ["C37H66N7O17P3S", "Fatty Acyls [FA] with formula: C37H66N7O17P3S"],
        "LMFA07050015; LMFA07050032 (3-hydroxypalmitoyl-CoA)": ["C37H66N7O18P3S", "Fatty Acyls [FA] with formula: C37H66N7O18P3S"],
        "LMFA00000005": ["C37H71NO6", "Fatty Acyls [FA] with formula: C37H71NO6"],
        "LMFA01020300 (Phthioceranic acid (C37)); LMFA01010037": ["C37H74O2", "Fatty Acyls [FA] with formula: C37H74O2"],
        "LMFA01020324 (Hydroxyphthioceranic acid (C37))": ["C37H74O3", "Fatty Acyls [FA] with formula: C37H74O3"],
        "LMFA13020003 (13-sophorosyloxydocosanoate 6',6''-diacetate)": ["C38H68O15", "Fatty Acyls [FA] with formula: C38H68O15"],
        "LMFA00000003": ["C38H74N2O5", "Fatty Acyls [FA] with formula: C38H74N2O5"],
        "LMFA13010030; LMFA13010031": ["C38H74O9", "Fatty Acyls [FA] with formula: C38H74O9"],
        "LMFA01020273; LMFA01010038; LMFA07010010 (Docosyl-palmitate)": ["C38H76O2", "Fatty Acyls [FA] with formula: C38H76O2"],
        "LMFA13010017; LMFA13010018": ["C38H76O9", "Fatty Acyls [FA] with formula: C38H76O9"],
        "LMFA07060003 (C14-ACP)": ["C391H632N95O142PS2", "Fatty Acyls [FA] with formula: C391H632N95O142PS2"],
        "LMFA07060002 (C12-ACP)": ["C393H636N95O142PS2", "Fatty Acyls [FA] with formula: C393H636N95O142PS2"],
        "LMFA07060001 (3-OH-C14-ACP)": ["C393H636N95O143PS2", "Fatty Acyls [FA] with formula: C393H636N95O143PS2"],
        "LMFA07050046 (CoA(18:4(6Z,9Z,12Z,15Z)))": ["C39H62N7O17P3S", "Fatty Acyls [FA] with formula: C39H62N7O17P3S"],
        "LMFA07050045 (CoA(18:3(9Z,12Z,15Z))); LMFA07050038 (CoA(18:3(6Z,9Z,12Z)))": ["C39H64N7O17P3S", "Fatty Acyls [FA] with formula: C39H64N7O17P3S"],
        "LMFA07050027; LMFA07050060 (CoA(18:2(6Z,9Z))); LMFA07050035 (CoA(18:2(9Z,12Z)))": ["C39H66N7O17P3S", "Fatty Acyls [FA] with formula: C39H66N7O17P3S"],
        "LMFA07050055 (CoA(18:1(9Z))); LMFA07050003 (cis-vaccenoyl CoA)": ["C39H68N7O17P3S", "Fatty Acyls [FA] with formula: C39H68N7O17P3S"],
        "LMFA07050004 (CoA(18:0))": ["C39H70N7O17P3S", "Fatty Acyls [FA] with formula: C39H70N7O17P3S"],
        "LMFA00000006 (Lysine-containing siolipin)": ["C39H76N2O7", "Fatty Acyls [FA] with formula: C39H76N2O7"],
        "LMFA01020301 (Phthioceranic acid (C39)); LMFA07010007": ["C39H78O2", "Fatty Acyls [FA] with formula: C39H78O2"],
        "LMFA01020325 (Hydroxyphthioceranic acid (C39))": ["C39H78O3", "Fatty Acyls [FA] with formula: C39H78O3"],
        "LMFA01030193 (Acrylic acid)": ["C3H4O2", "Fatty Acyls [FA] with formula: C3H4O2"],
        "LMFA01060077 (Pyruvic acid)": ["C3H4O3", "Fatty Acyls [FA] with formula: C3H4O3"],
        "LMFA01170041 (Malonic acid)": ["C3H4O4", "Fatty Acyls [FA] with formula: C3H4O4"],
        "LMFA01010003 (Propionic acid)": ["C3H6O2", "Fatty Acyls [FA] with formula: C3H6O2"],
        "LMFA01100045": ["C3H7NO3", "Fatty Acyls [FA] with formula: C3H7NO3"],
        "LMFA01100051 (2,3-diamino-propionic acid)": ["C3H8N2O2", "Fatty Acyls [FA] with formula: C3H8N2O2"],
        "LMFA05000101": ["C3H8O", "Fatty Acyls [FA] with formula: C3H8O"],
        "LMFA00000001": ["C40H66O5", "Fatty Acyls [FA] with formula: C40H66O5"],
        "LMFA13010003": ["C40H78O8", "Fatty Acyls [FA] with formula: C40H78O8"],
        "LMFA01020302 (Phthioceranic acid (C40)); LMFA07010011 (Tetracosyl-palmitate)": ["C40H80O2", "Fatty Acyls [FA] with formula: C40H80O2"],
        "LMFA01020326 (Hydroxyphthioceranic acid (C40))": ["C40H80O3", "Fatty Acyls [FA] with formula: C40H80O3"],
        "LMFA05000084 (3,7,11,15,18,22,26,30-octamethyldotriacontane-1,32-diol)": ["C40H82O2", "Fatty Acyls [FA] with formula: C40H82O2"],
        "LMFA07050063 (CoA(20:5(5Z,8Z,11Z,14Z,17Z)))": ["C41H64N7O17P3S", "Fatty Acyls [FA] with formula: C41H64N7O17P3S"],
        "LMFA07050047 (CoA(20:4(8Z,11Z,14Z,17Z))); LMFA07050007; LMFA07050039 (CoA(20:4(5Z,8Z,11Z,14Z)))": ["C41H66N7O17P3S", "Fatty Acyls [FA] with formula: C41H66N7O17P3S"],
        "LMFA07050044 (CoA(20:3(11Z,14Z,17Z))); LMFA07050062 (CoA(20:3(5Z,8Z,11Z))); LMFA07050011 (CoA(20:3(8Z,11Z,14Z)))": ["C41H68N7O17P3S", "Fatty Acyls [FA] with formula: C41H68N7O17P3S"],
        "LMFA07050061 (CoA(20:2(8Z,11Z))); LMFA07050036 (CoA(20:2(11Z,14Z)))": ["C41H70N7O17P3S", "Fatty Acyls [FA] with formula: C41H70N7O17P3S"],
        "LMFA07030001": ["C41H71NO4", "Fatty Acyls [FA] with formula: C41H71NO4"],
        "LMFA07050056 (CoA(20:1(11Z)))": ["C41H72N7O17P3S", "Fatty Acyls [FA] with formula: C41H72N7O17P3S"],
        "LMFA07050006 (CoA(20:0))": ["C41H74N7O17P3S", "Fatty Acyls [FA] with formula: C41H74N7O17P3S"],
        "LMFA01020271; LMFA07010008": ["C41H82O2", "Fatty Acyls [FA] with formula: C41H82O2"],
        "LMFA07020001": ["C42H82O4", "Fatty Acyls [FA] with formula: C42H82O4"],
        "LMFA13010004": ["C42H82O8", "Fatty Acyls [FA] with formula: C42H82O8"],
        "LMFA07010012 (Hexacosyl-palmitate); LMFA01020303 (Phthioceranic acid (C42)); LMFA07010009": ["C42H84O2", "Fatty Acyls [FA] with formula: C42H84O2"],
        "LMFA01020327 (Hydroxyphthioceranic acid (C42))": ["C42H84O3", "Fatty Acyls [FA] with formula: C42H84O3"],
        "LMFA07050050 (CoA(22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C43H66N7O17P3S", "Fatty Acyls [FA] with formula: C43H66N7O17P3S"],
        "LMFA07050043 (CoA(22:5(4Z,7Z,10Z,13Z,16Z))); LMFA07050048 (CoA(22:5(7Z,10Z,13Z,16Z,19Z)))": ["C43H68N7O17P3S", "Fatty Acyls [FA] with formula: C43H68N7O17P3S"],
        "LMFA07050040 (CoA(22:4(7Z,10Z,13Z,16Z)))": ["C43H70N7O17P3S", "Fatty Acyls [FA] with formula: C43H70N7O17P3S"],
        "LMFA07050037 (CoA(22:2(13Z,16Z)))": ["C43H74N7O17P3S", "Fatty Acyls [FA] with formula: C43H74N7O17P3S"],
        "LMFA07050057 (CoA(22:1(13Z)))": ["C43H76N7O17P3S", "Fatty Acyls [FA] with formula: C43H76N7O17P3S"],
        "LMFA07050052 (CoA(22:0))": ["C43H78N7O17P3S", "Fatty Acyls [FA] with formula: C43H78N7O17P3S"],
        "LMFA01020304 (Phthioceranic acid (C43))": ["C43H86O2", "Fatty Acyls [FA] with formula: C43H86O2"],
        "LMFA01020328 (Hydroxyphthioceranic acid (C43))": ["C43H86O3", "Fatty Acyls [FA] with formula: C43H86O3"],
        "LMFA01160001 (alpha,alpha'-Trehalose 6-mycolate)": ["C44H82O13", "Fatty Acyls [FA] with formula: C44H82O13"],
        "LMFA07010013 (Octacosyl-palmitate)": ["C44H88O2", "Fatty Acyls [FA] with formula: C44H88O2"],
        "LMFA07050051 (CoA(24:6(6Z,9Z,12Z,15Z,18Z,21Z)))": ["C45H70N7O17P3S", "Fatty Acyls [FA] with formula: C45H70N7O17P3S"],
        "LMFA07050049 (CoA(24:5(9Z,12Z,15Z,18Z,21Z))); LMFA07050042 (CoA(24:5(6Z,9Z,12Z,15Z,18Z)))": ["C45H72N7O17P3S", "Fatty Acyls [FA] with formula: C45H72N7O17P3S"],
        "LMFA07050041 (CoA(24:4(9Z,12Z,15Z,18Z)))": ["C45H74N7O17P3S", "Fatty Acyls [FA] with formula: C45H74N7O17P3S"],
        "LMFA07050058 (CoA(24:1(15Z)))": ["C45H80N7O17P3S", "Fatty Acyls [FA] with formula: C45H80N7O17P3S"],
        "LMFA07050053 (CoA(24:0))": ["C45H82N7O17P3S", "Fatty Acyls [FA] with formula: C45H82N7O17P3S"],
        "LMFA01020305 (Phthioceranic acid (C45))": ["C45H90O2", "Fatty Acyls [FA] with formula: C45H90O2"],
        "LMFA01020329 (Hydroxyphthioceranic acid (C45))": ["C45H90O3", "Fatty Acyls [FA] with formula: C45H90O3"],
        "LMFA01020306 (Phthioceranic acid (C46)); LMFA01010039": ["C46H92O2", "Fatty Acyls [FA] with formula: C46H92O2"],
        "LMFA01020330 (Hydroxyphthioceranic acid (C46))": ["C46H92O3", "Fatty Acyls [FA] with formula: C46H92O3"],
        "LMFA00000015 (Dideoxymycobactin)": ["C47H75N5O8", "Fatty Acyls [FA] with formula: C47H75N5O8"],
        "LMFA07050054 (CoA(26:0))": ["C47H86N7O17P3S", "Fatty Acyls [FA] with formula: C47H86N7O17P3S"],
        "LMFA01020307 (Phthioceranic acid (C48))": ["C48H96O2", "Fatty Acyls [FA] with formula: C48H96O2"],
        "LMFA01020331 (Hydroxyphthioceranic acid (C48))": ["C48H96O3", "Fatty Acyls [FA] with formula: C48H96O3"],
        "LMFA01100052 (2,4-diamino-butyric acid)": ["C4H10N2O2", "Fatty Acyls [FA] with formula: C4H10N2O2"],
        "LMFA05000100; LMFA05000109": ["C4H10O", "Fatty Acyls [FA] with formula: C4H10O"],
        "LMFA01170061; LMFA01170120 (Oxalacetic acid)": ["C4H4O5", "Fatty Acyls [FA] with formula: C4H4O5"],
        "LMFA01060194 (dihydroxy-fumaric acid)": ["C4H4O6", "Fatty Acyls [FA] with formula: C4H4O6"],
        "LMFA01090029": ["C4H5BrO2", "Fatty Acyls [FA] with formula: C4H5BrO2"],
        "LMFA01170110 (Iminoaspartic acid)": ["C4H5NO4", "Fatty Acyls [FA] with formula: C4H5NO4"],
        "LMFA01030004 (Vinyl acetic acid); LMFA01030194 (Isocrotonic acid); LMFA01030195 (Crotonic acid)": ["C4H6O2", "Fatty Acyls [FA] with formula: C4H6O2"],
        "LMFA01060002 (3-methyl pyruvic acid); LMFA01060003 (Acetoacetic acid); LMFA06000118 (Succinic acid semialdehyde); LMFA01060193 (2-methyl-3-oxo-propanoic acid); LMFA01060190 ((S)-Methylmalonic acid semialdehyde); LMFA01050398 (4-hydroxy-crotonic acid)": ["C4H6O3", "Fatty Acyls [FA] with formula: C4H6O3"],
        "LMFA01170118 (Methylmalonic acid); LMFA01170043 (Succinic acid)": ["C4H6O4", "Fatty Acyls [FA] with formula: C4H6O4"],
        "LMFA01090028": ["C4H7BrO2", "Fatty Acyls [FA] with formula: C4H7BrO2"],
        "LMFA01060172": ["C4H7NO3", "Fatty Acyls [FA] with formula: C4H7NO3"],
        "LMFA01020071 (Isobutyric acid); LMFA01010004 (Butyric acid)": ["C4H8O2", "Fatty Acyls [FA] with formula: C4H8O2"],
        "LMFA01130006 (3-methyl-thiopropionic acid)": ["C4H8O2S", "Fatty Acyls [FA] with formula: C4H8O2S"],
        "LMFA01050382 (3R-hydroxy-isobutyric acid); LMFA01010042 (alpha-hydroxy-isobutyric acid); LMFA01050006 (4-hydroxy-butyric acid); LMFA01050004 ((+/-)alpha-hydoxy butyric acid); LMFA01050005 (D(-)-beta-hydroxy butyric acid); LMFA01050342; LMFA01050243": ["C4H8O3", "Fatty Acyls [FA] with formula: C4H8O3"],
        "LMFA01050385 (2,4-dihydroxy-butanoic acid); LMFA01050378 (3S,4-dihydroxy-butyric acid); LMFA01050397 (4-deoxy-erythronic acid); LMFA01050400 (a,b-dihydroxy-isobutyric acid)": ["C4H8O4", "Fatty Acyls [FA] with formula: C4H8O4"],
        "LMFA01100054 (3-amino-isobutanoic acid); LMFA01100053 (2-amino-isobutyric acid); LMFA01100050 ((S)-b-amino-isobutyric acid); LMFA01100049 ((R)-b-amino-isobutyric acid); LMFA01100043; LMFA01100034; LMFA01100039": ["C4H9NO2", "Fatty Acyls [FA] with formula: C4H9NO2"],
        "LMFA13010008": ["C54H104O9", "Fatty Acyls [FA] with formula: C54H104O9"],
        "LMFA13010007": ["C58H112O9", "Fatty Acyls [FA] with formula: C58H112O9"],
        "LMFA12000003 (pentan-2-one); LMFA12000001 (pentan-3-one); LMFA05000106; LMFA05000107; LMFA05000105; LMFA06000251; LMFA05000110; LMFA05000103": ["C5H10O", "Fatty Acyls [FA] with formula: C5H10O"],
        "LMFA01020072 (alpha-methyl butyric Acid); LMFA01020073 (Pivalic acid); LMFA01020181 (Isovaleric acid); LMFA01010005 (Valeric acid)": ["C5H10O2", "Fatty Acyls [FA] with formula: C5H10O2"],
        "LMFA01050389 (2-hydroxy-2-methyl-butyric acid); LMFA01050388 (2-ethyl-hydracrylic acid); LMFA01050007 (DL-2-hydroxy valeric acid); LMFA01050008 (3-hydroxy valeric acid); LMFA01050009 (4-hydroxy-valeric acid); LMFA01050010 (5-hydroxy valeric acid); LMFA01050399 (4-hydroxy-isovaleric acid); LMFA01050393 (3-hydroxy-2-methyl-[R-(R,S)]-butanoic acid); LMFA01050390 (2-hydroxy-3-methyl-butyric acid); LMFA01050391 (2-methyl-3-hydroxybutyric acid); LMFA01050396 (3-hydroxy-isovaleric acid); LMFA01050394 (3-Hydroxy-2-methyl-[S-(R,R)]-butanoic acid)": ["C5H10O3", "Fatty Acyls [FA] with formula: C5H10O3"],
        "LMFA01050384 (2,3-dihydroxy-valeric acid)": ["C5H10O4", "Fatty Acyls [FA] with formula: C5H10O4"],
        "LMFA01050386 (2-deoxy-ribonic acid)": ["C5H10O5", "Fatty Acyls [FA] with formula: C5H10O5"],
        "LMFA08010002": ["C5H11NO", "Fatty Acyls [FA] with formula: C5H11NO"],
        "LMFA01100046; LMFA01100040; LMFA01100041; LMFA01100022; LMFA01100023; LMFA01100021": ["C5H11NO2", "Fatty Acyls [FA] with formula: C5H11NO2"],
        "LMFA05000102; LMFA05000108; LMFA05000104; LMFA05000112": ["C5H12O", "Fatty Acyls [FA] with formula: C5H12O"],
        "LMFA01030099 (beta-vinyl acrylic acid)": ["C5H6O2", "Fatty Acyls [FA] with formula: C5H6O2"],
        "LMFA01060166": ["C5H6O3", "Fatty Acyls [FA] with formula: C5H6O3"],
        "LMFA01170063 (itaconic acid); LMFA01170109 (Glutaconic acid); LMFA01170116 (Mesaconic acid); LMFA01170099 (Citraconic acid)": ["C5H6O4", "Fatty Acyls [FA] with formula: C5H6O4"],
        "LMFA01100038; LMFA01100037": ["C5H8N2O2", "Fatty Acyls [FA] with formula: C5H8N2O2"],
        "LMFA01020097 (beta,beta-dimethyl acrylic acid); LMFA01030005 (beta-ethyl acrylic acid); LMFA01030006 (beta-penteic acid); LMFA01030007 (Allyl acetic acid); LMFA01020030 (Tiglic acid); LMFA01020029 (Angelic acid); LMFA01020111 (2-ethyl acrylic acid); LMFA01020110 (Isopropenylacetic acid)": ["C5H8O2", "Fatty Acyls [FA] with formula: C5H8O2"],
        "LMFA01020274; LMFA01060005 (3-keto valeric acid); LMFA01060004 (2-keto valeric acid); LMFA01060006 (Levulinic acid); LMFA01060161; LMFA01060192 (2methyl-3-ketovaleric acid)": ["C5H8O3", "Fatty Acyls [FA] with formula: C5H8O3"],
        "LMFA01060170": ["C5H8O3S", "Fatty Acyls [FA] with formula: C5H8O3S"],
        "LMFA01020277; LMFA01170105 (Ethylmalonic acid); LMFA01170103 (dimethyl-malonic acid); LMFA01170119 (Methylsuccinic acid)": ["C5H8O4", "Fatty Acyls [FA] with formula: C5H8O4"],
        "LMFA01100055 (5-amino-levulinic acid); LMFA01060169; LMFA01060171": ["C5H9NO3", "Fatty Acyls [FA] with formula: C5H9NO3"],
        "LMFA06000005; LMFA06000003; LMFA06000110; LMFA06000004; LMFA06000002 (3-propyl acrolein)": ["C6H10O", "Fatty Acyls [FA] with formula: C6H10O"],
        "LMFA01020098; LMFA01020099; LMFA01030008 (Isohydrosorbic acid); LMFA01030009 (Hydrosorbic acid); LMFA01030011 (delta-hexenoic acid); LMFA01030010 (gamma-hexenoic acid); LMFA01020031 (Pyroterebic acid); LMFA01030779 (cis-hex-3-enoic acid); LMFA06000008 (Adipaldehyde); LMFA01020113; LMFA01020112 (3-isopropyl acrylic acid); LMFA01020116 (trimethyl acrylic acid); LMFA01020115; LMFA01020114; LMFA06000016 (4-hydroxyhexenal); LMFA01030791": ["C6H10O2", "Fatty Acyls [FA] with formula: C6H10O2"],
        "LMFA01020276; LMFA01020275; LMFA01060010 (5-keto-n-caproic acid); LMFA01060007 (2-keto-n-caproic acid); LMFA01060009 (4-keto-n-caproic acid); LMFA01060008 (3-keto-n-caproic acid); LMFA01020280": ["C6H10O3", "Fatty Acyls [FA] with formula: C6H10O3"],
        "LMFA01170084 (2-methyl-glutaric acid); LMFA01170080 (2,2-dimethyl-succinic acid); LMFA01020278; LMFA01170117 (Methylglutaric acid); LMFA01170048 (Adipic acid); LMFA01050343": ["C6H10O4", "Fatty Acyls [FA] with formula: C6H10O4"],
        "LMFA01170088 (3-hydroxy-adipic acid); LMFA01170050 (2S-hydroxyadipic acid); LMFA01170049 (2-Hydroxyadipic acid); LMFA01170091 (3-hydroxymethyl-glutaric acid)": ["C6H10O5", "Fatty Acyls [FA] with formula: C6H10O5"],
        "LMFA01170108 (Glucaric acid); LMFA01170107 (Galactaric acid)": ["C6H10O8", "Fatty Acyls [FA] with formula: C6H10O8"],
        "LMFA01060173": ["C6H11NO3", "Fatty Acyls [FA] with formula: C6H11NO3"],
        "LMFA01170098 (Aminoadipic acid)": ["C6H11NO4", "Fatty Acyls [FA] with formula: C6H11NO4"],
        "LMFA05000059; LMFA05000113; LMFA05000115; LMFA05000116; LMFA06000109 (Caproaldehyde); LMFA05000060": ["C6H12O", "Fatty Acyls [FA] with formula: C6H12O"],
        "LMFA06000014 (5-hydroxy caproaldehyde); LMFA01020074 (2-methyl valeric acid); LMFA01020075 (3-methyl valeric acid); LMFA01020076 (Isocaproic acid); LMFA01020077 (diethyl acetic acid); LMFA01020078 (dimethyl ethyl acetic acid); LMFA01020079; LMFA01010006 (Caproic acid); LMFA06000125; LMFA06000015 (6-hydroxy caproaldehyde); LMFA06000013 (4-hydroxy caproaldehyde); LMFA06000012 (2-hydroxy caproaldehyde)": ["C6H12O2", "Fatty Acyls [FA] with formula: C6H12O2"],
        "LMFA01050387 (2-ethyl-2-hydroxy-butyric acid); LMFA01050381 (Leucinic acid); LMFA01050380 (2-hydroxy-3-methyl-pentanoic acid); LMFA01050011 (DL-2-hydroxy caproic acid); LMFA01050013 (DL-4-hydroxy caproic acid); LMFA01050012 (DL-3-hydroxy caproic acid); LMFA01050015 (6-hydroxy caproic acid); LMFA01050014 (5-hydroxy caproic acid); LMFA01050376 (5R-hydroxy-hexanoic acid); LMFA01050377 (3R-hydroxy-hexanoic acid); LMFA01050402 (D-Leucic acid); LMFA01050408 (hydroxy-isocaproic acid)": ["C6H12O3", "Fatty Acyls [FA] with formula: C6H12O3"],
        "LMFA01050352 (Mevalonic acid)": ["C6H12O4", "Fatty Acyls [FA] with formula: C6H12O4"],
        "LMFA01050098 (Digitoxic acid)": ["C6H12O5", "Fatty Acyls [FA] with formula: C6H12O5"],
        "LMFA01100048; LMFA01100047; LMFA01100042; LMFA01100035": ["C6H13NO2", "Fatty Acyls [FA] with formula: C6H13NO2"],
        "LMFA01050415 (Mevalonate-P)": ["C6H13O7P", "Fatty Acyls [FA] with formula: C6H13O7P"],
        "LMFA11000007 (hexane)": ["C6H14", "Fatty Acyls [FA] with formula: C6H14"],
        "LMFA05000117; LMFA05000111": ["C6H14O", "Fatty Acyls [FA] with formula: C6H14O"],
        "LMFA01050416 (Mevalonate-PP)": ["C6H14O10P2", "Fatty Acyls [FA] with formula: C6H14O10P2"],
        "LMFA06000011 (Muconic dialdehyde)": ["C6H6O2", "Fatty Acyls [FA] with formula: C6H6O2"],
        "LMFA01170124 (trans-trans-muconic acid); LMFA01170077 (cis,cis-muconic acid)": ["C6H6O4", "Fatty Acyls [FA] with formula: C6H6O4"],
        "LMFA01170067 (fumarylacetic acid); LMFA01170047; LMFA01170071 (3-hydroxy-cis,cis-muconic acid)": ["C6H6O5", "Fatty Acyls [FA] with formula: C6H6O5"],
        "LMFA01060191 (2-aminomuconic acid semialdehyde)": ["C6H7NO3", "Fatty Acyls [FA] with formula: C6H7NO3"],
        "LMFA01170082 (2-amino-muconic acid)": ["C6H7NO4", "Fatty Acyls [FA] with formula: C6H7NO4"],
        "LMFA06000006 (Sorbaldehyde); LMFA06000007": ["C6H8O", "Fatty Acyls [FA] with formula: C6H8O"],
        "LMFA01030100 (Sorbic acid); LMFA01030451; LMFA01030499; LMFA01030498; LMFA01140022 (Aleprolic acid); LMFA06000122; LMFA06000120; LMFA06000009; LMFA01030500; LMFA06000017; LMFA06000010": ["C6H8O2", "Fatty Acyls [FA] with formula: C6H8O2"],
        "LMFA01050273; LMFA01060174": ["C6H8O3", "Fatty Acyls [FA] with formula: C6H8O3"],
        "LMFA01170068 (3E-methylglutaconic acid); LMFA01170087 (3-hexenedioic acid); LMFA01170070 ((E)-hex-2-enedioic acid); LMFA01170079 (2E-methyl-glutaconic acid)": ["C6H8O4", "Fatty Acyls [FA] with formula: C6H8O4"],
        "LMFA01170121 (Oxoadipic acid); LMFA01170096 (3-oxo-adipic acid)": ["C6H8O5", "Fatty Acyls [FA] with formula: C6H8O5"],
        "LMFA01060195 (diketo-gulonic acid)": ["C6H8O7", "Fatty Acyls [FA] with formula: C6H8O7"],
        "LMFA01100036 (2-amino-3-oxo-hexanedioic acid)": ["C6H9NO5", "Fatty Acyls [FA] with formula: C6H9NO5"],
        "LMFA01160002 (alpha,alpha'-Trehalose 6,6'-bismycolate)": ["C76H142O15", "Fatty Acyls [FA] with formula: C76H142O15"],
        "LMFA01160003 (alpha-Semegma mycolic acid)": ["C77H150O3", "Fatty Acyls [FA] with formula: C77H150O3"],
        "LMFA06000024; LMFA06000025; LMFA06000126": ["C7H10O", "Fatty Acyls [FA] with formula: C7H10O"],
        "LMFA06000027; LMFA01030488; LMFA01030489; LMFA01030490; LMFA01030792": ["C7H10O2", "Fatty Acyls [FA] with formula: C7H10O2"],
        "LMFA01050262": ["C7H10O3", "Fatty Acyls [FA] with formula: C7H10O3"],
        "LMFA01170069 (3-oxopimelic acid); LMFA01050242": ["C7H10O5", "Fatty Acyls [FA] with formula: C7H10O5"],
        "LMFA01170062; LMFA01170052": ["C7H10O6", "Fatty Acyls [FA] with formula: C7H10O6"],
        "LMFA01090001": ["C7H11BrO2", "Fatty Acyls [FA] with formula: C7H11BrO2"],
        "LMFA01090024": ["C7H11ClO2", "Fatty Acyls [FA] with formula: C7H11ClO2"],
        "LMFA06000022; LMFA06000020; LMFA06000021; LMFA06000023; LMFA05000119; LMFA06000019": ["C7H12O", "Fatty Acyls [FA] with formula: C7H12O"],
        "LMFA06000026 (Pimelic dialdehyde); LMFA01030013 (beta-heptenoic acid); LMFA01030012 (alpha-heptenoic acid); LMFA01030016 (epsilon-heptenoic acid); LMFA01030015 (delta-heptenoic acid); LMFA01030014 (gamma-heptenoic acid); LMFA01020100; LMFA01020101; LMFA01020119; LMFA01020118 (2-butyl acrylic acid); LMFA01020117; LMFA01020122 (2-isopropyl trans-crotonic acid); LMFA01020123; LMFA01020120; LMFA01020121; LMFA01030452; LMFA01030794; LMFA01030793": ["C7H12O2", "Fatty Acyls [FA] with formula: C7H12O2"],
        "LMFA01050383; LMFA01060012 (n-valeryl acetic acid); LMFA01060013 (3-butyrl propionic acid); LMFA01060011 (2-Keto-n-heptylic acid); LMFA01060014 (4-propionyl butyric acid); LMFA01060015 (5-aceto valeric acid)": ["C7H12O3", "Fatty Acyls [FA] with formula: C7H12O3"],
        "LMFA01170086 (3,3-dimethyl-glutaric acid); LMFA01170051 (Pimelic acid); LMFA01170095 (3-methyl-adipic acid)": ["C7H12O4", "Fatty Acyls [FA] with formula: C7H12O4"],
        "LMFA01170064 (3-propylmalic acid); LMFA01170083 (2-isopropyl-malic acid); LMFA01170081 (2,3-dimethyl-3-hydroxy-glutaric acid)": ["C7H12O5", "Fatty Acyls [FA] with formula: C7H12O5"],
        "LMFA01170102 (diamino-pimelic acid)": ["C7H14N2O4", "Fatty Acyls [FA] with formula: C7H14N2O4"],
        "LMFA12000004; LMFA06000001 (Enanthaldehyde)": ["C7H14O", "Fatty Acyls [FA] with formula: C7H14O"],
        "LMFA01020081; LMFA01020080; LMFA01020083; LMFA01020082; LMFA01020085 (alpha,alpha-dimethyl valeric acid); LMFA01020084 (alpha-ethyl valeric acid); LMFA01020086 (beta,beta-dimethyl valeric acid); LMFA01020144 (4,4-dimethyl valeric acid); LMFA01020145 (3,4-dimethyl valeric acid); LMFA01020146; LMFA01010007 (Heptylic acid); LMFA05000224": ["C7H14O2", "Fatty Acyls [FA] with formula: C7H14O2"],
        "LMFA01050261; LMFA01050017 (4-hydroxy enanthoic acid); LMFA01050016 (2-hydroxy enanthoic acid); LMFA01050019 (omega-hydroxy enanthoic acid); LMFA01050018 (delta-hydroxy enanthoic acid); LMFA01050225": ["C7H14O3", "Fatty Acyls [FA] with formula: C7H14O3"],
        "LMFA01100013; LMFA01100015; LMFA01100014": ["C7H15NO2", "Fatty Acyls [FA] with formula: C7H15NO2"],
        "LMFA05000122": ["C7H16O", "Fatty Acyls [FA] with formula: C7H16O"],
        "LMFA01170065 (3-maleylpyruvic acid)": ["C7H6O6", "Fatty Acyls [FA] with formula: C7H6O6"],
        "LMFA01170072 (4-carboxy-2-hydroxy-cis,cis-muconic acid)": ["C7H6O7", "Fatty Acyls [FA] with formula: C7H6O7"],
        "LMFA01030782 (cis,trans-hepta-2,4,6-trienoic acid); LMFA01030781 (trans,trans-hepta-2,4,6-trienoic acid)": ["C7H8O2", "Fatty Acyls [FA] with formula: C7H8O2"],
        "LMFA01090030": ["C7H9BrO2", "Fatty Acyls [FA] with formula: C7H9BrO2"],
        "LMFA06000036": ["C8H10O", "Fatty Acyls [FA] with formula: C8H10O"],
        "LMFA06000035; LMFA06000034; LMFA06000132; LMFA06000133; LMFA06000131; LMFA06000121; LMFA06000128": ["C8H12O", "Fatty Acyls [FA] with formula: C8H12O"],
        "LMFA06000037; LMFA06000038; LMFA05000228; LMFA01030441; LMFA01030442; LMFA06000129; LMFA01030578; LMFA01030577; LMFA01030795; LMFA05000225": ["C8H12O2", "Fatty Acyls [FA] with formula: C8H12O2"],
        "LMFA01060165": ["C8H12O3", "Fatty Acyls [FA] with formula: C8H12O3"],
        "LMFA01170085 (2-octenedioic acid); LMFA01060156; LMFA01170078 (cis-4-octenedioic acid)": ["C8H12O4", "Fatty Acyls [FA] with formula: C8H12O4"],
        "LMFA08030002": ["C8H13NO3", "Fatty Acyls [FA] with formula: C8H13NO3"],
        "LMFA08030005": ["C8H13NO4", "Fatty Acyls [FA] with formula: C8H13NO4"],
        "LMFA06000031; LMFA06000030; LMFA06000033; LMFA06000032; LMFA05000114; LMFA06000029": ["C8H14O", "Fatty Acyls [FA] with formula: C8H14O"],
        "LMFA06000039; LMFA05000230; LMFA01030017 (cis-alpha-octenoic acid); LMFA01030019 (cis-beta-octenoic acid); LMFA01030018 (trans-alpha-octenoic acid); LMFA05000229; LMFA05000227; LMFA05000226; LMFA01030800; LMFA01030024 (cis-epsilon-octenoic acid); LMFA01030025 (trans-epsilon-octenoic acid); LMFA01030022 (cis-delta-octenoic acid); LMFA01030023 (trans-delta-octenoic acid); LMFA01030020 (trans-beta-octenoic acid); LMFA01030021 (cis-gamma-octenoic acid); LMFA01020102; LMFA01030797; LMFA01020126; LMFA01020124; LMFA01020125; LMFA01030576; LMFA01030796; LMFA01030798; LMFA01030799": ["C8H14O2", "Fatty Acyls [FA] with formula: C8H14O2"],
        "LMFA01130001 (Lipoic acid)": ["C8H14O2S2", "Fatty Acyls [FA] with formula: C8H14O2S2"],
        "LMFA01060021 (7-keto-n-caprylic acid); LMFA01060020 (6-keto-n-caprylic acid); LMFA01060018 (4-keto-n-caprylic acid); LMFA01060019 (5-Keto-n-caprylic acid); LMFA01060016 (2-keto-n-caprylic acid); LMFA01060017 (3-keto-n-caprylic acid)": ["C8H14O3", "Fatty Acyls [FA] with formula: C8H14O3"],
        "LMFA01170001 (Suberic acid); LMFA01170104 (Ethyladipic acid)": ["C8H14O4", "Fatty Acyls [FA] with formula: C8H14O4"],
        "LMFA01170093 (3-hydroxy-suberic acid)": ["C8H14O5", "Fatty Acyls [FA] with formula: C8H14O5"],
        "LMFA08010006 (lipoamide)": ["C8H15NOS2", "Fatty Acyls [FA] with formula: C8H15NOS2"],
        "LMFA06000028 (Caprylaldehyde); LMFA06000124; LMFA05000124; LMFA05000126; LMFA05000128; LMFA01050367 (oct-1-en-3S-ol); LMFA05000090 (oct-1-en-3-ol); LMFA05000093 ((R)-oct-1-en-3-ol)": ["C8H16O", "Fatty Acyls [FA] with formula: C8H16O"],
        "LMFA01020242; LMFA01020087 (alpha-ethyl caproic acid); LMFA05000232; LMFA01020147; LMFA01020148; LMFA01020149; LMFA01020151 (2-ethyl-2-methyl valeric ccid); LMFA01020150; LMFA01020291 (Valproic acid); LMFA01010008 (Caprylic acid); LMFA01020283; LMFA01020284": ["C8H16O2", "Fatty Acyls [FA] with formula: C8H16O2"],
        "LMFA01130003 ((S)-dihydrolipoic acid)": ["C8H16O2S2", "Fatty Acyls [FA] with formula: C8H16O2S2"],
        "LMFA01050020 (2-hydroxy caprylic acid); LMFA01050021 (3-hydroxy caprylic acid); LMFA01050022 (6-hydroxy caprylic acid); LMFA01050023 (8-hydroxy caprylic acid); LMFA01050316; LMFA01050317; LMFA01050314; LMFA01050315; LMFA01050229; LMFA01050313; LMFA01050226; LMFA01050227; LMFA01050395 (3-hydroxy-isoheptanoic acid)": ["C8H16O3", "Fatty Acyls [FA] with formula: C8H16O3"],
        "LMFA01050228": ["C8H16O4", "Fatty Acyls [FA] with formula: C8H16O4"],
        "LMFA01100056 (DL-2-amino-octanoic acid); LMFA01100020": ["C8H17NO2", "Fatty Acyls [FA] with formula: C8H17NO2"],
        "LMFA11000002 (octane)": ["C8H18", "Fatty Acyls [FA] with formula: C8H18"],
        "LMFA05000130": ["C8H18O", "Fatty Acyls [FA] with formula: C8H18O"],
        "LMFA05000089 (octane-1,2-diol)": ["C8H18O2", "Fatty Acyls [FA] with formula: C8H18O2"],
        "LMFA01030743; LMFA01030744": ["C8H6O2", "Fatty Acyls [FA] with formula: C8H6O2"],
        "LMFA01170066 (4-fumarylacetoacetic acid); LMFA01170114 (Maleylacetoacetic acid)": ["C8H8O6", "Fatty Acyls [FA] with formula: C8H8O6"],
        "LMFA01170073 (5-(L-alanin-3-yl)-2-hydroxy-cis,cis-muconate 6-semialdehyde)": ["C9H11NO6", "Fatty Acyls [FA] with formula: C9H11NO6"],
        "LMFA06000138; LMFA06000136; LMFA06000137": ["C9H12O", "Fatty Acyls [FA] with formula: C9H12O"],
        "LMFA06000046; LMFA06000047; LMFA06000048; LMFA06000049; LMFA06000139; LMFA06000135; LMFA06000117 ((2E,6Z)-nona-2,6-dienal); LMFA06000045": ["C9H14O", "Fatty Acyls [FA] with formula: C9H14O"],
        "LMFA01030448; LMFA01030449; LMFA01030447; LMFA01030509; LMFA01030508; LMFA01030505; LMFA01030504; LMFA01030507; LMFA01030506; LMFA01030450": ["C9H14O2", "Fatty Acyls [FA] with formula: C9H14O2"],
        "LMFA06000043; LMFA06000041; LMFA06000042; LMFA06000044; LMFA06000113; LMFA05000118; LMFA06000127; LMFA06000140; LMFA05000136": ["C9H16O", "Fatty Acyls [FA] with formula: C9H16O"],
        "LMFA06000051 (4-hydroxynonenal); LMFA05000231; LMFA05000233; LMFA01030801; LMFA01030802; LMFA01030028 (8-nonylenic acid); LMFA01030026 (alpha-nonylenic acid); LMFA01030027 (beta-nonylenic acid); LMFA01030443; LMFA01030444; LMFA01030445; LMFA01030446; LMFA01020103; LMFA01020127 (2-amyl 3-butenoic acid)": ["C9H16O2", "Fatty Acyls [FA] with formula: C9H16O2"],
        "LMFA01060026 (6-propionyl n-caproic acid); LMFA01060025 (n-butyrl n-valeric acid); LMFA01060024 (4-n-valeryl butyric acid); LMFA01060023 (3-caproyl propionic acid); LMFA01060022 (n-heptanoyl acetic acid); LMFA01060157; LMFA01060155; LMFA01060159; LMFA01060158; LMFA01050232; LMFA01060160; LMFA01060178 (7-methyl-3-oxooctanoic acid)": ["C9H16O3", "Fatty Acyls [FA] with formula: C9H16O3"],
        "LMFA01170054 (Azelaic acid)": ["C9H16O4", "Fatty Acyls [FA] with formula: C9H16O4"],
        "LMFA01090025; LMFA01090026": ["C9H17BrO2", "Fatty Acyls [FA] with formula: C9H17BrO2"],
        "LMFA01060168": ["C9H17NO3", "Fatty Acyls [FA] with formula: C9H17NO3"],
        "LMFA05000121; LMFA06000040 (Pelargonaldehyde); LMFA05000120; LMFA05000133; LMFA05000131; LMFA05000135; LMFA05000134": ["C9H18O", "Fatty Acyls [FA] with formula: C9H18O"],
        "LMFA05000138; LMFA01020245; LMFA01020244; LMFA01020243; LMFA01020270; LMFA01020088; LMFA05000234; LMFA01020153; LMFA01020152; LMFA01020003 (7-methyl caprylic acid); LMFA01020002 ((+)-6-methyl caprylic acid); LMFA01010009 (Pelargonic acid)": ["C9H18O2", "Fatty Acyls [FA] with formula: C9H18O2"],
        "LMFA01050275; LMFA01050231; LMFA01050028 (9-hydroxy pelargonic acid); LMFA01050024 (2-hydroxy pelargonic acid); LMFA01050025 ((+)-3-hydroxy pelargonic acid); LMFA01050026 (4-hydroxy pelargonic acid); LMFA01050027 (7-hydroxy pelargonic acid); LMFA01050230": ["C9H18O3", "Fatty Acyls [FA] with formula: C9H18O3"],
        "LMFA01100010; LMFA01100019": ["C9H19NO2", "Fatty Acyls [FA] with formula: C9H19NO2"],
        "LMFA05000129; LMFA05000092 (1-Nonanol)": ["C9H20O", "Fatty Acyls [FA] with formula: C9H20O"],
        "LMFA06000050": ["C9H4O", "Fatty Acyls [FA] with formula: C9H4O"],
        "LMFA01030721; LMFA01030722": ["C9H8O3", "Fatty Acyls [FA] with formula: C9H8O3"],
        "LMFA01010040 (Formic acid)": ["CH2O2", "Fatty Acyls [FA] with formula: CH2O2"],
    },
    'Saccharolipids [SL]': {
        "LMSL02000001 (Kdo2-lipid A)": ["C110H202N2O39P2", "Saccharolipids [SL] with formula: C110H202N2O39P2"],
        "LMSL01010002 (UDP-GlcNAc)": ["C17H27N3O17P2", "Saccharolipids [SL] with formula: C17H27N3O17P2"],
        "LMSL05000001": ["C18H32O8", "Saccharolipids [SL] with formula: C18H32O8"],
        "LMSL01010001": ["C29H51N3O18P2", "Saccharolipids [SL] with formula: C29H51N3O18P2"],
        "LMSL01020003 (UDP-3-O-(beta-hydroxymyristoyl)-GlcNAc)": ["C31H53N3O19P2", "Saccharolipids [SL] with formula: C31H53N3O19P2"],
        "LMSL01020001 (Lipid X)": ["C34H66NO12P", "Saccharolipids [SL] with formula: C34H66NO12P"],
        "LMSL01020002 (UDP-2,3-diacyl-GlcN)": ["C43H77N3O20P2", "Saccharolipids [SL] with formula: C43H77N3O20P2"],
        "LMSL01040002 (Lipid A -disaccharide-1-P)": ["C68H129N2O20P", "Saccharolipids [SL] with formula: C68H129N2O20P"],
        "LMSL01040001 (Lipid IVA)": ["C68H130N2O23P2", "Saccharolipids [SL] with formula: C68H130N2O23P2"],
        "LMSL01050001 (Bordetella pertussis lipid A)": ["C78H148N2O24P2", "Saccharolipids [SL] with formula: C78H148N2O24P2"],
        "LMSL02000003 (Kdo2-Lipid IVA)": ["C84H154N2O37P2", "Saccharolipids [SL] with formula: C84H154N2O37P2"],
        "LMSL02000002 (Lauroyl-Kdo2-Lipid IVA)": ["C96H176N2O38P2", "Saccharolipids [SL] with formula: C96H176N2O38P2"],
        "LMSL01060001 (Bordetella parapertussis lipid A)": ["C96H182N2O24P2", "Saccharolipids [SL] with formula: C96H182N2O24P2"],
    },
    'Glycerolipids [GL]': {
        "LMGL05030001": ["C104H205O26PS", "Glycerolipids [GL] with formula: C104H205O26PS"],
        "LMGL01020030 (2-Octylglycerol); LMGL01020027 (1-Octylglycerol)": ["C11H24O3", "Glycerolipids [GL] with formula: C11H24O3"],
        "LMGL01010008": ["C15H30O4", "Glycerolipids [GL] with formula: C15H30O4"],
        "LMGL01010009 (MG(16:0/0:0/0:0)); LMGL01010001 (MG(16:0/0:0/0:0)[rac])": ["C19H38O4", "Glycerolipids [GL] with formula: C19H38O4"],
        "LMGL01010002 (MG(17:0/0:0/0:0)[rac])": ["C20H40O4", "Glycerolipids [GL] with formula: C20H40O4"],
        "LMGL01010006 (MG(18:2(9Z,12Z)/0:0/0:0)[rac])": ["C21H38O4", "Glycerolipids [GL] with formula: C21H38O4"],
        "LMGL01010004 (MG(18:1(11E)/0:0/0:0)[rac]); LMGL01010005 (MG(18:1(9Z)/0:0/0:0)[rac])": ["C21H40O4", "Glycerolipids [GL] with formula: C21H40O4"],
        "LMGL01010003 (MG(18:0/0:0/0:0)[rac])": ["C21H42O4", "Glycerolipids [GL] with formula: C21H42O4"],
        "LMGL01010023 (MG(0:0/20:4(5Z,8Z,11Z,14Z)/0:0))": ["C23H38O4", "Glycerolipids [GL] with formula: C23H38O4"],
        "LMGL01020026": ["C23H40O3", "Glycerolipids [GL] with formula: C23H40O3"],
        "LMGL01010007 (MG(20:0/0:0/0:0)[rac])": ["C23H46O4", "Glycerolipids [GL] with formula: C23H46O4"],
        "LMGL04010007 (SQMG(0:0/16:1(13Z))); LMGL04010003 (SQMG(16:1(11Z)/0:0)); LMGL04010002 (SQMG(16:1(9Z)/0:0)); LMGL04010005 (SQMG(0:0/16:1(9Z))); LMGL04010004 (SQMG(16:1(13Z)/0:0)); LMGL04010006 (SQMG(0:0/16:1(11Z)))": ["C25H45O11S", "Glycerolipids [GL] with formula: C25H45O11S"],
        "LMGL02010321 (1,2-dimyristoyl-sn-glycerol)": ["C31H60O5", "Glycerolipids [GL] with formula: C31H60O5"],
        "LMGL03012617 (1,2,3-tricaprinoyl-glycerol)": ["C33H62O6", "Glycerolipids [GL] with formula: C33H62O6"],
        "LMGL02010011 (DG(16:1(9Z)/16:1(9Z)/0:0))": ["C35H64O5", "Glycerolipids [GL] with formula: C35H64O5"],
        "LMGL02040001 (DG(P-14:0/18:1(9Z)))": ["C35H66O4", "Glycerolipids [GL] with formula: C35H66O4"],
        "LMGL02010010 (DG(16:0/16:1(9Z)/0:0)[iso2])": ["C35H66O5", "Glycerolipids [GL] with formula: C35H66O5"],
        "LMGL02010001 (DG(16:0/16:0/0:0)[rac]); LMGL02010009 (DG(16:0/16:0/0:0))": ["C35H68O5", "Glycerolipids [GL] with formula: C35H68O5"],
        "LMGL02010019 (DG(16:1(9Z)/17:2(9Z,12Z)/0:0)[iso2])": ["C36H64O5", "Glycerolipids [GL] with formula: C36H64O5"],
        "LMGL02010016 (DG(16:1(9Z)/17:1(9Z)/0:0)[iso2]); LMGL02010017 (DG(16:0/17:2(9Z,12Z)/0:0)[iso2])": ["C36H66O5", "Glycerolipids [GL] with formula: C36H66O5"],
        "LMGL04010001": ["C36H68O17", "Glycerolipids [GL] with formula: C36H68O17"],
        "LMGL02010014 (DG(16:0/17:1(9Z)/0:0)[iso2]); LMGL02010013 (DG(16:1(9Z)/17:0/0:0)[iso2])": ["C36H68O5", "Glycerolipids [GL] with formula: C36H68O5"],
        "LMGL02010012 (DG(16:0/17:0/0:0)[iso2])": ["C36H70O5", "Glycerolipids [GL] with formula: C36H70O5"],
        "LMGL02010035 (DG(16:1(9Z)/18:3(9Z,12Z,15Z)/0:0)[iso2]); LMGL02010028 (DG(17:2(9Z,12Z)/17:2(9Z,12Z)/0:0))": ["C37H64O5", "Glycerolipids [GL] with formula: C37H64O5"],
        "LMGL02010032 (DG(16:0/18:3(9Z,12Z,15Z)/0:0)[iso2]); LMGL02010031 (DG(16:1(9Z)/18:2(9Z,12Z)/0:0)[iso2]); LMGL02010024 (DG(17:1(9Z)/17:2(9Z,12Z)/0:0)[iso2])": ["C37H66O5", "Glycerolipids [GL] with formula: C37H66O5"],
        "LMGL02030032; LMGL02030033": ["C37H68O3", "Glycerolipids [GL] with formula: C37H68O3"],
        "LMGL02010027 (DG(16:0/18:2(9Z,12Z)/0:0)[iso2]); LMGL02010026 (DG(16:1(9Z)/18:1(9Z)/0:0)[iso2]); LMGL02010021 (DG(17:1(9Z)/17:1(9Z)/0:0)); LMGL02010022 (DG(17:0/17:2(9Z,12Z)/0:0)[iso2])": ["C37H68O5", "Glycerolipids [GL] with formula: C37H68O5"],
        "LMGL02010018 (DG(17:0/17:1(9Z)/0:0)[iso2]); LMGL02010006 (DG(16:0/18:1(9Z)/0:0)); LMGL02010005 (DG(18:1(9Z)/16:0/0:0)); LMGL02010004 (DG(18:1(11E)/16:0/0:0)); LMGL02010023 (DG(16:1(9Z)/18:0/0:0)[iso2]); LMGL02010307 (DG(16:0/18:1(11Z)/0:0))": ["C37H70O5", "Glycerolipids [GL] with formula: C37H70O5"],
        "LMGL02020001 (DG(O-16:0/18:1(9Z)))": ["C37H72O4", "Glycerolipids [GL] with formula: C37H72O4"],
        "LMGL02010015 (DG(17:0/17:0/0:0)); LMGL02010003 (DG(18:0/16:0/0:0)); LMGL02010020 (DG(16:0/18:0/0:0)[iso2])": ["C37H72O5", "Glycerolipids [GL] with formula: C37H72O5"],
        "LMGL02010051 (DG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/0:0)[iso2])": ["C38H64O5", "Glycerolipids [GL] with formula: C38H64O5"],
        "LMGL02010045 (DG(17:1(9Z)/18:3(9Z,12Z,15Z)/0:0)[iso2]); LMGL02010044 (DG(17:2(9Z,12Z)/18:2(9Z,12Z)/0:0)[iso2])": ["C38H66O5", "Glycerolipids [GL] with formula: C38H66O5"],
        "LMGL02010038 (DG(17:2(9Z,12Z)/18:1(9Z)/0:0)[iso2]); LMGL02010039 (DG(17:1(9Z)/18:2(9Z,12Z)/0:0)[iso2]); LMGL02010040 (DG(17:0/18:3(9Z,12Z,15Z)/0:0)[iso2])": ["C38H68O5", "Glycerolipids [GL] with formula: C38H68O5"],
        "LMGL02010033 (DG(17:2(9Z,12Z)/18:0/0:0)[iso2]); LMGL02010034 (DG(17:0/18:2(9Z,12Z)/0:0)[iso2])": ["C38H70O5", "Glycerolipids [GL] with formula: C38H70O5"],
        "LMGL02010030 (DG(17:0/18:1(9Z)/0:0)[iso2]); LMGL02010029 (DG(17:1(9Z)/18:0/0:0)[iso2]); LMGL02010041 (DG(16:1(9Z)/19:0/0:0)[iso2])": ["C38H72O5", "Glycerolipids [GL] with formula: C38H72O5"],
        "LMGL02010036 (DG(16:0/19:0/0:0)[iso2]); LMGL02010025 (DG(17:0/18:0/0:0)[iso2])": ["C38H74O5", "Glycerolipids [GL] with formula: C38H74O5"],
        "LMGL02010079 (DG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/0:0)); LMGL02010086 (DG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2])": ["C39H64O5", "Glycerolipids [GL] with formula: C39H64O5"],
        "LMGL02010077 (DG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010071 (DG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/0:0)[iso2]); LMGL02010078 (DG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2])": ["C39H66O5", "Glycerolipids [GL] with formula: C39H66O5"],
        "LMGL02010070 (DG(16:0/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010063 (DG(18:2(9Z,12Z)/18:2(9Z,12Z)/0:0)); LMGL02010064 (DG(18:1(9Z)/18:3(9Z,12Z,15Z)/0:0)[iso2]); LMGL02010069 (DG(16:1(9Z)/20:3(8Z,11Z,14Z)/0:0)[iso2])": ["C39H68O5", "Glycerolipids [GL] with formula: C39H68O5"],
        "LMGL02070004": ["C39H70O4", "Glycerolipids [GL] with formula: C39H70O4"],
        "LMGL02010056 (DG(18:1(9Z)/18:2(9Z,12Z)/0:0)[iso2]); LMGL02010057 (DG(18:0/18:3(9Z,12Z,15Z)/0:0)[iso2]); LMGL02010061 (DG(16:1(9Z)/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010062 (DG(16:0/20:3(8Z,11Z,14Z)/0:0)[iso2])": ["C39H70O5", "Glycerolipids [GL] with formula: C39H70O5"],
        "LMGL02030026; LMGL02030025": ["C39H72O3", "Glycerolipids [GL] with formula: C39H72O3"],
        "LMGL02010058 (DG(17:2(9Z,12Z)/19:0/0:0)[iso2]); LMGL02010050 (DG(18:0/18:2(9Z,12Z)/0:0)[iso2]); LMGL02010054 (DG(16:1(9Z)/20:1(11Z)/0:0)[iso2]); LMGL02010055 (DG(16:0/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010049 (DG(18:1(9Z)/18:1(9Z)/0:0))": ["C39H72O5", "Glycerolipids [GL] with formula: C39H72O5"],
        "LMGL02010052 (DG(17:1(9Z)/19:0/0:0)[iso2]); LMGL02010048 (DG(16:0/20:1(11Z)/0:0)[iso2]); LMGL02010043 (DG(18:0/18:1(9Z)/0:0)[iso2]); LMGL02010047 (DG(16:1(9Z)/20:0/0:0)[iso2])": ["C39H74O5", "Glycerolipids [GL] with formula: C39H74O5"],
        "LMGL03012618 (Trilauroyl-glycerol)": ["C39H74O6", "Glycerolipids [GL] with formula: C39H74O6"],
        "LMGL02010002 (DG(18:0/18:0/0:0)[rac]); LMGL02010037 (DG(18:0/18:0/0:0)); LMGL02010042 (DG(16:0/20:0/0:0)[iso2]); LMGL02010046 (DG(17:0/19:0/0:0)[iso2])": ["C39H76O5", "Glycerolipids [GL] with formula: C39H76O5"],
        "LMGL02010112 (DG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2])": ["C40H64O5", "Glycerolipids [GL] with formula: C40H64O5"],
        "LMGL02010102 (DG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010103 (DG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2])": ["C40H66O5", "Glycerolipids [GL] with formula: C40H66O5"],
        "LMGL02010094 (DG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2]); LMGL02010092 (DG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/0:0)[iso2]); LMGL02010093 (DG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2])": ["C40H68O5", "Glycerolipids [GL] with formula: C40H68O5"],
        "LMGL02010085 (DG(17:0/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010084 (DG(17:1(9Z)/20:3(8Z,11Z,14Z)/0:0)[iso2]); LMGL02010083 (DG(17:2(9Z,12Z)/20:2(11Z,14Z)/0:0)[iso2])": ["C40H70O5", "Glycerolipids [GL] with formula: C40H70O5"],
        "LMGL02070005; LMGL02070006": ["C40H72O4", "Glycerolipids [GL] with formula: C40H72O4"],
        "LMGL02010076 (DG(17:0/20:3(8Z,11Z,14Z)/0:0)[iso2]); LMGL02010074 (DG(17:2(9Z,12Z)/20:1(11Z)/0:0)[iso2]); LMGL02010075 (DG(17:1(9Z)/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010088 (DG(18:3(9Z,12Z,15Z)/19:0/0:0)[iso2])": ["C40H72O5", "Glycerolipids [GL] with formula: C40H72O5"],
        "LMGL02030028; LMGL02030027": ["C40H74O3", "Glycerolipids [GL] with formula: C40H74O3"],
        "LMGL02010067 (DG(17:1(9Z)/20:1(11Z)/0:0)[iso2]); LMGL02010066 (DG(17:2(9Z,12Z)/20:0/0:0)[iso2]); LMGL02010068 (DG(17:0/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010080 (DG(18:2(9Z,12Z)/19:0/0:0)[iso2])": ["C40H74O5", "Glycerolipids [GL] with formula: C40H74O5"],
        "LMGL05010005 (SQDG(16:0/14:0))": ["C40H75O12S", "Glycerolipids [GL] with formula: C40H75O12S"],
        "LMGL02010059 (DG(17:1(9Z)/20:0/0:0)[iso2]); LMGL02010072 (DG(18:1(9Z)/19:0/0:0)[iso2]); LMGL02010095 (DG(16:1(9Z)/21:0/0:0)[iso2]); LMGL02010060 (DG(17:0/20:1(11Z)/0:0)[iso2])": ["C40H76O5", "Glycerolipids [GL] with formula: C40H76O5"],
        "LMGL02010053 (DG(17:0/20:0/0:0)[iso2]); LMGL02010065 (DG(18:0/19:0/0:0)[iso2]); LMGL02010087 (DG(16:0/21:0/0:0)[iso2])": ["C40H78O5", "Glycerolipids [GL] with formula: C40H78O5"],
        "LMGL02070007": ["C41H64O4", "Glycerolipids [GL] with formula: C41H64O4"],
        "LMGL02010154 (DG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2])": ["C41H64O5", "Glycerolipids [GL] with formula: C41H64O5"],
        "LMGL02030029": ["C41H66O3", "Glycerolipids [GL] with formula: C41H66O3"],
        "LMGL02010174 (DG(16:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010142 (DG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010143 (DG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2])": ["C41H66O5", "Glycerolipids [GL] with formula: C41H66O5"],
        "LMGL02010161 (DG(16:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010162 (DG(16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010132 (DG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2]); LMGL02010131 (DG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010130 (DG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/0:0)[iso2])": ["C41H68O5", "Glycerolipids [GL] with formula: C41H68O5"],
        "LMGL02010149 (DG(16:1(9Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010150 (DG(16:0/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010120 (DG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/0:0)[iso2]); LMGL02010121 (DG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010122 (DG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2]); LMGL02010119 (DG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/0:0)[iso2])": ["C41H70O5", "Glycerolipids [GL] with formula: C41H70O5"],
        "LMGL02010126 (DG(16:1(9Z)/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010138 (DG(16:0/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010108 (DG(18:3(9Z,12Z,15Z)/20:1(11Z)/0:0)[iso2]); LMGL02010109 (DG(18:2(9Z,12Z)/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010111 (DG(18:0/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010110 (DG(18:1(9Z)/20:3(8Z,11Z,14Z)/0:0)[iso2])": ["C41H72O5", "Glycerolipids [GL] with formula: C41H72O5"],
        "LMGL02010137 (DG(16:1(9Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010100 (DG(18:1(9Z)/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010101 (DG(18:0/20:3(8Z,11Z,14Z)/0:0)[iso2]); LMGL02010116 (DG(16:0/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010098 (DG(18:3(9Z,12Z,15Z)/20:0/0:0)[iso2]); LMGL02010099 (DG(18:2(9Z,12Z)/20:1(11Z)/0:0)[iso2])": ["C41H74O5", "Glycerolipids [GL] with formula: C41H74O5"],
        "LMGL05010008 (SQDG(16:0/16:1(13Z))); LMGL05010006 (SQDG(16:0/16:1(9Z))); LMGL05010007 (SQDG(16:0/16:1(11Z)))": ["C41H75O12S", "Glycerolipids [GL] with formula: C41H75O12S"],
        "LMGL02010123 (DG(17:2(9Z,12Z)/21:0/0:0)[iso2]); LMGL02010127 (DG(16:0/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010115 (DG(16:1(9Z)/22:1(13Z)/0:0)[iso2]); LMGL02010090 (DG(18:1(9Z)/20:1(11Z)/0:0)[iso2]); LMGL02010091 (DG(18:0/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010089 (DG(18:2(9Z,12Z)/20:0/0:0)[iso2])": ["C41H76O5", "Glycerolipids [GL] with formula: C41H76O5"],
        "LMGL05010004 (SQDG(16:0/16:0))": ["C41H77O12S", "Glycerolipids [GL] with formula: C41H77O12S"],
        "LMGL02010106 (DG(16:0/22:1(13Z)/0:0)[iso2]); LMGL02010105 (DG(16:1(9Z)/22:0/0:0)[iso2]); LMGL02010113 (DG(17:1(9Z)/21:0/0:0)[iso2]); LMGL02010082 (DG(18:0/20:1(11Z)/0:0)[iso2]); LMGL02010081 (DG(18:1(9Z)/20:0/0:0)[iso2])": ["C41H78O5", "Glycerolipids [GL] with formula: C41H78O5"],
        "LMGL02010008 (DG(20:0/18:0)); LMGL02010104 (DG(17:0/21:0/0:0)[iso2]); LMGL02010073 (DG(18:0/20:0/0:0)[iso2]); LMGL02010096 (DG(16:0/22:0/0:0)[iso2]); LMGL02010097 (DG(19:0/19:0/0:0))": ["C41H80O5", "Glycerolipids [GL] with formula: C41H80O5"],
        "LMGL00000123 (Crasseride 2a)": ["C41H80O8", "Glycerolipids [GL] with formula: C41H80O8"],
        "LMGL02010206 (DG(17:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C42H66O5", "Glycerolipids [GL] with formula: C42H66O5"],
        "LMGL02010195 (DG(17:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010196 (DG(17:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C42H68O5", "Glycerolipids [GL] with formula: C42H68O5"],
        "LMGL02010184 (DG(17:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010185 (DG(17:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010183 (DG(17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2])": ["C42H70O5", "Glycerolipids [GL] with formula: C42H70O5"],
        "LMGL02010166 (DG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2]); LMGL02010173 (DG(17:0/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010172 (DG(17:1(9Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010158 (DG(17:2(9Z,12Z)/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C42H72O5", "Glycerolipids [GL] with formula: C42H72O5"],
        "LMGL02010160 (DG(17:0/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010171 (DG(17:2(9Z,12Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010147 (DG(17:1(9Z)/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010153 (DG(19:0/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2])": ["C42H74O5", "Glycerolipids [GL] with formula: C42H74O5"],
        "LMGL02010167 (DG(18:3(9Z,12Z,15Z)/21:0/0:0)[iso2]); LMGL02010141 (DG(19:0/20:3(8Z,11Z,14Z)/0:0)[iso2]); LMGL02010146 (DG(17:2(9Z,12Z)/22:1(13Z)/0:0)[iso2]); LMGL02010159 (DG(17:1(9Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010136 (DG(17:0/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C42H76O5", "Glycerolipids [GL] with formula: C42H76O5"],
        "LMGL02010148 (DG(17:0/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010155 (DG(18:2(9Z,12Z)/21:0/0:0)[iso2]); LMGL02010129 (DG(19:0/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010135 (DG(17:1(9Z)/22:1(13Z)/0:0)[iso2]); LMGL02010134 (DG(17:2(9Z,12Z)/22:0/0:0)[iso2])": ["C42H78O5", "Glycerolipids [GL] with formula: C42H78O5"],
        "LMGL02010144 (DG(18:1(9Z)/21:0/0:0)[iso2]); LMGL02010124 (DG(17:1(9Z)/22:0/0:0)[iso2]); LMGL02010125 (DG(17:0/22:1(13Z)/0:0)[iso2]); LMGL02010118 (DG(19:0/20:1(11Z)/0:0)[iso2])": ["C42H80O5", "Glycerolipids [GL] with formula: C42H80O5"],
        "LMGL00000125 (DGTS(16:0/16:0))": ["C42H81NO7", "Glycerolipids [GL] with formula: C42H81NO7"],
        "LMGL02010133 (DG(18:0/21:0/0:0)[iso2]); LMGL02010107 (DG(19:0/20:0/0:0)[iso2]); LMGL02010114 (DG(17:0/22:0/0:0)[iso2])": ["C42H82O5", "Glycerolipids [GL] with formula: C42H82O5"],
        "LMGL02010226 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0))": ["C43H64O5", "Glycerolipids [GL] with formula: C43H64O5"],
        "LMGL02010217 (DG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2]); LMGL02010242 (DG(18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C43H66O5", "Glycerolipids [GL] with formula: C43H66O5"],
        "LMGL05010027 (MGDG-O(16:3(7Z,10Z,13Z)))": ["C43H68O11", "Glycerolipids [GL] with formula: C43H68O11"],
        "LMGL02070008": ["C43H68O4", "Glycerolipids [GL] with formula: C43H68O4"],
        "LMGL02010234 (DG(18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010233 (DG(18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010207 (DG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/0:0)); LMGL02010208 (DG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2])": ["C43H68O5", "Glycerolipids [GL] with formula: C43H68O5"],
        "LMGL05010019 (MGDG(18:3(9Z,12Z,15Z)/16:3(7Z,10Z,13Z)))": ["C43H70O10", "Glycerolipids [GL] with formula: C43H70O10"],
        "LMGL02030030": ["C43H70O3", "Glycerolipids [GL] with formula: C43H70O3"],
        "LMGL02070009": ["C43H70O4", "Glycerolipids [GL] with formula: C43H70O4"],
        "LMGL02010197 (DG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010198 (DG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2]); LMGL02010225 (DG(18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010224 (DG(18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010223 (DG(18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2])": ["C43H70O5", "Glycerolipids [GL] with formula: C43H70O5"],
        "LMGL02030031": ["C43H72O3", "Glycerolipids [GL] with formula: C43H72O3"],
        "LMGL02010186 (DG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/0:0)); LMGL02010187 (DG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010188 (DG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2]); LMGL02010216 (DG(18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010214 (DG(18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010215 (DG(18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010202 (DG(18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C43H72O5", "Glycerolipids [GL] with formula: C43H72O5"],
        "LMGL02010192 (DG(18:2(9Z,12Z)/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010177 (DG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/0:0)[iso2]); LMGL02010176 (DG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010175 (DG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/0:0)[iso2]); LMGL02010213 (DG(18:3(9Z,12Z,15Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010205 (DG(18:0/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010204 (DG(18:1(9Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2])": ["C43H74O5", "Glycerolipids [GL] with formula: C43H74O5"],
        "LMGL02010181 (DG(18:1(9Z)/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010164 (DG(20:1(11Z)/20:3(8Z,11Z,14Z)/0:0)[iso2]); LMGL02010165 (DG(20:0/20:4(5Z,8Z,11Z,14Z)/0:0)[iso2]); LMGL02010163 (DG(20:2(11Z,14Z)/20:2(11Z,14Z)/0:0)); LMGL02010191 (DG(18:3(9Z,12Z,15Z)/22:1(13Z)/0:0)[iso2]); LMGL02010194 (DG(18:0/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010203 (DG(18:2(9Z,12Z)/22:2(13Z,16Z)/0:0)[iso2])": ["C43H76O5", "Glycerolipids [GL] with formula: C43H76O5"],
        "LMGL05010026 (MGDG(16:0/18:2(9Z,12Z)))": ["C43H78O10", "Glycerolipids [GL] with formula: C43H78O10"],
        "LMGL02010180 (DG(18:2(9Z,12Z)/22:1(13Z)/0:0)[iso2]); LMGL02010193 (DG(18:1(9Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010179 (DG(18:3(9Z,12Z,15Z)/22:0/0:0)[iso2]); LMGL02010170 (DG(18:0/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010151 (DG(20:1(11Z)/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010152 (DG(20:0/20:3(8Z,11Z,14Z)/0:0)[iso2])": ["C43H78O5", "Glycerolipids [GL] with formula: C43H78O5"],
        "LMGL05010025 (MGDG(16:0/18:1(9Z)))": ["C43H80O10", "Glycerolipids [GL] with formula: C43H80O10"],
        "LMGL02010182 (DG(18:0/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010168 (DG(18:2(9Z,12Z)/22:0/0:0)[iso2]); LMGL02010169 (DG(18:1(9Z)/22:1(13Z)/0:0)[iso2]); LMGL02010140 (DG(20:0/20:2(11Z,14Z)/0:0)[iso2]); LMGL02010139 (DG(20:1(11Z)/20:1(11Z)/0:0))": ["C43H80O5", "Glycerolipids [GL] with formula: C43H80O5"],
        "LMGL00000124 (Cyclic archaeol with two cyclopentane rings)": ["C43H82O3", "Glycerolipids [GL] with formula: C43H82O3"],
        "LMGL02010157 (DG(18:0/22:1(13Z)/0:0)[iso2]); LMGL02010156 (DG(18:1(9Z)/22:0/0:0)[iso2]); LMGL02010128 (DG(20:0/20:1(11Z)/0:0)[iso2])": ["C43H82O5", "Glycerolipids [GL] with formula: C43H82O5"],
        "LMGL02010178 (DG(19:0/21:0/0:0)[iso2]); LMGL02010145 (DG(18:0/22:0/0:0)[iso2]); LMGL02010117 (DG(20:0/20:0/0:0))": ["C43H84O5", "Glycerolipids [GL] with formula: C43H84O5"],
        "LMGL02030035 (Archaeol)": ["C43H88O3", "Glycerolipids [GL] with formula: C43H88O3"],
        "LMGL02030034 (sn2-hydroxy-archaeol)": ["C43H88O4", "Glycerolipids [GL] with formula: C43H88O4"],
        "LMGL02010250 (DG(19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C44H74O5", "Glycerolipids [GL] with formula: C44H74O5"],
        "LMGL02010235 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/0:0)[iso2]); LMGL02010241 (DG(19:0/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C44H76O5", "Glycerolipids [GL] with formula: C44H76O5"],
        "LMGL02010232 (DG(19:0/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010227 (DG(20:4(5Z,8Z,11Z,14Z)/21:0/0:0)[iso2])": ["C44H78O5", "Glycerolipids [GL] with formula: C44H78O5"],
        "LMGL02010218 (DG(20:3(8Z,11Z,14Z)/21:0/0:0)[iso2]); LMGL02010212 (DG(19:0/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C44H80O5", "Glycerolipids [GL] with formula: C44H80O5"],
        "LMGL00000126 (DGTS(16:0/18:2(9Z,12Z))); LMGL00000121 (DGTS(16:0/18:2(9Z,12Z)))": ["C44H81NO7", "Glycerolipids [GL] with formula: C44H81NO7"],
        "LMGL02010222 (DG(19:0/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010209 (DG(20:2(11Z,14Z)/21:0/0:0)[iso2])": ["C44H82O5", "Glycerolipids [GL] with formula: C44H82O5"],
        "LMGL02010199 (DG(20:1(11Z)/21:0/0:0)[iso2]); LMGL02010201 (DG(19:0/22:1(13Z)/0:0)[iso2])": ["C44H84O5", "Glycerolipids [GL] with formula: C44H84O5"],
        "LMGL02010189 (DG(20:0/21:0/0:0)[iso2]); LMGL02010190 (DG(19:0/22:0/0:0)[iso2])": ["C44H86O5", "Glycerolipids [GL] with formula: C44H86O5"],
        "LMGL05010012 (MGDG(18:5(3Z,6Z,9Z,12Z,15Z)/18:5(3Z,6Z,9Z,12Z,15Z)))": ["C45H66O10", "Glycerolipids [GL] with formula: C45H66O10"],
        "LMGL02010286 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C45H66O5", "Glycerolipids [GL] with formula: C45H66O5"],
        "LMGL05010011 (MGDG(18:5(3Z,6Z,9Z,12Z,15Z)/18:4(6Z,9Z,12Z,15Z)))": ["C45H68O10", "Glycerolipids [GL] with formula: C45H68O10"],
        "LMGL02010281 (DG(20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010280 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C45H68O5", "Glycerolipids [GL] with formula: C45H68O5"],
        "LMGL05010017 (MGDG(20:5(5Z,8Z,11Z,14Z,17Z)/16:3(7Z,10Z,13Z))); LMGL05010018 (MGDG(16:3(7Z,10Z,13Z)/20:5(5Z,8Z,11Z,14Z,17Z)))": ["C45H70O10", "Glycerolipids [GL] with formula: C45H70O10"],
        "LMGL02010274 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010275 (DG(20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010276 (DG(20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C45H70O5", "Glycerolipids [GL] with formula: C45H70O5"],
        "LMGL05010014 (MGDG(18:3(9Z,12Z,15Z)/18:4(6Z,9Z,12Z,15Z)))": ["C45H72O10", "Glycerolipids [GL] with formula: C45H72O10"],
        "LMGL02010270 (DG(20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010260 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010269 (DG(20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010268 (DG(20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2])": ["C45H72O5", "Glycerolipids [GL] with formula: C45H72O5"],
        "LMGL05010001 (MGDG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)))": ["C45H74O10", "Glycerolipids [GL] with formula: C45H74O10"],
        "LMGL02010263 (DG(20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010262 (DG(20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010267 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010264 (DG(20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010253 (DG(20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C45H74O5", "Glycerolipids [GL] with formula: C45H74O5"],
        "LMGL05010009 (SQDG(22:5(5Z,8Z,11Z,14Z,17Z)/16:1(13Z)))": ["C45H75O12S", "Glycerolipids [GL] with formula: C45H75O12S"],
        "LMGL05010024 (MGDG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)))": ["C45H76O10", "Glycerolipids [GL] with formula: C45H76O10"],
        "LMGL02010261 (DG(20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010256 (DG(20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010257 (DG(20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010255 (DG(20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010252 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z)/0:0)[iso2]); LMGL02010246 (DG(20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C45H76O5", "Glycerolipids [GL] with formula: C45H76O5"],
        "LMGL05010023 (MGDG(18:2(9Z,12Z)/18:2(9Z,12Z)))": ["C45H78O10", "Glycerolipids [GL] with formula: C45H78O10"],
        "LMGL02010238 (DG(20:2(11Z,14Z)/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010254 (DG(20:3(8Z,11Z,14Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010249 (DG(20:0/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010248 (DG(20:1(11Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010245 (DG(20:4(5Z,8Z,11Z,14Z)/22:1(13Z)/0:0)[iso2]); LMGL02010244 (DG(20:5(5Z,8Z,11Z,14Z,17Z)/22:0/0:0)[iso2])": ["C45H78O5", "Glycerolipids [GL] with formula: C45H78O5"],
        "LMGL02010236 (DG(20:4(5Z,8Z,11Z,14Z)/22:0/0:0)[iso2]); LMGL02010237 (DG(20:3(8Z,11Z,14Z)/22:1(13Z)/0:0)[iso2]); LMGL02010230 (DG(20:1(11Z)/22:3(10Z,13Z,16Z)/0:0)[iso2]); LMGL02010240 (DG(20:0/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010247 (DG(20:2(11Z,14Z)/22:2(13Z,16Z)/0:0)[iso2])": ["C45H80O5", "Glycerolipids [GL] with formula: C45H80O5"],
        "LMGL05010022 (MGDG(18:0(9Z)/18:2(9Z,12Z))); LMGL05010021 (MGDG(18:1(9Z)/18:1(9Z)))": ["C45H82O10", "Glycerolipids [GL] with formula: C45H82O10"],
        "LMGL02010239 (DG(20:1(11Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010229 (DG(20:2(11Z,14Z)/22:1(13Z)/0:0)[iso2]); LMGL02010228 (DG(20:3(8Z,11Z,14Z)/22:0/0:0)[iso2]); LMGL02010221 (DG(20:0/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C45H82O5", "Glycerolipids [GL] with formula: C45H82O5"],
        "LMGL02010231 (DG(20:0/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010220 (DG(20:1(11Z)/22:1(13Z)/0:0)[iso2]); LMGL02010219 (DG(20:2(11Z,14Z)/22:0/0:0)[iso2])": ["C45H84O5", "Glycerolipids [GL] with formula: C45H84O5"],
        "LMGL02010210 (DG(20:1(11Z)/22:0/0:0)[iso2]); LMGL02010211 (DG(20:0/22:1(13Z)/0:0)[iso2])": ["C45H86O5", "Glycerolipids [GL] with formula: C45H86O5"],
        "LMGL03012616 (TG(14:0/14:0/14:0))": ["C45H86O6", "Glycerolipids [GL] with formula: C45H86O6"],
        "LMGL05010003": ["C45H87NO9", "Glycerolipids [GL] with formula: C45H87NO9"],
        "LMGL02010200 (DG(20:0/22:0/0:0)[iso2]); LMGL02010243 (DG(21:0/21:0/0:0))": ["C45H88O5", "Glycerolipids [GL] with formula: C45H88O5"],
        "LMGL02010290 (DG(21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C46H78O5", "Glycerolipids [GL] with formula: C46H78O5"],
        "LMGL02010285 (DG(21:0/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C46H80O5", "Glycerolipids [GL] with formula: C46H80O5"],
        "LMGL02010279 (DG(21:0/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2])": ["C46H82O5", "Glycerolipids [GL] with formula: C46H82O5"],
        "LMGL02010266 (DG(21:0/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C46H84O5", "Glycerolipids [GL] with formula: C46H84O5"],
        "LMGL02010273 (DG(21:0/22:2(13Z,16Z)/0:0)[iso2])": ["C46H86O5", "Glycerolipids [GL] with formula: C46H86O5"],
        "LMGL02010259 (DG(21:0/22:1(13Z)/0:0)[iso2])": ["C46H88O5", "Glycerolipids [GL] with formula: C46H88O5"],
        "LMGL02010251 (DG(21:0/22:0/0:0)[iso2])": ["C46H90O5", "Glycerolipids [GL] with formula: C46H90O5"],
        "LMGL02010306 (DG(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0))": ["C47H68O5", "Glycerolipids [GL] with formula: C47H68O5"],
        "LMGL02010305 (DG(22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C47H70O5", "Glycerolipids [GL] with formula: C47H70O5"],
        "LMGL05010016 (MGDG(20:5(5Z,8Z,11Z,14Z,17Z)/18:4(6Z,9Z,12Z,15Z)))": ["C47H72O10", "Glycerolipids [GL] with formula: C47H72O10"],
        "LMGL02010304 (DG(22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010303 (DG(22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0))": ["C47H72O5", "Glycerolipids [GL] with formula: C47H72O5"],
        "LMGL05010013 (MGDG(20:5(5Z,8Z,11Z,14Z,17Z)/18:3(9Z,12Z,15Z)))": ["C47H74O10", "Glycerolipids [GL] with formula: C47H74O10"],
        "LMGL02010300 (DG(22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010301 (DG(22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C47H74O5", "Glycerolipids [GL] with formula: C47H74O5"],
        "LMGL05010002": ["C47H76O11", "Glycerolipids [GL] with formula: C47H76O11"],
        "LMGL02010296 (DG(22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010298 (DG(22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/0:0)); LMGL02010302 (DG(22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C47H76O5", "Glycerolipids [GL] with formula: C47H76O5"],
        "LMGL02010292 (DG(22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010297 (DG(22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010299 (DG(22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2])": ["C47H78O5", "Glycerolipids [GL] with formula: C47H78O5"],
        "LMGL02010293 (DG(22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010294 (DG(22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010295 (DG(22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010282 (DG(22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z)/0:0))": ["C47H80O5", "Glycerolipids [GL] with formula: C47H80O5"],
        "LMGL02010289 (DG(22:0/22:5(7Z,10Z,13Z,16Z,19Z)/0:0)[iso2]); LMGL02010288 (DG(22:1(13Z)/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010287 (DG(22:3(10Z,13Z,16Z)/22:2(13Z,16Z)/0:0)[iso2])": ["C47H82O5", "Glycerolipids [GL] with formula: C47H82O5"],
        "LMGL02010291 (DG(22:2(13Z,16Z)/22:2(13Z,16Z)/0:0)); LMGL02010284 (DG(22:0/22:4(7Z,10Z,13Z,16Z)/0:0)[iso2]); LMGL02010277 (DG(22:1(13Z)/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C47H84O5", "Glycerolipids [GL] with formula: C47H84O5"],
        "LMGL02010283 (DG(22:1(13Z)/22:2(13Z,16Z)/0:0)[iso2]); LMGL02010272 (DG(22:0/22:3(10Z,13Z,16Z)/0:0)[iso2])": ["C47H86O5", "Glycerolipids [GL] with formula: C47H86O5"],
        "LMGL02010271 (DG(22:1(13Z)/22:1(13Z)/0:0)); LMGL02010278 (DG(22:0/22:2(13Z,16Z)/0:0)[iso2])": ["C47H88O5", "Glycerolipids [GL] with formula: C47H88O5"],
        "LMGL02010265 (DG(22:0/22:1(13Z)/0:0)[iso2])": ["C47H90O5", "Glycerolipids [GL] with formula: C47H90O5"],
        "LMGL02010258 (DG(22:0/22:0/0:0))": ["C47H92O5", "Glycerolipids [GL] with formula: C47H92O5"],
        "LMGL00000127 (DGTA(18:1/22:4(10Z,13Z,16Z,19Z)))": ["C48H83NO7", "Glycerolipids [GL] with formula: C48H83NO7"],
        "LMGL03010007 (TG(12:0/16:0/18:0))": ["C49H94O6", "Glycerolipids [GL] with formula: C49H94O6"],
        "LMGL00000122": ["C50H85NO7", "Glycerolipids [GL] with formula: C50H85NO7"],
        "LMGL05010010 (DGDG(18:5(3Z,6Z,9Z,12Z,15Z)/18:4(6Z,9Z,12Z,15Z)))": ["C51H78O15", "Glycerolipids [GL] with formula: C51H78O15"],
        "LMGL05010020 (DGDG(18:4(6Z,9Z,12Z,15Z)/18:4(6Z,9Z,12Z,15Z)))": ["C51H80O15", "Glycerolipids [GL] with formula: C51H80O15"],
        "LMGL03010020 (TG(16:1(9Z)/16:1(9Z)/16:1(9Z)))": ["C51H92O6", "Glycerolipids [GL] with formula: C51H92O6"],
        "LMGL03010018 (TG(16:0/16:1(9Z)/16:1(9Z))[iso3])": ["C51H94O6", "Glycerolipids [GL] with formula: C51H94O6"],
        "LMGL03010017 (TG(16:0/16:0/16:1(9Z))[iso3])": ["C51H96O6", "Glycerolipids [GL] with formula: C51H96O6"],
        "LMGL03010001 (TG(16:0/16:0/16:0))": ["C51H98O6", "Glycerolipids [GL] with formula: C51H98O6"],
        "LMGL03010019 (TG(16:0/16:0/17:0)[iso3])": ["C52H100O6", "Glycerolipids [GL] with formula: C52H100O6"],
        "LMGL03010035 (TG(16:1(9Z)/16:1(9Z)/17:2(9Z,12Z))[iso3])": ["C52H92O6", "Glycerolipids [GL] with formula: C52H92O6"],
        "LMGL03010030 (TG(16:0/16:1(9Z)/17:2(9Z,12Z))[iso6]); LMGL03010029 (TG(16:1(9Z)/16:1(9Z)/17:1(9Z))[iso3])": ["C52H94O6", "Glycerolipids [GL] with formula: C52H94O6"],
        "LMGL03010024 (TG(16:1(9Z)/16:1(9Z)/17:0)[iso3]); LMGL03010025 (TG(16:0/16:1(9Z)/17:1(9Z))[iso6]); LMGL03010026 (TG(16:0/16:0/17:2(9Z,12Z))[iso3])": ["C52H96O6", "Glycerolipids [GL] with formula: C52H96O6"],
        "LMGL03010021 (TG(16:0/16:1(9Z)/17:0)[iso6]); LMGL03010022 (TG(16:0/16:0/17:1(9Z))[iso3])": ["C52H98O6", "Glycerolipids [GL] with formula: C52H98O6"],
        "LMGL03010006 (TG(16:0/16:0/18:1(9Z))); LMGL03010027 (TG(16:1(9Z)/17:0/17:0)[iso3]); LMGL03010028 (TG(16:0/17:0/17:1(9Z))[iso6]); LMGL03010036 (TG(16:0/16:1(9Z)/18:0)[iso6]); LMGL03010005 (TG(16:0/16:0/18:1(11E)))": ["C53H100O6", "Glycerolipids [GL] with formula: C53H100O6"],
        "LMGL03010004 (TG(16:0/16:0/18:0)); LMGL03010023 (TG(16:0/17:0/17:0)[iso3])": ["C53H102O6", "Glycerolipids [GL] with formula: C53H102O6"],
        "LMGL03010078 (TG(16:1(9Z)/16:1(9Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010056 (TG(16:1(9Z)/17:2(9Z,12Z)/17:2(9Z,12Z))[iso3])": ["C53H92O6", "Glycerolipids [GL] with formula: C53H92O6"],
        "LMGL03010064 (TG(16:1(9Z)/16:1(9Z)/18:2(9Z,12Z))[iso3]); LMGL03010065 (TG(16:0/16:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010046 (TG(16:0/17:2(9Z,12Z)/17:2(9Z,12Z))[iso3]); LMGL03010047 (TG(16:1(9Z)/17:1(9Z)/17:2(9Z,12Z))[iso6])": ["C53H94O6", "Glycerolipids [GL] with formula: C53H94O6"],
        "LMGL03010040 (TG(16:1(9Z)/17:0/17:2(9Z,12Z))[iso6]); LMGL03010054 (TG(16:0/16:0/18:3(9Z,12Z,15Z))[iso3]); LMGL03010053 (TG(16:0/16:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010052 (TG(16:1(9Z)/16:1(9Z)/18:1(9Z))[iso3]); LMGL03010037 (TG(16:1(9Z)/17:1(9Z)/17:1(9Z))[iso3]); LMGL03010039 (TG(16:0/17:1(9Z)/17:2(9Z,12Z))[iso6])": ["C53H96O6", "Glycerolipids [GL] with formula: C53H96O6"],
        "LMGL03010042 (TG(16:1(9Z)/16:1(9Z)/18:0)[iso3]); LMGL03010043 (TG(16:0/16:1(9Z)/18:1(9Z))[iso6]); LMGL03010044 (TG(16:0/16:0/18:2(9Z,12Z))[iso3]); LMGL03010033 (TG(16:1(9Z)/17:0/17:1(9Z))[iso6]); LMGL03010032 (TG(16:0/17:1(9Z)/17:1(9Z))[iso3]); LMGL03010034 (TG(16:0/17:0/17:2(9Z,12Z))[iso6])": ["C53H98O6", "Glycerolipids [GL] with formula: C53H98O6"],
        "LMGL03010061 (TG(16:0/17:1(9Z)/18:1(9Z))[iso6]); LMGL03010062 (TG(16:1(9Z)/17:0/18:1(9Z))[iso6]); LMGL03010063 (TG(16:0/17:0/18:2(9Z,12Z))[iso6]); LMGL03010094 (TG(16:1(9Z)/16:1(9Z)/19:0)[iso3]); LMGL03010048 (TG(17:0/17:0/17:2(9Z,12Z))[iso3]); LMGL03010045 (TG(17:0/17:1(9Z)/17:1(9Z))[iso3]); LMGL03010059 (TG(16:1(9Z)/17:1(9Z)/18:0)[iso6]); LMGL03010058 (TG(16:0/17:2(9Z,12Z)/18:0)[iso6])": ["C54H100O6", "Glycerolipids [GL] with formula: C54H100O6"],
        "LMGL03010079 (TG(16:0/16:1(9Z)/19:0)[iso6]); LMGL03010049 (TG(16:0/17:1(9Z)/18:0)[iso6]); LMGL03010051 (TG(16:0/17:0/18:1(9Z))[iso6]); LMGL03010050 (TG(16:1(9Z)/17:0/18:0)[iso6]); LMGL03010038 (TG(17:0/17:0/17:1(9Z))[iso3])": ["C54H102O6", "Glycerolipids [GL] with formula: C54H102O6"],
        "LMGL03010066 (TG(16:0/16:0/19:0)[iso3]); LMGL03010041 (TG(16:0/17:0/18:0)[iso6]); LMGL03010031 (TG(17:0/17:0/17:0))": ["C54H104O6", "Glycerolipids [GL] with formula: C54H104O6"],
        "LMGL03010126 (TG(16:1(9Z)/17:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010097 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/17:2(9Z,12Z)))": ["C54H92O6", "Glycerolipids [GL] with formula: C54H92O6"],
        "LMGL03010081 (TG(17:1(9Z)/17:2(9Z,12Z)/17:2(9Z,12Z))[iso3]); LMGL03010107 (TG(16:0/17:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010105 (TG(16:1(9Z)/17:2(9Z,12Z)/18:2(9Z,12Z))[iso6]); LMGL03010108 (TG(16:1(9Z)/17:1(9Z)/18:3(9Z,12Z,15Z))[iso6])": ["C54H94O6", "Glycerolipids [GL] with formula: C54H94O6"],
        "LMGL03010086 (TG(16:1(9Z)/17:2(9Z,12Z)/18:1(9Z))[iso6]); LMGL03010088 (TG(16:0/17:2(9Z,12Z)/18:2(9Z,12Z))[iso6]); LMGL03010089 (TG(16:1(9Z)/17:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010068 (TG(17:1(9Z)/17:1(9Z)/17:2(9Z,12Z))[iso3]); LMGL03010067 (TG(17:0/17:2(9Z,12Z)/17:2(9Z,12Z))[iso3]); LMGL03010091 (TG(16:0/17:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010092 (TG(16:1(9Z)/17:0/18:3(9Z,12Z,15Z))[iso6])": ["C54H96O6", "Glycerolipids [GL] with formula: C54H96O6"],
        "LMGL03010077 (TG(16:0/17:0/18:3(9Z,12Z,15Z))[iso6]); LMGL03010076 (TG(16:1(9Z)/17:0/18:2(9Z,12Z))[iso6]); LMGL03010075 (TG(16:0/17:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010073 (TG(16:1(9Z)/17:1(9Z)/18:1(9Z))[iso6]); LMGL03010072 (TG(16:0/17:2(9Z,12Z)/18:1(9Z))[iso6]); LMGL03010070 (TG(16:1(9Z)/17:2(9Z,12Z)/18:0)[iso6]); LMGL03010055 (TG(17:1(9Z)/17:1(9Z)/17:1(9Z))); LMGL03010057 (TG(17:0/17:1(9Z)/17:2(9Z,12Z))[iso6])": ["C54H98O6", "Glycerolipids [GL] with formula: C54H98O6"],
        "LMGL03010125 (TG(16:0/18:0/18:3(9Z,12Z,15Z))[iso6]); LMGL03010121 (TG(16:0/18:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010122 (TG(16:1(9Z)/18:0/18:2(9Z,12Z))[iso6]); LMGL03010150 (TG(16:1(9Z)/17:2(9Z,12Z)/19:0)[iso6]); LMGL03010099 (TG(17:1(9Z)/17:2(9Z,12Z)/18:0)[iso6]); LMGL03010135 (TG(16:0/16:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010118 (TG(16:1(9Z)/18:1(9Z)/18:1(9Z))[iso3]); LMGL03010106 (TG(17:0/17:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010103 (TG(17:1(9Z)/17:1(9Z)/18:1(9Z))[iso3]); LMGL03010102 (TG(17:0/17:2(9Z,12Z)/18:1(9Z))[iso6]); LMGL03010109 (TG(17:0/17:0/18:3(9Z,12Z,15Z))[iso3]); LMGL03010136 (TG(16:0/16:0/20:3(8Z,11Z,14Z))[iso3]); LMGL03010134 (TG(16:1(9Z)/16:1(9Z)/20:1(11Z))[iso3])": ["C55H100O6", "Glycerolipids [GL] with formula: C55H100O6"],
        "LMGL03010128 (TG(16:0/17:2(9Z,12Z)/19:0)[iso6]); LMGL03010129 (TG(16:1(9Z)/17:1(9Z)/19:0)[iso6]); LMGL03010087 (TG(17:0/17:1(9Z)/18:1(9Z))[iso6]); LMGL03010084 (TG(17:1(9Z)/17:1(9Z)/18:0)[iso3]); LMGL03010083 (TG(17:0/17:2(9Z,12Z)/18:0)[iso6]); LMGL03010090 (TG(17:0/17:0/18:2(9Z,12Z))[iso3]); LMGL03010114 (TG(16:0/16:1(9Z)/20:1(11Z))[iso6]); LMGL03010115 (TG(16:0/16:0/20:2(11Z,14Z))[iso3]); LMGL03010113 (TG(16:1(9Z)/16:1(9Z)/20:0)[iso3]); LMGL03010104 (TG(16:0/18:0/18:2(9Z,12Z))[iso6]); LMGL03010101 (TG(16:1(9Z)/18:0/18:1(9Z))[iso6]); LMGL03010100 (TG(16:0/18:1(9Z)/18:1(9Z))[iso3])": ["C55H102O6", "Glycerolipids [GL] with formula: C55H102O6"],
        "LMGL03010085 (TG(16:0/18:0/18:1(9Z))[iso6]); LMGL03010082 (TG(16:1(9Z)/18:0/18:0)[iso3]); LMGL03010095 (TG(16:0/16:1(9Z)/20:0)[iso6]); LMGL03010096 (TG(16:0/16:0/20:1(11Z))[iso3]); LMGL03010074 (TG(17:0/17:0/18:1(9Z))[iso3]); LMGL03010071 (TG(17:0/17:1(9Z)/18:0)[iso6]); LMGL03010110 (TG(16:0/17:1(9Z)/19:0)[iso6]); LMGL03010111 (TG(16:1(9Z)/17:0/19:0)[iso6])": ["C55H104O6", "Glycerolipids [GL] with formula: C55H104O6"],
        "LMGL03010080 (TG(16:0/16:0/20:0)[iso3]); LMGL03010069 (TG(16:0/18:0/18:0)[iso3]); LMGL03010060 (TG(17:0/17:0/18:0)[iso3]); LMGL03010093 (TG(16:0/17:0/19:0)[iso6])": ["C55H106O6", "Glycerolipids [GL] with formula: C55H106O6"],
        "LMGL05030002; LMGL05030003": ["C55H108O16S", "Glycerolipids [GL] with formula: C55H108O16S"],
        "LMGL03010196 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010221 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010247 (TG(16:1(9Z)/16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3])": ["C55H92O6", "Glycerolipids [GL] with formula: C55H92O6"],
        "LMGL03010215 (TG(16:0/16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010214 (TG(16:1(9Z)/16:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010170 (TG(17:1(9Z)/17:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010192 (TG(16:0/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010193 (TG(16:1(9Z)/18:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010166 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/18:2(9Z,12Z))[iso3])": ["C55H94O6", "Glycerolipids [GL] with formula: C55H94O6"],
        "LMGL03010148 (TG(17:1(9Z)/17:1(9Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010140 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/18:1(9Z))[iso3]); LMGL03010147 (TG(17:0/17:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010144 (TG(17:1(9Z)/17:2(9Z,12Z)/18:2(9Z,12Z))[iso6]); LMGL03010163 (TG(16:1(9Z)/18:2(9Z,12Z)/18:2(9Z,12Z))[iso3]); LMGL03010167 (TG(16:0/18:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010168 (TG(16:1(9Z)/18:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010186 (TG(16:0/16:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03010185 (TG(16:0/16:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010184 (TG(16:1(9Z)/16:1(9Z)/20:3(8Z,11Z,14Z))[iso3])": ["C55H96O6", "Glycerolipids [GL] with formula: C55H96O6"],
        "LMGL03010124 (TG(17:1(9Z)/17:1(9Z)/18:2(9Z,12Z))[iso3]); LMGL03010127 (TG(17:0/17:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010120 (TG(17:1(9Z)/17:2(9Z,12Z)/18:1(9Z))[iso6]); LMGL03010123 (TG(17:0/17:2(9Z,12Z)/18:2(9Z,12Z))[iso6]); LMGL03010158 (TG(16:1(9Z)/16:1(9Z)/20:2(11Z,14Z))[iso3]); LMGL03010159 (TG(16:0/16:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010142 (TG(16:1(9Z)/18:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010141 (TG(16:0/18:2(9Z,12Z)/18:2(9Z,12Z))[iso3]); LMGL03010146 (TG(16:1(9Z)/18:0/18:3(9Z,12Z,15Z))[iso6]); LMGL03010145 (TG(16:0/18:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010160 (TG(16:0/16:0/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010117 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/18:0)[iso3])": ["C55H98O6", "Glycerolipids [GL] with formula: C55H98O6"],
        "LMGL03010208 (TG(16:0/17:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010209 (TG(16:1(9Z)/17:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010206 (TG(16:1(9Z)/17:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010213 (TG(16:0/17:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010212 (TG(16:1(9Z)/17:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010211 (TG(16:0/17:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010194 (TG(17:0/18:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010195 (TG(17:1(9Z)/18:0/18:3(9Z,12Z,15Z))[iso6]); LMGL03010190 (TG(17:1(9Z)/18:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010191 (TG(17:2(9Z,12Z)/18:0/18:2(9Z,12Z))[iso6]); LMGL03010229 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/19:0)[iso3]); LMGL03010189 (TG(17:0/18:2(9Z,12Z)/18:2(9Z,12Z))[iso3]); LMGL03010187 (TG(17:2(9Z,12Z)/18:1(9Z)/18:1(9Z))[iso3]); LMGL03010258 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/19:0)[iso6])": ["C56H100O6", "Glycerolipids [GL] with formula: C56H100O6"],
        "LMGL03010200 (TG(17:1(9Z)/17:2(9Z,12Z)/19:0)[iso6]); LMGL03010176 (TG(16:1(9Z)/17:2(9Z,12Z)/20:0)[iso6]); LMGL03010178 (TG(16:0/17:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010179 (TG(16:1(9Z)/17:1(9Z)/20:1(11Z))[iso6]); LMGL03010226 (TG(16:1(9Z)/18:2(9Z,12Z)/19:0)[iso6]); LMGL03010225 (TG(16:0/18:3(9Z,12Z,15Z)/19:0)[iso6]); LMGL03010161 (TG(17:1(9Z)/18:1(9Z)/18:1(9Z))[iso3]); LMGL03010162 (TG(17:2(9Z,12Z)/18:0/18:1(9Z))[iso6]); LMGL03010165 (TG(17:1(9Z)/18:0/18:2(9Z,12Z))[iso6]); LMGL03010164 (TG(17:0/18:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010169 (TG(17:0/18:0/18:3(9Z,12Z,15Z))[iso6]); LMGL03010183 (TG(16:0/17:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010182 (TG(16:1(9Z)/17:0/20:2(11Z,14Z))[iso6]); LMGL03010181 (TG(16:0/17:1(9Z)/20:2(11Z,14Z))[iso6])": ["C56H102O6", "Glycerolipids [GL] with formula: C56H102O6"],
        "LMGL03010152 (TG(16:0/17:2(9Z,12Z)/20:0)[iso6]); LMGL03010153 (TG(16:1(9Z)/17:1(9Z)/20:0)[iso6]); LMGL03010155 (TG(16:0/17:1(9Z)/20:1(11Z))[iso6]); LMGL03010156 (TG(16:1(9Z)/17:0/20:1(11Z))[iso6]); LMGL03010157 (TG(16:0/17:0/20:2(11Z,14Z))[iso6]); LMGL03010143 (TG(17:0/18:0/18:2(9Z,12Z))[iso6]); LMGL03010174 (TG(17:1(9Z)/17:1(9Z)/19:0)[iso3]); LMGL03010173 (TG(17:0/17:2(9Z,12Z)/19:0)[iso6]); LMGL03010198 (TG(16:1(9Z)/18:1(9Z)/19:0)[iso6]); LMGL03010197 (TG(16:0/18:2(9Z,12Z)/19:0)[iso6]); LMGL03010284 (TG(16:1(9Z)/16:1(9Z)/21:0)[iso3]); LMGL03010137 (TG(17:2(9Z,12Z)/18:0/18:0)[iso3]); LMGL03010138 (TG(17:0/18:1(9Z)/18:1(9Z))[iso3]); LMGL03010139 (TG(17:1(9Z)/18:0/18:1(9Z))[iso6])": ["C56H104O6", "Glycerolipids [GL] with formula: C56H104O6"],
        "LMGL03010151 (TG(17:0/17:1(9Z)/19:0)[iso6]); LMGL03010172 (TG(16:1(9Z)/18:0/19:0)[iso6]); LMGL03010171 (TG(16:0/18:1(9Z)/19:0)[iso6]); LMGL03010248 (TG(16:0/16:1(9Z)/21:0)[iso6]); LMGL03010116 (TG(17:1(9Z)/18:0/18:0)[iso3]); LMGL03010119 (TG(17:0/18:0/18:1(9Z))[iso6]); LMGL03010132 (TG(16:1(9Z)/17:0/20:0)[iso6]); LMGL03010133 (TG(16:0/17:0/20:1(11Z))[iso6]); LMGL03010131 (TG(16:0/17:1(9Z)/20:0)[iso6])": ["C56H106O6", "Glycerolipids [GL] with formula: C56H106O6"],
        "LMGL03010149 (TG(16:0/18:0/19:0)[iso6]); LMGL03010216 (TG(16:0/16:0/21:0)[iso3]); LMGL03010098 (TG(17:0/18:0/18:0)[iso3]); LMGL03010112 (TG(16:0/17:0/20:0)[iso6]); LMGL03010130 (TG(17:0/17:0/19:0)[iso3])": ["C56H108O6", "Glycerolipids [GL] with formula: C56H108O6"],
        "LMGL03010360 (TG(16:1(9Z)/17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010328 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[iso3])": ["C56H92O6", "Glycerolipids [GL] with formula: C56H92O6"],
        "LMGL03010289 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010290 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010318 (TG(16:0/17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010319 (TG(16:1(9Z)/17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010316 (TG(16:1(9Z)/17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6])": ["C56H94O6", "Glycerolipids [GL] with formula: C56H94O6"],
        "LMGL03010253 (TG(17:0/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010251 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/18:2(9Z,12Z))[iso3]); LMGL03010255 (TG(17:2(9Z,12Z)/18:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010254 (TG(17:1(9Z)/18:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010279 (TG(16:1(9Z)/17:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010278 (TG(16:0/17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010276 (TG(16:1(9Z)/17:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010281 (TG(16:0/17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010282 (TG(16:1(9Z)/17:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C56H96O6", "Glycerolipids [GL] with formula: C56H96O6"],
        "LMGL03010219 (TG(17:2(9Z,12Z)/18:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010218 (TG(17:1(9Z)/18:2(9Z,12Z)/18:2(9Z,12Z))[iso3]); LMGL03010222 (TG(17:0/18:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010223 (TG(17:1(9Z)/18:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010224 (TG(17:2(9Z,12Z)/18:0/18:3(9Z,12Z,15Z))[iso6]); LMGL03010239 (TG(16:1(9Z)/17:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010241 (TG(16:0/17:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010242 (TG(16:1(9Z)/17:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010244 (TG(16:0/17:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010245 (TG(16:1(9Z)/17:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010246 (TG(16:0/17:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C56H98O6", "Glycerolipids [GL] with formula: C56H98O6"],
        "LMGL03010306 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/20:1(11Z))[iso3]); LMGL03010375 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/19:0)[iso6]); LMGL03010359 (TG(16:0/18:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010356 (TG(16:1(9Z)/18:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010355 (TG(16:0/18:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010352 (TG(16:1(9Z)/18:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010351 (TG(16:0/18:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010347 (TG(16:1(9Z)/18:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010346 (TG(16:0/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso6]); LMGL03010416 (TG(16:1(9Z)/16:1(9Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03010469 (TG(16:0/16:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010470 (TG(16:0/16:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03010330 (TG(18:1(9Z)/18:1(9Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010329 (TG(18:0/18:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010327 (TG(18:1(9Z)/18:2(9Z,12Z)/18:2(9Z,12Z))[iso3]); LMGL03010320 (TG(17:0/17:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03010313 (TG(17:0/17:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010310 (TG(17:1(9Z)/17:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010317 (TG(17:0/17:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010314 (TG(17:1(9Z)/17:1(9Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010342 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/20:1(11Z))[iso6])": ["C57H100O6", "Glycerolipids [GL] with formula: C57H100O6"],
        "LMGL03010307 (TG(16:0/18:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010303 (TG(16:1(9Z)/18:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010302 (TG(16:0/18:3(9Z,12Z,15Z)/20:1(11Z))[iso6]); LMGL03010308 (TG(16:1(9Z)/18:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010369 (TG(16:0/16:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010418 (TG(16:0/16:0/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03010468 (TG(16:1(9Z)/16:1(9Z)/22:2(13Z,16Z))[iso3]); LMGL03010266 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/20:0)[iso3]); LMGL03010270 (TG(17:1(9Z)/17:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010273 (TG(17:0/17:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010274 (TG(17:1(9Z)/17:1(9Z)/20:2(11Z,14Z))[iso3]); LMGL03010277 (TG(17:0/17:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010287 (TG(18:0/18:2(9Z,12Z)/18:2(9Z,12Z))[iso3]); LMGL03010280 (TG(17:0/17:0/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010288 (TG(18:1(9Z)/18:1(9Z)/18:2(9Z,12Z))[iso3]); LMGL03010291 (TG(18:0/18:1(9Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010298 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/20:0)[iso6]); LMGL03010332 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/19:0)[iso6]); LMGL03010333 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/19:0)[iso6]); LMGL03010312 (TG(16:1(9Z)/18:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010311 (TG(16:0/18:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010315 (TG(16:0/18:0/20:4(5Z,8Z,11Z,14Z))[iso6])": ["C57H102O6", "Glycerolipids [GL] with formula: C57H102O6"],
        "LMGL03010368 (TG(16:1(9Z)/16:1(9Z)/22:1(13Z))[iso3]); LMGL03010237 (TG(17:1(9Z)/17:1(9Z)/20:1(11Z))[iso3]); LMGL03010236 (TG(17:0/17:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010233 (TG(17:1(9Z)/17:2(9Z,12Z)/20:0)[iso6]); LMGL03010408 (TG(16:1(9Z)/17:2(9Z,12Z)/21:0)[iso6]); LMGL03010240 (TG(17:0/17:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010243 (TG(17:0/17:0/20:3(8Z,11Z,14Z))[iso3]); LMGL03010417 (TG(16:0/16:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010252 (TG(18:0/18:1(9Z)/18:2(9Z,12Z))[iso6]); LMGL03010250 (TG(18:1(9Z)/18:1(9Z)/18:1(9Z))); LMGL03010256 (TG(18:0/18:0/18:3(9Z,12Z,15Z))[iso3]); LMGL03012613 (TG(18:1(6Z)/18:1(9Z)/18:1(6Z))); LMGL03010268 (TG(16:1(9Z)/18:1(9Z)/20:1(11Z))[iso6]); LMGL03010267 (TG(16:0/18:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010262 (TG(16:0/18:3(9Z,12Z,15Z)/20:0)[iso6]); LMGL03010263 (TG(16:1(9Z)/18:2(9Z,12Z)/20:0)[iso6]); LMGL03010271 (TG(16:0/18:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010272 (TG(16:1(9Z)/18:0/20:2(11Z,14Z))[iso6]); LMGL03010275 (TG(16:0/18:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010295 (TG(17:2(9Z,12Z)/18:1(9Z)/19:0)[iso6]); LMGL03010294 (TG(17:1(9Z)/18:2(9Z,12Z)/19:0)[iso6]); LMGL03010293 (TG(17:0/18:3(9Z,12Z,15Z)/19:0)[iso6]); LMGL03012612 (TG(18:1(9Z)/18:1(6Z)/18:1(9Z))); LMGL03010326 (TG(16:0/16:0/22:3(10Z,13Z,16Z))[iso3])": ["C57H104O6", "Glycerolipids [GL] with formula: C57H104O6"],
        "LMGL03010370 (TG(16:0/16:0/22:2(13Z,16Z))[iso3]); LMGL03010204 (TG(17:1(9Z)/17:1(9Z)/20:0)[iso3]); LMGL03010207 (TG(17:0/17:1(9Z)/20:1(11Z))[iso6]); LMGL03010203 (TG(17:0/17:2(9Z,12Z)/20:0)[iso6]); LMGL03010363 (TG(16:1(9Z)/17:1(9Z)/21:0)[iso6]); LMGL03010362 (TG(16:0/17:2(9Z,12Z)/21:0)[iso6]); LMGL03010217 (TG(18:0/18:1(9Z)/18:1(9Z))[iso3]); LMGL03010210 (TG(17:0/17:0/20:2(11Z,14Z))[iso3]); LMGL03010220 (TG(18:0/18:0/18:2(9Z,12Z))[iso3]); LMGL03010235 (TG(16:1(9Z)/18:0/20:1(11Z))[iso6]); LMGL03010234 (TG(16:0/18:1(9Z)/20:1(11Z))[iso6]); LMGL03010231 (TG(16:1(9Z)/18:1(9Z)/20:0)[iso6]); LMGL03010230 (TG(16:0/18:2(9Z,12Z)/20:0)[iso6]); LMGL03010238 (TG(16:0/18:0/20:2(11Z,14Z))[iso6]); LMGL03010259 (TG(17:0/18:2(9Z,12Z)/19:0)[iso6]); LMGL03010260 (TG(17:1(9Z)/18:1(9Z)/19:0)[iso6]); LMGL03010261 (TG(17:2(9Z,12Z)/18:0/19:0)[iso6]); LMGL03010325 (TG(16:0/16:1(9Z)/22:1(13Z))[iso6]); LMGL03010324 (TG(16:1(9Z)/16:1(9Z)/22:0)[iso3])": ["C57H106O6", "Glycerolipids [GL] with formula: C57H106O6"],
        "LMGL03010205 (TG(16:0/18:0/20:1(11Z))[iso6]); LMGL03010201 (TG(16:0/18:1(9Z)/20:0)[iso6]); LMGL03010202 (TG(16:1(9Z)/18:0/20:0)[iso6]); LMGL03010177 (TG(17:0/17:1(9Z)/20:0)[iso6]); LMGL03010228 (TG(17:1(9Z)/18:0/19:0)[iso6]); LMGL03010227 (TG(17:0/18:1(9Z)/19:0)[iso6]); LMGL03010188 (TG(18:0/18:0/18:1(9Z))[iso3]); LMGL03010180 (TG(17:0/17:0/20:1(11Z))[iso3]); LMGL03010285 (TG(16:0/16:1(9Z)/22:0)[iso6]); LMGL03010286 (TG(16:0/16:0/22:1(13Z))[iso3]); LMGL03010292 (TG(16:1(9Z)/19:0/19:0)[iso3]); LMGL03010322 (TG(16:1(9Z)/17:0/21:0)[iso6]); LMGL03010321 (TG(16:0/17:1(9Z)/21:0)[iso6])": ["C57H108O6", "Glycerolipids [GL] with formula: C57H108O6"],
        "LMGL03010154 (TG(17:0/17:0/20:0)[iso3]); LMGL03010175 (TG(16:0/18:0/20:0)[iso6]); LMGL03010199 (TG(17:0/18:0/19:0)[iso6]); LMGL03010249 (TG(16:0/16:0/22:0)[iso3]); LMGL03010257 (TG(16:0/19:0/19:0)[iso3]); LMGL03010283 (TG(16:0/17:0/21:0)[iso6]); LMGL03010002 (TG(18:0/18:0/18:0))": ["C57H110O6", "Glycerolipids [GL] with formula: C57H110O6"],
        "LMGL03050001": ["C57H88O8", "Glycerolipids [GL] with formula: C57H88O8"],
        "LMGL03010506 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03010527 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))); LMGL03010559 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C57H92O6", "Glycerolipids [GL] with formula: C57H92O6"],
        "LMGL03010498 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010503 (TG(16:1(9Z)/18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010502 (TG(16:0/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010649 (TG(16:1(9Z)/16:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03010471 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010450 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010454 (TG(17:1(9Z)/17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C57H94O6", "Glycerolipids [GL] with formula: C57H94O6"],
        "LMGL03010446 (TG(16:0/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010447 (TG(16:1(9Z)/18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010402 (TG(17:1(9Z)/17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010406 (TG(17:1(9Z)/17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03010405 (TG(17:0/17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010419 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010398 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010420 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010442 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010451 (TG(16:0/18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010452 (TG(16:1(9Z)/18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010586 (TG(16:0/16:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010585 (TG(16:1(9Z)/16:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3])": ["C57H96O6", "Glycerolipids [GL] with formula: C57H96O6"],
        "LMGL03010371 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/18:2(9Z,12Z))); LMGL03010372 (TG(18:0/18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[iso3]); LMGL03010373 (TG(18:1(9Z)/18:2(9Z,12Z)/18:3(9Z,12Z,15Z))[iso6]); LMGL03010361 (TG(17:0/17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010394 (TG(16:0/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010395 (TG(16:1(9Z)/18:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010358 (TG(17:1(9Z)/17:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010357 (TG(17:0/17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010354 (TG(17:1(9Z)/17:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010403 (TG(16:0/18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010400 (TG(16:1(9Z)/18:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010404 (TG(16:1(9Z)/18:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010525 (TG(16:0/16:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010524 (TG(16:1(9Z)/16:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03010526 (TG(16:0/16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03010390 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso6]); LMGL03010399 (TG(16:0/18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010350 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/20:2(11Z,14Z))[iso3])": ["C57H98O6", "Glycerolipids [GL] with formula: C57H98O6"],
        "LMGL03010499 (TG(17:0/18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010495 (TG(17:2(9Z,12Z)/18:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010494 (TG(17:1(9Z)/18:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010493 (TG(17:0/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010577 (TG(16:1(9Z)/17:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010501 (TG(17:2(9Z,12Z)/18:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010500 (TG(17:1(9Z)/18:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010505 (TG(17:1(9Z)/18:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010504 (TG(17:0/18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010644 (TG(16:1(9Z)/17:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010646 (TG(16:0/17:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010647 (TG(16:1(9Z)/17:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010643 (TG(16:0/17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010648 (TG(16:0/17:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010482 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:1(11Z))[iso6]); LMGL03010617 (TG(16:1(9Z)/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010588 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/19:0)[iso3]); LMGL03010488 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso6]); LMGL03010489 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/20:2(11Z,14Z))[iso6])": ["C58H100O6", "Glycerolipids [GL] with formula: C58H100O6"],
        "LMGL03010445 (TG(17:2(9Z,12Z)/18:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010443 (TG(17:0/18:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010518 (TG(16:0/17:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010519 (TG(16:1(9Z)/17:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010439 (TG(17:2(9Z,12Z)/18:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010438 (TG(17:1(9Z)/18:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010529 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/19:0)[iso6]); LMGL03010641 (TG(16:1(9Z)/17:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03010426 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:0)[iso6]); LMGL03010448 (TG(17:0/18:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010449 (TG(17:1(9Z)/18:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010444 (TG(17:1(9Z)/18:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010453 (TG(17:0/18:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010583 (TG(16:1(9Z)/17:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010582 (TG(16:0/17:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010584 (TG(16:0/17:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010558 (TG(16:0/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010553 (TG(16:1(9Z)/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010437 (TG(17:0/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso6]); LMGL03010433 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010432 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/20:1(11Z))[iso6])": ["C58H102O6", "Glycerolipids [GL] with formula: C58H102O6"],
        "LMGL03010497 (TG(16:0/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010492 (TG(16:1(9Z)/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010579 (TG(16:0/17:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03010567 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/21:0)[iso3]); LMGL03010393 (TG(17:2(9Z,12Z)/18:0/20:2(11Z,14Z))[iso6]); LMGL03010391 (TG(17:0/18:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010465 (TG(16:0/17:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010516 (TG(16:1(9Z)/17:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010401 (TG(17:0/18:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010523 (TG(16:0/17:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010392 (TG(17:1(9Z)/18:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010396 (TG(17:0/18:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010397 (TG(17:1(9Z)/18:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010466 (TG(16:1(9Z)/17:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010385 (TG(17:0/18:3(9Z,12Z,15Z)/20:1(11Z))[iso6]); LMGL03010387 (TG(17:2(9Z,12Z)/18:1(9Z)/20:1(11Z))[iso6]); LMGL03010386 (TG(17:1(9Z)/18:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010381 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/20:0)[iso6]); LMGL03010380 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/20:0)[iso6]); LMGL03010473 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/19:0)[iso6]); LMGL03010474 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/19:0)[iso3]); LMGL03010580 (TG(16:1(9Z)/17:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010623 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/21:0)[iso6])": ["C58H104O6", "Glycerolipids [GL] with formula: C58H104O6"],
        "LMGL03010441 (TG(16:0/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010564 (TG(16:1(9Z)/18:2(9Z,12Z)/21:0)[iso6]); LMGL03010563 (TG(16:0/18:3(9Z,12Z,15Z)/21:0)[iso6]); LMGL03010460 (TG(16:1(9Z)/17:2(9Z,12Z)/22:0)[iso6]); LMGL03010462 (TG(16:0/17:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010510 (TG(17:1(9Z)/17:2(9Z,12Z)/21:0)[iso6]); LMGL03010353 (TG(17:0/18:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010422 (TG(18:0/18:3(9Z,12Z,15Z)/19:0)[iso6]); LMGL03010349 (TG(17:1(9Z)/18:0/20:2(11Z,14Z))[iso6]); LMGL03010348 (TG(17:0/18:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010343 (TG(17:0/18:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010345 (TG(17:2(9Z,12Z)/18:0/20:1(11Z))[iso6]); LMGL03010344 (TG(17:1(9Z)/18:1(9Z)/20:1(11Z))[iso6]); LMGL03010521 (TG(16:0/17:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010522 (TG(16:1(9Z)/17:0/22:2(13Z,16Z))[iso6]); LMGL03010415 (TG(16:0/17:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010463 (TG(16:1(9Z)/17:1(9Z)/22:1(13Z))[iso6]); LMGL03010423 (TG(18:1(9Z)/18:2(9Z,12Z)/19:0)[iso6]); LMGL03010338 (TG(17:1(9Z)/18:2(9Z,12Z)/20:0)[iso6]); LMGL03010339 (TG(17:2(9Z,12Z)/18:1(9Z)/20:0)[iso6]); LMGL03010337 (TG(17:0/18:3(9Z,12Z,15Z)/20:0)[iso6]); LMGL03010436 (TG(16:1(9Z)/19:0/20:2(11Z,14Z))[iso6])": ["C58H106O6", "Glycerolipids [GL] with formula: C58H106O6"],
        "LMGL03010305 (TG(17:1(9Z)/18:0/20:1(11Z))[iso6]); LMGL03010304 (TG(17:0/18:1(9Z)/20:1(11Z))[iso6]); LMGL03010301 (TG(17:2(9Z,12Z)/18:0/20:0)[iso6]); LMGL03010300 (TG(17:1(9Z)/18:1(9Z)/20:0)[iso6]); LMGL03010309 (TG(17:0/18:0/20:2(11Z,14Z))[iso6]); LMGL03010376 (TG(18:0/18:2(9Z,12Z)/19:0)[iso6]); LMGL03010377 (TG(18:1(9Z)/18:1(9Z)/19:0)[iso3]); LMGL03010507 (TG(16:0/18:2(9Z,12Z)/21:0)[iso6]); LMGL03010508 (TG(16:1(9Z)/18:1(9Z)/21:0)[iso6]); LMGL03010414 (TG(16:1(9Z)/17:0/22:1(13Z))[iso6]); LMGL03010411 (TG(16:1(9Z)/17:1(9Z)/22:0)[iso6]); LMGL03010410 (TG(16:0/17:2(9Z,12Z)/22:0)[iso6]); LMGL03010413 (TG(16:0/17:1(9Z)/22:1(13Z))[iso6]); LMGL03010467 (TG(16:0/17:0/22:2(13Z,16Z))[iso6]); LMGL03010421 (TG(17:2(9Z,12Z)/19:0/19:0)[iso3]); LMGL03010389 (TG(16:0/19:0/20:2(11Z,14Z))[iso6]); LMGL03010384 (TG(16:1(9Z)/19:0/20:1(11Z))[iso6]); LMGL03010458 (TG(17:1(9Z)/17:1(9Z)/21:0)[iso3]); LMGL03010457 (TG(17:0/17:2(9Z,12Z)/21:0)[iso6]); LMGL03010299 (TG(17:0/18:2(9Z,12Z)/20:0)[iso6])": ["C58H108O6", "Glycerolipids [GL] with formula: C58H108O6"],
        "LMGL03010374 (TG(17:1(9Z)/19:0/19:0)[iso3]); LMGL03010367 (TG(16:0/17:0/22:1(13Z))[iso6]); LMGL03010366 (TG(16:1(9Z)/17:0/22:0)[iso6]); LMGL03010365 (TG(16:0/17:1(9Z)/22:0)[iso6]); LMGL03010341 (TG(16:0/19:0/20:1(11Z))[iso6]); LMGL03010409 (TG(17:0/17:1(9Z)/21:0)[iso6]); LMGL03010269 (TG(17:0/18:0/20:1(11Z))[iso6]); LMGL03010264 (TG(17:0/18:1(9Z)/20:0)[iso6]); LMGL03010265 (TG(17:1(9Z)/18:0/20:0)[iso6]); LMGL03010455 (TG(16:0/18:1(9Z)/21:0)[iso6]); LMGL03010456 (TG(16:1(9Z)/18:0/21:0)[iso6]); LMGL03010334 (TG(18:0/18:1(9Z)/19:0)[iso6]); LMGL03010336 (TG(16:1(9Z)/19:0/20:0)[iso6])": ["C58H110O6", "Glycerolipids [GL] with formula: C58H110O6"],
        "LMGL03010364 (TG(17:0/17:0/21:0)[iso3]); LMGL03010232 (TG(17:0/18:0/20:0)[iso6]); LMGL03010407 (TG(16:0/18:0/21:0)[iso6]); LMGL03010297 (TG(16:0/19:0/20:0)[iso6]); LMGL03010296 (TG(18:0/18:0/19:0)[iso3]); LMGL03010331 (TG(17:0/19:0/19:0)[iso3]); LMGL03010323 (TG(16:0/17:0/22:0)[iso6])": ["C58H112O6", "Glycerolipids [GL] with formula: C58H112O6"],
        "LMGL03010746 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C58H92O6", "Glycerolipids [GL] with formula: C58H92O6"],
        "LMGL03010681 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010682 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010675 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010854 (TG(16:1(9Z)/17:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C58H94O6", "Glycerolipids [GL] with formula: C58H94O6"],
        "LMGL03010780 (TG(16:1(9Z)/17:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010783 (TG(16:1(9Z)/17:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010782 (TG(16:0/17:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010607 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010619 (TG(17:1(9Z)/18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010618 (TG(17:0/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010613 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010614 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010620 (TG(17:2(9Z,12Z)/18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C58H96O6", "Glycerolipids [GL] with formula: C58H96O6"],
        "LMGL03010549 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010561 (TG(17:1(9Z)/18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010560 (TG(17:0/18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010562 (TG(17:2(9Z,12Z)/18:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010543 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso6]); LMGL03010714 (TG(16:0/17:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010711 (TG(16:0/17:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010709 (TG(16:1(9Z)/17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010554 (TG(17:0/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010555 (TG(17:1(9Z)/18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010556 (TG(17:2(9Z,12Z)/18:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010550 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010715 (TG(16:1(9Z)/17:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010712 (TG(16:1(9Z)/17:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C58H98O6", "Glycerolipids [GL] with formula: C58H98O6"],
        "LMGL03010836 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010916 (TG(16:0/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010813 (TG(17:2(9Z,12Z)/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010770 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03010748 (TG(18:1(9Z)/18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03010747 (TG(18:0/18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010741 (TG(18:1(9Z)/18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010740 (TG(18:0/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010743 (TG(16:1(9Z)/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010742 (TG(16:0/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010733 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010734 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010735 (TG(16:0/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010736 (TG(16:1(9Z)/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010722 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/20:1(11Z))[iso3]); LMGL03010728 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010727 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso6]); LMGL03010917 (TG(16:1(9Z)/18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010848 (TG(17:1(9Z)/17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010855 (TG(17:0/17:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010851 (TG(17:0/17:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010852 (TG(17:1(9Z)/17:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03010925 (TG(16:0/18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010926 (TG(16:1(9Z)/18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010921 (TG(16:0/18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010922 (TG(16:1(9Z)/18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C59H100O6", "Glycerolipids [GL] with formula: C59H100O6"],
        "LMGL03010781 (TG(17:0/17:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010784 (TG(17:0/17:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03010777 (TG(17:0/17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010778 (TG(17:1(9Z)/17:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03010683 (TG(18:0/18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010767 (TG(16:1(9Z)/18:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010766 (TG(16:0/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010703 (TG(17:1(9Z)/17:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010745 (TG(17:1(9Z)/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010739 (TG(17:2(9Z,12Z)/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010657 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:1(11Z))[iso6]); LMGL03010653 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/20:0)[iso3]); LMGL03010662 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso6]); LMGL03010663 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/20:2(11Z,14Z))[iso3]); LMGL03010664 (TG(16:0/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010665 (TG(16:1(9Z)/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010669 (TG(18:0/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010912 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso6]); LMGL03010679 (TG(16:1(9Z)/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010678 (TG(16:0/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010677 (TG(18:1(9Z)/18:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010676 (TG(18:0/18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010671 (TG(16:0/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010670 (TG(18:1(9Z)/18:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010672 (TG(16:1(9Z)/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010846 (TG(16:1(9Z)/18:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010844 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/22:2(13Z,16Z))[iso3]); LMGL03010845 (TG(16:0/18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010849 (TG(16:0/18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010850 (TG(16:1(9Z)/18:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010853 (TG(16:0/18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C59H102O6", "Glycerolipids [GL] with formula: C59H102O6"],
        "LMGL03010639 (TG(17:1(9Z)/17:1(9Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03010638 (TG(17:0/17:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010774 (TG(17:1(9Z)/17:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03010775 (TG(16:0/18:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010776 (TG(16:1(9Z)/18:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010779 (TG(16:0/18:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010680 (TG(17:0/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010762 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/22:1(13Z))[iso6]); LMGL03010699 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/22:1(13Z))[iso3]); LMGL03010701 (TG(16:1(9Z)/18:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010700 (TG(16:0/18:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010713 (TG(17:0/17:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03010668 (TG(17:2(9Z,12Z)/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010674 (TG(17:1(9Z)/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010840 (TG(16:0/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso6]); LMGL03010841 (TG(16:1(9Z)/18:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03010608 (TG(18:0/18:2(9Z,12Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010609 (TG(18:1(9Z)/18:1(9Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010601 (TG(18:0/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso6]); LMGL03010602 (TG(18:1(9Z)/18:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010603 (TG(16:0/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010604 (TG(16:1(9Z)/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010591 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:0)[iso6]); LMGL03010595 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/20:1(11Z))[iso6]); LMGL03010596 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/20:1(11Z))[iso3]); LMGL03010597 (TG(16:1(9Z)/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03010611 (TG(16:1(9Z)/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010610 (TG(16:0/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010616 (TG(16:0/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010615 (TG(18:0/18:1(9Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010621 (TG(18:0/18:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03010820 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/21:0)[iso6]); LMGL03010710 (TG(17:0/17:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6])": ["C59H104O6", "Glycerolipids [GL] with formula: C59H104O6"],
        "LMGL03010631 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/22:0)[iso3]); LMGL03010635 (TG(17:1(9Z)/17:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010637 (TG(16:1(9Z)/18:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010636 (TG(16:0/18:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010578 (TG(17:0/17:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010771 (TG(16:0/18:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03010772 (TG(16:1(9Z)/18:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010547 (TG(16:1(9Z)/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010545 (TG(18:1(9Z)/18:1(9Z)/20:2(11Z,14Z))[iso3]); LMGL03010540 (TG(16:1(9Z)/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03010691 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/22:0)[iso6]); LMGL03010696 (TG(16:1(9Z)/18:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010695 (TG(16:0/18:3(9Z,12Z,15Z)/22:1(13Z))[iso6]); LMGL03010707 (TG(17:1(9Z)/17:1(9Z)/22:2(13Z,16Z))[iso3]); LMGL03010752 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/21:0)[iso6]); LMGL03010753 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/21:0)[iso6]); LMGL03010538 (TG(18:1(9Z)/18:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010539 (TG(16:0/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03010537 (TG(18:0/18:3(9Z,12Z,15Z)/20:1(11Z))[iso6]); LMGL03010532 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/20:0)[iso6]); LMGL03010533 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/20:0)[iso3]); LMGL03010645 (TG(17:0/17:0/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03010546 (TG(16:0/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010544 (TG(18:0/18:2(9Z,12Z)/20:2(11Z,14Z))[iso6]); LMGL03010557 (TG(18:0/18:0/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010706 (TG(17:0/17:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03010708 (TG(16:0/18:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010600 (TG(17:2(9Z,12Z)/19:0/20:2(11Z,14Z))[iso6]); LMGL03010606 (TG(17:1(9Z)/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010612 (TG(17:0/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010551 (TG(18:0/18:1(9Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010552 (TG(16:0/20:0/20:4(5Z,8Z,11Z,14Z))[iso6])": ["C59H106O6", "Glycerolipids [GL] with formula: C59H106O6"],
        "LMGL03010633 (TG(16:1(9Z)/18:1(9Z)/22:1(13Z))[iso6]); LMGL03010632 (TG(16:0/18:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010548 (TG(17:0/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010496 (TG(18:0/18:0/20:3(8Z,11Z,14Z))[iso3]); LMGL03010491 (TG(16:0/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010490 (TG(18:0/18:1(9Z)/20:2(11Z,14Z))[iso6]); LMGL03010571 (TG(17:1(9Z)/17:2(9Z,12Z)/22:0)[iso6]); LMGL03010576 (TG(16:0/18:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010574 (TG(17:0/17:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010575 (TG(17:1(9Z)/17:1(9Z)/22:1(13Z))[iso3]); LMGL03010686 (TG(17:0/18:3(9Z,12Z,15Z)/21:0)[iso6]); LMGL03010687 (TG(17:1(9Z)/18:2(9Z,12Z)/21:0)[iso6]); LMGL03010688 (TG(17:2(9Z,12Z)/18:1(9Z)/21:0)[iso6]); LMGL03010542 (TG(17:1(9Z)/19:0/20:2(11Z,14Z))[iso6]); LMGL03010536 (TG(17:2(9Z,12Z)/19:0/20:1(11Z))[iso6]); LMGL03010705 (TG(16:1(9Z)/18:0/22:2(13Z,16Z))[iso6]); LMGL03010520 (TG(17:0/17:0/22:3(10Z,13Z,16Z))[iso3]); LMGL03010642 (TG(17:0/17:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010650 (TG(18:3(9Z,12Z,15Z)/19:0/19:0)[iso3]); LMGL03010477 (TG(18:0/18:3(9Z,12Z,15Z)/20:0)[iso6]); LMGL03010479 (TG(16:1(9Z)/20:1(11Z)/20:1(11Z))[iso3]); LMGL03010478 (TG(18:1(9Z)/18:2(9Z,12Z)/20:0)[iso6]); LMGL03010704 (TG(16:0/18:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010486 (TG(16:1(9Z)/20:0/20:2(11Z,14Z))[iso6]); LMGL03010484 (TG(18:1(9Z)/18:1(9Z)/20:1(11Z))[iso3]); LMGL03010627 (TG(16:0/18:3(9Z,12Z,15Z)/22:0)[iso6]); LMGL03010628 (TG(16:1(9Z)/18:2(9Z,12Z)/22:0)[iso6]); LMGL03010483 (TG(18:0/18:2(9Z,12Z)/20:1(11Z))[iso6]); LMGL03010485 (TG(16:0/20:1(11Z)/20:2(11Z,14Z))[iso6])": ["C59H108O6", "Glycerolipids [GL] with formula: C59H108O6"],
        "LMGL03010440 (TG(18:0/18:0/20:2(11Z,14Z))[iso3]); LMGL03010572 (TG(16:0/18:1(9Z)/22:1(13Z))[iso6]); LMGL03010573 (TG(16:1(9Z)/18:0/22:1(13Z))[iso6]); LMGL03010569 (TG(16:1(9Z)/18:1(9Z)/22:0)[iso6]); LMGL03010568 (TG(16:0/18:2(9Z,12Z)/22:0)[iso6]); LMGL03010513 (TG(17:0/17:2(9Z,12Z)/22:0)[iso6]); LMGL03010514 (TG(17:1(9Z)/17:1(9Z)/22:0)[iso3]); LMGL03010517 (TG(17:0/17:1(9Z)/22:1(13Z))[iso6]); LMGL03010428 (TG(18:1(9Z)/18:1(9Z)/20:0)[iso3]); LMGL03010429 (TG(16:0/20:1(11Z)/20:1(11Z))[iso3]); LMGL03010434 (TG(18:0/18:1(9Z)/20:1(11Z))[iso6]); LMGL03010640 (TG(16:0/18:0/22:2(13Z,16Z))[iso6]); LMGL03010427 (TG(18:0/18:2(9Z,12Z)/20:0)[iso6]); LMGL03010476 (TG(17:2(9Z,12Z)/19:0/20:0)[iso6]); LMGL03010481 (TG(17:1(9Z)/19:0/20:1(11Z))[iso6]); LMGL03010487 (TG(17:0/19:0/20:2(11Z,14Z))[iso6]); LMGL03010581 (TG(17:0/17:0/22:2(13Z,16Z))[iso3]); LMGL03010587 (TG(18:2(9Z,12Z)/19:0/19:0)[iso3]); LMGL03010626 (TG(17:2(9Z,12Z)/18:0/21:0)[iso6]); LMGL03010624 (TG(17:0/18:2(9Z,12Z)/21:0)[iso6]); LMGL03010625 (TG(17:1(9Z)/18:1(9Z)/21:0)[iso6]); LMGL03010435 (TG(16:0/20:0/20:2(11Z,14Z))[iso6]); LMGL03010430 (TG(16:1(9Z)/20:0/20:1(11Z))[iso6])": ["C59H110O6", "Glycerolipids [GL] with formula: C59H110O6"],
        "LMGL03010378 (TG(16:1(9Z)/20:0/20:0)[iso3]); LMGL03010565 (TG(17:0/18:1(9Z)/21:0)[iso6]); LMGL03010566 (TG(17:1(9Z)/18:0/21:0)[iso6]); LMGL03010464 (TG(17:0/17:0/22:1(13Z))[iso3]); LMGL03010512 (TG(16:1(9Z)/18:0/22:0)[iso6]); LMGL03010515 (TG(16:0/18:0/22:1(13Z))[iso6]); LMGL03010685 (TG(16:1(9Z)/19:0/21:0)[iso6]); LMGL03010528 (TG(18:1(9Z)/19:0/19:0)[iso3]); LMGL03010511 (TG(16:0/18:1(9Z)/22:0)[iso6]); LMGL03010461 (TG(17:0/17:1(9Z)/22:0)[iso6]); LMGL03010425 (TG(17:1(9Z)/19:0/20:0)[iso6]); LMGL03010388 (TG(18:0/18:0/20:1(11Z))[iso3]); LMGL03010383 (TG(16:0/20:0/20:1(11Z))[iso6]); LMGL03010382 (TG(18:0/18:1(9Z)/20:0)[iso6]); LMGL03010431 (TG(17:0/19:0/20:1(11Z))[iso6])": ["C59H112O6", "Glycerolipids [GL] with formula: C59H112O6"],
        "LMGL03010379 (TG(17:0/19:0/20:0)[iso6]); LMGL03010509 (TG(17:0/18:0/21:0)[iso6]); LMGL03010340 (TG(18:0/18:0/20:0)[iso3]); LMGL03010412 (TG(17:0/17:0/22:0)[iso3]); LMGL03010472 (TG(18:0/19:0/19:0)[iso3]); LMGL03010459 (TG(16:0/18:0/22:0)[iso6]); LMGL03010335 (TG(16:0/20:0/20:0)[iso3]); LMGL03010622 (TG(16:0/19:0/21:0)[iso6])": ["C59H114O6", "Glycerolipids [GL] with formula: C59H114O6"],
        "LMGL03011026 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011019 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3])": ["C59H92O6", "Glycerolipids [GL] with formula: C59H92O6"],
        "LMGL03010947 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03010946 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010948 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011152 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011078 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03010954 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C59H94O6", "Glycerolipids [GL] with formula: C59H94O6"],
        "LMGL03010884 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03010883 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010998 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011002 (TG(17:1(9Z)/17:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010870 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010869 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010877 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010876 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010878 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011074 (TG(16:0/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011075 (TG(16:1(9Z)/18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011070 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C59H96O6", "Glycerolipids [GL] with formula: C59H96O6"],
        "LMGL03010807 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010802 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010800 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010801 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010808 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03010809 (TG(16:0/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010794 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/20:2(11Z,14Z))[iso3]); LMGL03010810 (TG(16:1(9Z)/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010815 (TG(18:1(9Z)/18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010814 (TG(18:0/18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010994 (TG(16:0/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010995 (TG(16:1(9Z)/18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010990 (TG(16:1(9Z)/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010999 (TG(16:0/18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011000 (TG(16:1(9Z)/18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010924 (TG(17:1(9Z)/17:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010927 (TG(17:0/17:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010920 (TG(17:2(9Z,12Z)/17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03010928 (TG(17:1(9Z)/17:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C59H98O6", "Glycerolipids [GL] with formula: C59H98O6"],
        "LMGL03011054 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010942 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010941 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010940 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011147 (TG(17:0/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011142 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011143 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011148 (TG(17:1(9Z)/18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011149 (TG(17:2(9Z,12Z)/18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010949 (TG(17:0/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011154 (TG(17:1(9Z)/18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011153 (TG(17:0/18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011155 (TG(17:2(9Z,12Z)/18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011099 (TG(18:3(9Z,12Z,15Z)/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010951 (TG(17:2(9Z,12Z)/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010935 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010950 (TG(17:1(9Z)/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C60H100O6", "Glycerolipids [GL] with formula: C60H100O6"],
        "LMGL03011229 (TG(16:1(9Z)/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010880 (TG(17:1(9Z)/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010881 (TG(17:2(9Z,12Z)/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011025 (TG(18:2(9Z,12Z)/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010981 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010980 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010872 (TG(17:1(9Z)/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010864 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010873 (TG(17:2(9Z,12Z)/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010871 (TG(17:0/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010879 (TG(17:0/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011018 (TG(18:3(9Z,12Z,15Z)/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011076 (TG(17:0/18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011077 (TG(17:1(9Z)/18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011071 (TG(17:0/18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011072 (TG(17:1(9Z)/18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011073 (TG(17:2(9Z,12Z)/18:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011136 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso6]); LMGL03011067 (TG(17:2(9Z,12Z)/18:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011066 (TG(17:1(9Z)/18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011065 (TG(17:0/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010865 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6])": ["C60H102O6", "Glycerolipids [GL] with formula: C60H102O6"],
        "LMGL03010945 (TG(18:2(9Z,12Z)/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010804 (TG(17:1(9Z)/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010805 (TG(17:2(9Z,12Z)/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010803 (TG(17:0/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010796 (TG(17:1(9Z)/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010797 (TG(17:2(9Z,12Z)/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010795 (TG(17:0/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03010790 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03010974 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:1(13Z))[iso6]); LMGL03011146 (TG(16:1(9Z)/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010811 (TG(17:0/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010812 (TG(17:1(9Z)/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011151 (TG(16:0/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010996 (TG(17:0/18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010997 (TG(17:1(9Z)/18:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010991 (TG(17:0/18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010992 (TG(17:1(9Z)/18:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010993 (TG(17:2(9Z,12Z)/18:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011001 (TG(17:0/18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011108 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/21:0)[iso3]); LMGL03011101 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03010907 (TG(17:0/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010909 (TG(17:2(9Z,12Z)/18:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010908 (TG(17:1(9Z)/18:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010939 (TG(18:3(9Z,12Z,15Z)/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03011061 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03011060 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso6]); LMGL03010953 (TG(18:1(9Z)/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C60H104O6", "Glycerolipids [GL] with formula: C60H104O6"],
        "LMGL03010839 (TG(17:2(9Z,12Z)/18:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010838 (TG(17:1(9Z)/18:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010837 (TG(17:0/18:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010731 (TG(17:2(9Z,12Z)/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03011034 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/21:0)[iso6]); LMGL03011028 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011027 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03010882 (TG(18:0/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010987 (TG(17:2(9Z,12Z)/18:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010986 (TG(17:1(9Z)/18:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03010985 (TG(17:0/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso6]); LMGL03010744 (TG(17:0/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03010903 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010902 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/22:1(13Z))[iso6]); LMGL03010738 (TG(17:1(9Z)/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010730 (TG(17:1(9Z)/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010737 (TG(17:0/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010723 (TG(17:1(9Z)/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03010896 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:0)[iso6]); LMGL03010729 (TG(17:0/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010724 (TG(17:2(9Z,12Z)/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03010868 (TG(18:2(9Z,12Z)/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010918 (TG(17:0/18:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010919 (TG(17:1(9Z)/18:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010875 (TG(18:1(9Z)/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010923 (TG(17:0/18:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011064 (TG(16:1(9Z)/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011069 (TG(16:0/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03010863 (TG(18:3(9Z,12Z,15Z)/19:0/20:2(11Z,14Z))[iso6])": ["C60H106O6", "Glycerolipids [GL] with formula: C60H106O6"],
        "LMGL03010833 (TG(17:2(9Z,12Z)/18:1(9Z)/22:1(13Z))[iso6]); LMGL03010832 (TG(17:1(9Z)/18:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010831 (TG(17:0/18:3(9Z,12Z,15Z)/22:1(13Z))[iso6]); LMGL03010806 (TG(18:0/19:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010799 (TG(18:1(9Z)/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010793 (TG(18:2(9Z,12Z)/19:0/20:2(11Z,14Z))[iso6]); LMGL03010789 (TG(18:3(9Z,12Z,15Z)/19:0/20:1(11Z))[iso6]); LMGL03010961 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/21:0)[iso6]); LMGL03010962 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/21:0)[iso3]); LMGL03010769 (TG(17:1(9Z)/18:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010768 (TG(17:0/18:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010989 (TG(16:0/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010906 (TG(16:1(9Z)/19:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010654 (TG(17:2(9Z,12Z)/20:1(11Z)/20:1(11Z))[iso3]); LMGL03010659 (TG(17:1(9Z)/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03010658 (TG(17:0/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03010660 (TG(17:2(9Z,12Z)/20:0/20:2(11Z,14Z))[iso6]); LMGL03010666 (TG(17:0/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010667 (TG(17:1(9Z)/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010914 (TG(17:1(9Z)/18:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010915 (TG(17:2(9Z,12Z)/18:0/22:2(13Z,16Z))[iso6]); LMGL03010913 (TG(17:0/18:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03010673 (TG(17:0/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010847 (TG(17:0/18:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010826 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/22:0)[iso6]); LMGL03010827 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/22:0)[iso6]); LMGL03010955 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03010956 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/21:0)[iso6])": ["C60H108O6", "Glycerolipids [GL] with formula: C60H108O6"],
        "LMGL03010835 (TG(16:0/19:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010886 (TG(16:1(9Z)/20:2(11Z,14Z)/21:0)[iso6]); LMGL03010885 (TG(16:0/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03010765 (TG(17:2(9Z,12Z)/18:0/22:1(13Z))[iso6]); LMGL03010764 (TG(17:1(9Z)/18:1(9Z)/22:1(13Z))[iso6]); LMGL03010763 (TG(17:0/18:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010984 (TG(16:1(9Z)/19:0/22:2(13Z,16Z))[iso6]); LMGL03010757 (TG(17:0/18:3(9Z,12Z,15Z)/22:0)[iso6]); LMGL03010758 (TG(17:1(9Z)/18:2(9Z,12Z)/22:0)[iso6]); LMGL03010759 (TG(17:2(9Z,12Z)/18:1(9Z)/22:0)[iso6]); LMGL03010702 (TG(17:0/18:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010732 (TG(18:0/19:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010726 (TG(18:1(9Z)/19:0/20:2(11Z,14Z))[iso6]); LMGL03010891 (TG(18:1(9Z)/18:2(9Z,12Z)/21:0)[iso6]); LMGL03010890 (TG(18:0/18:3(9Z,12Z,15Z)/21:0)[iso6]); LMGL03010721 (TG(18:2(9Z,12Z)/19:0/20:1(11Z))[iso6]); LMGL03010718 (TG(18:3(9Z,12Z,15Z)/19:0/20:0)[iso6]); LMGL03010842 (TG(17:0/18:1(9Z)/22:2(13Z,16Z))[iso6]); LMGL03010843 (TG(17:1(9Z)/18:0/22:2(13Z,16Z))[iso6]); LMGL03010605 (TG(17:0/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010598 (TG(17:0/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03010599 (TG(17:1(9Z)/20:0/20:2(11Z,14Z))[iso6]); LMGL03010592 (TG(17:1(9Z)/20:1(11Z)/20:1(11Z))[iso3]); LMGL03010593 (TG(17:2(9Z,12Z)/20:0/20:1(11Z))[iso6])": ["C60H110O6", "Glycerolipids [GL] with formula: C60H110O6"],
        "LMGL03010830 (TG(16:1(9Z)/19:0/22:1(13Z))[iso6]); LMGL03010541 (TG(17:0/20:0/20:2(11Z,14Z))[iso6]); LMGL03010817 (TG(16:1(9Z)/20:1(11Z)/21:0)[iso6]); LMGL03010816 (TG(16:0/20:2(11Z,14Z)/21:0)[iso6]); LMGL03010773 (TG(17:0/18:0/22:2(13Z,16Z))[iso6]); LMGL03010693 (TG(17:1(9Z)/18:1(9Z)/22:0)[iso6]); LMGL03010692 (TG(17:0/18:2(9Z,12Z)/22:0)[iso6]); LMGL03010697 (TG(17:0/18:1(9Z)/22:1(13Z))[iso6]); LMGL03010694 (TG(17:2(9Z,12Z)/18:0/22:0)[iso6]); LMGL03010698 (TG(17:1(9Z)/18:0/22:1(13Z))[iso6]); LMGL03010534 (TG(17:0/20:1(11Z)/20:1(11Z))[iso3]); LMGL03010535 (TG(17:1(9Z)/20:0/20:1(11Z))[iso6]); LMGL03010530 (TG(17:2(9Z,12Z)/20:0/20:0)[iso3]); LMGL03010889 (TG(17:2(9Z,12Z)/19:0/21:0)[iso6]); LMGL03010656 (TG(18:1(9Z)/19:0/20:1(11Z))[iso6]); LMGL03010652 (TG(18:2(9Z,12Z)/19:0/20:0)[iso6]); LMGL03010661 (TG(18:0/19:0/20:2(11Z,14Z))[iso6]); LMGL03010911 (TG(16:0/19:0/22:2(13Z,16Z))[iso6]); LMGL03010821 (TG(18:0/18:2(9Z,12Z)/21:0)[iso6]); LMGL03010822 (TG(18:1(9Z)/18:1(9Z)/21:0)[iso3])": ["C60H112O6", "Glycerolipids [GL] with formula: C60H112O6"],
        "LMGL03010630 (TG(17:1(9Z)/18:0/22:0)[iso6]); LMGL03010634 (TG(17:0/18:0/22:1(13Z))[iso6]); LMGL03010819 (TG(17:1(9Z)/19:0/21:0)[iso6]); LMGL03010761 (TG(16:0/19:0/22:1(13Z))[iso6]); LMGL03010750 (TG(16:1(9Z)/20:0/21:0)[iso6]); LMGL03010756 (TG(16:1(9Z)/19:0/22:0)[iso6]); LMGL03010754 (TG(18:0/18:1(9Z)/21:0)[iso6]); LMGL03010749 (TG(16:0/20:1(11Z)/21:0)[iso6]); LMGL03010475 (TG(17:1(9Z)/20:0/20:0)[iso3]); LMGL03010480 (TG(17:0/20:0/20:1(11Z))[iso6]); LMGL03010590 (TG(18:1(9Z)/19:0/20:0)[iso6]); LMGL03010594 (TG(18:0/19:0/20:1(11Z))[iso6]); LMGL03010629 (TG(17:0/18:1(9Z)/22:0)[iso6])": ["C60H114O6", "Glycerolipids [GL] with formula: C60H114O6"],
        "LMGL03010570 (TG(17:0/18:0/22:0)[iso6]); LMGL03010684 (TG(16:0/20:0/21:0)[iso6]); LMGL03010689 (TG(18:0/18:0/21:0)[iso3]); LMGL03010690 (TG(16:0/19:0/22:0)[iso6]); LMGL03010751 (TG(17:0/19:0/21:0)[iso6]); LMGL03010531 (TG(18:0/19:0/20:0)[iso6]); LMGL03010424 (TG(17:0/20:0/20:0)[iso3]); LMGL03010716 (TG(19:0/19:0/19:0))": ["C60H116O6", "Glycerolipids [GL] with formula: C60H116O6"],
        "LMGL03011244 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3])": ["C60H92O6", "Glycerolipids [GL] with formula: C60H92O6"],
        "LMGL03011168 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011169 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011387 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C60H94O6", "Glycerolipids [GL] with formula: C60H94O6"],
        "LMGL03011309 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011303 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011310 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011094 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011095 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011093 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011087 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3])": ["C60H96O6", "Glycerolipids [GL] with formula: C60H96O6"],
        "LMGL03011232 (TG(17:2(9Z,12Z)/18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011230 (TG(17:0/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011231 (TG(17:1(9Z)/18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011225 (TG(17:1(9Z)/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011226 (TG(17:2(9Z,12Z)/18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011022 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011021 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011020 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011014 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011013 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011219 (TG(17:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso6])": ["C60H98O6", "Glycerolipids [GL] with formula: C60H98O6"],
        "LMGL03011236 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011248 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011245 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011445 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011239 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011454 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011452 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011453 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011359 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03011352 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011247 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011246 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011241 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011240 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011446 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011462 (TG(16:1(9Z)/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011461 (TG(16:0/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011460 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011467 (TG(18:1(9Z)/18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011466 (TG(18:0/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011459 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C61H100O6", "Glycerolipids [GL] with formula: C61H100O6"],
        "LMGL03011368 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011369 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011388 (TG(18:0/18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011159 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011163 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011160 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011166 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011164 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011165 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011171 (TG(18:1(9Z)/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011170 (TG(18:0/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011173 (TG(18:3(9Z,12Z,15Z)/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011172 (TG(18:2(9Z,12Z)/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011377 (TG(16:1(9Z)/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011376 (TG(16:0/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011375 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03011374 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011437 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03011283 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011382 (TG(18:1(9Z)/18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011383 (TG(16:0/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011381 (TG(18:0/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011384 (TG(16:1(9Z)/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011389 (TG(18:1(9Z)/18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011276 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011277 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011444 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso3]); LMGL03011465 (TG(17:2(9Z,12Z)/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C61H102O6", "Glycerolipids [GL] with formula: C61H102O6"],
        "LMGL03011300 (TG(16:1(9Z)/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011306 (TG(16:0/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011307 (TG(16:1(9Z)/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011304 (TG(18:0/18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011305 (TG(18:1(9Z)/18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011360 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03011361 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011311 (TG(18:0/18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011367 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso6]); LMGL03011298 (TG(18:1(9Z)/18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011299 (TG(16:0/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011292 (TG(16:0/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011293 (TG(16:1(9Z)/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011297 (TG(18:0/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011380 (TG(17:2(9Z,12Z)/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011386 (TG(17:1(9Z)/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011098 (TG(18:2(9Z,12Z)/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011096 (TG(18:0/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011097 (TG(18:1(9Z)/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011090 (TG(18:2(9Z,12Z)/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011091 (TG(18:3(9Z,12Z,15Z)/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011275 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/22:1(13Z))[iso3]); LMGL03011089 (TG(18:1(9Z)/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011088 (TG(18:0/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011080 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03011083 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011085 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011084 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011268 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011327 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011201 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011200 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011207 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03011206 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso6])": ["C61H104O6", "Glycerolipids [GL] with formula: C61H104O6"],
        "LMGL03011233 (TG(18:0/18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011308 (TG(17:0/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011302 (TG(17:1(9Z)/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011228 (TG(16:0/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011221 (TG(18:1(9Z)/18:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03011220 (TG(18:0/18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011223 (TG(16:1(9Z)/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011222 (TG(16:0/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011227 (TG(18:0/18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011006 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03011009 (TG(18:1(9Z)/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011008 (TG(18:0/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011023 (TG(18:0/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011024 (TG(18:1(9Z)/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011016 (TG(18:1(9Z)/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011017 (TG(18:2(9Z,12Z)/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011015 (TG(18:0/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011010 (TG(18:2(9Z,12Z)/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011011 (TG(18:3(9Z,12Z,15Z)/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03011005 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03011290 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso6]); LMGL03011291 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/22:2(13Z,16Z))[iso3]); LMGL03011296 (TG(17:2(9Z,12Z)/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011285 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011284 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011126 (TG(16:1(9Z)/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011125 (TG(16:0/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011251 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011252 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011131 (TG(18:1(9Z)/18:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011130 (TG(18:0/18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011215 (TG(16:0/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011216 (TG(16:1(9Z)/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011184 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011193 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011192 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011191 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/22:0)[iso3]); LMGL03011199 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:1(13Z))[iso6])": ["C61H106O6", "Glycerolipids [GL] with formula: C61H106O6"],
        "LMGL03011050 (TG(16:0/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011051 (TG(16:1(9Z)/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011056 (TG(18:1(9Z)/18:1(9Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03011055 (TG(18:0/18:2(9Z,12Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03010943 (TG(18:0/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03010944 (TG(18:1(9Z)/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011224 (TG(17:0/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011144 (TG(18:0/18:1(9Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011145 (TG(16:0/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011140 (TG(16:1(9Z)/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011150 (TG(18:0/18:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011129 (TG(17:2(9Z,12Z)/19:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011178 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011174 (TG(19:0/19:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011177 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011176 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011109 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011118 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011110 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011117 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011116 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:0)[iso6]); LMGL03011123 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/22:1(13Z))[iso6]); LMGL03011124 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/22:1(13Z))[iso3]); LMGL03010938 (TG(18:2(9Z,12Z)/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010932 (TG(18:2(9Z,12Z)/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03010933 (TG(18:3(9Z,12Z,15Z)/20:0/20:2(11Z,14Z))[iso6]); LMGL03010931 (TG(18:1(9Z)/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03010936 (TG(18:0/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010937 (TG(18:1(9Z)/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011213 (TG(18:0/18:3(9Z,12Z,15Z)/22:2(13Z,16Z))[iso6]); LMGL03011214 (TG(18:1(9Z)/18:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03011218 (TG(17:1(9Z)/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010929 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/20:1(11Z))[iso3]); LMGL03011139 (TG(16:0/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011209 (TG(16:1(9Z)/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011208 (TG(16:0/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03010952 (TG(18:0/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C61H108O6", "Glycerolipids [GL] with formula: C61H108O6"],
        "LMGL03011053 (TG(17:1(9Z)/19:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011049 (TG(18:1(9Z)/18:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03011048 (TG(18:0/18:3(9Z,12Z,15Z)/22:1(13Z))[iso6]); LMGL03011041 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/22:0)[iso6]); LMGL03011043 (TG(16:0/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03010978 (TG(16:1(9Z)/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010977 (TG(16:0/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011035 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011036 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011141 (TG(17:0/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03010982 (TG(18:0/18:1(9Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011102 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011103 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011104 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/21:0)[iso6]); LMGL03011044 (TG(16:1(9Z)/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011042 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/22:0)[iso3]); LMGL03011133 (TG(16:1(9Z)/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011132 (TG(16:0/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03010867 (TG(18:1(9Z)/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010860 (TG(18:0/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03010862 (TG(18:2(9Z,12Z)/20:0/20:2(11Z,14Z))[iso6]); LMGL03010874 (TG(18:0/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011092 (TG(19:0/19:0/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011212 (TG(17:2(9Z,12Z)/19:0/22:2(13Z,16Z))[iso6]); LMGL03010858 (TG(18:3(9Z,12Z,15Z)/20:0/20:1(11Z))[iso6]); LMGL03010857 (TG(18:2(9Z,12Z)/20:1(11Z)/20:1(11Z))[iso3]); LMGL03011137 (TG(18:0/18:2(9Z,12Z)/22:2(13Z,16Z))[iso6]); LMGL03011138 (TG(18:1(9Z)/18:1(9Z)/22:2(13Z,16Z))[iso3]); LMGL03011063 (TG(16:0/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011068 (TG(18:0/18:0/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03010866 (TG(18:0/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03010861 (TG(18:1(9Z)/20:1(11Z)/20:2(11Z,14Z))[iso6])": ["C61H110O6", "Glycerolipids [GL] with formula: C61H110O6"],
        "LMGL03011057 (TG(16:0/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011058 (TG(16:1(9Z)/20:0/22:2(13Z,16Z))[iso6]); LMGL03010910 (TG(18:0/18:0/22:3(10Z,13Z,16Z))[iso3]); LMGL03011047 (TG(17:2(9Z,12Z)/19:0/22:1(13Z))[iso6]); LMGL03010798 (TG(18:0/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03010792 (TG(18:1(9Z)/20:0/20:2(11Z,14Z))[iso6]); LMGL03010791 (TG(18:0/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03010979 (TG(17:0/19:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03010976 (TG(18:1(9Z)/18:1(9Z)/22:1(13Z))[iso3]); LMGL03010975 (TG(18:0/18:2(9Z,12Z)/22:1(13Z))[iso6]); LMGL03010970 (TG(16:0/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03010971 (TG(16:1(9Z)/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011030 (TG(17:1(9Z)/20:2(11Z,14Z)/21:0)[iso6]); LMGL03011031 (TG(17:2(9Z,12Z)/20:1(11Z)/21:0)[iso6]); LMGL03010788 (TG(18:2(9Z,12Z)/20:0/20:1(11Z))[iso6]); LMGL03010785 (TG(18:3(9Z,12Z,15Z)/20:0/20:0)[iso3]); LMGL03010787 (TG(18:1(9Z)/20:1(11Z)/20:1(11Z))[iso3]); LMGL03010969 (TG(18:1(9Z)/18:2(9Z,12Z)/22:0)[iso6]); LMGL03010968 (TG(18:0/18:3(9Z,12Z,15Z)/22:0)[iso6]); LMGL03010963 (TG(16:0/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03010964 (TG(16:1(9Z)/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011029 (TG(17:0/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03010905 (TG(16:0/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011135 (TG(17:1(9Z)/19:0/22:2(13Z,16Z))[iso6]); LMGL03011012 (TG(19:0/19:0/20:3(8Z,11Z,14Z))[iso3]); LMGL03011182 (TG(18:3(9Z,12Z,15Z)/19:0/21:0)[iso6]); LMGL03011062 (TG(18:0/18:1(9Z)/22:2(13Z,16Z))[iso6])": ["C61H112O6", "Glycerolipids [GL] with formula: C61H112O6"],
        "LMGL03011059 (TG(17:0/19:0/22:2(13Z,16Z))[iso6]); LMGL03010973 (TG(17:1(9Z)/19:0/22:1(13Z))[iso6]); LMGL03010893 (TG(16:1(9Z)/20:1(11Z)/22:0)[iso6]); LMGL03010967 (TG(17:2(9Z,12Z)/19:0/22:0)[iso6]); LMGL03010983 (TG(16:0/20:0/22:2(13Z,16Z))[iso6]); LMGL03010988 (TG(18:0/18:0/22:2(13Z,16Z))[iso3]); LMGL03011107 (TG(18:2(9Z,12Z)/19:0/21:0)[iso6]); LMGL03010900 (TG(16:1(9Z)/20:0/22:1(13Z))[iso6]); LMGL03010720 (TG(18:1(9Z)/20:0/20:1(11Z))[iso6]); LMGL03010725 (TG(18:0/20:0/20:2(11Z,14Z))[iso6]); LMGL03010899 (TG(16:0/20:1(11Z)/22:1(13Z))[iso6]); LMGL03010898 (TG(18:1(9Z)/18:1(9Z)/22:0)[iso3]); LMGL03010892 (TG(16:0/20:2(11Z,14Z)/22:0)[iso6]); LMGL03010897 (TG(18:0/18:2(9Z,12Z)/22:0)[iso6]); LMGL03010904 (TG(18:0/18:1(9Z)/22:1(13Z))[iso6]); LMGL03010717 (TG(18:2(9Z,12Z)/20:0/20:0)[iso3]); LMGL03010719 (TG(18:0/20:1(11Z)/20:1(11Z))[iso3]); LMGL03010957 (TG(17:0/20:2(11Z,14Z)/21:0)[iso6]); LMGL03010934 (TG(19:0/19:0/20:2(11Z,14Z))[iso3]); LMGL03010958 (TG(17:1(9Z)/20:1(11Z)/21:0)[iso6]); LMGL03010959 (TG(17:2(9Z,12Z)/20:0/21:0)[iso6])": ["C61H114O6", "Glycerolipids [GL] with formula: C61H114O6"],
        "LMGL03010834 (TG(18:0/18:0/22:1(13Z))[iso3]); LMGL03011033 (TG(18:1(9Z)/19:0/21:0)[iso6]); LMGL03011175 (TG(16:1(9Z)/21:0/21:0)[iso3]); LMGL03010901 (TG(17:0/19:0/22:1(13Z))[iso6]); LMGL03010888 (TG(17:1(9Z)/20:0/21:0)[iso6]); LMGL03010887 (TG(17:0/20:1(11Z)/21:0)[iso6]); LMGL03010895 (TG(17:1(9Z)/19:0/22:0)[iso6]); LMGL03010655 (TG(18:0/20:0/20:1(11Z))[iso6]); LMGL03010651 (TG(18:1(9Z)/20:0/20:0)[iso3]); LMGL03010859 (TG(19:0/19:0/20:1(11Z))[iso3]); LMGL03010828 (TG(18:0/18:1(9Z)/22:0)[iso6]); LMGL03010829 (TG(16:0/20:0/22:1(13Z))[iso6]); LMGL03010823 (TG(16:0/20:1(11Z)/22:0)[iso6]); LMGL03010824 (TG(16:1(9Z)/20:0/22:0)[iso6])": ["C61H116O6", "Glycerolipids [GL] with formula: C61H116O6"],
        "LMGL05030004": ["C61H118O21S", "Glycerolipids [GL] with formula: C61H118O21S"],
        "LMGL03010818 (TG(17:0/20:0/21:0)[iso6]); LMGL03010786 (TG(19:0/19:0/20:0)[iso3]); LMGL03010960 (TG(18:0/19:0/21:0)[iso6]); LMGL03010760 (TG(18:0/18:0/22:0)[iso3]); LMGL03010755 (TG(16:0/20:0/22:0)[iso6]); LMGL03011100 (TG(16:0/21:0/21:0)[iso3]); LMGL03010589 (TG(18:0/20:0/20:0)[iso3]); LMGL03010825 (TG(17:0/19:0/22:0)[iso6])": ["C61H118O6", "Glycerolipids [GL] with formula: C61H118O6"],
        "LMGL03011549 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3])": ["C61H92O6", "Glycerolipids [GL] with formula: C61H92O6"],
        "LMGL03011473 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011474 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011695 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011688 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C61H94O6", "Glycerolipids [GL] with formula: C61H94O6"],
        "LMGL03011614 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011612 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011613 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011605 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011399 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011398 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011397 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011393 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011620 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C61H96O6", "Glycerolipids [GL] with formula: C61H96O6"],
        "LMGL03011543 (TG(18:1(9Z)/18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011544 (TG(18:2(9Z,12Z)/18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011317 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011316 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011323 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011528 (TG(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03011529 (TG(16:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011521 (TG(16:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011322 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011320 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011321 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011537 (TG(16:0/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011536 (TG(18:2(9Z,12Z)/18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011530 (TG(16:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011538 (TG(16:1(9Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C61H98O6", "Glycerolipids [GL] with formula: C61H98O6"],
        "LMGL03011579 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011624 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011672 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011671 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011690 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011691 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011689 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011682 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011681 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011680 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C62H100O6", "Glycerolipids [GL] with formula: C62H100O6"],
        "LMGL03011550 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011768 (TG(18:3(9Z,12Z,15Z)/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011597 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011599 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011598 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011615 (TG(17:0/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011616 (TG(17:1(9Z)/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011617 (TG(17:2(9Z,12Z)/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011607 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011606 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011608 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011504 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011505 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011662 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6])": ["C62H102O6", "Glycerolipids [GL] with formula: C62H102O6"],
        "LMGL03011540 (TG(17:1(9Z)/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011541 (TG(17:2(9Z,12Z)/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011588 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03011589 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011430 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011431 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011629 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011429 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011495 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011470 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011475 (TG(19:0/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011694 (TG(18:2(9Z,12Z)/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011522 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011523 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011524 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011686 (TG(18:3(9Z,12Z,15Z)/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011531 (TG(17:0/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011533 (TG(17:2(9Z,12Z)/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011532 (TG(17:1(9Z)/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011539 (TG(17:0/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C62H104O6", "Glycerolipids [GL] with formula: C62H104O6"],
        "LMGL03011555 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011554 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011761 (TG(16:1(9Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011456 (TG(17:1(9Z)/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011457 (TG(17:2(9Z,12Z)/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011455 (TG(17:0/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011353 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011355 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011354 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011611 (TG(18:2(9Z,12Z)/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011619 (TG(18:1(9Z)/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011603 (TG(18:3(9Z,12Z,15Z)/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011421 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011420 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011411 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011394 (TG(19:0/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011400 (TG(19:0/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011449 (TG(17:2(9Z,12Z)/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011448 (TG(17:1(9Z)/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011447 (TG(17:0/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011463 (TG(17:0/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011464 (TG(17:1(9Z)/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011515 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011514 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011513 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6])": ["C62H106O6", "Glycerolipids [GL] with formula: C62H106O6"],
        "LMGL03011542 (TG(18:0/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011481 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011480 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011379 (TG(17:1(9Z)/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011378 (TG(17:0/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011344 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011345 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011372 (TG(17:2(9Z,12Z)/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011371 (TG(17:1(9Z)/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011370 (TG(17:0/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011438 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011439 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011435 (TG(18:3(9Z,12Z,15Z)/19:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011280 (TG(17:2(9Z,12Z)/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011385 (TG(17:0/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011313 (TG(19:0/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011318 (TG(19:0/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011278 (TG(17:0/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011279 (TG(17:1(9Z)/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011479 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011440 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011335 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011679 (TG(16:1(9Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011346 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011324 (TG(19:0/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011527 (TG(18:2(9Z,12Z)/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011336 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011687 (TG(16:0/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011535 (TG(18:1(9Z)/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C62H108O6", "Glycerolipids [GL] with formula: C62H108O6"],
        "LMGL03011301 (TG(17:0/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011249 (TG(19:0/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011362 (TG(17:0/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011363 (TG(17:1(9Z)/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011364 (TG(17:2(9Z,12Z)/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011358 (TG(18:2(9Z,12Z)/19:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011596 (TG(16:1(9Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011294 (TG(17:0/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011295 (TG(17:1(9Z)/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011604 (TG(16:0/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011242 (TG(19:0/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011405 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011404 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011406 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/21:0)[iso6]); LMGL03011403 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011270 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011271 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011451 (TG(18:1(9Z)/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011261 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011260 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011262 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011269 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011458 (TG(18:0/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011203 (TG(17:1(9Z)/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011202 (TG(17:0/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011204 (TG(17:2(9Z,12Z)/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011237 (TG(19:0/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011519 (TG(18:3(9Z,12Z,15Z)/19:0/22:2(13Z,16Z))[iso6])": ["C62H110O6", "Glycerolipids [GL] with formula: C62H110O6"],
        "LMGL03011157 (TG(19:0/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03011161 (TG(19:0/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011167 (TG(19:0/20:0/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011328 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011329 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011350 (TG(18:3(9Z,12Z,15Z)/19:0/22:1(13Z))[iso6]); LMGL03011520 (TG(16:0/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011373 (TG(18:0/19:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011128 (TG(17:1(9Z)/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011288 (TG(17:2(9Z,12Z)/20:0/22:2(13Z,16Z))[iso6]); LMGL03011282 (TG(18:1(9Z)/19:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011287 (TG(17:1(9Z)/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011286 (TG(17:0/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011428 (TG(16:1(9Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011127 (TG(17:0/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011443 (TG(18:2(9Z,12Z)/19:0/22:2(13Z,16Z))[iso6]); LMGL03011217 (TG(17:0/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011185 (TG(17:0/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011186 (TG(17:1(9Z)/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011187 (TG(17:2(9Z,12Z)/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011196 (TG(17:2(9Z,12Z)/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011195 (TG(17:1(9Z)/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011194 (TG(17:0/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011331 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/21:0)[iso6]); LMGL03011330 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/21:0)[iso6])": ["C62H112O6", "Glycerolipids [GL] with formula: C62H112O6"],
        "LMGL03011052 (TG(17:0/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011366 (TG(18:1(9Z)/19:0/22:2(13Z,16Z))[iso6]); LMGL03011351 (TG(16:0/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011119 (TG(17:0/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011113 (TG(17:2(9Z,12Z)/20:1(11Z)/22:0)[iso6]); LMGL03011112 (TG(17:1(9Z)/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011111 (TG(17:0/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011120 (TG(17:1(9Z)/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011121 (TG(17:2(9Z,12Z)/20:0/22:1(13Z))[iso6]); LMGL03011254 (TG(18:1(9Z)/20:2(11Z,14Z)/21:0)[iso6]); LMGL03011255 (TG(18:2(9Z,12Z)/20:1(11Z)/21:0)[iso6]); LMGL03011256 (TG(18:3(9Z,12Z,15Z)/20:0/21:0)[iso6]); LMGL03011253 (TG(18:0/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011274 (TG(18:2(9Z,12Z)/19:0/22:1(13Z))[iso6]); LMGL03011081 (TG(19:0/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03011086 (TG(19:0/20:0/20:3(8Z,11Z,14Z))[iso6]); LMGL03011266 (TG(18:3(9Z,12Z,15Z)/19:0/22:0)[iso6]); LMGL03011512 (TG(16:1(9Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03011210 (TG(17:0/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011211 (TG(17:1(9Z)/20:0/22:2(13Z,16Z))[iso6]); LMGL03011205 (TG(18:0/19:0/22:3(10Z,13Z,16Z))[iso6])": ["C62H114O6", "Glycerolipids [GL] with formula: C62H114O6"],
        "LMGL03011045 (TG(17:0/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011046 (TG(17:1(9Z)/20:0/22:1(13Z))[iso6]); LMGL03011038 (TG(17:1(9Z)/20:1(11Z)/22:0)[iso6]); LMGL03011039 (TG(17:2(9Z,12Z)/20:0/22:0)[iso6]); LMGL03011037 (TG(17:0/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011007 (TG(19:0/20:0/20:2(11Z,14Z))[iso6]); LMGL03011343 (TG(16:1(9Z)/21:0/22:1(13Z))[iso6]); LMGL03011003 (TG(19:0/20:1(11Z)/20:1(11Z))[iso3]); LMGL03011179 (TG(18:0/20:2(11Z,14Z)/21:0)[iso6]); LMGL03011436 (TG(16:0/21:0/22:2(13Z,16Z))[iso6]); LMGL03011289 (TG(18:0/19:0/22:2(13Z,16Z))[iso6]); LMGL03011134 (TG(17:0/20:0/22:2(13Z,16Z))[iso6]); LMGL03011402 (TG(17:2(9Z,12Z)/21:0/21:0)[iso3]); LMGL03011180 (TG(18:1(9Z)/20:1(11Z)/21:0)[iso6]); LMGL03011181 (TG(18:2(9Z,12Z)/20:0/21:0)[iso6]); LMGL03011190 (TG(18:2(9Z,12Z)/19:0/22:0)[iso6]); LMGL03011198 (TG(18:1(9Z)/19:0/22:1(13Z))[iso6])": ["C62H116O6", "Glycerolipids [GL] with formula: C62H116O6"],
        "LMGL03010972 (TG(17:0/20:0/22:1(13Z))[iso6]); LMGL03010965 (TG(17:0/20:1(11Z)/22:0)[iso6]); LMGL03010966 (TG(17:1(9Z)/20:0/22:0)[iso6]); LMGL03011105 (TG(18:0/20:1(11Z)/21:0)[iso6]); LMGL03011106 (TG(18:1(9Z)/20:0/21:0)[iso6]); LMGL03011115 (TG(18:1(9Z)/19:0/22:0)[iso6]); LMGL03011122 (TG(18:0/19:0/22:1(13Z))[iso6]); LMGL03011259 (TG(16:1(9Z)/21:0/22:0)[iso6]); LMGL03011267 (TG(16:0/21:0/22:1(13Z))[iso6]); LMGL03010930 (TG(19:0/20:0/20:1(11Z))[iso6]); LMGL03011326 (TG(17:1(9Z)/21:0/21:0)[iso3])": ["C62H118O6", "Glycerolipids [GL] with formula: C62H118O6"],
        "LMGL03011040 (TG(18:0/19:0/22:0)[iso6]); LMGL03011032 (TG(18:0/20:0/21:0)[iso6]); LMGL03010894 (TG(17:0/20:0/22:0)[iso6]); LMGL03011257 (TG(19:0/19:0/21:0)[iso3]); LMGL03011250 (TG(17:0/21:0/21:0)[iso3]); LMGL03011183 (TG(16:0/21:0/22:0)[iso6]); LMGL03010856 (TG(19:0/20:0/20:0)[iso3])": ["C62H120O6", "Glycerolipids [GL] with formula: C62H120O6"],
        "LMGL03011903 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C62H94O6", "Glycerolipids [GL] with formula: C62H94O6"],
        "LMGL03011833 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011834 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011824 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C62H96O6", "Glycerolipids [GL] with formula: C62H96O6"],
        "LMGL03011764 (TG(17:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011762 (TG(17:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011763 (TG(17:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011744 (TG(17:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011754 (TG(17:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011753 (TG(17:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C62H98O6", "Glycerolipids [GL] with formula: C62H98O6"],
        "LMGL03012086 (TG(16:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012087 (TG(16:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011959 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011948 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011949 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011960 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011961 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011769 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011772 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011771 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03012075 (TG(16:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011971 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011972 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011969 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011770 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011863 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011970 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C63H100O6", "Glycerolipids [GL] with formula: C63H100O6"],
        "LMGL03012016 (TG(16:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011938 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03011795 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011794 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011904 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011905 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011906 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011907 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012027 (TG(16:0/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012015 (TG(16:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011965 (TG(16:1(9Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011896 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011894 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011895 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011893 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011883 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011885 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011884 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011698 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011699 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011696 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011697 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011700 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6])": ["C63H102O6", "Glycerolipids [GL] with formula: C63H102O6"],
        "LMGL03011835 (TG(18:0/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011836 (TG(18:1(9Z)/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011837 (TG(18:2(9Z,12Z)/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011838 (TG(18:3(9Z,12Z,15Z)/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011816 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011817 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011825 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011786 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011814 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011815 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011827 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011826 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011724 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011725 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011726 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011953 (TG(16:0/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011828 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011942 (TG(16:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03011625 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011627 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011626 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011872 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03011873 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011899 (TG(16:0/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011889 (TG(16:1(9Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012028 (TG(16:1(9Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011621 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))); LMGL03011623 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011622 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3])": ["C63H104O6", "Glycerolipids [GL] with formula: C63H104O6"],
        "LMGL03011547 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011545 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011546 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011548 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011715 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011716 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011552 (TG(20:1(11Z)/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011551 (TG(20:0/20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011810 (TG(16:1(9Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011765 (TG(18:0/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011766 (TG(18:1(9Z)/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011767 (TG(18:2(9Z,12Z)/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011805 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011804 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03011806 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011900 (TG(16:1(9Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011746 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011747 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011745 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011755 (TG(18:0/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011757 (TG(18:2(9Z,12Z)/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011756 (TG(18:1(9Z)/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011758 (TG(18:3(9Z,12Z,15Z)/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011877 (TG(16:0/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03011968 (TG(17:2(9Z,12Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011954 (TG(16:1(9Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011964 (TG(16:0/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011820 (TG(16:0/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011652 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011653 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011654 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011655 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011708 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011748 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6])": ["C63H106O6", "Glycerolipids [GL] with formula: C63H106O6"],
        "LMGL03011830 (TG(16:0/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011831 (TG(16:1(9Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011821 (TG(16:1(9Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011902 (TG(17:1(9Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011737 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011736 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011735 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011734 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03011636 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011635 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011878 (TG(16:1(9Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011892 (TG(17:2(9Z,12Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011471 (TG(20:0/20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011472 (TG(20:1(11Z)/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011476 (TG(20:0/20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011477 (TG(20:1(11Z)/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011888 (TG(16:0/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011643 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011645 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011644 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011469 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011468 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011648 (TG(16:1(9Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03011676 (TG(18:3(9Z,12Z,15Z)/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011674 (TG(18:1(9Z)/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011675 (TG(18:2(9Z,12Z)/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011673 (TG(18:0/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011692 (TG(18:0/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011693 (TG(18:1(9Z)/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011580 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011581 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011582 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011583 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011740 (TG(16:0/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011685 (TG(18:2(9Z,12Z)/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011684 (TG(18:1(9Z)/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011683 (TG(18:0/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C63H108O6", "Glycerolipids [GL] with formula: C63H108O6"],
        "LMGL03011832 (TG(17:0/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011839 (TG(19:0/19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011823 (TG(17:1(9Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011562 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011563 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011602 (TG(18:2(9Z,12Z)/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011813 (TG(17:2(9Z,12Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011561 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011760 (TG(16:0/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011809 (TG(16:0/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011572 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011575 (TG(16:0/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03011741 (TG(16:1(9Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011569 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011751 (TG(16:1(9Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011750 (TG(16:0/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011610 (TG(18:1(9Z)/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011618 (TG(18:0/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011571 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011570 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011601 (TG(18:1(9Z)/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011600 (TG(18:0/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011609 (TG(18:0/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011730 (TG(16:1(9Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03011508 (TG(18:2(9Z,12Z)/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011509 (TG(18:3(9Z,12Z,15Z)/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011395 (TG(20:0/20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011396 (TG(20:1(11Z)/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011391 (TG(20:0/20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011390 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/20:2(11Z,14Z))); LMGL03011392 (TG(20:1(11Z)/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011401 (TG(20:0/20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011506 (TG(18:0/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011507 (TG(18:1(9Z)/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011663 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011665 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011664 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011666 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/22:2(13Z,16Z))[iso6])": ["C63H110O6", "Glycerolipids [GL] with formula: C63H110O6"],
        "LMGL03011315 (TG(20:1(11Z)/20:1(11Z)/20:3(8Z,11Z,14Z))[iso3]); LMGL03011314 (TG(20:0/20:2(11Z,14Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011497 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011799 (TG(16:1(9Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03011487 (TG(18:1(9Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011486 (TG(18:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011576 (TG(16:1(9Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011743 (TG(17:1(9Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011593 (TG(18:3(9Z,12Z,15Z)/20:0/22:2(13Z,16Z))[iso6]); LMGL03011592 (TG(18:2(9Z,12Z)/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011591 (TG(18:1(9Z)/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011590 (TG(18:0/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011752 (TG(17:0/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011759 (TG(19:0/19:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011658 (TG(16:0/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03011651 (TG(17:2(9Z,12Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011489 (TG(18:3(9Z,12Z,15Z)/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011488 (TG(18:2(9Z,12Z)/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011434 (TG(18:2(9Z,12Z)/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011432 (TG(18:0/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011433 (TG(18:1(9Z)/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011496 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011498 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011499 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011312 (TG(20:1(11Z)/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03011319 (TG(20:0/20:1(11Z)/20:4(5Z,8Z,11Z,14Z))[iso6]); LMGL03011678 (TG(16:0/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011325 (TG(20:0/20:0/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011526 (TG(18:1(9Z)/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011525 (TG(18:0/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011702 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011669 (TG(16:1(9Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011668 (TG(16:0/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011534 (TG(18:0/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C63H112O6", "Glycerolipids [GL] with formula: C63H112O6"],
        "LMGL03011234 (TG(20:0/20:2(11Z,14Z)/20:2(11Z,14Z))[iso3]); LMGL03011235 (TG(20:1(11Z)/20:1(11Z)/20:2(11Z,14Z))[iso3]); LMGL03011238 (TG(20:0/20:1(11Z)/20:3(8Z,11Z,14Z))[iso6]); LMGL03011357 (TG(18:1(9Z)/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011356 (TG(18:0/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011595 (TG(16:0/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011659 (TG(16:1(9Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03011729 (TG(16:0/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03011733 (TG(17:2(9Z,12Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03011425 (TG(18:3(9Z,12Z,15Z)/20:0/22:1(13Z))[iso6]); LMGL03011424 (TG(18:2(9Z,12Z)/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011423 (TG(18:1(9Z)/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011422 (TG(18:0/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011501 (TG(16:0/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011630 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011412 (TG(18:0/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011413 (TG(18:1(9Z)/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011414 (TG(18:2(9Z,12Z)/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011415 (TG(18:3(9Z,12Z,15Z)/20:1(11Z)/22:0)[iso6]); LMGL03011516 (TG(18:0/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011243 (TG(20:0/20:0/20:4(5Z,8Z,11Z,14Z))[iso3]); LMGL03011578 (TG(17:1(9Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011502 (TG(16:1(9Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011677 (TG(19:0/19:0/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03011670 (TG(17:0/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011450 (TG(18:0/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011518 (TG(18:2(9Z,12Z)/20:0/22:2(13Z,16Z))[iso6]); LMGL03011517 (TG(18:1(9Z)/20:1(11Z)/22:2(13Z,16Z))[iso6])": ["C63H114O6", "Glycerolipids [GL] with formula: C63H114O6"],
        "LMGL03011510 (TG(19:0/19:0/22:3(10Z,13Z,16Z))[iso3]); LMGL03011568 (TG(17:2(9Z,12Z)/21:0/22:1(13Z))[iso6]); LMGL03011556 (TG(19:0/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011492 (TG(16:1(9Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03011156 (TG(20:1(11Z)/20:1(11Z)/20:1(11Z))); LMGL03011158 (TG(20:0/20:1(11Z)/20:2(11Z,14Z))[iso6]); LMGL03011162 (TG(20:0/20:0/20:3(8Z,11Z,14Z))[iso3]); LMGL03011340 (TG(18:3(9Z,12Z,15Z)/20:0/22:0)[iso6]); LMGL03011338 (TG(18:1(9Z)/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011281 (TG(18:0/20:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011427 (TG(16:0/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011503 (TG(17:0/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011339 (TG(18:2(9Z,12Z)/20:1(11Z)/22:0)[iso6]); LMGL03011441 (TG(18:0/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011442 (TG(18:1(9Z)/20:0/22:2(13Z,16Z))[iso6]); LMGL03011348 (TG(18:1(9Z)/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011349 (TG(18:2(9Z,12Z)/20:0/22:1(13Z))[iso6]); LMGL03011347 (TG(18:0/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011701 (TG(18:3(9Z,12Z,15Z)/21:0/21:0)[iso3]); LMGL03011585 (TG(16:0/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03011586 (TG(16:1(9Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03011661 (TG(17:1(9Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03011337 (TG(18:0/20:3(8Z,11Z,14Z)/22:0)[iso6])": ["C63H116O6", "Glycerolipids [GL] with formula: C63H116O6"],
        "LMGL03011365 (TG(18:0/20:0/22:2(13Z,16Z))[iso6]); LMGL03011485 (TG(17:2(9Z,12Z)/21:0/22:0)[iso6]); LMGL03011594 (TG(19:0/19:0/22:2(13Z,16Z))[iso3]); LMGL03011482 (TG(19:0/20:2(11Z,14Z)/21:0)[iso6]); LMGL03011628 (TG(18:2(9Z,12Z)/21:0/21:0)[iso3]); LMGL03011494 (TG(17:1(9Z)/21:0/22:1(13Z))[iso6]); LMGL03011418 (TG(16:1(9Z)/22:0/22:1(13Z))[iso6]); LMGL03011417 (TG(16:0/22:1(13Z)/22:1(13Z))[iso3]); LMGL03011272 (TG(18:0/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011273 (TG(18:1(9Z)/20:0/22:1(13Z))[iso6]); LMGL03011082 (TG(20:0/20:0/20:2(11Z,14Z))[iso3]); LMGL03011265 (TG(18:2(9Z,12Z)/20:0/22:0)[iso6]); LMGL03011264 (TG(18:1(9Z)/20:1(11Z)/22:0)[iso6]); LMGL03011263 (TG(18:0/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011511 (TG(16:0/22:0/22:2(13Z,16Z))[iso6]); LMGL03011079 (TG(20:0/20:1(11Z)/20:1(11Z))[iso3]); LMGL03011587 (TG(17:0/21:0/22:2(13Z,16Z))[iso6])": ["C63H118O6", "Glycerolipids [GL] with formula: C63H118O6"],
        "LMGL03011553 (TG(18:1(9Z)/21:0/21:0)[iso3]); LMGL03011342 (TG(16:0/22:0/22:1(13Z))[iso6]); LMGL03011004 (TG(20:0/20:0/20:1(11Z))[iso3]); LMGL03011426 (TG(19:0/19:0/22:1(13Z))[iso3]); LMGL03011419 (TG(17:0/21:0/22:1(13Z))[iso6]); LMGL03011410 (TG(17:1(9Z)/21:0/22:0)[iso6]); LMGL03011407 (TG(19:0/20:1(11Z)/21:0)[iso6]); LMGL03011188 (TG(18:0/20:1(11Z)/22:0)[iso6]); LMGL03011189 (TG(18:1(9Z)/20:0/22:0)[iso6]); LMGL03011197 (TG(18:0/20:0/22:1(13Z))[iso6]); LMGL03011333 (TG(16:1(9Z)/22:0/22:0)[iso3])": ["C63H120O6", "Glycerolipids [GL] with formula: C63H120O6"],
        "LMGL03011341 (TG(19:0/19:0/22:0)[iso3]); LMGL03011334 (TG(17:0/21:0/22:0)[iso6]); LMGL03011114 (TG(18:0/20:0/22:0)[iso6]); LMGL03011258 (TG(16:0/22:0/22:0)[iso3]); LMGL03011478 (TG(18:0/21:0/21:0)[iso3]); LMGL03010003 (TG(20:0/20:0/20:0)); LMGL03011332 (TG(19:0/20:0/21:0)[iso6])": ["C63H122O6", "Glycerolipids [GL] with formula: C63H122O6"],
        "LMGL03012038 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)))": ["C63H92O6", "Glycerolipids [GL] with formula: C63H92O6"],
        "LMGL03012150 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011975 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3])": ["C63H94O6", "Glycerolipids [GL] with formula: C63H94O6"],
        "LMGL03012093 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012094 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012082 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011909 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011910 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03012194 (TG(16:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C63H96O6", "Glycerolipids [GL] with formula: C63H96O6"],
        "LMGL03012143 (TG(16:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012142 (TG(16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012011 (TG(18:3(9Z,12Z,15Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012022 (TG(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012023 (TG(18:3(9Z,12Z,15Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012035 (TG(18:3(9Z,12Z,15Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012034 (TG(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011842 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso6]); LMGL03011841 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z))[iso3]); LMGL03011840 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))); LMGL03012033 (TG(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C63H98O6", "Glycerolipids [GL] with formula: C63H98O6"],
        "LMGL03012233 (TG(17:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012244 (TG(17:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012245 (TG(17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012243 (TG(17:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C64H100O6", "Glycerolipids [GL] with formula: C64H100O6"],
        "LMGL03012146 (TG(17:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012202 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012196 (TG(17:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012195 (TG(17:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012185 (TG(17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012184 (TG(17:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3])": ["C64H102O6", "Glycerolipids [GL] with formula: C64H102O6"],
        "LMGL03012151 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012144 (TG(17:0/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012089 (TG(17:1(9Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012099 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso3]); LMGL03012131 (TG(17:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012132 (TG(17:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012138 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012122 (TG(17:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012078 (TG(17:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012197 (TG(17:2(9Z,12Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C64H104O6", "Glycerolipids [GL] with formula: C64H104O6"],
        "LMGL03012018 (TG(17:1(9Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012145 (TG(17:1(9Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012090 (TG(17:2(9Z,12Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012095 (TG(19:0/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012083 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012133 (TG(17:2(9Z,12Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012040 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03012065 (TG(17:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012076 (TG(17:0/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012071 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012007 (TG(17:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012201 (TG(18:3(9Z,12Z,15Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012029 (TG(17:0/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C64H106O6", "Glycerolipids [GL] with formula: C64H106O6"],
        "LMGL03012149 (TG(18:2(9Z,12Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012088 (TG(17:0/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012137 (TG(18:3(9Z,12Z,15Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011978 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso3]); LMGL03012066 (TG(17:2(9Z,12Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012077 (TG(17:1(9Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011977 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03012005 (TG(17:0/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03011929 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012012 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012019 (TG(17:2(9Z,12Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011955 (TG(17:0/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012024 (TG(19:0/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011944 (TG(17:1(9Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012031 (TG(17:2(9Z,12Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012030 (TG(17:1(9Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012036 (TG(19:0/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011859 (TG(17:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3])": ["C64H108O6", "Glycerolipids [GL] with formula: C64H108O6"],
        "LMGL03012081 (TG(18:2(9Z,12Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012017 (TG(17:0/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012092 (TG(18:1(9Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011962 (TG(19:0/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011966 (TG(17:0/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011967 (TG(17:1(9Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011790 (TG(17:1(9Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012070 (TG(18:3(9Z,12Z,15Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011913 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011912 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011973 (TG(19:0/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012001 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03012006 (TG(17:1(9Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011934 (TG(17:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03011957 (TG(17:2(9Z,12Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011956 (TG(17:1(9Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011950 (TG(19:0/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011864 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011945 (TG(17:2(9Z,12Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011879 (TG(17:0/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6])": ["C64H110O6", "Glycerolipids [GL] with formula: C64H110O6"],
        "LMGL03011855 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011791 (TG(17:2(9Z,12Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011796 (TG(19:0/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011901 (TG(17:0/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011908 (TG(19:0/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011846 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/21:0)[iso3]); LMGL03011928 (TG(18:3(9Z,12Z,15Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011720 (TG(17:0/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012021 (TG(18:1(9Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012010 (TG(18:2(9Z,12Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011939 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011868 (TG(17:1(9Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03011845 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011844 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03011897 (TG(19:0/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011890 (TG(17:0/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011891 (TG(17:1(9Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011881 (TG(17:2(9Z,12Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011880 (TG(17:1(9Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011886 (TG(19:0/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011943 (TG(17:0/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012032 (TG(18:0/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011996 (TG(17:2(9Z,12Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3])": ["C64H112O6", "Glycerolipids [GL] with formula: C64H112O6"],
        "LMGL03011721 (TG(17:1(9Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011822 (TG(17:0/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011958 (TG(18:0/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011727 (TG(19:0/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011787 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011812 (TG(17:1(9Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011811 (TG(17:0/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011800 (TG(17:0/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03011775 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6]); LMGL03011774 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/21:0)[iso6]); LMGL03012000 (TG(18:3(9Z,12Z,15Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03011722 (TG(17:2(9Z,12Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011829 (TG(19:0/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011933 (TG(17:1(9Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03011779 (TG(19:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011776 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011869 (TG(17:2(9Z,12Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03011947 (TG(18:1(9Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011874 (TG(19:0/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011862 (TG(18:2(9Z,12Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011818 (TG(19:0/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6])": ["C64H114O6", "Glycerolipids [GL] with formula: C64H114O6"],
        "LMGL03011717 (TG(19:0/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011854 (TG(18:3(9Z,12Z,15Z)/21:0/22:1(13Z))[iso6]); LMGL03011937 (TG(18:2(9Z,12Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03011793 (TG(18:1(9Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011801 (TG(17:1(9Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03011802 (TG(17:2(9Z,12Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03011807 (TG(19:0/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011749 (TG(19:0/20:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011742 (TG(17:0/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011650 (TG(17:1(9Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011656 (TG(19:0/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011704 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011705 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/21:0)[iso3]); LMGL03011882 (TG(18:0/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011649 (TG(17:0/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011867 (TG(17:0/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03011712 (TG(17:2(9Z,12Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03011709 (TG(19:0/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011703 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/21:0)[iso6])": ["C64H116O6", "Glycerolipids [GL] with formula: C64H116O6"],
        "LMGL03011785 (TG(18:2(9Z,12Z)/21:0/22:1(13Z))[iso6]); LMGL03011577 (TG(17:0/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011871 (TG(18:1(9Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03011723 (TG(18:0/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011778 (TG(18:3(9Z,12Z,15Z)/21:0/22:0)[iso6]); LMGL03011732 (TG(17:1(9Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03011731 (TG(17:0/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03011738 (TG(19:0/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011632 (TG(20:1(11Z)/20:2(11Z,14Z)/21:0)[iso6]); LMGL03011631 (TG(20:0/20:3(8Z,11Z,14Z)/21:0)[iso6]); LMGL03011637 (TG(19:0/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011646 (TG(19:0/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011641 (TG(17:2(9Z,12Z)/22:0/22:1(13Z))[iso6]); LMGL03011640 (TG(17:1(9Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03011584 (TG(19:0/20:0/22:3(10Z,13Z,16Z))[iso6])": ["C64H118O6", "Glycerolipids [GL] with formula: C64H118O6"],
        "LMGL03011714 (TG(18:1(9Z)/21:0/22:1(13Z))[iso6]); LMGL03011557 (TG(20:0/20:2(11Z,14Z)/21:0)[iso6]); LMGL03011559 (TG(17:2(9Z,12Z)/22:0/22:0)[iso3]); LMGL03011558 (TG(20:1(11Z)/20:1(11Z)/21:0)[iso3]); LMGL03011566 (TG(17:0/22:1(13Z)/22:1(13Z))[iso3]); LMGL03011567 (TG(17:1(9Z)/22:0/22:1(13Z))[iso6]); LMGL03011564 (TG(19:0/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011803 (TG(18:0/21:0/22:2(13Z,16Z))[iso6]); LMGL03011573 (TG(19:0/20:1(11Z)/22:1(13Z))[iso6]); LMGL03011707 (TG(18:2(9Z,12Z)/21:0/22:0)[iso6]); LMGL03011660 (TG(17:0/22:0/22:2(13Z,16Z))[iso6]); LMGL03011667 (TG(19:0/20:0/22:2(13Z,16Z))[iso6])": ["C64H120O6", "Glycerolipids [GL] with formula: C64H120O6"],
        "LMGL03011490 (TG(19:0/20:1(11Z)/22:0)[iso6]); LMGL03011484 (TG(17:1(9Z)/22:0/22:0)[iso3]); LMGL03011500 (TG(19:0/20:0/22:1(13Z))[iso6]); LMGL03011483 (TG(20:0/20:1(11Z)/21:0)[iso6]); LMGL03011493 (TG(17:0/22:0/22:1(13Z))[iso6]); LMGL03011634 (TG(18:1(9Z)/21:0/22:0)[iso6]); LMGL03011642 (TG(18:0/21:0/22:1(13Z))[iso6])": ["C64H122O6", "Glycerolipids [GL] with formula: C64H122O6"],
        "LMGL03011560 (TG(18:0/21:0/22:0)[iso6]); LMGL03011773 (TG(19:0/21:0/21:0)[iso3]); LMGL03011416 (TG(19:0/20:0/22:0)[iso6]); LMGL03011409 (TG(17:0/22:0/22:0)[iso3]); LMGL03011408 (TG(20:0/20:0/21:0)[iso3])": ["C64H124O6", "Glycerolipids [GL] with formula: C64H124O6"],
        "LMGL03012328 (TG(17:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C64H96O6", "Glycerolipids [GL] with formula: C64H96O6"],
        "LMGL03012287 (TG(17:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012288 (TG(17:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C64H98O6", "Glycerolipids [GL] with formula: C64H98O6"],
        "LMGL03012400 (TG(18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012401 (TG(18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012318 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012327 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012399 (TG(18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012336 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012337 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012326 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012391 (TG(18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012263 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso3])": ["C65H100O6", "Glycerolipids [GL] with formula: C65H100O6"],
        "LMGL03012276 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012365 (TG(18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012367 (TG(18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012366 (TG(18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012311 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso3]); LMGL03012332 (TG(18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012217 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012277 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012286 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012285 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012295 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012297 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012296 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012357 (TG(18:2(9Z,12Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012358 (TG(18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C65H102O6", "Glycerolipids [GL] with formula: C65H102O6"],
        "LMGL03012368 (TG(18:3(9Z,12Z,15Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012320 (TG(18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012312 (TG(18:3(9Z,12Z,15Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012212 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso3]); LMGL03012232 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012231 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012330 (TG(18:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012329 (TG(18:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012242 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012240 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012241 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012269 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03012251 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012253 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012252 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012281 (TG(18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012291 (TG(18:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012319 (TG(18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012167 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012166 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6])": ["C65H104O6", "Glycerolipids [GL] with formula: C65H104O6"],
        "LMGL03012157 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso3]); LMGL03012224 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso3]); LMGL03012227 (TG(18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012223 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03012236 (TG(18:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012203 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012204 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012205 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012331 (TG(18:2(9Z,12Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012112 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012113 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012321 (TG(18:3(9Z,12Z,15Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012279 (TG(18:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012278 (TG(18:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012270 (TG(18:2(9Z,12Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012247 (TG(18:1(9Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012182 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012289 (TG(18:0/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012292 (TG(18:3(9Z,12Z,15Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012192 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012193 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012191 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012181 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012183 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012161 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6])": ["C65H106O6", "Glycerolipids [GL] with formula: C65H106O6"],
        "LMGL03012152 (TG(20:0/20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012153 (TG(20:1(11Z)/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012141 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012140 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012225 (TG(18:1(9Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012130 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012139 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012108 (TG(18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012237 (TG(18:3(9Z,12Z,15Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012234 (TG(18:0/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012129 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012128 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012056 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012055 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012054 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012107 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso3]); LMGL03012106 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03012271 (TG(18:3(9Z,12Z,15Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012248 (TG(18:2(9Z,12Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012249 (TG(18:3(9Z,12Z,15Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012280 (TG(18:2(9Z,12Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012102 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03012290 (TG(18:1(9Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012198 (TG(18:0/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012174 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03012177 (TG(18:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012173 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03012187 (TG(18:1(9Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C65H108O6", "Glycerolipids [GL] with formula: C65H108O6"],
        "LMGL03012085 (TG(20:1(11Z)/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012097 (TG(20:1(11Z)/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012084 (TG(20:0/20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012226 (TG(18:2(9Z,12Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012134 (TG(18:0/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012048 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03012049 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03012044 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso3]); LMGL03012043 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03012235 (TG(18:1(9Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012121 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso3]); LMGL03012120 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03012124 (TG(18:1(9Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012050 (TG(18:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012200 (TG(18:2(9Z,12Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012074 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012073 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012072 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012096 (TG(20:0/20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012246 (TG(18:0/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012188 (TG(18:2(9Z,12Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012119 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03012199 (TG(18:1(9Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012178 (TG(18:3(9Z,12Z,15Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012175 (TG(18:0/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012189 (TG(18:3(9Z,12Z,15Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012169 (TG(18:3(9Z,12Z,15Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03011993 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011995 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011994 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6])": ["C65H110O6", "Glycerolipids [GL] with formula: C65H110O6"],
        "LMGL03012014 (TG(20:1(11Z)/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012147 (TG(18:0/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012148 (TG(18:1(9Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012136 (TG(18:2(9Z,12Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011932 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012218 (TG(18:3(9Z,12Z,15Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012126 (TG(18:3(9Z,12Z,15Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012125 (TG(18:2(9Z,12Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012051 (TG(18:3(9Z,12Z,15Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012115 (TG(18:2(9Z,12Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012062 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z))[iso6]); LMGL03012063 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03012067 (TG(18:0/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012064 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03012013 (TG(20:0/20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011931 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011930 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012025 (TG(20:0/20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012037 (TG(20:0/20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012176 (TG(18:1(9Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011988 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso3]); LMGL03011989 (TG(18:1(9Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03011981 (TG(20:2(11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011982 (TG(20:3(8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011986 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011987 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03012135 (TG(18:1(9Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012026 (TG(20:1(11Z)/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012186 (TG(18:0/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C65H112O6", "Glycerolipids [GL] with formula: C65H112O6"],
        "LMGL03012080 (TG(18:1(9Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012091 (TG(18:0/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011963 (TG(20:0/20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012123 (TG(18:0/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012058 (TG(18:1(9Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03011917 (TG(20:2(11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011916 (TG(20:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011918 (TG(20:3(8Z,11Z,14Z)/20:3(8Z,11Z,14Z)/22:0)[iso3]); LMGL03012068 (TG(18:1(9Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012069 (TG(18:2(9Z,12Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012079 (TG(18:0/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011974 (TG(20:0/20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012002 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03012003 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03012004 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/22:2(13Z,16Z))[iso3]); LMGL03011951 (TG(20:0/20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011952 (TG(20:1(11Z)/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03011925 (TG(18:0/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03011865 (TG(20:0/20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011922 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z))[iso6]); LMGL03011923 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03012250 (TG(19:0/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012116 (TG(18:3(9Z,12Z,15Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03011924 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011866 (TG(20:1(11Z)/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012168 (TG(18:2(9Z,12Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03011991 (TG(18:3(9Z,12Z,15Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011990 (TG(18:2(9Z,12Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6])": ["C65H114O6", "Glycerolipids [GL] with formula: C65H114O6"],
        "LMGL03012154 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/21:0)[iso3]); LMGL03011926 (TG(18:1(9Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011797 (TG(20:0/20:2(11Z,14Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011798 (TG(20:1(11Z)/20:1(11Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03011858 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/22:1(13Z))[iso3]); LMGL03011983 (TG(18:3(9Z,12Z,15Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012114 (TG(18:1(9Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012060 (TG(18:3(9Z,12Z,15Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03012059 (TG(18:2(9Z,12Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012008 (TG(18:0/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012009 (TG(18:1(9Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012020 (TG(18:0/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011927 (TG(18:2(9Z,12Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011940 (TG(20:0/20:3(8Z,11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011941 (TG(20:1(11Z)/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011898 (TG(20:0/20:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03011887 (TG(20:0/20:1(11Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012190 (TG(19:0/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03011850 (TG(20:1(11Z)/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011851 (TG(20:2(11Z,14Z)/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011856 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011857 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011849 (TG(20:0/20:5(5Z,8Z,11Z,14Z,17Z)/22:0)[iso6]); LMGL03011997 (TG(18:0/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6])": ["C65H116O6", "Glycerolipids [GL] with formula: C65H116O6"],
        "LMGL03011819 (TG(20:0/20:0/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012098 (TG(20:4(5Z,8Z,11Z,14Z)/21:0/21:0)[iso3]); LMGL03011782 (TG(20:2(11Z,14Z)/20:2(11Z,14Z)/22:0)[iso3]); LMGL03011780 (TG(20:0/20:4(5Z,8Z,11Z,14Z)/22:0)[iso6]); LMGL03011781 (TG(20:1(11Z)/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011788 (TG(20:0/20:3(8Z,11Z,14Z)/22:1(13Z))[iso6]); LMGL03011789 (TG(20:1(11Z)/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03012127 (TG(19:0/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012057 (TG(18:0/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03011919 (TG(18:2(9Z,12Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03011876 (TG(20:1(11Z)/20:1(11Z)/22:2(13Z,16Z))[iso3]); LMGL03011728 (TG(20:0/20:1(11Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011946 (TG(18:0/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03011875 (TG(20:0/20:2(11Z,14Z)/22:2(13Z,16Z))[iso6]); LMGL03011920 (TG(18:3(9Z,12Z,15Z)/22:0/22:1(13Z))[iso6]); LMGL03011861 (TG(18:1(9Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011860 (TG(18:0/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03011999 (TG(18:2(9Z,12Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03011998 (TG(18:1(9Z)/22:1(13Z)/22:2(13Z,16Z))[iso6])": ["C65H118O6", "Glycerolipids [GL] with formula: C65H118O6"],
        "LMGL03011935 (TG(18:0/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03011936 (TG(18:1(9Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03011792 (TG(18:0/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03011808 (TG(20:0/20:1(11Z)/22:2(13Z,16Z))[iso6]); LMGL03011657 (TG(20:0/20:0/22:3(10Z,13Z,16Z))[iso3]); LMGL03011847 (TG(18:3(9Z,12Z,15Z)/22:0/22:0)[iso3]); LMGL03011718 (TG(20:0/20:2(11Z,14Z)/22:1(13Z))[iso6]); LMGL03011719 (TG(20:1(11Z)/20:1(11Z)/22:1(13Z))[iso3]); LMGL03012039 (TG(20:3(8Z,11Z,14Z)/21:0/21:0)[iso3]); LMGL03011711 (TG(20:1(11Z)/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011710 (TG(20:0/20:3(8Z,11Z,14Z)/22:0)[iso6]); LMGL03011852 (TG(18:1(9Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03011853 (TG(18:2(9Z,12Z)/22:0/22:1(13Z))[iso6]); LMGL03011992 (TG(19:0/21:0/22:3(10Z,13Z,16Z))[iso6])": ["C65H120O6", "Glycerolipids [GL] with formula: C65H120O6"],
        "LMGL03011784 (TG(18:1(9Z)/22:0/22:1(13Z))[iso6]); LMGL03011783 (TG(18:0/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012061 (TG(19:0/21:0/22:2(13Z,16Z))[iso6]); LMGL03011976 (TG(20:2(11Z,14Z)/21:0/21:0)[iso3]); LMGL03011870 (TG(18:0/22:0/22:2(13Z,16Z))[iso6]); LMGL03011777 (TG(18:2(9Z,12Z)/22:0/22:0)[iso3]); LMGL03011739 (TG(20:0/20:0/22:2(13Z,16Z))[iso3]); LMGL03011638 (TG(20:0/20:2(11Z,14Z)/22:0)[iso6]); LMGL03011639 (TG(20:1(11Z)/20:1(11Z)/22:0)[iso3]); LMGL03011647 (TG(20:0/20:1(11Z)/22:1(13Z))[iso6])": ["C65H122O6", "Glycerolipids [GL] with formula: C65H122O6"],
        "LMGL03011565 (TG(20:0/20:1(11Z)/22:0)[iso6]); LMGL03011911 (TG(20:1(11Z)/21:0/21:0)[iso3]); LMGL03011574 (TG(20:0/20:0/22:1(13Z))[iso3]); LMGL03011706 (TG(18:1(9Z)/22:0/22:0)[iso3]); LMGL03011921 (TG(19:0/21:0/22:1(13Z))[iso6]); LMGL03011713 (TG(18:0/22:0/22:1(13Z))[iso6])": ["C65H124O6", "Glycerolipids [GL] with formula: C65H124O6"],
        "LMGL03011491 (TG(20:0/20:0/22:0)[iso3]); LMGL03011848 (TG(19:0/21:0/22:0)[iso6]); LMGL03011633 (TG(18:0/22:0/22:0)[iso3]); LMGL03011843 (TG(20:0/21:0/21:0)[iso3])": ["C65H126O6", "Glycerolipids [GL] with formula: C65H126O6"],
        "LMGL03012437 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C65H94O6", "Glycerolipids [GL] with formula: C65H94O6"],
        "LMGL03012407 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012457 (TG(18:3(9Z,12Z,15Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012398 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3])": ["C65H96O6", "Glycerolipids [GL] with formula: C65H96O6"],
        "LMGL03012364 (TG(20:4(5Z,8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012430 (TG(18:3(9Z,12Z,15Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012356 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012429 (TG(18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012373 (TG(20:3(8Z,11Z,14Z)/20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012374 (TG(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C65H98O6", "Glycerolipids [GL] with formula: C65H98O6"],
        "LMGL03012481 (TG(19:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C66H104O6", "Glycerolipids [GL] with formula: C66H104O6"],
        "LMGL03012458 (TG(19:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012464 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C66H106O6", "Glycerolipids [GL] with formula: C66H106O6"],
        "LMGL03012428 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012436 (TG(20:4(5Z,8Z,11Z,14Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012431 (TG(19:0/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012422 (TG(19:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3])": ["C66H108O6", "Glycerolipids [GL] with formula: C66H108O6"],
        "LMGL03012406 (TG(20:3(8Z,11Z,14Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012369 (TG(19:0/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012390 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012392 (TG(19:0/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012397 (TG(20:4(5Z,8Z,11Z,14Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C66H110O6", "Glycerolipids [GL] with formula: C66H110O6"],
        "LMGL03012402 (TG(19:0/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012363 (TG(20:3(8Z,11Z,14Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012305 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012322 (TG(19:0/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012355 (TG(20:4(5Z,8Z,11Z,14Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012350 (TG(19:0/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012372 (TG(20:2(11Z,14Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C66H112O6", "Glycerolipids [GL] with formula: C66H112O6"],
        "LMGL03012317 (TG(20:3(8Z,11Z,14Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012262 (TG(20:4(5Z,8Z,11Z,14Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012335 (TG(20:1(11Z)/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012333 (TG(19:0/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012325 (TG(20:2(11Z,14Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012272 (TG(19:0/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012359 (TG(19:0/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012349 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/22:2(13Z,16Z))[iso6])": ["C66H114O6", "Glycerolipids [GL] with formula: C66H114O6"],
        "LMGL03012310 (TG(20:4(5Z,8Z,11Z,14Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03012313 (TG(19:0/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012216 (TG(20:3(8Z,11Z,14Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012275 (TG(20:2(11Z,14Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012258 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/22:1(13Z))[iso6]); LMGL03012282 (TG(19:0/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012284 (TG(20:1(11Z)/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012294 (TG(20:0/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012293 (TG(19:0/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012162 (TG(19:0/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3])": ["C66H116O6", "Glycerolipids [GL] with formula: C66H116O6"],
        "LMGL03012228 (TG(19:0/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012219 (TG(19:0/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012230 (TG(20:1(11Z)/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012239 (TG(20:0/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012238 (TG(19:0/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012208 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/21:0/22:0)[iso6]); LMGL03012211 (TG(20:4(5Z,8Z,11Z,14Z)/21:0/22:1(13Z))[iso6]); LMGL03012268 (TG(20:3(8Z,11Z,14Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03012165 (TG(20:2(11Z,14Z)/21:0/22:3(10Z,13Z,16Z))[iso6])": ["C66H118O6", "Glycerolipids [GL] with formula: C66H118O6"],
        "LMGL03012156 (TG(20:4(5Z,8Z,11Z,14Z)/21:0/22:0)[iso6]); LMGL03012222 (TG(20:2(11Z,14Z)/21:0/22:2(13Z,16Z))[iso6]); LMGL03012111 (TG(20:1(11Z)/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012264 (TG(19:0/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012109 (TG(19:0/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012179 (TG(19:0/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012180 (TG(20:0/21:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012160 (TG(20:3(8Z,11Z,14Z)/21:0/22:1(13Z))[iso6])": ["C66H120O6", "Glycerolipids [GL] with formula: C66H120O6"],
        "LMGL03012053 (TG(20:0/21:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012052 (TG(19:0/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012101 (TG(20:3(8Z,11Z,14Z)/21:0/22:0)[iso6]); LMGL03012105 (TG(20:2(11Z,14Z)/21:0/22:1(13Z))[iso6]); LMGL03012170 (TG(19:0/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012172 (TG(20:1(11Z)/21:0/22:2(13Z,16Z))[iso6])": ["C66H122O6", "Glycerolipids [GL] with formula: C66H122O6"],
        "LMGL03012045 (TG(19:0/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012047 (TG(20:1(11Z)/21:0/22:1(13Z))[iso6]); LMGL03012042 (TG(20:2(11Z,14Z)/21:0/22:0)[iso6]); LMGL03012118 (TG(20:0/21:0/22:2(13Z,16Z))[iso6]); LMGL03012117 (TG(19:0/22:0/22:2(13Z,16Z))[iso6])": ["C66H124O6", "Glycerolipids [GL] with formula: C66H124O6"],
        "LMGL03011980 (TG(20:1(11Z)/21:0/22:0)[iso6]); LMGL03011984 (TG(19:0/22:0/22:1(13Z))[iso6]); LMGL03011985 (TG(20:0/21:0/22:1(13Z))[iso6])": ["C66H126O6", "Glycerolipids [GL] with formula: C66H126O6"],
        "LMGL03012206 (TG(21:0/21:0/21:0)); LMGL03011915 (TG(20:0/21:0/22:0)[iso6]); LMGL03011914 (TG(19:0/22:0/22:0)[iso3])": ["C66H128O6", "Glycerolipids [GL] with formula: C66H128O6"],
        "LMGL03012549 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012554 (TG(20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012555 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012553 (TG(20:3(8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C67H100O6", "Glycerolipids [GL] with formula: C67H100O6"],
        "LMGL03012541 (TG(20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012540 (TG(20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012539 (TG(20:2(11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012534 (TG(20:4(5Z,8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012535 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012526 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C67H102O6", "Glycerolipids [GL] with formula: C67H102O6"],
        "LMGL03012542 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012524 (TG(20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012523 (TG(20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012513 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012517 (TG(20:3(8Z,11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012518 (TG(20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012522 (TG(20:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012507 (TG(20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012500 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C67H104O6", "Glycerolipids [GL] with formula: C67H104O6"],
        "LMGL03012485 (TG(20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012472 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012478 (TG(20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012498 (TG(20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012497 (TG(20:2(11Z,14Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012493 (TG(20:4(5Z,8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012525 (TG(20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012519 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012508 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012505 (TG(20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012504 (TG(20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012503 (TG(20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C67H106O6", "Glycerolipids [GL] with formula: C67H106O6"],
        "LMGL03012409 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012453 (TG(20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012447 (TG(20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012461 (TG(20:2(11Z,14Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012486 (TG(20:4(5Z,8Z,11Z,14Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012487 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012482 (TG(20:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012483 (TG(20:1(11Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012470 (TG(20:3(8Z,11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012475 (TG(20:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012476 (TG(20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012479 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012499 (TG(20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012494 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012506 (TG(20:3(8Z,11Z,14Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C67H108O6", "Glycerolipids [GL] with formula: C67H108O6"],
        "LMGL03012418 (TG(20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012454 (TG(20:4(5Z,8Z,11Z,14Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012455 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012433 (TG(20:1(11Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012451 (TG(20:1(11Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012445 (TG(20:2(11Z,14Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012462 (TG(20:3(8Z,11Z,14Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012463 (TG(20:4(5Z,8Z,11Z,14Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012484 (TG(20:2(11Z,14Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012471 (TG(20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012477 (TG(20:3(8Z,11Z,14Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012450 (TG(20:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012459 (TG(20:0/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012442 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012448 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012425 (TG(20:2(11Z,14Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012377 (TG(20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3])": ["C67H110O6", "Glycerolipids [GL] with formula: C67H110O6"],
        "LMGL03012403 (TG(20:0/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012419 (TG(20:4(5Z,8Z,11Z,14Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012452 (TG(20:2(11Z,14Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012435 (TG(20:3(8Z,11Z,14Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012434 (TG(20:2(11Z,14Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012467 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012460 (TG(20:1(11Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012413 (TG(20:4(5Z,8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012423 (TG(20:0/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012394 (TG(20:1(11Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012416 (TG(20:1(11Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012341 (TG(20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012387 (TG(20:2(11Z,14Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012446 (TG(20:3(8Z,11Z,14Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012420 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012427 (TG(20:4(5Z,8Z,11Z,14Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012426 (TG(20:3(8Z,11Z,14Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012378 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6])": ["C67H112O6", "Glycerolipids [GL] with formula: C67H112O6"],
        "LMGL03012404 (TG(20:1(11Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012405 (TG(20:2(11Z,14Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012360 (TG(20:0/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012302 (TG(20:2(11Z,14Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012432 (TG(20:0/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012395 (TG(20:2(11Z,14Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012414 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012396 (TG(20:3(8Z,11Z,14Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012417 (TG(20:2(11Z,14Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012381 (TG(20:3(8Z,11Z,14Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012385 (TG(20:0/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012388 (TG(20:3(8Z,11Z,14Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012441 (TG(20:4(5Z,8Z,11Z,14Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012352 (TG(20:1(11Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012389 (TG(20:4(5Z,8Z,11Z,14Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012424 (TG(20:1(11Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012343 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012342 (TG(20:4(5Z,8Z,11Z,14Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6])": ["C67H114O6", "Glycerolipids [GL] with formula: C67H114O6"],
        "LMGL03012361 (TG(20:1(11Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012362 (TG(20:2(11Z,14Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012314 (TG(20:0/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012303 (TG(20:3(8Z,11Z,14Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012304 (TG(20:4(5Z,8Z,11Z,14Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012339 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012412 (TG(20:3(8Z,11Z,14Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012393 (TG(20:0/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012383 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03012382 (TG(20:4(5Z,8Z,11Z,14Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012386 (TG(20:1(11Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012259 (TG(20:1(11Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012354 (TG(20:3(8Z,11Z,14Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012353 (TG(20:2(11Z,14Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012346 (TG(20:2(11Z,14Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012370 (TG(20:0/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012371 (TG(20:1(11Z)/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C67H116O6", "Glycerolipids [GL] with formula: C67H116O6"],
        "LMGL03012316 (TG(20:2(11Z,14Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012213 (TG(20:0/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012300 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:0/22:1(13Z))[iso6]); LMGL03012307 (TG(20:1(11Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012323 (TG(20:0/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012324 (TG(20:1(11Z)/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012260 (TG(20:2(11Z,14Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012261 (TG(20:3(8Z,11Z,14Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012488 (TG(21:0/21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012380 (TG(20:2(11Z,14Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012334 (TG(20:0/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012347 (TG(20:3(8Z,11Z,14Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012299 (TG(20:4(5Z,8Z,11Z,14Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012351 (TG(20:0/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012315 (TG(20:1(11Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012348 (TG(20:4(5Z,8Z,11Z,14Z)/22:0/22:2(13Z,16Z))[iso6])": ["C67H118O6", "Glycerolipids [GL] with formula: C67H118O6"],
        "LMGL03012309 (TG(20:3(8Z,11Z,14Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03012308 (TG(20:2(11Z,14Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012456 (TG(21:0/21:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012215 (TG(20:2(11Z,14Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012214 (TG(20:1(11Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012265 (TG(20:0/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012273 (TG(20:0/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012274 (TG(20:1(11Z)/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012254 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:0/22:0)[iso3]); LMGL03012257 (TG(20:4(5Z,8Z,11Z,14Z)/22:0/22:1(13Z))[iso6]); LMGL03012256 (TG(20:3(8Z,11Z,14Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012283 (TG(20:0/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012345 (TG(20:1(11Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3])": ["C67H120O6", "Glycerolipids [GL] with formula: C67H120O6"],
        "LMGL03012229 (TG(20:0/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012306 (TG(20:0/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012207 (TG(20:4(5Z,8Z,11Z,14Z)/22:0/22:0)[iso3]); LMGL03012209 (TG(20:2(11Z,14Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012210 (TG(20:3(8Z,11Z,14Z)/22:0/22:1(13Z))[iso6]); LMGL03012266 (TG(20:1(11Z)/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012267 (TG(20:2(11Z,14Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03012421 (TG(21:0/21:0/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012164 (TG(20:1(11Z)/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012163 (TG(20:0/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6])": ["C67H122O6", "Glycerolipids [GL] with formula: C67H122O6"],
        "LMGL03012158 (TG(20:1(11Z)/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012159 (TG(20:2(11Z,14Z)/22:0/22:1(13Z))[iso6]); LMGL03012155 (TG(20:3(8Z,11Z,14Z)/22:0/22:0)[iso3]); LMGL03012220 (TG(20:0/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012221 (TG(20:1(11Z)/22:0/22:2(13Z,16Z))[iso6]); LMGL03012110 (TG(20:0/22:0/22:3(10Z,13Z,16Z))[iso6]); LMGL03012344 (TG(21:0/21:0/22:3(10Z,13Z,16Z))[iso3])": ["C67H124O6", "Glycerolipids [GL] with formula: C67H124O6"],
        "LMGL03012103 (TG(20:0/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012100 (TG(20:2(11Z,14Z)/22:0/22:0)[iso3]); LMGL03012104 (TG(20:1(11Z)/22:0/22:1(13Z))[iso6]); LMGL03012384 (TG(21:0/21:0/22:2(13Z,16Z))[iso3]); LMGL03012171 (TG(20:0/22:0/22:2(13Z,16Z))[iso6])": ["C67H126O6", "Glycerolipids [GL] with formula: C67H126O6"],
        "LMGL03012046 (TG(20:0/22:0/22:1(13Z))[iso6]); LMGL03012041 (TG(20:1(11Z)/22:0/22:0)[iso3]); LMGL03012301 (TG(21:0/21:0/22:1(13Z))[iso3])": ["C67H128O6", "Glycerolipids [GL] with formula: C67H128O6"],
        "LMGL03011979 (TG(20:0/22:0/22:0)[iso3]); LMGL03012255 (TG(21:0/21:0/22:0)[iso3])": ["C67H130O6", "Glycerolipids [GL] with formula: C67H130O6"],
        "LMGL03012576 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C67H96O6", "Glycerolipids [GL] with formula: C67H96O6"],
        "LMGL03012567 (TG(20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012566 (TG(20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C67H98O6", "Glycerolipids [GL] with formula: C67H98O6"],
        "LMGL03012585 (TG(21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C68H108O6", "Glycerolipids [GL] with formula: C68H108O6"],
        "LMGL03012577 (TG(21:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C68H110O6", "Glycerolipids [GL] with formula: C68H110O6"],
        "LMGL03012568 (TG(21:0/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012562 (TG(21:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3])": ["C68H112O6", "Glycerolipids [GL] with formula: C68H112O6"],
        "LMGL03012543 (TG(21:0/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012550 (TG(21:0/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C68H114O6", "Glycerolipids [GL] with formula: C68H114O6"],
        "LMGL03012531 (TG(21:0/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012556 (TG(21:0/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012520 (TG(21:0/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C68H116O6", "Glycerolipids [GL] with formula: C68H116O6"],
        "LMGL03012495 (TG(21:0/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012536 (TG(21:0/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012527 (TG(21:0/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C68H118O6", "Glycerolipids [GL] with formula: C68H118O6"],
        "LMGL03012439 (TG(21:0/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012514 (TG(21:0/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012509 (TG(21:0/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012501 (TG(21:0/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C68H120O6", "Glycerolipids [GL] with formula: C68H120O6"],
        "LMGL03012468 (TG(21:0/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012480 (TG(21:0/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012473 (TG(21:0/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6])": ["C68H122O6", "Glycerolipids [GL] with formula: C68H122O6"],
        "LMGL03012490 (TG(21:0/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012449 (TG(21:0/22:0/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012410 (TG(21:0/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6])": ["C68H124O6", "Glycerolipids [GL] with formula: C68H124O6"],
        "LMGL03012443 (TG(21:0/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012379 (TG(21:0/22:0/22:3(10Z,13Z,16Z))[iso6])": ["C68H126O6", "Glycerolipids [GL] with formula: C68H126O6"],
        "LMGL03012415 (TG(21:0/22:0/22:2(13Z,16Z))[iso6]); LMGL03012375 (TG(21:0/22:1(13Z)/22:1(13Z))[iso3])": ["C68H128O6", "Glycerolipids [GL] with formula: C68H128O6"],
        "LMGL03012340 (TG(21:0/22:0/22:1(13Z))[iso6])": ["C68H130O6", "Glycerolipids [GL] with formula: C68H130O6"],
        "LMGL03012298 (TG(21:0/22:0/22:0)[iso3])": ["C68H132O6", "Glycerolipids [GL] with formula: C68H132O6"],
        "LMGL03012610 (TG(22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C69H100O6", "Glycerolipids [GL] with formula: C69H100O6"],
        "LMGL03012608 (TG(22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012609 (TG(22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C69H102O6", "Glycerolipids [GL] with formula: C69H102O6"],
        "LMGL03012607 (TG(22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012602 (TG(22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012605 (TG(22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z)))": ["C69H104O6", "Glycerolipids [GL] with formula: C69H104O6"],
        "LMGL03012606 (TG(22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012604 (TG(22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012601 (TG(22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012599 (TG(22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C69H106O6", "Glycerolipids [GL] with formula: C69H106O6"],
        "LMGL03012603 (TG(22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012598 (TG(22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012590 (TG(22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012597 (TG(22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012594 (TG(22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C69H108O6", "Glycerolipids [GL] with formula: C69H108O6"],
        "LMGL03012592 (TG(22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012593 (TG(22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012596 (TG(22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012580 (TG(22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012583 (TG(22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012589 (TG(22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))); LMGL03012600 (TG(22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C69H110O6", "Glycerolipids [GL] with formula: C69H110O6"],
        "LMGL03012571 (TG(22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012565 (TG(22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012591 (TG(22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012587 (TG(22:1(13Z)/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012586 (TG(22:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012582 (TG(22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012588 (TG(22:3(10Z,13Z,16Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6])": ["C69H112O6", "Glycerolipids [GL] with formula: C69H112O6"],
        "LMGL03012578 (TG(22:0/22:4(7Z,10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012570 (TG(22:1(13Z)/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012573 (TG(22:0/22:5(7Z,10Z,13Z,16Z,19Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012574 (TG(22:1(13Z)/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012575 (TG(22:3(10Z,13Z,16Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012548 (TG(22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012595 (TG(22:2(13Z,16Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012581 (TG(22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3])": ["C69H114O6", "Glycerolipids [GL] with formula: C69H114O6"],
        "LMGL03012579 (TG(22:1(13Z)/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012563 (TG(22:0/22:4(7Z,10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012561 (TG(22:3(10Z,13Z,16Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012560 (TG(22:1(13Z)/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012510 (TG(22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))); LMGL03012584 (TG(22:2(13Z,16Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012557 (TG(22:0/22:3(10Z,13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012552 (TG(22:1(13Z)/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6])": ["C69H116O6", "Glycerolipids [GL] with formula: C69H116O6"],
        "LMGL05010015 (DGDG(18:2(9Z,12Z)/18:2(9Z,12Z)[15(R)OH-18:2(9Z,12Z]))": ["C69H118O17", "Glycerolipids [GL] with formula: C69H118O17"],
        "LMGL03012572 (TG(22:2(13Z,16Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012569 (TG(22:0/22:2(13Z,16Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012564 (TG(22:1(13Z)/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012546 (TG(22:0/22:4(7Z,10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012537 (TG(22:0/22:3(10Z,13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012530 (TG(22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012533 (TG(22:1(13Z)/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012558 (TG(22:1(13Z)/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3])": ["C69H118O6", "Glycerolipids [GL] with formula: C69H118O6"],
        "LMGL03012545 (TG(22:3(10Z,13Z,16Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012544 (TG(22:0/22:1(13Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012547 (TG(22:1(13Z)/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012489 (TG(22:1(13Z)/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012538 (TG(22:1(13Z)/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012551 (TG(22:0/22:2(13Z,16Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012515 (TG(22:0/22:3(10Z,13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6])": ["C69H120O6", "Glycerolipids [GL] with formula: C69H120O6"],
        "LMGL03012559 (TG(22:2(13Z,16Z)/22:2(13Z,16Z)/22:2(13Z,16Z))); LMGL03012465 (TG(22:0/22:3(10Z,13Z,16Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012532 (TG(22:0/22:2(13Z,16Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012521 (TG(22:0/22:1(13Z)/22:5(7Z,10Z,13Z,16Z,19Z))[iso6]); LMGL03012528 (TG(22:0/22:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[iso3]); LMGL03012512 (TG(22:1(13Z)/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012516 (TG(22:1(13Z)/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso3])": ["C69H122O6", "Glycerolipids [GL] with formula: C69H122O6"],
        "LMGL03012466 (TG(22:1(13Z)/22:1(13Z)/22:3(10Z,13Z,16Z))[iso3]); LMGL03012496 (TG(22:0/22:1(13Z)/22:4(7Z,10Z,13Z,16Z))[iso6]); LMGL03012491 (TG(22:0/22:3(10Z,13Z,16Z)/22:2(13Z,16Z))[iso6]); LMGL03012529 (TG(22:1(13Z)/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3]); LMGL03012502 (TG(22:0/22:0/22:5(7Z,10Z,13Z,16Z,19Z))[iso3])": ["C69H124O6", "Glycerolipids [GL] with formula: C69H124O6"],
        "LMGL03012440 (TG(22:0/22:1(13Z)/22:3(10Z,13Z,16Z))[iso6]); LMGL03012474 (TG(22:0/22:0/22:4(7Z,10Z,13Z,16Z))[iso3]); LMGL03012492 (TG(22:1(13Z)/22:1(13Z)/22:2(13Z,16Z))[iso3]); LMGL03012511 (TG(22:0/22:2(13Z,16Z)/22:2(13Z,16Z))[iso3])": ["C69H126O6", "Glycerolipids [GL] with formula: C69H126O6"],
        "LMGL03012438 (TG(22:1(13Z)/22:1(13Z)/22:1(13Z))); LMGL03012469 (TG(22:0/22:1(13Z)/22:2(13Z,16Z))[iso6]); LMGL03012411 (TG(22:0/22:0/22:3(10Z,13Z,16Z))[iso3])": ["C69H128O6", "Glycerolipids [GL] with formula: C69H128O6"],
        "LMGL03012408 (TG(22:0/22:1(13Z)/22:1(13Z))[iso3]); LMGL03012444 (TG(22:0/22:0/22:2(13Z,16Z))[iso3])": ["C69H130O6", "Glycerolipids [GL] with formula: C69H130O6"],
        "LMGL03012376 (TG(22:0/22:0/22:1(13Z))[iso3])": ["C69H132O6", "Glycerolipids [GL] with formula: C69H132O6"],
        "LMGL03012338 (TG(22:0/22:0/22:0))": ["C69H134O6", "Glycerolipids [GL] with formula: C69H134O6"],
        "LMGL03012611 (TG(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C69H98O6", "Glycerolipids [GL] with formula: C69H98O6"],
        "LMGL02050004 (Crenarchaeol)": ["C82H154O6", "Glycerolipids [GL] with formula: C82H154O6"],
        "LMGL02050003 (Isocaldarchaeol); LMGL02050002": ["C86H172O6", "Glycerolipids [GL] with formula: C86H172O6"],
        "LMGL02060006 (Calditoglycerocaldachaeol)": ["C92H182O11", "Glycerolipids [GL] with formula: C92H182O11"],
        "LMGL02060005": ["C98H192O16", "Glycerolipids [GL] with formula: C98H192O16"],
        "LMGL05030005": ["C99H197O21PS", "Glycerolipids [GL] with formula: C99H197O21PS"],
        "LMGL03012615 (Triacetin)": ["C9H14O6", "Glycerolipids [GL] with formula: C9H14O6"],
        "LMGL01020029 (2-Hexylglycerol); LMGL01020028 (1-Hexylglycerol)": ["C9H20O3", "Glycerolipids [GL] with formula: C9H20O3"],
    },
    'Glycerophospholipids [GP]': {
        "LMGP01010000 (PC)": ["C10H18NO8P", "Glycerophospholipids [GP] with formula: C10H18NO8P"],
        "LMGP01050084 (PC(0:0/2:0)); LMGP01050085 (PC(0:0/2:0)[U]); LMGP01050043 (PC(2:0/0:0)); LMGP01050044 (PC(2:0/0:0)[U])": ["C10H22NO7P", "Glycerophospholipids [GP] with formula: C10H22NO7P"],
        "LMGP01050088 (PC(0:0/3:1(2E))); LMGP01050060 (PC(3:1(2E)/0:0)[U])": ["C11H22NO7P", "Glycerophospholipids [GP] with formula: C11H22NO7P"],
        "LMGP01010988 (PC(2:0/1:0)[U])": ["C11H22NO8P", "Glycerophospholipids [GP] with formula: C11H22NO8P"],
        "LMGP01050086 (PC(0:0/3:0)); LMGP01050087 (PC(0:0/3:0)[U]); LMGP01050059 (PC(3:0/0:0)); LMGP01020006 (PC(O-1:0/2:0)[U]); LMGP01020005 (PC(O-1:0/2:0))": ["C11H24NO7P", "Glycerophospholipids [GP] with formula: C11H24NO7P"],
        "LMGP01040067 (PC(O-2:0/O-1:0))": ["C11H26NO6P", "Glycerophospholipids [GP] with formula: C11H26NO6P"],
        "LMGP01010994 (PC(2:0/2:0)[U]); LMGP01010992 (PC(2:0/2:0)); LMGP01010993 (PC(2:0/2:0)[S])": ["C12H24NO8P", "Glycerophospholipids [GP] with formula: C12H24NO8P"],
        "LMGP01050089 (PC(0:0/4:0)); LMGP01050090 (PC(0:0/4:0)[U]); LMGP01050061 (PC(4:0/0:0)); LMGP01020121 (PC(O-2:0/2:0))": ["C12H26NO7P", "Glycerophospholipids [GP] with formula: C12H26NO7P"],
        "LMGP01060019 (PC(O-4:0/0:0)[U]); LMGP01040069 (PC(O-2:0/O-2:0))": ["C12H28NO6P", "Glycerophospholipids [GP] with formula: C12H28NO6P"],
        "LMGP01011214 (PC(3:0/2:0)[U])": ["C13H26NO8P", "Glycerophospholipids [GP] with formula: C13H26NO8P"],
        "LMGP01050092 (PC(0:0/5:0)[U]); LMGP01050091 (PC(0:0/5:0))": ["C13H28NO7P", "Glycerophospholipids [GP] with formula: C13H28NO7P"],
        "LMGP01060020 (PC(O-5:0/0:0)[R])": ["C13H30NO6P", "Glycerophospholipids [GP] with formula: C13H30NO6P"],
        "LMGP01011216 (PC(3:0/3:0)[U]); LMGP01011215 (PC(3:0/3:0))": ["C14H28NO8P", "Glycerophospholipids [GP] with formula: C14H28NO8P"],
        "LMGP01050094 (PC(0:0/6:0)[U]); LMGP01050093 (PC(0:0/6:0)); LMGP01050062 (PC(6:0/0:0)); LMGP01050063 (PC(6:0/0:0)[U]); LMGP01020126 (PC(O-4:0/2:0)[U])": ["C14H30NO7P", "Glycerophospholipids [GP] with formula: C14H30NO7P"],
        "LMGP01060021 (PC(O-6:0/0:0)[U])": ["C14H32NO6P", "Glycerophospholipids [GP] with formula: C14H32NO6P"],
        "LMGP10010020 (PA(6:0/6:0))": ["C15H29O8P", "Glycerophospholipids [GP] with formula: C15H29O8P"],
        "LMGP01050065 (PC(7:0/0:0)[U]); LMGP01050096 (PC(0:0/7:0)[U]); LMGP01050095 (PC(0:0/7:0)); LMGP01050064 (PC(7:0/0:0))": ["C15H32NO7P", "Glycerophospholipids [GP] with formula: C15H32NO7P"],
        "LMGP01011223 (PC(4:0/4:0)[U]); LMGP01011222 (PC(4:0/4:0))": ["C16H32NO8P", "Glycerophospholipids [GP] with formula: C16H32NO8P"],
        "LMGP01050097 (PC(0:0/8:0)[U]); LMGP01050066 (PC(8:0/0:0)); LMGP01050067 (PC(8:0/0:0)[U]); LMGP01020127 (PC(O-6:0/2:0)[U])": ["C16H34NO7P", "Glycerophospholipids [GP] with formula: C16H34NO7P"],
        "LMGP10050001 (PA(13:0/0:0))": ["C16H36NO7P", "Glycerophospholipids [GP] with formula: C16H36NO7P"],
        "LMGP02010104 (PE(6:0/6:0)); LMGP02010105 (PE(6:0/6:0)[U])": ["C17H34NO8P", "Glycerophospholipids [GP] with formula: C17H34NO8P"],
        "LMGP10050007 (PA(14:0/0:0)); LMGP10050009 (PA(14:0/0:0)[U])": ["C17H35O7P", "Glycerophospholipids [GP] with formula: C17H35O7P"],
        "LMGP02050005 (PE(12:0/0:0)); LMGP01050098 (PC(0:0/9:0)[U]); LMGP01050068 (PC(9:0/0:0)); LMGP01050069 (PC(9:0/0:0)[U])": ["C17H36NO7P", "Glycerophospholipids [GP] with formula: C17H36NO7P"],
        "LMGP01040082 (PC(O-8:0/O-1:0)[U])": ["C17H38NO6P", "Glycerophospholipids [GP] with formula: C17H38NO6P"],
        "LMGP03010026 (PS(6:0/6:0)[U]); LMGP03010020 (PS(6:0/6:0))": ["C18H34NO10P", "Glycerophospholipids [GP] with formula: C18H34NO10P"],
        "LMGP04010030 (PG(6:0/6:0)); LMGP04010018 (PG(6:0/6:0)[U])": ["C18H35O10P", "Glycerophospholipids [GP] with formula: C18H35O10P"],
        "LMGP01011226 (PC(5:0/5:0)[U]); LMGP01011225 (PC(5:0/5:0))": ["C18H36NO8P", "Glycerophospholipids [GP] with formula: C18H36NO8P"],
        "LMGP01060027 (PC(O-10:1(9E)/0:0))": ["C18H38NO6P", "Glycerophospholipids [GP] with formula: C18H38NO6P"],
        "LMGP02050007 (PE(13:0/0:0)); LMGP01050070 (PC(0:0/10:0)[U]); LMGP01050005 (PC(10:0/0:0)); LMGP01050006 (PC(10:0/0:0)[U]); LMGP01020129 (PC(O-8:0/2:0))": ["C18H38NO7P", "Glycerophospholipids [GP] with formula: C18H38NO7P"],
        "LMGP01040086 (PC(O-9:0/O-1:0)[U])": ["C18H40NO6P", "Glycerophospholipids [GP] with formula: C18H40NO6P"],
        "LMGP10050012 (PA(16:0/0:0)[cyclic])": ["C19H37O6P", "Glycerophospholipids [GP] with formula: C19H37O6P"],
        "LMGP10010021 (PA(8:0/8:0))": ["C19H37O8P", "Glycerophospholipids [GP] with formula: C19H37O8P"],
        "LMGP03050005 (PS(13:0/0:0))": ["C19H38NO9P", "Glycerophospholipids [GP] with formula: C19H38NO9P"],
        "LMGP10050006 (PA(16:0/0:0)); LMGP10050010 (PA(16:0/0:0)[U])": ["C19H39O7P", "Glycerophospholipids [GP] with formula: C19H39O7P"],
        "LMGP04050007 (PG(13:0/0:0))": ["C19H39O9P", "Glycerophospholipids [GP] with formula: C19H39O9P"],
        "LMGP02050003 (PE(14:0/0:0)); LMGP01050007 (PC(11:0/0:0)); LMGP01050071 (PC(0:0/11:0)[U]); LMGP01050008 (PC(11:0/0:0)[U])": ["C19H40NO7P", "Glycerophospholipids [GP] with formula: C19H40NO7P"],
        "LMGP01011235 (PC(6:2(2E,4E)/6:2(2E,4E)))": ["C20H32NO8P", "Glycerophospholipids [GP] with formula: C20H32NO8P"],
        "LMGP01020145 (PC(O-10:1(9E)/2:0))": ["C20H40NO7P", "Glycerophospholipids [GP] with formula: C20H40NO7P"],
        "LMGP01011230 (PC(6:0/6:0)[S]); LMGP01011231 (PC(6:0/6:0)[U]); LMGP01011229 (PC(6:0/6:0))": ["C20H40NO8P", "Glycerophospholipids [GP] with formula: C20H40NO8P"],
        "LMGP04050001 (PG(14:0/0:0)[U])": ["C20H41O9P", "Glycerophospholipids [GP] with formula: C20H41O9P"],
        "LMGP10050002 (PA(17:1(9Z)/0:0)); LMGP01050072 (PC(0:0/12:0)[U]); LMGP01080028 (PC(6:0/O-6:0)[U]); LMGP01050010 (PC(12:0/0:0)[U]); LMGP01020007 (PC(O-10:0/2:0)[U]); LMGP01050009 (PC(12:0/0:0)); LMGP01020128 (PC(O-6:0/6:0)[U])": ["C20H42NO7P", "Glycerophospholipids [GP] with formula: C20H42NO7P"],
        "LMGP01060006 (PC(O-12:0/0:0)[U]); LMGP01040078 (PC(O-6:0/O-6:0)); LMGP01040079 (PC(O-6:0/O-6:0)[U])": ["C20H44NO6P", "Glycerophospholipids [GP] with formula: C20H44NO6P"],
        "LMGP00000056 (CPA(18:1(9Z)))": ["C21H39O6P", "Glycerophospholipids [GP] with formula: C21H39O6P"],
        "LMGP00000055 (CPA(18:0))": ["C21H41O6P", "Glycerophospholipids [GP] with formula: C21H41O6P"],
        "LMGP10050008 (PA(18:1(9Z)/0:0)); LMGP10050011 (PA(18:1(9Z)/0:0)[U]); LMGP10050014 (PA(0:0/18:1(9Z)))": ["C21H41O7P", "Glycerophospholipids [GP] with formula: C21H41O7P"],
        "LMGP01020146 (PC(O-11:1(10E)/2:0))": ["C21H42NO7P", "Glycerophospholipids [GP] with formula: C21H42NO7P"],
        "LMGP02010102 (PE(8:0/8:0)); LMGP02010103 (PE(8:0/8:0)[U]); LMGP01011247 (PC(8:0/5:0)[U]); LMGP01011232 (PC(6:0/7:0)[U])": ["C21H42NO8P", "Glycerophospholipids [GP] with formula: C21H42NO8P"],
        "LMGP10050005 (PA(18:0/0:0))": ["C21H43O7P", "Glycerophospholipids [GP] with formula: C21H43O7P"],
        "LMGP02070001 (PE(P-16:0/0:0))": ["C21H44NO6P", "Glycerophospholipids [GP] with formula: C21H44NO6P"],
        "LMGP02050002 (PE(16:0/0:0)); LMGP01050011 (PC(13:0/0:0)[U]); LMGP01050001 (PC(13:0/0:0))": ["C21H44NO7P", "Glycerophospholipids [GP] with formula: C21H44NO7P"],
        "LMGP01040013 (PC(O-12:0/O-1:0)); LMGP01040014 (PC(O-12:0/O-1:0)[U]); LMGP02060002 (PE(O-16:0/0:0))": ["C21H46NO6P", "Glycerophospholipids [GP] with formula: C21H46NO6P"],
        "LMGP03010021 (PS(8:0/8:0))": ["C22H42NO10P", "Glycerophospholipids [GP] with formula: C22H42NO10P"],
        "LMGP10050004 (PA(19:3(10Z,13Z,16Z)/0:0))": ["C22H42NO7P", "Glycerophospholipids [GP] with formula: C22H42NO7P"],
        "LMGP04010031 (PG(8:0/8:0)); LMGP04010019 (PG(8:0/8:0)[U])": ["C22H43O10P", "Glycerophospholipids [GP] with formula: C22H43O10P"],
        "LMGP06050001 (PI(13:0/0:0))": ["C22H43O12P", "Glycerophospholipids [GP] with formula: C22H43O12P"],
        "LMGP02050008 (PE(17:1(9Z)/0:0)); LMGP01050015 (PC(14:2(Z)l8,8/0:0)[U]); LMGP01050014 (PC(14:1(9Z)/0:0))": ["C22H44NO7P", "Glycerophospholipids [GP] with formula: C22H44NO7P"],
        "LMGP01010443 (PC(12:0/2:0)); LMGP01011269 (PC(9:0/5:0)); LMGP01011240 (PC(7:0/7:0)[U]); LMGP01011249 (PC(8:0/6:0)[U]); LMGP01011248 (PC(8:0/6:0)); LMGP01011233 (PC(6:0/8:0)); LMGP01011234 (PC(6:0/8:0)[U]); LMGP01011238 (PC(7:0/7:0)); LMGP01011239 (PC(7:0/7:0)[S]); LMGP01010403 (PC(10:0/4:0))": ["C22H44NO8P", "Glycerophospholipids [GP] with formula: C22H44NO8P"],
        "LMGP03050002 (PS(16:0/0:0))": ["C22H44NO9P", "Glycerophospholipids [GP] with formula: C22H44NO9P"],
        "LMGP04050008 (PG(16:0/0:0)); LMGP04050002 (PG(16:0/0:0)[U])": ["C22H45O9P", "Glycerophospholipids [GP] with formula: C22H45O9P"],
        "LMGP01070002 (PC(P-14:0/0:0)); LMGP01070001 (PC(O-14:1(1E)/0:0))": ["C22H46NO6P", "Glycerophospholipids [GP] with formula: C22H46NO6P"],
        "LMGP01050073 (PC(0:0/14:0)); LMGP01050012 (PC(14:0/0:0)); LMGP01050013 (PC(14:0/0:0)[U]); LMGP01020009 (PC(O-12:0/2:0)); LMGP01020010 (PC(O-12:0/2:0)[U])": ["C22H46NO7P", "Glycerophospholipids [GP] with formula: C22H46NO7P"],
        "LMGP01040081 (PC(O-7:0/O-7:0)[U]); LMGP01040080 (PC(O-7:0/O-7:0)); LMGP01060007 (PC(O-14:0/0:0)); LMGP01060008 (PC(O-14:0/0:0)[U]); LMGP01040020 (PC(O-13:0/O-1:0)[U]); LMGP01040017 (PC(O-12:0/O-2:0))": ["C22H48NO6P", "Glycerophospholipids [GP] with formula: C22H48NO6P"],
        "LMGP10050013 (PA(20:4(5Z,8Z,11Z,14Z)/0:0))": ["C23H39O7P", "Glycerophospholipids [GP] with formula: C23H39O7P"],
        "LMGP10060002 (sn-3-O-(geranylgeranyl)glycerol 1-phosphate)": ["C23H41O6P", "Glycerophospholipids [GP] with formula: C23H41O6P"],
        "LMGP10010022 (PA(10:0/10:0)); LMGP10010029 (PA(10:0/10:0)[U])": ["C23H45O8P", "Glycerophospholipids [GP] with formula: C23H45O8P"],
        "LMGP02050006 (PE(18:1(9Z)/0:0)[U]); LMGP02050004 (PE(18:1(9Z)/0:0))": ["C23H46NO7P", "Glycerophospholipids [GP] with formula: C23H46NO7P"],
        "LMGP02010285 (PE(9:0/9:0)[U]); LMGP01011241 (PC(7:0/8:0)[U]); LMGP01011250 (PC(8:0/7:0)[U])": ["C23H46NO8P", "Glycerophospholipids [GP] with formula: C23H46NO8P"],
        "LMGP01070003 (PC(P-15:0/0:0)); LMGP02070002 (PE(P-18:0/0:0)); LMGP02060004 (PE(O-18:1(9Z)/0:0))": ["C23H48NO6P", "Glycerophospholipids [GP] with formula: C23H48NO6P"],
        "LMGP02050001 (PE(18:0/0:0)); LMGP01050117 (PC(15:0/0:0)[U]); LMGP01080020 (PC(14:0/O-1:0)); LMGP01080029 (PC(7:0/O-8:0)); LMGP01050016 (PC(15:0/0:0)); LMGP01050017 (PC(15:0/0:0)[S])": ["C23H48NO7P", "Glycerophospholipids [GP] with formula: C23H48NO7P"],
        "LMGP01060009 (PC(O-15:0/0:0)); LMGP01040023 (PC(O-14:0/O-1:0)[U]); LMGP01040022 (PC(O-14:0/O-1:0)[S]); LMGP01040021 (PC(O-14:0/O-1:0)); LMGP02060003 (PE(O-18:0/0:0))": ["C23H50NO6P", "Glycerophospholipids [GP] with formula: C23H50NO6P"],
        "LMGP01011254 (PC(8:2(2E,4E)/8:2(2E,4E)))": ["C24H40NO8P", "Glycerophospholipids [GP] with formula: C24H40NO8P"],
        "LMGP10050003 (PA(21:4(6Z,9Z,12Z,15Z)/0:0))": ["C24H44NO7P", "Glycerophospholipids [GP] with formula: C24H44NO7P"],
        "LMGP03050004 (PS(18:1(9Z)/0:0)[U]); LMGP03050001 (PS(18:1(9Z)/0:0))": ["C24H46NO9P", "Glycerophospholipids [GP] with formula: C24H46NO9P"],
        "LMGP04050006 (PG(18:1(9Z)/0:0)); LMGP04050003 (PG(18:1(9E)/0:0)[U]); LMGP04050004 (PG(18:1(9Z)/0:0)[U])": ["C24H47O9P", "Glycerophospholipids [GP] with formula: C24H47O9P"],
        "LMGP01060033 (PC(O-16:2(9E,10E)/0:0)[U]); LMGP02070003 (PE(P-19:1(12Z)/0:0))": ["C24H48NO6P", "Glycerophospholipids [GP] with formula: C24H48NO6P"],
        "LMGP01050022 (PC(16:1(9Z)/0:0)); LMGP01050023 (PC(16:1(9Z)/0:0)[U]); LMGP01050021 (PC(16:1(9E)/0:0))": ["C24H48NO7P", "Glycerophospholipids [GP] with formula: C24H48NO7P"],
        "LMGP02010272 (PE(10:0/9:0)[U]); LMGP01010504 (PC(14:0/2:0)); LMGP01011252 (PC(8:0/8:0)[S]); LMGP01011253 (PC(8:0/8:0)[U]); LMGP02010091 (PE(9:0/10:0)[U]); LMGP01011251 (PC(8:0/8:0))": ["C24H48NO8P", "Glycerophospholipids [GP] with formula: C24H48NO8P"],
        "LMGP03050003 (PS(18:0/0:0)[U]); LMGP03050006 (PS(18:0/0:0))": ["C24H48NO9P", "Glycerophospholipids [GP] with formula: C24H48NO9P"],
        "LMGP04050009 (PG(18:0/0:0)); LMGP04050005 (PG(18:0/0:0)[U])": ["C24H49O9P", "Glycerophospholipids [GP] with formula: C24H49O9P"],
        "LMGP01070006 (PC(P-16:0/0:0)); LMGP01070004 (PC(O-16:1(1E)/0:0)); LMGP01070005 (PC(O-16:1(1E)/0:0)[U]); LMGP01060032 (PC(O-16:1(9Z)/0:0)[U]); LMGP01060030 (PC(O-16:1(9E)/0:0)[U]); LMGP01060031 (PC(O-16:1(9Z)/0:0)); LMGP01060029 (PC(O-16:1(9E)/0:0)); LMGP01060028 (PC(O-16:1(11Z)/0:0))": ["C24H50NO6P", "Glycerophospholipids [GP] with formula: C24H50NO6P"],
        "LMGP01050074 (PC(0:0/16:0)); LMGP01050075 (PC(0:0/16:0)[U]); LMGP01050113 (PC(16:0/0:0)[rac]); LMGP01020020 (PC(O-14:0/2:0)[U]); LMGP01050018 (PC(16:0/0:0)); LMGP01050019 (PC(16:0/0:0)[S]); LMGP01020019 (PC(O-14:0/2:0)); LMGP01050020 (PC(16:0/0:0)[U])": ["C24H50NO7P", "Glycerophospholipids [GP] with formula: C24H50NO7P"],
        "LMGP01060010 (PC(O-16:0/0:0)); LMGP01060011 (PC(O-16:0/0:0)[S]); LMGP01060012 (PC(O-16:0/0:0)[U]); LMGP01040085 (PC(O-8:0/O-8:0)[U]); LMGP01040084 (PC(O-8:0/O-8:0)); LMGP01040028 (PC(O-15:0/O-1:0)[U])": ["C24H52NO6P", "Glycerophospholipids [GP] with formula: C24H52NO6P"],
        "LMGP02050009 (PE(20:4(5Z,8Z,11Z,14Z)/0:0))": ["C25H44NO7P", "Glycerophospholipids [GP] with formula: C25H44NO7P"],
        "LMGP02060001": ["C25H46NO6P", "Glycerophospholipids [GP] with formula: C25H46NO6P"],
        "LMGP06050002 (PI(16:0/0:0))": ["C25H49O12P", "Glycerophospholipids [GP] with formula: C25H49O12P"],
        "LMGP01050002 (PC(17:1(10Z)/0:0))": ["C25H50NO7P", "Glycerophospholipids [GP] with formula: C25H50NO7P"],
        "LMGP02010013 (PE(10:0/10:0)[U]); LMGP02010221 (PE(11:0/9:0)[U]); LMGP02010101 (PE(10:0/10:0)); LMGP02010092 (PE(9:0/11:0)[U])": ["C25H50NO8P", "Glycerophospholipids [GP] with formula: C25H50NO8P"],
        "LMGP01070007 (PC(P-17:0/0:0))": ["C25H52NO6P", "Glycerophospholipids [GP] with formula: C25H52NO6P"],
        "LMGP01080022 (PC(16:0/O-1:0)[U]); LMGP01080021 (PC(16:0/O-1:0)); LMGP01020028 (PC(O-16:0/1:0)); LMGP01020025 (PC(O-15:0/2:0)[U]); LMGP01020024 (PC(O-15:0/2:0)); LMGP01050024 (PC(17:0/0:0)); LMGP01020004 (PC(O-1:0/16:0)); LMGP01050025 (PC(17:0/0:0)[U])": ["C25H52NO7P", "Glycerophospholipids [GP] with formula: C25H52NO7P"],
        "LMGP01060013 (PC(O-17:0/0:0)); LMGP01040030 (PC(O-16:0/O-1:0)); LMGP01040031 (PC(O-16:0/O-1:0)[S]); LMGP01040032 (PC(O-16:0/O-1:0)[U]); LMGP01040005 (PC(O-1:0/O-16:0)[U])": ["C25H54NO6P", "Glycerophospholipids [GP] with formula: C25H54NO6P"],
        "LMGP03050007 (PS(20:4(5Z,8Z,11Z,14Z)/0:0))": ["C26H44NO9P", "Glycerophospholipids [GP] with formula: C26H44NO9P"],
        "LMGP04050010 (PG(20:4(5Z,8Z,11Z,14Z)/0:0))": ["C26H45O9P", "Glycerophospholipids [GP] with formula: C26H45O9P"],
        "LMGP01050040 (PC(18:4(9E,11E,13E,15E)/0:0))": ["C26H46NO7P", "Glycerophospholipids [GP] with formula: C26H46NO7P"],
        "LMGP01050039 (PC(18:3(9Z,12Z,15Z)/0:0)[U]); LMGP01050038 (PC(18:3(9Z,12Z,15Z)/0:0)); LMGP01050037 (PC(18:3(6Z,9Z,12Z)/0:0)[U])": ["C26H48NO7P", "Glycerophospholipids [GP] with formula: C26H48NO7P"],
        "LMGP06050003 (PI(17:1(10Z)/0:0))": ["C26H49O12P", "Glycerophospholipids [GP] with formula: C26H49O12P"],
        "LMGP03010022 (PS(10:0/10:0))": ["C26H50NO10P", "Glycerophospholipids [GP] with formula: C26H50NO10P"],
        "LMGP01050036 (PC(18:2(9Z,12Z)/0:0)[U]); LMGP01050035 (PC(18:2(9Z,12Z)/0:0)); LMGP01050034 (PC(18:2(2E,4E)/0:0))": ["C26H50NO7P", "Glycerophospholipids [GP] with formula: C26H50NO7P"],
        "LMGP01010693 (PC(16:1(9Z)/2:0))": ["C26H50NO8P", "Glycerophospholipids [GP] with formula: C26H50NO8P"],
        "LMGP04010032 (PG(10:0/10:0)); LMGP04010020 (PG(10:0/10:0)[U])": ["C26H51O10P", "Glycerophospholipids [GP] with formula: C26H51O10P"],
        "LMGP01070012 (PC(P-18:1(9Z)/0:0)); LMGP01060038 (PC(O-18:2(9Z,12Z)/0:0)[U])": ["C26H52NO6P", "Glycerophospholipids [GP] with formula: C26H52NO6P"],
        "LMGP01050029 (PC(18:1(6Z)/0:0)); LMGP01050080 (PC(0:0/18:1(9E))); LMGP01050081 (PC(0:0/18:1(9E))[U]); LMGP01050082 (PC(0:0/18:1(9Z))); LMGP01050083 (PC(0:0/18:1(9Z))[U]); LMGP01050079 (PC(0:0/18:1(6Z))); LMGP01050114 (PC(18:1(9Z)/0:0)[rac]); LMGP01020148 (PC(O-16:1(9E)/2:0)[U]); LMGP01020149 (PC(O-16:1(9Z)/2:0)[U]); LMGP01020147 (PC(O-16:1(11Z)/2:0)); LMGP01050033 (PC(18:1(9Z)/0:0)[U]); LMGP01050115 (PC(18:1(9E)/0:0)[U]); LMGP01030009 (PC(P-16:0/2:0)); LMGP01050031 (PC(18:1(9)/0:0)[U]); LMGP01050030 (PC(18:1(9E)/0:0)); LMGP01050032 (PC(18:1(9Z)/0:0))": ["C26H52NO7P", "Glycerophospholipids [GP] with formula: C26H52NO7P"],
        "LMGP02010053 (PE(10:0/11:0)[U]); LMGP02010281 (PE(9:0/12:0)[U]); LMGP02010254 (PE(11:0/10:0)[U]); LMGP01011270 (PC(9:0/9:0)); LMGP01011271 (PC(9:0/9:0)[U]); LMGP01010613 (PC(16:0/2:0)[S]); LMGP01010612 (PC(16:0/2:0)); LMGP01010614 (PC(16:0/2:0)[U]); LMGP01010989 (PC(2:0/16:0))": ["C26H52NO8P", "Glycerophospholipids [GP] with formula: C26H52NO8P"],
        "LMGP01070008 (PC(O-18:1(1E)/0:0)); LMGP01070009 (PC(P-18:0/0:0)); LMGP01060036 (PC(O-18:1(9Z)/0:0)[S]); LMGP01060037 (PC(O-18:1(9Z)/0:0)[U]); LMGP01060034 (PC(O-18:1(11Z)/0:0)); LMGP01060035 (PC(O-18:1(9E)/0:0)[S]); LMGP01060039 (PC(O-18:1(9Z)/0:0))": ["C26H54NO6P", "Glycerophospholipids [GP] with formula: C26H54NO6P"],
        "LMGP01050077 (PC(0:0/18:0)[S]); LMGP01050076 (PC(0:0/18:0)); LMGP01050078 (PC(0:0/18:0)[U]); LMGP01080008 (PC(2:0/O-16:0)[U]); LMGP01020048 (PC(O-16:0/2:0)[U]); LMGP01020047 (PC(O-16:0/2:0)[S]); LMGP01020046 (PC(O-16:0/2:0)); LMGP01050026 (PC(18:0/0:0)); LMGP01050028 (PC(18:0/0:0)[U]); LMGP01050027 (PC(18:0/0:0)[S])": ["C26H54NO7P", "Glycerophospholipids [GP] with formula: C26H54NO7P"],
        "LMGP01040041 (PC(O-16:0/O-2:0)); LMGP01040042 (PC(O-16:0/O-2:0)[U]); LMGP01040047 (PC(O-17:0/O-1:0)[U]); LMGP01060014 (PC(O-18:0/0:0)); LMGP01060015 (PC(O-18:0/0:0)[S]); LMGP01060016 (PC(O-18:0/0:0)[U]); LMGP01040087 (PC(O-9:0/O-9:0)[U]); LMGP01040010 (PC(O-10:0/O-8:0)[U]); LMGP01040068 (PC(O-2:0/O-16:0)[U])": ["C26H56NO6P", "Glycerophospholipids [GP] with formula: C26H56NO6P"],
        "LMGP01050003 (PC(19:3(10Z,13Z,16Z)/0:0))": ["C27H50NO7P", "Glycerophospholipids [GP] with formula: C27H50NO7P"],
        "LMGP06050005 (PI(18:1(9Z)/0:0))": ["C27H51O12P", "Glycerophospholipids [GP] with formula: C27H51O12P"],
        "LMGP01010668 (PC(16:0/3:1(2E)))": ["C27H52NO8P", "Glycerophospholipids [GP] with formula: C27H52NO8P"],
        "LMGP06050004 (PI(18:0/0:0))": ["C27H53O12P", "Glycerophospholipids [GP] with formula: C27H53O12P"],
        "LMGP10010030 (PA(12:0/12:0)); LMGP10010009 (PA(12:0/12:0)[U])": ["C27H53O8P", "Glycerophospholipids [GP] with formula: C27H53O8P"],
        "LMGP01070010 (PC(P-19:1(12Z)/0:0))": ["C27H54NO6P", "Glycerophospholipids [GP] with formula: C27H54NO6P"],
        "LMGP01020070 (PC(O-16:0/3:1(2E))); LMGP01020071 (PC(O-16:0/3:1(2E))[S])": ["C27H54NO7P", "Glycerophospholipids [GP] with formula: C27H54NO7P"],
        "LMGP02010054 (PE(10:0/12:0)[U]); LMGP02010282 (PE(9:0/13:0)[U]); LMGP01010666 (PC(16:0/3:0)); LMGP01010667 (PC(16:0/3:0)[U]); LMGP01010714 (PC(17:0/2:0)); LMGP01010715 (PC(17:0/2:0)[S]); LMGP02010014 (PE(11:0/11:0)[U]); LMGP02010225 (PE(12:0/10:0)[U]); LMGP01011255 (PC(9:0/10:0)[U]); LMGP01010404 (PC(10:0/9:0)[U])": ["C27H54NO8P", "Glycerophospholipids [GP] with formula: C27H54NO8P"],
        "LMGP01040061 (PC(O-18:1(9Z)/O-1:0)); LMGP01040058 (PC(O-18:1(9E)/O-1:0)[U])": ["C27H56NO6P", "Glycerophospholipids [GP] with formula: C27H56NO6P"],
        "LMGP01080026 (PC(3:0/O-16:0)[U]); LMGP01020085 (PC(O-18:0/1:0)[U]); LMGP01020084 (PC(O-18:0/1:0)); LMGP01020078 (PC(O-17:0/2:0)); LMGP01020079 (PC(O-17:0/2:0)[U]); LMGP01020069 (PC(O-16:0/3:0)[U]); LMGP01020068 (PC(O-16:0/3:0)); LMGP01050041 (PC(19:0/0:0)); LMGP01050042 (PC(19:0/0:0)[U])": ["C27H56NO7P", "Glycerophospholipids [GP] with formula: C27H56NO7P"],
        "LMGP01040049 (PC(O-18:0/O-1:0)[S]); LMGP01040048 (PC(O-18:0/O-1:0)); LMGP01040043 (PC(O-16:0/O-3:0)[U]); LMGP01060017 (PC(O-19:0/0:0)); LMGP01040011 (PC(O-10:0/O-9:0)[U]); LMGP01040007 (PC(O-1:0/O-18:0)[U]); LMGP01040006 (PC(O-1:0/O-18:0)); LMGP01040050 (PC(O-18:0/O-1:0)[U])": ["C27H58NO6P", "Glycerophospholipids [GP] with formula: C27H58NO6P"],
        "LMGP01050050 (PC(20:5(5Z,8Z,11Z,14Z,17Z)/0:0))": ["C28H48NO7P", "Glycerophospholipids [GP] with formula: C28H48NO7P"],
        "LMGP01011236 (PC(6:2(3E,5E)/14:2(11E,13E))); LMGP01010405 (PC(10:2(2E,4E)/10:2(2E,4E))[S])": ["C28H48NO8P", "Glycerophospholipids [GP] with formula: C28H48NO8P"],
        "LMGP01050121 (PC(0:0/20:4(5Z,8Z,11Z,14Z))); LMGP01050048 (PC(20:4(5Z,8Z,11Z,14Z)/0:0)); LMGP01050049 (PC(20:4(5Z,8Z,11Z,14Z)/0:0)[U])": ["C28H50NO7P", "Glycerophospholipids [GP] with formula: C28H50NO7P"],
        "LMGP01060026": ["C28H52NO6P", "Glycerophospholipids [GP] with formula: C28H52NO6P"],
        "LMGP01010940 (PC(18:2(9Z,12Z)/2:0)[U])": ["C28H52NO8P", "Glycerophospholipids [GP] with formula: C28H52NO8P"],
        "LMGP01020159 (PC(O-18:2(9Z,12Z)/2:0)[U]); LMGP01020158 (PC(O-18:2(9Z,12Z)/2:0))": ["C28H54NO7P", "Glycerophospholipids [GP] with formula: C28H54NO7P"],
        "LMGP01010901 (PC(18:1(9Z)/2:0)[U]); LMGP01010900 (PC(18:1(9Z)/2:0)); LMGP01010878 (PC(18:1(9E)/2:0)); LMGP01010991 (PC(2:0/18:1(9Z)))": ["C28H54NO8P", "Glycerophospholipids [GP] with formula: C28H54NO8P"],
        "LMGP01020151 (PC(O-18:1(9E)/2:0)[U]); LMGP01020150 (PC(O-18:1(10E)/2:0)); LMGP01020155 (PC(O-18:1(9Z)/2:0)[S]); LMGP01020154 (PC(O-18:1(9Z)/2:0)); LMGP01020156 (PC(O-18:1(9Z)/2:0)[U]); LMGP01080007 (PC(2:0/O-18:1(9Z))[S]); LMGP01080006 (PC(2:0/O-18:1(9Z))); LMGP01030011 (PC(P-18:0/2:0)); LMGP01050047 (PC(20:1(9Z)/0:0))": ["C28H56NO7P", "Glycerophospholipids [GP] with formula: C28H56NO7P"],
        "LMGP01010780 (PC(18:0/2:0)[U]); LMGP01010424 (PC(11:0/9:0)[U]); LMGP02010055 (PE(11:0/12:0)[U]); LMGP02010283 (PE(9:0/14:0)[U]); LMGP02010266 (PE(10:0/13:0)[U]); LMGP01010669 (PC(16:0/4:0)); LMGP02010246 (PE(13:0/10:0)[U]); LMGP01010671 (PC(16:0/4:0)[U]); LMGP02010233 (PE(12:0/11:0)[U]); LMGP02010348 (PE-NMe(11:0/11:0)); LMGP01010382 (PC(10:0/10:0)[U]); LMGP01010380 (PC(10:0/10:0)); LMGP01011256 (PC(9:0/11:0)[U]); LMGP01010519 (PC(14:0/6:0)[U]); LMGP01010670 (PC(16:0/4:0)[S]); LMGP01010990 (PC(2:0/18:0)); LMGP01010779 (PC(18:0/2:0)); LMGP01010381 (PC(10:0/10:0)[S])": ["C28H56NO8P", "Glycerophospholipids [GP] with formula: C28H56NO8P"],
        "LMGP01040056 (PC(O-18:0/O-2:1(1E)))": ["C28H58NO6P", "Glycerophospholipids [GP] with formula: C28H58NO6P"],
        "LMGP01080025 (PC(2:0/O-18:0)); LMGP01020094 (PC(O-18:0/2:0)); LMGP01020095 (PC(O-18:0/2:0)[S]); LMGP01020096 (PC(O-18:0/2:0)[U]); LMGP01080017 (PC(2:0/O-18:0)[S]); LMGP01080010 (PC(2:0/O-18:0)[S]); LMGP01080009 (PC(2:0/O-18:0)[U]); LMGP01020072 (PC(O-16:0/4:0)); LMGP01020073 (PC(O-16:0/4:0)[U]); LMGP01050045 (PC(20:0/0:0)); LMGP01050046 (PC(20:0/0:0)[U])": ["C28H58NO7P", "Glycerophospholipids [GP] with formula: C28H58NO7P"],
        "LMGP10010001 (PA(12:0/13:0))": ["C28H58NO8P", "Glycerophospholipids [GP] with formula: C28H58NO8P"],
        "LMGP01040044 (PC(O-16:0/O-4:0)[U]); LMGP01060018 (PC(O-20:0/0:0)[U]); LMGP01040019 (PC(O-12:0/O-8:0)[U]); LMGP01040008 (PC(O-10:0/O-10:0)[U]); LMGP01040066 (PC(O-19:0/O-1:0)[U]); LMGP01040054 (PC(O-18:0/O-2:0)[S]); LMGP01040055 (PC(O-18:0/O-2:0)[U]); LMGP01040053 (PC(O-18:0/O-2:0))": ["C28H60NO6P", "Glycerophospholipids [GP] with formula: C28H60NO6P"],
        "LMGP06050006 (PI(20:4(5Z,8Z,11Z,14Z)/0:0))": ["C29H49O12P", "Glycerophospholipids [GP] with formula: C29H49O12P"],
        "LMGP01050004 (PC(21:4(6Z,9Z,12Z,15Z)/0:0))": ["C29H52NO7P", "Glycerophospholipids [GP] with formula: C29H52NO7P"],
        "LMGP01010673 (PC(16:0/5:1(4E))); LMGP01010830 (PC(18:0/3:1(2E)))": ["C29H56NO8P", "Glycerophospholipids [GP] with formula: C29H56NO8P"],
        "LMGP01040073 (PC(O-3:1(1E)/O-18:1(9Z))[S]); LMGP01040074 (PC(P-3:0/O-18:1(9Z))[S]); LMGP01040075 (PC(O-3:1(2E)/O-18:1(9Z))[S])": ["C29H58NO6P", "Glycerophospholipids [GP] with formula: C29H58NO6P"],
        "LMGP01020115 (PC(O-18:0/3:1(2E))[S]); LMGP01020114 (PC(O-18:0/3:1(2E)))": ["C29H58NO7P", "Glycerophospholipids [GP] with formula: C29H58NO7P"],
        "LMGP02010056 (PE(11:0/13:0)[U]); LMGP01010672 (PC(16:0/5:0)); LMGP02010284 (PE(9:0/15:0)[U]); LMGP02010265 (PE(10:0/14:0)[U]); LMGP02010245 (PE(13:0/11:0)[U]); LMGP02010015 (PE(12:0/12:0)[U]); LMGP02010061 (PE(14:0/10:0)[U]); LMGP01010383 (PC(10:0/11:0)[U]); LMGP01011257 (PC(9:0/12:0)[U]); LMGP01010829 (PC(18:0/3:0)); LMGP01011224 (PC(5:0/16:0)); LMGP02010098 (PE(12:0/12:0)); LMGP01010406 (PC(11:0/10:0)[U]); LMGP01010978 (PC(19:0/2:0))": ["C29H58NO8P", "Glycerophospholipids [GP] with formula: C29H58NO8P"],
        "LMGP01020113 (PC(O-18:0/3:0)[U]); LMGP01020112 (PC(O-18:0/3:0)); LMGP01020119 (PC(O-19:0/2:0)[U]); LMGP01020118 (PC(O-19:0/2:0)); LMGP01050052 (PC(21:0/0:0)[U]); LMGP01050051 (PC(21:0/0:0)); LMGP01020074 (PC(O-16:0/5:0))": ["C29H60NO7P", "Glycerophospholipids [GP] with formula: C29H60NO7P"],
        "LMGP01040057 (PC(O-18:0/O-3:1(2E))[U])": ["C29H61NO6P", "Glycerophospholipids [GP] with formula: C29H61NO6P"],
        "LMGP01040045 (PC(O-16:0/O-5:0)[U]); LMGP01040070 (PC(O-20:0/O-1:0))": ["C29H62NO6P", "Glycerophospholipids [GP] with formula: C29H62NO6P"],
        "LMGP01050056 (PC(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/0:0)); LMGP01050055 (PC(22:6(4E,7E,10E,13E,16E,19E)/0:0)[U])": ["C30H50NO7P", "Glycerophospholipids [GP] with formula: C30H50NO7P"],
        "LMGP01010425 (PC(11:1(10E)/11:1(10E))[U])": ["C30H56NO8P", "Glycerophospholipids [GP] with formula: C30H56NO8P"],
        "LMGP03010027 (PS(12:0/12:0)); LMGP03010015 (PS(12:0/12:0)[U])": ["C30H58NO10P", "Glycerophospholipids [GP] with formula: C30H58NO10P"],
        "LMGP01010916 (PC(18:1(9Z)/4:0)); LMGP01010917 (PC(18:1(9Z)/4:0)[U]); LMGP01011221 (PC(4:0/18:1(9Z)))": ["C30H58NO8P", "Glycerophospholipids [GP] with formula: C30H58NO8P"],
        "LMGP04010035 (PG(12:0/12:0)); LMGP04010011 (PG(12:0/12:0)[U])": ["C30H59O10P", "Glycerophospholipids [GP] with formula: C30H59O10P"],
        "LMGP01010427 (PC(12:0/10:0)[U]); LMGP02010057 (PE(12:0/13:0)[U]); LMGP02010264 (PE(10:0/15:0)[U]); LMGP02010244 (PE(13:0/12:0)[U]); LMGP01010472 (PC(13:0/9:0)[U]); LMGP02010232 (PE(11:0/14:0)[U]); LMGP02010235 (PE(14:0/11:0)[U]); LMGP02010341 (PE-NMe(12:0/12:0)); LMGP02010342 (PE-NMe(12:0/12:0)[U]); LMGP01010831 (PC(18:0/4:0)[U]); LMGP02010008 (PE(12:0/13:0)); LMGP01011258 (PC(9:0/13:0)[U]); LMGP01010384 (PC(10:0/12:0)[U]); LMGP01010676 (PC(16:0/6:0)[U]); LMGP01010675 (PC(16:0/6:0)[S]); LMGP01010674 (PC(16:0/6:0)); LMGP01011220 (PC(4:0/18:0)); LMGP01011227 (PC(6:0/16:0)[U]); LMGP01010407 (PC(11:0/11:0)); LMGP01010408 (PC(11:0/11:0)[U])": ["C30H60NO8P", "Glycerophospholipids [GP] with formula: C30H60NO8P"],
        "LMGP01020117 (PC(O-18:0/4:0)[U]); LMGP01020116 (PC(O-18:0/4:0)); LMGP01050053 (PC(22:0/0:0)); LMGP01050054 (PC(22:0/0:0)[U]); LMGP01080027 (PC(6:0/O-16:0)[U]); LMGP01020075 (PC(O-16:0/6:0)); LMGP01020124 (PC(O-20:0/2:0)[U]); LMGP01020123 (PC(O-20:0/2:0)); LMGP01020008 (PC(O-12:0/10:0)[U])": ["C30H62NO7P", "Glycerophospholipids [GP] with formula: C30H62NO7P"],
        "LMGP01040046 (PC(O-16:0/O-6:0)[U]); LMGP01040012 (PC(O-11:0/O-11:0)[U]); LMGP01040009 (PC(O-10:0/O-12:0)[U]); LMGP01040076 (PC(O-6:0/O-16:0)[U])": ["C30H64NO6P", "Glycerophospholipids [GP] with formula: C30H64NO6P"],
        "LMGP10010026 (PA(14:0/14:0)); LMGP10010010 (PA(14:0/14:0)[U])": ["C31H61O8P", "Glycerophospholipids [GP] with formula: C31H61O8P"],
        "LMGP01010428 (PC(12:0/11:0)[U]); LMGP02010058 (PE(12:0/14:0)); LMGP02010289 (PE(14:0/12:0)[U]); LMGP02010263 (PE(10:0/16:0)[U]); LMGP01010453 (PC(13:0/10:0)[U]); LMGP02010243 (PE(13:0/13:0)); LMGP02010231 (PE(11:0/15:0)[U]); LMGP01010385 (PC(10:0/13:0)[U]); LMGP01010520 (PC(14:0/9:0)[U]); LMGP02010313 (PE-NMe2(12:0/12:0)); LMGP02010315 (PE-NMe2(12:0/12:0)[U]); LMGP01011259 (PC(9:0/14:0)[U]); LMGP01010409 (PC(11:0/12:0)[U])": ["C31H62NO8P", "Glycerophospholipids [GP] with formula: C31H62NO8P"],
        "LMGP03010001 (PS(12:0/13:0))": ["C31H63N2O10P", "Glycerophospholipids [GP] with formula: C31H63N2O10P"],
        "LMGP04010001 (PG(12:0/13:0))": ["C31H64NO10P", "Glycerophospholipids [GP] with formula: C31H64NO10P"],
        "LMGP10040003 (PA(O-14:0/O-14:0)[U])": ["C31H65O6P", "Glycerophospholipids [GP] with formula: C31H65O6P"],
        "LMGP01010410 (PC(11:0/13:0)[U]); LMGP01010554 (PC(15:0/9:0)[U]); LMGP01010429 (PC(12:0/12:0)); LMGP01010430 (PC(12:0/12:0)[U]); LMGP02010059 (PE(13:0/14:0)[U]); LMGP01010454 (PC(13:0/11:0)[U]); LMGP02010241 (PE(10:0/17:0)[U]); LMGP01010473 (PC(14:0/10:0)[U]); LMGP02010230 (PE(11:0/16:0)[U]); LMGP01010832 (PC(18:0/6:0)[U]); LMGP02010223 (PE(12:0/15:0)[U]); LMGP01011260 (PC(9:0/15:0)[U]); LMGP01010386 (PC(10:0/14:0)[U]); LMGP02010204 (PE(14:0/13:0)[U]); LMGP01011228 (PC(6:0/18:0))": ["C32H64NO8P", "Glycerophospholipids [GP] with formula: C32H64NO8P"],
        "LMGP01050058 (PC(24:0/0:0)[U]); LMGP01050057 (PC(24:0/0:0))": ["C32H66NO7P", "Glycerophospholipids [GP] with formula: C32H66NO7P"],
        "LMGP01040083 (PC(O-8:0/O-16:0)[U]); LMGP01040016 (PC(O-12:0/O-12:0)[U]); LMGP01040015 (PC(O-12:0/O-12:0)); LMGP01040077 (PC(O-6:0/O-18:0)[U])": ["C32H68NO6P", "Glycerophospholipids [GP] with formula: C32H68NO6P"],
        "LMGP10010011 (PA(15:0/15:0)[U])": ["C33H65O8P", "Glycerophospholipids [GP] with formula: C33H65O8P"],
        "LMGP01010411 (PC(11:0/14:0)[U]); LMGP01010431 (PC(12:0/13:0)[U]); LMGP01010455 (PC(13:0/12:0)[U]); LMGP01010001 (PC(12:0/13:0)); LMGP01010474 (PC(14:0/11:0)[U]); LMGP02010016 (PE(14:0/14:0)[U]); LMGP02010222 (PE(12:0/16:0)[U]); LMGP02010229 (PE(11:0/17:0)[U]); LMGP02010352 (PE(14:0/14:0)); LMGP02010060 (PE(13:0/15:0)[U]); LMGP01010387 (PC(10:0/15:0)[U]); LMGP02010021 (PE(18:0/10:0)); LMGP01011242 (PC(8:0/17:0)[U]); LMGP01010525 (PC(15:0/10:0)[U]); LMGP02010308 (PE(16:0/12:0)); LMGP01010677 (PC(16:0/9:0))": ["C33H66NO8P", "Glycerophospholipids [GP] with formula: C33H66NO8P"],
        "LMGP03010028 (PS(14:0/14:0)); LMGP03010009 (PS(14:0/14:0)[U])": ["C34H66NO10P", "Glycerophospholipids [GP] with formula: C34H66NO10P"],
        "LMGP04010005 (PG(14:0/14:0)); LMGP04010025 (PG(16:0/12:0)); LMGP04010026 (PG(16:0/12:0)[U]); LMGP04010009 (PG(14:0/14:0)[U])": ["C34H67O10P", "Glycerophospholipids [GP] with formula: C34H67O10P"],
        "LMGP06010003 (PI(12:0/13:0))": ["C34H68NO13P", "Glycerophospholipids [GP] with formula: C34H68NO13P"],
        "LMGP02010334 (PE-NMe(14:0/14:0)[U]); LMGP01010412 (PC(11:0/15:0)[U]); LMGP01010433 (PC(12:0/14:0)[U]); LMGP01010432 (PC(12:0/14:0)); LMGP02010298 (PE(16:0/13:0)[U]); LMGP01010457 (PC(13:0/13:0)[U]); LMGP01010456 (PC(13:0/13:0)); LMGP02010062 (PE(14:0/15:0)[U]); LMGP02010242 (PE(13:0/16:0)[U]); LMGP01010475 (PC(14:0/12:0)); LMGP02010239 (PE(12:0/17:0)[U]); LMGP02010343 (PE-NMe(14:0/14:0)); LMGP01010833 (PC(18:0/8:0)[U]); LMGP02010228 (PE(11:0/18:0)[U]); LMGP01011261 (PC(9:0/17:0)[U]); LMGP01010388 (PC(10:0/16:0)); LMGP01010555 (PC(16:0/10:0)[U]); LMGP01010725 (PC(17:0/9:0)); LMGP01011243 (PC(8:0/18:0)); LMGP01010526 (PC(15:0/11:0)[U]); LMGP10010006 (PA(17:0/14:1(9Z)))": ["C34H68NO8P", "Glycerophospholipids [GP] with formula: C34H68NO8P"],
        "LMGP02040010 (PE-NMe(O-14:0/O-14:0))": ["C34H72NO6P", "Glycerophospholipids [GP] with formula: C34H72NO6P"],
        "LMGP10010019 (PA(14:0/18:1(9Z)))": ["C35H67O8P", "Glycerophospholipids [GP] with formula: C35H67O8P"],
        "LMGP01010426 (PC(11:1(10E)/16:0)[U])": ["C35H68NO8P", "Glycerophospholipids [GP] with formula: C35H68NO8P"],
        "LMGP10010012 (PA(16:0/16:0)[rac]); LMGP10010027 (PA(16:0/16:0))": ["C35H69O8P", "Glycerophospholipids [GP] with formula: C35H69O8P"],
        "LMGP00000051": ["C35H69O8PS", "Glycerophospholipids [GP] with formula: C35H69O8PS"],
        "LMGP01010413 (PC(11:0/16:0)[U]); LMGP01010556 (PC(16:0/11:0)[U]); LMGP01010834 (PC(18:0/9:0)[U]); LMGP01010434 (PC(12:0/15:0)[U]); LMGP02010297 (PE(16:0/14:0)); LMGP01010458 (PC(13:0/14:0)[U]); LMGP02010250 (PE(17:0/13:0)[U]); LMGP01010476 (PC(14:0/13:0)[U]); LMGP02010234 (PE(13:0/17:0)[U]); LMGP01010700 (PC(17:0/10:0)); LMGP02010227 (PE(11:0/19:0)[U]); LMGP02010224 (PE(12:0/18:0)[U]); LMGP01011262 (PC(9:0/18:0)); LMGP01010389 (PC(10:0/17:0)[U]); LMGP02010106 (PE(15:0/15:0)); LMGP02010107 (PE(15:0/15:0)[U]); LMGP02010022 (PE(18:0/12:0)[U]); LMGP01011244 (PC(8:0/19:0)); LMGP01010527 (PC(15:0/12:0)[U]); LMGP02010302 (PE(14:0/16:0)); LMGP02010316 (PE-NMe2(14:0/14:0)); LMGP02010328 (PE-NMe2(14:0/14:0)[U])": ["C35H70NO8P", "Glycerophospholipids [GP] with formula: C35H70NO8P"],
        "LMGP10040004 (PA(O-16:0/O-16:0)); LMGP10040002 (PA(O-16:0/O-16:0)[U])": ["C35H73O6P", "Glycerophospholipids [GP] with formula: C35H73O6P"],
        "LMGP02040008 (PE-NMe2(O-14:0/O-14:0))": ["C35H74NO6P", "Glycerophospholipids [GP] with formula: C35H74NO6P"],
        "LMGP13010001 (CDP-DG(12:0/12:0))": ["C36H65N3O15P2", "Glycerophospholipids [GP] with formula: C36H65N3O15P2"],
        "LMGP01010393 (PC(10:0/18:2(9Z,12Z))); LMGP01010524 (PC(14:1(9Z)/14:1(9Z))[U]); LMGP01010523 (PC(14:1(9Z)/14:1(9Z))); LMGP01010522 (PC(14:1(9E)/14:1(9E))[U]); LMGP01010521 (PC(14:1(9E)/14:1(9E)))": ["C36H68NO8P", "Glycerophospholipids [GP] with formula: C36H68NO8P"],
        "LMGP02010005 (PE(17:0/14:1(9Z))); LMGP01010392 (PC(10:0/18:1(9Z))); LMGP02010355 (PE(16:1(5Z)/15:0)); LMGP02010353 (PE(16:1(11Z)/15:0))": ["C36H70NO8P", "Glycerophospholipids [GP] with formula: C36H70NO8P"],
        "LMGP04010024 (PG(15:0/15:0)); LMGP04010023 (PG(14:0/16:0)[U]); LMGP04010022 (PG(14:0/16:0)); LMGP04010012 (PG(15:0/15:0)[U])": ["C36H71O10P", "Glycerophospholipids [GP] with formula: C36H71O10P"],
        "LMGP01010414 (PC(11:0/17:0)); LMGP01010557 (PC(16:0/12:0)); LMGP01010558 (PC(16:0/12:0)[U]); LMGP01010435 (PC(12:0/16:0)); LMGP01010436 (PC(12:0/16:0)[U]); LMGP02010296 (PE(16:0/15:0)[U]); LMGP01010459 (PC(13:0/15:0)); LMGP02010251 (PE(17:0/14:0)[U]); LMGP02010063 (PE(15:0/16:0)[U]); LMGP02010240 (PE(13:0/18:0)[U]); LMGP01010477 (PC(14:0/14:0)); LMGP01010478 (PC(14:0/14:0)[U]); LMGP01010701 (PC(17:0/11:0)); LMGP02010226 (PE(12:0/19:0)[U]); LMGP01010390 (PC(10:0/18:0)); LMGP01010391 (PC(10:0/18:0)[U]); LMGP01011263 (PC(9:0/19:0)); LMGP01010732 (PC(18:0/10:0)); LMGP01010733 (PC(18:0/10:0)[U]); LMGP01011245 (PC(8:0/20:0)); LMGP01010528 (PC(15:0/13:0)); LMGP01011237 (PC(7:0/21:0)); LMGP02010309 (PE(14:0/17:0)[U]); LMGP01010986 (PC(19:0/9:0))": ["C36H72NO8P", "Glycerophospholipids [GP] with formula: C36H72NO8P"],
        "LMGP01040025 (PC(O-14:0/O-14:0)[U]); LMGP01040024 (PC(O-14:0/O-14:0))": ["C36H76NO6P", "Glycerophospholipids [GP] with formula: C36H76NO6P"],
        "LMGP10010023 (PA(16:0/18:2(9Z,12Z)))": ["C37H69O8P", "Glycerophospholipids [GP] with formula: C37H69O8P"],
        "LMGP02010019 (PE(16:1(9Z)/16:1(9Z))[U]); LMGP02010354 (PE(16:1(11Z)/16:1(11Z))); LMGP02010356 (PE(16:1(5Z)/16:1(5Z))); LMGP02010108 (PE(16:1(9Z)/16:1(9Z)))": ["C37H70NO8P", "Glycerophospholipids [GP] with formula: C37H70NO8P"],
        "LMGP10010032 (PA(16:0/18:1(9Z))); LMGP10010008 (PA(16:0/18:1(9Z))[U]); LMGP10010018 (PA(18:1(9Z)/16:0)[U]); LMGP10010007 (PA(16:0/18:1(11Z))); LMGP10010002 (PA(16:0/18:1(9Z)))": ["C37H71O8P", "Glycerophospholipids [GP] with formula: C37H71O8P"],
        "LMGP01010735 (PC(18:0/11:1(10E)))": ["C37H72NO8P", "Glycerophospholipids [GP] with formula: C37H72NO8P"],
        "LMGP11010001 (PPA(16:0/18:1(9Z)))": ["C37H72O11P2", "Glycerophospholipids [GP] with formula: C37H72O11P2"],
        "LMGP03010006 (PS(17:0/14:1(9Z)))": ["C37H73N2O10P", "Glycerophospholipids [GP] with formula: C37H73N2O10P"],
        "LMGP00000052": ["C37H73O8PS", "Glycerophospholipids [GP] with formula: C37H73O8PS"],
        "LMGP04010007 (PG(17:0/14:1(9Z)))": ["C37H74NO10P", "Glycerophospholipids [GP] with formula: C37H74NO10P"],
        "LMGP01010415 (PC(11:0/18:0)[U]); LMGP01010968 (PC(19:0/10:0)); LMGP01010559 (PC(16:0/13:0)[U]); LMGP01010437 (PC(12:0/17:0)[U]); LMGP02010252 (PE(17:0/15:0)[U]); LMGP01010460 (PC(13:0/16:0)[U]); LMGP01010480 (PC(14:0/15:0)[U]); LMGP02010247 (PE(12:0/20:0)[U]); LMGP02010248 (PE(13:0/19:0)[U]); LMGP01010479 (PC(14:0/15:0)); LMGP02010017 (PE(16:0/16:0)[U]); LMGP01010394 (PC(10:0/19:0)); LMGP01011264 (PC(9:0/20:0)); LMGP01010734 (PC(18:0/11:0)[U]); LMGP02010037 (PE(16:0/16:0)); LMGP02010023 (PE(18:0/14:0)[U]); LMGP01011246 (PC(8:0/21:0)); LMGP01010529 (PC(15:0/14:0)[U]); LMGP01011035 (PC(20:0/9:0))": ["C37H74NO8P", "Glycerophospholipids [GP] with formula: C37H74NO8P"],
        "LMGP01020011 (PC(O-14:0/15:0)); LMGP02020004 (PE(O-16:0/16:0)[U])": ["C37H76NO7P", "Glycerophospholipids [GP] with formula: C37H76NO7P"],
        "LMGP02040004 (PE(O-16:0/O-16:0)); LMGP02040003 (PE(O-16:0/O-16:0)[U])": ["C37H78NO6P", "Glycerophospholipids [GP] with formula: C37H78NO6P"],
        "LMGP03010029 (PS(16:0/16:0)); LMGP03010008 (PS(16:0/16:0)[U])": ["C38H74NO10P", "Glycerophospholipids [GP] with formula: C38H74NO10P"],
        "LMGP01010440 (PC(12:0/18:1(9Z))); LMGP01010441 (PC(12:0/18:1(9Z))[U]); LMGP01010484 (PC(14:0/16:1(7Z))[U]); LMGP01010485 (PC(14:0/16:1(9Z))); LMGP01010486 (PC(14:0/16:1(9Z))[U])": ["C38H74NO8P", "Glycerophospholipids [GP] with formula: C38H74NO8P"],
        "LMGP04010028 (PG(18:0/14:0)[U]); LMGP04010027 (PG(18:0/14:0)); LMGP04010010 (PG(16:0/16:0)[U])": ["C38H75O10P", "Glycerophospholipids [GP] with formula: C38H75O10P"],
        "LMGP01020014 (PC(O-14:0/16:1(9Z)))": ["C38H76NO7P", "Glycerophospholipids [GP] with formula: C38H76NO7P"],
        "LMGP02010337 (PE-NMe(16:0/16:0)); LMGP01010561 (PC(16:0/14:0)[U]); LMGP01010560 (PC(16:0/14:0)); LMGP01010416 (PC(11:0/19:0)); LMGP01010969 (PC(19:0/11:0)); LMGP02010188 (PE(19:0/14:0)[U]); LMGP01010439 (PC(12:0/18:0)[U]); LMGP01010438 (PC(12:0/18:0)); LMGP01010530 (PC(15:0/15:0)); LMGP01010531 (PC(15:0/15:0)[U]); LMGP02010260 (PE(18:0/15:0)[U]); LMGP02010253 (PE(17:0/16:0)[U]); LMGP01010461 (PC(13:0/17:0)); LMGP01010481 (PC(14:0/16:0)); LMGP01010482 (PC(14:0/16:0)[S]); LMGP01010483 (PC(14:0/16:0)[U]); LMGP02010064 (PE(16:0/17:0)[U]); LMGP02010238 (PE(13:0/20:0)[U]); LMGP02010347 (PE-NMe(16:0/16:0)[U]); LMGP01010702 (PC(17:0/13:0)); LMGP01010395 (PC(10:0/20:0)); LMGP01011265 (PC(9:0/21:0)); LMGP01010736 (PC(18:0/12:0)); LMGP01010737 (PC(18:0/12:0)[U]); LMGP01010995 (PC(20:0/10:0)); LMGP02010307 (PE(14:0/19:0)[U])": ["C38H76NO8P", "Glycerophospholipids [GP] with formula: C38H76NO8P"],
        "LMGP01020012 (PC(O-14:0/16:0)); LMGP01020013 (PC(O-14:0/16:0)[U])": ["C38H78NO7P", "Glycerophospholipids [GP] with formula: C38H78NO7P"],
        "LMGP03040001 (PS(O-16:0/O-16:0)[U])": ["C38H78NO8P", "Glycerophospholipids [GP] with formula: C38H78NO8P"],
        "LMGP04040001 (PG(O-16:0/O-16:0)[U])": ["C38H79O8P", "Glycerophospholipids [GP] with formula: C38H79O8P"],
        "LMGP02040011 (PE-NMe(O-16:0/O-16:0)[U]); LMGP02040012 (PE-NMe(O-16:0/O-16:0)); LMGP01040033 (PC(O-16:0/O-14:0)[U]); LMGP01040026 (PC(O-14:0/O-16:0)[U])": ["C38H80NO6P", "Glycerophospholipids [GP] with formula: C38H80NO6P"],
        "LMGP10010015 (PA(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[U]); LMGP10010017 (PA(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[S]); LMGP10010016 (PA(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z)))": ["C39H65O8P", "Glycerophospholipids [GP] with formula: C39H65O8P"],
        "LMGP10010025 (PA(16:0/20:4(5Z,8Z,11Z,14Z))); LMGP10010014 (PA(18:2(9Z,12Z)/18:2(9Z,12Z))[U])": ["C39H69O8P", "Glycerophospholipids [GP] with formula: C39H69O8P"],
        "LMGP02080005": ["C39H72NO7P", "Glycerophospholipids [GP] with formula: C39H72NO7P"],
        "LMGP02010047 (PE(18:3(9Z,12Z,15Z)/16:0)); LMGP02010041 (PE(16:0/18:3(9Z,12Z,15Z)))": ["C39H72NO8P", "Glycerophospholipids [GP] with formula: C39H72NO8P"],
        "LMGP10010036 (PA(18:0/18:2(9Z,12Z))); LMGP10010031 (PA(18:1(9Z)/18:1(9Z))[U])": ["C39H73O8P", "Glycerophospholipids [GP] with formula: C39H73O8P"],
        "LMGP02040015": ["C39H74NO6P", "Glycerophospholipids [GP] with formula: C39H74NO6P"],
        "LMGP02010042 (PE(16:0/18:2(9Z,12Z)))": ["C39H74NO8P", "Glycerophospholipids [GP] with formula: C39H74NO8P"],
        "LMGP11010002 (PPA(18:1(9Z)/18:1(9Z)))": ["C39H74O11P2", "Glycerophospholipids [GP] with formula: C39H74O11P2"],
        "LMGP10010037 (PA(18:0/18:1(9Z)))": ["C39H75O8P", "Glycerophospholipids [GP] with formula: C39H75O8P"],
        "LMGP17010001 (PnE(16:0/18:1(9Z)))": ["C39H76NO7P", "Glycerophospholipids [GP] with formula: C39H76NO7P"],
        "LMGP01010534 (PC(15:0/16:1(7Z))[U]); LMGP01010536 (PC(15:0/16:1(9Z))[U]); LMGP01010535 (PC(15:0/16:1(9Z))); LMGP01010002 (PC(16:0/15:1(14))); LMGP01010008 (PC(17:0/14:1(9Z))); LMGP02010018 (PE(16:0/18:1(9Z))[U]); LMGP02010010 (PE(16:0/18:1(11Z))); LMGP02010009 (PE(16:0/18:1(9Z))); LMGP02010100 (PE(18:1(9Z)/16:0)[U]); LMGP02010311 (PE(16:0/18:1(7Z))); LMGP02010310 (PE(16:0/18:1(13Z))[U]); LMGP02010099 (PE(18:1(9Z)/16:0))": ["C39H76NO8P", "Glycerophospholipids [GP] with formula: C39H76NO8P"],
        "LMGP10010013 (PA(18:0/18:0)[U]); LMGP10010028 (PA(18:0/18:0))": ["C39H77O8P", "Glycerophospholipids [GP] with formula: C39H77O8P"],
        "LMGP00000050": ["C39H77O8PS", "Glycerophospholipids [GP] with formula: C39H77O8PS"],
        "LMGP02020018 (PE(O-16:0/18:1(9Z)))": ["C39H78NO7P", "Glycerophospholipids [GP] with formula: C39H78NO7P"],
        "LMGP01010563 (PC(16:0/15:0)[U]); LMGP01010562 (PC(16:0/15:0)); LMGP01010417 (PC(11:0/20:0)); LMGP01010967 (PC(19:0/12:0)); LMGP02010189 (PE(19:0/15:0)[U]); LMGP01010533 (PC(15:0/16:0)[U]); LMGP01010442 (PC(12:0/19:0)[U]); LMGP01010532 (PC(15:0/16:0)); LMGP02010268 (PE(16:0/18:0)[U]); LMGP01010462 (PC(13:0/18:0)[U]); LMGP01010487 (PC(14:0/17:0)[U]); LMGP01010396 (PC(10:0/21:0)); LMGP02010237 (PE(13:0/21:0)[U]); LMGP01010703 (PC(17:0/14:0)[U]); LMGP01011266 (PC(9:0/22:0)); LMGP01010738 (PC(18:0/13:0)[U]); LMGP01011061 (PC(21:0/10:0)); LMGP02010020 (PE(17:0/17:0)[U]); LMGP02010024 (PE(18:0/16:0)[U]); LMGP02010306 (PE(14:0/20:0)[U]); LMGP01010996 (PC(20:0/11:0)); LMGP02010177 (PE(20:0/14:0)[U]); LMGP02010327 (PE-NMe2(16:0/16:0)[U]); LMGP02010325 (PE-NMe2(16:0/16:0))": ["C39H78NO8P", "Glycerophospholipids [GP] with formula: C39H78NO8P"],
        "LMGP02020005 (PE(O-18:0/16:0)[U])": ["C39H80NO7P", "Glycerophospholipids [GP] with formula: C39H80NO7P"],
        "LMGP02040007 (PE-NMe2(O-16:0/O-16:0)); LMGP02040009 (PE-NMe2(O-16:0/O-16:0)[U])": ["C39H82NO6P", "Glycerophospholipids [GP] with formula: C39H82NO6P"],
        "LMGP01010502 (PC(14:0/18:4(9Z,11E,13E,15Z))[U]); LMGP01010568 (PC(16:0/16:4(2E,4E,12E,14E))); LMGP01010698 (PC(16:2(2E,4E)/16:2(2E,4E))); LMGP01010501 (PC(14:0/18:4(9E,11E,13E,15E))[U]); LMGP01010500 (PC(14:0/18:4(9E,11E,13E,15E))); LMGP01010499 (PC(14:0/18:4(6Z,9Z,12Z,15Z)))": ["C40H72NO8P", "Glycerophospholipids [GP] with formula: C40H72NO8P"],
        "LMGP04110001": ["C40H73O9P", "Glycerophospholipids [GP] with formula: C40H73O9P"],
        "LMGP10010003 (PA(17:0/20:4(5Z,8Z,11Z,14Z))); LMGP01010498 (PC(14:0/18:3(9Z,12Z,15Z))[U]); LMGP01010497 (PC(14:0/18:3(9Z,12Z,15Z)))": ["C40H74NO8P", "Glycerophospholipids [GP] with formula: C40H74NO8P"],
        "LMGP04040003": ["C40H75O8P", "Glycerophospholipids [GP] with formula: C40H75O8P"],
        "LMGP03010024 (PS(16:0/18:1(9Z))); LMGP03010007 (PS(16:0/18:1(11Z))); LMGP03010002 (PS(16:0/18:1(9Z))); LMGP03010017 (PS(18:1(9Z)/16:0)[S]); LMGP03010010 (PS(16:0/18:1(9Z))[U])": ["C40H76NO10P", "Glycerophospholipids [GP] with formula: C40H76NO10P"],
        "LMGP01020018 (PC(O-14:0/18:3(9Z,12Z,15Z)))": ["C40H76NO7P", "Glycerophospholipids [GP] with formula: C40H76NO7P"],
        "LMGP01010684 (PC(16:1(9Z)/16:1(9Z))); LMGP01010685 (PC(16:1(9Z)/16:1(9Z))[U]); LMGP01010682 (PC(16:1(9E)/16:1(9E))); LMGP01010683 (PC(16:1(9E)/16:1(9E))[U]); LMGP01010496 (PC(14:0/18:2(9Z,12Z))); LMGP01010495 (PC(14:0/18:2(2E,4E))[U]); LMGP01010494 (PC(14:0/18:2(11Z,14Z)))": ["C40H76NO8P", "Glycerophospholipids [GP] with formula: C40H76NO8P"],
        "LMGP04010008 (PG(16:0/18:1(11Z))); LMGP04010013 (PG(16:0/18:1(9Z))[U])": ["C40H77O10P", "Glycerophospholipids [GP] with formula: C40H77O10P"],
        "LMGP06010006 (PI(17:0/14:1(9Z)))": ["C40H78NO13P", "Glycerophospholipids [GP] with formula: C40H78NO13P"],
        "LMGP01030004 (PC(P-14:0/18:1(9Z))); LMGP01020017 (PC(O-14:0/18:2(9Z,12Z)))": ["C40H78NO7P", "Glycerophospholipids [GP] with formula: C40H78NO7P"],
        "LMGP02010339 (PE-NMe(16:0/18:1(9Z))); LMGP02010335 (PE-NMe(16:0/18:1(9Z))[U]); LMGP01010567 (PC(16:0/16:1(9Z))[U]); LMGP01010566 (PC(16:0/16:1(9Z))); LMGP01010493 (PC(14:0/18:1(9Z))[U]); LMGP01010492 (PC(14:0/18:1(9Z))); LMGP01010491 (PC(14:0/18:1(9E))[U]); LMGP01010490 (PC(14:0/18:1(11Z))); LMGP02010340 (PE-NMe(18:1(9Z)/16:0)); LMGP01010882 (PC(18:1(9Z)/14:0)); LMGP01010883 (PC(18:1(9Z)/14:0)[U])": ["C40H78NO8P", "Glycerophospholipids [GP] with formula: C40H78NO8P"],
        "LMGP05010001 (PGP(16:0/18:1(9Z))); LMGP05010002 (PGP(16:0/18:1(11Z)))": ["C40H78O13P2", "Glycerophospholipids [GP] with formula: C40H78O13P2"],
        "LMGP04010021 (PG(17:0/17:0)[U])": ["C40H79O10P", "Glycerophospholipids [GP] with formula: C40H79O10P"],
        "LMGP04010002 (PG(16:0/18:1(9Z)))": ["C40H80NO10P", "Glycerophospholipids [GP] with formula: C40H80NO10P"],
        "LMGP01020016 (PC(O-14:0/18:1(9Z)))": ["C40H80NO7P", "Glycerophospholipids [GP] with formula: C40H80NO7P"],
        "LMGP01010565 (PC(16:0/16:0)[U]); LMGP01010564 (PC(16:0/16:0)); LMGP01010418 (PC(11:0/21:0)); LMGP01010538 (PC(15:0/17:0)[U]); LMGP02010178 (PE(20:0/15:0)[U]); LMGP01010444 (PC(12:0/20:0)); LMGP01010445 (PC(12:0/20:0)[U]); LMGP01010537 (PC(15:0/17:0)); LMGP01011080 (PC(22:0/10:0)); LMGP01010464 (PC(13:0/19:0)[U]); LMGP01010463 (PC(13:0/19:0)); LMGP01010488 (PC(14:0/18:0)); LMGP01010489 (PC(14:0/18:0)[U]); LMGP02010065 (PE(17:0/18:0)[U]); LMGP02010236 (PE(13:0/22:0)[U]); LMGP02010349 (PE-NMe(17:0/17:0)[U]); LMGP01010705 (PC(17:0/15:0)[U]); LMGP01010704 (PC(17:0/15:0)); LMGP01010398 (PC(10:0/22:0)[U]); LMGP01010397 (PC(10:0/22:0)); LMGP01011267 (PC(9:0/23:0)); LMGP02010357 (PE(18:0(10(R)Me)/16:0)); LMGP01010739 (PC(18:0/14:0)); LMGP02010171 (PE(19:0/16:0)); LMGP01011062 (PC(21:0/11:0)); LMGP02010207 (PE(18:0/17:0)[U]); LMGP02010305 (PE(14:0/21:0)[U]); LMGP01010740 (PC(18:0/14:0)[U]); LMGP01010998 (PC(20:0/12:0)[U]); LMGP01010997 (PC(20:0/12:0)); LMGP02010173 (PE(16:0/19:0)); LMGP02010172 (PE(19:0/16:0)[U]); LMGP02010174 (PE(16:0/19:0)[U]); LMGP01010970 (PC(19:0/13:0))": ["C40H80NO8P", "Glycerophospholipids [GP] with formula: C40H80NO8P"],
        "LMGP01020030 (PC(O-16:0/16:0)[U]); LMGP01020015 (PC(O-14:0/18:0)); LMGP01080023 (PC(16:0/O-16:0)); LMGP01020029 (PC(O-16:0/16:0))": ["C40H82NO7P", "Glycerophospholipids [GP] with formula: C40H82NO7P"],
        "LMGP01040034 (PC(O-16:0/O-16:0)); LMGP01040035 (PC(O-16:0/O-16:0)[U]); LMGP01040027 (PC(O-14:0/O-18:0)[U]); LMGP01040018 (PC(O-12:0/O-20:0)[U]); LMGP01040071 (PC(O-20:0/O-12:0)[U])": ["C40H84NO6P", "Glycerophospholipids [GP] with formula: C40H84NO6P"],
        "LMGP10010038 (PA(16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C41H69O8P", "Glycerophospholipids [GP] with formula: C41H69O8P"],
        "LMGP02010029 (PE(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[U])": ["C41H70NO8P", "Glycerophospholipids [GP] with formula: C41H70NO8P"],
        "LMGP10010024 (PA(18:0/20:4(5Z,8Z,11Z,14Z))); LMGP10010005 (PA(18:0/20:4(5Z,8Z,11Z,14Z)))": ["C41H73O8P", "Glycerophospholipids [GP] with formula: C41H73O8P"],
        "LMGP02010111 (PE(18:2(9Z,12Z)/18:2(9Z,12Z))); LMGP02010012 (PE(18:2(9Z,12Z)/18:2(9Z,12Z))[U]); LMGP02010030 (PE(18:2(9Z,11Z)/18:2(9Z,11Z))[U]); LMGP02010113 (PE(18:2(6Z,9Z)/18:2(6Z,9Z))[U]); LMGP02010112 (PE(18:2(6Z,9Z)/18:2(6Z,9Z))); LMGP20020005 (PE(P-16:0/20:4(5Z,8Z,10E,14Z)(12OH[S]))); LMGP20020008 (PE(P-16:0/20:4(5Z,8Z,11Z,13E)(15OH[S]))); LMGP20020011 (PE(P-16:0/20:4(6E,8Z,11Z,14Z)(5OH[S]))); LMGP02010096 (PE(16:0/20:4(5Z,8Z,11Z,14Z)))": ["C41H74NO8P", "Glycerophospholipids [GP] with formula: C41H74NO8P"],
        "LMGP02020019 (PE(O-16:0/20:4(5Z,8Z,11Z,14Z)))": ["C41H76NO7P", "Glycerophospholipids [GP] with formula: C41H76NO7P"],
        "LMGP02010045 (PE(18:0/18:3(9Z,12Z,15Z))[U]); LMGP02010048 (PE(18:1(9Z)/18:2(9Z,12Z)))": ["C41H76NO8P", "Glycerophospholipids [GP] with formula: C41H76NO8P"],
        "LMGP01010543 (PC(15:0/18:2(9Z,12Z))); LMGP01010544 (PC(15:0/18:2(9Z,12Z))[U]); LMGP02010052 (PE(18:1(9Z)/18:1(9Z))); LMGP02010044 (PE(18:0/18:2(9Z,12Z))); LMGP02010043 (PE(18:0/18:2(9Z,12Z))[U]); LMGP02010110 (PE(18:1(6Z)/18:1(6Z))[U]); LMGP02010011 (PE(18:1(9Z)/18:1(9Z))[U]); LMGP02010034 (PE(18:1(11Z)/18:1(9Z))[U]); LMGP02010039 (PE(18:1(9E)/18:1(9E))); LMGP02010109 (PE(18:1(6Z)/18:1(6Z))); LMGP02010028 (PE(18:1(9E)/18:1(9E))[U])": ["C41H78NO8P", "Glycerophospholipids [GP] with formula: C41H78NO8P"],
        "LMGP06010007 (PI(16:0/16:0))": ["C41H79O13P", "Glycerophospholipids [GP] with formula: C41H79O13P"],
        "LMGP02030004 (PE(P-18:0/18:1(9Z)))": ["C41H80NO7P", "Glycerophospholipids [GP] with formula: C41H80NO7P"],
        "LMGP02010330 (PE-NMe2(18:1(9Z)/16:0)); LMGP01010541 (PC(15:0/18:1(11Z))); LMGP01010542 (PC(15:0/18:1(9Z))[U]); LMGP02010299 (PE(18:0/18:1(13Z))[U]); LMGP02010050 (PE(18:1(9Z)/18:0)); LMGP02010051 (PE(18:1(9E)/18:0)[U]); LMGP02010046 (PE(18:0/18:1(9E))[U]); LMGP02010049 (PE(18:1(9Z)/18:0)[U]); LMGP02010036 (PE(18:0/18:1(9Z))); LMGP02010026 (PE(18:0/18:1(9Z))[U]); LMGP02010301 (PE(18:0/18:1(7Z))); LMGP01010571 (PC(16:0/17:1(9Z))); LMGP01010572 (PC(16:0/17:1(9Z))[U]); LMGP02010312 (PE(16:0/20:1(11Z))); LMGP02010322 (PE-NMe2(16:0/18:1(9Z)))": ["C41H80NO8P", "Glycerophospholipids [GP] with formula: C41H80NO8P"],
        "LMGP01010569 (PC(16:0/17:0)); LMGP01010419 (PC(11:0/22:0)); LMGP01010540 (PC(15:0/18:0)[U]); LMGP02010190 (PE(19:0/17:0)[U]); LMGP01010539 (PC(15:0/18:0)); LMGP01011268 (PC(9:0/24:0)[U]); LMGP02010270 (PE(16:0/20:0)); LMGP01011081 (PC(22:0/11:0)); LMGP01010465 (PC(13:0/20:0)); LMGP02010066 (PE(17:0/19:0)[U]); LMGP01010706 (PC(17:0/16:0)[U]); LMGP01010399 (PC(10:0/23:0)); LMGP02010219 (PE(21:0/15:0)[U]); LMGP01011063 (PC(21:0/12:0)); LMGP02010025 (PE(18:0/18:0)[U]); LMGP01011122 (PC(23:0/10:0)[U]); LMGP02010304 (PE(14:0/22:0)[U]); LMGP01010741 (PC(18:0/15:0)[U]); LMGP01010570 (PC(16:0/17:0)[U]); LMGP01010999 (PC(20:0/13:0)); LMGP01010503 (PC(14:0/19:0)[U]); LMGP02010097 (PE(18:0/18:0)); LMGP02010323 (PE-NMe2(17:0/17:0)[U]); LMGP01010971 (PC(19:0/14:0))": ["C41H82NO8P", "Glycerophospholipids [GP] with formula: C41H82NO8P"],
        "LMGP01020032 (PC(O-16:0/17:0)[U]); LMGP01020031 (PC(O-16:0/17:0)); LMGP02020009 (PE(O-16:0/20:0)); LMGP02080006 (PE(18:0/O-18:0)[U]); LMGP02020011 (PE(O-18:0/18:0)); LMGP02020010 (PE(O-18:0/18:0)[U])": ["C41H84NO7P", "Glycerophospholipids [GP] with formula: C41H84NO7P"],
        "LMGP02040006 (PE(O-20:0/O-16:0)); LMGP02040005 (PE(O-18:0/O-18:0)); LMGP02040002 (PE(O-18:0/O-18:0)[U])": ["C41H86NO6P", "Glycerophospholipids [GP] with formula: C41H86NO6P"],
        "LMGP01010447 (PC(12:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C42H72NO8P", "Glycerophospholipids [GP] with formula: C42H72NO8P"],
        "LMGP03010023 (PS(18:2(9Z,12Z)/18:2(9Z,12Z))); LMGP03010038 (PS(16:0/20:4(5Z,8Z,11Z,14Z))); LMGP03010016 (PS(18:2(9Z,12Z)/18:2(9Z,12Z))[U])": ["C42H74NO10P", "Glycerophospholipids [GP] with formula: C42H74NO10P"],
        "LMGP01010692 (PC(16:1(9Z)/18:4(6Z,9Z,12Z,15Z))); LMGP01010509 (PC(14:0/20:5(5Z,8Z,11Z,14Z,17Z))[U]); LMGP01010508 (PC(14:0/20:5(5Z,8Z,11Z,14Z,17Z)))": ["C42H74NO8P", "Glycerophospholipids [GP] with formula: C42H74NO8P"],
        "LMGP04010036 (PG(16:0/20:4(5Z,8Z,11Z,14Z))); LMGP04010017 (PG(18:2(9Z,12Z)/18:2(9Z,12Z))[U])": ["C42H75O10P", "Glycerophospholipids [GP] with formula: C42H75O10P"],
        "LMGP03010018 (PS(18:1(9Z)/18:2(9Z,12Z))[U])": ["C42H76NO10P", "Glycerophospholipids [GP] with formula: C42H76NO10P"],
        "LMGP01010963 (PC(18:4(9Z,11E,13E,15Z)/16:0)); LMGP02010332 (PE-NMe(18:2(9Z,12Z)/18:2(9Z,12Z))[U]); LMGP01010699 (PC(16:2(2E,4E)/18:2(2E,4E))); LMGP01010507 (PC(14:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01010934 (PC(18:2(9Z,12Z)/16:2(5Z,8Z))[U]); LMGP02010003 (PE(17:0/20:4(5Z,8Z,11Z,14Z))); LMGP01010731 (PC(17:2(9Z,12Z)/17:2(9Z,12Z))); LMGP01010606 (PC(16:0/18:4(9Z,11E,13E,15Z))); LMGP01010607 (PC(16:0/18:4(9Z,11E,13E,15Z))[U]); LMGP01010604 (PC(16:0/18:4(9E,11E,13E,15E))); LMGP01010605 (PC(16:0/18:4(9E,11E,13E,15E))[U]); LMGP01010603 (PC(16:0/18:4(6Z,9Z,12Z,15Z))); LMGP01010608 (PC(16:0/18:4(9Z,11Z,13Z,15Z))); LMGP01010506 (PC(14:0/20:4(5Z,8Z,11Z,14Z)))": ["C42H76NO8P", "Glycerophospholipids [GP] with formula: C42H76NO8P"],
        "LMGP03010033 (PS(18:0/18:2(9Z,12Z))[U]); LMGP03010032 (PS(18:2(9Z,12Z)/18:0)[U]); LMGP03010031 (PS(18:0/18:2(9Z,12Z))); LMGP03010030 (PS(18:1(9Z)/18:1(9Z))); LMGP03010013 (PS(18:1(9Z)/18:1(9Z))[U]); LMGP03010014 (PS(18:1(9E)/18:1(9E))[U])": ["C42H78NO10P", "Glycerophospholipids [GP] with formula: C42H78NO10P"],
        "LMGP01020021 (PC(O-14:0/20:4(5Z,8Z,11Z,14Z))); LMGP01020022 (PC(O-14:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01080005; LMGP02080004": ["C42H78NO7P", "Glycerophospholipids [GP] with formula: C42H78NO7P"],
        "LMGP01010546 (PC(15:0/19:3(9Z,12Z,15Z))[U]); LMGP01010681 (PC(16:1(7Z)/18:2(9Z,12Z))[U]); LMGP01010598 (PC(16:0/18:3(6Z,9Z,12Z))); LMGP01010599 (PC(16:0/18:3(6Z,9Z,12Z))[U]); LMGP01010597 (PC(16:0/18:3(5E,9Z,12Z))[U]); LMGP01010691 (PC(16:1(9Z)/18:2(9Z,12Z))[U]); LMGP01010690 (PC(16:1(9Z)/18:2(9Z,12Z))); LMGP01010602 (PC(16:0/18:3(9Z,12Z,15Z))[U]); LMGP01010600 (PC(16:0/18:3(9E,12E,15E))[U]); LMGP01010601 (PC(16:0/18:3(9Z,12Z,15Z)))": ["C42H78NO8P", "Glycerophospholipids [GP] with formula: C42H78NO8P"],
        "LMGP04010033 (PG(18:1(9E)/18:1(9E))); LMGP04010016 (PG(18:1(9E)/18:1(9E))[U]); LMGP04010015 (PG(18:1(9Z)/18:1(9Z))[U]); LMGP04010034 (PG(18:1(11E)/18:1(11E))[U])": ["C42H79O10P", "Glycerophospholipids [GP] with formula: C42H79O10P"],
        "LMGP03010025 (PS(18:0/18:1(9Z))); LMGP03010034 (PS(18:1(9Z)/18:0)); LMGP03010005 (PS(18:0/18:1(9Z))); LMGP03010012 (PS(18:0/18:1(9Z))[U]); LMGP03010019 (PS(18:1(9Z)/18:0)[U])": ["C42H80NO10P", "Glycerophospholipids [GP] with formula: C42H80NO10P"],
        "LMGP01040094": ["C42H80NO6P", "Glycerophospholipids [GP] with formula: C42H80NO6P"],
        "LMGP01020043 (PC(O-16:0/18:3(9Z,12Z,15Z))[S]); LMGP01020042 (PC(O-16:0/18:3(9Z,12Z,15Z))); LMGP01020041 (PC(O-16:0/18:3(6Z,9Z,12Z))); LMGP01030008 (PC(P-16:0/18:2(9Z,12Z)))": ["C42H80NO7P", "Glycerophospholipids [GP] with formula: C42H80NO7P"],
        "LMGP02010338 (PE-NMe(18:1(9Z)/18:1(9Z))); LMGP02010331 (PE-NMe(18:1(9E)/18:1(9E))); LMGP02010333 (PE-NMe(18:1(9Z)/18:1(9Z))[U]); LMGP01010587 (PC(16:0/18:2(2E,4E))); LMGP01010688 (PC(16:1(9Z)/18:1(9Z))); LMGP01010689 (PC(16:1(9Z)/18:1(9Z))[U]); LMGP01010687 (PC(16:1(9Z)/18:1(11Z))); LMGP01010680 (PC(16:1(7Z)/18:1(9Z))[U]); LMGP01010592 (PC(16:0/18:2(9E,12E))); LMGP01010593 (PC(16:0/18:2(9E,12E))[U]); LMGP01010590 (PC(16:0/18:2(9E,11E))); LMGP01010591 (PC(16:0/18:2(9E,11Z))); LMGP01010596 (PC(16:0/18:2(9Z,12Z))[U]); LMGP01010594 (PC(16:0/18:2(9Z,12Z))); LMGP01010595 (PC(16:0/18:2(9Z,12Z))[S]); LMGP01010926 (PC(18:2(6Z,9Z)/16:0)); LMGP01010589 (PC(16:0/18:2(6Z,9Z))); LMGP01010588 (PC(16:0/18:2(2Z,4Z))); LMGP01010678 (PC(16:1(2Z)/18:1(9Z))); LMGP01010932 (PC(18:2(9Z,12Z)/16:0)); LMGP01010933 (PC(18:2(9Z,12Z)/16:0)[U]); LMGP02010350 (PE-NMe(18:1(9E)/18:1(9E))[U]); LMGP01010727 (PC(17:1(10Z)/17:1(10Z))); LMGP01010726 (PC(17:1(10E)/17:1(10E))[U]); LMGP01010728 (PC(17:1(9Z)/17:1(9Z))); LMGP01010585 (PC(16:0/18:2(10E,12Z))); LMGP01010586 (PC(16:0/18:2(11Z,13Z))); LMGP01010920 (PC(18:2(2E,4E)/16:0)); LMGP01010745 (PC(18:0/16:2(2E,4E))); LMGP01010886 (PC(18:1(9Z)/16:1(3E))[U]); LMGP01010887 (PC(18:1(9Z)/16:1(9Z)))": ["C42H80NO8P", "Glycerophospholipids [GP] with formula: C42H80NO8P"],
        "LMGP04010037 (PG(18:0/18:1(9Z))); LMGP04010029 (PG(18:0/18:1(9Z))[U])": ["C42H81O10P", "Glycerophospholipids [GP] with formula: C42H81O10P"],
        "LMGP03010036 (PS(18:0/18:0)); LMGP03010035 (PS(16:0/20:0)); LMGP03010011 (PS(18:0/18:0)[U])": ["C42H82NO10P", "Glycerophospholipids [GP] with formula: C42H82NO10P"],
        "LMGP01020039 (PC(O-16:0/18:2(9Z,12Z))); LMGP16010001 (PnC(16:0/18:1(9Z))); LMGP01020040 (PC(O-16:0/18:2(9Z,12Z))[U]); LMGP01030006 (PC(P-16:0/18:1(9Z))); LMGP01030007 (PC(P-16:0/18:1(9Z))[U]); LMGP01030005 (PC(O-16:1(1E)/18:1(9Z))[U])": ["C42H82NO7P", "Glycerophospholipids [GP] with formula: C42H82NO7P"],
        "LMGP01010581 (PC(16:0/18:1(9E))); LMGP01010583 (PC(16:0/18:1(9Z))[S]); LMGP01010582 (PC(16:0/18:1(9E))[U]); LMGP01010686 (PC(16:1(9Z)/18:0)[U]); LMGP01010584 (PC(16:0/18:1(9Z))[U]); LMGP01010005 (PC(16:0/18:1(9Z))); LMGP01010679 (PC(16:1(7Z)/18:0)[U]); LMGP01010874 (PC(18:1(9E)/16:0)[U]); LMGP01010580 (PC(16:0/18:1(6Z))[U]); LMGP01010744 (PC(18:0/16:1(9Z))); LMGP01010579 (PC(16:0/18:1(6Z))); LMGP01010575 (PC(16:0/18:1(11E))); LMGP01010577 (PC(16:0/18:1(11Z))[U]); LMGP01010576 (PC(16:0/18:1(11Z))); LMGP01010578 (PC(16:0/18:1(6E))); LMGP01010884 (PC(18:1(9Z)/16:0)); LMGP01010885 (PC(18:1(9Z)/16:0)[U])": ["C42H82NO8P", "Glycerophospholipids [GP] with formula: C42H82NO8P"],
        "LMGP04010038 (PG(18:0/18:0)); LMGP04010014 (PG(18:0/18:0)[U])": ["C42H83O10P", "Glycerophospholipids [GP] with formula: C42H83O10P"],
        "LMGP01020038 (PC(O-16:0/18:1(9Z))[U]); LMGP01020036 (PC(O-16:0/18:1(9E))[U]); LMGP01020037 (PC(O-16:0/18:1(9Z))[S]); LMGP01020153 (PC(O-18:1(9Z)/16:0)[U]); LMGP01020152 (PC(O-18:1(9Z)/16:0)); LMGP01020089 (PC(O-18:0/16:1(9Z))); LMGP01020003 (PC(O-16:0/18:1(9Z)))": ["C42H84NO7P", "Glycerophospholipids [GP] with formula: C42H84NO7P"],
        "LMGP02010336 (PE-NMe(18:0/18:0)[U]); LMGP02010180 (PE(20:0/17:0)[U]); LMGP02010181 (PE(19:0/18:0)[U]); LMGP02010185 (PE(21:0/16:0)[U]); LMGP01010545 (PC(15:0/19:0)); LMGP01010420 (PC(11:0/23:0)); LMGP02010271 (PE(16:0/21:0)[U]); LMGP01010446 (PC(12:0/22:0)); LMGP01011083 (PC(22:0/12:0)[U]); LMGP01011082 (PC(22:0/12:0)); LMGP01010466 (PC(13:0/21:0)); LMGP01010505 (PC(14:0/20:0)); LMGP02010067 (PE(17:0/20:0)); LMGP02010344 (PE-NMe(18:0/18:0)); LMGP01010708 (PC(17:0/17:0)[U]); LMGP01010707 (PC(17:0/17:0)); LMGP01011289 (PC(14:0/20:0)[U]); LMGP01011064 (PC(21:0/13:0)); LMGP01011123 (PC(23:0/11:0)[U]); LMGP02010303 (PE(14:0/23:0)[U]); LMGP02010068 (PE(18:0/19:0)[U]); LMGP01010743 (PC(18:0/16:0)[U]); LMGP01010742 (PC(18:0/16:0)); LMGP01010574 (PC(16:0/18:0)[U]); LMGP01011000 (PC(20:0/14:0)); LMGP01010573 (PC(16:0/18:0)); LMGP01010400 (PC(10:0/24:0)); LMGP01010972 (PC(19:0/15:0))": ["C42H84NO8P", "Glycerophospholipids [GP] with formula: C42H84NO8P"],
        "LMGP01040038 (PC(O-16:0/O-18:1(9E))[U]); LMGP01040039 (PC(O-16:0/O-18:1(9Z))); LMGP01040029 (PC(O-16:/O-18:1(9Z))[U]); LMGP01040062 (PC(O-18:1(9Z)/O-16:0)); LMGP01040059 (PC(O-18:1(9E)/O-16:0)[U])": ["C42H86NO6P", "Glycerophospholipids [GP] with formula: C42H86NO6P"],
        "LMGP01020034 (PC(O-16:0/18:0)[S]); LMGP01020035 (PC(O-16:0/18:0)[U]); LMGP01020033 (PC(O-16:0/18:0)); LMGP01080024 (PC(18:0/O-16:0)); LMGP01020088 (PC(O-18:0/16:0)[U]); LMGP01020087 (PC(O-18:0/16:0)[S]); LMGP01020086 (PC(O-18:0/16:0)); LMGP01020076 (PC(O-17:0/17:0))": ["C42H86NO7P", "Glycerophospholipids [GP] with formula: C42H86NO7P"],
        "LMGP01040036 (PC(O-16:0/O-18:0)); LMGP01040037 (PC(O-16:0/O-18:0)[U])": ["C42H88NO6P", "Glycerophospholipids [GP] with formula: C42H88NO6P"],
        "LMGP02080001": ["C43H70NO7P", "Glycerophospholipids [GP] with formula: C43H70NO7P"],
        "LMGP02040013": ["C43H72NO6P", "Glycerophospholipids [GP] with formula: C43H72NO6P"],
        "LMGP02080008": ["C43H72NO7P", "Glycerophospholipids [GP] with formula: C43H72NO7P"],
        "LMGP10010039 (PA(18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C43H73O8P", "Glycerophospholipids [GP] with formula: C43H73O8P"],
        "LMGP02040016": ["C43H74NO6P", "Glycerophospholipids [GP] with formula: C43H74NO6P"],
        "LMGP02030001 (PE(P-16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C43H74NO7P", "Glycerophospholipids [GP] with formula: C43H74NO7P"],
        "LMGP20020014 (PE(P-16:0/22:6(4Z,7Z,10Z,12E,16Z,19Z)(14OH))); LMGP02010095 (PE(16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C43H74NO8P", "Glycerophospholipids [GP] with formula: C43H74NO8P"],
        "LMGP20020003 (PE(16:0/22:6(54Z,7Z,10Z,12E,16Z,19Z)(14OH)))": ["C43H74NO9P", "Glycerophospholipids [GP] with formula: C43H74NO9P"],
        "LMGP20020006 (PE(P-18:1(9Z)/20:4(5Z,8Z,10E,14Z)(12OH[S]))); LMGP20020009 (PE(P-18:1(9Z)/20:4(5Z,8Z,11Z,13E)(15OH[S]))); LMGP20020012 (PE(P-18:1(9Z)/20:4(6E,8Z,11Z,14Z)(5OH[S])))": ["C43H76NO8P", "Glycerophospholipids [GP] with formula: C43H76NO8P"],
        "LMGP02020008 (PE(O-18:0/20:5(5Z,8Z,11Z,14Z,17Z))); LMGP02020006 (PE(O-16:0/22:5(4Z,7Z,10Z,13Z,16Z))); LMGP02020007 (PE(O-16:0/22:5(7Z,10Z,13Z,16Z,19Z))); LMGP02030003 (PE(P-18:0/20:4(5Z,8Z,11Z,14Z)))": ["C43H78NO7P", "Glycerophospholipids [GP] with formula: C43H78NO7P"],
        "LMGP20020007 (PE(P-18:0/20:4(5Z,8Z,10E,14Z)(12OH[S]))); LMGP02010119 (PE(18:0/20:4(5Z,8Z,11Z,14Z))[S]); LMGP02010118 (PE(18:0/20:4(5Z,8Z,11Z,14Z))); LMGP02010123 (PE(20:4(5E,8E,11E,14E)/18:0)[U]); LMGP02010129 (PE(18:0/20:4(5E,8E,11E,14E))); LMGP01010931 (PC(18:2(9Z,12E)/17:2(9Z,11E))); LMGP02010130 (PE(18:0/20:4(5E,8E,11E,14E))[U]); LMGP01010548 (PC(15:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP02010027 (PE(18:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP02010115 (PE(18:1(9Z)/20:3(5Z,8Z,11Z))); LMGP02010114 (PE(20:0/18:4(6Z,9Z,12Z,15Z))); LMGP02010117 (PE(16:0/22:4(7Z,10Z,13Z,16Z))[U]); LMGP02010116 (PE(16:0/22:4(7Z,10Z,13Z,16Z))); LMGP20020013 (PE(P-18:0/20:4(6E,8Z,11Z,14Z)(5OH[S]))); LMGP20020010 (PE(P-18:0/20:4(5Z,8Z,11Z,13E)(15OH[S]))); LMGP02010321 (PE-NMe2(16:0/20:4(5Z,8Z,11Z,14Z))[S])": ["C43H78NO8P", "Glycerophospholipids [GP] with formula: C43H78NO8P"],
        "LMGP20020001 (PE(18:0/20:4(5Z,8Z,10E,14Z)(12OH[S]))); LMGP20020002 (PE(18:0/20:4(5Z,8Z,11Z,13E)(15OH[S])))": ["C43H78NO9P", "Glycerophospholipids [GP] with formula: C43H78NO9P"],
        "LMGP03010003 (PS(17:0/20:4(5Z,8Z,11Z,14Z)))": ["C43H79N2O10P", "Glycerophospholipids [GP] with formula: C43H79N2O10P"],
        "LMGP04010006 (PG(17:0/20:4(5Z,8Z,11Z,14Z)))": ["C43H80NO10P", "Glycerophospholipids [GP] with formula: C43H80NO10P"],
        "LMGP01020027 (PC(O-15:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01020026 (PC(O-15:0/20:4(5Z,8Z,11Z,14Z)))": ["C43H80NO7P", "Glycerophospholipids [GP] with formula: C43H80NO7P"],
        "LMGP01010611 (PC(16:0/19:3(9Z,12Z,15Z))[U])": ["C43H80NO8P", "Glycerophospholipids [GP] with formula: C43H80NO8P"],
        "LMGP06010001 (PI(16:0/18:1(9Z)))": ["C43H81O13P", "Glycerophospholipids [GP] with formula: C43H81O13P"],
        "LMGP00000048 (PT(18:0/18:1(9Z)))": ["C43H82NO10P", "Glycerophospholipids [GP] with formula: C43H82NO10P"],
        "LMGP01010712 (PC(17:0/18:2(9Z,12Z))[U]); LMGP02010124 (PE(18:0/20:2(11Z,14Z))); LMGP02010125 (PE(20:0/18:2(9Z,12Z))); LMGP02010126 (PE(18:1(9Z)/20:1(11Z))); LMGP02010127 (PE(18:1(9Z)/20:1(11Z))[U]); LMGP02010120 (PE(20:2(5Z,8Z)/18:0)[S]); LMGP02010121 (PE(20:2(5Z,8Z)/18:0)[U]); LMGP02010122 (PE(20:2(5Z,8Z)/18:0)); LMGP02010128 (PE(18:0/20:2(11Z,14Z))[U]); LMGP01010730 (PC(17:1(9Z)/18:1(9Z))[U]); LMGP01010610 (PC(16:0/19:2(9Z,12Z))[U]); LMGP02010329 (PE-NMe2(18:1(9E)/18:1(9E))); LMGP02010326 (PE-NMe2(18:1(9Z)/18:1(9Z))); LMGP02010324 (PE-NMe2(18:1(9Z)/18:1(9Z))[U])": ["C43H82NO8P", "Glycerophospholipids [GP] with formula: C43H82NO8P"],
        "LMGP07010001 (PIP[3'](16:0/18:1(9Z)))": ["C43H82O16P2", "Glycerophospholipids [GP] with formula: C43H82O16P2"],
        "LMGP03010037 (PS(18:0/19:0)[U])": ["C43H84NO10P", "Glycerophospholipids [GP] with formula: C43H84NO10P"],
        "LMGP01010711 (PC(17:0/18:1(9Z))); LMGP02010138 (PE(20:0/18:1(11Z))); LMGP02010137 (PE(20:0/18:1(13Z))); LMGP02010136 (PE(16:0/22:1(13Z))); LMGP02010135 (PE(20:0/18:1(9Z))); LMGP02010139 (PE(20:0/18:1(7Z))); LMGP01010729 (PC(17:1(9Z)/18:0)[U]); LMGP02010144 (PE(18:1(9Z)/20:0)[U]); LMGP02010142 (PE(18:0/20:1(11Z))[U]); LMGP02010143 (PE(18:1(9Z)/20:0)); LMGP02010141 (PE(18:0/20:1(11Z)))": ["C43H84NO8P", "Glycerophospholipids [GP] with formula: C43H84NO8P"],
        "LMGP10010035 (PA(18:0/22:0)); LMGP10010034 (PA(20:0/20:0)[U]); LMGP10010033 (PA(18:0/22:0)[U])": ["C43H85O8P", "Glycerophospholipids [GP] with formula: C43H85O8P"],
        "LMGP01020077 (PC(O-17:0/18:1(9Z)))": ["C43H86NO7P", "Glycerophospholipids [GP] with formula: C43H86NO7P"],
        "LMGP01010547 (PC(15:0/20:0)[U]); LMGP01010421 (PC(11:0/24:0)); LMGP01011143 (PC(24:0/11:0)[U]); LMGP01010448 (PC(12:0/23:0)); LMGP01011084 (PC(22:0/13:0)); LMGP01010467 (PC(13:0/22:0)[U]); LMGP01010710 (PC(17:0/18:0)[U]); LMGP01010709 (PC(17:0/18:0)); LMGP02010134 (PE(16:0/22:0)[U]); LMGP02010133 (PE(18:0/20:0)[U]); LMGP02010132 (PE(16:0/22:0)); LMGP02010131 (PE(20:0/18:0)); LMGP02010038 (PE(19:0/19:0)[U]); LMGP01011065 (PC(21:0/14:0)); LMGP02010208 (PE(21:0/17:0)[U]); LMGP02010206 (PE(22:0/16:0)[U]); LMGP01011124 (PC(23:0/12:0)[U]); LMGP02010069 (PE(18:0/20:0)); LMGP01010746 (PC(18:0/17:0)[U]); LMGP01010609 (PC(16:0/19:0)[U]); LMGP01010510 (PC(14:0/21:0)[U]); LMGP02010261 (PE(17:0/21:0)[U]); LMGP01011001 (PC(20:0/15:0)[U]); LMGP02010317 (PE-NMe2(18:0/18:0)); LMGP02010318 (PE-NMe2(18:0/18:0)[U]); LMGP01010401 (PC(10:0/25:0)); LMGP01010973 (PC(19:0/16:0)[U])": ["C43H86NO8P", "Glycerophospholipids [GP] with formula: C43H86NO8P"],
        "LMGP02020013 (PE(O-18:0/20:0)[U]); LMGP02020012 (PE(O-16:0/22:0)[U]); LMGP02020015 (PE(O-16:0/22:0)); LMGP02020014 (PE(O-18:0/20:0)); LMGP01020045 (PC(O-16:0/19:0)[U]); LMGP01020044 (PC(O-16:0/19:0))": ["C43H88NO7P", "Glycerophospholipids [GP] with formula: C43H88NO7P"],
        "LMGP04100001 (Bis-[2-lyso-3-arachidonoyl-sn-glycerol]-1-phosphate)": ["C44H71O10P", "Glycerophospholipids [GP] with formula: C44H71O10P"],
        "LMGP04110002": ["C44H71O9P", "Glycerophospholipids [GP] with formula: C44H71O9P"],
        "LMGP01010965 (PC(18:4(9Z,11Z,13Z,15Z)/18:4(9Z,11Z,13Z,15Z))[U]); LMGP01010964 (PC(18:4(9Z,11E,13E,15Z)/18:4(9Z,11E,13E,15Z))); LMGP01010962 (PC(18:4(9E,11E,13E,15E)/18:4(9E,11E,13E,15E))[U]); LMGP01010961 (PC(18:4(9E,11E,13E,15E)/18:4(9E,11E,13E,15E))); LMGP01010959 (PC(18:4(5Z,8Z,11Z,14Z)/18:4(5Z,8Z,11Z,14Z))[U])": ["C44H72NO8P", "Glycerophospholipids [GP] with formula: C44H72NO8P"],
        "LMGP04040002": ["C44H73O8P", "Glycerophospholipids [GP] with formula: C44H73O8P"],
        "LMGP04110003": ["C44H73O9P", "Glycerophospholipids [GP] with formula: C44H73O9P"],
        "LMGP01010960 (PC(18:4(9E,11E,13E,15E)/18:2(9Z,12Z))); LMGP01010513 (PC(14:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01010952 (PC(18:3(9E,11E,13E)/18:3(9E,11E,13E))); LMGP01010953 (PC(18:3(9E,11E,13E)/18:3(9E,11E,13E))[U]); LMGP01010950 (PC(18:3(6Z,9Z,12Z)/18:3(6Z,9Z,12Z))[U]); LMGP01010951 (PC(18:3(8E,10E,12E)/18:3(8E,10E,12E))[U]); LMGP01010956 (PC(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))); LMGP01010957 (PC(18:3(9Z,12Z,15Z)/18:3(9Z,12Z,15Z))[U]); LMGP01010954 (PC(18:3(9Z,11E,13E)/18:3(9Z,11E,13E))); LMGP01010512 (PC(14:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C44H76NO8P", "Glycerophospholipids [GP] with formula: C44H76NO8P"],
        "LMGP03010039 (PS(18:0/20:4(5Z,8Z,11Z,14Z)))": ["C44H78NO10P", "Glycerophospholipids [GP] with formula: C44H78NO10P"],
        "LMGP01011305 (PC(16:1(7Z)/20:4(5Z,8Z,11Z,14Z))); LMGP01010958 (PC(18:4(2E,4E,6E,11Z)/18:1(11Z))[U]); LMGP01010695 (PC(16:1(9Z)/20:4(5Z,8Z,11Z,14Z))); LMGP01010694 (PC(16:1(9Z)/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01010633 (PC(16:0/20:5(5Z,8Z,11Z,14Z,17Z))); LMGP01010632 (PC(16:0/20:5(5E,8E,11E,14E,17E))[U]); LMGP01010634 (PC(16:0/20:5(5Z,8Z,11Z,14Z,17Z))[U])": ["C44H78NO8P", "Glycerophospholipids [GP] with formula: C44H78NO8P"],
        "LMGP04010039 (PG(18:0/20:4(5Z,8Z,11Z,14Z)))": ["C44H79O10P", "Glycerophospholipids [GP] with formula: C44H79O10P"],
        "LMGP01020058 (PC(O-16:0/20:5(5Z,8Z,11Z,14Z,17Z))); LMGP01030010 (PC(P-16:0/20:4(5Z,8Z,11Z,14Z)))": ["C44H80NO7P", "Glycerophospholipids [GP] with formula: C44H80NO7P"],
        "LMGP01010897 (PC(18:1(9Z)/18:3(6Z,9Z,12Z))[U]); LMGP01010899 (PC(18:1(9Z)/18:3(9Z,12Z,15Z))[U]); LMGP01010898 (PC(18:1(9Z)/18:3(9Z,12Z,15Z))); LMGP01010955 (PC(18:3(9Z,12Z,15Z)/18:1(9Z))); LMGP01010949 (PC(18:3(6Z,9Z,12Z)/18:1(9Z))[U]); LMGP01010938 (PC(18:2(9Z,12Z)/18:2(9Z,12Z))[S]); LMGP01010939 (PC(18:2(9Z,12Z)/18:2(9Z,12Z))[U]); LMGP01010929 (PC(18:2(9E,12Z)/18:2(9E,12Z))[U]); LMGP01010928 (PC(18:2(6Z,9Z)/18:2(6Z,9Z))[U]); LMGP01010921 (PC(18:2(2E,4E)/18:2(2E,4E))); LMGP01010927 (PC(18:2(6Z,9Z)/18:2(6Z,9Z))); LMGP01010925 (PC(18:2(5Z,9Z)/18:2(5Z,9Z))[U]); LMGP01010924 (PC(18:2(2Z,4Z)/18:2(2Z,4Z))); LMGP01010918 (PC(18:2(15E,17E)/18:2(15E,17E))[U]); LMGP01010919 (PC(18:2(2E).4/18:2(2E,4E))[S]); LMGP01010007 (PC(16:0/20:4(5Z,8Z,11Z,14Z))); LMGP01011056 (PC(20:4(8E,11E,14E,17E)/16:0)); LMGP01011050 (PC(20:4(5Z,8Z,11Z,14Z)/16:0)[U]); LMGP01011049 (PC(20:4(5Z,8Z,11Z,14Z)/16:0)); LMGP01010930 (PC(18:2(9Z,11Z)/18:2(9Z,11Z))); LMGP01010629 (PC(16:0/20:4(5E,8E,11E,14E))); LMGP01010631 (PC(16:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01010630 (PC(16:0/20:4(5E,8E,11E,14E))[U]); LMGP01010937 (PC(18:2(9Z,12Z)/18:2(9Z,12Z))); LMGP01010776 (PC(18:0/18:4(9E,11E,13Z,15Z))[U]); LMGP01010774 (PC(18:0/18:4(9E,11E,13E,15E))); LMGP01010775 (PC(18:0/18:4(9E,11E,13E,15E))[U]); LMGP01010772 (PC(18:0/18:4(5Z,8Z,11Z,14Z))[U]); LMGP01010773 (PC(18:0/18:4(6Z,9Z,12Z,15Z))); LMGP01010923 (PC(18:2(2E,4E)/18:2(2E,4E))[U]); LMGP01010922 (PC(18:2(2E,4E)/18:2(2E,4E))[S])": ["C44H80NO8P", "Glycerophospholipids [GP] with formula: C44H80NO8P"],
        "LMGP20010003 (PC(16:0/20:4(6E,8Z,11Z,14Z)(5OH[S]))); LMGP20010002 (PC(16:0/20:4(5Z,8Z,10E,14Z)(12OH[S])))": ["C44H80NO9P", "Glycerophospholipids [GP] with formula: C44H80NO9P"],
        "LMGP13010003 (CDP-DG(16:0/16:0))": ["C44H81N3O15P2", "Glycerophospholipids [GP] with formula: C44H81N3O15P2"],
        "LMGP01020057 (PC(O-16:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01020054 (PC(O-16:0/20:4(5E,8E,11E,14E))); LMGP01020055 (PC(O-16:0/20:4(5E,8E,11E,14E))[U]); LMGP01020056 (PC(O-16:0/20:4(5Z,8Z,11Z,14Z)))": ["C44H82NO7P", "Glycerophospholipids [GP] with formula: C44H82NO7P"],
        "LMGP01010893 (PC(18:1(9Z)/18:2(6Z,9Z))); LMGP01010896 (PC(18:1(9Z)/18:2(9Z,12Z))[U]); LMGP01010895 (PC(18:1(9Z)/18:2(9Z,12Z))); LMGP01010894 (PC(18:1(9Z)/18:2(6Z,9Z))[U]); LMGP01010628 (PC(16:0/20:3(8Z,11Z,14Z))[U]); LMGP01010620 (PC(16:0/20:3(11E,14E,17E))[U]); LMGP01010621 (PC(16:0/20:3(5E,8E,11E))[U]); LMGP01010622 (PC(16:0/20:3(5Z,8Z,11Z))); LMGP01010623 (PC(16:0/20:3(5Z,8Z,11Z))[U]); LMGP01010624 (PC(16:0/20:3(8E,11E,14E))); LMGP01010625 (PC(16:0/20:3(8E,11E,14E))[S]); LMGP01010626 (PC(16:0/20:3(8E,11E,14E))[U]); LMGP01010627 (PC(16:0/20:3(8Z,11Z,14Z))); LMGP01010770 (PC(18:0/18:3(6Z,9Z,12Z))[U]); LMGP01010771 (PC(18:0/18:3(9Z,12Z,15Z))[U])": ["C44H82NO8P", "Glycerophospholipids [GP] with formula: C44H82NO8P"],
        "LMGP01040092": ["C44H84NO6P", "Glycerophospholipids [GP] with formula: C44H84NO6P"],
        "LMGP01020053 (PC(O-16:0/20:3(8Z,11Z,14Z)))": ["C44H84NO7P", "Glycerophospholipids [GP] with formula: C44H84NO7P"],
        "LMGP01010892 (PC(18:1(9Z)/18:1(9Z))[U]); LMGP01010891 (PC(18:1(9Z)/18:1(9Z))[S]); LMGP01010890 (PC(18:1(9Z)/18:1(9Z))); LMGP01010966 (PC(18:1(4Z)/18:1(4Z))); LMGP01010856 (PC(18:1(16E)/18:1(16E))[U]); LMGP01010841 (PC(18:1(11Z)/18:1(11Z))); LMGP01010842 (PC(18:1(11Z)/18:1(11Z))[U]); LMGP01010857 (PC(18:1(16Z)/18:1(16Z))); LMGP01010855 (PC(18:1(15Z)/18:1(15Z))); LMGP01010854 (PC(18:1(15E)/18:1(15E))[U]); LMGP01010853 (PC(18:1(14Z)/18:1(14Z))); LMGP01010852 (PC(18:1(14E)/18:1(14E))[U]); LMGP01010851 (PC(18:1(13Z)/18:1(13Z))); LMGP01010850 (PC(18:1(13E)/18:1(13E))[U]); LMGP01010859 (PC(18:1(2E)/18:1(2E))[U]); LMGP01010858 (PC(18:1(17Z)/18:1(17Z))); LMGP01010862 (PC(18:1(3Z)/18:1(3Z))); LMGP01010863 (PC(18:1(4E)/18:1(4E))[U]); LMGP01010860 (PC(18:1(2Z)/18:1(2Z))); LMGP01010861 (PC(18:1(3E)/18:1(3E))[U]); LMGP01010866 (PC(18:1(6E)/18:1(6E))); LMGP01010864 (PC(18:1(5E)/18:1(5E))[U]); LMGP01010865 (PC(18:1(5Z)/18:1(5Z))); LMGP01010868 (PC(18:1(6Z)/18:1(6Z))); LMGP01010869 (PC(18:1(6Z)/18:1(6Z))[U]); LMGP01010867 (PC(18:1(6E)/18:1(6E))[U]); LMGP01010877 (PC(18:1(9E)/18:1(9E))[U]); LMGP01010876 (PC(18:1(9E)/18:1(9E))); LMGP01010871 (PC(18:1(7Z)/18:1(7Z))); LMGP01010870 (PC(18:1(7E)/18:1(7E))[U]); LMGP01010873 (PC(18:1(8Z)/18:1(8Z))); LMGP01010872 (PC(18:1(8E)/18:1(8E))[U]); LMGP01010835 (PC(18:1(10E)/18:1(10E))[U]); LMGP01010837 (PC(18:1(11E)/18:1(11E))); LMGP01010836 (PC(18:1(10Z)/18:1(10Z))); LMGP01010935 (PC(18:2(9Z,12Z)/18:0)); LMGP01010848 (PC(18:1(12E)/18:1(12E))[U]); LMGP01010849 (PC(18:1(12Z)/18:1(12Z))); LMGP01010838 (PC(18:1(11E)/18:1(11E))[U]); LMGP01010936 (PC(18:2(9Z,12Z)/18:0)[U]); LMGP01010619 (PC(16:0/20:2(11E,14E))[U]); LMGP01010769 (PC(18:0/18:2(9Z,12Z))[U]); LMGP01010768 (PC(18:0/18:2(9Z,12Z))); LMGP01010765 (PC(18:0/18:2(2E,4E))); LMGP01010764 (PC(18:0/18:2(10Z,12Z))); LMGP01010767 (PC(18:0/18:2(6Z,9Z))[U]); LMGP01010766 (PC(18:0/18:2(6Z,9Z)))": ["C44H84NO8P", "Glycerophospholipids [GP] with formula: C44H84NO8P"],
        "LMGP01080012 (PC(18:2(2E,4E)/O-18:0)[U]); LMGP01030013 (PC(P-18:0/18:1(9Z)))": ["C44H86NO7P", "Glycerophospholipids [GP] with formula: C44H86NO7P"],
        "LMGP01010840 (PC(18:1(11Z)/18:0)); LMGP01010757 (PC(18:0/18:1(6Z))[U]); LMGP01010751 (PC(18:0/18:1(12Z))); LMGP01010875 (PC(18:1(9E)/18:0)[U]); LMGP01010750 (PC(18:0/18:1(11Z))); LMGP01010752 (PC(18:0/18:1(12Z))[U]); LMGP01010753 (PC(18:0/18:1(13Z))); LMGP01010754 (PC(18:0/18:1(16Z))); LMGP01010755 (PC(18:0/18:1(16Z))[U]); LMGP01010756 (PC(18:0/18:1(6Z))); LMGP01010758 (PC(18:0/18:1(7Z))); LMGP01010759 (PC(18:0/18:1(9E))); LMGP01010749 (PC(18:0/18:1(11E))[U]); LMGP01010618 (PC(16:0/20:1(11Z))[U]); LMGP01011037 (PC(20:1(11Z)/16:0)[U]); LMGP01010761 (PC(18:0/18:1(9Z))); LMGP01010760 (PC(18:0/18:1(9E))[U]); LMGP01010763 (PC(18:0/18:1(9Z))[U]); LMGP01010762 (PC(18:0/18:1(9Z))[S]); LMGP01010888 (PC(18:1(9Z)/18:0)); LMGP01010889 (PC(18:1(9Z)/18:0)[U])": ["C44H86NO8P", "Glycerophospholipids [GP] with formula: C44H86NO8P"],
        "LMGP01040063 (PC(O-18:1(9Z)/O-18:1(9Z))); LMGP01040060 (PC(O-18:1(9E)/O-18:1(9E))[U]); LMGP01040065 (PC(O-18:1(9Z)/O-18:1(9Z))[U]); LMGP01040064 (PC(O-18:1(9Z)/O-18:1(9Z))[S])": ["C44H88NO6P", "Glycerophospholipids [GP] with formula: C44H88NO6P"],
        "LMGP01020052 (PC(O-16:0/20:1(9Z)))": ["C44H88NO7P", "Glycerophospholipids [GP] with formula: C44H88NO7P"],
        "LMGP01011168 (PC(25:0/11:0)[U]); LMGP01010549 (PC(15:0/21:0)); LMGP01010422 (PC(11:0/25:0)); LMGP01011144 (PC(24:0/12:0)[U]); LMGP01010449 (PC(12:0/24:0)); LMGP01011085 (PC(22:0/14:0)); LMGP01010450 (PC(12:0/24:0)[U]); LMGP02010070 (PE(18:0/21:0)[U]); LMGP02010071 (PE(19:0/20:0)[U]); LMGP02010256 (PE(16:0/23:0)[U]); LMGP02010255 (PE(17:0/22:0)[U]); LMGP01010468 (PC(13:0/23:0)); LMGP01010006 (PC(18:0/18:0)); LMGP01010713 (PC(17:0/19:0)[U]); LMGP02010214 (PE(22:0/17:0)[U]); LMGP01011066 (PC(21:0/15:0)[U]); LMGP02010209 (PE(21:0/18:0)[U]); LMGP01011125 (PC(23:0/13:0)[U]); LMGP01010747 (PC(18:0/18:0)[S]); LMGP01010748 (PC(18:0/18:0)[U]); LMGP01010511 (PC(14:0/22:0)); LMGP01011002 (PC(20:0/16:0)); LMGP01010617 (PC(16:0/20:0)[U]); LMGP01010616 (PC(16:0/20:0)); LMGP01010402 (PC(10:0/26:0)[U]); LMGP01010974 (PC(19:0/17:0)[U])": ["C44H88NO8P", "Glycerophospholipids [GP] with formula: C44H88NO8P"],
        "LMGP01020023 (PC(O-14:0/22:0)); LMGP01020091 (PC(O-18:0/18:0)); LMGP01020092 (PC(O-18:0/18:0)[S]); LMGP01020093 (PC(O-18:0/18:0)[U]); LMGP01020051 (PC(O-16:0/20:0)); LMGP01020122 (PC(O-20:0/16:0))": ["C44H90NO7P", "Glycerophospholipids [GP] with formula: C44H90NO7P"],
        "LMGP01040052 (PC(O-18:0/O-18:0)[U]); LMGP01040051 (PC(O-18:0/O-18:0)[S])": ["C44H92NO6P", "Glycerophospholipids [GP] with formula: C44H92NO6P"],
        "LMGP02080002": ["C45H74NO7P", "Glycerophospholipids [GP] with formula: C45H74NO7P"],
        "LMGP02010040 (PE(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[U])": ["C45H74NO8P", "Glycerophospholipids [GP] with formula: C45H74NO8P"],
        "LMGP02040014": ["C45H76NO6P", "Glycerophospholipids [GP] with formula: C45H76NO6P"],
        "LMGP02080003": ["C45H76NO7P", "Glycerophospholipids [GP] with formula: C45H76NO7P"],
        "LMGP02040017": ["C45H78NO6P", "Glycerophospholipids [GP] with formula: C45H78NO6P"],
        "LMGP02030005 (PE(P-18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C45H78NO7P", "Glycerophospholipids [GP] with formula: C45H78NO7P"],
        "LMGP20020015 (PE(P-18:0/22:6(4Z,7Z,10Z,12E,16Z,19Z)(14OH))); LMGP02010094 (PE(18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C45H78NO8P", "Glycerophospholipids [GP] with formula: C45H78NO8P"],
        "LMGP20020004 (PE(18:0/22:6(4Z,7Z,10Z,12E,16Z,19Z)(14OH)))": ["C45H78NO9P", "Glycerophospholipids [GP] with formula: C45H78NO9P"],
        "LMGP01010003 (PC(17:0/20:4(5Z,8Z,11Z,14Z)))": ["C45H82NO8P", "Glycerophospholipids [GP] with formula: C45H82NO8P"],
        "LMGP06010009 (PI(18:1(9Z)/18:1(9Z)))": ["C45H83O13P", "Glycerophospholipids [GP] with formula: C45H83O13P"],
        "LMGP01020082 (PC(O-17:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01020081 (PC(O-17:0/20:4(5Z,8Z,11Z,14Z)))": ["C45H84NO7P", "Glycerophospholipids [GP] with formula: C45H84NO7P"],
        "LMGP01010778 (PC(18:0/19:3(9Z,12Z,15Z))[U])": ["C45H84NO8P", "Glycerophospholipids [GP] with formula: C45H84NO8P"],
        "LMGP06010002 (PI(18:1(9Z)/18:1(9Z)))": ["C45H86NO13P", "Glycerophospholipids [GP] with formula: C45H86NO13P"],
        "LMGP01040093": ["C45H86NO6P", "Glycerophospholipids [GP] with formula: C45H86NO6P"],
        "LMGP02010145 (PE(18:1(9Z)/22:1(13Z))[U]); LMGP02010140 (PE(20:0/20:2(11Z,14Z)))": ["C45H86NO8P", "Glycerophospholipids [GP] with formula: C45H86NO8P"],
        "LMGP06010008 (PI(18:0/18:0))": ["C45H87O13P", "Glycerophospholipids [GP] with formula: C45H87O13P"],
        "LMGP02010151 (PE(18:0/22:1(13Z))); LMGP02010153 (PE(22:0/18:1(13Z))); LMGP02010152 (PE(20:0/20:1(11Z))); LMGP02010155 (PE(22:0/18:1(9Z))); LMGP02010154 (PE(22:0/18:1(11Z))); LMGP02010157 (PE(20:1(13E)/20:0)); LMGP02010156 (PE(22:0/18:1(7Z))); LMGP02010159 (PE(20:1(13Z)/20:0)); LMGP02010158 (PE(18:1(11E)/22:0)); LMGP02010033 (PE(22:1(13Z)/18:0)[U]); LMGP02010162 (PE(18:1(9Z)/22:0)[U]); LMGP02010160 (PE(18:1(11Z)/22:0)); LMGP02010161 (PE(18:1(9Z)/22:0))": ["C45H88NO8P", "Glycerophospholipids [GP] with formula: C45H88NO8P"],
        "LMGP01011169 (PC(25:0/12:0)[U]); LMGP01010550 (PC(15:0/22:0)[U]); LMGP01010423 (PC(11:0/26:0)[U]); LMGP01011145 (PC(24:0/13:0)[U]); LMGP02010269 (PE(16:0/24:0)[U]); LMGP01010451 (PC(12:0/25:0)[U]); LMGP01011184 (PC(26:0/11:0)[U]); LMGP02010072 (PE(19:0/21:0)[U]); LMGP01010469 (PC(13:0/24:0)[U]); LMGP02010249 (PE(17:0/23:0)[U]); LMGP01010716 (PC(17:0/20:0)[U]); LMGP02010031 (PE(20:0/20:0)[U]); LMGP02010215 (PE(22:0/18:0)[U]); LMGP02010213 (PE(23:0/17:0)[U]); LMGP02010210 (PE(21:0/19:0)[U]); LMGP01011067 (PC(21:0/16:0)[U]); LMGP01011126 (PC(23:0/14:0)[U]); LMGP01010635 (PC(16:0/21:0)[U]); LMGP02010300 (PE(15:0/25:0)[U]); LMGP01011003 (PC(20:0/17:0)[U]); LMGP01010777 (PC(18:0/19:0)[U]); LMGP02010146 (PE(18:0/22:0)); LMGP02010147 (PE(18:0/22:0)[U]); LMGP01010975 (PC(19:0/18:0)); LMGP01010514 (PC(14:0/23:0)[U])": ["C45H90NO8P", "Glycerophospholipids [GP] with formula: C45H90NO8P"],
        "LMGP01020080 (PC(O-17:0/20:0)); LMGP02020017 (PE(O-18:0/22:0)); LMGP02020016 (PE(O-18:0/22:0)[U]); LMGP01020059 (PC(O-16:0/21:0)[U])": ["C45H92NO7P", "Glycerophospholipids [GP] with formula: C45H92NO7P"],
        "LMGP02040018 (beta-hydroarchaetidylethanolamine)": ["C45H94NO7P", "Glycerophospholipids [GP] with formula: C45H94NO7P"],
        "LMGP04040006": ["C46H75O9P", "Glycerophospholipids [GP] with formula: C46H75O9P"],
        "LMGP01080001": ["C46H76NO7P", "Glycerophospholipids [GP] with formula: C46H76NO7P"],
        "LMGP04040004": ["C46H77O8P", "Glycerophospholipids [GP] with formula: C46H77O8P"],
        "LMGP04110004": ["C46H77O9P", "Glycerophospholipids [GP] with formula: C46H77O9P"],
        "LMGP03010040 (PS(18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C46H78NO10P", "Glycerophospholipids [GP] with formula: C46H78NO10P"],
        "LMGP01040088": ["C46H78NO6P", "Glycerophospholipids [GP] with formula: C46H78NO6P"],
        "LMGP01080003": ["C46H78NO7P", "Glycerophospholipids [GP] with formula: C46H78NO7P"],
        "LMGP01010697 (PC(16:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01010696 (PC(16:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))); LMGP01011306 (PC(16:1(7Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))); LMGP01010945 (PC(18:2(9Z,12Z)/20:5(5Z,8Z,11Z,14Z,17Z))[U])": ["C46H78NO8P", "Glycerophospholipids [GP] with formula: C46H78NO8P"],
        "LMGP04010040 (PG(18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C46H79O10P", "Glycerophospholipids [GP] with formula: C46H79O10P"],
        "LMGP04040005": ["C46H79O8P", "Glycerophospholipids [GP] with formula: C46H79O8P"],
        "LMGP01040090": ["C46H80NO6P", "Glycerophospholipids [GP] with formula: C46H80NO6P"],
        "LMGP01011115 (PC(22:6(4E,7E,10E,13E,16E,19E)/16:0)); LMGP01011117 (PC(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/16:0)[U]); LMGP01011116 (PC(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/16:0)); LMGP01010944 (PC(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01010943 (PC(18:2(9Z,12Z)/20:4(5Z,8Z,11Z,14Z))); LMGP01010844 (PC(18:1(11Z)/20:5(5Z,8Z,11Z,14Z,17Z))); LMGP01010908 (PC(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z))[U]); LMGP01011057 (PC(20:5(5Z,8Z,11Z,14Z,17Z)/18:1(9Z))); LMGP01011051 (PC(20:4(5Z,8Z,11Z,14Z)/18:2(9Z,12Z))[U]); LMGP01010649 (PC(16:0/22:6(3Z,6Z,9Z,12Z,15Z,18))[U]); LMGP01010654 (PC(16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01010651 (PC(16:0/22:6(4E,7E,10E,13E,16E,19E))[U]); LMGP01010650 (PC(16:0/22:6(4E,7E,10E,13E,16E,19E))); LMGP01010653 (PC(16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[S]); LMGP01010652 (PC(16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))); LMGP01010907 (PC(18:1(9Z)/20:5(5Z,8Z,11Z,14Z,17Z)))": ["C46H80NO8P", "Glycerophospholipids [GP] with formula: C46H80NO8P"],
        "LMGP01020065 (PC(O-16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01020064 (PC(O-16:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C46H82NO7P", "Glycerophospholipids [GP] with formula: C46H82NO7P"],
        "LMGP01010905 (PC(18:1(9Z)/20:4(5Z,8Z,11Z,14Z))); LMGP01010906 (PC(18:1(9Z)/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01010646 (PC(16:0/22:5(4Z,7Z,10Z,13Z,16Z))[U]); LMGP01010647 (PC(16:0/22:5(7Z,10Z,13Z,16Z,19Z))); LMGP01010644 (PC(16:0/22:5(4E,7E,10E,13E,16E))[U]); LMGP01010645 (PC(16:0/22:5(4Z,7Z,10Z,13Z,16Z))); LMGP01010648 (PC(16:0/22:5(7Z,10Z,13Z,16Z,19Z))[U]); LMGP01010805 (PC(18:0/20:5(5Z,8Z,11Z,14Z,17Z))); LMGP01010806 (PC(18:0/20:5(5Z,8Z,11Z,14Z,17Z))[U]); LMGP01010807 (PC(18:0/20:5(9Z,11Z,13Z,15Z,17Z))); LMGP10010004 (PA(21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C46H82NO8P", "Glycerophospholipids [GP] with formula: C46H82NO8P"],
        "LMGP20010004 (PE(18:0/20:4(5Z,8Z,11Z,13E)(15Ke)))": ["C46H82NO9P", "Glycerophospholipids [GP] with formula: C46H82NO9P"],
        "LMGP13010002 (CDP-DG(16:0/18:1(11Z)))": ["C46H83N3O15P2", "Glycerophospholipids [GP] with formula: C46H83N3O15P2"],
        "LMGP06010004 (PI(17:0/20:4(5Z,8Z,11Z,14Z)))": ["C46H84NO13P", "Glycerophospholipids [GP] with formula: C46H84NO13P"],
        "LMGP01020104 (PC(O-18:0/20:5(5Z,8Z,11Z,14Z,17Z))); LMGP01020157 (PC(O-18:1(9Z)/20:4(5Z,8Z,11Z,14Z))); LMGP01020066 (PC(O-16:0/22:5(7Z,10Z,13Z,16Z,19Z))); LMGP01020063 (PC(O-16:0/22:5(7Z,10Z,13Z,16Z,19Z))[U]); LMGP01030012 (PC(P-18:0/20:4(5Z,8Z,11Z,14Z)))": ["C46H84NO7P", "Glycerophospholipids [GP] with formula: C46H84NO7P"],
        "LMGP01010904 (PC(18:1(9Z)/20:3(5Z,8Z,11Z))); LMGP01010642 (PC(16:0/22:4(7Z,10Z,13Z,16Z))); LMGP01010643 (PC(16:0/22:4(7Z,10Z,13Z,16Z))[U]); LMGP01010801 (PC(18:0/20:4(5E,8E,11E,14E))[U]); LMGP01010802 (PC(18:0/20:4(5Z,8Z,11Z,14Z))); LMGP01010803 (PC(18:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01010804 (PC(18:0/20:4(8Z,10Z,12Z,14Z)))": ["C46H84NO8P", "Glycerophospholipids [GP] with formula: C46H84NO8P"],
        "LMGP20010001 (PC(18:0/20:4(5Z,8Z,10E,14Z)(12OH[S])))": ["C46H84NO9P", "Glycerophospholipids [GP] with formula: C46H84NO9P"],
        "LMGP09010001 (PIP3[3',4',5'](17:0/20:4(5Z,8Z,11Z,14Z)))": ["C46H84O22P4", "Glycerophospholipids [GP] with formula: C46H84O22P4"],
        "LMGP01020102 (PC(O-18:0/20:4(5Z,8Z,11Z,14Z))); LMGP01020103 (PC(O-18:0/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01020100 (PC(O-18:0/20:4(5E,8E,11E,14E))); LMGP01020101 (PC(O-18:0/20:4(5E,8E,11E,14E))[U]); LMGP01020062 (PC(O-16:0/22:4(7Z,10Z,13Z,16Z))[U])": ["C46H86NO7P", "Glycerophospholipids [GP] with formula: C46H86NO7P"],
        "LMGP01010794 (PC(18:0/20:3(5E,8E,11E))[U]); LMGP01010795 (PC(18:0/20:3(5Z,11Z,14Z))); LMGP01010796 (PC(18:0/20:3(5Z,8Z,11Z))); LMGP01010797 (PC(18:0/20:3(5Z,8Z,11Z))[U]); LMGP01010798 (PC(18:0/20:3(5Z,8Z,14Z))); LMGP01010799 (PC(18:0/20:3(8Z,11Z,14Z))); LMGP01010942 (PC(18:2(9Z,12Z)/20:1(13Z))); LMGP01010641 (PC(16:0/22:3(13Z,16Z,19Z))[U]); LMGP01010800 (PC(18:0/20:3(8Z,11Z,14Z))[U])": ["C46H86NO8P", "Glycerophospholipids [GP] with formula: C46H86NO8P"],
        "LMGP07010004 (PIP[5'](17:0/20:4(5Z,8Z,11Z,14Z))); LMGP07010002 (PIP[3'](17:0/20:4(5Z,8Z,11Z,14Z))); LMGP07010003 (PIP[4'](17:0/20:4(5Z,8Z,11Z,14Z)))": ["C46H88N2O16P2", "Glycerophospholipids [GP] with formula: C46H88N2O16P2"],
        "LMGP01010790 (PC(18:0/20:2(5Z,14Z))); LMGP01010791 (PC(18:0/20:2(5Z,8Z))); LMGP01010792 (PC(18:0/20:2(8Z,11Z))); LMGP01010793 (PC(18:0/20:2(8Z,14Z))); LMGP01010789 (PC(18:0/20:2(5Z,11Z))); LMGP01010788 (PC(18:0/20:2(11Z,14Z))); LMGP01010941 (PC(18:2(9Z,12Z)/20:0)[U]); LMGP01010843 (PC(18:1(11Z)/20:1(13Z))); LMGP01011296 (PC(20:0/18:2(9Z,12Z))); LMGP01010640 (PC(16:0/22:2(13Z,16Z))[U]); LMGP01011012 (PC(20:0/18:2(9Z,12Z))[U]); LMGP01010987 (PC(19:1(10Z)/19:1(10Z))[U])": ["C46H88NO8P", "Glycerophospholipids [GP] with formula: C46H88NO8P"],
        "LMGP01010787 (PC(18:0/20:1(8Z))); LMGP01010785 (PC(18:0/20:1(14Z))); LMGP01010784 (PC(18:0/20:1(13Z))); LMGP01010783 (PC(18:0/20:1(11Z))); LMGP01010903 (PC(18:1(9Z)/20:0)[U]); LMGP01010902 (PC(18:1(9Z)/20:0)); LMGP01010879 (PC(18:1(9E)/20:0)); LMGP01010786 (PC(18:0/20:1(5Z))); LMGP01010639 (PC(16:0/22:1(13Z))[U]); LMGP01010638 (PC(16:0/22:1(13Z))); LMGP01011010 (PC(20:0/18:1(9Z))); LMGP01011011 (PC(20:0/18:1(9Z))[U]); LMGP01011009 (PC(20:0/18:1(7Z))); LMGP01011008 (PC(20:0/18:1(6Z))); LMGP01011007 (PC(20:0/18:1(13E))[U]); LMGP01011006 (PC(20:0/18:1(12E))[U]); LMGP01011005 (PC(20:0/18:1(11Z))); LMGP01010880 (PC(18:1(9E)/20:0)[U]); LMGP01010516 (PC(14:0/24:1(15Z)))": ["C46H90NO8P", "Glycerophospholipids [GP] with formula: C46H90NO8P"],
        "LMGP08010001 (PIP2[3',4'](17:0/20:4(5Z,8Z,11Z,14Z))); LMGP08010003 (PIP2[4',5'](17:0/20:4(5Z,8Z,11Z,14Z))); LMGP08010002 (PIP2[3',5'](17:0/20:4(5Z,8Z,11Z,14Z)))": ["C46H92N3O19P3", "Glycerophospholipids [GP] with formula: C46H92N3O19P3"],
        "LMGP01020099 (PC(O-18:0/20:1(9Z)))": ["C46H92NO7P", "Glycerophospholipids [GP] with formula: C46H92NO7P"],
        "LMGP02010211 (PE(21:0/20:0)[U]); LMGP02010184 (PE(18:0/23:0)[U]); LMGP01010782 (PC(18:0/20:0)[U]); LMGP01010781 (PC(18:0/20:0)); LMGP01010551 (PC(15:0/23:0)[U]); LMGP01011170 (PC(25:0/13:0)[U]); LMGP01011146 (PC(24:0/14:0)[U]); LMGP01011086 (PC(22:0/16:0)[U]); LMGP02010267 (PE(16:0/25:0)[U]); LMGP01010452 (PC(12:0/26:0)); LMGP01011185 (PC(26:0/12:0)[U]); LMGP02010073 (PE(19:0/22:0)[U]); LMGP02010074 (PE(20:0/21:0)[U]); LMGP02010257 (PE(17:0/24:0)[U]); LMGP01010717 (PC(17:0/21:0)[U]); LMGP01010470 (PC(13:0/25:0)); LMGP02010345 (PE-NMe(20:0/20:0)); LMGP02010346 (PE-NMe(20:0/20:0)[U]); LMGP02010216 (PE(22:0/19:0)[U]); LMGP01011068 (PC(21:0/17:0)[U]); LMGP01011127 (PC(23:0/15:0)[U]); LMGP01010637 (PC(16:0/22:0)[U]); LMGP01010636 (PC(16:0/22:0)); LMGP01010515 (PC(14:0/24:0)); LMGP01011004 (PC(20:0/18:0)); LMGP01010976 (PC(19:0/19:0)); LMGP01010977 (PC(19:0/19:0)[U])": ["C46H92NO8P", "Glycerophospholipids [GP] with formula: C46H92NO8P"],
        "LMGP01020098 (PC(O-18:0/20:0)[U]); LMGP01020097 (PC(O-18:0/20:0)); LMGP01020061 (PC(O-16:0/22:0)[U]); LMGP01020060 (PC(O-16:0/22:0))": ["C46H94NO7P", "Glycerophospholipids [GP] with formula: C46H94NO7P"],
        "LMGP04040007 (beta-hydroarchaetidylglycerol)": ["C46H95O9P", "Glycerophospholipids [GP] with formula: C46H95O9P"],
        "LMGP02010164 (PE(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/20:4(5Z,8Z,11Z,14Z))[U]); LMGP02010165 (PE(20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP02010166 (PE(20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z)))": ["C47H74NO8P", "Glycerophospholipids [GP] with formula: C47H74NO8P"],
        "LMGP01010720 (PC(17:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C47H82NO8P", "Glycerophospholipids [GP] with formula: C47H82NO8P"],
        "LMGP06010010 (PI(18:0/20:4(5Z,8Z,11Z,14Z))); LMGP14010001 (Glc-GP(18:0/20:4(5Z,8Z,11Z,14Z)))": ["C47H83O13P", "Glycerophospholipids [GP] with formula: C47H83O13P"],
        "LMGP01010719 (PC(17:0/22:5(7Z,10Z,13Z,16Z,19Z))); LMGP01010656 (PC(16:0/23:5(8E,11E,14E,17E,20E)))": ["C47H84NO8P", "Glycerophospholipids [GP] with formula: C47H84NO8P"],
        "LMGP02010294 (PE(24:0/18:1(9Z))); LMGP02010293 (PE(18:0/24:1(15Z))); LMGP02010290 (PE(22:0/20:1(11Z))); LMGP02010287 (PE(20:0/22:1(13Z)))": ["C47H92NO8P", "Glycerophospholipids [GP] with formula: C47H92NO8P"],
        "LMGP02010150 (PE(21:0/21:0)[U]); LMGP01010552 (PC(15:0/24:0)[U]); LMGP01011171 (PC(25:0/14:0)[U]); LMGP02010191 (PE(23:0/19:0)[U]); LMGP02010217 (PE(22:0/20:0)[U]); LMGP01011147 (PC(24:0/15:0)[U]); LMGP02010179 (PE(19:0/23:0)[U]); LMGP01011087 (PC(22:0/17:0)[U]); LMGP01011186 (PC(26:0/13:0)[U]); LMGP02010075 (PE(20:0/22:0)); LMGP02010258 (PE(17:0/25:0)[U]); LMGP01010718 (PC(17:0/22:0)[U]); LMGP01010471 (PC(13:0/26:0)[U]); LMGP01010808 (PC(18:0/21:0)[U]); LMGP01010655 (PC(16:0/23:0)[U]); LMGP01011069 (PC(21:0/18:0)); LMGP02010205 (PE(24:0/18:0)[U]); LMGP01011013 (PC(20:0/19:0)[U]); LMGP01011128 (PC(23:0/16:0)[U]); LMGP02010163 (PE(16:0/26:0)[U]); LMGP01010517 (PC(14:0/25:0)[U]); LMGP02010319 (PE-NMe2(20:0/20:0)); LMGP02010149 (PE(20:0/22:0)[U]); LMGP02010320 (PE-NMe2(20:0/20:0)[U]); LMGP01010979 (PC(19:0/20:0)[U])": ["C47H94NO8P", "Glycerophospholipids [GP] with formula: C47H94NO8P"],
        "LMGP01020083 (PC(O-17:0/22:0))": ["C47H96NO7P", "Glycerophospholipids [GP] with formula: C47H96NO7P"],
        "LMGP01040099; LMGP01040072 (PC(O-20:0/O-20:0))": ["C48H100NO6P", "Glycerophospholipids [GP] with formula: C48H100NO6P"],
        "LMGP01080002": ["C48H80NO7P", "Glycerophospholipids [GP] with formula: C48H80NO7P"],
        "LMGP01011118 (PC(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/18:2(9Z,12Z))[U]); LMGP01010948 (PC(18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01010947 (PC(18:2(9Z,12Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))); LMGP01011048 (PC(20:4(5E,8E,11E,14E)/20:4(5E,8E,11E,14E))[U]); LMGP01011052 (PC(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))); LMGP01011053 (PC(20:4(5Z,8Z,11Z,14Z)/20:4(5Z,8Z,11Z,14Z))[U]); LMGP01011047 (PC(20:4(5E,8E,11E,14E)/20:4(5E,8E,11E,14E)))": ["C48H80NO8P", "Glycerophospholipids [GP] with formula: C48H80NO8P"],
        "LMGP01040089": ["C48H82NO6P", "Glycerophospholipids [GP] with formula: C48H82NO6P"],
        "LMGP01080004": ["C48H82NO7P", "Glycerophospholipids [GP] with formula: C48H82NO7P"],
        "LMGP01010946 (PC(18:2(9Z,12Z)/22:5(4Z,7Z,10Z,13Z,16Z))); LMGP01010914 (PC(18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01010913 (PC(18:1(9Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))); LMGP01010847 (PC(18:1(11Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C48H82NO8P", "Glycerophospholipids [GP] with formula: C48H82NO8P"],
        "LMGP01040091; LMGP01040095": ["C48H84NO6P", "Glycerophospholipids [GP] with formula: C48H84NO6P"],
        "LMGP01030014 (PC(P-18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C48H84NO7P", "Glycerophospholipids [GP] with formula: C48H84NO7P"],
        "LMGP01010823 (PC(18:0/22:6(9Z,11Z,13Z,15Z,17Z,19))); LMGP01010820 (PC(18:0/22:6(4E,7E,10E,13E,16E,19E))[U]); LMGP01010912 (PC(18:1(9Z)/22:5(7Z,10Z,13Z,16Z,19Z))[U]); LMGP02010004 (PE(21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))); LMGP01010846 (PC(18:1(11Z)/22:5(7Z,10Z,13Z,16Z,19Z))); LMGP01010822 (PC(18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01010821 (PC(18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C48H84NO8P", "Glycerophospholipids [GP] with formula: C48H84NO8P"],
        "LMGP13010004 (CDP-DG(18:1(9Z)/18:1(9Z)))": ["C48H85N3O15P2", "Glycerophospholipids [GP] with formula: C48H85N3O15P2"],
        "LMGP01020111 (PC(O-18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01020110 (PC(O-18:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C48H86NO7P", "Glycerophospholipids [GP] with formula: C48H86NO7P"],
        "LMGP01010911 (PC(18:1(9Z)/22:4(7Z,10Z,13Z,16Z))[U]); LMGP01010819 (PC(18:0/22:5(7Z,10Z,13Z,16Z,19Z))[U]); LMGP01010818 (PC(18:0/22:5(7Z,10Z,13Z,16Z,19Z))); LMGP01010817 (PC(18:0/22:5(4Z,7Z,10Z,13Z,16Z))[U]); LMGP01010816 (PC(18:0/22:5(4Z,7Z,10Z,13Z,16Z))); LMGP01010815 (PC(18:0/22:5(4E,7E,10E,13E,16E))[U])": ["C48H86NO8P", "Glycerophospholipids [GP] with formula: C48H86NO8P"],
        "LMGP01040097": ["C48H88NO6P", "Glycerophospholipids [GP] with formula: C48H88NO6P"],
        "LMGP01020108 (PC(O-18:0/22:5(7E,10E,13E,16E,19E))[U]); LMGP01020109 (PC(O-18:0/22:5(7Z,10Z,13Z,16Z,19Z))); LMGP01020107 (PC(O-18:0/22:5(4Z,7Z,10Z,13Z,16Z)))": ["C48H88NO7P", "Glycerophospholipids [GP] with formula: C48H88NO7P"],
        "LMGP01011114 (PC(22:4(7Z,10Z,13Z,16Z)/18:0)[U]); LMGP01011046 (PC(20:2(2E,4E)/20:2(2E,4E))[S]); LMGP01011045 (PC(20:2(11E,14E)/20:2(11E,14E))); LMGP01010813 (PC(18:0/22:4(7Z,10Z,13Z,16Z))); LMGP01010814 (PC(18:0/22:4(7Z,10Z,13Z,16Z))[U]); LMGP01011023 (PC(20:0/20:4(5Z,8Z,11Z,14Z)))": ["C48H88NO8P", "Glycerophospholipids [GP] with formula: C48H88NO8P"],
        "LMGP01010812 (PC(18:0/22:3(10Z,13Z,16Z))); LMGP01011022 (PC(20:0/20:3(11Z,14Z,17Z)))": ["C48H90NO8P", "Glycerophospholipids [GP] with formula: C48H90NO8P"],
        "LMGP01040096": ["C48H92NO6P", "Glycerophospholipids [GP] with formula: C48H92NO6P"],
        "LMGP01011044 (PC(20:1(9Z)/20:1(9Z))[U]); LMGP01011043 (PC(20:1(9Z)/20:1(9Z))); LMGP01011042 (PC(20:1(9E)/20:1(9E))); LMGP01011036 (PC(20:1(11E)/20:1(11E))); LMGP01011038 (PC(20:1(11Z)/20:1(11Z))); LMGP01011039 (PC(20:1(11Z)/20:1(11Z))[U]); LMGP01011021 (PC(20:0/20:2(11Z,14Z)))": ["C48H92NO8P", "Glycerophospholipids [GP] with formula: C48H92NO8P"],
        "LMGP04090001": ["C48H93O11P", "Glycerophospholipids [GP] with formula: C48H93O11P"],
        "LMGP01011090 (PC(22:0/18:1(12Z))); LMGP01011091 (PC(22:0/18:1(13Z))); LMGP01011092 (PC(22:0/18:1(6Z))); LMGP01011093 (PC(22:0/18:1(7Z))); LMGP01011094 (PC(22:0/18:1(9Z))); LMGP01010845 (PC(18:1(11Z)/22:0)); LMGP01011089 (PC(22:0/18:1(11Z))); LMGP01010660 (PC(16:0/24:1(15Z))[S]); LMGP01010661 (PC(16:0/24:1(15Z))[U]); LMGP01010910 (PC(18:1(9Z)/22:0)[U]); LMGP01010909 (PC(18:1(9Z)/22:0)); LMGP01010659 (PC(16:0/24:1(15Z))); LMGP01010658 (PC(16:0/24:1(15E))[U]); LMGP01010811 (PC(18:0/22:1(13Z))); LMGP01010839 (PC(18:1(11E)/22:0)); LMGP01011018 (PC(20:0/20:1(13Z))); LMGP01011019 (PC(20:0/20:1(5Z))); LMGP01011017 (PC(20:0/20:1(11Z))); LMGP01011020 (PC(20:0/20:1(8Z))); LMGP01010881 (PC(18:1(9E)/22:0)[U])": ["C48H94NO8P", "Glycerophospholipids [GP] with formula: C48H94NO8P"],
        "LMGP01040098": ["C48H96NO6P", "Glycerophospholipids [GP] with formula: C48H96NO6P"],
        "LMGP02010183 (PE(19:0/24:0)[U]); LMGP02010186 (PE(18:0/25:0)[U]); LMGP01010553 (PC(15:0/25:0)[U]); LMGP01011172 (PC(25:0/15:0)[U]); LMGP02010197 (PE(24:0/19:0)[U]); LMGP02010192 (PE(23:0/20:0)[U]); LMGP01011148 (PC(24:0/16:0)); LMGP01011088 (PC(22:0/18:0)); LMGP01011187 (PC(26:0/14:0)[U]); LMGP02010076 (PE(20:0/23:0)[U]); LMGP02010077 (PE(21:0/22:0)[U]); LMGP02010259 (PE(17:0/26:0)[U]); LMGP01010809 (PC(18:0/22:0)); LMGP01010657 (PC(16:0/24:0)); LMGP01010810 (PC(18:0/22:0)[U]); LMGP01011070 (PC(21:0/19:0)[U]); LMGP02010218 (PE(22:0/21:0)[U]); LMGP01010721 (PC(17:0/23:0)); LMGP01011014 (PC(20:0/20:0)); LMGP01011015 (PC(20:0/20:0)[S]); LMGP01011016 (PC(20:0/20:0)[U]); LMGP01011129 (PC(23:0/17:0)[U]); LMGP01010980 (PC(19:0/21:0)[U]); LMGP01010518 (PC(14:0/26:0))": ["C48H96NO8P", "Glycerophospholipids [GP] with formula: C48H96NO8P"],
        "LMGP01020105 (PC(O-18:0/22:0)); LMGP01020106 (PC(O-18:0/22:0)[U])": ["C48H98NO7P", "Glycerophospholipids [GP] with formula: C48H98NO7P"],
        "LMGP01020120 (PC(O-19:0/22:0))": ["C49H100NO7P", "Glycerophospholipids [GP] with formula: C49H100NO7P"],
        "LMGP02010093 (PE(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C49H74NO8P", "Glycerophospholipids [GP] with formula: C49H74NO8P"],
        "LMGP03010004 (PS(21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C49H87N2O10P", "Glycerophospholipids [GP] with formula: C49H87N2O10P"],
        "LMGP04010004 (PG(21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C49H88NO10P", "Glycerophospholipids [GP] with formula: C49H88NO10P"],
        "LMGP02010295 (PE(24:0/20:1(11Z))); LMGP02010291 (PE(22:0/22:1(13Z))); LMGP02010288 (PE(20:0/24:1(15Z)))": ["C49H96NO8P", "Glycerophospholipids [GP] with formula: C49H96NO8P"],
        "LMGP00000053": ["C49H97O8PS", "Glycerophospholipids [GP] with formula: C49H97O8PS"],
        "LMGP02010182 (PE(20:0/24:0)[U]); LMGP02010187 (PE(18:0/26:0)[U]); LMGP01011173 (PC(25:0/16:0)[U]); LMGP01010824 (PC(18:0/23:0)[U]); LMGP02010193 (PE(23:0/21:0)[U]); LMGP01011130 (PC(23:0/18:0)); LMGP01011149 (PC(24:0/17:0)[U]); LMGP01011095 (PC(22:0/19:0)[U]); LMGP01011188 (PC(26:0/15:0)[U]); LMGP02010078 (PE(21:0/23:0)[U]); LMGP01010662 (PC(16:0/25:0)[U]); LMGP01011071 (PC(21:0/20:0)[U]); LMGP02010032 (PE(22:0/22:0)[U]); LMGP01010722 (PC(17:0/24:0)[U]); LMGP02010203 (PE(25:0/19:0)[U]); LMGP02010168 (PE(22:0/22:0)); LMGP02010167 (PE(24:0/20:0)); LMGP02010175 (PE(19:0/25:0)[U]); LMGP01010981 (PC(19:0/22:0)[U]); LMGP01011024 (PC(20:0/21:0)[U])": ["C49H98NO8P", "Glycerophospholipids [GP] with formula: C49H98NO8P"],
        "LMGP02010080 (PE(22:0/23:0)[U]); LMGP02010194 (PE(23:0/22:0)[U]); LMGP02010199 (PE(24:0/21:0)[U]); LMGP01011131 (PC(23:0/19:0)[U]); LMGP01011096 (PC(22:0/20:0)[U]); LMGP02010273 (PE(25:0/20:0)[U]); LMGP01011150 (PC(24:0/18:0)); LMGP01011189 (PC(26:0/16:0)[U]); LMGP02010079 (PE(21:0/24:0)[U]); LMGP01010664 (PC(16:0/26:0)[U]); LMGP01010663 (PC(16:0/26:0)); LMGP01011072 (PC(21:0/21:0)); LMGP01011073 (PC(21:0/21:0)[U]); LMGP01010723 (PC(17:0/25:0)[U]); LMGP01010825 (PC(18:0/24:0)); LMGP01011174 (PC(25:0/17:0)[U]); LMGP02010176 (PE(19:0/26:0)[U]); LMGP01010982 (PC(19:0/23:0)[U]); LMGP01011025 (PC(20:0/22:0))": ["C50H100NO8P", "Glycerophospholipids [GP] with formula: C50H100NO8P"],
        "LMGP01020067 (PC(O-16:0/26:0)[U]); LMGP01020125 (PC(O-20:0/22:0))": ["C50H102NO7P", "Glycerophospholipids [GP] with formula: C50H102NO7P"],
        "LMGP01011059 (PC(20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))); LMGP01011060 (PC(20:5(5Z,8Z,11Z,14Z,17Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U])": ["C50H78NO8P", "Glycerophospholipids [GP] with formula: C50H78NO8P"],
        "LMGP01011054 (PC(20:4(5Z,8Z,11Z,14Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01011058 (PC(20:5(5Z,8Z,11Z,14Z,17Z)/22:5(7Z,10Z,13Z,16Z,19Z)))": ["C50H80NO8P", "Glycerophospholipids [GP] with formula: C50H80NO8P"],
        "LMGP01011029 (PC(20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U]); LMGP01011028 (PC(20:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C50H88NO8P", "Glycerophospholipids [GP] with formula: C50H88NO8P"],
        "LMGP01011027 (PC(20:0/22:5(7Z,10Z,13Z,16Z,19Z)))": ["C50H90NO8P", "Glycerophospholipids [GP] with formula: C50H90NO8P"],
        "LMGP01011203 (PC(26:2(5Z,9Z)/16:0)); LMGP01010665 (PC(16:0/26:2(5Z,9Z))); LMGP01011079 (PC(21:1(12Z)/21:1(12Z))[U])": ["C50H96NO8P", "Glycerophospholipids [GP] with formula: C50H96NO8P"],
        "LMGP01010826 (PC(18:0/24:1(15Z))); LMGP01011097 (PC(22:0/20:1(11Z))); LMGP01011151 (PC(24:0/18:1(6Z))); LMGP01011152 (PC(24:0/18:1(9Z))); LMGP01010915 (PC(18:1(9Z)/24:0)); LMGP01011041 (PC(20:1(13Z)/22:0)); LMGP01011040 (PC(20:1(13E)/22:0)); LMGP01011026 (PC(20:0/22:1(13Z)))": ["C50H98NO8P", "Glycerophospholipids [GP] with formula: C50H98NO8P"],
        "LMGP02010292 (PE(22:0/24:1(15Z)))": ["C51H100NO8P", "Glycerophospholipids [GP] with formula: C51H100NO8P"],
        "LMGP00000054": ["C51H101O8PS", "Glycerophospholipids [GP] with formula: C51H101O8PS"],
        "LMGP02010081 (PE(22:0/24:0)[U]); LMGP01010827 (PC(18:0/25:0)[U]); LMGP02010195 (PE(23:0/23:0)[U]); LMGP02010196 (PE(20:0/26:0)[U]); LMGP01011098 (PC(22:0/21:0)[U]); LMGP02010277 (PE(26:0/20:0)[U]); LMGP01011153 (PC(24:0/19:0)[U]); LMGP01011190 (PC(26:0/17:0)[U]); LMGP02010220 (PE(21:0/25:0)[U]); LMGP01011074 (PC(21:0/22:0)[U]); LMGP01010724 (PC(17:0/26:0)[U]); LMGP02010200 (PE(24:0/22:0)[U]); LMGP01011175 (PC(25:0/18:0)); LMGP01011132 (PC(23:0/20:0)[U]); LMGP01010983 (PC(19:0/24:0)[U]); LMGP01011030 (PC(20:0/23:0)[U])": ["C51H102NO8P", "Glycerophospholipids [GP] with formula: C51H102NO8P"],
        "LMGP01010004 (PC(21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C51H90NO8P", "Glycerophospholipids [GP] with formula: C51H90NO8P"],
        "LMGP01011111 (PC(22:1(13Z)/22:1(13Z))[U]); LMGP01011110 (PC(22:1(13Z)/22:1(13Z))); LMGP01011112 (PC(22:1(9Z)/22:1(9Z))[U]); LMGP01011109 (PC(22:1(13E)/22:1(13E))[U]); LMGP01011108 (PC(22:1(13E)/22:1(13E)))": ["C52H100NO8P", "Glycerophospholipids [GP] with formula: C52H100NO8P"],
        "LMGP01011102 (PC(22:0/22:1(13Z))); LMGP01011155 (PC(24:0/20:1(11Z))); LMGP01011032 (PC(20:0/24:1(15Z)))": ["C52H102NO8P", "Glycerophospholipids [GP] with formula: C52H102NO8P"],
        "LMGP02010083 (PE(23:0/24:0)[U]); LMGP02010082 (PE(22:0/25:0)[U]); LMGP01011176 (PC(25:0/19:0)[U]); LMGP01011133 (PC(23:0/21:0)[U]); LMGP01011099 (PC(22:0/22:0)); LMGP01011154 (PC(24:0/20:0)[U]); LMGP02010262 (PE(25:0/22:0)[U]); LMGP02010278 (PE(26:0/21:0)[U]); LMGP01011191 (PC(26:0/18:0)[U]); LMGP01011075 (PC(21:0/23:0)[U]); LMGP02010212 (PE(21:0/26:0)[U]); LMGP01010828 (PC(18:0/26:0)); LMGP02010201 (PE(24:0/23:0)[U]); LMGP01010984 (PC(19:0/25:0)); LMGP01011031 (PC(20:0/24:0)[U]); LMGP01011100 (PC(22:0/22:0)[S]); LMGP01011101 (PC(22:0/22:0)[U])": ["C52H104NO8P", "Glycerophospholipids [GP] with formula: C52H104NO8P"],
        "LMGP01011119 (PC(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))); LMGP01011120 (PC(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[S]); LMGP01011121 (PC(22:6(4Z,7Z,10Z,13Z,16Z,19Z)/22:6(4Z,7Z,10Z,13Z,16Z,19Z))[U])": ["C52H80NO8P", "Glycerophospholipids [GP] with formula: C52H80NO8P"],
        "LMGP06010005 (PI(21:0/22:6(4Z,7Z,10Z,13Z,16Z,19Z)))": ["C52H92NO13P", "Glycerophospholipids [GP] with formula: C52H92NO13P"],
        "LMGP01011113 (PC(22:2(5Z,9Z)/22:2(5Z,9Z))[U])": ["C52H96NO8P", "Glycerophospholipids [GP] with formula: C52H96NO8P"],
        "LMGP02010084 (PE(23:0/25:0)[U]); LMGP01011177 (PC(25:0/20:0)[U]); LMGP02010198 (PE(22:0/26:0)[U]); LMGP02010279 (PE(26:0/22:0)[U]); LMGP02010275 (PE(25:0/23:0)[U]); LMGP01011156 (PC(24:0/21:0)[U]); LMGP01011192 (PC(26:0/19:0)[U]); LMGP01011076 (PC(21:0/24:0)[U]); LMGP02010202 (PE(24:0/24:0)[U]); LMGP01011134 (PC(23:0/22:0)[U]); LMGP01010985 (PC(19:0/26:0)[U]); LMGP01011033 (PC(20:0/25:0)[U]); LMGP01011103 (PC(22:0/23:0)[U])": ["C53H106NO8P", "Glycerophospholipids [GP] with formula: C53H106NO8P"],
        "LMGP01011142 (PC(23:1(9Z)/23:1(9Z))[U]); LMGP01011140 (PC(23:1(14Z)/23:1(14Z))[U]); LMGP01011141 (PC(23:1(9Z)/23:1(9Z)))": ["C54H104NO8P", "Glycerophospholipids [GP] with formula: C54H104NO8P"],
        "LMGP01011105 (PC(22:0/24:1(15Z)))": ["C54H106NO8P", "Glycerophospholipids [GP] with formula: C54H106NO8P"],
        "LMGP02010086 (PE(24:0/25:0)[U]); LMGP02010085 (PE(23:0/26:0)[U]); LMGP02010276 (PE(25:0/24:0)[U]); LMGP01011157 (PC(24:0/22:0)[U]); LMGP02010286 (PE(26:0/23:0)[U]); LMGP01011193 (PC(26:0/20:0)[U]); LMGP01011077 (PC(21:0/25:0)[U]); LMGP01011178 (PC(25:0/21:0)[U]); LMGP01011136 (PC(23:0/23:0)[U]); LMGP01011135 (PC(23:0/23:0)); LMGP01011034 (PC(20:0/26:0)); LMGP01011104 (PC(22:0/24:0)[U])": ["C54H108NO8P", "Glycerophospholipids [GP] with formula: C54H108NO8P"],
        "LMGP02010087 (PE(24:0/26:0)[U]); LMGP02010088 (PE(25:0/25:0)[U]); LMGP01011137 (PC(23:0/24:0)[U]); LMGP01011158 (PC(24:0/23:0)[U]); LMGP02010280 (PE(26:0/24:0)[U]); LMGP01011194 (PC(26:0/21:0)[U]); LMGP01011078 (PC(21:0/26:0)[U]); LMGP01011179 (PC(25:0/22:0)[U]); LMGP01011106 (PC(22:0/25:0)[U])": ["C55H110NO8P", "Glycerophospholipids [GP] with formula: C55H110NO8P"],
        "LMGP01011167 (PC(24:2(5Z,9Z)/24:2(5Z,9Z))[U])": ["C56H104NO8P", "Glycerophospholipids [GP] with formula: C56H104NO8P"],
        "LMGP01011163 (PC(24:1(15Z)/24:1(15Z))); LMGP01011164 (PC(24:1(15Z)/24:1(15Z))[U]); LMGP01011165 (PC(24:1(5Z)/24:1(5Z))[U]); LMGP01011166 (PC(24:1(9Z)/24:1(9Z))[U])": ["C56H108NO8P", "Glycerophospholipids [GP] with formula: C56H108NO8P"],
        "LMGP02010089 (PE(25:0/26:0)[U]); LMGP01011160 (PC(24:0/24:0)[U]); LMGP02010274 (PE(26:0/25:0)[U]); LMGP01011159 (PC(24:0/24:0)); LMGP01011180 (PC(25:0/23:0)[U]); LMGP01011195 (PC(26:0/22:0)[U]); LMGP01011138 (PC(23:0/25:0)[U]); LMGP01011107 (PC(22:0/26:0))": ["C56H112NO8P", "Glycerophospholipids [GP] with formula: C56H112NO8P"],
        "LMGP02010170 (PE(26:2(5E,9Z)/26:2(5E,9Z))); LMGP02010035 (PE(26:2(5Z,9Z)/26:2(5Z,9Z))); LMGP02010169 (PE(26:2(5Z,9E)/26:2(5Z,9E)))": ["C57H106NO8P", "Glycerophospholipids [GP] with formula: C57H106NO8P"],
        "LMGP02010358 (NAPE(18:1(9Z)/16:1(9Z)/18:0))": ["C57H108NO9P", "Glycerophospholipids [GP] with formula: C57H108NO9P"],
        "LMGP01011161 (PC(24:0/25:0)[U]); LMGP01011181 (PC(25:0/24:0)[U]); LMGP01011196 (PC(26:0/23:0)[U]); LMGP01011139 (PC(23:0/26:0)[U]); LMGP02010090 (PE(26:0/26:0)[U])": ["C57H114NO8P", "Glycerophospholipids [GP] with formula: C57H114NO8P"],
        "LMGP03010041 (PS-NAc(18:0/18:1(9Z)/16:0))": ["C58H110NO11P", "Glycerophospholipids [GP] with formula: C58H110NO11P"],
        "LMGP01011162 (PC(24:0/26:0)[U]); LMGP01011182 (PC(25:0/25:0)[U]); LMGP01011197 (PC(26:0/24:0)[U]); LMGP01011218 (PC(34:0/16:0))": ["C58H116NO8P", "Glycerophospholipids [GP] with formula: C58H116NO8P"],
        "LMGP01011183 (PC(25:0/26:0)[U]); LMGP01011198 (PC(26:0/25:0)[U])": ["C59H118NO8P", "Glycerophospholipids [GP] with formula: C59H118NO8P"],
        "LMGP06040001 (Archaetidylglycerol-myo-inositol)": ["C59H119O11P", "Glycerophospholipids [GP] with formula: C59H119O11P"],
        "LMGP04090002 (54:3 SLBPA)": ["C60H111O11P", "Glycerophospholipids [GP] with formula: C60H111O11P"],
        "LMGP01011201 (PC(26:2(5E,9Z)/26:2(5E,9Z))); LMGP01011205 (PC(26:2(5Z,9Z)/26:2(5Z,9Z))[U]); LMGP01011204 (PC(26:2(5Z,9Z)/26:2(5Z,9Z))); LMGP01011206 (PC(26:2(6Z,9Z)/26:2(6Z,9Z))); LMGP01011202 (PC(26:2(5Z,9E)/26:2(5Z,9E))); LMGP01011055 (PC(20:4(5Z,8Z,11Z,14Z)/32:0)); LMGP01011217 (PC(32:0/20:4(5Z,8Z,11Z,14Z)))": ["C60H112NO8P", "Glycerophospholipids [GP] with formula: C60H112NO8P"],
        "LMGP01011200 (PC(26:2(5E,9E)/26;25E,9E))": ["C60H116NO8P", "Glycerophospholipids [GP] with formula: C60H116NO8P"],
        "LMGP01011199 (PC(26:0/26:0)[U]); LMGP01011219 (PC(36:0/16:0))": ["C60H120NO8P", "Glycerophospholipids [GP] with formula: C60H120NO8P"],
        "LMGP03010042 (PS-NAc(18:1(9Z)/18:1(9Z)/19:0))": ["C61H114NO11P", "Glycerophospholipids [GP] with formula: C61H114NO11P"],
        "LMGP15010001 (EtN-P-6ManAlpha1-2ManAplha1-6ManAlpha1-4GlcNAplha1-6-PI(14:0/14:0))": ["C64H121N2O35P2", "Glycerophospholipids [GP] with formula: C64H121N2O35P2"],
        "LMGP14070001 (Archaetidylglycerol-(glycosyl)-myo-inositol)": ["C65H129O16P", "Glycerophospholipids [GP] with formula: C65H129O16P"],
        "LMGP12010003 (CL(1'-[14:1(9Z)/14:1(9Z)],3'-[14:1(9Z)/15:1(10Z)])[rac])": ["C66H126N2O17P2", "Glycerophospholipids [GP] with formula: C66H126N2O17P2"],
        "LMGP12010004 (CL(1'-[15:0/15:0],3'-[15:0/16:1(9Z)])[rac])": ["C70H140N2O17P2", "Glycerophospholipids [GP] with formula: C70H140N2O17P2"],
        "LMGP12010006 (CL(1'-[16:0/18:1(11Z)],3'-[16:0/18:1(11Z)]))": ["C77H146O17P2", "Glycerophospholipids [GP] with formula: C77H146O17P2"],
        "LMGP18000001": ["C88H178NO9P", "Glycerophospholipids [GP] with formula: C88H178NO9P"],
        "LMGP12010005 (CL(1'-[22:1(13Z)/22:1(13Z)],3'-[22:1(13Z)/14:1(9Z)])[rac])": ["C89H172N2O17P2", "Glycerophospholipids [GP] with formula: C89H172N2O17P2"],
        "LMGP12130001": ["C89H182O13P2", "Glycerophospholipids [GP] with formula: C89H182O13P2"],
        "LMGP19000001": ["C94H190NO15P", "Glycerophospholipids [GP] with formula: C94H190NO15P"],
        "LMGP12010002 (CL(1'-[24:1(15Z)/24:1(15Z)],3'-[24:1(15Z)/14:1(9Z)])[rac])": ["C95H184N2O17P2", "Glycerophospholipids [GP] with formula: C95H184N2O17P2"],
    },
    'Sphingolipids [SP]': {
        "LMSP0601BG08": ["C100H175N5O44", "Sphingolipids [SP] with formula: C100H175N5O44"],
        "LMSP0601BX08; LMSP0601CA08": ["C100H175N5O45", "Sphingolipids [SP] with formula: C100H175N5O45"],
        "LMSP0601GB03": ["C100H175N5O49", "Sphingolipids [SP] with formula: C100H175N5O49"],
        "LMSP0601BQ03": ["C100H175N5O51", "Sphingolipids [SP] with formula: C100H175N5O51"],
        "LMSP0601CM04": ["C100H176N4O48", "Sphingolipids [SP] with formula: C100H176N4O48"],
        "LMSP0601CL04": ["C100H176N4O49", "Sphingolipids [SP] with formula: C100H176N4O49"],
        "LMSP0505AX01; LMSP0504BB01; LMSP0505AR01; LMSP0505BC01; LMSP0504AZ01; LMSP0505CH01": ["C100H176N4O51", "Sphingolipids [SP] with formula: C100H176N4O51"],
        "LMSP0505CO01": ["C100H176N4O53", "Sphingolipids [SP] with formula: C100H176N4O53"],
        "LMSP0504AU07; LMSP0505BA07": ["C100H177N3O45", "Sphingolipids [SP] with formula: C100H177N3O45"],
        "LMSP0504BH08; LMSP0506AH08": ["C100H177N5O43", "Sphingolipids [SP] with formula: C100H177N5O43"],
        "LMSP0601BG06": ["C100H177N5O44", "Sphingolipids [SP] with formula: C100H177N5O44"],
        "LMSP0601CA06; LMSP0601BX06": ["C100H177N5O45", "Sphingolipids [SP] with formula: C100H177N5O45"],
        "LMSP0504BF03": ["C100H177N5O47", "Sphingolipids [SP] with formula: C100H177N5O47"],
        "LMSP0505EM03; LMSP0504BI03": ["C100H177N5O48", "Sphingolipids [SP] with formula: C100H177N5O48"],
        "LMSP0502AZ08": ["C100H178N2O48", "Sphingolipids [SP] with formula: C100H178N2O48"],
        "LMSP0505AJ04": ["C100H178N4O46", "Sphingolipids [SP] with formula: C100H178N4O46"],
        "LMSP0504BA04; LMSP0505AW04; LMSP0505CL04; LMSP0504AY04; LMSP0505CS04; LMSP0505CP04; LMSP0505BD04; LMSP0505BI04": ["C100H178N4O47", "Sphingolipids [SP] with formula: C100H178N4O47"],
        "LMSP0505BV04; LMSP0505BO04": ["C100H178N4O48", "Sphingolipids [SP] with formula: C100H178N4O48"],
        "LMSP0504AU05; LMSP0505BA05": ["C100H179N3O45", "Sphingolipids [SP] with formula: C100H179N3O45"],
        "LMSP0504BH06; LMSP0506AH06": ["C100H179N5O43", "Sphingolipids [SP] with formula: C100H179N5O43"],
        "LMSP0502AZ06": ["C100H180N2O48", "Sphingolipids [SP] with formula: C100H180N2O48"],
        "LMSP0601CT07; LMSP0601BF07; LMSP0601AR07; LMSP0601AW07; LMSP0601ET07; LMSP0601CS07; LMSP0601AT07": ["C101H175N5O47", "Sphingolipids [SP] with formula: C101H175N5O47"],
        "LMSP0601BW07; LMSP0601BL04; LMSP0601CF07": ["C101H175N5O48", "Sphingolipids [SP] with formula: C101H175N5O48"],
        "LMSP0601GO01": ["C101H176N6O51", "Sphingolipids [SP] with formula: C101H176N6O51"],
        "LMSP0601EY07; LMSP0601FO07; LMSP0601DR07; LMSP0601GX07; LMSP0601GP07": ["C101H177N5O46", "Sphingolipids [SP] with formula: C101H177N5O46"],
        "LMSP0601AR05; LMSP0601EP07; LMSP0601ET05; LMSP0601BF05; LMSP0601CS05; LMSP0601CT05; LMSP0601AT05; LMSP0601AW05": ["C101H177N5O47", "Sphingolipids [SP] with formula: C101H177N5O47"],
        "LMSP0601BW05; LMSP0601CF05": ["C101H177N5O48", "Sphingolipids [SP] with formula: C101H177N5O48"],
        "LMSP0601ER02; LMSP0601GC02; LMSP0601FK02; LMSP0601GT02; LMSP0601EZ02": ["C101H177N5O51", "Sphingolipids [SP] with formula: C101H177N5O51"],
        "LMSP0601EQ02": ["C101H177N5O52", "Sphingolipids [SP] with formula: C101H177N5O52"],
        "LMSP0601DX08": ["C101H178N4O44", "Sphingolipids [SP] with formula: C101H178N4O44"],
        "LMSP0601EX08; LMSP0601GI08; LMSP0601DN08; LMSP0601BR08; LMSP0601FJ08; LMSP0601EM08; LMSP0601FM08; LMSP0601EJ08": ["C101H178N4O45", "Sphingolipids [SP] with formula: C101H178N4O45"],
        "LMSP0601DO03; LMSP0601EN03; LMSP0601EW03": ["C101H178N4O49", "Sphingolipids [SP] with formula: C101H178N4O49"],
        "LMSP0601EY05; LMSP0601DR05; LMSP0601FO05; LMSP0601GX05; LMSP0601GP05": ["C101H179N5O46", "Sphingolipids [SP] with formula: C101H179N5O46"],
        "LMSP0601EP05": ["C101H179N5O47", "Sphingolipids [SP] with formula: C101H179N5O47"],
        "LMSP0601DX06": ["C101H180N4O44", "Sphingolipids [SP] with formula: C101H180N4O44"],
        "LMSP0601EX06; LMSP0601GI06; LMSP0601FJ06; LMSP0601DN06; LMSP0601EM06; LMSP0601BR06; LMSP0601FM06; LMSP0601EJ06": ["C101H180N4O45", "Sphingolipids [SP] with formula: C101H180N4O45"],
        "LMSP0601CM07": ["C102H178N4O48", "Sphingolipids [SP] with formula: C102H178N4O48"],
        "LMSP0601CL07": ["C102H178N4O49", "Sphingolipids [SP] with formula: C102H178N4O49"],
        "LMSP0601GB04": ["C102H179N5O49", "Sphingolipids [SP] with formula: C102H179N5O49"],
        "LMSP0601BQ04": ["C102H179N5O51", "Sphingolipids [SP] with formula: C102H179N5O51"],
        "LMSP0504BG01; LMSP0505EE01; LMSP0505EF01; LMSP0505EG01; LMSP0505CT01; LMSP0505CC01; LMSP0504BJ01; LMSP0505EI01": ["C102H179N5O52", "Sphingolipids [SP] with formula: C102H179N5O52"],
        "LMSP0505BW01; LMSP0505EN01; LMSP0505BP01": ["C102H179N5O53", "Sphingolipids [SP] with formula: C102H179N5O53"],
        "LMSP0505AJ07": ["C102H180N4O46", "Sphingolipids [SP] with formula: C102H180N4O46"],
        "LMSP0504BA07; LMSP0505AW07; LMSP0505BI07; LMSP0505CL07; LMSP0504AY07; LMSP0505CS07; LMSP0505CP07; LMSP0505BD07": ["C102H180N4O47", "Sphingolipids [SP] with formula: C102H180N4O47"],
        "LMSP0505BV07; LMSP0505BO07; LMSP0601CM05": ["C102H180N4O48", "Sphingolipids [SP] with formula: C102H180N4O48"],
        "LMSP0601CL05": ["C102H180N4O49", "Sphingolipids [SP] with formula: C102H180N4O49"],
        "LMSP0505AX02; LMSP0504BB02; LMSP0505AR02; LMSP0505BC02; LMSP0504AZ02; LMSP0505CH02": ["C102H180N4O51", "Sphingolipids [SP] with formula: C102H180N4O51"],
        "LMSP0505CO02": ["C102H180N4O53", "Sphingolipids [SP] with formula: C102H180N4O53"],
        "LMSP0504AU08; LMSP0505BA08": ["C102H181N3O45", "Sphingolipids [SP] with formula: C102H181N3O45"],
        "LMSP0504BF04": ["C102H181N5O47", "Sphingolipids [SP] with formula: C102H181N5O47"],
        "LMSP0505EM04; LMSP0504BI04": ["C102H181N5O48", "Sphingolipids [SP] with formula: C102H181N5O48"],
        "LMSP0505AJ05": ["C102H182N4O46", "Sphingolipids [SP] with formula: C102H182N4O46"],
        "LMSP0504BA05; LMSP0505AW05; LMSP0505BI05; LMSP0505CL05; LMSP0504AY05; LMSP0505CS05; LMSP0505CP05; LMSP0505BD05": ["C102H182N4O47", "Sphingolipids [SP] with formula: C102H182N4O47"],
        "LMSP0505BV05; LMSP0505BO05": ["C102H182N4O48", "Sphingolipids [SP] with formula: C102H182N4O48"],
        "LMSP0504AU06; LMSP0505BA06": ["C102H183N3O45", "Sphingolipids [SP] with formula: C102H183N3O45"],
        "LMSP0601BL07": ["C103H177N5O48", "Sphingolipids [SP] with formula: C103H177N5O48"],
        "LMSP0601CT08; LMSP0601AR08; LMSP0601AT08; LMSP0601AW08; LMSP0601ET08; LMSP0601BF08; LMSP0601CS08": ["C103H179N5O47", "Sphingolipids [SP] with formula: C103H179N5O47"],
        "LMSP0601BW08; LMSP0601CF08; LMSP0601BL05": ["C103H179N5O48", "Sphingolipids [SP] with formula: C103H179N5O48"],
        "LMSP0601GO02": ["C103H180N6O51", "Sphingolipids [SP] with formula: C103H180N6O51"],
        "LMSP0601EY08; LMSP0601DR08; LMSP0601FO08; LMSP0601GX08; LMSP0601GP08": ["C103H181N5O46", "Sphingolipids [SP] with formula: C103H181N5O46"],
        "LMSP0601CT06; LMSP0601AR06; LMSP0601BF06; LMSP0601AW06; LMSP0601EP08; LMSP0601ET06; LMSP0601CS06; LMSP0601AT06": ["C103H181N5O47", "Sphingolipids [SP] with formula: C103H181N5O47"],
        "LMSP0601BW06; LMSP0601CF06": ["C103H181N5O48", "Sphingolipids [SP] with formula: C103H181N5O48"],
        "LMSP0601GT03; LMSP0601ER03; LMSP0601FK03; LMSP0601EZ03; LMSP0601GC03": ["C103H181N5O51", "Sphingolipids [SP] with formula: C103H181N5O51"],
        "LMSP0601EQ03": ["C103H181N5O52", "Sphingolipids [SP] with formula: C103H181N5O52"],
        "LMSP0601DO04; LMSP0601EN04; LMSP0601EW04": ["C103H182N4O49", "Sphingolipids [SP] with formula: C103H182N4O49"],
        "LMSP0601EY06; LMSP0601DR06; LMSP0601FO06; LMSP0601GX06; LMSP0601GP06": ["C103H183N5O46", "Sphingolipids [SP] with formula: C103H183N5O46"],
        "LMSP0601EP06": ["C103H183N5O47", "Sphingolipids [SP] with formula: C103H183N5O47"],
        "LMSP0601BO01; LMSP0601AU01; LMSP0601CU01; LMSP0601BJ01; LMSP0601AV01": ["C104H178N6O55", "Sphingolipids [SP] with formula: C104H178N6O55"],
        "LMSP0601GB07": ["C104H181N5O49", "Sphingolipids [SP] with formula: C104H181N5O49"],
        "LMSP0601BQ07": ["C104H181N5O51", "Sphingolipids [SP] with formula: C104H181N5O51"],
        "LMSP0601CM08": ["C104H182N4O48", "Sphingolipids [SP] with formula: C104H182N4O48"],
        "LMSP0601CL08": ["C104H182N4O49", "Sphingolipids [SP] with formula: C104H182N4O49"],
        "LMSP0505EH01; LMSP0504BK01": ["C104H182N6O53", "Sphingolipids [SP] with formula: C104H182N6O53"],
        "LMSP0504BF07": ["C104H183N5O47", "Sphingolipids [SP] with formula: C104H183N5O47"],
        "LMSP0505EM07; LMSP0504BI07": ["C104H183N5O48", "Sphingolipids [SP] with formula: C104H183N5O48"],
        "LMSP0601GB05": ["C104H183N5O49", "Sphingolipids [SP] with formula: C104H183N5O49"],
        "LMSP0601BQ05": ["C104H183N5O51", "Sphingolipids [SP] with formula: C104H183N5O51"],
        "LMSP0504BG02; LMSP0505EE02; LMSP0505EF02; LMSP0505CT02; LMSP0505CC02; LMSP0505EI02; LMSP0504BJ02; LMSP0505EG02": ["C104H183N5O52", "Sphingolipids [SP] with formula: C104H183N5O52"],
        "LMSP0505BW02; LMSP0505EN02; LMSP0505BP02": ["C104H183N5O53", "Sphingolipids [SP] with formula: C104H183N5O53"],
        "LMSP0505AJ08": ["C104H184N4O46", "Sphingolipids [SP] with formula: C104H184N4O46"],
        "LMSP0505AW08; LMSP0505CL08; LMSP0504AY08; LMSP0505CS08; LMSP0504BA08; LMSP0505CP08; LMSP0505BD08; LMSP0505BI08": ["C104H184N4O47", "Sphingolipids [SP] with formula: C104H184N4O47"],
        "LMSP0505BV08; LMSP0505BO08; LMSP0601CM06": ["C104H184N4O48", "Sphingolipids [SP] with formula: C104H184N4O48"],
        "LMSP0601CL06": ["C104H184N4O49", "Sphingolipids [SP] with formula: C104H184N4O49"],
        "LMSP0505AX03; LMSP0504BB03; LMSP0505AR03; LMSP0505BC03; LMSP0504AZ03; LMSP0505CH03": ["C104H184N4O51", "Sphingolipids [SP] with formula: C104H184N4O51"],
        "LMSP0505CO03": ["C104H184N4O53", "Sphingolipids [SP] with formula: C104H184N4O53"],
        "LMSP0504BF05": ["C104H185N5O47", "Sphingolipids [SP] with formula: C104H185N5O47"],
        "LMSP0505EM05; LMSP0504BI05": ["C104H185N5O48", "Sphingolipids [SP] with formula: C104H185N5O48"],
        "LMSP0505AJ06": ["C104H186N4O46", "Sphingolipids [SP] with formula: C104H186N4O46"],
        "LMSP0504BA06; LMSP0505AW06; LMSP0505BI06; LMSP0505CL06; LMSP0504AY06; LMSP0505CS06; LMSP0505CP06; LMSP0505BD06": ["C104H186N4O47", "Sphingolipids [SP] with formula: C104H186N4O47"],
        "LMSP0505BV06; LMSP0505BO06": ["C104H186N4O48", "Sphingolipids [SP] with formula: C104H186N4O48"],
        "LMSP0601BL08": ["C105H181N5O48", "Sphingolipids [SP] with formula: C105H181N5O48"],
        "LMSP0601BL06": ["C105H183N5O48", "Sphingolipids [SP] with formula: C105H183N5O48"],
        "LMSP0601FC01; LMSP0601ES01; LMSP0601FP01; LMSP0601FY01": ["C105H183N5O55", "Sphingolipids [SP] with formula: C105H183N5O55"],
        "LMSP0601FR01": ["C105H183N5O56", "Sphingolipids [SP] with formula: C105H183N5O56"],
        "LMSP0601GU01": ["C105H183N5O57", "Sphingolipids [SP] with formula: C105H183N5O57"],
        "LMSP0601DO07; LMSP0601EW07; LMSP0601EN07": ["C105H184N4O49", "Sphingolipids [SP] with formula: C105H184N4O49"],
        "LMSP0601GO03": ["C105H184N6O51", "Sphingolipids [SP] with formula: C105H184N6O51"],
        "LMSP0601ER04; LMSP0601GC04; LMSP0601FK04; LMSP0601GT04; LMSP0601EZ04": ["C105H185N5O51", "Sphingolipids [SP] with formula: C105H185N5O51"],
        "LMSP0601EQ04": ["C105H185N5O52", "Sphingolipids [SP] with formula: C105H185N5O52"],
        "LMSP0601DO05; LMSP0601EN05; LMSP0601EW05": ["C105H186N4O49", "Sphingolipids [SP] with formula: C105H186N4O49"],
        "LMSP0601BO02; LMSP0601AU02; LMSP0601AV02; LMSP0601CU02; LMSP0601BJ02": ["C106H182N6O55", "Sphingolipids [SP] with formula: C106H182N6O55"],
        "LMSP0601GB08": ["C106H185N5O49", "Sphingolipids [SP] with formula: C106H185N5O49"],
        "LMSP0601BQ08": ["C106H185N5O51", "Sphingolipids [SP] with formula: C106H185N5O51"],
        "LMSP0505BB01": ["C106H186N4O55", "Sphingolipids [SP] with formula: C106H186N4O55"],
        "LMSP0505EB01; LMSP0505EC01": ["C106H186N4O56", "Sphingolipids [SP] with formula: C106H186N4O56"],
        "LMSP0505EA01; LMSP0505ED01": ["C106H186N4O57", "Sphingolipids [SP] with formula: C106H186N4O57"],
        "LMSP0504BK02; LMSP0505EH02": ["C106H186N6O53", "Sphingolipids [SP] with formula: C106H186N6O53"],
        "LMSP0504BF08": ["C106H187N5O47", "Sphingolipids [SP] with formula: C106H187N5O47"],
        "LMSP0505EM08; LMSP0504BI08": ["C106H187N5O48", "Sphingolipids [SP] with formula: C106H187N5O48"],
        "LMSP0601GB06": ["C106H187N5O49", "Sphingolipids [SP] with formula: C106H187N5O49"],
        "LMSP0601BQ06": ["C106H187N5O51", "Sphingolipids [SP] with formula: C106H187N5O51"],
        "LMSP0504BG03; LMSP0505EE03; LMSP0505EG03; LMSP0505CT03; LMSP0505CC03; LMSP0505EF03; LMSP0505EI03; LMSP0504BJ03": ["C106H187N5O52", "Sphingolipids [SP] with formula: C106H187N5O52"],
        "LMSP0505BW03; LMSP0505EN03; LMSP0505BP03": ["C106H187N5O53", "Sphingolipids [SP] with formula: C106H187N5O53"],
        "LMSP0505AX04; LMSP0504BB04; LMSP0505AR04; LMSP0505BC04; LMSP0504AZ04; LMSP0505CH04": ["C106H188N4O51", "Sphingolipids [SP] with formula: C106H188N4O51"],
        "LMSP0505CO04": ["C106H188N4O53", "Sphingolipids [SP] with formula: C106H188N4O53"],
        "LMSP0504BF06": ["C106H189N5O47", "Sphingolipids [SP] with formula: C106H189N5O47"],
        "LMSP0505EM06; LMSP0504BI06": ["C106H189N5O48", "Sphingolipids [SP] with formula: C106H189N5O48"],
        "LMSP0601GT07; LMSP0601FK07; LMSP0601ER07; LMSP0601EZ07; LMSP0601GC07": ["C107H187N5O51", "Sphingolipids [SP] with formula: C107H187N5O51"],
        "LMSP0601EQ07": ["C107H187N5O52", "Sphingolipids [SP] with formula: C107H187N5O52"],
        "LMSP0601FC02; LMSP0601ES02; LMSP0601FP02; LMSP0601FY02": ["C107H187N5O55", "Sphingolipids [SP] with formula: C107H187N5O55"],
        "LMSP0601FR02": ["C107H187N5O56", "Sphingolipids [SP] with formula: C107H187N5O56"],
        "LMSP0601GU02": ["C107H187N5O57", "Sphingolipids [SP] with formula: C107H187N5O57"],
        "LMSP0601DO08; LMSP0601EN08; LMSP0601EW08": ["C107H188N4O49", "Sphingolipids [SP] with formula: C107H188N4O49"],
        "LMSP0601GO04": ["C107H188N6O51", "Sphingolipids [SP] with formula: C107H188N6O51"],
        "LMSP0601GC05; LMSP0601FK05; LMSP0601GT05; LMSP0601ER05; LMSP0601EZ05": ["C107H189N5O51", "Sphingolipids [SP] with formula: C107H189N5O51"],
        "LMSP0601EQ05": ["C107H189N5O52", "Sphingolipids [SP] with formula: C107H189N5O52"],
        "LMSP0601DO06; LMSP0601EN06; LMSP0601EW06": ["C107H190N4O49", "Sphingolipids [SP] with formula: C107H190N4O49"],
        "LMSP0601CU03; LMSP0601BJ03; LMSP0601AU03; LMSP0601BO03; LMSP0601AV03": ["C108H186N6O55", "Sphingolipids [SP] with formula: C108H186N6O55"],
        "LMSP0505CQ01; LMSP0505DX01; LMSP0504BP01; LMSP0505AY01; LMSP0504BM01": ["C108H189N5O56", "Sphingolipids [SP] with formula: C108H189N5O56"],
        "LMSP0505EO01; LMSP0505CD01": ["C108H189N5O57", "Sphingolipids [SP] with formula: C108H189N5O57"],
        "LMSP0505BQ01; LMSP0505BX01": ["C108H189N5O58", "Sphingolipids [SP] with formula: C108H189N5O58"],
        "LMSP0505AX07; LMSP0504BB07; LMSP0505AR07; LMSP0505BC07; LMSP0504AZ07; LMSP0505CH07": ["C108H190N4O51", "Sphingolipids [SP] with formula: C108H190N4O51"],
        "LMSP0505CO07": ["C108H190N4O53", "Sphingolipids [SP] with formula: C108H190N4O53"],
        "LMSP0505BB02": ["C108H190N4O55", "Sphingolipids [SP] with formula: C108H190N4O55"],
        "LMSP0505EC02; LMSP0505EB02": ["C108H190N4O56", "Sphingolipids [SP] with formula: C108H190N4O56"],
        "LMSP0505EA02; LMSP0505ED02": ["C108H190N4O57", "Sphingolipids [SP] with formula: C108H190N4O57"],
        "LMSP0505EH03; LMSP0504BK03": ["C108H190N6O53", "Sphingolipids [SP] with formula: C108H190N6O53"],
        "LMSP0504BG04; LMSP0505EE04; LMSP0505EF04; LMSP0505EG04; LMSP0505CT04; LMSP0505CC04; LMSP0505EI04; LMSP0504BJ04": ["C108H191N5O52", "Sphingolipids [SP] with formula: C108H191N5O52"],
        "LMSP0505BW04; LMSP0505EN04; LMSP0505BP04": ["C108H191N5O53", "Sphingolipids [SP] with formula: C108H191N5O53"],
        "LMSP0505AX05; LMSP0504BB05; LMSP0505AR05; LMSP0505BC05; LMSP0504AZ05; LMSP0505CH05": ["C108H192N4O51", "Sphingolipids [SP] with formula: C108H192N4O51"],
        "LMSP0505CO05": ["C108H192N4O53", "Sphingolipids [SP] with formula: C108H192N4O53"],
        "LMSP0601GO07": ["C109H190N6O51", "Sphingolipids [SP] with formula: C109H190N6O51"],
        "LMSP0601GT08; LMSP0601GC08; LMSP0601ER08; LMSP0601FK08; LMSP0601EZ08": ["C109H191N5O51", "Sphingolipids [SP] with formula: C109H191N5O51"],
        "LMSP0601EQ08": ["C109H191N5O52", "Sphingolipids [SP] with formula: C109H191N5O52"],
        "LMSP0601FC03; LMSP0601ES03; LMSP0601FP03; LMSP0601FY03": ["C109H191N5O55", "Sphingolipids [SP] with formula: C109H191N5O55"],
        "LMSP0601FR03": ["C109H191N5O56", "Sphingolipids [SP] with formula: C109H191N5O56"],
        "LMSP0601GU03": ["C109H191N5O57", "Sphingolipids [SP] with formula: C109H191N5O57"],
        "LMSP0601GO05": ["C109H192N6O51", "Sphingolipids [SP] with formula: C109H192N6O51"],
        "LMSP0601ER06; LMSP0601GC06; LMSP0601FK06; LMSP0601GT06; LMSP0601EZ06": ["C109H193N5O51", "Sphingolipids [SP] with formula: C109H193N5O51"],
        "LMSP0601EQ06": ["C109H193N5O52", "Sphingolipids [SP] with formula: C109H193N5O52"],
        "LMSP0601BO04; LMSP0601AU04; LMSP0601BJ04; LMSP0601CU04; LMSP0601AV04": ["C110H190N6O55", "Sphingolipids [SP] with formula: C110H190N6O55"],
        "LMSP0601FQ01; LMSP0601FB01": ["C110H190N6O59", "Sphingolipids [SP] with formula: C110H190N6O59"],
        "LMSP0505DY01; LMSP0505DZ01; LMSP0504BL01; LMSP0504BN01": ["C110H192N6O57", "Sphingolipids [SP] with formula: C110H192N6O57"],
        "LMSP0504BG07; LMSP0505EE07; LMSP0505EF07; LMSP0505EG07; LMSP0505CT07; LMSP0505CC07; LMSP0505EI07; LMSP0504BJ07": ["C110H193N5O52", "Sphingolipids [SP] with formula: C110H193N5O52"],
        "LMSP0505BW07; LMSP0505EN07; LMSP0505BP07": ["C110H193N5O53", "Sphingolipids [SP] with formula: C110H193N5O53"],
        "LMSP0505CQ02; LMSP0505DX02; LMSP0504BP02; LMSP0505AY02; LMSP0504BM02": ["C110H193N5O56", "Sphingolipids [SP] with formula: C110H193N5O56"],
        "LMSP0505EO02; LMSP0505CD02": ["C110H193N5O57", "Sphingolipids [SP] with formula: C110H193N5O57"],
        "LMSP0505BQ02; LMSP0505BX02": ["C110H193N5O58", "Sphingolipids [SP] with formula: C110H193N5O58"],
        "LMSP0505AX08; LMSP0504BB08; LMSP0505AR08; LMSP0505BC08; LMSP0504AZ08; LMSP0505CH08": ["C110H194N4O51", "Sphingolipids [SP] with formula: C110H194N4O51"],
        "LMSP0505CO08": ["C110H194N4O53", "Sphingolipids [SP] with formula: C110H194N4O53"],
        "LMSP0505BB03": ["C110H194N4O55", "Sphingolipids [SP] with formula: C110H194N4O55"],
        "LMSP0505EB03; LMSP0505EC03": ["C110H194N4O56", "Sphingolipids [SP] with formula: C110H194N4O56"],
        "LMSP0505EA03; LMSP0505ED03": ["C110H194N4O57", "Sphingolipids [SP] with formula: C110H194N4O57"],
        "LMSP0504BK04; LMSP0505EH04": ["C110H194N6O53", "Sphingolipids [SP] with formula: C110H194N6O53"],
        "LMSP0504BG05; LMSP0505EE05; LMSP0505EF05; LMSP0505EG05; LMSP0505CT05; LMSP0505CC05; LMSP0505EI05; LMSP0504BJ05": ["C110H195N5O52", "Sphingolipids [SP] with formula: C110H195N5O52"],
        "LMSP0505BW05; LMSP0505EN05; LMSP0505BP05": ["C110H195N5O53", "Sphingolipids [SP] with formula: C110H195N5O53"],
        "LMSP0505AX06; LMSP0504BB06; LMSP0505AR06; LMSP0505BC06; LMSP0504AZ06; LMSP0505CH06": ["C110H196N4O51", "Sphingolipids [SP] with formula: C110H196N4O51"],
        "LMSP0505CO06": ["C110H196N4O53", "Sphingolipids [SP] with formula: C110H196N4O53"],
        "LMSP0601FV01; LMSP0601FU01": ["C111H193N5O59", "Sphingolipids [SP] with formula: C111H193N5O59"],
        "LMSP0601FZ01": ["C111H193N5O60", "Sphingolipids [SP] with formula: C111H193N5O60"],
        "LMSP0601GO08": ["C111H194N6O51", "Sphingolipids [SP] with formula: C111H194N6O51"],
        "LMSP0601FC04; LMSP0601ES04; LMSP0601FP04; LMSP0601FY04": ["C111H195N5O55", "Sphingolipids [SP] with formula: C111H195N5O55"],
        "LMSP0601FR04": ["C111H195N5O56", "Sphingolipids [SP] with formula: C111H195N5O56"],
        "LMSP0601GU04": ["C111H195N5O57", "Sphingolipids [SP] with formula: C111H195N5O57"],
        "LMSP0601GO06": ["C111H196N6O51", "Sphingolipids [SP] with formula: C111H196N6O51"],
        "LMSP0601CU07; LMSP0601BO07; LMSP0601AU07; LMSP0601AV07; LMSP0601BJ07": ["C112H192N6O55", "Sphingolipids [SP] with formula: C112H192N6O55"],
        "LMSP0601BO05; LMSP0601AU05; LMSP0601BJ05; LMSP0601CU05; LMSP0601AV05": ["C112H194N6O55", "Sphingolipids [SP] with formula: C112H194N6O55"],
        "LMSP0601FB02; LMSP0601FQ02": ["C112H194N6O59", "Sphingolipids [SP] with formula: C112H194N6O59"],
        "LMSP0505AT01": ["C112H196N4O61", "Sphingolipids [SP] with formula: C112H196N4O61"],
        "LMSP0505EH07; LMSP0504BK07": ["C112H196N6O53", "Sphingolipids [SP] with formula: C112H196N6O53"],
        "LMSP0505DY02; LMSP0505DZ02; LMSP0504BL02; LMSP0504BN02": ["C112H196N6O57", "Sphingolipids [SP] with formula: C112H196N6O57"],
        "LMSP0505EE08; LMSP0505CT08; LMSP0505EF08; LMSP0504BJ08; LMSP0505EI08; LMSP0505CC08; LMSP0504BG08; LMSP0505EG08": ["C112H197N5O52", "Sphingolipids [SP] with formula: C112H197N5O52"],
        "LMSP0505BW08; LMSP0505EN08; LMSP0505BP08": ["C112H197N5O53", "Sphingolipids [SP] with formula: C112H197N5O53"],
        "LMSP0505CQ03; LMSP0504BP03; LMSP0505DX03; LMSP0505AY03; LMSP0504BM03": ["C112H197N5O56", "Sphingolipids [SP] with formula: C112H197N5O56"],
        "LMSP0505EO03; LMSP0505CD03": ["C112H197N5O57", "Sphingolipids [SP] with formula: C112H197N5O57"],
        "LMSP0505BQ03; LMSP0505BX03": ["C112H197N5O58", "Sphingolipids [SP] with formula: C112H197N5O58"],
        "LMSP0505BB04": ["C112H198N4O55", "Sphingolipids [SP] with formula: C112H198N4O55"],
        "LMSP0505EB04; LMSP0505EC04": ["C112H198N4O56", "Sphingolipids [SP] with formula: C112H198N4O56"],
        "LMSP0505EA04; LMSP0505ED04": ["C112H198N4O57", "Sphingolipids [SP] with formula: C112H198N4O57"],
        "LMSP0505EH05; LMSP0504BK05": ["C112H198N6O53", "Sphingolipids [SP] with formula: C112H198N6O53"],
        "LMSP0504BG06; LMSP0505EE06; LMSP0505EF06; LMSP0505EG06; LMSP0505CT06; LMSP0505CC06; LMSP0505EI06; LMSP0504BJ06": ["C112H199N5O52", "Sphingolipids [SP] with formula: C112H199N5O52"],
        "LMSP0505BW06; LMSP0505BP06; LMSP0505EN06": ["C112H199N5O53", "Sphingolipids [SP] with formula: C112H199N5O53"],
        "LMSP0601GA01": ["C113H196N6O60", "Sphingolipids [SP] with formula: C113H196N6O60"],
        "LMSP0601FC07; LMSP0601ES07; LMSP0601FP07; LMSP0601FY07": ["C113H197N5O55", "Sphingolipids [SP] with formula: C113H197N5O55"],
        "LMSP0601FR07": ["C113H197N5O56", "Sphingolipids [SP] with formula: C113H197N5O56"],
        "LMSP0601GU07": ["C113H197N5O57", "Sphingolipids [SP] with formula: C113H197N5O57"],
        "LMSP0601FV02; LMSP0601FU02": ["C113H197N5O59", "Sphingolipids [SP] with formula: C113H197N5O59"],
        "LMSP0601FZ02": ["C113H197N5O60", "Sphingolipids [SP] with formula: C113H197N5O60"],
        "LMSP0601FC05; LMSP0601ES05; LMSP0601FP05; LMSP0601FY05": ["C113H199N5O55", "Sphingolipids [SP] with formula: C113H199N5O55"],
        "LMSP0601FR05": ["C113H199N5O56", "Sphingolipids [SP] with formula: C113H199N5O56"],
        "LMSP0601GU05": ["C113H199N5O57", "Sphingolipids [SP] with formula: C113H199N5O57"],
        "LMSP0601BJ08; LMSP0601CU08; LMSP0601BO08; LMSP0601AU08; LMSP0601AV08": ["C114H196N6O55", "Sphingolipids [SP] with formula: C114H196N6O55"],
        "LMSP0601AV06; LMSP0601BO06; LMSP0601AU06; LMSP0601BJ06; LMSP0601CU06": ["C114H198N6O55", "Sphingolipids [SP] with formula: C114H198N6O55"],
        "LMSP0601FB03; LMSP0601FQ03": ["C114H198N6O59", "Sphingolipids [SP] with formula: C114H198N6O59"],
        "LMSP0505BY01; LMSP0505BR01": ["C114H199N5O63", "Sphingolipids [SP] with formula: C114H199N5O63"],
        "LMSP0505BB07": ["C114H200N4O55", "Sphingolipids [SP] with formula: C114H200N4O55"],
        "LMSP0505EB07; LMSP0505EC07": ["C114H200N4O56", "Sphingolipids [SP] with formula: C114H200N4O56"],
        "LMSP0505ED07; LMSP0505EA07": ["C114H200N4O57", "Sphingolipids [SP] with formula: C114H200N4O57"],
        "LMSP0505AT02": ["C114H200N4O61", "Sphingolipids [SP] with formula: C114H200N4O61"],
        "LMSP0505EH08; LMSP0504BK08": ["C114H200N6O53", "Sphingolipids [SP] with formula: C114H200N6O53"],
        "LMSP0505DY03; LMSP0505DZ03; LMSP0504BL03; LMSP0504BN03": ["C114H200N6O57", "Sphingolipids [SP] with formula: C114H200N6O57"],
        "LMSP0505CQ04; LMSP0505DX04; LMSP0504BP04; LMSP0505AY04; LMSP0504BM04": ["C114H201N5O56", "Sphingolipids [SP] with formula: C114H201N5O56"],
        "LMSP0505EO04; LMSP0505CD04": ["C114H201N5O57", "Sphingolipids [SP] with formula: C114H201N5O57"],
        "LMSP0505BQ04; LMSP0505BX04": ["C114H201N5O58", "Sphingolipids [SP] with formula: C114H201N5O58"],
        "LMSP0505BB05": ["C114H202N4O55", "Sphingolipids [SP] with formula: C114H202N4O55"],
        "LMSP0505EB05; LMSP0505EC05": ["C114H202N4O56", "Sphingolipids [SP] with formula: C114H202N4O56"],
        "LMSP0505EA05; LMSP0505ED05": ["C114H202N4O57", "Sphingolipids [SP] with formula: C114H202N4O57"],
        "LMSP0505EH06; LMSP0504BK06": ["C114H202N6O53", "Sphingolipids [SP] with formula: C114H202N6O53"],
        "LMSP0601AX01": ["C115H195N7O63", "Sphingolipids [SP] with formula: C115H195N7O63"],
        "LMSP0601GA02": ["C115H200N6O60", "Sphingolipids [SP] with formula: C115H200N6O60"],
        "LMSP0601ES08; LMSP0601FC08; LMSP0601FP08; LMSP0601FY08": ["C115H201N5O55", "Sphingolipids [SP] with formula: C115H201N5O55"],
        "LMSP0601FR08": ["C115H201N5O56", "Sphingolipids [SP] with formula: C115H201N5O56"],
        "LMSP0601GU08": ["C115H201N5O57", "Sphingolipids [SP] with formula: C115H201N5O57"],
        "LMSP0601FV03; LMSP0601FU03": ["C115H201N5O59", "Sphingolipids [SP] with formula: C115H201N5O59"],
        "LMSP0601FZ03": ["C115H201N5O60", "Sphingolipids [SP] with formula: C115H201N5O60"],
        "LMSP0601ES06; LMSP0601FC06; LMSP0601FP06; LMSP0601FY06": ["C115H203N5O55", "Sphingolipids [SP] with formula: C115H203N5O55"],
        "LMSP0601FR06": ["C115H203N5O56", "Sphingolipids [SP] with formula: C115H203N5O56"],
        "LMSP0601GU06": ["C115H203N5O57", "Sphingolipids [SP] with formula: C115H203N5O57"],
        "LMSP0601FB04; LMSP0601FQ04": ["C116H202N6O59", "Sphingolipids [SP] with formula: C116H202N6O59"],
        "LMSP0504BQ01; LMSP0504BO01; LMSP0505CR01": ["C116H202N6O61", "Sphingolipids [SP] with formula: C116H202N6O61"],
        "LMSP0505CQ07; LMSP0505DX07; LMSP0504BP07; LMSP0505AY07; LMSP0504BM07": ["C116H203N5O56", "Sphingolipids [SP] with formula: C116H203N5O56"],
        "LMSP0505EO07; LMSP0505CD07": ["C116H203N5O57", "Sphingolipids [SP] with formula: C116H203N5O57"],
        "LMSP0505BQ07; LMSP0505BX07": ["C116H203N5O58", "Sphingolipids [SP] with formula: C116H203N5O58"],
        "LMSP0505BY02; LMSP0505BR02": ["C116H203N5O63", "Sphingolipids [SP] with formula: C116H203N5O63"],
        "LMSP0505BB08": ["C116H204N4O55", "Sphingolipids [SP] with formula: C116H204N4O55"],
        "LMSP0505EB08; LMSP0505EC08": ["C116H204N4O56", "Sphingolipids [SP] with formula: C116H204N4O56"],
        "LMSP0505ED08; LMSP0505EA08": ["C116H204N4O57", "Sphingolipids [SP] with formula: C116H204N4O57"],
        "LMSP0505AT03": ["C116H204N4O61", "Sphingolipids [SP] with formula: C116H204N4O61"],
        "LMSP0505DY04; LMSP0505DZ04; LMSP0504BL04; LMSP0504BN04": ["C116H204N6O57", "Sphingolipids [SP] with formula: C116H204N6O57"],
        "LMSP0505CQ05; LMSP0505DX05; LMSP0504BP05; LMSP0505AY05; LMSP0504BM05": ["C116H205N5O56", "Sphingolipids [SP] with formula: C116H205N5O56"],
        "LMSP0505EO05; LMSP0505CD05": ["C116H205N5O57", "Sphingolipids [SP] with formula: C116H205N5O57"],
        "LMSP0505BQ05; LMSP0505BX05": ["C116H205N5O58", "Sphingolipids [SP] with formula: C116H205N5O58"],
        "LMSP0505BB06": ["C116H206N4O55", "Sphingolipids [SP] with formula: C116H206N4O55"],
        "LMSP0505EB06; LMSP0505EC06": ["C116H206N4O56", "Sphingolipids [SP] with formula: C116H206N4O56"],
        "LMSP0505EA06; LMSP0505ED06": ["C116H206N4O57", "Sphingolipids [SP] with formula: C116H206N4O57"],
        "LMSP0601AX02": ["C117H199N7O63", "Sphingolipids [SP] with formula: C117H199N7O63"],
        "LMSP0601FW01": ["C117H203N5O63", "Sphingolipids [SP] with formula: C117H203N5O63"],
        "LMSP0601GA03": ["C117H204N6O60", "Sphingolipids [SP] with formula: C117H204N6O60"],
        "LMSP0601FV04; LMSP0601FU04": ["C117H205N5O59", "Sphingolipids [SP] with formula: C117H205N5O59"],
        "LMSP0601FZ04": ["C117H205N5O60", "Sphingolipids [SP] with formula: C117H205N5O60"],
        "LMSP0601FQ07; LMSP0601FB07": ["C118H204N6O59", "Sphingolipids [SP] with formula: C118H204N6O59"],
        "LMSP0505DY07; LMSP0505DZ07; LMSP0504BL07; LMSP0504BN07": ["C118H206N6O57", "Sphingolipids [SP] with formula: C118H206N6O57"],
        "LMSP0601FB05; LMSP0601FQ05": ["C118H206N6O59", "Sphingolipids [SP] with formula: C118H206N6O59"],
        "LMSP0504BQ02; LMSP0504BO02; LMSP0505CR02": ["C118H206N6O61", "Sphingolipids [SP] with formula: C118H206N6O61"],
        "LMSP0505CQ08; LMSP0505DX08; LMSP0504BP08; LMSP0505AY08; LMSP0504BM08": ["C118H207N5O56", "Sphingolipids [SP] with formula: C118H207N5O56"],
        "LMSP0505EO08; LMSP0505CD08": ["C118H207N5O57", "Sphingolipids [SP] with formula: C118H207N5O57"],
        "LMSP0505BQ08; LMSP0505BX08": ["C118H207N5O58", "Sphingolipids [SP] with formula: C118H207N5O58"],
        "LMSP0505BY03; LMSP0505BR03": ["C118H207N5O63", "Sphingolipids [SP] with formula: C118H207N5O63"],
        "LMSP0505AT04": ["C118H208N4O61", "Sphingolipids [SP] with formula: C118H208N4O61"],
        "LMSP0505DY05; LMSP0505DZ05; LMSP0504BL05; LMSP0504BN05": ["C118H208N6O57", "Sphingolipids [SP] with formula: C118H208N6O57"],
        "LMSP0505CQ06; LMSP0505DX06; LMSP0504BP06; LMSP0505AY06; LMSP0504BM06": ["C118H209N5O56", "Sphingolipids [SP] with formula: C118H209N5O56"],
        "LMSP0505EO06; LMSP0505CD06": ["C118H209N5O57", "Sphingolipids [SP] with formula: C118H209N5O57"],
        "LMSP0505BQ06; LMSP0505BX06": ["C118H209N5O58", "Sphingolipids [SP] with formula: C118H209N5O58"],
        "LMSP0601AX03": ["C119H203N7O63", "Sphingolipids [SP] with formula: C119H203N7O63"],
        "LMSP0601FL01": ["C119H206N6O65", "Sphingolipids [SP] with formula: C119H206N6O65"],
        "LMSP0601FV07; LMSP0601FU07": ["C119H207N5O59", "Sphingolipids [SP] with formula: C119H207N5O59"],
        "LMSP0601FZ07": ["C119H207N5O60", "Sphingolipids [SP] with formula: C119H207N5O60"],
        "LMSP0601FW02": ["C119H207N5O63", "Sphingolipids [SP] with formula: C119H207N5O63"],
        "LMSP0601GA04": ["C119H208N6O60", "Sphingolipids [SP] with formula: C119H208N6O60"],
        "LMSP0601FV05; LMSP0601FU05": ["C119H209N5O59", "Sphingolipids [SP] with formula: C119H209N5O59"],
        "LMSP0601FZ05": ["C119H209N5O60", "Sphingolipids [SP] with formula: C119H209N5O60"],
        "LMSP0601FB08; LMSP0601FQ08": ["C120H208N6O59", "Sphingolipids [SP] with formula: C120H208N6O59"],
        "LMSP0505AT07": ["C120H210N4O61", "Sphingolipids [SP] with formula: C120H210N4O61"],
        "LMSP0505DY08; LMSP0505DZ08; LMSP0504BL08; LMSP0504BN08": ["C120H210N6O57", "Sphingolipids [SP] with formula: C120H210N6O57"],
        "LMSP0601FB06; LMSP0601FQ06": ["C120H210N6O59", "Sphingolipids [SP] with formula: C120H210N6O59"],
        "LMSP0504BQ03; LMSP0504BO03; LMSP0505CR03": ["C120H210N6O61", "Sphingolipids [SP] with formula: C120H210N6O61"],
        "LMSP0505BR04; LMSP0505BY04": ["C120H211N5O63", "Sphingolipids [SP] with formula: C120H211N5O63"],
        "LMSP0505AT05": ["C120H212N4O61", "Sphingolipids [SP] with formula: C120H212N4O61"],
        "LMSP0505DY06; LMSP0505DZ06; LMSP0504BL06; LMSP0504BN06": ["C120H212N6O57", "Sphingolipids [SP] with formula: C120H212N6O57"],
        "LMSP0601AX04": ["C121H207N7O63", "Sphingolipids [SP] with formula: C121H207N7O63"],
        "LMSP0601GA07": ["C121H210N6O60", "Sphingolipids [SP] with formula: C121H210N6O60"],
        "LMSP0601FL02": ["C121H210N6O65", "Sphingolipids [SP] with formula: C121H210N6O65"],
        "LMSP0601FV08; LMSP0601FU08": ["C121H211N5O59", "Sphingolipids [SP] with formula: C121H211N5O59"],
        "LMSP0601FZ08": ["C121H211N5O60", "Sphingolipids [SP] with formula: C121H211N5O60"],
        "LMSP0601FW03": ["C121H211N5O63", "Sphingolipids [SP] with formula: C121H211N5O63"],
        "LMSP0601GA05": ["C121H212N6O60", "Sphingolipids [SP] with formula: C121H212N6O60"],
        "LMSP0601FV06; LMSP0601FU06": ["C121H213N5O59", "Sphingolipids [SP] with formula: C121H213N5O59"],
        "LMSP0601FZ06": ["C121H213N5O60", "Sphingolipids [SP] with formula: C121H213N5O60"],
        "LMSP0505BZ01; LMSP0505BS01": ["C122H212N6O68", "Sphingolipids [SP] with formula: C122H212N6O68"],
        "LMSP0505BY07; LMSP0505BR07": ["C122H213N5O63", "Sphingolipids [SP] with formula: C122H213N5O63"],
        "LMSP0505AT08": ["C122H214N4O61", "Sphingolipids [SP] with formula: C122H214N4O61"],
        "LMSP0504BQ04; LMSP0504BO04; LMSP0505CR04": ["C122H214N6O61", "Sphingolipids [SP] with formula: C122H214N6O61"],
        "LMSP0505BY05; LMSP0505BR05": ["C122H215N5O63", "Sphingolipids [SP] with formula: C122H215N5O63"],
        "LMSP0505AT06": ["C122H216N4O61", "Sphingolipids [SP] with formula: C122H216N4O61"],
        "LMSP0601AX07": ["C123H209N7O63", "Sphingolipids [SP] with formula: C123H209N7O63"],
        "LMSP0601AX05": ["C123H211N7O63", "Sphingolipids [SP] with formula: C123H211N7O63"],
        "LMSP0601GA08": ["C123H214N6O60", "Sphingolipids [SP] with formula: C123H214N6O60"],
        "LMSP0601FL03": ["C123H214N6O65", "Sphingolipids [SP] with formula: C123H214N6O65"],
        "LMSP0601FW04": ["C123H215N5O63", "Sphingolipids [SP] with formula: C123H215N5O63"],
        "LMSP0601GA06": ["C123H216N6O60", "Sphingolipids [SP] with formula: C123H216N6O60"],
        "LMSP0504BQ07; LMSP0504BO07; LMSP0505CR07": ["C124H216N6O61", "Sphingolipids [SP] with formula: C124H216N6O61"],
        "LMSP0505BZ02; LMSP0505BS02": ["C124H216N6O68", "Sphingolipids [SP] with formula: C124H216N6O68"],
        "LMSP0505BY08; LMSP0505BR08": ["C124H217N5O63", "Sphingolipids [SP] with formula: C124H217N5O63"],
        "LMSP0504BQ05; LMSP0504BO05; LMSP0505CR05": ["C124H218N6O61", "Sphingolipids [SP] with formula: C124H218N6O61"],
        "LMSP0505BY06; LMSP0505BR06": ["C124H219N5O63", "Sphingolipids [SP] with formula: C124H219N5O63"],
        "LMSP0601AX08": ["C125H213N7O63", "Sphingolipids [SP] with formula: C125H213N7O63"],
        "LMSP0601AX06": ["C125H215N7O63", "Sphingolipids [SP] with formula: C125H215N7O63"],
        "LMSP0601FW07": ["C125H217N5O63", "Sphingolipids [SP] with formula: C125H217N5O63"],
        "LMSP0601FL04": ["C125H218N6O65", "Sphingolipids [SP] with formula: C125H218N6O65"],
        "LMSP0601FW05": ["C125H219N5O63", "Sphingolipids [SP] with formula: C125H219N5O63"],
        "LMSP0505EP01": ["C126H219N5O71", "Sphingolipids [SP] with formula: C126H219N5O71"],
        "LMSP0504BQ08; LMSP0504BO08; LMSP0505CR08": ["C126H220N6O61", "Sphingolipids [SP] with formula: C126H220N6O61"],
        "LMSP0505BZ03; LMSP0505BS03": ["C126H220N6O68", "Sphingolipids [SP] with formula: C126H220N6O68"],
        "LMSP0504BO06; LMSP0504BQ06; LMSP0505CR06": ["C126H222N6O61", "Sphingolipids [SP] with formula: C126H222N6O61"],
        "LMSP0601FL07": ["C127H220N6O65", "Sphingolipids [SP] with formula: C127H220N6O65"],
        "LMSP0601FW08": ["C127H221N5O63", "Sphingolipids [SP] with formula: C127H221N5O63"],
        "LMSP0601FL05": ["C127H222N6O65", "Sphingolipids [SP] with formula: C127H222N6O65"],
        "LMSP0601FW06": ["C127H223N5O63", "Sphingolipids [SP] with formula: C127H223N5O63"],
        "LMSP0505CA01; LMSP0505BT01": ["C128H222N6O73", "Sphingolipids [SP] with formula: C128H222N6O73"],
        "LMSP0505EP02": ["C128H223N5O71", "Sphingolipids [SP] with formula: C128H223N5O71"],
        "LMSP0505BZ04; LMSP0505BS04": ["C128H224N6O68", "Sphingolipids [SP] with formula: C128H224N6O68"],
        "LMSP0601FL08": ["C129H224N6O65", "Sphingolipids [SP] with formula: C129H224N6O65"],
        "LMSP0601FL06": ["C129H226N6O65", "Sphingolipids [SP] with formula: C129H226N6O65"],
        "LMSP0505BZ07; LMSP0505BS07": ["C130H226N6O68", "Sphingolipids [SP] with formula: C130H226N6O68"],
        "LMSP0505CA02; LMSP0505BT02": ["C130H226N6O73", "Sphingolipids [SP] with formula: C130H226N6O73"],
        "LMSP0505EP03": ["C130H227N5O71", "Sphingolipids [SP] with formula: C130H227N5O71"],
        "LMSP0505BZ05; LMSP0505BS05": ["C130H228N6O68", "Sphingolipids [SP] with formula: C130H228N6O68"],
        "LMSP0505BZ08; LMSP0505BS08": ["C132H230N6O68", "Sphingolipids [SP] with formula: C132H230N6O68"],
        "LMSP0505CA03; LMSP0505BT03": ["C132H230N6O73", "Sphingolipids [SP] with formula: C132H230N6O73"],
        "LMSP0505EP04": ["C132H231N5O71", "Sphingolipids [SP] with formula: C132H231N5O71"],
        "LMSP0505BZ06; LMSP0505BS06": ["C132H232N6O68", "Sphingolipids [SP] with formula: C132H232N6O68"],
        "LMSP0505BU01": ["C134H232N6O78", "Sphingolipids [SP] with formula: C134H232N6O78"],
        "LMSP0505EP07": ["C134H233N5O71", "Sphingolipids [SP] with formula: C134H233N5O71"],
        "LMSP0505CA04; LMSP0505BT04": ["C134H234N6O73", "Sphingolipids [SP] with formula: C134H234N6O73"],
        "LMSP0505EP05": ["C134H235N5O71", "Sphingolipids [SP] with formula: C134H235N5O71"],
        "LMSP0505BT07; LMSP0505CA07": ["C136H236N6O73", "Sphingolipids [SP] with formula: C136H236N6O73"],
        "LMSP0505BU02": ["C136H236N6O78", "Sphingolipids [SP] with formula: C136H236N6O78"],
        "LMSP0505EP08": ["C136H237N5O71", "Sphingolipids [SP] with formula: C136H237N5O71"],
        "LMSP0505CA05; LMSP0505BT05": ["C136H238N6O73", "Sphingolipids [SP] with formula: C136H238N6O73"],
        "LMSP0505EP06": ["C136H239N5O71", "Sphingolipids [SP] with formula: C136H239N5O71"],
        "LMSP0505CA08; LMSP0505BT08": ["C138H240N6O73", "Sphingolipids [SP] with formula: C138H240N6O73"],
        "LMSP0505BU03": ["C138H240N6O78", "Sphingolipids [SP] with formula: C138H240N6O78"],
        "LMSP0505CA06; LMSP0505BT06": ["C138H242N6O73", "Sphingolipids [SP] with formula: C138H242N6O73"],
        "LMSP0505BU04": ["C140H244N6O78", "Sphingolipids [SP] with formula: C140H244N6O78"],
        "LMSP0505BU07": ["C142H246N6O78", "Sphingolipids [SP] with formula: C142H246N6O78"],
        "LMSP0505BU05": ["C142H248N6O78", "Sphingolipids [SP] with formula: C142H248N6O78"],
        "LMSP0505BU08": ["C144H250N6O78", "Sphingolipids [SP] with formula: C144H250N6O78"],
        "LMSP0505BU06": ["C144H252N6O78", "Sphingolipids [SP] with formula: C144H252N6O78"],
        "LMSP01080007 ((4E,6E,d14:2) sphingosine)": ["C14H27NO2", "Sphingolipids [SP] with formula: C14H27NO2"],
        "LMSP01080034 (Halaminol A)": ["C14H29NO", "Sphingolipids [SP] with formula: C14H29NO"],
        "LMSP01040006 (C14 sphingosine)": ["C14H29NO2", "Sphingolipids [SP] with formula: C14H29NO2"],
        "LMSP01080033 (Xestoaminol C)": ["C14H31NO", "Sphingolipids [SP] with formula: C14H31NO"],
        "LMSP01080050 (Micropine)": ["C16H27NO2", "Sphingolipids [SP] with formula: C16H27NO2"],
        "LMSP01040008 (C16 Sphingosine)": ["C16H33NO2", "Sphingolipids [SP] with formula: C16H33NO2"],
        "LMSP01080049 (Prosopinine)": ["C16H33NO3", "Sphingolipids [SP] with formula: C16H33NO3"],
        "LMSP01050005 (C16 Sphingosine-1-phosphate)": ["C16H34NO5P", "Sphingolipids [SP] with formula: C16H34NO5P"],
        "LMSP01040001 (C16 Sphinganine)": ["C16H35NO2", "Sphingolipids [SP] with formula: C16H35NO2"],
        "LMSP01050006 (C16 Sphinganine-1-phosphate)": ["C16H36NO5P", "Sphingolipids [SP] with formula: C16H36NO5P"],
        "LMSP01080044 (S-Antazirine)": ["C17H25Br2NO2", "Sphingolipids [SP] with formula: C17H25Br2NO2"],
        "LMSP01080051 (Prosafrinine)": ["C17H33NO2", "Sphingolipids [SP] with formula: C17H33NO2"],
        "LMSP01040002 (C17 Sphingosine); LMSP01080005 (iso (4E,15-methyl-d16:1) sphingosine); LMSP01080006 (anteiso (4E,14-methyl-d16:1) sphingosine)": ["C17H35NO2", "Sphingolipids [SP] with formula: C17H35NO2"],
        "LMSP01040003 (C17 Sphinganine)": ["C17H37NO2", "Sphingolipids [SP] with formula: C17H37NO2"],
        "LMSP01080041 (Capnine)": ["C17H37NO4S", "Sphingolipids [SP] with formula: C17H37NO4S"],
        "LMSP01040004 (C17 Sphingosine-1-phosphate)": ["C17H39N2O5P", "Sphingolipids [SP] with formula: C17H39N2O5P"],
        "LMSP01040005 (C17 Sphinganine-1-phosphate)": ["C17H41N2O5P", "Sphingolipids [SP] with formula: C17H41N2O5P"],
        "LMSP0601GD01": ["C188H316N12O115", "Sphingolipids [SP] with formula: C188H316N12O115"],
        "LMSP01080035 (Obscuraminol A); LMSP01080036 (Crucigasterin 277)": ["C18H31NO", "Sphingolipids [SP] with formula: C18H31NO"],
        "LMSP01080013 ((4E,8E,10E-d18:3)sphingosine)": ["C18H33NO2", "Sphingolipids [SP] with formula: C18H33NO2"],
        "LMSP01080059; LMSP01080052 (Lepadin D); LMSP01080010 ((4E,8E,d18:2) sphingosine); LMSP01080011 ((4E,8Z,d18:2) sphingosine); LMSP01080002 (4E,14Z-Sphingadiene); LMSP01010002 (3-ketosphingosine)": ["C18H35NO2", "Sphingolipids [SP] with formula: C18H35NO2"],
        "LMSP01020002 (3-ketosphinganine); LMSP01080004 (5-hydroxy,3E-sphingosine); LMSP01080008 ((8Z,d18:1) sphingosine); LMSP01010001 (Sphingosine)": ["C18H37NO2", "Sphingolipids [SP] with formula: C18H37NO2"],
        "LMSP01030002 (Dehydrophytosphingosine); LMSP01080003 (6-hydroxysphingosine); LMSP01080009 ((4OH,8Z,t18:1) sphingosine)": ["C18H37NO3", "Sphingolipids [SP] with formula: C18H37NO3"],
        "LMSP01050001 (Sphingosine-1-phosphate)": ["C18H38NO5P", "Sphingolipids [SP] with formula: C18H38NO5P"],
        "LMSP01080032 (Spisulosine)": ["C18H39NO", "Sphingolipids [SP] with formula: C18H39NO"],
        "LMSP01080058 (Enigmol); LMSP01080055 (Safingol ( L-threo-sphinganine)); LMSP01020001 (Sphinganine)": ["C18H39NO2", "Sphingolipids [SP] with formula: C18H39NO2"],
        "LMSP01030001 (Phytosphingosine)": ["C18H39NO3", "Sphingolipids [SP] with formula: C18H39NO3"],
        "LMSP01050002 (Sphinganine-phosphate)": ["C18H40NO5P", "Sphingolipids [SP] with formula: C18H40NO5P"],
        "LMSP01050003 (Phytosphingosine 1-phosphate)": ["C18H40NO6P", "Sphingolipids [SP] with formula: C18H40NO6P"],
        "LMSP0601GD02": ["C190H320N12O115", "Sphingolipids [SP] with formula: C190H320N12O115"],
        "LMSP0601GD03": ["C192H324N12O115", "Sphingolipids [SP] with formula: C192H324N12O115"],
        "LMSP0601GD04": ["C194H328N12O115", "Sphingolipids [SP] with formula: C194H328N12O115"],
        "LMSP0601GD07": ["C196H330N12O115", "Sphingolipids [SP] with formula: C196H330N12O115"],
        "LMSP0601GD05": ["C196H332N12O115", "Sphingolipids [SP] with formula: C196H332N12O115"],
        "LMSP0601GD08": ["C198H334N12O115", "Sphingolipids [SP] with formula: C198H334N12O115"],
        "LMSP0601GD06": ["C198H336N12O115", "Sphingolipids [SP] with formula: C198H336N12O115"],
        "LMSP01080048 (Pramanicin)": ["C19H31NO6", "Sphingolipids [SP] with formula: C19H31NO6"],
        "LMSP01080043 (R-Dysidazirine)": ["C19H33NO2", "Sphingolipids [SP] with formula: C19H33NO2"],
        "LMSP01080014 ((9Me,4E,8E,10E-d19:3)sphingosine)": ["C19H35NO2", "Sphingolipids [SP] with formula: C19H35NO2"],
        "LMSP01080021 (Sulfamisterin)": ["C19H36NNaO8S", "Sphingolipids [SP] with formula: C19H36NNaO8S"],
        "LMSP01080012 ((4E,8E,9Me-d19:2)sphingosine)": ["C19H37NO2", "Sphingolipids [SP] with formula: C19H37NO2"],
        "LMSP01080045 (Penaresidin A); LMSP01080046 (Penaresidin B)": ["C19H39NO3", "Sphingolipids [SP] with formula: C19H39NO3"],
        "LMSP01050004 (C19 Sphingosine-1-phosphate)": ["C19H40NO5P", "Sphingolipids [SP] with formula: C19H40NO5P"],
        "LMSP01080053 (Clavepictine B)": ["C20H35NO", "Sphingolipids [SP] with formula: C20H35NO"],
        "LMSP02010014 (Cer(d18:1/2:0))": ["C20H39NO3", "Sphingolipids [SP] with formula: C20H39NO3"],
        "LMSP01080062 (Sphingofungin B)": ["C20H39NO6", "Sphingolipids [SP] with formula: C20H39NO6"],
        "LMSP03010032 (N-acetylsphingosine 1-phosphate)": ["C20H40NO6P", "Sphingolipids [SP] with formula: C20H40NO6P"],
        "LMSP01070001 (N,N-dimethylsphingosine)": ["C20H41NO2", "Sphingolipids [SP] with formula: C20H41NO2"],
        "LMSP01080031": ["C20H43NO", "Sphingolipids [SP] with formula: C20H43NO"],
        "LMSP01080056 (N,N-dimethyl-Safingol)": ["C20H43NO2", "Sphingolipids [SP] with formula: C20H43NO2"],
        "LMSP01080020 (Myriocin); LMSP01080066 (Sphingofungin F)": ["C21H39NO6", "Sphingolipids [SP] with formula: C21H39NO6"],
        "LMSP01080065 (Sphingofungin E)": ["C21H39NO7", "Sphingolipids [SP] with formula: C21H39NO7"],
        "LMSP01080061 (Sphingofungin A)": ["C21H41N3O6", "Sphingolipids [SP] with formula: C21H41N3O6"],
        "LMSP01080057 (N,N,N-trimethyl-sphingosine)": ["C21H44NO2", "Sphingolipids [SP] with formula: C21H44NO2"],
        "LMSP01080063 (Sphingofungin C); LMSP01080064 (Sphingofungin D)": ["C22H41NO7", "Sphingolipids [SP] with formula: C22H41NO7"],
        "LMSP01080016 (Aplidiasphingosine)": ["C22H43NO3", "Sphingolipids [SP] with formula: C22H43NO3"],
        "LMSP01040007 (C17 sphingosine-1-phosphocholine)": ["C22H47N2O5P", "Sphingolipids [SP] with formula: C22H47N2O5P"],
        "LMSP01080018 (Calicogorgin A)": ["C23H41NO3", "Sphingolipids [SP] with formula: C23H41NO3"],
        "LMSP01080047 (Penazetidine A)": ["C23H47NO2", "Sphingolipids [SP] with formula: C23H47NO2"],
        "LMSP01060001 (Sphingosine-1-phosphocholine)": ["C23H49N2O5P", "Sphingolipids [SP] with formula: C23H49N2O5P"],
        "LMSP01060002 (Sphinganine-1-phosphocholine)": ["C23H51N2O5P", "Sphingolipids [SP] with formula: C23H51N2O5P"],
        "LMSP08000002 (psychosine sulfate)": ["C24H47NO10S", "Sphingolipids [SP] with formula: C24H47NO10S"],
        "LMSP07000001 (Psychosine); LMSP05010031 (Glucosyl sphingosine)": ["C24H47NO7", "Sphingolipids [SP] with formula: C24H47NO7"],
        "LMSP01080038 (Oceanin); LMSP01080037 (Calyxinin)": ["C28H58N2O4", "Sphingolipids [SP] with formula: C28H58N2O4"],
        "LMSP01080040 (Leucettamol A)": ["C30H52N2O2", "Sphingolipids [SP] with formula: C30H52N2O2"],
        "LMSP02010002 (Cer(d18:1/12:0))": ["C30H59NO3", "Sphingolipids [SP] with formula: C30H59NO3"],
        "LMSP02050001 (CerP(d18:1/12:0))": ["C30H63N2O6P", "Sphingolipids [SP] with formula: C30H63N2O6P"],
        "LMSP01080060 (Scyphostatin A)": ["C31H45NO5", "Sphingolipids [SP] with formula: C31H45NO5"],
        "LMSP02010018 (Cer(d18:0/13:0))": ["C31H63NO3", "Sphingolipids [SP] with formula: C31H63NO3"],
        "LMSP02010022 (Cer(d18:2/14:0))": ["C32H61NO3", "Sphingolipids [SP] with formula: C32H61NO3"],
        "LMSP02010001 (Cer(d18:1/14:0))": ["C32H63NO3", "Sphingolipids [SP] with formula: C32H63NO3"],
        "LMSP00000001": ["C32H63NO5S", "Sphingolipids [SP] with formula: C32H63NO5S"],
        "LMSP02020016 (Cer(d18:0/14:0))": ["C32H65NO3", "Sphingolipids [SP] with formula: C32H65NO3"],
        "LMSP01080030 (Fumonisin C4)": ["C33H57NO13", "Sphingolipids [SP] with formula: C33H57NO13"],
        "LMSP01080029 (Fumonisin C3); LMSP01080028 (Fumonisin C2)": ["C33H57NO14", "Sphingolipids [SP] with formula: C33H57NO14"],
        "LMSP01080027 (Fumonisin C1)": ["C33H57NO15", "Sphingolipids [SP] with formula: C33H57NO15"],
        "LMSP02010023 (Cer(d18:2/15:0))": ["C33H63NO3", "Sphingolipids [SP] with formula: C33H63NO3"],
        "LMSP02010015 (Cer(d16:1/17:0))": ["C33H65NO3", "Sphingolipids [SP] with formula: C33H65NO3"],
        "LMSP02010019 (Cer(d18:0/15:0))": ["C33H67NO3", "Sphingolipids [SP] with formula: C33H67NO3"],
        "LMSP01080025 (Fumonisin B4)": ["C34H59NO13", "Sphingolipids [SP] with formula: C34H59NO13"],
        "LMSP01080024 (Fumonisin B3); LMSP01080023 (Fumonisin B2)": ["C34H59NO14", "Sphingolipids [SP] with formula: C34H59NO14"],
        "LMSP01080022 (Fumonisin B1)": ["C34H59NO15", "Sphingolipids [SP] with formula: C34H59NO15"],
        "LMSP02010024 (Cer(d18:2/16:0))": ["C34H65NO3", "Sphingolipids [SP] with formula: C34H65NO3"],
        "LMSP00000003": ["C34H65NO5S", "Sphingolipids [SP] with formula: C34H65NO5S"],
        "LMSP02010004 (Cer(d18:1/16:0))": ["C34H67NO3", "Sphingolipids [SP] with formula: C34H67NO3"],
        "LMSP00000002": ["C34H67NO5S", "Sphingolipids [SP] with formula: C34H67NO5S"],
        "LMSP02050002 (CerP(d18:1/16:0))": ["C34H68NO6P", "Sphingolipids [SP] with formula: C34H68NO6P"],
        "LMSP04000001": ["C34H69N2O5P", "Sphingolipids [SP] with formula: C34H69N2O5P"],
        "LMSP02020001 (Cer(d18:0/16:0))": ["C34H69NO3", "Sphingolipids [SP] with formula: C34H69NO3"],
        "LMSP02030001 (Cer(t18:0/16:0))": ["C34H69NO4", "Sphingolipids [SP] with formula: C34H69NO4"],
        "LMSP02050003 (CerP(d18:0/16:0))": ["C34H70NO6P", "Sphingolipids [SP] with formula: C34H70NO6P"],
        "LMSP01080042": ["C35H67NO8S", "Sphingolipids [SP] with formula: C35H67NO8S"],
        "LMSP02010020 (Cer(d18:1/17:0))": ["C35H69NO3", "Sphingolipids [SP] with formula: C35H69NO3"],
        "LMSP01080039 (Rhizochalinin D)": ["C35H70N2O8", "Sphingolipids [SP] with formula: C35H70N2O8"],
        "LMSP03010002 (SM(d18:1/12:0))": ["C35H71N2O6P", "Sphingolipids [SP] with formula: C35H71N2O6P"],
        "LMSP02010031 (Cer(d18:0/17:0))": ["C35H71NO3", "Sphingolipids [SP] with formula: C35H71NO3"],
        "LMSP03010079 (SM(d18:0/12:0))": ["C35H73N2O6P", "Sphingolipids [SP] with formula: C35H73N2O6P"],
        "LMSP01080026 (Fumonisin A1)": ["C36H61NO16", "Sphingolipids [SP] with formula: C36H61NO16"],
        "LMSP02010025 (Cer(d18:2/18:1))": ["C36H67NO3", "Sphingolipids [SP] with formula: C36H67NO3"],
        "LMSP02010003 (Cer(d18:1/18:1(9Z)))": ["C36H69NO3", "Sphingolipids [SP] with formula: C36H69NO3"],
        "LMSP0501AA01 (GlcCer(d18:1/12:0))": ["C36H69NO8", "Sphingolipids [SP] with formula: C36H69NO8"],
        "LMSP02020015 (Cer(d18:0/18:1(9Z))); LMSP02010006 (Cer(d18:1/18:0))": ["C36H71NO3", "Sphingolipids [SP] with formula: C36H71NO3"],
        "LMSP02050004 (CerP(d18:1/18:0))": ["C36H72NO6P", "Sphingolipids [SP] with formula: C36H72NO6P"],
        "LMSP02020008 (Cer(d18:0/18:0))": ["C36H73NO3", "Sphingolipids [SP] with formula: C36H73NO3"],
        "LMSP03010033 (SM(d18:0/13:0))": ["C36H75N2O6P", "Sphingolipids [SP] with formula: C36H75N2O6P"],
        "LMSP03010034 (SM(d18:2/14:0))": ["C37H73N2O6P", "Sphingolipids [SP] with formula: C37H73N2O6P"],
        "LMSP02010032 (Cer(d18:1/19:0))": ["C37H73NO3", "Sphingolipids [SP] with formula: C37H73NO3"],
        "LMSP03010035 (SM(d16:1/16:0)); LMSP03010028 (SM(d18:1/14:0))": ["C37H75N2O6P", "Sphingolipids [SP] with formula: C37H75N2O6P"],
        "LMSP03010030 (SM(d18:0/14:0))": ["C37H77N2O6P", "Sphingolipids [SP] with formula: C37H77N2O6P"],
        "LMSP02010027 (Cer(d18:2/20:1))": ["C38H71NO3", "Sphingolipids [SP] with formula: C38H71NO3"],
        "LMSP02010026 (Cer(d18:2/20:0))": ["C38H73NO3", "Sphingolipids [SP] with formula: C38H73NO3"],
        "LMSP0501AA26 (GlcCer(d18:1/14:0))": ["C38H73NO8", "Sphingolipids [SP] with formula: C38H73NO8"],
        "LMSP03010036 (SM(d18:2/15:0))": ["C38H75N2O6P", "Sphingolipids [SP] with formula: C38H75N2O6P"],
        "LMSP02010016 (Cer(d16:1/22:0)); LMSP02010007 (Cer(d18:1/20:0))": ["C38H75NO3", "Sphingolipids [SP] with formula: C38H75NO3"],
        "LMSP0501AA28 (GlcCer(d18:0/14:0))": ["C38H75NO8", "Sphingolipids [SP] with formula: C38H75NO8"],
        "LMSP02050005 (CerP(d18:1/20:0))": ["C38H76NO6P", "Sphingolipids [SP] with formula: C38H76NO6P"],
        "LMSP03010037 (SM(d16:1/17:0)); LMSP03010038 (SM(d18:1/15:0)); LMSP03020001 (Etn-1-P-Cer(d14:1/18:0))": ["C38H77N2O6P", "Sphingolipids [SP] with formula: C38H77N2O6P"],
        "LMSP02020009 (Cer(d18:0/20:0))": ["C38H77NO3", "Sphingolipids [SP] with formula: C38H77NO3"],
        "LMSP03010039 (SM(d18:1/15:0)); LMSP03010091 (SM(d18:0/15:0))": ["C38H79N2O6P", "Sphingolipids [SP] with formula: C38H79N2O6P"],
        "LMSP02010028 (Cer(d18:2/21:0)); LMSP01080019 (Hemsleyin imine A)": ["C39H75NO3", "Sphingolipids [SP] with formula: C39H75NO3"],
        "LMSP03010090 (SM(d18:2/16:0)); LMSP03010040 (SM(d16:1/18:1)); LMSP03010041 (SM(d18:1/16:1))": ["C39H77N2O6P", "Sphingolipids [SP] with formula: C39H77N2O6P"],
        "LMSP02010017 (Cer(d16:1/23:0))": ["C39H77NO3", "Sphingolipids [SP] with formula: C39H77NO3"],
        "LMSP03010003 (SM(d18:1/16:0)); LMSP03010042 (SM(d16:1/18:0)); LMSP03010043 (SM(d17:1/17:0))": ["C39H79N2O6P", "Sphingolipids [SP] with formula: C39H79N2O6P"],
        "LMSP03010004 (SM(d18:0/16:0))": ["C39H81N2O6P", "Sphingolipids [SP] with formula: C39H81N2O6P"],
        "LMSP0501AA33 (GlcCer(d18:2/16:0)); LMSP0501AC18 (GalCer(d18:2/16:0))": ["C40H75NO8", "Sphingolipids [SP] with formula: C40H75NO8"],
        "LMSP06020002 (C16 Sulfatide)": ["C40H77NO11S", "Sphingolipids [SP] with formula: C40H77NO11S"],
        "LMSP06020003 (C16-OH Sulfatide)": ["C40H77NO12S", "Sphingolipids [SP] with formula: C40H77NO12S"],
        "LMSP02010029 (Cer(d18:2/22:0))": ["C40H77NO3", "Sphingolipids [SP] with formula: C40H77NO3"],
        "LMSP0501AA03 (GlcCer(d18:1/16:0)); LMSP0501AC01 (GalCer(d18:1/16:0))": ["C40H77NO8", "Sphingolipids [SP] with formula: C40H77NO8"],
        "LMSP02010008 (Cer(d18:1/22:0))": ["C40H79NO3", "Sphingolipids [SP] with formula: C40H79NO3"],
        "LMSP0501AA04 (GlcCer(d18:0/16:0)); LMSP0501AC11 (GalCer(d18:0/16:0))": ["C40H79NO8", "Sphingolipids [SP] with formula: C40H79NO8"],
        "LMSP02050006 (CerP(d18:1/22:0))": ["C40H80NO6P", "Sphingolipids [SP] with formula: C40H80NO6P"],
        "LMSP03010044 (SM(d18:1/17:0)); LMSP03010045 (SM(d19:1/16:0))": ["C40H81N2O6P", "Sphingolipids [SP] with formula: C40H81N2O6P"],
        "LMSP02020010 (Cer(d18:0/22:0))": ["C40H81NO3", "Sphingolipids [SP] with formula: C40H81NO3"],
        "LMSP03010046 (SM(d18:0/17:0))": ["C40H83N2O6P", "Sphingolipids [SP] with formula: C40H83N2O6P"],
        "LMSP01080054 (Oceanalin A)": ["C41H72N2O9", "Sphingolipids [SP] with formula: C41H72N2O9"],
        "LMSP01080015 (Termitomycesphin A)": ["C41H77NO10", "Sphingolipids [SP] with formula: C41H77NO10"],
        "LMSP03010047 (SM(d18:2/18:1))": ["C41H79N2O6P", "Sphingolipids [SP] with formula: C41H79N2O6P"],
        "LMSP02010030 (Cer(d18:2/23:0))": ["C41H79NO3", "Sphingolipids [SP] with formula: C41H79NO3"],
        "LMSP03010051 (SM(d19:1/17:1)); LMSP03010048 (SM(d16:1/20:1)); LMSP03010049 (SM(d18:0/18:2)); LMSP03010050 (SM(d18:2/18:0)); LMSP03010029 (SM(d18:1/18:1(9Z)))": ["C41H81N2O6P", "Sphingolipids [SP] with formula: C41H81N2O6P"],
        "LMSP02010021 (Cer(d18:1/23:0))": ["C41H81NO3", "Sphingolipids [SP] with formula: C41H81NO3"],
        "LMSP03010031 (SM(d18:0/18:1(9Z))); LMSP03010001 (SM(d18:1/18:0)); LMSP03010052 (SM(d16:1/20:0))": ["C41H83N2O6P", "Sphingolipids [SP] with formula: C41H83N2O6P"],
        "LMSP03010054 (SM(d19:0/17:0)); LMSP03010053 (SM(d16:0/20:0)); LMSP03010020 (SM(d18:0/18:0))": ["C41H85N2O6P", "Sphingolipids [SP] with formula: C41H85N2O6P"],
        "LMSP0501AB02 (LacCer(d18:1/12:0))": ["C42H79NO13", "Sphingolipids [SP] with formula: C42H79NO13"],
        "LMSP0501AA27 (GlcCer(d18:1/18:1(9Z)))": ["C42H79NO8", "Sphingolipids [SP] with formula: C42H79NO8"],
        "LMSP06030001": ["C42H79NO9", "Sphingolipids [SP] with formula: C42H79NO9"],
        "LMSP06020001 (C18 Sulfatide)": ["C42H81NO11S", "Sphingolipids [SP] with formula: C42H81NO11S"],
        "LMSP06020004 (C18-OH Sulfatide)": ["C42H81NO12S", "Sphingolipids [SP] with formula: C42H81NO12S"],
        "LMSP02010009 (Cer(d18:1/24:1(15Z)))": ["C42H81NO3", "Sphingolipids [SP] with formula: C42H81NO3"],
        "LMSP0501AA29 (GlcCer(d18:0/18:1(9Z))); LMSP0501AA05 (GlcCer(d18:1/18:0)); LMSP0501AC02 (GalCer(d18:1/18:0))": ["C42H81NO8", "Sphingolipids [SP] with formula: C42H81NO8"],
        "LMSP02050007 (CerP(d18:1/24:1(15Z)))": ["C42H82NO6P", "Sphingolipids [SP] with formula: C42H82NO6P"],
        "LMSP02020011 (Cer(d18:0/24:1(15Z))); LMSP02010012 (Cer(d18:1/24:0))": ["C42H83NO3", "Sphingolipids [SP] with formula: C42H83NO3"],
        "LMSP0501AA19 (GlcCer(d18:0/18:0))": ["C42H83NO8", "Sphingolipids [SP] with formula: C42H83NO8"],
        "LMSP02050008 (CerP(d18:1/24:0))": ["C42H84NO6P", "Sphingolipids [SP] with formula: C42H84NO6P"],
        "LMSP03010055 (SM(d18:1/19:0)); LMSP03010056 (SM(d19:1/18:0))": ["C42H85N2O6P", "Sphingolipids [SP] with formula: C42H85N2O6P"],
        "LMSP02020012 (Cer(d18:0/24:0))": ["C42H85NO3", "Sphingolipids [SP] with formula: C42H85NO3"],
        "LMSP02020017 (N-(24-hydroxytetracosanyl)sphinganine); LMSP02030004 (Cer(t18:0/24:0))": ["C42H85NO4", "Sphingolipids [SP] with formula: C42H85NO4"],
        "LMSP02030002 (Cer(t18:0/24:0(2-OH)))": ["C42H85NO5", "Sphingolipids [SP] with formula: C42H85NO5"],
        "LMSP03010057 (SM(d18:2/20:1))": ["C43H83N2O6P", "Sphingolipids [SP] with formula: C43H83N2O6P"],
        "LMSP03010060 (SM(d18:2/20:0)); LMSP03010059 (SM(d18:1/20:1)); LMSP03010058 (SM(d16:1/22:1))": ["C43H85N2O6P", "Sphingolipids [SP] with formula: C43H85N2O6P"],
        "LMSP02010013 (Cer(d18:1/25:0))": ["C43H85NO3", "Sphingolipids [SP] with formula: C43H85NO3"],
        "LMSP03010005 (SM(d18:1/20:0)); LMSP03010061 (SM(d16:1/22:0)); LMSP03010062 (SM(d18:1/20:0))": ["C43H87N2O6P", "Sphingolipids [SP] with formula: C43H87N2O6P"],
        "LMSP03010063 (SM(d16:0/22:0)); LMSP03010021 (SM(d18:0/20:0))": ["C43H89N2O6P", "Sphingolipids [SP] with formula: C43H89N2O6P"],
        "LMSP0501AA35 (GlcCer(d18:2/20:1)); LMSP0501AC20 (GalCer(d18:2/20:1))": ["C44H81NO8", "Sphingolipids [SP] with formula: C44H81NO8"],
        "LMSP0501AB12 (LacCer(d18:1/14:0))": ["C44H83NO13", "Sphingolipids [SP] with formula: C44H83NO13"],
        "LMSP0501AA34 (GlcCer(d18:2/20:0)); LMSP0501AC19 (GalCer(d18:2/20:0))": ["C44H83NO8", "Sphingolipids [SP] with formula: C44H83NO8"],
        "LMSP06020010 (C20 Sulfatide)": ["C44H85NO11S", "Sphingolipids [SP] with formula: C44H85NO11S"],
        "LMSP06020005 (C20-OHSulfatide)": ["C44H85NO12S", "Sphingolipids [SP] with formula: C44H85NO12S"],
        "LMSP0501AB15 (LacCer(d18:0/18:0)); LMSP0501AB13 (LacCer(d18:0/14:0))": ["C44H85NO13", "Sphingolipids [SP] with formula: C44H85NO13"],
        "LMSP02010010 (Cer(d18:1/26:1(17Z)))": ["C44H85NO3", "Sphingolipids [SP] with formula: C44H85NO3"],
        "LMSP0501AA30 (GlcCer(d16:1/22:0)); LMSP0501AC09 (GalCer(d16:1/22:0)); LMSP0501AC03 (GalCer(d18:1/20:0)); LMSP0501AA06 (GlcCer(d18:1/20:0))": ["C44H85NO8", "Sphingolipids [SP] with formula: C44H85NO8"],
        "LMSP03010064 (SM(d18:2/21:0))": ["C44H87N2O6P", "Sphingolipids [SP] with formula: C44H87N2O6P"],
        "LMSP02020013 (Cer(d18:0/26:1(17Z))); LMSP02010011 (Cer(d18:1/26:0))": ["C44H87NO3", "Sphingolipids [SP] with formula: C44H87NO3"],
        "LMSP0501AA20 (GlcCer(d18:0/20:0)); LMSP0501AC12 (GalCer(d18:0/20:0))": ["C44H87NO8", "Sphingolipids [SP] with formula: C44H87NO8"],
        "LMSP02050010 (CerP(d18:1/26:0))": ["C44H88NO6P", "Sphingolipids [SP] with formula: C44H88NO6P"],
        "LMSP03010068 (SM(d19:1/20:0)); LMSP03010069 (SM(d20:1/19:0)); LMSP03010065 (SM(d16:1/23:0)); LMSP03010066 (SM(d17:1/22:0)); LMSP03010067 (SM(d18:1/21:0))": ["C44H89N2O6P", "Sphingolipids [SP] with formula: C44H89N2O6P"],
        "LMSP02020014 (Cer(d18:0/26:0))": ["C44H89NO3", "Sphingolipids [SP] with formula: C44H89NO3"],
        "LMSP02030005 (Cer(t18:0/26:0)); LMSP02020018 (N-(26-hydroxyhexacosanyl)sphinganine)": ["C44H89NO4", "Sphingolipids [SP] with formula: C44H89NO4"],
        "LMSP02030003 (Cer(t18:0/26:0(2-OH)))": ["C44H89NO5", "Sphingolipids [SP] with formula: C44H89NO5"],
        "LMSP0501AA36 (GlcCer(d18:2/21:0)); LMSP0501AC21 (GalCer(d18:2/21:0))": ["C45H85NO8", "Sphingolipids [SP] with formula: C45H85NO8"],
        "LMSP03010070 (SM(d18:2/22:1))": ["C45H87N2O6P", "Sphingolipids [SP] with formula: C45H87N2O6P"],
        "LMSP0501AA31 (GlcCer(d16:1/23:0)); LMSP0501AC10 (GalCer(d16:1/23:0))": ["C45H87NO8", "Sphingolipids [SP] with formula: C45H87NO8"],
        "LMSP03010092 (SM(d18:2/22:0)); LMSP03010072 (SM(d18:1/22:1)); LMSP03010071 (SM(d16:1/24:1))": ["C45H89N2O6P", "Sphingolipids [SP] with formula: C45H89N2O6P"],
        "LMSP03010006 (SM(d18:1/22:0)); LMSP03010073 (SM(d16:1/24:0))": ["C45H91N2O6P", "Sphingolipids [SP] with formula: C45H91N2O6P"],
        "LMSP03010022 (SM(d18:0/22:0))": ["C45H93N2O6P", "Sphingolipids [SP] with formula: C45H93N2O6P"],
        "LMSP0509AA01; LMSP0501AB03 (LacCer(d18:1/16:0)); LMSP0501AD01": ["C46H87NO13", "Sphingolipids [SP] with formula: C46H87NO13"],
        "LMSP0501AA37 (GlcCer(d18:2/22:0)); LMSP0501AC22 (GalCer(d18:2/22:0))": ["C46H87NO8", "Sphingolipids [SP] with formula: C46H87NO8"],
        "LMSP06020009 (C22 Sulfatide)": ["C46H89NO11S", "Sphingolipids [SP] with formula: C46H89NO11S"],
        "LMSP06020011 (C22-OH Sulfatide)": ["C46H89NO12S", "Sphingolipids [SP] with formula: C46H89NO12S"],
        "LMSP0501AB14 (LacCer(d18:0/16:0))": ["C46H89NO13", "Sphingolipids [SP] with formula: C46H89NO13"],
        "LMSP0501AC04 (GalCer(d18:1/22:0)); LMSP0501AA07 (GlcCer(d18:1/22:0))": ["C46H89NO8", "Sphingolipids [SP] with formula: C46H89NO8"],
        "LMSP03030001 (Ins-1-P-Cer(d18:1/22:0))": ["C46H90NO11P", "Sphingolipids [SP] with formula: C46H90NO11P"],
        "LMSP02050011 (CerP(d18:1/26:1(17Z)))": ["C46H90NO6P", "Sphingolipids [SP] with formula: C46H90NO6P"],
        "LMSP03010075 (SM(d18:2/23:0)); LMSP03010074 (SM(d17:1/24:1))": ["C46H91N2O6P", "Sphingolipids [SP] with formula: C46H91N2O6P"],
        "LMSP0501AA21 (GlcCer(d18:0/22:0)); LMSP0501AC13 (GalCer(d18:0/22:0))": ["C46H91NO8", "Sphingolipids [SP] with formula: C46H91NO8"],
        "LMSP03010078 (SM(d18:1/23:0)); LMSP03010077 (SM(d17:1/24:0)); LMSP03010076 (SM(d16:1/25:0))": ["C46H93N2O6P", "Sphingolipids [SP] with formula: C46H93N2O6P"],
        "LMSP0501AA38 (GlcCer(d18:2/23:0)); LMSP0501AC23 (GalCer(d18:2/23:0))": ["C47H89NO8", "Sphingolipids [SP] with formula: C47H89NO8"],
        "LMSP03010080 (SM(d18:2/24:1))": ["C47H91N2O6P", "Sphingolipids [SP] with formula: C47H91N2O6P"],
        "LMSP0501AA32 (GlcCer(d18:1/23:0)); LMSP0501AC17 (GalCer(d18:1/23:0))": ["C47H91NO8", "Sphingolipids [SP] with formula: C47H91NO8"],
        "LMSP03010007 (SM(d18:1/24:1(15Z))); LMSP03010081 (SM(d18:2/24:0))": ["C47H93N2O6P", "Sphingolipids [SP] with formula: C47H93N2O6P"],
        "LMSP03010008 (SM(d18:1/24:0)); LMSP03010023 (SM(d18:0/24:1(15Z)))": ["C47H95N2O6P", "Sphingolipids [SP] with formula: C47H95N2O6P"],
        "LMSP03010024 (SM(d18:0/24:0))": ["C47H97N2O6P", "Sphingolipids [SP] with formula: C47H97N2O6P"],
        "LMSP0501AB11 (LacCer(d18:1/18:1(9Z)))": ["C48H89NO13", "Sphingolipids [SP] with formula: C48H89NO13"],
        "LMSP06020015 (C24:1 Sulfatide)": ["C48H91NO11S", "Sphingolipids [SP] with formula: C48H91NO11S"],
        "LMSP06020016 (C24:1-OH Sulfatide)": ["C48H91NO12S", "Sphingolipids [SP] with formula: C48H91NO12S"],
        "LMSP0501AB22 (LacCer(d18:0/18:1)); LMSP0501AB04 (LacCer(d18:1/18:0)); LMSP0509AA02; LMSP0501AD02": ["C48H91NO13", "Sphingolipids [SP] with formula: C48H91NO13"],
        "LMSP0501AA08 (GlcCer(d18:1/24:1(15Z))); LMSP0501AC07 (GalCer(d18:1/24:1(15Z)))": ["C48H91NO8", "Sphingolipids [SP] with formula: C48H91NO8"],
        "LMSP06020013 (C24 Sulfatide)": ["C48H93NO11S", "Sphingolipids [SP] with formula: C48H93NO11S"],
        "LMSP06020014 (C24-OH Sulfatide)": ["C48H93NO12S", "Sphingolipids [SP] with formula: C48H93NO12S"],
        "LMSP0501AA22 (GlcCer(d18:0/24:1(15Z))); LMSP0501AA09 (GlcCer(d18:1/24:0)); LMSP0501AC05 (GalCer(d18:1/24:0))": ["C48H93NO8", "Sphingolipids [SP] with formula: C48H93NO8"],
        "LMSP03010083 (SM(d18:2/25:0)); LMSP03010084 (SM(d19:1/24:1)); LMSP03010082 (SM(d17:1/26:1))": ["C48H95N2O6P", "Sphingolipids [SP] with formula: C48H95N2O6P"],
        "LMSP0501AA23 (GlcCer(d18:0/24:0)); LMSP0501AC14 (GalCer(d18:0/24:0))": ["C48H95NO8", "Sphingolipids [SP] with formula: C48H95NO8"],
        "LMSP03010086 (SM(d19:1/24:0)); LMSP03010087 (SM(d20:1/23:0)); LMSP03010085 (SM(d19:0/24:1)); LMSP03010027 (SM(d18:1/25:0))": ["C48H97N2O6P", "Sphingolipids [SP] with formula: C48H97N2O6P"],
        "LMSP03010089 (SM(d17:0/27:0)); LMSP03010026 (SM(d18:0/26:0))": ["C49H101N2O6P", "Sphingolipids [SP] with formula: C49H101N2O6P"],
        "LMSP03010009 (SM(d18:1/26:1(17Z)))": ["C49H97N2O6P", "Sphingolipids [SP] with formula: C49H97N2O6P"],
        "LMSP03010010 (SM(d18:1/26:0)); LMSP03010088 (SM(d20:0/24:1)); LMSP03010025 (SM(d18:0/26:1(17Z)))": ["C49H99N2O6P", "Sphingolipids [SP] with formula: C49H99N2O6P"],
        "LMSP03030002 (Ins-1-P-Cer(t18:0/26:0))": ["C50H100NO12P", "Sphingolipids [SP] with formula: C50H100NO12P"],
        "LMSP0501AB05 (LacCer(d18:1/20:0)); LMSP0501AD03; LMSP0509AA03": ["C50H95NO13", "Sphingolipids [SP] with formula: C50H95NO13"],
        "LMSP0501AA10 (GlcCer(d18:1/26:1(17Z))); LMSP0501AC08 (GalCer(d18:1/26:1(17Z)))": ["C50H95NO8", "Sphingolipids [SP] with formula: C50H95NO8"],
        "LMSP0501AB16 (LacCer(d18:0/20:0))": ["C50H97NO13", "Sphingolipids [SP] with formula: C50H97NO13"],
        "LMSP0501AA24 (GlcCer(d18:0/26:1(17Z))); LMSP0501AA11 (GlcCer(d18:1/26:0)); LMSP0501AC06 (GalCer(d18:1/26:0)); LMSP0501AC16 (GalCer(d18:0/26:1))": ["C50H97NO8", "Sphingolipids [SP] with formula: C50H97NO8"],
        "LMSP0501AA25 (GlcCer(d18:0/26:0)); LMSP0501AC15 (GalCer(d18:0/26:0))": ["C50H99NO8", "Sphingolipids [SP] with formula: C50H99NO8"],
        "LMSP0601AA01": ["C51H94N2O16", "Sphingolipids [SP] with formula: C51H94N2O16"],
        "LMSP0501AB17 (LacCer(d18:0/22:0))": ["C52H101NO13", "Sphingolipids [SP] with formula: C52H101NO13"],
        "LMSP0505CZ01; LMSP0502AA01; LMSP0507AA01": ["C52H97NO18", "Sphingolipids [SP] with formula: C52H97NO18"],
        "LMSP0501AB06 (LacCer(d18:1/22:0)); LMSP0501AD04; LMSP0509AA04": ["C52H99NO13", "Sphingolipids [SP] with formula: C52H99NO13"],
        "LMSP0601AA02": ["C53H98N2O16", "Sphingolipids [SP] with formula: C53H98N2O16"],
        "LMSP0503AA01; LMSP0508AA01; LMSP0504AA01": ["C54H100N2O18", "Sphingolipids [SP] with formula: C54H100N2O18"],
        "LMSP0501AB21 (LacCer(d18:0/24:1)); LMSP0501AB09 (LacCer(d18:1/24:1(15Z))); LMSP0501AD07; LMSP0509AA07": ["C54H101NO13", "Sphingolipids [SP] with formula: C54H101NO13"],
        "LMSP0505CZ02; LMSP0502AA02; LMSP0507AA02": ["C54H101NO18", "Sphingolipids [SP] with formula: C54H101NO18"],
        "LMSP0501AB07 (LacCer(d18:1/24:0)); LMSP0501AD05; LMSP0509AA05": ["C54H103NO13", "Sphingolipids [SP] with formula: C54H103NO13"],
        "LMSP0501AB18 (LacCer(d18:0/24:0))": ["C54H105NO13", "Sphingolipids [SP] with formula: C54H105NO13"],
        "LMSP0601DH01": ["C55H101NO21", "Sphingolipids [SP] with formula: C55H101NO21"],
        "LMSP0601AA03": ["C55H102N2O16", "Sphingolipids [SP] with formula: C55H102N2O16"],
        "LMSP0503AA02; LMSP0508AA02; LMSP0504AA02": ["C56H104N2O18", "Sphingolipids [SP] with formula: C56H104N2O18"],
        "LMSP0509AA08; LMSP0501AB10 (LacCer(d18:1/26:1(17Z))); LMSP0501AD08": ["C56H105NO13", "Sphingolipids [SP] with formula: C56H105NO13"],
        "LMSP0505CZ03; LMSP0502AA03; LMSP0507AA03": ["C56H105NO18", "Sphingolipids [SP] with formula: C56H105NO18"],
        "LMSP0501AB20 (LacCer(d18:0/26:1)); LMSP0501AB08 (LacCer(d18:1/26:0)); LMSP0501AD06; LMSP0509AA06": ["C56H107NO13", "Sphingolipids [SP] with formula: C56H107NO13"],
        "LMSP0501AB19 (LacCer(d18:0/26:0))": ["C56H109NO13", "Sphingolipids [SP] with formula: C56H109NO13"],
        "LMSP03030004 (Man-b1-2-Ins-1-P-Cer(t18:0/2-OH-26:0))": ["C56H110NO18P", "Sphingolipids [SP] with formula: C56H110NO18P"],
        "LMSP06040001 (GlcNalpha1-6Ins-1-P-Cer(t18:0/26:0))": ["C56H111N2O16P", "Sphingolipids [SP] with formula: C56H111N2O16P"],
        "LMSP0601CI01": ["C57H103N2O22", "Sphingolipids [SP] with formula: C57H103N2O22"],
        "LMSP0601AJ01": ["C57H104N2O21", "Sphingolipids [SP] with formula: C57H104N2O21"],
        "LMSP0601DH02": ["C57H105NO21", "Sphingolipids [SP] with formula: C57H105NO21"],
        "LMSP01080017 (Plakoside A)": ["C57H105NO9", "Sphingolipids [SP] with formula: C57H105NO9"],
        "LMSP0601AA04": ["C57H106N2O16", "Sphingolipids [SP] with formula: C57H106N2O16"],
        "LMSP0506AA01": ["C58H107NO21", "Sphingolipids [SP] with formula: C58H107NO21"],
        "LMSP0505DI01": ["C58H107NO22", "Sphingolipids [SP] with formula: C58H107NO22"],
        "LMSP0502AO01; LMSP0505DM01; LMSP0502AL01": ["C58H107NO23", "Sphingolipids [SP] with formula: C58H107NO23"],
        "LMSP0503AA03; LMSP0508AA03; LMSP0504AA03": ["C58H108N2O18", "Sphingolipids [SP] with formula: C58H108N2O18"],
        "LMSP0505CZ04; LMSP0502AA04; LMSP0507AA04": ["C58H109NO18", "Sphingolipids [SP] with formula: C58H109NO18"],
        "LMSP0601CI02": ["C59H107N2O22", "Sphingolipids [SP] with formula: C59H107N2O22"],
        "LMSP0601AA07": ["C59H108N2O16", "Sphingolipids [SP] with formula: C59H108N2O16"],
        "LMSP0601AJ02": ["C59H108N2O21", "Sphingolipids [SP] with formula: C59H108N2O21"],
        "LMSP0601DH03": ["C59H109NO21", "Sphingolipids [SP] with formula: C59H109NO21"],
        "LMSP0601AA05": ["C59H110N2O16", "Sphingolipids [SP] with formula: C59H110N2O16"],
        "LMSP0506AP01; LMSP0505DO01; LMSP0505AA01; LMSP0503AB01; LMSP0502AS01; LMSP0505DC01; LMSP0502AB01; LMSP0505DA01; LMSP0504AB01": ["C60H110N2O23", "Sphingolipids [SP] with formula: C60H110N2O23"],
        "LMSP0505CZ07; LMSP0502AA07; LMSP0507AA07": ["C60H111NO18", "Sphingolipids [SP] with formula: C60H111NO18"],
        "LMSP0506AA02": ["C60H111NO21", "Sphingolipids [SP] with formula: C60H111NO21"],
        "LMSP0505DI02": ["C60H111NO22", "Sphingolipids [SP] with formula: C60H111NO22"],
        "LMSP0502AO02; LMSP0505DM02; LMSP0502AL02": ["C60H111NO23", "Sphingolipids [SP] with formula: C60H111NO23"],
        "LMSP0503AA04; LMSP0508AA04; LMSP0504AA04": ["C60H112N2O18", "Sphingolipids [SP] with formula: C60H112N2O18"],
        "LMSP0505CZ05; LMSP0502AA05; LMSP0507AA05": ["C60H113NO18", "Sphingolipids [SP] with formula: C60H113NO18"],
        "LMSP0601CI03": ["C61H111N2O22", "Sphingolipids [SP] with formula: C61H111N2O22"],
        "LMSP0601AA08": ["C61H112N2O16", "Sphingolipids [SP] with formula: C61H112N2O16"],
        "LMSP0601AJ03": ["C61H112N2O21", "Sphingolipids [SP] with formula: C61H112N2O21"],
        "LMSP0601DH04": ["C61H113NO21", "Sphingolipids [SP] with formula: C61H113NO21"],
        "LMSP0601AA06": ["C61H114N2O16", "Sphingolipids [SP] with formula: C61H114N2O16"],
        "LMSP0503AN01": ["C62H113N3O23", "Sphingolipids [SP] with formula: C62H113N3O23"],
        "LMSP0503AA07; LMSP0508AA07; LMSP0504AA07": ["C62H114N2O18", "Sphingolipids [SP] with formula: C62H114N2O18"],
        "LMSP0506AP02; LMSP0505DO02; LMSP0505AA02; LMSP0503AB02; LMSP0502AS02; LMSP0505DC02; LMSP0502AB02; LMSP0505DA02; LMSP0504AB02": ["C62H114N2O23", "Sphingolipids [SP] with formula: C62H114N2O23"],
        "LMSP0505CZ08; LMSP0502AA08; LMSP0507AA08": ["C62H115NO18", "Sphingolipids [SP] with formula: C62H115NO18"],
        "LMSP0506AA03": ["C62H115NO21", "Sphingolipids [SP] with formula: C62H115NO21"],
        "LMSP0505DI03": ["C62H115NO22", "Sphingolipids [SP] with formula: C62H115NO22"],
        "LMSP0502AO03; LMSP0505DM03; LMSP0502AL03": ["C62H115NO23", "Sphingolipids [SP] with formula: C62H115NO23"],
        "LMSP0503AA05; LMSP0508AA05; LMSP0504AA05": ["C62H116N2O18", "Sphingolipids [SP] with formula: C62H116N2O18"],
        "LMSP0505CZ06; LMSP0502AA06; LMSP0507AA06": ["C62H117NO18", "Sphingolipids [SP] with formula: C62H117NO18"],
        "LMSP03030003 (Ins-1-P-6-Man-beta1-2-Ins-1-P-Cer(t18:0/2-OH-26:0))": ["C62H121NO26P2", "Sphingolipids [SP] with formula: C62H121NO26P2"],
        "LMSP0601DG01; LMSP0601DC01": ["C63H114N2O26", "Sphingolipids [SP] with formula: C63H114N2O26"],
        "LMSP0601CI04": ["C63H115N2O22", "Sphingolipids [SP] with formula: C63H115N2O22"],
        "LMSP0601DH07": ["C63H115NO21", "Sphingolipids [SP] with formula: C63H115NO21"],
        "LMSP0601AJ04": ["C63H116N2O21", "Sphingolipids [SP] with formula: C63H116N2O21"],
        "LMSP0601DH05": ["C63H117NO21", "Sphingolipids [SP] with formula: C63H117NO21"],
        "LMSP0503AN02": ["C64H117N3O23", "Sphingolipids [SP] with formula: C64H117N3O23"],
        "LMSP0502AU01": ["C64H117NO27", "Sphingolipids [SP] with formula: C64H117NO27"],
        "LMSP0502AM01": ["C64H117NO28", "Sphingolipids [SP] with formula: C64H117NO28"],
        "LMSP0503AA08; LMSP0508AA08; LMSP0504AA08": ["C64H118N2O18", "Sphingolipids [SP] with formula: C64H118N2O18"],
        "LMSP0506AP03; LMSP0505DO03; LMSP0505AA03; LMSP0503AB03; LMSP0505DA03; LMSP0502AS03; LMSP0505DC03; LMSP0502AB03; LMSP0504AB03": ["C64H118N2O23", "Sphingolipids [SP] with formula: C64H118N2O23"],
        "LMSP0506AA04": ["C64H119NO21", "Sphingolipids [SP] with formula: C64H119NO21"],
        "LMSP0505DI04": ["C64H119NO22", "Sphingolipids [SP] with formula: C64H119NO22"],
        "LMSP0502AO04; LMSP0505DM04; LMSP0502AL04": ["C64H119NO23", "Sphingolipids [SP] with formula: C64H119NO23"],
        "LMSP0503AA06; LMSP0508AA06; LMSP0504AA06": ["C64H120N2O18", "Sphingolipids [SP] with formula: C64H120N2O18"],
        "LMSP0601CI07": ["C65H117N2O22", "Sphingolipids [SP] with formula: C65H117N2O22"],
        "LMSP0601AM01; LMSP0601EK01": ["C65H117N3O26", "Sphingolipids [SP] with formula: C65H117N3O26"],
        "LMSP0601AJ07": ["C65H118N2O21", "Sphingolipids [SP] with formula: C65H118N2O21"],
        "LMSP0601DG02; LMSP0601DC02": ["C65H118N2O26", "Sphingolipids [SP] with formula: C65H118N2O26"],
        "LMSP0601CI05": ["C65H119N2O22", "Sphingolipids [SP] with formula: C65H119N2O22"],
        "LMSP0601DH08": ["C65H119NO21", "Sphingolipids [SP] with formula: C65H119NO21"],
        "LMSP0601AJ05": ["C65H120N2O21", "Sphingolipids [SP] with formula: C65H120N2O21"],
        "LMSP0601DH06": ["C65H121NO21", "Sphingolipids [SP] with formula: C65H121NO21"],
        "LMSP0504AD01; LMSP0505DE01; LMSP0505AB01; LMSP0504AC01; LMSP0505AD01; LMSP0503AI01": ["C66H120N2O27", "Sphingolipids [SP] with formula: C66H120N2O27"],
        "LMSP0506AN01; LMSP0502AE01; LMSP0504AQ01; LMSP0505DD01; LMSP0502BA01; LMSP0505AC01; LMSP0505BK01; LMSP0503AJ01; LMSP0505BJ01; LMSP0504BU01; LMSP0505DB01; LMSP0505DN01; LMSP0502BK01; LMSP0502AP01": ["C66H120N2O28", "Sphingolipids [SP] with formula: C66H120N2O28"],
        "LMSP0503AN03": ["C66H121N3O23", "Sphingolipids [SP] with formula: C66H121N3O23"],
        "LMSP0506AA07": ["C66H121NO21", "Sphingolipids [SP] with formula: C66H121NO21"],
        "LMSP0505DI07": ["C66H121NO22", "Sphingolipids [SP] with formula: C66H121NO22"],
        "LMSP0502AO07; LMSP0502AL07; LMSP0505DM07": ["C66H121NO23", "Sphingolipids [SP] with formula: C66H121NO23"],
        "LMSP0502AU02": ["C66H121NO27", "Sphingolipids [SP] with formula: C66H121NO27"],
        "LMSP0502AM02": ["C66H121NO28", "Sphingolipids [SP] with formula: C66H121NO28"],
        "LMSP0506AP04; LMSP0505DO04; LMSP0505AA04; LMSP0503AB04; LMSP0502AS04; LMSP0505DC04; LMSP0502AB04; LMSP0505DA04; LMSP0504AB04": ["C66H122N2O23", "Sphingolipids [SP] with formula: C66H122N2O23"],
        "LMSP0506AA05": ["C66H123NO21", "Sphingolipids [SP] with formula: C66H123NO21"],
        "LMSP0505DI05": ["C66H123NO22", "Sphingolipids [SP] with formula: C66H123NO22"],
        "LMSP0502AO05; LMSP0505DM05; LMSP0502AL05": ["C66H123NO23", "Sphingolipids [SP] with formula: C66H123NO23"],
        "LMSP02040001": ["C66H125NO5", "Sphingolipids [SP] with formula: C66H125NO5"],
        "LMSP0601AP01 (GM1(12:0))": ["C67H119N3O31", "Sphingolipids [SP] with formula: C67H119N3O31"],
        "LMSP0601CI08": ["C67H121N2O22", "Sphingolipids [SP] with formula: C67H121N2O22"],
        "LMSP0601EK02; LMSP0601AM02": ["C67H121N3O26", "Sphingolipids [SP] with formula: C67H121N3O26"],
        "LMSP0601AJ08": ["C67H122N2O21", "Sphingolipids [SP] with formula: C67H122N2O21"],
        "LMSP0601DG03; LMSP0601DC03": ["C67H122N2O26", "Sphingolipids [SP] with formula: C67H122N2O26"],
        "LMSP0601CI06": ["C67H123N2O22", "Sphingolipids [SP] with formula: C67H123N2O22"],
        "LMSP0601AJ06": ["C67H124N2O21", "Sphingolipids [SP] with formula: C67H124N2O21"],
        "LMSP0601AK01": ["C68H121N3O29", "Sphingolipids [SP] with formula: C68H121N3O29"],
        "LMSP0502BD01; LMSP0506AO01; LMSP0503AO01; LMSP0505BN01; LMSP0506AD01; LMSP0503AE01; LMSP0505CE01; LMSP0502AD01; LMSP0502AC01; LMSP0502BC01; LMSP0505AK01; LMSP0504AJ01; LMSP0503AC01; LMSP0505DP01": ["C68H123N3O28", "Sphingolipids [SP] with formula: C68H123N3O28"],
        "LMSP0506AP07; LMSP0505DO07; LMSP0505DA07; LMSP0505AA07; LMSP0503AB07; LMSP0502AS07; LMSP0505DC07; LMSP0502AB07; LMSP0504AB07": ["C68H124N2O23", "Sphingolipids [SP] with formula: C68H124N2O23"],
        "LMSP0504AD02; LMSP0504AC02; LMSP0505AB02; LMSP0505DE02; LMSP0505AD02; LMSP0503AI02": ["C68H124N2O27", "Sphingolipids [SP] with formula: C68H124N2O27"],
        "LMSP0505DN02; LMSP0502AE02; LMSP0504AQ02; LMSP0505DD02; LMSP0502BA02; LMSP0505AC02; LMSP0505BK02; LMSP0503AJ02; LMSP0505BJ02; LMSP0504BU02; LMSP0502BK02; LMSP0506AN02; LMSP0505DB02; LMSP0502AP02": ["C68H124N2O28", "Sphingolipids [SP] with formula: C68H124N2O28"],
        "LMSP0503AN04": ["C68H125N3O23", "Sphingolipids [SP] with formula: C68H125N3O23"],
        "LMSP0506AA08": ["C68H125NO21", "Sphingolipids [SP] with formula: C68H125NO21"],
        "LMSP0505DI08": ["C68H125NO22", "Sphingolipids [SP] with formula: C68H125NO22"],
        "LMSP0505DM08; LMSP0502AL08; LMSP0502AO08": ["C68H125NO23", "Sphingolipids [SP] with formula: C68H125NO23"],
        "LMSP0502AU03": ["C68H125NO27", "Sphingolipids [SP] with formula: C68H125NO27"],
        "LMSP0502AM03": ["C68H125NO28", "Sphingolipids [SP] with formula: C68H125NO28"],
        "LMSP0506AP05; LMSP0505DO05; LMSP0505AA05; LMSP0503AB05; LMSP0502AS05; LMSP0505DC05; LMSP0502AB05; LMSP0505DA05; LMSP0504AB05": ["C68H126N2O23", "Sphingolipids [SP] with formula: C68H126N2O23"],
        "LMSP0506AA06": ["C68H127NO21", "Sphingolipids [SP] with formula: C68H127NO21"],
        "LMSP0505DI06": ["C68H127NO22", "Sphingolipids [SP] with formula: C68H127NO22"],
        "LMSP0505DM06; LMSP0502AO06; LMSP0502AL06": ["C68H127NO23", "Sphingolipids [SP] with formula: C68H127NO23"],
        "LMSP0601DF01; LMSP0601EB01; LMSP0601GG01; LMSP0601GE01; LMSP0601EC01; LMSP0601DD01": ["C69H124N2O31", "Sphingolipids [SP] with formula: C69H124N2O31"],
        "LMSP0601AM03; LMSP0601EK03": ["C69H125N3O26", "Sphingolipids [SP] with formula: C69H125N3O26"],
        "LMSP0601DC04; LMSP0601DG04": ["C69H126N2O26", "Sphingolipids [SP] with formula: C69H126N2O26"],
        "LMSP0601AK02": ["C70H125N3O29", "Sphingolipids [SP] with formula: C70H125N3O29"],
        "LMSP0503AN07": ["C70H127N3O23", "Sphingolipids [SP] with formula: C70H127N3O23"],
        "LMSP0502BD02; LMSP0506AO02; LMSP0503AO02; LMSP0505BN02; LMSP0506AD02; LMSP0503AE02; LMSP0505CE02; LMSP0502AD02; LMSP0502AC02; LMSP0502BC02; LMSP0505AK02; LMSP0504AJ02; LMSP0503AC02; LMSP0505DP02": ["C70H127N3O28", "Sphingolipids [SP] with formula: C70H127N3O28"],
        "LMSP0502AN01": ["C70H127NO33", "Sphingolipids [SP] with formula: C70H127NO33"],
        "LMSP0506AP08; LMSP0505DO08; LMSP0505AA08; LMSP0503AB08; LMSP0505DA08; LMSP0502AS08; LMSP0505DC08; LMSP0502AB08; LMSP0504AB08": ["C70H128N2O23", "Sphingolipids [SP] with formula: C70H128N2O23"],
        "LMSP0504AD03; LMSP0504AC03; LMSP0505AB03; LMSP0505DE03; LMSP0505AD03; LMSP0503AI03": ["C70H128N2O27", "Sphingolipids [SP] with formula: C70H128N2O27"],
        "LMSP0506AN03; LMSP0505DN03; LMSP0502AE03; LMSP0504AQ03; LMSP0505DD03; LMSP0502BA03; LMSP0505AC03; LMSP0505BK03; LMSP0503AJ03; LMSP0505BJ03; LMSP0504BU03; LMSP0505DB03; LMSP0502BK03; LMSP0502AP03": ["C70H128N2O28", "Sphingolipids [SP] with formula: C70H128N2O28"],
        "LMSP0503AN05": ["C70H129N3O23", "Sphingolipids [SP] with formula: C70H129N3O23"],
        "LMSP0502AU04": ["C70H129NO27", "Sphingolipids [SP] with formula: C70H129NO27"],
        "LMSP0502AM04": ["C70H129NO28", "Sphingolipids [SP] with formula: C70H129NO28"],
        "LMSP0506AP06; LMSP0505DO06; LMSP0505DA06; LMSP0505AA06; LMSP0503AB06; LMSP0502AS06; LMSP0505DC06; LMSP0502AB06; LMSP0504AB06": ["C70H130N2O23", "Sphingolipids [SP] with formula: C70H130N2O23"],
        "LMSP0601AH01; LMSP0601DZ01; LMSP0601EF01; LMSP0601DK01; LMSP0601DY01; LMSP0601ED01; LMSP0601AY01; LMSP0601BM01": ["C71H127N3O31", "Sphingolipids [SP] with formula: C71H127N3O31"],
        "LMSP0601FF01; LMSP0601CJ01; LMSP0601BY01": ["C71H127N3O32", "Sphingolipids [SP] with formula: C71H127N3O32"],
        "LMSP0601DG07; LMSP0601DC07": ["C71H128N2O26", "Sphingolipids [SP] with formula: C71H128N2O26"],
        "LMSP0601DF02; LMSP0601GG02; LMSP0601EB02; LMSP0601GE02; LMSP0601EC02; LMSP0601DD02": ["C71H128N2O31", "Sphingolipids [SP] with formula: C71H128N2O31"],
        "LMSP0601AM04; LMSP0601EK04": ["C71H129N3O26", "Sphingolipids [SP] with formula: C71H129N3O26"],
        "LMSP0601DC05; LMSP0601DG05": ["C71H130N2O26", "Sphingolipids [SP] with formula: C71H130N2O26"],
        "LMSP0601AK03": ["C72H129N3O29", "Sphingolipids [SP] with formula: C72H129N3O29"],
        "LMSP0505AG01; LMSP0504AI01": ["C72H130N2O31", "Sphingolipids [SP] with formula: C72H130N2O31"],
        "LMSP0502AI01; LMSP0504AE01; LMSP0505CV01; LMSP0505DF01; LMSP0502BM01; LMSP0505DK01; LMSP0503AK01; LMSP0505AE01": ["C72H130N2O32", "Sphingolipids [SP] with formula: C72H130N2O32"],
        "LMSP0502BF01; LMSP0502AQ01; LMSP0505DJ01": ["C72H130N2O33", "Sphingolipids [SP] with formula: C72H130N2O33"],
        "LMSP0503AN08": ["C72H131N3O23", "Sphingolipids [SP] with formula: C72H131N3O23"],
        "LMSP0506AO03; LMSP0502BD03; LMSP0503AO03; LMSP0505BN03; LMSP0503AE03; LMSP0505CE03; LMSP0502AD03; LMSP0502AC03; LMSP0502BC03; LMSP0506AD03; LMSP0505AK03; LMSP0504AJ03; LMSP0503AC03; LMSP0505DP03": ["C72H131N3O28", "Sphingolipids [SP] with formula: C72H131N3O28"],
        "LMSP0502AU07": ["C72H131NO27", "Sphingolipids [SP] with formula: C72H131NO27"],
        "LMSP0502AM07": ["C72H131NO28", "Sphingolipids [SP] with formula: C72H131NO28"],
        "LMSP0502AN02": ["C72H131NO33", "Sphingolipids [SP] with formula: C72H131NO33"],
        "LMSP0504AD04; LMSP0505AB04; LMSP0504AC04; LMSP0505DE04; LMSP0505AD04; LMSP0503AI04": ["C72H132N2O27", "Sphingolipids [SP] with formula: C72H132N2O27"],
        "LMSP0502BA04; LMSP0506AN04; LMSP0505DN04; LMSP0502AE04; LMSP0504AQ04; LMSP0505DD04; LMSP0505AC04; LMSP0505BK04; LMSP0503AJ04; LMSP0505BJ04; LMSP0504BU04; LMSP0505DB04; LMSP0502BK04; LMSP0502AP04": ["C72H132N2O28", "Sphingolipids [SP] with formula: C72H132N2O28"],
        "LMSP0503AN06": ["C72H133N3O23", "Sphingolipids [SP] with formula: C72H133N3O23"],
        "LMSP0502AU05": ["C72H133NO27", "Sphingolipids [SP] with formula: C72H133NO27"],
        "LMSP0502AM05": ["C72H133NO28", "Sphingolipids [SP] with formula: C72H133NO28"],
        "LMSP0601AM07; LMSP0601EK07": ["C73H131N3O26", "Sphingolipids [SP] with formula: C73H131N3O26"],
        "LMSP0601EF02; LMSP0601AP02; LMSP0601AH02; LMSP0601BM02; LMSP0601DY02; LMSP0601DZ02; LMSP0601DK02; LMSP0601ED02; LMSP0601AY02": ["C73H131N3O31", "Sphingolipids [SP] with formula: C73H131N3O31"],
        "LMSP0601FF02; LMSP0601BY02; LMSP0601CJ02": ["C73H131N3O32", "Sphingolipids [SP] with formula: C73H131N3O32"],
        "LMSP0601DG08; LMSP0601DC08": ["C73H132N2O26", "Sphingolipids [SP] with formula: C73H132N2O26"],
        "LMSP0601GG03; LMSP0601EB03; LMSP0601DF03; LMSP0601GE03; LMSP0601EC03; LMSP0601DD03": ["C73H132N2O31", "Sphingolipids [SP] with formula: C73H132N2O31"],
        "LMSP0601AM05; LMSP0601EK05": ["C73H133N3O26", "Sphingolipids [SP] with formula: C73H133N3O26"],
        "LMSP0601DG06; LMSP0601DC06": ["C73H134N2O26", "Sphingolipids [SP] with formula: C73H134N2O26"],
        "LMSP0601AK04": ["C74H133N3O29", "Sphingolipids [SP] with formula: C74H133N3O29"],
        "LMSP0503AG01; LMSP0505AF01; LMSP0504AF01; LMSP0505CG01; LMSP0505CU01; LMSP0504AK01; LMSP0505DR01; LMSP0502BH01; LMSP0504AR01": ["C74H133N3O32", "Sphingolipids [SP] with formula: C74H133N3O32"],
        "LMSP0505AL01; LMSP0505BG01; LMSP0503AP01; LMSP0504AL01; LMSP0502BG01; LMSP0505CF01; LMSP0502AF01; LMSP0504BR01; LMSP0503AD01; LMSP0506AM01; LMSP0502BL01; LMSP0502BE01; LMSP0505CB01; LMSP0503AF01; LMSP0503AM01; LMSP0506AK01; LMSP0505EJ01; LMSP0505DQ01; LMSP0505EL01": ["C74H133N3O33", "Sphingolipids [SP] with formula: C74H133N3O33"],
        "LMSP0504AD07; LMSP0505DE07; LMSP0505AB07; LMSP0504AC07; LMSP0505AD07; LMSP0503AI07": ["C74H134N2O27", "Sphingolipids [SP] with formula: C74H134N2O27"],
        "LMSP0502BA07; LMSP0506AN07; LMSP0505DN07; LMSP0502AE07; LMSP0504AQ07; LMSP0505DD07; LMSP0505AC07; LMSP0503AJ07; LMSP0505BJ07; LMSP0504BU07; LMSP0505DB07; LMSP0502BK07; LMSP0505BK07; LMSP0502AP07": ["C74H134N2O28", "Sphingolipids [SP] with formula: C74H134N2O28"],
        "LMSP0505AG02; LMSP0504AI02": ["C74H134N2O31", "Sphingolipids [SP] with formula: C74H134N2O31"],
        "LMSP0502AI02; LMSP0504AE02; LMSP0505CV02; LMSP0505DF02; LMSP0502BM02; LMSP0505DK02; LMSP0503AK02; LMSP0505AE02": ["C74H134N2O32", "Sphingolipids [SP] with formula: C74H134N2O32"],
        "LMSP0502BF02; LMSP0502AQ02; LMSP0505DJ02": ["C74H134N2O33", "Sphingolipids [SP] with formula: C74H134N2O33"],
        "LMSP0502BD04; LMSP0506AO04; LMSP0503AO04; LMSP0505BN04; LMSP0506AD04; LMSP0503AE04; LMSP0505CE04; LMSP0502AD04; LMSP0502AC04; LMSP0502BC04; LMSP0505AK04; LMSP0504AJ04; LMSP0503AC04; LMSP0505DP04": ["C74H135N3O28", "Sphingolipids [SP] with formula: C74H135N3O28"],
        "LMSP0502AU08": ["C74H135NO27", "Sphingolipids [SP] with formula: C74H135NO27"],
        "LMSP0502AM08": ["C74H135NO28", "Sphingolipids [SP] with formula: C74H135NO28"],
        "LMSP0502AN03": ["C74H135NO33", "Sphingolipids [SP] with formula: C74H135NO33"],
        "LMSP0504AD05; LMSP0505DE05; LMSP0505AB05; LMSP0504AC05; LMSP0505AD05; LMSP0503AI05": ["C74H136N2O27", "Sphingolipids [SP] with formula: C74H136N2O27"],
        "LMSP0502BA05; LMSP0506AN05; LMSP0505DN05; LMSP0502AE05; LMSP0504AQ05; LMSP0505DD05; LMSP0505AC05; LMSP0505BK05; LMSP0503AJ05; LMSP0505BJ05; LMSP0504BU05; LMSP0505DB05; LMSP0502BK05; LMSP0502AP05": ["C74H136N2O28", "Sphingolipids [SP] with formula: C74H136N2O28"],
        "LMSP0502AU06": ["C74H137NO27", "Sphingolipids [SP] with formula: C74H137NO27"],
        "LMSP0502AM06": ["C74H137NO28", "Sphingolipids [SP] with formula: C74H137NO28"],
        "LMSP0601GF01": ["C75H134N2O35", "Sphingolipids [SP] with formula: C75H134N2O35"],
        "LMSP0601AM08; LMSP0601EK08": ["C75H135N3O26", "Sphingolipids [SP] with formula: C75H135N3O26"],
        "LMSP0601AP03; LMSP0601EF03; LMSP0601AH03; LMSP0601DY03; LMSP0601DZ03; LMSP0601DK03; LMSP0601ED03; LMSP0601AY03; LMSP0601BM03": ["C75H135N3O31", "Sphingolipids [SP] with formula: C75H135N3O31"],
        "LMSP0601FF03; LMSP0601BY03; LMSP0601CJ03": ["C75H135N3O32", "Sphingolipids [SP] with formula: C75H135N3O32"],
        "LMSP0601DF04; LMSP0601GE04; LMSP0601GG04; LMSP0601EB04; LMSP0601DD04; LMSP0601EC04": ["C75H136N2O31", "Sphingolipids [SP] with formula: C75H136N2O31"],
        "LMSP0601EK06; LMSP0601AM06": ["C75H137N3O26", "Sphingolipids [SP] with formula: C75H137N3O26"],
        "LMSP0601AN01": ["C76H134N4O34", "Sphingolipids [SP] with formula: C76H134N4O34"],
        "LMSP0601AK07": ["C76H135N3O29", "Sphingolipids [SP] with formula: C76H135N3O29"],
        "LMSP0506AL01; LMSP0502BB01": ["C76H136N4O33", "Sphingolipids [SP] with formula: C76H136N4O33"],
        "LMSP0502BD07; LMSP0506AO07; LMSP0503AO07; LMSP0506AD07; LMSP0503AE07; LMSP0505CE07; LMSP0502AD07; LMSP0505BN07; LMSP0502AC07; LMSP0502BC07; LMSP0505AK07; LMSP0504AJ07; LMSP0503AC07; LMSP0505DP07": ["C76H137N3O28", "Sphingolipids [SP] with formula: C76H137N3O28"],
        "LMSP0601AK05": ["C76H137N3O29", "Sphingolipids [SP] with formula: C76H137N3O29"],
        "LMSP0505CG02; LMSP0505AF02; LMSP0504AF02; LMSP0503AG02; LMSP0505CU02; LMSP0504AK02; LMSP0505DR02; LMSP0502BH02; LMSP0504AR02": ["C76H137N3O32", "Sphingolipids [SP] with formula: C76H137N3O32"],
        "LMSP0505AL02; LMSP0503AP02; LMSP0504AL02; LMSP0505CF02; LMSP0505BG02; LMSP0502AF02; LMSP0504BR02; LMSP0503AD02; LMSP0506AM02; LMSP0502BL02; LMSP0502BE02; LMSP0505CB02; LMSP0503AF02; LMSP0502BG02; LMSP0505EL02; LMSP0503AM02; LMSP0506AK02; LMSP0505EJ02; LMSP0505DQ02": ["C76H137N3O33", "Sphingolipids [SP] with formula: C76H137N3O33"],
        "LMSP0502AW01": ["C76H137NO38", "Sphingolipids [SP] with formula: C76H137NO38"],
        "LMSP0504AD08; LMSP0504AC08; LMSP0505AB08; LMSP0505DE08; LMSP0505AD08; LMSP0503AI08": ["C76H138N2O27", "Sphingolipids [SP] with formula: C76H138N2O27"],
        "LMSP0502BA08; LMSP0506AN08; LMSP0505DN08; LMSP0502AE08; LMSP0504AQ08; LMSP0505DD08; LMSP0505AC08; LMSP0503AJ08; LMSP0505BJ08; LMSP0504BU08; LMSP0505BK08; LMSP0502BK08; LMSP0502AP08; LMSP0505DB08": ["C76H138N2O28", "Sphingolipids [SP] with formula: C76H138N2O28"],
        "LMSP0505AG03; LMSP0504AI03": ["C76H138N2O31", "Sphingolipids [SP] with formula: C76H138N2O31"],
        "LMSP0502AI03; LMSP0504AE03; LMSP0505CV03; LMSP0505DF03; LMSP0502BM03; LMSP0505DK03; LMSP0503AK03; LMSP0505AE03": ["C76H138N2O32", "Sphingolipids [SP] with formula: C76H138N2O32"],
        "LMSP0505DJ03; LMSP0502BF03; LMSP0502AQ03": ["C76H138N2O33", "Sphingolipids [SP] with formula: C76H138N2O33"],
        "LMSP0502BD05; LMSP0506AO05; LMSP0503AO05; LMSP0505BN05; LMSP0503AE05; LMSP0505CE05; LMSP0502AD05; LMSP0502AC05; LMSP0502BC05; LMSP0506AD05; LMSP0505AK05; LMSP0504AJ05; LMSP0503AC05; LMSP0505DP05": ["C76H139N3O28", "Sphingolipids [SP] with formula: C76H139N3O28"],
        "LMSP0502AN04": ["C76H139NO33", "Sphingolipids [SP] with formula: C76H139NO33"],
        "LMSP0504AD06; LMSP0505DE06; LMSP0505AB06; LMSP0504AC06; LMSP0505AD06; LMSP0503AI06": ["C76H140N2O27", "Sphingolipids [SP] with formula: C76H140N2O27"],
        "LMSP0506AN06; LMSP0503AJ06; LMSP0505DN06; LMSP0502AE06; LMSP0504AQ06; LMSP0505DD06; LMSP0502BA06; LMSP0505AC06; LMSP0505BJ06; LMSP0504BU06; LMSP0505DB06; LMSP0502BK06; LMSP0505BK06; LMSP0502AP06": ["C76H140N2O28", "Sphingolipids [SP] with formula: C76H140N2O28"],
        "LMSP0601CH01; LMSP0601DS01; LMSP0601EE01; LMSP0601DL01; LMSP0601BD01": ["C77H137N3O35", "Sphingolipids [SP] with formula: C77H137N3O35"],
        "LMSP0601DV01; LMSP0601GL01; LMSP0601GK01; LMSP0601GW01; LMSP0601CN01; LMSP0601EU01; LMSP0601GS01; LMSP0601AI01; LMSP0601AB01": ["C77H137N3O36", "Sphingolipids [SP] with formula: C77H137N3O36"],
        "LMSP0601AF01": ["C77H137N3O37", "Sphingolipids [SP] with formula: C77H137N3O37"],
        "LMSP0601DF07; LMSP0601GE07; LMSP0601GG07; LMSP0601EC07; LMSP0601EB07; LMSP0601DD07": ["C77H138N2O31", "Sphingolipids [SP] with formula: C77H138N2O31"],
        "LMSP0601GF02": ["C77H138N2O35", "Sphingolipids [SP] with formula: C77H138N2O35"],
        "LMSP0601AP04; LMSP0601EF04; LMSP0601BM04; LMSP0601AH04; LMSP0601DY04; LMSP0601DZ04; LMSP0601DK04; LMSP0601ED04; LMSP0601AY04": ["C77H139N3O31", "Sphingolipids [SP] with formula: C77H139N3O31"],
        "LMSP0601FF04; LMSP0601CJ04; LMSP0601BY04": ["C77H139N3O32", "Sphingolipids [SP] with formula: C77H139N3O32"],
        "LMSP0601DF05; LMSP0601GG05; LMSP0601GE05; LMSP0601EB05; LMSP0601EC05; LMSP0601DD05": ["C77H140N2O31", "Sphingolipids [SP] with formula: C77H140N2O31"],
        "LMSP0601DE01; LMSP0601DI01": ["C78H138N2O39", "Sphingolipids [SP] with formula: C78H138N2O39"],
        "LMSP0601AN02": ["C78H138N4O34", "Sphingolipids [SP] with formula: C78H138N4O34"],
        "LMSP0601AK08": ["C78H139N3O29", "Sphingolipids [SP] with formula: C78H139N3O29"],
        "LMSP0504AG01; LMSP0505CY01": ["C78H140N2O36", "Sphingolipids [SP] with formula: C78H140N2O36"],
        "LMSP0505DL01; LMSP0502AK01": ["C78H140N2O37", "Sphingolipids [SP] with formula: C78H140N2O37"],
        "LMSP0502AR01": ["C78H140N2O38", "Sphingolipids [SP] with formula: C78H140N2O38"],
        "LMSP0506AL02; LMSP0502BB02": ["C78H140N4O33", "Sphingolipids [SP] with formula: C78H140N4O33"],
        "LMSP0506AO08; LMSP0506AD08; LMSP0503AO08; LMSP0502AC08; LMSP0505BN08; LMSP0502BD08; LMSP0503AE08; LMSP0502AD08; LMSP0502BC08; LMSP0505AK08; LMSP0504AJ08; LMSP0503AC08; LMSP0505CE08; LMSP0505DP08": ["C78H141N3O28", "Sphingolipids [SP] with formula: C78H141N3O28"],
        "LMSP0601AK06": ["C78H141N3O29", "Sphingolipids [SP] with formula: C78H141N3O29"],
        "LMSP0505AF03; LMSP0504AF03; LMSP0505CG03; LMSP0503AG03; LMSP0505CU03; LMSP0504AK03; LMSP0505DR03; LMSP0502BH03; LMSP0504AR03": ["C78H141N3O32", "Sphingolipids [SP] with formula: C78H141N3O32"],
        "LMSP0505AL03; LMSP0505BG03; LMSP0503AP03; LMSP0502AF03; LMSP0504AL03; LMSP0502BG03; LMSP0505CF03; LMSP0504BR03; LMSP0502BE03; LMSP0506AM03; LMSP0502BL03; LMSP0503AD03; LMSP0505CB03; LMSP0503AF03; LMSP0503AM03; LMSP0505EJ03; LMSP0506AK03; LMSP0505DQ03; LMSP0505EL03": ["C78H141N3O33", "Sphingolipids [SP] with formula: C78H141N3O33"],
        "LMSP0502AN07": ["C78H141NO33", "Sphingolipids [SP] with formula: C78H141NO33"],
        "LMSP0502AW02": ["C78H141NO38", "Sphingolipids [SP] with formula: C78H141NO38"],
        "LMSP0505AG04; LMSP0504AI04": ["C78H142N2O31", "Sphingolipids [SP] with formula: C78H142N2O31"],
        "LMSP0502AI04; LMSP0504AE04; LMSP0505DF04; LMSP0505CV04; LMSP0502BM04; LMSP0505DK04; LMSP0503AK04; LMSP0505AE04": ["C78H142N2O32", "Sphingolipids [SP] with formula: C78H142N2O32"],
        "LMSP0502BF04; LMSP0505DJ04; LMSP0502AQ04": ["C78H142N2O33", "Sphingolipids [SP] with formula: C78H142N2O33"],
        "LMSP0506AO06; LMSP0503AO06; LMSP0505BN06; LMSP0502BD06; LMSP0506AD06; LMSP0503AE06; LMSP0502AD06; LMSP0502AC06; LMSP0502BC06; LMSP0505AK06; LMSP0504AJ06; LMSP0503AC06; LMSP0505DP06; LMSP0505CE06": ["C78H143N3O28", "Sphingolipids [SP] with formula: C78H143N3O28"],
        "LMSP0502AN05": ["C78H143NO33", "Sphingolipids [SP] with formula: C78H143NO33"],
        "LMSP0601AL01": ["C79H138N4O37", "Sphingolipids [SP] with formula: C79H138N4O37"],
        "LMSP0601CO01; LMSP0601BC01; LMSP0601FI01; LMSP0601AZ01; LMSP0601DP01; LMSP0601FD01; LMSP0601CW01; LMSP0601BS01; LMSP0601FX01": ["C79H140N4O36", "Sphingolipids [SP] with formula: C79H140N4O36"],
        "LMSP0601BZ01": ["C79H140N4O37", "Sphingolipids [SP] with formula: C79H140N4O37"],
        "LMSP0601AP07; LMSP0601AH07; LMSP0601AY07; LMSP0601DZ07; LMSP0601EF07; LMSP0601DK07; LMSP0601DY07; LMSP0601ED07; LMSP0601BM07": ["C79H141N3O31", "Sphingolipids [SP] with formula: C79H141N3O31"],
        "LMSP0601FF07; LMSP0601BY07; LMSP0601CJ07": ["C79H141N3O32", "Sphingolipids [SP] with formula: C79H141N3O32"],
        "LMSP0601CH02; LMSP0601EE02; LMSP0601DS02; LMSP0601DL02; LMSP0601BD02": ["C79H141N3O35", "Sphingolipids [SP] with formula: C79H141N3O35"],
        "LMSP0601DV02; LMSP0601GL02; LMSP0601GW02; LMSP0601AI02; LMSP0601GS02; LMSP0601CN02; LMSP0601EU02; LMSP0601AB02; LMSP0601GK02": ["C79H141N3O36", "Sphingolipids [SP] with formula: C79H141N3O36"],
        "LMSP0601AF02": ["C79H141N3O37", "Sphingolipids [SP] with formula: C79H141N3O37"],
        "LMSP0601GG08; LMSP0601GE08; LMSP0601DD08; LMSP0601DF08; LMSP0601EC08; LMSP0601EB08": ["C79H142N2O31", "Sphingolipids [SP] with formula: C79H142N2O31"],
        "LMSP0601GF03": ["C79H142N2O35", "Sphingolipids [SP] with formula: C79H142N2O35"],
        "LMSP0601AP05; LMSP0601AH05; LMSP0601DZ05; LMSP0601EF05; LMSP0601DK05; LMSP0601DY05; LMSP0601ED05; LMSP0601AY05; LMSP0601BM05": ["C79H143N3O31", "Sphingolipids [SP] with formula: C79H143N3O31"],
        "LMSP0601FF05; LMSP0601CJ05; LMSP0601BY05": ["C79H143N3O32", "Sphingolipids [SP] with formula: C79H143N3O32"],
        "LMSP0601EB06; LMSP0601DF06; LMSP0601DD06; LMSP0601GG06; LMSP0601GE06; LMSP0601EC06": ["C79H144N2O31", "Sphingolipids [SP] with formula: C79H144N2O31"],
        "LMSP0601CD01; LMSP0601CB01; LMSP0601CC01": ["C80H141N3O39", "Sphingolipids [SP] with formula: C80H141N3O39"],
        "LMSP0601DE02; LMSP0601DI02": ["C80H142N2O39", "Sphingolipids [SP] with formula: C80H142N2O39"],
        "LMSP0601AN03": ["C80H142N4O34", "Sphingolipids [SP] with formula: C80H142N4O34"],
        "LMSP0505CN01; LMSP0504AH01; LMSP0505BM01; LMSP0504AS01": ["C80H143N3O36", "Sphingolipids [SP] with formula: C80H143N3O36"],
        "LMSP0502BI01; LMSP0505AM01; LMSP0502BN01; LMSP0505AH01; LMSP0504AN01; LMSP0505CK01; LMSP0505AV01; LMSP0503AL01; LMSP0504AV01; LMSP0505AS01; LMSP0502AJ01; LMSP0504BD01; LMSP0505DS01; LMSP0502BJ01; LMSP0503AH01; LMSP0505CI01; LMSP0504AM01": ["C80H143N3O37", "Sphingolipids [SP] with formula: C80H143N3O37"],
        "LMSP0502AG01; LMSP0505BL01": ["C80H143N3O38", "Sphingolipids [SP] with formula: C80H143N3O38"],
        "LMSP0505AG07; LMSP0504AI07": ["C80H144N2O31", "Sphingolipids [SP] with formula: C80H144N2O31"],
        "LMSP0502AI07; LMSP0504AE07; LMSP0505CV07; LMSP0505DF07; LMSP0502BM07; LMSP0505DK07; LMSP0503AK07; LMSP0505AE07": ["C80H144N2O32", "Sphingolipids [SP] with formula: C80H144N2O32"],
        "LMSP0505DJ07; LMSP0502BF07; LMSP0502AQ07": ["C80H144N2O33", "Sphingolipids [SP] with formula: C80H144N2O33"],
        "LMSP0504AG02; LMSP0505CY02": ["C80H144N2O36", "Sphingolipids [SP] with formula: C80H144N2O36"],
        "LMSP0505DL02; LMSP0502AK02": ["C80H144N2O37", "Sphingolipids [SP] with formula: C80H144N2O37"],
        "LMSP0502AR02": ["C80H144N2O38", "Sphingolipids [SP] with formula: C80H144N2O38"],
        "LMSP0506AL03; LMSP0502BB03": ["C80H144N4O33", "Sphingolipids [SP] with formula: C80H144N4O33"],
        "LMSP0505AF04; LMSP0504AF04; LMSP0505CG04; LMSP0503AG04; LMSP0505CU04; LMSP0504AK04; LMSP0505DR04; LMSP0502BH04; LMSP0504AR04": ["C80H145N3O32", "Sphingolipids [SP] with formula: C80H145N3O32"],
        "LMSP0505AL04; LMSP0503AP04; LMSP0505BG04; LMSP0504AL04; LMSP0502BG04; LMSP0505CF04; LMSP0503AF04; LMSP0502AF04; LMSP0504BR04; LMSP0503AD04; LMSP0506AM04; LMSP0502BL04; LMSP0502BE04; LMSP0505CB04; LMSP0503AM04; LMSP0506AK04; LMSP0505EJ04; LMSP0505DQ04; LMSP0505EL04": ["C80H145N3O33", "Sphingolipids [SP] with formula: C80H145N3O33"],
        "LMSP0502AN08": ["C80H145NO33", "Sphingolipids [SP] with formula: C80H145NO33"],
        "LMSP0502AW03": ["C80H145NO38", "Sphingolipids [SP] with formula: C80H145NO38"],
        "LMSP0505AG05; LMSP0504AI05": ["C80H146N2O31", "Sphingolipids [SP] with formula: C80H146N2O31"],
        "LMSP0502AI05; LMSP0504AE05; LMSP0505CV05; LMSP0505DF05; LMSP0502BM05; LMSP0505DK05; LMSP0503AK05; LMSP0505AE05": ["C80H146N2O32", "Sphingolipids [SP] with formula: C80H146N2O32"],
        "LMSP0505DJ05; LMSP0502BF05; LMSP0502AQ05": ["C80H146N2O33", "Sphingolipids [SP] with formula: C80H146N2O33"],
        "LMSP0502AN06": ["C80H147NO33", "Sphingolipids [SP] with formula: C80H147NO33"],
        "LMSP0601BK01": ["C81H140N4O38", "Sphingolipids [SP] with formula: C81H140N4O38"],
        "LMSP0601AL02": ["C81H142N4O37", "Sphingolipids [SP] with formula: C81H142N4O37"],
        "LMSP0601BS02; LMSP0601BC02; LMSP0601CO02; LMSP0601FX02; LMSP0601AZ02; LMSP0601CW02; LMSP0601DP02; LMSP0601FD02; LMSP0601FI02": ["C81H144N4O36", "Sphingolipids [SP] with formula: C81H144N4O36"],
        "LMSP0601BZ02": ["C81H144N4O37", "Sphingolipids [SP] with formula: C81H144N4O37"],
        "LMSP0601AY08; LMSP0601AH08; LMSP0601DY08; LMSP0601EF08; LMSP0601DZ08; LMSP0601DK08; LMSP0601ED08; LMSP0601AP08; LMSP0601BM08": ["C81H145N3O31", "Sphingolipids [SP] with formula: C81H145N3O31"],
        "LMSP0601BY08; LMSP0601FF08; LMSP0601CJ08": ["C81H145N3O32", "Sphingolipids [SP] with formula: C81H145N3O32"],
        "LMSP0601CH03; LMSP0601BD03; LMSP0601EE03; LMSP0601DS03; LMSP0601DL03": ["C81H145N3O35", "Sphingolipids [SP] with formula: C81H145N3O35"],
        "LMSP0601DV03; LMSP0601GL03; LMSP0601GS03; LMSP0601GW03; LMSP0601CN03; LMSP0601EU03; LMSP0601AB03; LMSP0601AI03; LMSP0601GK03": ["C81H145N3O36", "Sphingolipids [SP] with formula: C81H145N3O36"],
        "LMSP0601AF03": ["C81H145N3O37", "Sphingolipids [SP] with formula: C81H145N3O37"],
        "LMSP0601GF04": ["C81H146N2O35", "Sphingolipids [SP] with formula: C81H146N2O35"],
        "LMSP0601EF06; LMSP0601AP06; LMSP0601AH06; LMSP0601DY06; LMSP0601DZ06; LMSP0601DK06; LMSP0601ED06; LMSP0601AY06; LMSP0601BM06": ["C81H147N3O31", "Sphingolipids [SP] with formula: C81H147N3O31"],
        "LMSP0601CJ06; LMSP0601BY06; LMSP0601FF06": ["C81H147N3O32", "Sphingolipids [SP] with formula: C81H147N3O32"],
        "LMSP0601CG01": ["C82H144N4O38", "Sphingolipids [SP] with formula: C82H144N4O38"],
        "LMSP0601AS01; LMSP0601BN01; LMSP0601AQ01; LMSP0601BE01; LMSP0601BA01; LMSP0601DU01; LMSP0601EG01; LMSP0601GM01; LMSP0601DT01": ["C82H144N4O39", "Sphingolipids [SP] with formula: C82H144N4O39"],
        "LMSP0601BV01; LMSP0601FH01; LMSP0601CV01": ["C82H144N4O40", "Sphingolipids [SP] with formula: C82H144N4O40"],
        "LMSP0601CQ01; LMSP0601FG01": ["C82H144N4O41", "Sphingolipids [SP] with formula: C82H144N4O41"],
        "LMSP0601CD02; LMSP0601CB02; LMSP0601CC02": ["C82H145N3O39", "Sphingolipids [SP] with formula: C82H145N3O39"],
        "LMSP0601DE03; LMSP0601DI03": ["C82H146N2O39", "Sphingolipids [SP] with formula: C82H146N2O39"],
        "LMSP0601AN04": ["C82H146N4O34", "Sphingolipids [SP] with formula: C82H146N4O34"],
        "LMSP0505BF01; LMSP0505AN01; LMSP0504AO01; LMSP0502AT01; LMSP0506AJ01; LMSP0506AI01": ["C82H146N4O38", "Sphingolipids [SP] with formula: C82H146N4O38"],
        "LMSP0505AF07; LMSP0504AF07; LMSP0505CG07; LMSP0503AG07; LMSP0505CU07; LMSP0504AK07; LMSP0505DR07; LMSP0502BH07; LMSP0504AR07": ["C82H147N3O32", "Sphingolipids [SP] with formula: C82H147N3O32"],
        "LMSP0505AL07; LMSP0505BG07; LMSP0503AP07; LMSP0504AL07; LMSP0502BG07; LMSP0505CF07; LMSP0503AF07; LMSP0502AF07; LMSP0504BR07; LMSP0503AD07; LMSP0502BL07; LMSP0502BE07; LMSP0505CB07; LMSP0503AM07; LMSP0506AK07; LMSP0505DQ07; LMSP0505EJ07; LMSP0506AM07; LMSP0505EL07": ["C82H147N3O33", "Sphingolipids [SP] with formula: C82H147N3O33"],
        "LMSP0505CN02; LMSP0504AH02; LMSP0505BM02; LMSP0504AS02": ["C82H147N3O36", "Sphingolipids [SP] with formula: C82H147N3O36"],
        "LMSP0502BI02; LMSP0505AM02; LMSP0502BN02; LMSP0505AV02; LMSP0505AH02; LMSP0504AV02; LMSP0504AN02; LMSP0505CK02; LMSP0503AL02; LMSP0505AS02; LMSP0502AJ02; LMSP0504BD02; LMSP0505DS02; LMSP0502BJ02; LMSP0503AH02; LMSP0505CI02; LMSP0504AM02": ["C82H147N3O37", "Sphingolipids [SP] with formula: C82H147N3O37"],
        "LMSP0502AG02; LMSP0505BL02": ["C82H147N3O38", "Sphingolipids [SP] with formula: C82H147N3O38"],
        "LMSP0502AY01": ["C82H147NO43", "Sphingolipids [SP] with formula: C82H147NO43"],
        "LMSP0505AG08; LMSP0504AI08": ["C82H148N2O31", "Sphingolipids [SP] with formula: C82H148N2O31"],
        "LMSP0502AI08; LMSP0504AE08; LMSP0505CV08; LMSP0505DF08; LMSP0502BM08; LMSP0505DK08; LMSP0503AK08; LMSP0505AE08": ["C82H148N2O32", "Sphingolipids [SP] with formula: C82H148N2O32"],
        "LMSP0502BF08; LMSP0505DJ08; LMSP0502AQ08": ["C82H148N2O33", "Sphingolipids [SP] with formula: C82H148N2O33"],
        "LMSP0504AG03; LMSP0505CY03": ["C82H148N2O36", "Sphingolipids [SP] with formula: C82H148N2O36"],
        "LMSP0505DL03; LMSP0502AK03": ["C82H148N2O37", "Sphingolipids [SP] with formula: C82H148N2O37"],
        "LMSP0502AR03": ["C82H148N2O38", "Sphingolipids [SP] with formula: C82H148N2O38"],
        "LMSP0506AL04; LMSP0502BB04": ["C82H148N4O33", "Sphingolipids [SP] with formula: C82H148N4O33"],
        "LMSP0505AF05; LMSP0504AF05; LMSP0505CG05; LMSP0503AG05; LMSP0504AK05; LMSP0505CU05; LMSP0505DR05; LMSP0502BH05; LMSP0504AR05": ["C82H149N3O32", "Sphingolipids [SP] with formula: C82H149N3O32"],
        "LMSP0505AL05; LMSP0505BG05; LMSP0503AP05; LMSP0504AL05; LMSP0502BG05; LMSP0505CF05; LMSP0502AF05; LMSP0504BR05; LMSP0502BE05; LMSP0503AD05; LMSP0506AM05; LMSP0502BL05; LMSP0505CB05; LMSP0503AF05; LMSP0503AM05; LMSP0506AK05; LMSP0505EJ05; LMSP0505DQ05; LMSP0505EL05": ["C82H149N3O33", "Sphingolipids [SP] with formula: C82H149N3O33"],
        "LMSP0502AW04": ["C82H149NO38", "Sphingolipids [SP] with formula: C82H149NO38"],
        "LMSP0505AG06; LMSP0504AI06": ["C82H150N2O31", "Sphingolipids [SP] with formula: C82H150N2O31"],
        "LMSP0502AI06; LMSP0504AE06; LMSP0505CV06; LMSP0505DF06; LMSP0502BM06; LMSP0505DK06; LMSP0503AK06; LMSP0505AE06": ["C82H150N2O32", "Sphingolipids [SP] with formula: C82H150N2O32"],
        "LMSP0502BF06; LMSP0505DJ06; LMSP0502AQ06": ["C82H150N2O33", "Sphingolipids [SP] with formula: C82H150N2O33"],
        "LMSP0601BK02": ["C83H144N4O38", "Sphingolipids [SP] with formula: C83H144N4O38"],
        "LMSP0601AL03": ["C83H146N4O37", "Sphingolipids [SP] with formula: C83H146N4O37"],
        "LMSP0601CY01; LMSP0601GH01": ["C83H147N3O40", "Sphingolipids [SP] with formula: C83H147N3O40"],
        "LMSP0601GF07": ["C83H148N2O35", "Sphingolipids [SP] with formula: C83H148N2O35"],
        "LMSP0601BS03; LMSP0601CO03; LMSP0601CW03; LMSP0601DP03; LMSP0601FD03; LMSP0601AZ03; LMSP0601FI03; LMSP0601FX03; LMSP0601BC03": ["C83H148N4O36", "Sphingolipids [SP] with formula: C83H148N4O36"],
        "LMSP0601BZ03": ["C83H148N4O37", "Sphingolipids [SP] with formula: C83H148N4O37"],
        "LMSP0601DL04; LMSP0601CH04; LMSP0601EE04; LMSP0601DS04; LMSP0601BD04": ["C83H149N3O35", "Sphingolipids [SP] with formula: C83H149N3O35"],
        "LMSP0601DV04; LMSP0601GL04; LMSP0601AI04; LMSP0601CN04; LMSP0601EU04; LMSP0601GW04; LMSP0601AB04; LMSP0601GS04; LMSP0601GK04": ["C83H149N3O36", "Sphingolipids [SP] with formula: C83H149N3O36"],
        "LMSP0601AF04": ["C83H149N3O37", "Sphingolipids [SP] with formula: C83H149N3O37"],
        "LMSP0601GF05": ["C83H150N2O35", "Sphingolipids [SP] with formula: C83H150N2O35"],
        "LMSP0601CK01": ["C84H146N4O40", "Sphingolipids [SP] with formula: C84H146N4O40"],
        "LMSP0601AN07": ["C84H148N4O34", "Sphingolipids [SP] with formula: C84H148N4O34"],
        "LMSP0601CG02": ["C84H148N4O38", "Sphingolipids [SP] with formula: C84H148N4O38"],
        "LMSP0601AS02; LMSP0601BN02; LMSP0601DU02; LMSP0601BA02; LMSP0601BE02; LMSP0601EG02; LMSP0601DT02; LMSP0601AQ02; LMSP0601GM02": ["C84H148N4O39", "Sphingolipids [SP] with formula: C84H148N4O39"],
        "LMSP0601BV02; LMSP0601FH02; LMSP0601CV02": ["C84H148N4O40", "Sphingolipids [SP] with formula: C84H148N4O40"],
        "LMSP0601FG02; LMSP0601CQ02": ["C84H148N4O41", "Sphingolipids [SP] with formula: C84H148N4O41"],
        "LMSP0601CD03; LMSP0601CB03; LMSP0601CC03": ["C84H149N3O39", "Sphingolipids [SP] with formula: C84H149N3O39"],
        "LMSP0601DE04; LMSP0601DI04": ["C84H150N2O39", "Sphingolipids [SP] with formula: C84H150N2O39"],
        "LMSP0502AX01": ["C84H150N2O43", "Sphingolipids [SP] with formula: C84H150N2O43"],
        "LMSP0506AL07; LMSP0502BB07": ["C84H150N4O33", "Sphingolipids [SP] with formula: C84H150N4O33"],
        "LMSP0601AN05": ["C84H150N4O34", "Sphingolipids [SP] with formula: C84H150N4O34"],
        "LMSP0505BF02; LMSP0505AN02; LMSP0504AO02; LMSP0502AT02; LMSP0506AJ02; LMSP0506AI02": ["C84H150N4O38", "Sphingolipids [SP] with formula: C84H150N4O38"],
        "LMSP0505CG08; LMSP0505AF08; LMSP0504AF08; LMSP0503AG08; LMSP0504AK08; LMSP0505CU08; LMSP0505DR08; LMSP0502BH08; LMSP0504AR08": ["C84H151N3O32", "Sphingolipids [SP] with formula: C84H151N3O32"],
        "LMSP0505AL08; LMSP0504AL08; LMSP0503AF08; LMSP0502BG08; LMSP0505CF08; LMSP0503AP08; LMSP0505BG08; LMSP0505DQ08; LMSP0502AF08; LMSP0506AM08; LMSP0504BR08; LMSP0503AD08; LMSP0502BE08; LMSP0502BL08; LMSP0505CB08; LMSP0503AM08; LMSP0506AK08; LMSP0505EJ08; LMSP0505EL08": ["C84H151N3O33", "Sphingolipids [SP] with formula: C84H151N3O33"],
        "LMSP0505CN03; LMSP0504AH03; LMSP0505BM03; LMSP0504AS03": ["C84H151N3O36", "Sphingolipids [SP] with formula: C84H151N3O36"],
        "LMSP0502BI03; LMSP0505AM03; LMSP0502BN03; LMSP0505AV03; LMSP0505AH03; LMSP0504AN03; LMSP0505CK03; LMSP0503AL03; LMSP0504AV03; LMSP0505AS03; LMSP0502AJ03; LMSP0504BD03; LMSP0505DS03; LMSP0502BJ03; LMSP0503AH03; LMSP0505CI03; LMSP0504AM03": ["C84H151N3O37", "Sphingolipids [SP] with formula: C84H151N3O37"],
        "LMSP0502AG03; LMSP0505BL03": ["C84H151N3O38", "Sphingolipids [SP] with formula: C84H151N3O38"],
        "LMSP0502AW07": ["C84H151NO38", "Sphingolipids [SP] with formula: C84H151NO38"],
        "LMSP0502AY02": ["C84H151NO43", "Sphingolipids [SP] with formula: C84H151NO43"],
        "LMSP0504AG04; LMSP0505CY04": ["C84H152N2O36", "Sphingolipids [SP] with formula: C84H152N2O36"],
        "LMSP0505DL04; LMSP0502AK04": ["C84H152N2O37", "Sphingolipids [SP] with formula: C84H152N2O37"],
        "LMSP0502AR04": ["C84H152N2O38", "Sphingolipids [SP] with formula: C84H152N2O38"],
        "LMSP0506AL05; LMSP0502BB05": ["C84H152N4O33", "Sphingolipids [SP] with formula: C84H152N4O33"],
        "LMSP0505AF06; LMSP0504AF06; LMSP0505CG06; LMSP0503AG06; LMSP0505CU06; LMSP0504AK06; LMSP0505DR06; LMSP0502BH06; LMSP0504AR06": ["C84H153N3O32", "Sphingolipids [SP] with formula: C84H153N3O32"],
        "LMSP0505AL06; LMSP0504AL06; LMSP0502BG06; LMSP0505CF06; LMSP0503AF06; LMSP0505BG06; LMSP0503AP06; LMSP0502AF06; LMSP0504BR06; LMSP0502BE06; LMSP0506AM06; LMSP0502BL06; LMSP0503AD06; LMSP0505CB06; LMSP0503AM06; LMSP0506AK06; LMSP0505EJ06; LMSP0505DQ06; LMSP0505EL06": ["C84H153N3O33", "Sphingolipids [SP] with formula: C84H153N3O33"],
        "LMSP0502AW05": ["C84H153NO38", "Sphingolipids [SP] with formula: C84H153NO38"],
        "LMSP0601BK03": ["C85H148N4O38", "Sphingolipids [SP] with formula: C85H148N4O38"],
        "LMSP0601AL04": ["C85H150N4O37", "Sphingolipids [SP] with formula: C85H150N4O37"],
        "LMSP0601BT01; LMSP0601CZ01; LMSP0601DM01": ["C85H150N4O40", "Sphingolipids [SP] with formula: C85H150N4O40"],
        "LMSP0601EI01; LMSP0601FN01; LMSP0601FE01; LMSP0601BU01; LMSP0601GV01; LMSP0601BB01; LMSP0601EH01; LMSP0601GQ01; LMSP0601EL01; LMSP0601GR01": ["C85H150N4O41", "Sphingolipids [SP] with formula: C85H150N4O41"],
        "LMSP0601CR01; LMSP0601EO01; LMSP0601BP01": ["C85H150N4O42", "Sphingolipids [SP] with formula: C85H150N4O42"],
        "LMSP0601DS07; LMSP0601CH07; LMSP0601EE07; LMSP0601DL07; LMSP0601BD07": ["C85H151N3O35", "Sphingolipids [SP] with formula: C85H151N3O35"],
        "LMSP0601DV07; LMSP0601GL07; LMSP0601GS07; LMSP0601GK07; LMSP0601GW07; LMSP0601CN07; LMSP0601AI07; LMSP0601EU07; LMSP0601AB07": ["C85H151N3O36", "Sphingolipids [SP] with formula: C85H151N3O36"],
        "LMSP0601AF07": ["C85H151N3O37", "Sphingolipids [SP] with formula: C85H151N3O37"],
        "LMSP0601CY02; LMSP0601GH02": ["C85H151N3O40", "Sphingolipids [SP] with formula: C85H151N3O40"],
        "LMSP0601GF08": ["C85H152N2O35", "Sphingolipids [SP] with formula: C85H152N2O35"],
        "LMSP0601BS04; LMSP0601CO04; LMSP0601CW04; LMSP0601FI04; LMSP0601FX04; LMSP0601DP04; LMSP0601AZ04; LMSP0601FD04; LMSP0601BC04": ["C85H152N4O36", "Sphingolipids [SP] with formula: C85H152N4O36"],
        "LMSP0601BZ04": ["C85H152N4O37", "Sphingolipids [SP] with formula: C85H152N4O37"],
        "LMSP0601CH05; LMSP0601DS05; LMSP0601EE05; LMSP0601DL05; LMSP0601BD05": ["C85H153N3O35", "Sphingolipids [SP] with formula: C85H153N3O35"],
        "LMSP0601CN05; LMSP0601GL05; LMSP0601GW05; LMSP0601AI05; LMSP0601EU05; LMSP0601DV05; LMSP0601AB05; LMSP0601GS05; LMSP0601GK05": ["C85H153N3O36", "Sphingolipids [SP] with formula: C85H153N3O36"],
        "LMSP0601AF05": ["C85H153N3O37", "Sphingolipids [SP] with formula: C85H153N3O37"],
        "LMSP0601GF06": ["C85H154N2O35", "Sphingolipids [SP] with formula: C85H154N2O35"],
        "LMSP0601CK02": ["C86H150N4O40", "Sphingolipids [SP] with formula: C86H150N4O40"],
        "LMSP0601DE07; LMSP0601DI07": ["C86H152N2O39", "Sphingolipids [SP] with formula: C86H152N2O39"],
        "LMSP0601AN08": ["C86H152N4O34", "Sphingolipids [SP] with formula: C86H152N4O34"],
        "LMSP0601CG03": ["C86H152N4O38", "Sphingolipids [SP] with formula: C86H152N4O38"],
        "LMSP0601AS03; LMSP0601BN03; LMSP0601BE03; LMSP0601AQ03; LMSP0601DU03; LMSP0601EG03; LMSP0601GM03; LMSP0601DT03; LMSP0601BA03": ["C86H152N4O39", "Sphingolipids [SP] with formula: C86H152N4O39"],
        "LMSP0601BV03; LMSP0601FH03; LMSP0601CV03": ["C86H152N4O40", "Sphingolipids [SP] with formula: C86H152N4O40"],
        "LMSP0601FG03; LMSP0601CQ03": ["C86H152N4O41", "Sphingolipids [SP] with formula: C86H152N4O41"],
        "LMSP0601CD04; LMSP0601CB04; LMSP0601CC04": ["C86H153N3O39", "Sphingolipids [SP] with formula: C86H153N3O39"],
        "LMSP0504AW01; LMSP0504BC01; LMSP0504AT01; LMSP0505AI01; LMSP0505CJ01; LMSP0504BT01; LMSP0505AZ01; LMSP0505AU01": ["C86H153N3O41", "Sphingolipids [SP] with formula: C86H153N3O41"],
        "LMSP0505AO01; LMSP0502AH01": ["C86H153N3O42", "Sphingolipids [SP] with formula: C86H153N3O42"],
        "LMSP0504AG07; LMSP0505CY07": ["C86H154N2O36", "Sphingolipids [SP] with formula: C86H154N2O36"],
        "LMSP0505DL07; LMSP0502AK07": ["C86H154N2O37", "Sphingolipids [SP] with formula: C86H154N2O37"],
        "LMSP0502AR07": ["C86H154N2O38", "Sphingolipids [SP] with formula: C86H154N2O38"],
        "LMSP0601DE05; LMSP0601DI05": ["C86H154N2O39", "Sphingolipids [SP] with formula: C86H154N2O39"],
        "LMSP0502AX02": ["C86H154N2O43", "Sphingolipids [SP] with formula: C86H154N2O43"],
        "LMSP0506AL08; LMSP0502BB08": ["C86H154N4O33", "Sphingolipids [SP] with formula: C86H154N4O33"],
        "LMSP0601AN06": ["C86H154N4O34", "Sphingolipids [SP] with formula: C86H154N4O34"],
        "LMSP0505BF03; LMSP0505AN03; LMSP0504AO03; LMSP0502AT03; LMSP0506AJ03; LMSP0506AI03": ["C86H154N4O38", "Sphingolipids [SP] with formula: C86H154N4O38"],
        "LMSP0505CN04; LMSP0504AH04; LMSP0505BM04; LMSP0504AS04": ["C86H155N3O36", "Sphingolipids [SP] with formula: C86H155N3O36"],
        "LMSP0502BI04; LMSP0505AM04; LMSP0502BN04; LMSP0505AV04; LMSP0505AH04; LMSP0504AN04; LMSP0504AV04; LMSP0505CK04; LMSP0503AL04; LMSP0505AS04; LMSP0502AJ04; LMSP0504BD04; LMSP0505DS04; LMSP0502BJ04; LMSP0503AH04; LMSP0505CI04; LMSP0504AM04": ["C86H155N3O37", "Sphingolipids [SP] with formula: C86H155N3O37"],
        "LMSP0502AG04; LMSP0505BL04": ["C86H155N3O38", "Sphingolipids [SP] with formula: C86H155N3O38"],
        "LMSP0502AW08": ["C86H155NO38", "Sphingolipids [SP] with formula: C86H155NO38"],
        "LMSP0502AY03": ["C86H155NO43", "Sphingolipids [SP] with formula: C86H155NO43"],
        "LMSP0504AG05; LMSP0505CY05": ["C86H156N2O36", "Sphingolipids [SP] with formula: C86H156N2O36"],
        "LMSP0505DL05; LMSP0502AK05": ["C86H156N2O37", "Sphingolipids [SP] with formula: C86H156N2O37"],
        "LMSP0502AR05": ["C86H156N2O38", "Sphingolipids [SP] with formula: C86H156N2O38"],
        "LMSP0506AL06; LMSP0502BB06": ["C86H156N4O33", "Sphingolipids [SP] with formula: C86H156N4O33"],
        "LMSP0502AW06": ["C86H157NO38", "Sphingolipids [SP] with formula: C86H157NO38"],
        "LMSP0601AO01": ["C87H151N5O42", "Sphingolipids [SP] with formula: C87H151N5O42"],
        "LMSP0601AL07": ["C87H152N4O37", "Sphingolipids [SP] with formula: C87H152N4O37"],
        "LMSP0601BK04": ["C87H152N4O38", "Sphingolipids [SP] with formula: C87H152N4O38"],
        "LMSP0601DQ01; LMSP0601CX01; LMSP0601CP01": ["C87H153N5O41", "Sphingolipids [SP] with formula: C87H153N5O41"],
        "LMSP0601CO07; LMSP0601BC07; LMSP0601FI07; LMSP0601DP07; LMSP0601CW07; LMSP0601AZ07; LMSP0601FD07; LMSP0601BS07; LMSP0601FX07": ["C87H154N4O36", "Sphingolipids [SP] with formula: C87H154N4O36"],
        "LMSP0601BZ07; LMSP0601AL05": ["C87H154N4O37", "Sphingolipids [SP] with formula: C87H154N4O37"],
        "LMSP0601BT02; LMSP0601CZ02; LMSP0601DM02": ["C87H154N4O40", "Sphingolipids [SP] with formula: C87H154N4O40"],
        "LMSP0601EI02; LMSP0601FN02; LMSP0601BB02; LMSP0601BU02; LMSP0601GV02; LMSP0601FE02; LMSP0601EH02; LMSP0601GQ02; LMSP0601EL02; LMSP0601GR02": ["C87H154N4O41", "Sphingolipids [SP] with formula: C87H154N4O41"],
        "LMSP0601CR02; LMSP0601EO02; LMSP0601BP02": ["C87H154N4O42", "Sphingolipids [SP] with formula: C87H154N4O42"],
        "LMSP0601CH08; LMSP0601EE08; LMSP0601DS08; LMSP0601DL08; LMSP0601BD08": ["C87H155N3O35", "Sphingolipids [SP] with formula: C87H155N3O35"],
        "LMSP0601DV08; LMSP0601GW08; LMSP0601CN08; LMSP0601EU08; LMSP0601AB08; LMSP0601GS08; LMSP0601AI08; LMSP0601GL08; LMSP0601GK08": ["C87H155N3O36", "Sphingolipids [SP] with formula: C87H155N3O36"],
        "LMSP0601AF08": ["C87H155N3O37", "Sphingolipids [SP] with formula: C87H155N3O37"],
        "LMSP0601CY03; LMSP0601GH03": ["C87H155N3O40", "Sphingolipids [SP] with formula: C87H155N3O40"],
        "LMSP0601CO05; LMSP0601BC05; LMSP0601FI05; LMSP0601AZ05; LMSP0601CW05; LMSP0601DP05; LMSP0601FD05; LMSP0601BS05; LMSP0601FX05": ["C87H156N4O36", "Sphingolipids [SP] with formula: C87H156N4O36"],
        "LMSP0601BZ05": ["C87H156N4O37", "Sphingolipids [SP] with formula: C87H156N4O37"],
        "LMSP0601DS06; LMSP0601DL06; LMSP0601CH06; LMSP0601EE06; LMSP0601BD06": ["C87H157N3O35", "Sphingolipids [SP] with formula: C87H157N3O35"],
        "LMSP0601DV06; LMSP0601GW06; LMSP0601GK06; LMSP0601AI06; LMSP0601CN06; LMSP0601GS06; LMSP0601AB06; LMSP0601EU06; LMSP0601GL06": ["C87H157N3O36", "Sphingolipids [SP] with formula: C87H157N3O36"],
        "LMSP0601AF06": ["C87H157N3O37", "Sphingolipids [SP] with formula: C87H157N3O37"],
        "LMSP0601CK03": ["C88H154N4O40", "Sphingolipids [SP] with formula: C88H154N4O40"],
        "LMSP0601BI01; LMSP0601EA01": ["C88H154N4O43", "Sphingolipids [SP] with formula: C88H154N4O43"],
        "LMSP0601AE01; LMSP0601BH01; LMSP0601AD01; LMSP0601AC01": ["C88H154N4O44", "Sphingolipids [SP] with formula: C88H154N4O44"],
        "LMSP0601AG01": ["C88H154N4O46", "Sphingolipids [SP] with formula: C88H154N4O46"],
        "LMSP0601CD07; LMSP0601CC07; LMSP0601CB07": ["C88H155N3O39", "Sphingolipids [SP] with formula: C88H155N3O39"],
        "LMSP0601DE08; LMSP0601DI08": ["C88H156N2O39", "Sphingolipids [SP] with formula: C88H156N2O39"],
        "LMSP0601CG04": ["C88H156N4O38", "Sphingolipids [SP] with formula: C88H156N4O38"],
        "LMSP0601AS04; LMSP0601EG04; LMSP0601BN04; LMSP0601BE04; LMSP0601AQ04; LMSP0601DT04; LMSP0601DU04; LMSP0601GM04; LMSP0601BA04": ["C88H156N4O39", "Sphingolipids [SP] with formula: C88H156N4O39"],
        "LMSP0601FH04; LMSP0601BV04; LMSP0601CV04": ["C88H156N4O40", "Sphingolipids [SP] with formula: C88H156N4O40"],
        "LMSP0601FG04; LMSP0601CQ04": ["C88H156N4O41", "Sphingolipids [SP] with formula: C88H156N4O41"],
        "LMSP0502AV01; LMSP0505AQ01; LMSP0504AP01; LMSP0505BH01; LMSP0504AX01": ["C88H156N4O42", "Sphingolipids [SP] with formula: C88H156N4O42"],
        "LMSP0505AP01; LMSP0505BE01": ["C88H156N4O43", "Sphingolipids [SP] with formula: C88H156N4O43"],
        "LMSP0504AH07; LMSP0505BM07; LMSP0504AS07; LMSP0505CN07": ["C88H157N3O36", "Sphingolipids [SP] with formula: C88H157N3O36"],
        "LMSP0502BI07; LMSP0505AM07; LMSP0502BN07; LMSP0505AV07; LMSP0505AH07; LMSP0504AV07; LMSP0504AN07; LMSP0505CK07; LMSP0503AL07; LMSP0505AS07; LMSP0502AJ07; LMSP0504BD07; LMSP0505DS07; LMSP0502BJ07; LMSP0503AH07; LMSP0505CI07; LMSP0504AM07": ["C88H157N3O37", "Sphingolipids [SP] with formula: C88H157N3O37"],
        "LMSP0502AG07; LMSP0505BL07": ["C88H157N3O38", "Sphingolipids [SP] with formula: C88H157N3O38"],
        "LMSP0601CB05; LMSP0601CD05; LMSP0601CC05": ["C88H157N3O39", "Sphingolipids [SP] with formula: C88H157N3O39"],
        "LMSP0504AW02; LMSP0504BC02; LMSP0504AT02; LMSP0505CJ02; LMSP0504BT02; LMSP0505AZ02; LMSP0505AI02; LMSP0505AU02": ["C88H157N3O41", "Sphingolipids [SP] with formula: C88H157N3O41"],
        "LMSP0505AO02; LMSP0502AH02": ["C88H157N3O42", "Sphingolipids [SP] with formula: C88H157N3O42"],
        "LMSP0504AG08; LMSP0505CY08": ["C88H158N2O36", "Sphingolipids [SP] with formula: C88H158N2O36"],
        "LMSP0505DL08; LMSP0502AK08": ["C88H158N2O37", "Sphingolipids [SP] with formula: C88H158N2O37"],
        "LMSP0502AR08": ["C88H158N2O38", "Sphingolipids [SP] with formula: C88H158N2O38"],
        "LMSP0601DE06; LMSP0601DI06": ["C88H158N2O39", "Sphingolipids [SP] with formula: C88H158N2O39"],
        "LMSP0502AX03": ["C88H158N2O43", "Sphingolipids [SP] with formula: C88H158N2O43"],
        "LMSP0505BF04; LMSP0505AN04; LMSP0504AO04; LMSP0502AT04; LMSP0506AJ04; LMSP0506AI04": ["C88H158N4O38", "Sphingolipids [SP] with formula: C88H158N4O38"],
        "LMSP0505CN05; LMSP0504AH05; LMSP0505BM05; LMSP0504AS05": ["C88H159N3O36", "Sphingolipids [SP] with formula: C88H159N3O36"],
        "LMSP0502BI05; LMSP0505AM05; LMSP0502BN05; LMSP0505AV05; LMSP0505AH05; LMSP0504AV05; LMSP0504AN05; LMSP0503AL05; LMSP0505AS05; LMSP0502AJ05; LMSP0504BD05; LMSP0505DS05; LMSP0502BJ05; LMSP0505CK05; LMSP0503AH05; LMSP0505CI05; LMSP0504AM05": ["C88H159N3O37", "Sphingolipids [SP] with formula: C88H159N3O37"],
        "LMSP0502AG05; LMSP0505BL05": ["C88H159N3O38", "Sphingolipids [SP] with formula: C88H159N3O38"],
        "LMSP0502AY04": ["C88H159NO43", "Sphingolipids [SP] with formula: C88H159NO43"],
        "LMSP0504AG06; LMSP0505CY06": ["C88H160N2O36", "Sphingolipids [SP] with formula: C88H160N2O36"],
        "LMSP0505DL06; LMSP0502AK06": ["C88H160N2O37", "Sphingolipids [SP] with formula: C88H160N2O37"],
        "LMSP0502AR06": ["C88H160N2O38", "Sphingolipids [SP] with formula: C88H160N2O38"],
        "LMSP0601BK07": ["C89H154N4O38", "Sphingolipids [SP] with formula: C89H154N4O38"],
        "LMSP0601AO02": ["C89H155N5O42", "Sphingolipids [SP] with formula: C89H155N5O42"],
        "LMSP0601AL08": ["C89H156N4O37", "Sphingolipids [SP] with formula: C89H156N4O37"],
        "LMSP0601BK05": ["C89H156N4O38", "Sphingolipids [SP] with formula: C89H156N4O38"],
        "LMSP0601CP02; LMSP0601CX02; LMSP0601DQ02": ["C89H157N5O41", "Sphingolipids [SP] with formula: C89H157N5O41"],
        "LMSP0601AZ08; LMSP0601BC08; LMSP0601FI08; LMSP0601DP08; LMSP0601CO08; LMSP0601FD08; LMSP0601CW08; LMSP0601BS08; LMSP0601FX08": ["C89H158N4O36", "Sphingolipids [SP] with formula: C89H158N4O36"],
        "LMSP0601BZ08; LMSP0601AL06": ["C89H158N4O37", "Sphingolipids [SP] with formula: C89H158N4O37"],
        "LMSP0601BT03; LMSP0601CZ03; LMSP0601DM03": ["C89H158N4O40", "Sphingolipids [SP] with formula: C89H158N4O40"],
        "LMSP0601EI03; LMSP0601EH03; LMSP0601GV03; LMSP0601FN03; LMSP0601FE03; LMSP0601BB03; LMSP0601BU03; LMSP0601GQ03; LMSP0601EL03; LMSP0601GR03": ["C89H158N4O41", "Sphingolipids [SP] with formula: C89H158N4O41"],
        "LMSP0601EO03; LMSP0601BP03; LMSP0601CR03": ["C89H158N4O42", "Sphingolipids [SP] with formula: C89H158N4O42"],
        "LMSP0601CY04; LMSP0601GH04": ["C89H159N3O40", "Sphingolipids [SP] with formula: C89H159N3O40"],
        "LMSP0601CO06; LMSP0601BC06; LMSP0601CW06; LMSP0601FI06; LMSP0601FD06; LMSP0601FX06; LMSP0601DP06; LMSP0601AZ06; LMSP0601BS06": ["C89H160N4O36", "Sphingolipids [SP] with formula: C89H160N4O36"],
        "LMSP0601BZ06": ["C89H160N4O37", "Sphingolipids [SP] with formula: C89H160N4O37"],
        "LMSP0601BG01": ["C90H157N5O44", "Sphingolipids [SP] with formula: C90H157N5O44"],
        "LMSP0601BX01; LMSP0601CA01": ["C90H157N5O45", "Sphingolipids [SP] with formula: C90H157N5O45"],
        "LMSP0601CG07": ["C90H158N4O38", "Sphingolipids [SP] with formula: C90H158N4O38"],
        "LMSP0601AS07; LMSP0601AQ07; LMSP0601DU07; LMSP0601EG07; LMSP0601DT07; LMSP0601GM07; LMSP0601BE07; LMSP0601BA07; LMSP0601BN07": ["C90H158N4O39", "Sphingolipids [SP] with formula: C90H158N4O39"],
        "LMSP0601BV07; LMSP0601CK04; LMSP0601FH07; LMSP0601CV07": ["C90H158N4O40", "Sphingolipids [SP] with formula: C90H158N4O40"],
        "LMSP0601CQ07; LMSP0601FG07": ["C90H158N4O41", "Sphingolipids [SP] with formula: C90H158N4O41"],
        "LMSP0601EA02; LMSP0601BI02": ["C90H158N4O43", "Sphingolipids [SP] with formula: C90H158N4O43"],
        "LMSP0601BH02; LMSP0601AC02; LMSP0601AD02; LMSP0601AE02": ["C90H158N4O44", "Sphingolipids [SP] with formula: C90H158N4O44"],
        "LMSP0601AG02": ["C90H158N4O46", "Sphingolipids [SP] with formula: C90H158N4O46"],
        "LMSP0601CD08; LMSP0601CB08; LMSP0601CC08": ["C90H159N3O39", "Sphingolipids [SP] with formula: C90H159N3O39"],
        "LMSP0504BH01; LMSP0506AH01": ["C90H159N5O43", "Sphingolipids [SP] with formula: C90H159N5O43"],
        "LMSP0502AZ01": ["C90H160N2O48", "Sphingolipids [SP] with formula: C90H160N2O48"],
        "LMSP0505BF07; LMSP0504AO07; LMSP0601CG05; LMSP0502AT07; LMSP0506AJ07; LMSP0506AI07; LMSP0505AN07": ["C90H160N4O38", "Sphingolipids [SP] with formula: C90H160N4O38"],
        "LMSP0601AS05; LMSP0601BE05; LMSP0601GM05; LMSP0601AQ05; LMSP0601DU05; LMSP0601EG05; LMSP0601BN05; LMSP0601DT05; LMSP0601BA05": ["C90H160N4O39", "Sphingolipids [SP] with formula: C90H160N4O39"],
        "LMSP0601CV05; LMSP0601BV05; LMSP0601FH05": ["C90H160N4O40", "Sphingolipids [SP] with formula: C90H160N4O40"],
        "LMSP0601FG05; LMSP0601CQ05": ["C90H160N4O41", "Sphingolipids [SP] with formula: C90H160N4O41"],
        "LMSP0502AV02; LMSP0505AQ02; LMSP0504AP02; LMSP0505BH02; LMSP0504AX02": ["C90H160N4O42", "Sphingolipids [SP] with formula: C90H160N4O42"],
        "LMSP0505AP02; LMSP0505BE02": ["C90H160N4O43", "Sphingolipids [SP] with formula: C90H160N4O43"],
        "LMSP0504AH08; LMSP0505BM08; LMSP0504AS08; LMSP0505CN08": ["C90H161N3O36", "Sphingolipids [SP] with formula: C90H161N3O36"],
        "LMSP0502BI08; LMSP0505AM08; LMSP0502BN08; LMSP0505AV08; LMSP0504AV08; LMSP0505AH08; LMSP0504AN08; LMSP0503AL08; LMSP0505AS08; LMSP0502AJ08; LMSP0504BD08; LMSP0505DS08; LMSP0505CK08; LMSP0502BJ08; LMSP0503AH08; LMSP0505CI08; LMSP0504AM08": ["C90H161N3O37", "Sphingolipids [SP] with formula: C90H161N3O37"],
        "LMSP0502AG08; LMSP0505BL08": ["C90H161N3O38", "Sphingolipids [SP] with formula: C90H161N3O38"],
        "LMSP0601CD06; LMSP0601CB06; LMSP0601CC06": ["C90H161N3O39", "Sphingolipids [SP] with formula: C90H161N3O39"],
        "LMSP0504AW03; LMSP0504BC03; LMSP0504AT03; LMSP0505AI03; LMSP0505CJ03; LMSP0504BT03; LMSP0505AZ03; LMSP0505AU03": ["C90H161N3O41", "Sphingolipids [SP] with formula: C90H161N3O41"],
        "LMSP0502AH03; LMSP0505AO03": ["C90H161N3O42", "Sphingolipids [SP] with formula: C90H161N3O42"],
        "LMSP0502AY07": ["C90H161NO43", "Sphingolipids [SP] with formula: C90H161NO43"],
        "LMSP0502AX04": ["C90H162N2O43", "Sphingolipids [SP] with formula: C90H162N2O43"],
        "LMSP0505BF05; LMSP0505AN05; LMSP0504AO05; LMSP0502AT05; LMSP0506AJ05; LMSP0506AI05": ["C90H162N4O38", "Sphingolipids [SP] with formula: C90H162N4O38"],
        "LMSP0505CN06; LMSP0504AH06; LMSP0505BM06; LMSP0504AS06": ["C90H163N3O36", "Sphingolipids [SP] with formula: C90H163N3O36"],
        "LMSP0502BI06; LMSP0505AM06; LMSP0502BN06; LMSP0505AV06; LMSP0505AH06; LMSP0504AV06; LMSP0504AN06; LMSP0505CK06; LMSP0503AL06; LMSP0505AS06; LMSP0502AJ06; LMSP0504BD06; LMSP0505DS06; LMSP0502BJ06; LMSP0503AH06; LMSP0505CI06; LMSP0504AM06": ["C90H163N3O37", "Sphingolipids [SP] with formula: C90H163N3O37"],
        "LMSP0502AG06; LMSP0505BL06": ["C90H163N3O38", "Sphingolipids [SP] with formula: C90H163N3O38"],
        "LMSP0502AY05": ["C90H163NO43", "Sphingolipids [SP] with formula: C90H163NO43"],
        "LMSP0601BK08": ["C91H158N4O38", "Sphingolipids [SP] with formula: C91H158N4O38"],
        "LMSP0601AO03": ["C91H159N5O42", "Sphingolipids [SP] with formula: C91H159N5O42"],
        "LMSP0601BK06": ["C91H160N4O38", "Sphingolipids [SP] with formula: C91H160N4O38"],
        "LMSP0601DX01": ["C91H160N4O44", "Sphingolipids [SP] with formula: C91H160N4O44"],
        "LMSP0601EX01; LMSP0601EM01; LMSP0601GI01; LMSP0601FJ01; LMSP0601DN01; LMSP0601BR01; LMSP0601FM01; LMSP0601EJ01": ["C91H160N4O45", "Sphingolipids [SP] with formula: C91H160N4O45"],
        "LMSP0601CY07; LMSP0601GH07": ["C91H161N3O40", "Sphingolipids [SP] with formula: C91H161N3O40"],
        "LMSP0601CP03; LMSP0601CX03; LMSP0601DQ03": ["C91H161N5O41", "Sphingolipids [SP] with formula: C91H161N5O41"],
        "LMSP0601BT04; LMSP0601CZ04; LMSP0601DM04": ["C91H162N4O40", "Sphingolipids [SP] with formula: C91H162N4O40"],
        "LMSP0601EH04; LMSP0601FN04; LMSP0601BU04; LMSP0601GV04; LMSP0601EI04; LMSP0601FE04; LMSP0601BB04; LMSP0601GQ04; LMSP0601EL04; LMSP0601GR04": ["C91H162N4O41", "Sphingolipids [SP] with formula: C91H162N4O41"],
        "LMSP0601CR04; LMSP0601EO04; LMSP0601BP04": ["C91H162N4O42", "Sphingolipids [SP] with formula: C91H162N4O42"],
        "LMSP0601CY05; LMSP0601GH05": ["C91H163N3O40", "Sphingolipids [SP] with formula: C91H163N3O40"],
        "LMSP0601CK07": ["C92H160N4O40", "Sphingolipids [SP] with formula: C92H160N4O40"],
        "LMSP0601BG02": ["C92H161N5O44", "Sphingolipids [SP] with formula: C92H161N5O44"],
        "LMSP0601BX02; LMSP0601CA02": ["C92H161N5O45", "Sphingolipids [SP] with formula: C92H161N5O45"],
        "LMSP0601CG08": ["C92H162N4O38", "Sphingolipids [SP] with formula: C92H162N4O38"],
        "LMSP0601AS08; LMSP0601DU08; LMSP0601BE08; LMSP0601BA08; LMSP0601AQ08; LMSP0601EG08; LMSP0601GM08; LMSP0601DT08; LMSP0601BN08": ["C92H162N4O39", "Sphingolipids [SP] with formula: C92H162N4O39"],
        "LMSP0601CV08; LMSP0601BV08; LMSP0601CK05; LMSP0601FH08": ["C92H162N4O40", "Sphingolipids [SP] with formula: C92H162N4O40"],
        "LMSP0601CQ08; LMSP0601FG08": ["C92H162N4O41", "Sphingolipids [SP] with formula: C92H162N4O41"],
        "LMSP0601BI03; LMSP0601EA03": ["C92H162N4O43", "Sphingolipids [SP] with formula: C92H162N4O43"],
        "LMSP0601AD03; LMSP0601AC03; LMSP0601AE03; LMSP0601BH03": ["C92H162N4O44", "Sphingolipids [SP] with formula: C92H162N4O44"],
        "LMSP0601AG03": ["C92H162N4O46", "Sphingolipids [SP] with formula: C92H162N4O46"],
        "LMSP0504AU01; LMSP0505BA01": ["C92H163N3O45", "Sphingolipids [SP] with formula: C92H163N3O45"],
        "LMSP0504BH02; LMSP0506AH02": ["C92H163N5O43", "Sphingolipids [SP] with formula: C92H163N5O43"],
        "LMSP0502AX07": ["C92H164N2O43", "Sphingolipids [SP] with formula: C92H164N2O43"],
        "LMSP0502AZ02": ["C92H164N2O48", "Sphingolipids [SP] with formula: C92H164N2O48"],
        "LMSP0505BF08; LMSP0505AN08; LMSP0601CG06; LMSP0502AT08; LMSP0506AI08; LMSP0506AJ08; LMSP0504AO08": ["C92H164N4O38", "Sphingolipids [SP] with formula: C92H164N4O38"],
        "LMSP0601BN06; LMSP0601AS06; LMSP0601DU06; LMSP0601BE06; LMSP0601DT06; LMSP0601BA06; LMSP0601AQ06; LMSP0601EG06; LMSP0601GM06": ["C92H164N4O39", "Sphingolipids [SP] with formula: C92H164N4O39"],
        "LMSP0601BV06; LMSP0601FH06; LMSP0601CV06": ["C92H164N4O40", "Sphingolipids [SP] with formula: C92H164N4O40"],
        "LMSP0601FG06; LMSP0601CQ06": ["C92H164N4O41", "Sphingolipids [SP] with formula: C92H164N4O41"],
        "LMSP0502AV03; LMSP0505AQ03; LMSP0504AP03; LMSP0505BH03; LMSP0504AX03": ["C92H164N4O42", "Sphingolipids [SP] with formula: C92H164N4O42"],
        "LMSP0505AP03; LMSP0505BE03": ["C92H164N4O43", "Sphingolipids [SP] with formula: C92H164N4O43"],
        "LMSP0504AT04; LMSP0504AW04; LMSP0504BC04; LMSP0505AI04; LMSP0505CJ04; LMSP0504BT04; LMSP0505AZ04; LMSP0505AU04": ["C92H165N3O41", "Sphingolipids [SP] with formula: C92H165N3O41"],
        "LMSP0505AO04; LMSP0502AH04": ["C92H165N3O42", "Sphingolipids [SP] with formula: C92H165N3O42"],
        "LMSP0502AY08": ["C92H165NO43", "Sphingolipids [SP] with formula: C92H165NO43"],
        "LMSP0502AX05": ["C92H166N2O43", "Sphingolipids [SP] with formula: C92H166N2O43"],
        "LMSP0505BF06; LMSP0502AT06; LMSP0506AJ06; LMSP0506AI06; LMSP0505AN06; LMSP0504AO06": ["C92H166N4O38", "Sphingolipids [SP] with formula: C92H166N4O38"],
        "LMSP0502AY06": ["C92H167NO43", "Sphingolipids [SP] with formula: C92H167NO43"],
        "LMSP0601AR01; LMSP0601AW01; LMSP0601ET01; LMSP0601BF01; LMSP0601CS01; LMSP0601AT01; LMSP0601CT01": ["C93H161N5O47", "Sphingolipids [SP] with formula: C93H161N5O47"],
        "LMSP0601BW01; LMSP0601CF01": ["C93H161N5O48", "Sphingolipids [SP] with formula: C93H161N5O48"],
        "LMSP0601AO04": ["C93H163N5O42", "Sphingolipids [SP] with formula: C93H163N5O42"],
        "LMSP0601EY01; LMSP0601DR01; LMSP0601GX01; LMSP0601FO01; LMSP0601GP01": ["C93H163N5O46", "Sphingolipids [SP] with formula: C93H163N5O46"],
        "LMSP0601EP01": ["C93H163N5O47", "Sphingolipids [SP] with formula: C93H163N5O47"],
        "LMSP0601BT07; LMSP0601CZ07; LMSP0601DM07": ["C93H164N4O40", "Sphingolipids [SP] with formula: C93H164N4O40"],
        "LMSP0601EI07; LMSP0601EH07; LMSP0601FN07; LMSP0601FE07; LMSP0601BU07; LMSP0601GV07; LMSP0601BB07; LMSP0601GQ07; LMSP0601EL07; LMSP0601GR07": ["C93H164N4O41", "Sphingolipids [SP] with formula: C93H164N4O41"],
        "LMSP0601CR07; LMSP0601BP07; LMSP0601EO07": ["C93H164N4O42", "Sphingolipids [SP] with formula: C93H164N4O42"],
        "LMSP0601DX02": ["C93H164N4O44", "Sphingolipids [SP] with formula: C93H164N4O44"],
        "LMSP0601EX02; LMSP0601GI02; LMSP0601FJ02; LMSP0601DN02; LMSP0601EM02; LMSP0601BR02; LMSP0601EJ02; LMSP0601FM02": ["C93H164N4O45", "Sphingolipids [SP] with formula: C93H164N4O45"],
        "LMSP0601CY08; LMSP0601GH08": ["C93H165N3O40", "Sphingolipids [SP] with formula: C93H165N3O40"],
        "LMSP0601CP04; LMSP0601CX04; LMSP0601DQ04": ["C93H165N5O41", "Sphingolipids [SP] with formula: C93H165N5O41"],
        "LMSP0601BT05; LMSP0601CZ05; LMSP0601DM05": ["C93H166N4O40", "Sphingolipids [SP] with formula: C93H166N4O40"],
        "LMSP0601EI05; LMSP0601EH05; LMSP0601FE05; LMSP0601FN05; LMSP0601BU05; LMSP0601GV05; LMSP0601BB05; LMSP0601GQ05; LMSP0601EL05; LMSP0601GR05": ["C93H166N4O41", "Sphingolipids [SP] with formula: C93H166N4O41"],
        "LMSP0601CR05; LMSP0601BP05; LMSP0601EO05": ["C93H166N4O42", "Sphingolipids [SP] with formula: C93H166N4O42"],
        "LMSP0601CY06; LMSP0601GH06": ["C93H167N3O40", "Sphingolipids [SP] with formula: C93H167N3O40"],
        "LMSP0601CK08": ["C94H164N4O40", "Sphingolipids [SP] with formula: C94H164N4O40"],
        "LMSP0601CM01": ["C94H164N4O48", "Sphingolipids [SP] with formula: C94H164N4O48"],
        "LMSP0601CL01": ["C94H164N4O49", "Sphingolipids [SP] with formula: C94H164N4O49"],
        "LMSP0601BG03": ["C94H165N5O44", "Sphingolipids [SP] with formula: C94H165N5O44"],
        "LMSP0601CA03; LMSP0601BX03": ["C94H165N5O45", "Sphingolipids [SP] with formula: C94H165N5O45"],
        "LMSP0601CK06": ["C94H166N4O40", "Sphingolipids [SP] with formula: C94H166N4O40"],
        "LMSP0601BI04; LMSP0601EA04": ["C94H166N4O43", "Sphingolipids [SP] with formula: C94H166N4O43"],
        "LMSP0601AD04; LMSP0601BH04; LMSP0601AC04; LMSP0601AE04": ["C94H166N4O44", "Sphingolipids [SP] with formula: C94H166N4O44"],
        "LMSP0601AG04; LMSP0505AJ01": ["C94H166N4O46", "Sphingolipids [SP] with formula: C94H166N4O46"],
        "LMSP0504BA01; LMSP0505AW01; LMSP0505BI01; LMSP0505CL01; LMSP0504AY01; LMSP0505CS01; LMSP0505CP01; LMSP0505BD01": ["C94H166N4O47", "Sphingolipids [SP] with formula: C94H166N4O47"],
        "LMSP0505BV01; LMSP0505BO01": ["C94H166N4O48", "Sphingolipids [SP] with formula: C94H166N4O48"],
        "LMSP0504AT07; LMSP0504AW07; LMSP0504BC07; LMSP0505AU07; LMSP0505CJ07; LMSP0504BT07; LMSP0505AZ07; LMSP0505AI07": ["C94H167N3O41", "Sphingolipids [SP] with formula: C94H167N3O41"],
        "LMSP0505AO07; LMSP0502AH07": ["C94H167N3O42", "Sphingolipids [SP] with formula: C94H167N3O42"],
        "LMSP0504AU02; LMSP0505BA02": ["C94H167N3O45", "Sphingolipids [SP] with formula: C94H167N3O45"],
        "LMSP0504BH03; LMSP0506AH03": ["C94H167N5O43", "Sphingolipids [SP] with formula: C94H167N5O43"],
        "LMSP0502AX08": ["C94H168N2O43", "Sphingolipids [SP] with formula: C94H168N2O43"],
        "LMSP0502AZ03": ["C94H168N2O48", "Sphingolipids [SP] with formula: C94H168N2O48"],
        "LMSP0502AV04; LMSP0505AQ04; LMSP0504AP04; LMSP0505BH04; LMSP0504AX04": ["C94H168N4O42", "Sphingolipids [SP] with formula: C94H168N4O42"],
        "LMSP0505AP04; LMSP0505BE04": ["C94H168N4O43", "Sphingolipids [SP] with formula: C94H168N4O43"],
        "LMSP0504AT05; LMSP0504AW05; LMSP0504BC05; LMSP0505AI05; LMSP0505CJ05; LMSP0504BT05; LMSP0505AZ05; LMSP0505AU05": ["C94H169N3O41", "Sphingolipids [SP] with formula: C94H169N3O41"],
        "LMSP0505AO05; LMSP0502AH05": ["C94H169N3O42", "Sphingolipids [SP] with formula: C94H169N3O42"],
        "LMSP0502AX06": ["C94H170N2O43", "Sphingolipids [SP] with formula: C94H170N2O43"],
        "LMSP0601BL01": ["C95H163N5O48", "Sphingolipids [SP] with formula: C95H163N5O48"],
        "LMSP0601AO07": ["C95H165N5O42", "Sphingolipids [SP] with formula: C95H165N5O42"],
        "LMSP0601AT02; LMSP0601BF02; LMSP0601AR02; LMSP0601AW02; LMSP0601CT02; LMSP0601ET02; LMSP0601CS02": ["C95H165N5O47", "Sphingolipids [SP] with formula: C95H165N5O47"],
        "LMSP0601BW02; LMSP0601CF02": ["C95H165N5O48", "Sphingolipids [SP] with formula: C95H165N5O48"],
        "LMSP0601CX07; LMSP0601CP07; LMSP0601DQ07": ["C95H167N5O41", "Sphingolipids [SP] with formula: C95H167N5O41"],
        "LMSP0601AO05": ["C95H167N5O42", "Sphingolipids [SP] with formula: C95H167N5O42"],
        "LMSP0601EY02; LMSP0601DR02; LMSP0601FO02; LMSP0601GP02; LMSP0601GX02": ["C95H167N5O46", "Sphingolipids [SP] with formula: C95H167N5O46"],
        "LMSP0601EP02": ["C95H167N5O47", "Sphingolipids [SP] with formula: C95H167N5O47"],
        "LMSP0601CZ08; LMSP0601BT08; LMSP0601DM08": ["C95H168N4O40", "Sphingolipids [SP] with formula: C95H168N4O40"],
        "LMSP0601EI08; LMSP0601EH08; LMSP0601FN08; LMSP0601GV08; LMSP0601BU08; LMSP0601FE08; LMSP0601BB08; LMSP0601EL08; LMSP0601GQ08; LMSP0601GR08": ["C95H168N4O41", "Sphingolipids [SP] with formula: C95H168N4O41"],
        "LMSP0601BP08; LMSP0601EO08; LMSP0601CR08": ["C95H168N4O42", "Sphingolipids [SP] with formula: C95H168N4O42"],
        "LMSP0601DX03": ["C95H168N4O44", "Sphingolipids [SP] with formula: C95H168N4O44"],
        "LMSP0601GI03; LMSP0601EX03; LMSP0601FJ03; LMSP0601DN03; LMSP0601EM03; LMSP0601BR03; LMSP0601FM03; LMSP0601EJ03": ["C95H168N4O45", "Sphingolipids [SP] with formula: C95H168N4O45"],
        "LMSP0601CP05; LMSP0601CX05; LMSP0601DQ05": ["C95H169N5O41", "Sphingolipids [SP] with formula: C95H169N5O41"],
        "LMSP0601CZ06; LMSP0601BT06; LMSP0601DM06": ["C95H170N4O40", "Sphingolipids [SP] with formula: C95H170N4O40"],
        "LMSP0601GR06; LMSP0601EH06; LMSP0601GV06; LMSP0601FN06; LMSP0601EI06; LMSP0601BB06; LMSP0601BU06; LMSP0601FE06; LMSP0601GQ06; LMSP0601EL06": ["C95H170N4O41", "Sphingolipids [SP] with formula: C95H170N4O41"],
        "LMSP0601CR06; LMSP0601EO06; LMSP0601BP06": ["C95H170N4O42", "Sphingolipids [SP] with formula: C95H170N4O42"],
        "LMSP0601GB01": ["C96H167N5O49", "Sphingolipids [SP] with formula: C96H167N5O49"],
        "LMSP0601BQ01": ["C96H167N5O51", "Sphingolipids [SP] with formula: C96H167N5O51"],
        "LMSP0601BI07; LMSP0601EA07": ["C96H168N4O43", "Sphingolipids [SP] with formula: C96H168N4O43"],
        "LMSP0601AC07; LMSP0601AE07; LMSP0601AD07; LMSP0601BH07": ["C96H168N4O44", "Sphingolipids [SP] with formula: C96H168N4O44"],
        "LMSP0601AG07": ["C96H168N4O46", "Sphingolipids [SP] with formula: C96H168N4O46"],
        "LMSP0601CM02": ["C96H168N4O48", "Sphingolipids [SP] with formula: C96H168N4O48"],
        "LMSP0601CL02": ["C96H168N4O49", "Sphingolipids [SP] with formula: C96H168N4O49"],
        "LMSP0601BG04": ["C96H169N5O44", "Sphingolipids [SP] with formula: C96H169N5O44"],
        "LMSP0601CA04; LMSP0601BX04": ["C96H169N5O45", "Sphingolipids [SP] with formula: C96H169N5O45"],
        "LMSP0504BF01": ["C96H169N5O47", "Sphingolipids [SP] with formula: C96H169N5O47"],
        "LMSP0505EM01; LMSP0504BI01": ["C96H169N5O48", "Sphingolipids [SP] with formula: C96H169N5O48"],
        "LMSP0502AV07; LMSP0505AQ07; LMSP0504AP07; LMSP0505BH07; LMSP0504AX07": ["C96H170N4O42", "Sphingolipids [SP] with formula: C96H170N4O42"],
        "LMSP0601BI05; LMSP0601EA05; LMSP0505AP07; LMSP0505BE07": ["C96H170N4O43", "Sphingolipids [SP] with formula: C96H170N4O43"],
        "LMSP0601BH05; LMSP0601AD05; LMSP0601AC05; LMSP0601AE05": ["C96H170N4O44", "Sphingolipids [SP] with formula: C96H170N4O44"],
        "LMSP0601AG05; LMSP0505AJ02": ["C96H170N4O46", "Sphingolipids [SP] with formula: C96H170N4O46"],
        "LMSP0504BA02; LMSP0505AW02; LMSP0505CL02; LMSP0504AY02; LMSP0505CS02; LMSP0505BI02; LMSP0505CP02; LMSP0505BD02": ["C96H170N4O47", "Sphingolipids [SP] with formula: C96H170N4O47"],
        "LMSP0505BV02; LMSP0505BO02": ["C96H170N4O48", "Sphingolipids [SP] with formula: C96H170N4O48"],
        "LMSP0504AT08; LMSP0504AW08; LMSP0504BC08; LMSP0505AU08; LMSP0505AI08; LMSP0505CJ08; LMSP0504BT08; LMSP0505AZ08": ["C96H171N3O41", "Sphingolipids [SP] with formula: C96H171N3O41"],
        "LMSP0502AH08; LMSP0505AO08": ["C96H171N3O42", "Sphingolipids [SP] with formula: C96H171N3O42"],
        "LMSP0504AU03; LMSP0505BA03": ["C96H171N3O45", "Sphingolipids [SP] with formula: C96H171N3O45"],
        "LMSP0504BH04; LMSP0506AH04": ["C96H171N5O43", "Sphingolipids [SP] with formula: C96H171N5O43"],
        "LMSP0502AZ04": ["C96H172N2O48", "Sphingolipids [SP] with formula: C96H172N2O48"],
        "LMSP0505BH05; LMSP0502AV05; LMSP0505AQ05; LMSP0504AP05; LMSP0504AX05": ["C96H172N4O42", "Sphingolipids [SP] with formula: C96H172N4O42"],
        "LMSP0505AP05; LMSP0505BE05": ["C96H172N4O43", "Sphingolipids [SP] with formula: C96H172N4O43"],
        "LMSP0504AW06; LMSP0504AT06; LMSP0504BC06; LMSP0505AU06; LMSP0505CJ06; LMSP0504BT06; LMSP0505AZ06; LMSP0505AI06": ["C96H173N3O41", "Sphingolipids [SP] with formula: C96H173N3O41"],
        "LMSP0505AO06; LMSP0502AH06": ["C96H173N3O42", "Sphingolipids [SP] with formula: C96H173N3O42"],
        "LMSP0601BL02": ["C97H167N5O48", "Sphingolipids [SP] with formula: C97H167N5O48"],
        "LMSP0601AO08": ["C97H169N5O42", "Sphingolipids [SP] with formula: C97H169N5O42"],
        "LMSP0601CT03; LMSP0601AT03; LMSP0601BF03; LMSP0601AR03; LMSP0601AW03; LMSP0601ET03; LMSP0601CS03": ["C97H169N5O47", "Sphingolipids [SP] with formula: C97H169N5O47"],
        "LMSP0601BW03; LMSP0601CF03": ["C97H169N5O48", "Sphingolipids [SP] with formula: C97H169N5O48"],
        "LMSP0601DO01; LMSP0601EN01; LMSP0601EW01": ["C97H170N4O49", "Sphingolipids [SP] with formula: C97H170N4O49"],
        "LMSP0601CX08; LMSP0601DQ08; LMSP0601CP08": ["C97H171N5O41", "Sphingolipids [SP] with formula: C97H171N5O41"],
        "LMSP0601AO06": ["C97H171N5O42", "Sphingolipids [SP] with formula: C97H171N5O42"],
        "LMSP0601EY03; LMSP0601DR03; LMSP0601FO03; LMSP0601GP03; LMSP0601GX03": ["C97H171N5O46", "Sphingolipids [SP] with formula: C97H171N5O46"],
        "LMSP0601EP03": ["C97H171N5O47", "Sphingolipids [SP] with formula: C97H171N5O47"],
        "LMSP0601DX04": ["C97H172N4O44", "Sphingolipids [SP] with formula: C97H172N4O44"],
        "LMSP0601FJ04; LMSP0601DN04; LMSP0601EM04; LMSP0601BR04; LMSP0601GI04; LMSP0601EX04; LMSP0601FM04; LMSP0601EJ04": ["C97H172N4O45", "Sphingolipids [SP] with formula: C97H172N4O45"],
        "LMSP0601CP06; LMSP0601CX06; LMSP0601DQ06": ["C97H173N5O41", "Sphingolipids [SP] with formula: C97H173N5O41"],
        "LMSP0601BG07": ["C98H171N5O44", "Sphingolipids [SP] with formula: C98H171N5O44"],
        "LMSP0601BX07; LMSP0601CA07": ["C98H171N5O45", "Sphingolipids [SP] with formula: C98H171N5O45"],
        "LMSP0601GB02": ["C98H171N5O49", "Sphingolipids [SP] with formula: C98H171N5O49"],
        "LMSP0601BQ02": ["C98H171N5O51", "Sphingolipids [SP] with formula: C98H171N5O51"],
        "LMSP0601EA08; LMSP0601BI08": ["C98H172N4O43", "Sphingolipids [SP] with formula: C98H172N4O43"],
        "LMSP0601BH08; LMSP0601AD08; LMSP0601AC08; LMSP0601AE08": ["C98H172N4O44", "Sphingolipids [SP] with formula: C98H172N4O44"],
        "LMSP0601AG08": ["C98H172N4O46", "Sphingolipids [SP] with formula: C98H172N4O46"],
        "LMSP0601CM03": ["C98H172N4O48", "Sphingolipids [SP] with formula: C98H172N4O48"],
        "LMSP0601CL03": ["C98H172N4O49", "Sphingolipids [SP] with formula: C98H172N4O49"],
        "LMSP0504BH07; LMSP0506AH07": ["C98H173N5O43", "Sphingolipids [SP] with formula: C98H173N5O43"],
        "LMSP0601BG05": ["C98H173N5O44", "Sphingolipids [SP] with formula: C98H173N5O44"],
        "LMSP0601BX05; LMSP0601CA05": ["C98H173N5O45", "Sphingolipids [SP] with formula: C98H173N5O45"],
        "LMSP0504BF02": ["C98H173N5O47", "Sphingolipids [SP] with formula: C98H173N5O47"],
        "LMSP0505EM02; LMSP0504BI02": ["C98H173N5O48", "Sphingolipids [SP] with formula: C98H173N5O48"],
        "LMSP0502AZ07": ["C98H174N2O48", "Sphingolipids [SP] with formula: C98H174N2O48"],
        "LMSP0505BH08; LMSP0502AV08; LMSP0505AQ08; LMSP0504AP08; LMSP0504AX08": ["C98H174N4O42", "Sphingolipids [SP] with formula: C98H174N4O42"],
        "LMSP0601EA06; LMSP0601BI06; LMSP0505AP08; LMSP0505BE08": ["C98H174N4O43", "Sphingolipids [SP] with formula: C98H174N4O43"],
        "LMSP0601AD06; LMSP0601AC06; LMSP0601BH06; LMSP0601AE06": ["C98H174N4O44", "Sphingolipids [SP] with formula: C98H174N4O44"],
        "LMSP0601AG06; LMSP0505AJ03": ["C98H174N4O46", "Sphingolipids [SP] with formula: C98H174N4O46"],
        "LMSP0504BA03; LMSP0505AW03; LMSP0505CL03; LMSP0504AY03; LMSP0505CS03; LMSP0505BI03; LMSP0505CP03; LMSP0505BD03": ["C98H174N4O47", "Sphingolipids [SP] with formula: C98H174N4O47"],
        "LMSP0505BV03; LMSP0505BO03": ["C98H174N4O48", "Sphingolipids [SP] with formula: C98H174N4O48"],
        "LMSP0504AU04; LMSP0505BA04": ["C98H175N3O45", "Sphingolipids [SP] with formula: C98H175N3O45"],
        "LMSP0504BH05; LMSP0506AH05": ["C98H175N5O43", "Sphingolipids [SP] with formula: C98H175N5O43"],
        "LMSP0502AZ05": ["C98H176N2O48", "Sphingolipids [SP] with formula: C98H176N2O48"],
        "LMSP0502AV06; LMSP0505AQ06; LMSP0504AP06; LMSP0505BH06; LMSP0504AX06": ["C98H176N4O42", "Sphingolipids [SP] with formula: C98H176N4O42"],
        "LMSP0505AP06; LMSP0505BE06": ["C98H176N4O43", "Sphingolipids [SP] with formula: C98H176N4O43"],
        "LMSP0601BL03": ["C99H171N5O48", "Sphingolipids [SP] with formula: C99H171N5O48"],
        "LMSP0601CT04; LMSP0601ET04; LMSP0601AR04; LMSP0601AW04; LMSP0601BF04; LMSP0601CS04; LMSP0601AT04": ["C99H173N5O47", "Sphingolipids [SP] with formula: C99H173N5O47"],
        "LMSP0601BW04; LMSP0601CF04": ["C99H173N5O48", "Sphingolipids [SP] with formula: C99H173N5O48"],
        "LMSP0601ER01; LMSP0601FK01; LMSP0601GT01; LMSP0601EZ01; LMSP0601GC01": ["C99H173N5O51", "Sphingolipids [SP] with formula: C99H173N5O51"],
        "LMSP0601EQ01": ["C99H173N5O52", "Sphingolipids [SP] with formula: C99H173N5O52"],
        "LMSP0601DX07": ["C99H174N4O44", "Sphingolipids [SP] with formula: C99H174N4O44"],
        "LMSP0601EJ07; LMSP0601FJ07; LMSP0601DN07; LMSP0601EM07; LMSP0601BR07; LMSP0601GI07; LMSP0601EX07; LMSP0601FM07": ["C99H174N4O45", "Sphingolipids [SP] with formula: C99H174N4O45"],
        "LMSP0601DO02; LMSP0601EN02; LMSP0601EW02": ["C99H174N4O49", "Sphingolipids [SP] with formula: C99H174N4O49"],
        "LMSP0601EY04; LMSP0601DR04; LMSP0601FO04; LMSP0601GX04; LMSP0601GP04": ["C99H175N5O46", "Sphingolipids [SP] with formula: C99H175N5O46"],
        "LMSP0601EP04": ["C99H175N5O47", "Sphingolipids [SP] with formula: C99H175N5O47"],
        "LMSP0601DX05": ["C99H176N4O44", "Sphingolipids [SP] with formula: C99H176N4O44"],
        "LMSP0601EX05; LMSP0601GI05; LMSP0601FJ05; LMSP0601DN05; LMSP0601EM05; LMSP0601BR05; LMSP0601FM05; LMSP0601EJ05": ["C99H176N4O45", "Sphingolipids [SP] with formula: C99H176N4O45"],
    },
    'Sterol Lipids [ST]': {
        "LMST06000003 (2-hydroxyhexadecanal)": ["C16H32O2", "Sterol Lipids [ST] with formula: C16H32O2"],
        "LMST02010007": ["C18H18O2", "Sterol Lipids [ST] with formula: C18H18O2"],
        "LMST02010026": ["C18H20O2", "Sterol Lipids [ST] with formula: C18H20O2"],
        "LMST02010048 (16-Oxoestrone)": ["C18H20O3", "Sterol Lipids [ST] with formula: C18H20O3"],
        "LMST02010004 (Estrone); LMST02010021; LMST02010020; LMST02010024": ["C18H22O2", "Sterol Lipids [ST] with formula: C18H22O2"],
        "LMST02010047 (16-Ketoestradiol); LMST02010046 (16b-Hydroxyestrone); LMST02010041 (16alpha-hydroxyestrone); LMST02010032 (2-Hydroxyestrone)": ["C18H22O3", "Sterol Lipids [ST] with formula: C18H22O3"],
        "LMST02010053 (6-Ketoestriol)": ["C18H22O4", "Sterol Lipids [ST] with formula: C18H22O4"],
        "LMST02010043 (estrone 3-sulfate); LMST05020008 (Estrone 3-sulfate)": ["C18H22O5S", "Sterol Lipids [ST] with formula: C18H22O5S"],
        "LMST02010001 (Beta-estradiol); LMST02010013; LMST02010017; LMST02010029 (Estradiol-17alpha); LMST02010012": ["C18H24O2", "Sterol Lipids [ST] with formula: C18H24O2"],
        "LMST02010003; LMST02010049 (17-Epiestriol); LMST02010045 (16,17-Epiestriol); LMST02010006; LMST02010031 (6beta-Hydroxyestradiol-17beta); LMST02010028 (4-hydroxyestradiol); LMST02010027 (2-hydroxyestradiol)": ["C18H24O3", "Sterol Lipids [ST] with formula: C18H24O3"],
        "LMST05020005 (Estradiol-17beta 3-sulfate)": ["C18H24O5S", "Sterol Lipids [ST] with formula: C18H24O5S"],
        "LMST02010044 (nandrolone)": ["C18H26O2", "Sterol Lipids [ST] with formula: C18H26O2"],
        "LMST02010042 (19-norandrosterone); LMST02010050": ["C18H28O2", "Sterol Lipids [ST] with formula: C18H28O2"],
        "LMST02010019": ["C18H30O2", "Sterol Lipids [ST] with formula: C18H30O2"],
        "LMST01031007 ((S)-laballenic acid)": ["C18H32O2", "Sterol Lipids [ST] with formula: C18H32O2"],
        "LMST02010018; LMST02020083 (3,17-dioxoandrost-4-en-19-al); LMST02020084 (testolactone); LMST02010033 (2-Methoxyestrone); LMST02020072": ["C19H24O3", "Sterol Lipids [ST] with formula: C19H24O3"],
        "LMST02020062": ["C19H24O4", "Sterol Lipids [ST] with formula: C19H24O4"],
        "LMST02020063": ["C19H24O6", "Sterol Lipids [ST] with formula: C19H24O6"],
        "LMST05020006 (2-Methoxyestrone 3-sulfate)": ["C19H24O6S", "Sterol Lipids [ST] with formula: C19H24O6S"],
        "LMST02020082 (6-dehydrotestosterone); LMST02020007 (Androstenedione); LMST02020018 (Dehydrotestosterone)": ["C19H26O2", "Sterol Lipids [ST] with formula: C19H26O2"],
        "LMST02010035 (2-Methoxyestradiol-17beta); LMST02020061; LMST02020066; LMST02020067; LMST02020065; LMST02020071; LMST02010051 (2-Hydroxyestradiol-3-methyl ether)": ["C19H26O3", "Sterol Lipids [ST] with formula: C19H26O3"],
        "LMST05020007 (2-Methoxyestradiol-17beta 3-sulfate)": ["C19H26O6S", "Sterol Lipids [ST] with formula: C19H26O6S"],
        "LMST02020019 (4-Chlorotestosterone)": ["C19H27ClO2", "Sterol Lipids [ST] with formula: C19H27ClO2"],
        "LMST02020094; LMST02020079 (5alpha-androst-16-en-3-one)": ["C19H28O", "Sterol Lipids [ST] with formula: C19H28O"],
        "LMST02020085; LMST02020058; LMST02020055; LMST02020051 (Epitestosterone); LMST02020103 (Dehydroandrosterone); LMST02020002 (Testosterone); LMST02020021 (Dehydroepiandrosterone)": ["C19H28O2", "Sterol Lipids [ST] with formula: C19H28O2"],
        "LMST02020088 (16-Oxoandrostenediol); LMST02020087 (11-Ketoetiocholanolone); LMST02020092 (3a,16-Dihydroxyandrostenone); LMST02020091 (3a,16b-Dihydroxyandrostenone); LMST02020090 (3a,16a-Dihydroxyandrostenone); LMST02020054 (6beta-hydroxytestosterone); LMST02020068 (7alpha-Hydroxytestosterone); LMST02020064 (16alpha-Hydroxydehydroepiandrosterone); LMST02020102 (4-Hydroxytestosterone); LMST02020106 (7b-Hydroxydehydroepiandrosterone); LMST02020101 (7a-Hydroxydehydroepiandrosterone); LMST02020070": ["C19H28O3", "Sterol Lipids [ST] with formula: C19H28O3"],
        "LMST02020081 (testolic acid)": ["C19H28O4", "Sterol Lipids [ST] with formula: C19H28O4"],
        "LMST05020032 (Testosterone sulfate); LMST05020010 (Dehydroepiandrosterone sulfate)": ["C19H28O5S", "Sterol Lipids [ST] with formula: C19H28O5S"],
        "LMST05020022 (3b,16a-Dihydroxyandrostenone sulfate)": ["C19H28O6S", "Sterol Lipids [ST] with formula: C19H28O6S"],
        "LMST02020008 (alpha-androstenol)": ["C19H30O", "Sterol Lipids [ST] with formula: C19H30O"],
        "LMST02020023 (Epiandrosterone); LMST02020006; LMST02020042 (5alpha-dihydrotesosterone); LMST02020059; LMST02020069 (5beta-Dihydrotestosterone); LMST02020105 (4-Androstenediol); LMST02020104 (Epietiocholanolone); LMST02020001 (Androsterone); LMST02020005 (Androstenediol)": ["C19H30O2", "Sterol Lipids [ST] with formula: C19H30O2"],
        "LMST02020086 (11-Hydroxyandrosterone); LMST02020099 (5-Androstenetriol); LMST02020098; LMST02020097; LMST02020004 (11beta-Hydroxyisoandrosterone)": ["C19H30O3", "Sterol Lipids [ST] with formula: C19H30O3"],
        "LMST05020023 (5a-Dihydrotestosterone sulfate); LMST05020001 (5alpha-androstane-3alpha-ol-17-one sulfate)": ["C19H30O5S", "Sterol Lipids [ST] with formula: C19H30O5S"],
        "LMST02020056": ["C19H32", "Sterol Lipids [ST] with formula: C19H32"],
        "LMST02020095": ["C19H32O", "Sterol Lipids [ST] with formula: C19H32O"],
        "LMST02020080 (5alpha-androstane-3beta,17alpha-diol); LMST02020093 (3a,17a-Dihydroxy-5b-androstane); LMST02020096; LMST02020053 (3beta-androstanediol); LMST02020052 (3alpha-androstanediol); LMST02020077 (5beta-androstane-3alpha,17beta-diol); LMST02020078 (5beta-androstane-3beta,17beta-diol)": ["C19H32O2", "Sterol Lipids [ST] with formula: C19H32O2"],
        "LMST02010036 (17alpha-Ethinyl estradiol)": ["C20H24O2", "Sterol Lipids [ST] with formula: C20H24O2"],
        "LMST02030097 (Norethindrone)": ["C20H26O2", "Sterol Lipids [ST] with formula: C20H26O2"],
        "LMST02030127 (Lynestrenol)": ["C20H28O", "Sterol Lipids [ST] with formula: C20H28O"],
        "LMST02020013 (Methandrostenolone)": ["C20H28O2", "Sterol Lipids [ST] with formula: C20H28O2"],
        "LMST02010052 (2-Methoxyestradiol-3-methylether)": ["C20H28O3", "Sterol Lipids [ST] with formula: C20H28O3"],
        "LMST02030191 (11beta-Hydroxyprogesterone)": ["C20H28O4", "Sterol Lipids [ST] with formula: C20H28O4"],
        "LMST02020025 (Fluoxymesterone)": ["C20H29FO3", "Sterol Lipids [ST] with formula: C20H29FO3"],
        "LMST02020044 (Stenbolone); LMST02020028 (Methenolone); LMST02020029 (17-Methyltestosterone)": ["C20H30O2", "Sterol Lipids [ST] with formula: C20H30O2"],
        "LMST03020604 (1alpha-hydroxy-20-oxo-19,22,23,24,25,26,27-heptanorvitamin D3 / 1alpha-hydroxy-20-oxo-19,22,23,24,25,26,27-heptanorcholecalciferol)": ["C20H30O3", "Sterol Lipids [ST] with formula: C20H30O3"],
        "LMST02020107 (Mesterolone); LMST02020012 (Methandriol); LMST02020027 (Mestanolone)": ["C20H32O2", "Sterol Lipids [ST] with formula: C20H32O2"],
        "LMST02030180 (prednisone)": ["C21H26O5", "Sterol Lipids [ST] with formula: C21H26O5"],
        "LMST02030119 (Norgestrel); LMST01031018 (pregna-4,9(11)-diene-3,20-dione); LMST02030147 (Delta(1)-progesterone); LMST02030163 (16,17-didehydroprogesterone)": ["C21H28O2", "Sterol Lipids [ST] with formula: C21H28O2"],
        "LMST02030177 (megestrol); LMST02030160 (9,11alpha-epoxypregn-4-ene-3,20-dione)": ["C21H28O3", "Sterol Lipids [ST] with formula: C21H28O3"],
        "LMST02030101 (11-Dehydrocorticosterone); LMST02030192 (11-Dehydrocorticosterone); LMST02020026 (Formyldienolone)": ["C21H28O4", "Sterol Lipids [ST] with formula: C21H28O4"],
        "LMST02030179 (prednisolone); LMST02030090 (Cortisone); LMST02030145 (Aldosterone hemiacetal); LMST02030026 (Aldosterone)": ["C21H28O5", "Sterol Lipids [ST] with formula: C21H28O5"],
        "LMST02030194 (18-Oxocortisol)": ["C21H28O6", "Sterol Lipids [ST] with formula: C21H28O6"],
        "LMST02030103 (Fludrocortisone)": ["C21H29FO5", "Sterol Lipids [ST] with formula: C21H29FO5"],
        "LMST02030135 (Progesterone); LMST03020002 (20-oxo-22,23,24,25,26,27-hexanorvitamin D3 / 20-oxo-22,23,24,25,26,27-hexanorcholecalciferol); LMST02030159 (progesterone); LMST02030164 (16,17-didehydropregnenolone)": ["C21H30O2", "Sterol Lipids [ST] with formula: C21H30O2"],
        "LMST03020003 (1alpha-hydroxy-20-oxo-22,23,24,25,26,27-hexanorvitamin D3 / 1alpha-hydroxy-20-oxo-22,23,24,25,26,27-hexanorcholecalciferol); LMST02030136 (17alpha-hydroxyprogesterone); LMST02030184 (11alpha-hydroxyprogesterone); LMST02030087 (11-deoxycorticosterone); LMST02020057 (Testosterone acetate); LMST02030181 (20-hydroxy-3-oxopregn-4-en-21-al); LMST02030182 (16alpha-hydroxyprogesterone); LMST02030148 (12alpha-hydroxyprogesterone); LMST02030161 (17alpha-hydroxyprogesterone); LMST02030168 (11beta-hydroxyprogesterone)": ["C21H30O3", "Sterol Lipids [ST] with formula: C21H30O3"],
        "LMST02030102 (21-Deoxycortisol); LMST02030171 (algestone); LMST02030092 (Corticosterone); LMST02030086 (11-deoxycortisol); LMST03020004 (1alpha,21-dihydroxy-20-oxo-22,23,24,25,26,27-hexanorvitamin D3 / 1alpha,21-dihydroxy-20-oxo-22,23,24,25,26,27-hexanorcholecalciferol); LMST02030186 (corticosterone); LMST02030196; LMST02030195 (21-Deoxycortisol)": ["C21H30O4", "Sterol Lipids [ST] with formula: C21H30O4"],
        "LMST02030001 (Cortisol); LMST02030096 (4,5alpha-Dihydrocortisone); LMST02030095 (4,5beta-Dihydrocortisone); LMST02030091 (18-Hydroxycorticosterone); LMST03020005 (1alpha,17alpha,21-trihydroxy-20-oxo-22,23,24,25,26,27-hexanorvitamin D3 / 1alpha,17alpha,21-trihydroxy-20-oxo-22,23,24,25,26,27-hexanorcholecalciferol); LMST02030187; LMST02030165 (poststerone)": ["C21H30O5", "Sterol Lipids [ST] with formula: C21H30O5"],
        "LMST02030193 (18-Hydroxycortisol)": ["C21H30O6", "Sterol Lipids [ST] with formula: C21H30O6"],
        "LMST05020020 (cortisol 21-sulfate); LMST05020011 (Cortisol 21-sulfate)": ["C21H30O8S", "Sterol Lipids [ST] with formula: C21H30O8S"],
        "LMST02030125 (Allylestrenol); LMST02030150 (pregn-4-en-3-one)": ["C21H32O", "Sterol Lipids [ST] with formula: C21H32O"],
        "LMST02030133 (5alpha-dihydroprogesterone); LMST02030170 (5alpha-pregnane-3,20-dione); LMST02030088 (Pregnenolone); LMST02030203 (Pregnenolone); LMST02030201 (Ethyltestosterone); LMST02020010 (Calusterone); LMST02020017 (Bolasterone); LMST02030144 (5beta-pregnane-3,20-dione); LMST02030146 (5beta-pregnane-3,20-dione); LMST02030153 ((20R)-20-hydroxypregn-4-en-3-one); LMST02030152 (20-hydroxypregn-4-en-3-one); LMST02030169 ((20S)-20-hydroxypregn-4-en-3-one)": ["C21H32O2", "Sterol Lipids [ST] with formula: C21H32O2"],
        "LMST02030172 (16alpha-hydroxypregnenolone); LMST03020006 ((20S)-1alpha,20-dihydroxy-22,23,24,25,26,27-hexanorvitamin D3 / (20S)-1alpha,20-dihydroxy-22,23,24,25,26,27-hexanorcholecalciferol); LMST02030134 (5alpha-dihydrodeoxycorticosterone); LMST02030089 (17alpha-hydroxypregnenolone); LMST02030183 ((20S)-17,20-dihydroxypregn-4-en-3-one); LMST02030149 ((20R)-17,20-dihydroxypregn-4-en-3-one); LMST02030151 (17,20-dihydroxypregn-4-en-3-one); LMST02030167 (21-hydroxypregnenolone)": ["C21H32O3", "Sterol Lipids [ST] with formula: C21H32O3"],
        "LMST02030188; LMST02030199; LMST02030140 (3beta,15beta,17alpha-Trihydroxy-pregnenone); LMST02030141 (3beta,17alpha,21-Trihydroxy-pregnenone)": ["C21H32O4", "Sterol Lipids [ST] with formula: C21H32O4"],
        "LMST02030098 (Urocortisone); LMST02030204 (Dihydrocortisol); LMST02030197; LMST02030166 (11beta,17alpha,21-trihydroxypregnenolone)": ["C21H32O5", "Sterol Lipids [ST] with formula: C21H32O5"],
        "LMST05020014 (pregnenolone sulfate); LMST05020028 (Pregnenolone sulfate); LMST05020009 (Pregnenolone sulfate)": ["C21H32O5S", "Sterol Lipids [ST] with formula: C21H32O5S"],
        "LMST05020021 (17-Hydroxypregnenolone sulfate)": ["C21H32O6S", "Sterol Lipids [ST] with formula: C21H32O6S"],
        "LMST02030162 (pregnan-21-al)": ["C21H34O", "Sterol Lipids [ST] with formula: C21H34O"],
        "LMST02030131 (Epi-allopregnanolone); LMST02030130 (Allopregnanolone); LMST02030137 (Epipregnanolone); LMST02030138 (Pregnanolone); LMST02030175 (3alpha-hydroxy-5beta-pregnan-20-one); LMST02030173 (3beta-hydroxy-5alpha-pregnan-20-one); LMST02030185 (3beta-hydroxy-5beta-pregnan-20-one); LMST02030206 (Pregn-5-ene-3beta,20beta-diol); LMST02030205 (Pregn-5-ene-3beta,20alpha-diol); LMST02030157 (3-hydroxy-5beta-pregnan-20-one); LMST02030156 (3alpha-hydroxy-5alpha-pregnan-20-one); LMST02030155 (3-hydroxypregnan-20-one)": ["C21H34O2", "Sterol Lipids [ST] with formula: C21H34O2"],
        "LMST05030013 (Tetrahydrodeoxycorticosterone); LMST02030132 (21-hydroxyallopregnanolone)": ["C21H34O3", "Sterol Lipids [ST] with formula: C21H34O3"],
        "LMST05030014 (Tetrahydrodeoxycortisol); LMST02030100 (Tetrahydrocorticosterone); LMST02030142 (5alpha-Tetrahydrocorticosterone)": ["C21H34O4", "Sterol Lipids [ST] with formula: C21H34O4"],
        "LMST02030139 (3beta-Allotetrahydrocortisol); LMST02030099 (Urocortisol); LMST02030200 (5a-Tetrahydrocortisol); LMST02030143 (Tetrahydrocortisol)": ["C21H34O5", "Sterol Lipids [ST] with formula: C21H34O5"],
        "LMST02030174 (pregnan-21-ol)": ["C21H36O", "Sterol Lipids [ST] with formula: C21H36O"],
        "LMST02030202 (Pregnanediol); LMST02030198; LMST02020100": ["C21H36O2", "Sterol Lipids [ST] with formula: C21H36O2"],
        "LMST02030104 (Desogestrel)": ["C22H30O", "Sterol Lipids [ST] with formula: C22H30O"],
        "LMST02030154 (canrenoic acid)": ["C22H30O4", "Sterol Lipids [ST] with formula: C22H30O4"],
        "LMST02030178 (6alpha-methylprednisolone); LMST02030190; LMST02030158 (6-methylprednisolone)": ["C22H30O5", "Sterol Lipids [ST] with formula: C22H30O5"],
        "LMST02030176 (medroxyprogesterone); LMST03020007 (1alpha-hydroxy-22-oxo-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-22-oxo-23,24,25,26,27-pentanorcholecalciferol); LMST02020076 (Testosterone propionate)": ["C22H32O3", "Sterol Lipids [ST] with formula: C22H32O3"],
        "LMST03020008 ((6RS)-22-oxo-23,24,25,26,27-pentanorvitamin D3 6,19-sulfur dioxide adduct / (6RS)-22-oxo-23,24,25,26,27-pentanorcholecalciferol 6,19-sulfur dioxide adduct)": ["C22H32O4S", "Sterol Lipids [ST] with formula: C22H32O4S"],
        "LMST02030189": ["C22H32O5", "Sterol Lipids [ST] with formula: C22H32O5"],
        "LMST03020010 (22-hydroxy-23,24,25,26,27-pentanorvitamin D3 / 22-hydroxy-23,24,25,26,27-pentanorcholecalciferol); LMST03020009 (1alpha-hydroxy-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-23,24,25,26,27-pentanorcholecalciferol)": ["C22H34O2", "Sterol Lipids [ST] with formula: C22H34O2"],
        "LMST03020011 (1alpha,22-dihydroxy-23,24,25,26,27-pentanorvitamin D3 / 1alpha,22-dihydroxy-23,24,25,26,27-pentanorcholecalciferol)": ["C22H34O3", "Sterol Lipids [ST] with formula: C22H34O3"],
        "LMST03020012 ((6RS)-22-hydroxy-23,24,25,26,27-pentanorvitamin D3 6,19-sulfur dioxide adduct / (6RS)-22-hydroxy-23,24,25,26,27-pentanorcholecalciferol 6,19-sulfur dioxide adduct)": ["C22H34O4S", "Sterol Lipids [ST] with formula: C22H34O4S"],
        "LMST04050005 (Bisnorcholic acid)": ["C22H36O5", "Sterol Lipids [ST] with formula: C22H36O5"],
        "LMST02030120 (Cortisone acetate)": ["C23H30O6", "Sterol Lipids [ST] with formula: C23H30O6"],
        "LMST02010038 (Estramustine)": ["C23H31Cl2NO3", "Sterol Lipids [ST] with formula: C23H31Cl2NO3"],
        "LMST02030122 (Fludrocortisone acetate)": ["C23H31FO6", "Sterol Lipids [ST] with formula: C23H31FO6"],
        "LMST02010039 (Estradiol valerate)": ["C23H32O3", "Sterol Lipids [ST] with formula: C23H32O3"],
        "LMST01120004 (cannogenin)": ["C23H32O5", "Sterol Lipids [ST] with formula: C23H32O5"],
        "LMST02030093 (Cortisol 21-acetate); LMST01120009 (adonitoxigenin); LMST01120005 (strophanthidin)": ["C23H32O6", "Sterol Lipids [ST] with formula: C23H32O6"],
        "LMST03020687 ((1S)-1-hydroxy-23-oxo-24,25,26,27-tetranorcalciol)": ["C23H34O3", "Sterol Lipids [ST] with formula: C23H34O3"],
        "LMST01120001 (Digitoxigenin); LMST03020013 (1alpha-hydroxy-24,25,26,27-tetranorvitamin D3 23-carboxylic acid / calcitroic acid)": ["C23H34O4", "Sterol Lipids [ST] with formula: C23H34O4"],
        "LMST01120008 (Digoxigenin); LMST01120003 (gitoxigenin)": ["C23H34O5", "Sterol Lipids [ST] with formula: C23H34O5"],
        "LMST01120006 (bipindogenin); LMST01120007 (antiogenin); LMST01120002 (diginatigenin)": ["C23H34O6", "Sterol Lipids [ST] with formula: C23H34O6"],
        "LMST03020016 ((22S)-22-hydroxy-24,25,26,27-tetranorvitamin D3 / (22S)-22-hydroxy-23,24,25,26,27-pentanorcholecalciferol); LMST03020018 ((5E)-(22S)-22-hydroxy-24,25,26,27-tetranorvitamin D3 / (5E)-(22S)-22-hydroxy-24,25,26,27-tetranorcholecalciferol); LMST03020019 (23-hydroxy-24,25,26,27-tetranorvitamin D3 / 23-hydroxy-24,25,26,27-tetranorcholecalciferol); LMST03020017 ((5E)-(22R)-22-hydroxy-24,25,26,27-tetranorvitamin D3 / (5E)-(22R)-22-hydroxy-24,25,26,27-tetranorcholecalciferol); LMST03020014 (1alpha-hydroxy-24,25,26,27-tetranorvitamin D3 / 1alpha-hydroxy-24,25,26,27-tetranorcholecalciferol); LMST03020015 ((22R)-22-hydroxy-24,25,26,27-tetranorvitamin D3 / (22R)-22-hydroxy-24,25,26,27-tetranorcholecalciferol); LMST03020650 (1alpha-Hydroxy-2-methylene-19-nor-(20S)-bishomopregnacalciferol)": ["C23H36O2", "Sterol Lipids [ST] with formula: C23H36O2"],
        "LMST03020020 (1alpha,23-dihydroxy-24,25,26,27-tetranorvitamin D3 / 1alpha,23-dihydroxy-24,25,26,27-tetranorcholecalciferol)": ["C23H36O3", "Sterol Lipids [ST] with formula: C23H36O3"],
        "LMST04060014; LMST04060016; LMST04060013; LMST04060015": ["C23H38O2", "Sterol Lipids [ST] with formula: C23H38O2"],
        "LMST04060012": ["C23H38O3", "Sterol Lipids [ST] with formula: C23H38O3"],
        "LMST04060002": ["C23H38O4", "Sterol Lipids [ST] with formula: C23H38O4"],
        "LMST04060011; LMST04060010; LMST04060007; LMST04060008; LMST04060009": ["C23H40O3", "Sterol Lipids [ST] with formula: C23H40O3"],
        "LMST04060003; LMST04060006; LMST04060004; LMST04060005": ["C23H40O4", "Sterol Lipids [ST] with formula: C23H40O4"],
        "LMST04060001": ["C23H40O5", "Sterol Lipids [ST] with formula: C23H40O5"],
        "LMST04010325": ["C24H30O4", "Sterol Lipids [ST] with formula: C24H30O4"],
        "LMST04010365; LMST04010366": ["C24H30O5", "Sterol Lipids [ST] with formula: C24H30O5"],
        "LMST05010011 (Estrone 3-glucuronide)": ["C24H30O8", "Sterol Lipids [ST] with formula: C24H30O8"],
        "LMST02030123 (Paramethasone acetate)": ["C24H31FO6", "Sterol Lipids [ST] with formula: C24H31FO6"],
        "LMST05010018 (17beta-Estradiol 3-sulfate-17-(beta-D-glucuronide))": ["C24H31O11S", "Sterol Lipids [ST] with formula: C24H31O11S"],
        "LMST05010015 (17beta-Estradiol 17-(beta-D-glucuronide))": ["C24H31O8", "Sterol Lipids [ST] with formula: C24H31O8"],
        "LMST05010019 (16alpha,17beta-Estriol 17-(beta-D-glucuronide))": ["C24H31O9", "Sterol Lipids [ST] with formula: C24H31O9"],
        "LMST05010035 (17-beta-estradiol 3-sulfate-17-(beta-D-glucuronide))": ["C24H32O11S", "Sterol Lipids [ST] with formula: C24H32O11S"],
        "LMST05010047 (Estriol 3-sulfate 16-glucuronide)": ["C24H32O12S", "Sterol Lipids [ST] with formula: C24H32O12S"],
        "LMST04010429": ["C24H32O3", "Sterol Lipids [ST] with formula: C24H32O3"],
        "LMST04010407; LMST02030118 (Megestrol acetate); LMST02030124 (Ethynodiol diacetate); LMST02010040 (Estradiol dipropionate); LMST04010281; LMST01130003 (Scillarenin); LMST04010393; LMST04010396": ["C24H32O4", "Sterol Lipids [ST] with formula: C24H32O4"],
        "LMST04010364; LMST04010362; LMST04010363; LMST04010391": ["C24H32O5", "Sterol Lipids [ST] with formula: C24H32O5"],
        "LMST01130004 (hellebrigenin)": ["C24H32O6", "Sterol Lipids [ST] with formula: C24H32O6"],
        "LMST05010025 (17beta-estradiol 17-glucosiduronic acid); LMST05010005 (17alpha-Estradiol 3-D-glucuronide); LMST05010007 (17beta-Estradiol 3-(beta-D-glucuronide)); LMST05010026 (17alpha-estradiol 3-glucosiduronic acid)": ["C24H32O8", "Sterol Lipids [ST] with formula: C24H32O8"],
        "LMST05010008 (16alpha,17beta-Estriol 16-(beta-D-glucuronide)); LMST05010017 (16alpha,17beta-Estriol 3-(beta-D-glucuronide)); LMST05010034 (16-alpha,17-beta-estriol 17-beta-D-glucuronide); LMST05010033 (15-hydroxynorandrostene-3,17-dione glucuronide)": ["C24H32O9", "Sterol Lipids [ST] with formula: C24H32O9"],
        "LMST04010327": ["C24H34O2", "Sterol Lipids [ST] with formula: C24H34O2"],
        "LMST04010341; LMST04010235; LMST04010333; LMST04010332; LMST04010331; LMST04010318; LMST04010234": ["C24H34O3", "Sterol Lipids [ST] with formula: C24H34O3"],
        "LMST04010342; LMST04010351; LMST04010236; LMST04010361; LMST04010243; LMST04010242; LMST04010245; LMST04010277; LMST04010283; LMST04010282; LMST04010295; LMST01130001 (Bufalin); LMST04010384; LMST04010382; LMST04010360": ["C24H34O4", "Sterol Lipids [ST] with formula: C24H34O4"],
        "LMST04010416; LMST04010345; LMST04010259; LMST04010106; LMST04010244; LMST04010260; LMST04010425; LMST04010424; LMST04010375": ["C24H34O5", "Sterol Lipids [ST] with formula: C24H34O5"],
        "LMST04010326; LMST04010328; LMST04010442 (chola-4,6-dien-24-oic acid); LMST03020688 ((1S)-1-hydroxy-23,24-didehydro-25,26,27-trinorcalciol); LMST04010388": ["C24H36O2", "Sterol Lipids [ST] with formula: C24H36O2"],
        "LMST04010340; LMST04010408; LMST04010320; LMST04010321; LMST04010329; LMST04010330; LMST04010233; LMST04010297; LMST03020021 (cholacalcioic acid / 25,26,27-trinorvitamin D3 24-carboxylic acid / 25,26,27-trinorcholecalciferol 24-carboxylic acid); LMST04010275; LMST04010299; LMST04010296; LMST04010287; LMST04010293; LMST04010433; LMST04010436; LMST04010437; LMST04010379; LMST04010377; LMST04010376": ["C24H36O3", "Sterol Lipids [ST] with formula: C24H36O3"],
        "LMST04010348; LMST04010349; LMST04010401; LMST04010350; LMST04010359; LMST04010400; LMST04010335; LMST04010237; LMST03020022 (1alpha-hydroxy-25,26,27-trinorvitamin D3 24-carboxylic acid); LMST04010253; LMST011120001 (sarmentogenin); LMST04010240; LMST04010406; LMST04010290; LMST04010135; LMST04010134; LMST04010137; LMST04010136; LMST04010139; LMST04010138; LMST04010140; LMST04010141; LMST04010430; LMST04010387; LMST04010380; LMST04010381; LMST04010389; LMST04010369; LMST04010238; LMST04010239; LMST04010392; LMST04010394; LMST04010399": ["C24H36O4", "Sterol Lipids [ST] with formula: C24H36O4"],
        "LMST04010413; LMST04010346; LMST04010405; LMST04010197; LMST04010196; LMST04010195; LMST04010194; LMST04010193; LMST04010192; LMST04010357; LMST04010336; LMST04010317; LMST04010241; LMST04010276; LMST04010271; LMST04010440; LMST04010432; LMST04010434; LMST04010435; LMST04010390": ["C24H36O5", "Sterol Lipids [ST] with formula: C24H36O5"],
        "LMST04010266; LMST04010269; LMST04010268; LMST04010267; LMST04010263; LMST04010265; LMST04010264; LMST04010142; LMST04010143; LMST04010144; LMST04010170": ["C24H38O2", "Sterol Lipids [ST] with formula: C24H38O2"],
        "LMST04010344; LMST04010199; LMST04010198; LMST04010210; LMST04010211; LMST04010212; LMST04010213; LMST04010322; LMST04010324; LMST04010207; LMST04010206; LMST04010205; LMST04010204; LMST04010201; LMST04010200; LMST04010209; LMST04010208; LMST04010334; LMST04010203; LMST04010319; LMST03020023 (1alpha,24-dihydroxy-25,26,27-trinorvitamin D3 / 1alpha,24-dihydroxy-25,26,27-trinorcholecalciferol); LMST04010270; LMST04010278; LMST04010128; LMST04010129; LMST04010127; LMST04010202; LMST04010289; LMST04010286; LMST04010131; LMST04010130; LMST04010133; LMST04010132": ["C24H38O3", "Sterol Lipids [ST] with formula: C24H38O3"],
        "LMST04010347; LMST04010404; LMST04010214; LMST04010216; LMST04010217; LMST04010218; LMST04010219; LMST04010228; LMST04010230; LMST04010226; LMST04010229; LMST04010225; LMST04010224; LMST04010221; LMST04010220; LMST04010223; LMST04010222; LMST04010258; LMST04010279; LMST04010298; LMST04010284; LMST04010280; LMST04010146; LMST04010147; LMST04010148; LMST04010149; LMST04010153; LMST04010152; LMST04010151; LMST04010150; LMST04010157; LMST04010156; LMST04010155; LMST04010154; LMST04010159; LMST04010158; LMST04010438; LMST04010385; LMST04010168; LMST04010169; LMST04010166; LMST04010167; LMST04010164; LMST04010165; LMST04010162; LMST04010163; LMST04010160; LMST04010161; LMST04010367; LMST04010426; LMST04010395; LMST04010398; LMST04010171": ["C24H38O4", "Sterol Lipids [ST] with formula: C24H38O4"],
        "LMST04010184; LMST04010185; LMST04010186; LMST04010180; LMST04010181; LMST04010182; LMST04010183; LMST04010189; LMST04010403; LMST04010402; LMST04010191; LMST04010190; LMST04010354; LMST04010358; LMST04010337; LMST04010338; LMST04010187; LMST04010188; LMST04010232; LMST04010307; LMST04010227; LMST04010272; LMST04010273; LMST04010291; LMST04010292; LMST04010145; LMST04010443 (3-Oxocholic acid); LMST04010178; LMST04010439; LMST04010231; LMST04010423; LMST04010422; LMST04010179; LMST04010173; LMST04010172; LMST04010175; LMST04010174; LMST04010177; LMST04010176; LMST04010374": ["C24H38O5", "Sterol Lipids [ST] with formula: C24H38O5"],
        "LMST04010415; LMST04010409; LMST04010274; LMST04010262; LMST04010383": ["C24H38O6", "Sterol Lipids [ST] with formula: C24H38O6"],
        "LMST05020025 (Chenodeoxycholic acid disulfate); LMST05020027 (Deoxycholic acid disulfate)": ["C24H40O10S2", "Sterol Lipids [ST] with formula: C24H40O10S2"],
        "LMST04010002 (5alpha-Cholanoic acid); LMST04010441 (5beta-Cholanoic acid)": ["C24H40O2", "Sterol Lipids [ST] with formula: C24H40O2"],
        "LMST04010343; LMST04010323; LMST04010018; LMST04010012; LMST04010013; LMST04010010; LMST04010011; LMST04010016; LMST04010017; LMST04010014; LMST04010015; LMST04010315; LMST04010005; LMST04010004; LMST04010007; LMST04010006; LMST04010003; LMST04010009; LMST04010008; LMST04010397": ["C24H40O3", "Sterol Lipids [ST] with formula: C24H40O3"],
        "LMST04010412; LMST04010353; LMST04010352; LMST04010035; LMST04010033 (Ursodeoxycholic acid); LMST04010038; LMST04010039; LMST04010034; LMST04010036; LMST04010037; LMST04010030; LMST04010031; LMST04010032 (Chenodeoxycholic Acid); LMST04010029; LMST04010028; LMST04010027; LMST04010026; LMST04010025; LMST04010024; LMST04010023; LMST04010022; LMST04010021; LMST04010020; LMST04010308; LMST04010309; LMST04010019; LMST04010255; LMST04010056; LMST04010054; LMST04010055; LMST04010052; LMST04010050; LMST04010051; LMST04010053; LMST04010049; LMST04010048; LMST04010041; LMST04010040 (Deoxycholic acid); LMST04010043; LMST04010042; LMST04010045; LMST04010044; LMST04010047; LMST04010046; LMST04010288; LMST04010386; LMST04010368; LMST04010428": ["C24H40O4", "Sterol Lipids [ST] with formula: C24H40O4"],
        "LMST04010417; LMST04010414; LMST04010411; LMST04010418; LMST04010339; LMST04010300; LMST04010086; LMST04010001 (Cholic acid); LMST04010250; LMST04010251; LMST04010256; LMST04010257; LMST04010070; LMST04010071; LMST04010072; LMST04010073; LMST04010074; LMST04010075; LMST04010076; LMST04010077; LMST04010078; LMST04010079; LMST04010108; LMST04010109; LMST04010104; LMST04010105; LMST04010107; LMST04010100; LMST04010101; LMST04010102; LMST04010103; LMST04010249; LMST04010248; LMST04010247; LMST04010246; LMST04010063; LMST04010062; LMST04010061; LMST04010060; LMST04010067 (Muricholic acid); LMST04010066; LMST04010065; LMST04010064; LMST04010069; LMST04010068; LMST04010113; LMST04010112; LMST04010111; LMST04010110; LMST04010058; LMST04010057; LMST04010285; LMST04010088; LMST04010059; LMST04010092; LMST04010093; LMST04010090; LMST04010091; LMST04010096; LMST04010097; LMST04010094; LMST04010095; LMST04010098; LMST04010099; LMST04010089; LMST04010085; LMST04010087; LMST04010081; LMST04010080; LMST04010083; LMST04010082; LMST04010373; LMST04010372; LMST04010371; LMST04010370": ["C24H40O5", "Sterol Lipids [ST] with formula: C24H40O5"],
        "LMST04010419; LMST04010252; LMST04010254; LMST04010119; LMST04010118; LMST04010117; LMST04010116; LMST04010115; LMST04010114; LMST04010122; LMST04010123; LMST04010120; LMST04010121; LMST04010126; LMST04010124; LMST04010125; LMST04010261; LMST04010294; LMST04010421; LMST04010420": ["C24H40O6", "Sterol Lipids [ST] with formula: C24H40O6"],
        "LMST05020015 (lithocholic acid sulfate)": ["C24H40O6S", "Sterol Lipids [ST] with formula: C24H40O6S"],
        "LMST05020033 (Ursodeoxycholic acid 3-sulfate); LMST05020024 (Chenodeoxycholic acid 3-sulfate); LMST05020026 (Chenodeoxycholic acid sulfate); LMST04010446 (3-Sulfodeoxycholic acid)": ["C24H40O7S", "Sterol Lipids [ST] with formula: C24H40O7S"],
        "LMST04010444 (7-Sulfocholic acid)": ["C24H40O8S", "Sterol Lipids [ST] with formula: C24H40O8S"],
        "LMST04010316": ["C24H42O2", "Sterol Lipids [ST] with formula: C24H42O2"],
        "LMST04010311; LMST04010310; LMST04010313; LMST04010312; LMST04010314; LMST03020615 (C-9,11,21-Trisnor-17-methyl-1alpha,25-dihydroxyvitamin D3)": ["C24H42O3", "Sterol Lipids [ST] with formula: C24H42O3"],
        "LMST04010302; LMST04010303; LMST04010301": ["C24H42O4", "Sterol Lipids [ST] with formula: C24H42O4"],
        "LMST05020018 (3alpha,7alpha,12alpha-trihydroxy-5alpha-cholan-24-yl sulfate)": ["C24H42O7S", "Sterol Lipids [ST] with formula: C24H42O7S"],
        "LMST02010037 (Quinestrol)": ["C25H32O2", "Sterol Lipids [ST] with formula: C25H32O2"],
        "LMST05010010 (2-Methoxyestrone 3-glucuronide)": ["C25H32O9", "Sterol Lipids [ST] with formula: C25H32O9"],
        "LMST02030126 (Hydrocortisone succinate); LMST05010024 (6-dehydrotestosterone 17-glucosiduronic acid)": ["C25H34O8", "Sterol Lipids [ST] with formula: C25H34O8"],
        "LMST05010040 (4-Hydroxyandrostenedione glucuronide); LMST05010009 (2-Methoxy-estradiol-17beta 3-glucuronide)": ["C25H34O9", "Sterol Lipids [ST] with formula: C25H34O9"],
        "LMST05010045 (Dehydroepiandrosterone 3-glucuronide); LMST05010012 (Testosterone glucuronide)": ["C25H36O8", "Sterol Lipids [ST] with formula: C25H36O8"],
        "LMST05010032 (11-Oxo-androsterone glucuronide)": ["C25H36O9", "Sterol Lipids [ST] with formula: C25H36O9"],
        "LMST03020025 (1alpha-hydroxy-26,27-dinorvitamin D3 25-carboxylic acid / 1alpha-hydroxy-26,27-dinorcholecalciferol 25-carboxylic acid)": ["C25H38O4", "Sterol Lipids [ST] with formula: C25H38O4"],
        "LMST05010041 (5-alpha-Dihydrotestosterone glucuronide); LMST05010001; LMST05010014 (Etiocholan-3alpha-ol-17-one 3-glucuronide); LMST05010013 (Androsterone 3-glucuronide)": ["C25H38O8", "Sterol Lipids [ST] with formula: C25H38O8"],
        "LMST05010030 (11-beta-hydroxyandrosterone-3-glucuronide)": ["C25H38O9", "Sterol Lipids [ST] with formula: C25H38O9"],
        "LMST03020027 (1alpha,25-dihydroxy-23,24-dinorvitamin D3 / 1alpha,25-dihydroxy-23,24-dinorcholecalciferol); LMST03020026 (1alpha-hydroxy-21-nor-20-oxavitamin D3 / 1alpha-hydroxy-21-nor-20-oxacholecalciferol); LMST03020028 (1alpha,25-dihydroxy-26,27-dinorvitamin D3 / 1alpha,25-dihydroxy-26,27-dinorcholecalciferol)": ["C25H40O3", "Sterol Lipids [ST] with formula: C25H40O3"],
        "LMST04070028; LMST03020030 (1alpha,25-dihydroxy-24-nor-22-oxavitamin D3 / 1alpha,25-dihydroxy-24-nor-22-oxacholecalciferol); LMST03020029 (1alpha,25-dihydroxy-21-nor-20-oxavitamin D3 / 1alpha,25-dihydroxy-21-nor-20-oxacholecalciferol)": ["C25H40O4", "Sterol Lipids [ST] with formula: C25H40O4"],
        "LMST03020031 (1alpha-hydroxy-24-methylsulfonyl-25,26,27-trinorvitamin D3 / 1alpha-hydroxy-24-methylsulfonyl-25,26,27-trinorcholecalciferol)": ["C25H40O4S", "Sterol Lipids [ST] with formula: C25H40O4S"],
        "LMST05010004 (3alpha-androstanediol glucuronide); LMST05010037 (3,17-Androstanediol glucuronide); LMST05010039 (3-alpha-androstanediol glucuronide)": ["C25H40O8", "Sterol Lipids [ST] with formula: C25H40O8"],
        "LMST05010036": ["C25H40O9", "Sterol Lipids [ST] with formula: C25H40O9"],
        "LMST03020616 (2alpha-Fluoro-19-nor-22-oxa-1alpha,25-dihydroxyvitamin D3)": ["C25H41FO4", "Sterol Lipids [ST] with formula: C25H41FO4"],
        "LMST03020032 (1,25-dihydroxy-2,4-dinor-1,3-secovitamin D3 / 1,25-dihydroxy-2,4-dinor-1,3-secocholecalciferol); LMST03020566 (1alpha,25-dihydroxy-3-deoxy-19-nor-22-oxavitamin D3 / 1alpha,25-dihydroxy-3-deoxy-19-nor-22-oxacholecalciferol); LMST03020567 (1beta,25-dihydroxy-3-deoxy-19-nor-22-oxavitamin D3 / 1beta,25-dihydroxy-3-deoxy-19-nor-22-oxacholecalciferol); LMST03020568 (25-dihydroxy-19-nor-22-oxa-3-epivitamin D3 / 25-dihydroxy-19-nor-22-oxa-3-epicholecalciferol); LMST03020569 (25-dihydroxy-19-nor-22-oxavitamin D3 / 25-dihydroxy-19-nor-22-oxacholecalciferol)": ["C25H42O3", "Sterol Lipids [ST] with formula: C25H42O3"],
        "LMST03020546 (1alpha,25-dihydroxy-19-nor-22-oxavitamin D3 / 1alpha,25-dihydroxy-19-nor-22-oxacholecalciferol); LMST04070027": ["C25H42O4", "Sterol Lipids [ST] with formula: C25H42O4"],
        "LMST03020545 (1alpha,25-dihydroxy-26,26,26,27,27,27-hexafluoro-16,17,23,23,24,24-hexadehydro-19-norvitamin D3 / 1alpha,25-dihydroxy-26,26,26,27,27,27-hexafluoro-16,17,23,23,24,24-hexadehydro-19-norcholecalciferol)": ["C26H32F6O3", "Sterol Lipids [ST] with formula: C26H32F6O3"],
        "LMST01130002 (Scillirosidin)": ["C26H34O6", "Sterol Lipids [ST] with formula: C26H34O6"],
        "LMST03020033 (25,26-epoxy-1alpha-hydroxy-23,23,24,24-tetradehydro-19-norvitamin D3 / 25,26-epoxy-1alpha-hydroxy-23,23,24,24-tetradehydro-19-norcholecalciferol); LMST03020034 ((22E,24E)-1alpha,26-dihydroxy-22,23,24,25-tetradehydro-27-norvitamin D3 / (22E,24E)-1alpha,26-dihydroxy-22,23,24,25-tetradehydro-27-norcholecalciferol)": ["C26H38O3", "Sterol Lipids [ST] with formula: C26H38O3"],
        "LMST03020024 (26,26,26-trifluoro-25-hydroxy-27-norvitamin D3 / 26,26,26-trifluoro-25-hydroxy-27-norcholecalciferol)": ["C26H39F3O2", "Sterol Lipids [ST] with formula: C26H39F3O2"],
        "LMST03020645 (19-Nor-14,20-bisepi-23-yne-1,25 dihydroxyvitamin D3); LMST03020649 (19-Nor-14-epi-23-yne-1,25 dihydroxyvitamin D3); LMST03020035 ((17E)-1alpha,25-dihydroxy-17,20-didehydro-21-norvitamin D3 / (17E)-1alpha,25-dihydroxy-17,20-didehydro-21-norcholecalciferol); LMST03020036 ((17Z)-1alpha,25-dihydroxy-17,20-didehydro-21-norvitamin D3 / (17Z)-1alpha,25-dihydroxy-17,20-didehydro-21-norcholecalciferol); LMST02020075 (Testosterone enanthate)": ["C26H40O3", "Sterol Lipids [ST] with formula: C26H40O3"],
        "LMST03020037 ((24R,25S)-25,26-epoxy-1alpha,24-dihydroxy-27-norvitamin D3 / (24R,25S)-25,26-epoxy-1alpha,24-dihydroxy-27-norcholecalciferol); LMST03020038 ((24S,25R)-25,26-epoxy-1alpha,24-dihydroxy-27-norvitamin D3 / (24S,25R)-25,26-epoxy-1alpha,24-dihydroxy-27-norcholecalciferol); LMST03020609 (1alpha,25-Dihydroxy-16-ene-19-nor-24-oxovitamin D3)": ["C26H40O4", "Sterol Lipids [ST] with formula: C26H40O4"],
        "LMST03020039 (1alpha,25-dihydroxy-24-oxo-22-oxavitamin D3 / 1alpha,25-dihydroxy-24-oxo-22-oxacholecalciferol)": ["C26H40O5", "Sterol Lipids [ST] with formula: C26H40O5"],
        "LMST03020647 (24,24-Difluoro-1,25,26-trihydroxyvitamin D3)": ["C26H42F2O4", "Sterol Lipids [ST] with formula: C26H42F2O4"],
        "LMST05030004 (Sulfoglycolithocholate)": ["C26H42NO7S", "Sterol Lipids [ST] with formula: C26H42NO7S"],
        "LMST03020040 (25-hydroxy-3-deoxy-2-oxavitamin D3 / 25-hydroxy-3-deoxy-2-oxacholecalciferol)": ["C26H42O2", "Sterol Lipids [ST] with formula: C26H42O2"],
        "LMST03020041 (1alpha,25-dihydroxy-3-deoxy-3-thiavitamin D3 / 1alpha,25-dihydroxy-3-deoxy-3-thiacholecalciferol); LMST03020043 ((5Z)-1,25-dihydroxy-3-thiavitamin D3 / (5Z)-1,25-dihydroxy-3-thiacholecalciferol); LMST03020042 (1beta,25-dihydroxy-3-deoxy-3-thiavitamin D3 / 1beta,25-dihydroxy-3-deoxy-3-thiacholecalciferol)": ["C26H42O2S", "Sterol Lipids [ST] with formula: C26H42O2S"],
        "LMST03020255 (22-ethyl-1alpha,22-dihydroxy-25,26,27-trinorvitamin D3 / 22-ethyl-1alpha,22-dihydroxy-25,26,27-trinorcholecalciferol); LMST03020045 (25-hydroxy-23-oxavitamin D3 / 25-hydroxy-23-oxacholecalciferol); LMST03020044 (1alpha-hydroxy-22-oxavitamin D3 / 1alpha-hydroxy-22-oxacholecalciferol); LMST03020047 (1alpha,25-dihydroxy-19-norprevitamin D3 / 1alpha,25-dihydroxy-19-norprecholecalciferol); LMST03020046 (1alpha,25-dihydroxy-24-norvitamin D3 / 1alpha,25-dihydroxy-24-norcholecalciferol); LMST03020048 (1alpha,25-dihydroxy-21-norvitamin D3 / 1alpha,25-dihydroxy-21-norcholecalciferol)": ["C26H42O3", "Sterol Lipids [ST] with formula: C26H42O3"],
        "LMST03020052 ((5Z)-(3S)-1alpha,25-dihydroxy-3-deoxy-3-thiavitamin D3 3-oxide / (5Z)-(3S)-1alpha,25-dihydroxy-3-deoxy-3-thiacholecalciferol 3-oxide); LMST03020053 (1alpha,25-dihydroxy-22-thiavitamin D3 / 1alpha,25-dihydroxy-22-thiacholecalciferol); LMST03020050 ((5E)-(3S)-1alpha,25-dihydroxy-3-deoxy-3-thiavitamin D3 3-oxide / (5E)-(3S)-1alpha,25-dihydroxy-3-deoxy-3-thiacholecalciferol 3-oxide); LMST03020051 ((5Z)-1alpha,25-dihydroxy-3-deoxy-3-thiavitamin D3 3-oxide / (5Z)-1alpha,25-dihydroxy-3-deoxy-3-thiacholecalciferol 3-oxide); LMST03020054 (1alpha,25-dihydroxy-22-thia-20-epivitamin D3 / 1alpha,25-dihydroxy-22-thia-20-epicholecalciferol); LMST03020055 (1alpha,25-dihydroxy-23-thiavitamin D3 / 1alpha,25-dihydroxy-23-thiacholecalciferol); LMST03020049 (1alpha,25-dihydroxy-3-deoxy-3-thiavitamin D3 3-oxide / 1alpha,25-dihydroxy-3-deoxy-3-thiacholecalciferol 3-oxide)": ["C26H42O3S", "Sterol Lipids [ST] with formula: C26H42O3S"],
        "LMST03020064 ((20S)-1alpha,20,25-trihydroxy-24-norvitamin D3/(20S)-1alpha,20,25-trihydroxy-24-norcholecalciferol); LMST03020063 (1alpha,25-dihydroxy-23-oxavitamin D3 / 1alpha,25-dihydroxy-23-oxacholecalciferol); LMST03020062 (1beta,25-dihydroxy-22-oxavitamin D3 / 1beta,25-dihydroxy-22-oxacholecalciferol); LMST03020061 (1alpha,25-dihydroxy-22-oxa-20-epivitamin D3 / 1alpha,25-dihydroxy-22-oxa-20-epicholecalciferol); LMST03020060 (1alpha,25-dihydroxy-22-oxavitamin D3 / 1alpha,25-dihydroxy-22-oxacholecalciferol); LMST03020058 ((24S)-1alpha,24-dihydroxy-22-oxavitamin D3 / (24S)-1alpha,24-dihydroxy-22-oxacholecalciferol); LMST03020059 ((24S)-1alpha,24-dihydroxy-22-oxa-20-epivitamin D3 / (24S)-1alpha,24-dihydroxy-22-oxa-20-epicholecalciferol); LMST03020056 ((24R)-1alpha,24-dihydroxy-22-oxavitamin D3 / (24R)-1alpha,24-dihydroxy-22-oxacholecalciferol); LMST03020057 ((24R)-1alpha,24-dihydroxy-22-oxa-20-epivitamin D3 / (24R)-1alpha,24-dihydroxy-22-oxa-20-epicholecalciferol)": ["C26H42O4", "Sterol Lipids [ST] with formula: C26H42O4"],
        "LMST03020068 ((25S)-1alpha,25,26-trihydroxy-22-oxavitamin D3 / (25S)-1alpha,25,26-trihydroxy-22-oxacholecalciferol); LMST03020067 ((25R)-1alpha,25,26-trihydroxy-22-oxavitamin D3 / (25R)-1alpha,25,26-trihydroxy-22-oxacholecalciferol); LMST03020066 ((24S)-1alpha,24,25-trihydroxy-22-oxavitamin D3 / (24S)-1alpha,24,25-trihydroxy-22-oxacholecalciferol); LMST03020065 ((24R)-1alpha,24,25-trihydroxy-22-oxavitamin D3 / (24R)-1alpha,24,25-trihydroxy-22-oxacholecalciferol)": ["C26H42O5", "Sterol Lipids [ST] with formula: C26H42O5"],
        "LMST03020069 (25-azavitamin D3 / 25-azacholecalciferol)": ["C26H43NO", "Sterol Lipids [ST] with formula: C26H43NO"],
        "LMST03020070 (1alpha,25-dihydroxy-23-azavitamin D3 / 1alpha,25-dihydroxy-23-azacholecalciferol)": ["C26H43NO3", "Sterol Lipids [ST] with formula: C26H43NO3"],
        "LMST05030009 (Lithocholic acid glycine conjugate)": ["C26H43NO4", "Sterol Lipids [ST] with formula: C26H43NO4"],
        "LMST04010445 (Glycoursodeoxycholic acid); LMST05030008 (Chenodeoxycholic acid glycine conjugate); LMST05030006 (glycodeoxycholic acid); LMST05030002 (Deoxycholic acid); LMST05030003 (Chenodeoxyglycocholate)": ["C26H43NO5", "Sterol Lipids [ST] with formula: C26H43NO5"],
        "LMST05030007 (3a,7b,12a-Trihydroxyoxocholanyl-Glycine); LMST05030001 (Glycocholic Acid)": ["C26H43NO6", "Sterol Lipids [ST] with formula: C26H43NO6"],
        "LMST05030012; LMST05030005 (glycochenodeoxycholic acid 7-sulfate)": ["C26H43NO8S", "Sterol Lipids [ST] with formula: C26H43NO8S"],
        "LMST05030011; LMST05030010": ["C26H43NO9S", "Sterol Lipids [ST] with formula: C26H43NO9S"],
        "LMST03020071 (1alpha-hydroxy-24-(dimethylphosphoryl)-25,26,27-trinorvitamin D3 / 1alpha-hydroxy-24-(dimethylphosphoryl)-25,26,27-trinorcholecalciferol)": ["C26H43O3P", "Sterol Lipids [ST] with formula: C26H43O3P"],
        "LMST03020072 (24-(dimethoxyphosphoryl)-25,26,27-trinorvitamin D3 / 24-(dimethoxyphosphoryl)-25,26,27-trinorcholecalciferol)": ["C26H43O4P", "Sterol Lipids [ST] with formula: C26H43O4P"],
        "LMST03020073 (1alpha-hydroxy-24-(dimethoxyphosphoryl)-25,26,27-trinorvitamin D3 / 1alpha-hydroxy-24-(dimethoxyphosphoryl)-25,26,27-trinorcholecalciferol)": ["C26H43O5P", "Sterol Lipids [ST] with formula: C26H43O5P"],
        "LMST03020564 (25-dihydroxy-19-nor-3-epivitamin D3 / 25-dihydroxy-19-nor-3-epicholecalciferol); LMST03020565 (25-dihydroxy-19-norvitamin D3 / 25-dihydroxy-19-norcholecalciferol); LMST03020562 (1alpha,25-dihydroxy-3-deoxy-19-norvitamin D3 / 1alpha,25-dihydroxy-3-deoxy-19-norcholecalciferol); LMST03020563 (1beta,25-dihydroxy-3-deoxy-19-norvitamin D3 / 1beta,25-dihydroxy-3-deoxy-19-norcholecalciferol)": ["C26H44O2", "Sterol Lipids [ST] with formula: C26H44O2"],
        "LMST03020074 (1alpha,25-dihydroxy-19-norvitamin D3 / 1alpha,25-dihydroxy-19-norcholecalciferol); LMST03020075 (1,25-dihydroxy-2-nor-1,2-secovitamin D3 / 1,25-dihydroxy-2-nor-1,2-secocholecalciferol); LMST03020679 (2-Nor-1,3-seco-1alpha,25-dihydroxyvitamin D3)": ["C26H44O3", "Sterol Lipids [ST] with formula: C26H44O3"],
        "LMST03020547 (1alpha,2alpha,25-trihydroxy-19-norvitamin D3 / 1alpha,2alpha,25-trihydroxy-19-norcholecalciferolcholecalciferol); LMST03020548 (1alpha,2beta,25-trihydroxy-19-norvitamin D3 / 1alpha,2beta,25-trihydroxy-19-norcholecalciferol); LMST04020001": ["C26H44O4", "Sterol Lipids [ST] with formula: C26H44O4"],
        "LMST01010212 (25-Azacholesterol)": ["C26H45NO", "Sterol Lipids [ST] with formula: C26H45NO"],
        "LMST05020031 (Taurocholic acid 3-sulfate)": ["C26H45NO10S2", "Sterol Lipids [ST] with formula: C26H45NO10S2"],
        "LMST05040003 (Taurolithocholic acid)": ["C26H45NO5S", "Sterol Lipids [ST] with formula: C26H45NO5S"],
        "LMST05040015 (Tauroursodeoxycholic acid); LMST05040013 (Taurodeoxycholic acid); LMST05040005 (Taurochenodeoxycholic acid)": ["C26H45NO6S", "Sterol Lipids [ST] with formula: C26H45NO6S"],
        "LMST05040014 (Tauroursocholic acid); LMST05040012 (Tauro-b-muricholic acid); LMST05040010 (Taurohyocholic acid); LMST05040001 (Taurocholic acid)": ["C26H45NO7S", "Sterol Lipids [ST] with formula: C26H45NO7S"],
        "LMST05020029 (Taurochenodeoxycholic acid 3-sulfate); LMST05020003 (Taurolithocholate sulfate)": ["C26H45NO8S2", "Sterol Lipids [ST] with formula: C26H45NO8S2"],
        "LMST05020030 (Taurochenodeoxycholic acid 7-sulfate)": ["C26H45NO9S2", "Sterol Lipids [ST] with formula: C26H45NO9S2"],
        "LMST01010213": ["C26H46O5", "Sterol Lipids [ST] with formula: C26H46O5"],
        "LMST04020029 (27-Norcholestanehexol)": ["C26H46O6", "Sterol Lipids [ST] with formula: C26H46O6"],
        "LMST03020076 (1alpha,26,26,26,27,27,27-heptafluoro-25-hydroxy-16,17,23,23,24,24-hexadehydrovitamin D3 / 1alpha,26,26,26,27,27,27-heptafluoro-25-hydroxy-16,17,23,23,24,24-hexadehydrocholecalciferol)": ["C27H31F7O2", "Sterol Lipids [ST] with formula: C27H31F7O2"],
        "LMST03020077 (26,26,26,27,27,27-hexafluoro-25-hydroxy-16,17,23,23,24,24-hexadehydrovitamin D3 / 26,26,26,27,27,27-hexafluoro-25-hydroxy-16,17,23,23,24,24-hexadehydrocholecalciferol)": ["C27H32F6O2", "Sterol Lipids [ST] with formula: C27H32F6O2"],
        "LMST03020078 (26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxy-16,17,23,23,24,24-hexadehydrovitamin D3 / 26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxy-16,17,23,23,24,24-hexadehydrocholecalciferol)": ["C27H32F6O3", "Sterol Lipids [ST] with formula: C27H32F6O3"],
        "LMST03020079 (26,26,26,27,27,27-hexafluoro-25-hydroxy-23,23,24,24-tetradehydrovitamin D3 / 26,26,26,27,27,27-hexafluoro-25-hydroxy-23,23,24,24-tetradehydrocholecalciferol)": ["C27H34F6O2", "Sterol Lipids [ST] with formula: C27H34F6O2"],
        "LMST03020080 (26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxy-23,23,24,24-tetradehydrovitamin D3 / 26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxy-23,23,24,24-tetradehydrocholecalciferol)": ["C27H34F6O3", "Sterol Lipids [ST] with formula: C27H34F6O3"],
        "LMST03020081 ((22E)-26,26,26,27,27,27-hexafluoro-25-hydroxy-22,23-didehydrovitamin D3 / (22E)-26,26,26,27,27,27-hexafluoro-25-hydroxy-22,23-didehydrocholecalciferol)": ["C27H36F6O2", "Sterol Lipids [ST] with formula: C27H36F6O2"],
        "LMST03020083 ((23E)-26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxy-23,24-didehydrovitamin D3 / (23E)-26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxy-23,24-didehydrocholecalciferol); LMST03020082 ((22E)-26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxy-22,23-didehydrovitamin D3 / (22E)-26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxy-22,23-didehydrocholecalciferol)": ["C27H36F6O3", "Sterol Lipids [ST] with formula: C27H36F6O3"],
        "LMST03020084 (1alpha-fluoro-25-hydroxy-16,17,23,23,24,24-hexadehydrovitamin D3 / 1alpha-fluoro-25-hydroxy-16,17,23,23,24,24-hexadehydrocholecalciferol)": ["C27H37FO2", "Sterol Lipids [ST] with formula: C27H37FO2"],
        "LMST03020085 (26,26,26,27,27,27-hexafluoro-1alphaa-hydroxyvitamin D3 / 26,26,26,27,27,27-hexafluoro-1alphaa-hydroxycholecalciferol); LMST03020086 (26,26,26,27,27,27-hexafluoro-25-hydroxyvitamin D3 / 26,26,26,27,27,27-hexafluoro-25-hydroxycholecalciferol)": ["C27H38F6O2", "Sterol Lipids [ST] with formula: C27H38F6O2"],
        "LMST03020089 (26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxyvitamin D3 / 26,26,26,27,27,27-hexafluoro-1alpha,25-dihydroxycholecalciferol); LMST03020088 (26,26,26,27,27,27-hexafluoro-1alpha,24-dihydroxyvitamin D3 / 26,26,26,27,27,27-hexafluoro-1alpha,24-dihydroxycholecalciferol)": ["C27H38F6O3", "Sterol Lipids [ST] with formula: C27H38F6O3"],
        "LMST03020090 ((23S)-26,26,26,27,27,27-hexafluoro-1alpha,23,25-trihydroxyvitamin D3 / (23S)-26,26,26,27,27,27-hexafluoro-1alpha,23,25-trihydroxycholecalciferol); LMST03020087 (6,19-epidioxy-26,26,26,27,27,27-hexafluoro-25-hydroxy-6,19-dihydrovitamin D3 / 6,19-epidioxy-26,26,26,27,27,27-hexafluoro-25-hydroxy-6,19-dihydrocholecalciferol)": ["C27H38F6O4", "Sterol Lipids [ST] with formula: C27H38F6O4"],
        "LMST03020091 (25-hydroxy-16,17,23,23,24,24-hexadehydrovitamin D3 / 25-hydroxy-16,17,23,23,24,24-hexadehydrocholecalciferol)": ["C27H38O2", "Sterol Lipids [ST] with formula: C27H38O2"],
        "LMST03020096 (1alpha,25-dihydroxy-16,17,23,23,24,24-hexadehydrovitamin D3 / 1alpha,25-dihydroxy-16,17,23,23,24,24-hexadehydrocholecalciferol); LMST03020094 (25,26-epoxy-1alpha-hydroxy-23,23,24,24-tetradehydrovitamin D3 / 25,26-epoxy-1alpha-hydroxy-23,23,24,24-tetradehydrocholecalciferol); LMST03020095 (25,26-epoxy-1alpha-hydroxy-23,23,24,24-tetradehydro-20-epivitamin D3 / 25,26-epoxy-1alpha-hydroxy-23,23,24,24-tetradehydro-20-epicholecalciferol); LMST03020092 ((22E)-1alpha-hydroxy-24-oxo-26,27-cyclo-22,23-didehydrovitamin D3 / (22E)-1alpha-hydroxy-24-oxo-26,27-cyclo-22,23-didehydrocholecalciferol); LMST03020093 (24,25-epoxy-1alpha-hydroxy-22,22,23,23-tetradehydrovitamin D3 / 24,25-epoxy-1alpha-hydroxy-22,22,23,23-tetradehydrocholecalciferol)": ["C27H38O3", "Sterol Lipids [ST] with formula: C27H38O3"],
        "LMST03020600 ((23R)-1alpha-hydroxy-25,27-didehydrovitamin D3 26,23-lactone); LMST03020599 ((23S)-1alpha-hydroxy-25,27-didehydrovitamin D3 26,23-lactone)": ["C27H38O4", "Sterol Lipids [ST] with formula: C27H38O4"],
        "LMST05010031 (11-Hydroxyprogesterone 11-glucuronide)": ["C27H38O9", "Sterol Lipids [ST] with formula: C27H38O9"],
        "LMST03020098 ((22E)-(25R)-26,26,26-trifluoro-1alpha,25-dihydroxy-22,23-didehydrovitamin D3 / (22E)-(25R)-26,26,26-trifluoro-1alpha,25-dihydroxy-22,23-didehydrocholecalciferol); LMST03020099 ((22E)-(25S)-26,26,26-trifluoro-1alpha,25-dihydroxy-22,23-didehydrovitamin D3 / (22E)-(25S)-26,26,26-trifluoro-1alpha,25-dihydroxy-22,23-didehydrocholecalciferol)": ["C27H39F3O3", "Sterol Lipids [ST] with formula: C27H39F3O3"],
        "LMST03020100 (25-hydroxy-16,17,23,24-tetradehydrovitamin D3 / 25-hydroxy-16,17,23,24-tetradehydrocholecalciferol); LMST03020101 ((23Z)-25-hydroxy-16,17,23,24-tetradehydrovitamin D3 / (23Z)-25-hydroxy-16,17,23,24-tetradehydrocholecalciferol); LMST03020102 (25-hydroxy-23,23,24,24-tetradehydrovitamin D3 / 25-hydroxy-23,23,24,24-tetradehydrocholecalciferol); LMST03020605 (calicoferol A)": ["C27H40O2", "Sterol Lipids [ST] with formula: C27H40O2"],
        "LMST03020103 (1alpha-hydroxy-24-oxo-26,27-cyclovitamin D3 / 1alpha-hydroxy-24-oxo-26,27-cyclocholecalciferol); LMST03020104 ((22E)-25-hydroxy-24-oxo-22,23-didehydrovitamin D3 / (22E)-25-hydroxy-24-oxo-22,23-didehydrocholecalciferol); LMST03020105 ((22E)-(24R)-1alpha,24-dihydroxy-26,27-cyclo-22,23-didehydrovitamin D3 / (22E)-(24R)-1alpha,24-dihydroxy-26,27-cyclo-22,23-didehydrocholecalciferol); LMST03020106 ((22E)-(24S)-1alpha,24-dihydroxy-26,27-cyclo-22,23-didehydrovitamin D3 / (22E)-(24S)-1alpha,24-dihydroxy-26,27-cyclo-22,23-didehydrocholecalciferol / Calcipotriol); LMST03020107 ((22E)-(24R)-1alpha,24-dihydroxy-26,27-cyclo-22,23-didehydro-20-epivitamin D3 / (22E)-(24R)-1alpha,24-dihydroxy-26,27-cyclo-22,23-didehydro-20-epicholecalciferol); LMST03020108 ((22E)-(24S)-1alpha,24-dihydroxy-26,27-cyclo-22,23-didehydro-20-epivitamin D3 / (22E)-(24S)-1alpha,24-dihydroxy-26,27-cyclo-22,23-didehydro-20-epicholecalciferol); LMST03020109 ((23E)-1alpha,25-dihydroxy-16,17,23,24-tetradehydrovitamin D3 / (23E)-1alpha,25-dihydroxy-16,17,23,24-tetradehydrocholecalciferol); LMST02020074 (Testosterone cypionate); LMST03020113 (1alpha,25-dihydroxy-23,23,24,24-tetradehydrovitamin D3 / 1alpha,25-dihydroxy-23,23,24,24-tetradehydrocholecalciferol); LMST03020112 ((23S)-1alpha,25-dihydroxy-22,23,23,24-tetradehydrovitamin D3 / (23S)-1alpha,25-dihydroxy-22,23,23,24-tetradehydrocholecalciferol); LMST03020111 ((23R)-1alpha,25-dihydroxy-22,23,23,24-tetradehydrovitamin D3 / (23R)-1alpha,25-dihydroxy-22,23,23,24-tetradehydrocholecalciferol); LMST03020110 ((23Z)-1alpha,25-dihydroxy-16,17,23,24-tetradehydrovitamin D3 / (23Z)-1alpha,25-dihydroxy-16,17,23,24-tetradehydrocholecalciferol); LMST03020114 ((22E,24E)-1alpha,26a-dihydroxy-22,23,24,25-tetradehydro-26a-homo-27-norvitamin D3 / (22E,24E)-1alpha,26a-dihydroxy-22,23,24,25-tetradehydro-26a-homo-27-norcholecalciferol)": ["C27H40O3", "Sterol Lipids [ST] with formula: C27H40O3"],
        "LMST03020117 ((23R,25S)-25-hydroxyvitamin D3 26,23-lactone / (23R,25S)-25-hydroxycholecalciferol 26,23-lactone); LMST03020116 ((23S,25R)-25-hydroxyvitamin D3 26,23-lactone / (23S,25R)-25-hydroxycholecalciferol 26,23-lactone); LMST03020115 ((23R,25R)-25-hydroxyvitamin D3 26,23-lactone / (23R,25R)-25-hydroxycholecalciferol 26,23-lactone); LMST03020119 ((22E)-(24R,25R)-25,26-epoxy-1alpha,24-dihydroxy-22,23-didehydrovitamin D3 / (22E)-(24R,25R)-25,26-epoxy-1alpha,24-dihydroxy-22,23-didehydrocholecalciferol); LMST03020118 ((23S,25S)-25-hydroxyvitamin D3 26,23-lactone / (23S,25S)-25-hydroxycholecalciferol 26,23-lactone); LMST03020608 (1,25-Dihydroxy-24-oxo-16-ene-vitamin D3); LMST03020120 ((22E)-(24S,25S)-25,26-epoxy-1alpha,24-dihydroxy-22,23-didehydrovitamin D3 / (22E)-(24S,25S)-25,26-epoxy-1alpha,24-dihydroxy-22,23-didehydrocholecalciferol)": ["C27H40O4", "Sterol Lipids [ST] with formula: C27H40O4"],
        "LMST03020124 ((23R,25S)-1alpha,25-dihydroxyvitamin D3 26,23-lactone / (23R,25S)-1alpha,25-dihydroxycholecalciferol 26,23-lactone); LMST03020125 ((23S,25S)-1alpha,25-dihydroxyvitamin D3 26,23-lactone / (23S,25S)-1alpha,25-dihydroxycholecalciferol 26,23-lactone); LMST03020122 ((23R,25R)-1alpha,25-dihydroxyvitamin D3 26,23-lactone / (23R,25R)-1alpha,25-dihydroxycholecalciferol 26,23-lactone); LMST03020123 ((23S,25R)-1alpha,25-dihydroxyvitamin D3 26,23-lactone / (23S,25R)-1alpha,25-dihydroxycholecalciferol 26,23-lactone); LMST03020121 ((23S,25R)-25-hydroxyvitamin D3 26,23-peroxylactone / (23S,25R)-25-hydroxycholecalciferol 26,23-peroxylactone)": ["C27H40O5", "Sterol Lipids [ST] with formula: C27H40O5"],
        "LMST02030129 (Hydrocortisone caproate)": ["C27H40O6", "Sterol Lipids [ST] with formula: C27H40O6"],
        "LMST03020131 (26,26,26-trifluoro-25-hydroxyvitamin D3 / 26,26,26-trifluoro-25-hydroxycholecalciferol)": ["C27H41F3O2", "Sterol Lipids [ST] with formula: C27H41F3O2"],
        "LMST03020133 ((25S)-26,26,26-trifluoro-1alpha,25-dihydroxyvitamin D3 / (25S)-26,26,26-trifluoro-1alpha,25-dihydroxycholecalciferol); LMST03020132 ((25R)-26,26,26-trifluoro-1alpha,25-dihydroxyvitamin D3 / (25R)-26,26,26-trifluoro-1alpha,25-dihydroxycholecalciferol)": ["C27H41F3O3", "Sterol Lipids [ST] with formula: C27H41F3O3"],
        "LMST03020128 ((20S,24R)-20-fluoro-1alpha,24-dihydroxy-26,27-cyclovitamin D3 / (20S,24R)-20-fluoro-1alpha,24-dihydroxy-26,27-cyclocholecalciferol); LMST03020129 ((20R,24S)-20-fluoro-1alpha,24-dihydroxy-26,27-cyclovitamin D3 / (20R,24S)-20-fluoro-1alpha,24-dihydroxy-26,27-cyclocholecalciferol); LMST03020127 ((20R,24R)-20-fluoro-1alpha,24-dihydroxy-26,27-cyclovitamin D3 / (20R,24R)-20-fluoro-1alpha,24-dihydroxy-26,27-cyclocholecalciferol); LMST03020130 ((20S,24S)-20-fluoro-1alpha,24-dihydroxy-26,27-cyclovitamin D3 / (20S,24S)-20-fluoro-1alpha,24-dihydroxy-26,27-cyclocholecalciferol)": ["C27H41FO3", "Sterol Lipids [ST] with formula: C27H41FO3"],
        "LMST03020667 (1alpha,25-Difluorovitamin D3); LMST03020135 ((5Z)-4,4-difluorovitamin D3 / (5Z)-4,4-difluorocholecalciferol); LMST03020134 (4,4-difluorovitamin D3 / 4,4-difluorocholecalciferol); LMST03020136 (1alpha,25-difluorovitamin D3 / 1alpha,25-difluorocholecalciferol)": ["C27H42F2O", "Sterol Lipids [ST] with formula: C27H42F2O"],
        "LMST03020140 (23,23-difluoro-25-hydroxyvitamin D3 / 23,23-difluoro-25-hydroxycholecalciferol); LMST03020141 (24,24-difluoro-25-hydroxyvitamin D3 / 24,24-difluoro-25-hydroxycholecalciferol); LMST03020139 ((5Z)-4,4-difluoro-1alpha--hydroxyvitamin D3 / (5Z)-4,4-difluoro-1alpha--hydroxycholecalciferol); LMST03020138 (4,4-difluoro-1alpha-hydroxyvitamin D3 / 4,4-difluoro-1alpha-hydroxycholecalciferol); LMST03020137 (24,24-difluoro-1alpha-hydroxyvitamin D3 / 24,24-difluoro-1alpha-hydroxycholecalciferol)": ["C27H42F2O2", "Sterol Lipids [ST] with formula: C27H42F2O2"],
        "LMST03020144 (23,23-difluoro-1alpha,25-dihydroxyvitamin D3 / 23,23-difluoro-1alpha,25-dihydroxycholecalciferol); LMST03020145 (24,24-difluoro-1alpha,25-dihydroxyvitamin D3 / 24,24-difluoro-1alpha,25-dihydroxycholecalciferol); LMST03020142 (4,4-difluoro-1alpha,25-dihydroxyvitamin D3 / 4,4-difluoro-1alpha,25-dihydroxycholecalciferol); LMST03020143 ((5Z)-4,4-difluoro-1alpha,25-dihydroxyvitamin D3 / (5Z)-4,4-difluoro-1alpha,25-dihydroxycholecalciferol)": ["C27H42F2O3", "Sterol Lipids [ST] with formula: C27H42F2O3"],
        "LMST03020146 ((6RS)-6,19-epidioxy-24,24-difluoro-25-hydroxy-6,19-dihydrovitamin D3 / (6RS)-6,19-epidioxy-24,24-difluoro-25-hydroxy-6,19-dihydrocholecalciferol)": ["C27H42F2O4", "Sterol Lipids [ST] with formula: C27H42F2O4"],
        "LMST03020665 (24-Dehydroprevitamin D3); LMST03020664 (25-Dehydrovitamin D3); LMST01010058; LMST03020147 (24,25-didehydrovitamin D3 / 24,25-didehydrocholecalciferol); LMST01010153 (Zymosterone); LMST01010121 (7-dehydro-desmosterol); LMST01010059; LMST01010254; LMST01010168 (Zymosterone)": ["C27H42O", "Sterol Lipids [ST] with formula: C27H42O"],
        "LMST03020148 ((22E)-1alpha-hydroxy-22,23-didehydrovitamin D3 / (22E)-1alpha-hydroxy-22,23-didehydrocholecalciferol); LMST03020149 ((22E)-1beta-hydroxy-22,23-didehydrovitamin D3 / (22E)-1beta-hydroxy-22,23-didehydrocholecalciferol); LMST03020158 (1-oxoprevitamin D3 / 1-oxoprecholecalciferol); LMST03020157 (calicoferol E); LMST03020156 (23,24-didehydro-25-hydroxyvitamin D3 / 23,24-didehydro-25-hydroxycholecalciferol); LMST03020155 (25-hydroxy-16,17-didehydrovitamin D3 / 25-hydroxy-16,17-didehydrocholecalciferol); LMST03020154 (1alpha,25-dihydroxy-9,11-didehydro-3-deoxyvitamin D3 / 1alpha,25-dihydroxy-9,11-didehydro-3-deoxycholecalciferol); LMST03020153 (1alpha-hydroxy-24,25-didehydrovitamin D3 / 1alpha-hydroxy-24,25-didehydrocholecalciferol); LMST03020151 ((22Z)-1beta-hydroxy-22,23-didehydrovitamin D3 / (22Z)-1beta-hydroxy-22,23-didehydrocholecalciferol); LMST03020150 ((22Z)-1alpha-hydroxy-22,23-didehydrovitamin D3 / (22Z)-1alpha-hydroxy-22,23-didehydrocholecalciferol); LMST01010272 (7-oxo-cholestenone)": ["C27H42O2", "Sterol Lipids [ST] with formula: C27H42O2"],
        "LMST03020180 (calicoferol B); LMST03020159 (1alpha-hydroxy-22-oxovitamin D3 / 1alpha-hydroxy-22-oxocholecalciferol); LMST03020178 ((22E)-(24R)-24,25-dihydroxy-22,23-didehydrovitamin D3 / (22E)-(24R)-24,25-dihydroxy-22,23-didehydrocholecalciferol); LMST03020168 ((22E)-(24R)-1alpha,24-dihydroxy-22,23-didehydrovitamin D3 / (22E)-(24R)-1alpha,24-dihydroxy-22,23-didehydrocholecalciferol); LMST03020169 ((22E)-(24S)-1alpha,24-dihydroxy-22,23-didehydrovitamin D3 / (22E)-(24S)-1alpha,24-dihydroxy-22,23-didehydrocholecalciferol); LMST03020162 (24,25-epoxy-1alpha-hydroxy-23,23-dimethyl-26,27-dinorvitamin D3 / 24,25-epoxy-1alpha-hydroxy-23,23-dimethyl-26,27-dinorcholecalciferol); LMST03020163 (25-hydroxy-23-oxovitamin D3 / 25-hydroxy-23-oxocholecalciferol); LMST03020160 (24,25-epoxy-1alpha-hydroxyvitamin D3 / 24,25-epoxy-1alpha-hydroxycholecalciferol); LMST03020161 (25,26-epoxy-1alpha-hydroxyvitamin D3 / 25,26-epoxy-1alpha-hydroxycholecalciferol); LMST03020166; LMST03020167 ((23S)-1alpha,23-dihydroxy-25,26-didehydrovitamin D3 / (23S)-1alpha,23-dihydroxy-25,26-didehydrocholecalciferol); LMST03020164 (25-hydroxy-24-oxovitamin D3 / 25-hydroxy-24-oxocholecalciferol); LMST03020165 (25-hydroxy-1-oxo-3-epiprevitamin D3 / 25-hydroxy-1-oxo-3-epiprecholecalciferol); LMST03020175 (1beta,25-dihydroxy-6,7-didehydro-3-epiprevitamin D3 / 1beta,25-dihydroxy-6,7-didehydro-3-epiprecholecalciferol); LMST03020174 (1alpha,25-dihydroxy-6,7-didehydroprevitamin D3 / 1alpha,25-dihydroxy-6,7-didehydroprecholecalciferol); LMST03020177 ((17S,20R)-1alpha,25-dihydroxy-17,20-methano-21-norvitamin D3 / (17S,20R)-1alpha,25-dihydroxy-17,20-methano-21-norcholecalciferol); LMST03020176 ((17S,20S)-1alpha,25-dihydroxy-17,20-methano-21-norvitamin D3 / (17S,20S)-1alpha,25-dihydroxy-17,20-methano-21-norcholecalciferol); LMST03020171 (1alpha,25-dihydroxy-16,17-didehydrovitamin D3 / 1alpha,25-dihydroxy-16,17-didehydrocholecalciferol); LMST03020170 (1alpha,25-dihydroxy-9,11-didehydrovitamin D3 / 1alpha,25-dihydroxy-9,11-didehydrocholecalciferol); LMST03020173 ((23E)-1alpha,25-dihydroxy-23,24-didehydrovitamin D3 / (23E)-1alpha,25-dihydroxy-23,24-didehydrocholecalciferol); LMST03020172 (1alpha,25-dihydroxy-22,23-didehydrovitamin D3 / 1alpha,25-dihydroxy-22,23-didehydrocholecalciferol); LMST03020179 ((22E)-(24S)-24,25-dihydroxy-22,23-didehydrovitamin D3 / (22E)-(24S)-24,25-dihydroxy-22,23-didehydrocholecalciferol); LMST03020639 (16-Dehydroepicalcitriol); LMST03020625 (18-(3-Hydroxy-3-methylbutyl)-20-methyl-9,10-secopregna-5,7,10(19),20-tetraene-1,3-diol); LMST01010259; LMST01010257": ["C27H42O3", "Sterol Lipids [ST] with formula: C27H42O3"],
        "LMST01090001 (Nuatigenin); LMST03020188 ((23S,25R)-25-hydroxyvitamin D3 26,23-lactol / (23S,25R)-25-hydroxycholecalciferol 26,23-lactol); LMST03020189 ((22E)-(24R)-1alpha,24,25-trihydroxy-22,23-didehydrovitamin D3 / (22E)-(24R)-1alpha,24,25-trihydroxy-22,23-didehydrocholecalciferol); LMST03020181 ((24R,25R)-25,26-epoxy-1alpha,24-dihydroxyvitamin D3 / (24R,25R)-25,26-epoxy-1alpha,24-dihydroxycholecalciferol); LMST03020182 ((24R,25S)-25,26-epoxy-1alpha,24-dihydroxyvitamin D3 / (24R,25S)-25,26-epoxy-1alpha,24-dihydroxycholecalciferol); LMST03020183 ((24S,25R)-25,26-epoxy-1alpha,24-dihydroxyvitamin D3 / (24S,25R)-25,26-epoxy-1alpha,24-dihydroxycholecalciferol); LMST03020184 ((24S,25S)-25,26-epoxy-1alpha,24-dihydroxyvitamin D3 / (24S,25S)-25,26-epoxy-1alpha,24-dihydroxycholecalciferol); LMST03020186 (1alpha,25-dihydroxy-24-oxovitamin D3 / 1alpha,25-dihydroxy-24-oxocholecalciferol); LMST03020187 ((23S)-23,25-dihydroxy-24-oxovitamin D3 / (23S)-23,25-dihydroxy-24-oxocholecalciferol); LMST03020192 ((22E)-(25S)-1alpha,25,26-trihydroxy-22,23-didehydrovitamin D3 / (22E)-(25S)-1alpha,25,26-trihydroxy-22,23-didehydrocholecalciferol); LMST03020191 ((22E)-(25R)-1alpha,25,26-trihydroxy-22,23-didehydrovitamin D3 / (22E)-(25R)-1alpha,25,26-trihydroxy-22,23-didehydrocholecalciferol); LMST03020190 ((22E)-(24S)-1alpha,24,25-trihydroxy-22,23-didehydrovitamin D3 / (22E)-(24S)-1alpha,24,25-trihydroxy-22,23-didehydrocholecalciferol); LMST04030149 (7alpha-hydroxy-3-oxocholest-4-en-27-oic acid); LMST01010261; LMST01010120 (3beta-Hydroxy-5alpha,6alpha-epoxy-9-oxo-9,10-seco-5-cholest-7-en-11-al); LMST04030133; LMST03020668 (1,25-Dihydroxy-23-oxo-vitamin D3); LMST01010252": ["C27H42O4", "Sterol Lipids [ST] with formula: C27H42O4"],
        "LMST04030150 (7alpha,12alpha-dihydroxy-3-oxocholest-4-en-27-oic acid); LMST03020193 ((23S,25R)-1alpha,25-dihydroxyvitamin D3 26,23-lactol / (23S,25R)-1alpha,25-dihydroxycholecalciferol 26,23-lactol); LMST03020195 ((23S)-1alpha,23,25-trihydroxy-24-oxovitamin D3 / (23S)-1alpha,23,25-trihydroxy-24-oxocholecalciferol); LMST03020194 ((23R)-1alpha,23,25-trihydroxy-24-oxovitamin D3 / (23R)-1alpha,23,25-trihydroxy-24-oxocholecalciferol)": ["C27H42O5", "Sterol Lipids [ST] with formula: C27H42O5"],
        "LMST01010193 (shidasterone); LMST01010180 (2-dehydroecdysone); LMST01010172 (3-dehydroecdysone)": ["C27H42O6", "Sterol Lipids [ST] with formula: C27H42O6"],
        "LMST03020196 (2alpha-chloro-1beta,25-dihydroxyvitamin D3 / 2alpha-chloro-1beta,25-dihydroxycholecalciferol); LMST03020601 (2beta-chloro-1alpha,25-dihydroxyvitamin D3)": ["C27H43ClO3", "Sterol Lipids [ST] with formula: C27H43ClO3"],
        "LMST03020658 (3-Fluoro-9,10-secocholesta-5,7,10(19)-triene)": ["C27H43F", "Sterol Lipids [ST] with formula: C27H43F"],
        "LMST03020663 (25-Fluorovitamin D3); LMST03020199 ((10E)-19-fluorovitamin D3 / (10E)-19-fluorocholecalciferol); LMST03020198 ((10Z)-19-fluorovitamin D3 / (10Z)-19-fluorocholecalciferol); LMST03020197 (6-fluorovitamin D3 / 6-fluorocholecalciferol); LMST03020202 (22-fluorovitamin D3 / 22-fluorocholecalciferol); LMST03020201 ((5E,10E)-19-fluorovitamin D3 / (5E,10E)-19-fluorocholecalciferol); LMST03020200 ((5E,10Z)-19-fluorovitamin D3 / (5E,10Z)-19-fluorocholecalciferol)": ["C27H43FO", "Sterol Lipids [ST] with formula: C27H43FO"],
        "LMST03020210 (24-fluoro-25-hydroxyvitamin D3 / 24-fluoro-25-hydroxycholecalciferol); LMST03020209 (1alpha-fluoro-25-hydrovitamin D3 / 1alpha-fluoro-25-hydrocholecalciferol); LMST03020208 ((24R)-25-fluoro-24-hydroxyvitamin D3 / (24R)-25-fluoro-24-hydroxycholecalciferol); LMST03020203 ((5Z,10Z)-19-fluoro-1alpha-hydroxyvitamin-D3 / (5Z,10Z)-19-fluoro-1alpha-hydroxycholecalciferol); LMST03020207 (25-fluoro-1alpha-hydroxyvitamin D3 / 25-fluoro-1alpha-hydroxycholecalciferol); LMST03020206 ((5E,10E)-19-fluoro-1alpha-hydroxyvitamin-D3 / (5E,10E)-19-fluoro-1alpha-hydroxycholecalciferol); LMST03020205 ((5E,10Z)-19-fluoro-1alpha-hydroxyvitamin-D3 / (5E,10Z)-19-fluoro-1alpha-hydroxycholecalciferol); LMST03020204 ((5Z,10E)-19-fluoro-1alpha-hydroxyvitamin-D3 / (5Z,10E)-19-fluoro-1alpha-hydroxycholecalciferol)": ["C27H43FO2", "Sterol Lipids [ST] with formula: C27H43FO2"],
        "LMST03020211 ((24R)-25-fluoro-1alpha,24-dihydroxyvitamin D3 / (24R)-25-fluoro-1alpha,24-dihydroxycholecalciferol); LMST03020212 ((10Z)-19-fluoro-1alpha,25-dihydroxyvitamin D3 / (10Z)-19-fluoro-1alpha,25-dihydroxycholecalciferol); LMST03020213 ((10E)-19-fluoro-1alpha,25-dihydroxyvitamin D3 / (10E)-19-fluoro-1alpha,25-dihydroxycholecalciferol); LMST03020214 ((5E,10Z)-19-fluoro-1alpha,25-dihydroxyvitamin D3 / (5E,10Z)-19-fluoro-1alpha,25-dihydroxycholecalciferol); LMST03020215 ((5E,10E)-19-fluoro-1alpha,25-dihydroxyvitamin D3 / (5E,10E)-19-fluoro-1alpha,25-dihydroxycholecalciferol); LMST03020216 (24R-fluoro-1alpha,25-dihydroxyvitamin D3 / 24R-fluoro-1alpha,25-dihydroxycholecalciferol); LMST03020666 (1,24-Dihydroxy-25-fluorovitamin D3); LMST03020602 (2beta-fluoro-1alpha,25-dihydroxyvitamin D3)": ["C27H43FO3", "Sterol Lipids [ST] with formula: C27H43FO3"],
        "LMST01150007 (Solanidine)": ["C27H43NO", "Sterol Lipids [ST] with formula: C27H43NO"],
        "LMST01150011 (25-iso-etioline); LMST01150005 (tomatidinol); LMST01150004 (Solasodine); LMST01150009 (Leptinidine); LMST01150008 (Etioline)": ["C27H43NO2", "Sterol Lipids [ST] with formula: C27H43NO2"],
        "LMST03010007 (1alpha,25-dihydroxy-24-oxo-23-azavitamin D2 / 1alpha,25-dihydroxy-24-oxo-23-azaergocalciferol)": ["C27H43NO4", "Sterol Lipids [ST] with formula: C27H43NO4"],
        "LMST03020618 (3-Deoxyvitamin D3)": ["C27H44", "Sterol Lipids [ST] with formula: C27H44"],
        "LMST03020677 (3-Deoxy-3-azido-25-hydroxyvitamin D3)": ["C27H44N3O", "Sterol Lipids [ST] with formula: C27H44N3O"],
        "LMST03020648 (3-epi-vitamin D3); LMST01010016 (Desmosterol); LMST01010015 (Cholestenone); LMST03020219 (3-epivitamin D3 / 3-epicholecalciferol); LMST01010066 (Zymosterol); LMST03020217 (1alpha-hydroxy-3-deoxyvitamin D3 / 1alpha-hydroxy-3-deoxycholecalciferol); LMST03020221 ((5E)-3-epivitamin D3 / (5E)-3-epicholecalciferol); LMST03020220 ((5E)-vitamin D3 / (5E)-cholecalciferol / (5E)-calciol); LMST03020223 (tachysterol3); LMST03020222 (previtamin D3 / precholecalciferol / (6Z)-tacalciol); LMST03020225 ((5E)-isovitamin D3 / (5E)-isocholecalciferol); LMST03020224 (isotachysterol3); LMST03020228; LMST03020230; LMST03020227 (toxisterol3 E1); LMST01010095; LMST01010239; LMST03020226 (toxisterol3 D1); LMST03020229; LMST03020001 (Vitamin D3); LMST01010206 (5alpha-cholesta-7,24-dien-3beta-ol); LMST03020619 (3-Deoxy-25-hydroxyvitamin D3); LMST01010069 (7-dehydrocholesterol); LMST01010248 (3-ketocholesterol); LMST01010247 (Lumisterol 3); LMST01010242 (8-Dehydrocholesterol)": ["C27H44O", "Sterol Lipids [ST] with formula: C27H44O"],
        "LMST03020646 (25-Hydroxy-3-epivitamin D3); LMST03020661 (1alpha-Hydroxypregnacalciferol); LMST01010012 (24,25-epoxy-cholesterol); LMST03020678 (22-Hydroxyvitamin D3); LMST03020672 (7-Dehydrocholesterol 5,6-oxide); LMST03020247 (25-hydroxy-14-epivitamin D3 / 25-hydroxy-14-epicholecalciferol); LMST03020246 (25-hydroxyvitamin D3 / 25-hydroxycholecalciferol / calcidiol); LMST03020245 ((24S)-24-hydroxyvitamin D3 / (24S)-24-hydroxycholecalciferol); LMST03020244 ((24R)-24-hydroxyvitamin D3 / (24R)-24-hydroxycholecalciferol); LMST03020243 ((22S)-22-hydroxyvitamin D3 / (22S)-22-hydroxycholecalciferol); LMST03020242 (astrogorgiadiol B); LMST03020241 (1alpha,25-dihydroxy-3-deoxyvitamin D3 / 1alpha,25-dihydroxy-3-deoxycholecalciferol); LMST03020240 (2beta-hydroxyvitamin D3 / 2beta-hydroxycholecalciferol); LMST01010049 (7-oxo-cholesterol); LMST03030005; LMST03020236 (1beta-hydroxy-3-epivitamin D3 / 1beta-hydroxy-3-epicholecalciferol); LMST03020237 ((5E)-1beta-hydroxyvitamin D3 / (5E)-1beta-hydroxycholecalciferol); LMST03020234 ((5E)-1alpha-hydroxy-3-epivitamin D3 / (5E)-1alpha-hydroxy-3-epicholecalciferol); LMST03020235 (1beta-hydroxyvitamin D3 / 1beta-hydroxycholecalciferol); LMST03020232 (1alpha-hydroxy-3-epivitamin D3 / 1alpha-hydroxy-3-epicholecalciferol); LMST03020233 ((5E)-1alpha-hydroxyvitamin D3 / (5E)-1alpha-hydroxycholecalciferol); LMST03020231 (1alpha-hydroxyvitamin D3 / 1alpha-hydroxycholecalciferol); LMST03020238 ((5E)-1beta-hydroxy-3-epivitamin D3 / (5E)-1beta-hydroxy-3-epicholecalciferol); LMST03020239 (2alpha-hydroxyvitamin D3 / 2alpha-hydroxycholecalciferol); LMST01010133 (24-oxocholesterol); LMST01010269 (15-ketocholestene); LMST01010122 (Cholesta-5,7-diene-1,3-diol); LMST01010271 (3-oxo-7alpha-hydroxycholesterol); LMST04030123; LMST04030124; LMST04030126; LMST03020655 (5,6-trans-25-Hydroxyvitamin D3); LMST03020657 (1-Hydroxyprevitamin D3); LMST03020669 (11-Hydroxyvitamin D3); LMST01010253": ["C27H44O2", "Sterol Lipids [ST] with formula: C27H44O2"],
        "LMST04030107 (7alpha,25-dihydroxycholestenone); LMST03020254 (1alpha,18-dihydroxyvitamin D3 / 1alpha,18-dihydroxycholecalciferol); LMST03020256 ((24R)-1alpha,24-dihydroxyvitamin D3 / (24R)-1alpha,24-dihydroxycholecalciferol); LMST03020257 ((24S)-1alpha,24-dihydroxyvitamin D3 / (24S)-1alpha,24-dihydroxycholecalciferol); LMST03020252; LMST03020253; LMST03020258 (1alpha,25-dihydroxyvitamin D3 / 1alpha,25-dihydroxycholecalciferol / calcitriol); LMST03020259 (1alpha,25-dihydroxy-3-epivitamin D3 / 1alpha,25-dihydroxy-3-epicholecalciferol); LMST04030170 (7alpha,24-dihydroxycholest-4-en-3-one); LMST03020249 ((6S)-6,19-epidioxy-6,19-dihydrovitamin D3 / (6S)-6,19-epidioxy-6,19-dihydrocholecalciferol); LMST03020248 ((6R)-6,19-epidioxy-6,19-dihydrovitamin D3 / (6R)-6,19-epidioxy-6,19-dihydrocholecalciferol); LMST03020272 ((23S)-23,25-dihydroxyvitamin D3 / (23S)-23,25-dihydroxycholecalciferol); LMST03020273 ((24R)-24,25-dihydroxyvitamin D3 / (24R)-24,25-dihydroxycholecalciferol); LMST03020270 ((22S)-22,25-dihydroxyvitamin D3 / (22S)-22,25-dihydroxycholecalciferol); LMST03020271 ((23R)-23,25-dihydroxyvitamin D3 / (23R)-23,25-dihydroxycholecalciferol); LMST03020276 ((25S)-25,26-dihydroxyvitamin D3 / (25S)-25,26-dihydroxycholecalciferol); LMST03020274 ((24S)-24,25-dihydroxyvitamin D3 / (24S)-24,25-dihydroxycholecalciferol); LMST03020275 ((25R)-25,26-dihydroxyvitamin D3 / (25R)-25,26-dihydroxycholecalciferol); LMST03020269 ((22R)-22,25-dihydroxyvitamin D3 / (22R)-22,25-dihydroxycholecalciferol); LMST03020268 (18,25-dihydroxyvitamin D3 / 18,25-dihydroxycholecalciferol); LMST04030072 (Cholestenoic acid); LMST01080005 ((25R)-5beta-spirostan-3beta-ol); LMST01080007 ((25S)-5beta-spirostan-3beta-ol); LMST01010179 (2,22,25-trideoxyecdysone); LMST03020552 (1alpha,25-dihydroxy-2-methylene-19-norvitamin D3 / 1alpha,25-dihydroxy-2-methylene-19-norcholecalciferol); LMST03020557 (1alpha,25-dihydroxy-2-methylene-19-nor-20-epivitamin D3 / 1alpha,25-dihydroxy-2-methylene-19-nor-20-epicholecalciferol); LMST04030180 (3beta,27-dihydroxy-5-cholesten-7-one); LMST04030163 (paricalcitol); LMST03020265 ((5E)-1alpha,25-dihydroxyvitamin D3 / (5E)-1alpha,25-dihydroxycholecalciferol); LMST03020267 (1beta,25-dihydroxy-3-epivitamin D3 / 1beta,25-dihydroxy-3-epicholecalciferol); LMST03020261 (1alpha,25-dihydroxy-14-epiprevitamin D3 / 1alpha,25-dihydroxy-14-epiprecholecalciferol); LMST03020260 (1alpha,25-dihydroxy-14-epivitamin D3 / 1alpha,25-dihydroxy-14-epicholecalciferol); LMST03020262 (1alpha,25-dihydroxy-20-epivitamin D3 / 1alpha,25-dihydroxy-20-epicholecalciferol); LMST04030114; LMST04030147 (7alpha,27-dihydroxycholestenone); LMST04030145; LMST01010260; LMST03020266 (1beta,25-dihydroxyvitamin D3 / 1beta,25-dihydroxycholecalciferol); LMST03020689; LMST01010249; LMST01010100 (Dormatinone); LMST04030157 (7alpha,26-dihydroxycholest-4-en-3-one); LMST03020660 (1alpha,25-Dihydroxy-previtamin D3); LMST01010255; LMST01010256": ["C27H44O3", "Sterol Lipids [ST] with formula: C27H44O3"],
        "LMST03020250 ((6R)-vitamin D3 6,19-sulfur dioxide adduct / (6R)-cholecalciferol 6,19-sulfur dioxide adduct); LMST03020251 ((6S)-vitamin D3 6,19-sulfur dioxide adduct / (6S)-cholecalciferol 6,19-sulfur dioxide adduct); LMST03020263 (1alpha,25-dihydroxy-24a-homo-22-thiavitamin D3 / 1alpha,25-dihydroxy-24a-homo-22-thiacholecalciferol); LMST03020264 (1alpha,25-dihydroxy-24a-homo-22-thia-20-epivitamin D3 / 1alpha,25-dihydroxy-24a-homo-22-thia-20-epicholecalciferol)": ["C27H44O3S", "Sterol Lipids [ST] with formula: C27H44O3S"],
        "LMST04030105; LMST04030171 (7alpha,12alpha,24-trihydroxycholest-4-en-3-one); LMST04030059; LMST03020277 ((6R)-6,19-epidioxy-1alpha-hydroxy-6,19-dihydrovitamin D3 / (6R)-6,19-epidioxy-1alpha-hydroxy-6,19-dihydrocholecalciferol); LMST03020278 ((6S)-6,19-epidioxy-1alpha-hydroxy-6,19-dihydrovitamin D3 / (6S)-6,19-epidioxy-1alpha-hydroxy-6,19-dihydrocholecalciferol); LMST01080002 ((25R)-5beta-spirostan-1beta,3alpha-diol); LMST03020686 (calcitetrol); LMST04030060; LMST03020300 (24,25,26-trihydroxyvitamin D3 / 24,25,26-trihydroxycholecalciferol); LMST04030148 (3beta,7alpha-dihydroxycholest-5-en-27-oic acid); LMST04030142; LMST04030143; LMST03020290 ((20S)-1alpha,20,25-trihydroxyvitamin D3 / (20S)-1alpha,20,25-trihydroxycholecalciferol); LMST03020291 ((22R)-1alpha,22,25-trihydroxy-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-20-epicholecalciferol); LMST03020292 ((23S)-1alpha,23,25-trihydroxyvitamin D3 / (23S)-1alpha,23,25-trihydroxycholecalciferol); LMST03020294 ((24S)-1alpha,24,25-trihydroxyvitamin D3 / (24S)-1alpha,24,25-trihydroxycholecalciferol); LMST03020295 ((5E)-(25R)-1alpha,25,26-trihydroxyvitamin D3 / (5E)-(25R)-1alpha,25,26-trihydroxycholecalciferol); LMST03020296 ((25S)-1alpha,25,26-trihydroxyvitamin D3 / (25S)-1alpha,25S,26-trihydroxycholecalciferol); LMST03020297 (22,24,25-trihydroxyvitamin D3 / 22,24,25-trihydroxycholecalciferol); LMST03020298 ((23S)-23,24,25-trihydroxyvitamin D3 / (23S)-23,24,25-trihydroxycholecalciferol); LMST03020299 ((23S,25R)-23,25,26-trihydroxyvitamin D3 / (23S,25R)-23,25,26-trihydroxycholecalciferol); LMST04030158 (7alpha,12alpha,26-trihydroxycholest-4-en-3-one); LMST03020283 (1alpha,25-dihydroxy-24a-homo-22-oxavitamin D3 / 1alpha,25-dihydroxy-24a-homo-22-oxacholecalciferol); LMST03020282 ((6S)-6,19-epidioxy-25-hydroxy-6,19-dihydrovitamin D3 / (6S)-6,19-epidioxy-25-hydroxy-6,19-dihydrocholecalciferol); LMST03020281 ((6R)-6,19-epidioxy-25-hydroxy-6,19-dihydrovitamin D3 / (6R)-6,19-epidioxy-25-hydroxy-6,19-dihydrocholecalciferol); LMST03020287 (1alpha,11alpha,25-trihydroxyvitamin D3 / 1alpha,11alpha,25-trihydroxycholecalciferol); LMST03020286 (1alpha,2,25-trihydroxyvitamin D3 / 1alpha,2,25-trihydroxycholecalciferol); LMST03020285 (1alpha,25-dihydroxy-10,19-methano-23-oxavitamin D3 / 1alpha,25-dihydroxy-10,19-methano-23-oxacholecalciferol); LMST03020284 (1alpha,25-dihydroxy-24a-homo-22-oxa-20-epivitamin D3 / 1alpha,25-dihydroxy-24a-homo-22-oxa-20-epicholecalciferol); LMST03020289 (1alpha,18,25-trihydroxyvitamin D3 / 1alpha,18,25-trihydroxycholecalciferol); LMST03020288 (1alpha,11beta,25-trihydroxyvitamin D3 / 1alpha,11beta,25-trihydroxycholecalciferol); LMST03020388 ((23R)-1alpha,23,25-trihydroxyvitamin D3 / (23R)-1alpha,23,25-trihydroxycholecalciferol); LMST04030132; LMST01010258; LMST01010251; LMST01010250": ["C27H44O4", "Sterol Lipids [ST] with formula: C27H44O4"],
        "LMST03020279 ((6R)-25-hydroxyvitamin D3 6,19-sulfur dioxide adduct / (6R)-25-hydroxycholecalciferol 6,19-sulfur dioxide adduct); LMST03010067 (7-Dehydrocholesterol-3-sulfate ester); LMST03020280 ((6S)-25-hydroxyvitamin D3 6,19-sulfur dioxide adduct / (6S)-25-hydroxycholecalciferol 6,19-sulfur dioxide adduct); LMST03020652 (Vitamin D3 sulfoconjugate)": ["C27H44O4S", "Sterol Lipids [ST] with formula: C27H44O4S"],
        "LMST03020302 ((6R)-6,19-epidioxy-1alpha,25-dihydroxy-6,19-dihydrovitamin D3 / (6R)-6,19-epidioxy-1alpha,25-dihydroxy-6,19-dihydrocholecalciferol); LMST03020301 ((24R)-6,19-epidioxy-1alpha,24-dihydroxy-6,19-dihydrovitamin D3 / (24R)-6,19-epidioxy-1alpha,24-di hydroxy-6,19-dihydrocholecalciferol); LMST03020306 ((23S,25R)-1alpha,23,25,26-tetrahydroxyvitamin D3 / (23S,25R)-1alpha,23,25,26-tetrahydroxycholecalciferol); LMST03020674 (1alpha,23R,25S,26-Tetrahydroxyvitamin D3); LMST04030050; LMST04030051; LMST04030052; LMST04030049; LMST04030074; LMST01010182 (2-deoxyecdysone); LMST01010187 (25-deoxyecdysone); LMST01080001 (Porrigenin A); LMST01080004 (digitogenin); LMST04030065; LMST04030064; LMST04030129": ["C27H44O5", "Sterol Lipids [ST] with formula: C27H44O5"],
        "LMST03020303 ((6R)-1alpha,25-dihydroxyvitamin D3 6,19-sulfur dioxide adduct / (6R)-1alpha,25-dihydroxycholecalciferol 6,19-sulfur dioxide adduct); LMST03020304 ((6S)-1alpha,25-dihydroxyvitamin D3 6,19-sulfur dioxide adduct / (6S)-1alpha,25-dihydroxycholecalciferol 6,19-sulfur dioxide adduct); LMST03020305 ((6RS,24R)-24,25-dihydroxyvitamin D3 6,19-sulfur dioxide adduct / (6RS,24R)-24,25-dihydroxycholecalciferol 6,19-sulfur dioxide adduct)": ["C27H44O5S", "Sterol Lipids [ST] with formula: C27H44O5S"],
        "LMST01010195 (ponasterone A); LMST01010210 (ecdysone); LMST04030128": ["C27H44O6", "Sterol Lipids [ST] with formula: C27H44O6"],
        "LMST01010194 (inokosterone); LMST01010186 (22-deoxy-20,21-dihydroxyecdysone); LMST01010209 (20-hydroxyecdysone)": ["C27H44O7", "Sterol Lipids [ST] with formula: C27H44O7"],
        "LMST01010198 (polypodine B); LMST01010184 (20,26-dihydroxyecdysone); LMST05010038; LMST05010049 (Pregnanediol-3-glucuronide)": ["C27H44O8", "Sterol Lipids [ST] with formula: C27H44O8"],
        "LMST01010177 ((24R)-11alpha,20,24-trihydroxyecdysone); LMST01010178 ((25R)-11alpha,20,26-trihydroxyecdysone); LMST01010158 ((25S)-11alpha,20,26-trihydroxyecdysone)": ["C27H44O9", "Sterol Lipids [ST] with formula: C27H44O9"],
        "LMST01150001 (Demissidine)": ["C27H45NO", "Sterol Lipids [ST] with formula: C27H45NO"],
        "LMST01150010 (Teinemine); LMST01150012 (22-iso-teinemine); LMST01150014 (tomatidine); LMST01150003 (tomatidine); LMST01150002 (soladulcidine)": ["C27H45NO2", "Sterol Lipids [ST] with formula: C27H45NO2"],
        "LMST01010185 (20-hydroxyecdysone 22-phosphate)": ["C27H45O10P", "Sterol Lipids [ST] with formula: C27H45O10P"],
        "LMST01010183 (2-deoxyecdysone 22-phosphate)": ["C27H45O8P", "Sterol Lipids [ST] with formula: C27H45O8P"],
        "LMST01010181 (2-deoxy-20-hydroxyecdysone 22-phosphate)": ["C27H45O9P", "Sterol Lipids [ST] with formula: C27H45O9P"],
        "LMST01010243": ["C27H46", "Sterol Lipids [ST] with formula: C27H46"],
        "LMST03020307 (dihydrotachysterol3 / (5E)-(10S)-10,19-dihydrovitamin D3 / (5E)-(10S)-10,19-dihydrocholecalciferol); LMST03020308 (toxisterol3 R1 / 6,19-dihydrovitamin D3 / 6,19-dihydrocholecalciferol); LMST04030119; LMST01010174 (5alpha-cholestanone); LMST01010097; LMST01010096; LMST01010099; LMST01010081; LMST01010089 (Lathosterol); LMST01010205 (5beta-cholestanone); LMST04030120; LMST01010001 (Cholesterol)": ["C27H46O", "Sterol Lipids [ST] with formula: C27H46O"],
        "LMST01010019 (24S-hydroxy-cholesterol); LMST01010018 (25-hydroxy-cholesterol); LMST01010013 (7alpha-hydroxy-cholesterol); LMST01010011 (5,6alpha epoxy-cholesterol); LMST01010010 (5,6beta-epoxy-cholesterol); LMST01010014 (4beta-hydroxy-cholesterol); LMST04030112; LMST04030115; LMST04030116; LMST03020662 (19-Hydroxy-10S,19-dihydrovitamin D3); LMST01010196 (5,6beta-epoxy-5alpha-cholestan-3beta-ol); LMST01010047 (7beta-hydroxycholesterol); LMST01010154 (24R-hydoxycholesterol); LMST01010086 (22R-hydroxycholesterol); LMST01010088 (27-hydroxy-cholesterol(25R)); LMST01010201 (20-hydroxycholesterol); LMST01010211 (20a-hydroxy cholesterol); LMST01010134 (20S-hydroxycholesterol); LMST01010267 (15alpha-hydroxycholestene); LMST01010268 (15beta-hydroxycholestene); LMST01010057 (27-hydroxy-cholesterol); LMST01010054 (22-hydroxycholesterol); LMST01010276 (6-oxocholestanol); LMST01010274 (19-hydroxycholesterol); LMST04030125; LMST01010164 ((24R)-24-hydroxycholesterol)": ["C27H46O2", "Sterol Lipids [ST] with formula: C27H46O2"],
        "LMST03020309 (1-methyl-1,25-dihydroxy-4-nor-2,3-secovitamin D3 / 1-methyl-1,25-dihydroxy-4-nor-2,3-secocholecalciferol); LMST04030036; LMST04030106; LMST04030113; LMST04030176 ((20R)-17alpha,20-dihydroxycholesterol); LMST04030175 ((24R)-7alpha,24-dihydroxycholesterol); LMST04030053; LMST04030054; LMST04030169 (7alpha,24-dihydroxy-5beta-cholestan-3-one); LMST04030089; LMST04030081 (7alpha,27-dihydroxycholesterol); LMST01010155; LMST03020553 (1alpha,25-dihydroxy-2alpha-methyl-19-norvitamin D3 / 1alpha,25-dihydroxy-2alpha-methyl-19-norcholecalciferol); LMST03020559 (1alpha,25-dihydroxy-2beta-methyl-19-nor-20-epivitamin D3 / 1alpha,25-dihydroxy-2beta-methyl-19-nor-20-epicholecalciferol); LMST03020558 (1alpha,25-dihydroxy-2alpha-methyl-19-nor-20-epivitamin D3 / 1alpha,25-dihydroxy-2alpha-methyl-19-nor-20-epicholecalciferol); LMST03020554 (1alpha,25-dihydroxy-2beta-methyl-19-norvitamin D3 / 1alpha,25-dihydroxy-2beta-methyl-19-norcholecalciferol); LMST04030168 (7alpha,24S-dihydroxycholesterol); LMST01010200 ((20R,22R)-20,22-dihydroxycholesterol); LMST04030179 (16alpha,27-dihydroxycholesterol); LMST04030178 (7beta,27-dihydroxycholesterol); LMST04030174 (7alpha,24-dihydroxycholesterol); LMST01010131 (25,27-dihydroxycholesterol); LMST01010132 (6,24S-dihydroxycholesterol); LMST04030165; LMST04030166 (7alpha,25-dihydroxycholesterol); LMST04030162 (3alpha,7alpha-dihydroxy-5beta-cholestan-26-al); LMST01010129 (24S,27-dihydroxycholesterol); LMST01010128 (24S,25-dihydroxycholesterol); LMST01010123 (1,25-Dihydroxycholesterol); LMST01010127 (3beta,5-oxo-5,6-secocholestan-6-al); LMST01010126 (cholestan-6-oxo-3,5-diol); LMST01010125 (3,5-dihydroxy-B-norcholestane-6-carboxaldehyde); LMST01010101 (Dormatinol); LMST04030137; LMST04030136; LMST04030135; LMST04030156 (7alpha,26-dihydroxy-5beta-cholestan-3-one)": ["C27H46O3", "Sterol Lipids [ST] with formula: C27H46O3"],
        "LMST04030154 (3alpha,7alpha,24-trihydroxy-5beta-cholestan-26-al); LMST04030108; LMST04030104; LMST04030100; LMST04030172 (7alpha,12alpha,24-trihydroxy-5beta-cholestan-3-one); LMST04030058; LMST04030055; LMST04030056; LMST04030057; LMST04030088; LMST04030077; LMST04030094; LMST04030095; LMST04030096; LMST04030097; LMST04030066; LMST04030083 (7alpha,25,27-trihydroxycholesterol); LMST04030080; LMST03020556 (1alpha,25-dihydroxy-2beta-hydroxymethyl-19-norvitamin D3 / 1alpha,25-dihydroxy-2beta-hydroxymethyl-19-norcholecalciferol); LMST03020555 (1alpha,25-dihydroxy-2alpha-hydroxymethyl-19-norvitamin D3 / 1alpha,25-dihydroxy-2alpha-hydroxymethyl-19-norcholecalciferolcholecalciferol); LMST04030078; LMST03020560 (1alpha,25-dihydroxy-2alpha-hydroxymethyl-19-nor-20-epivitamin D3 / 1alpha,25-dihydroxy-2alpha-hydroxymethyl-19-nor-20-epicholecalciferol); LMST03020561 (1alpha,25-dihydroxy-2beta-hydroxymethyl-19-nor-20-epivitamin D3 / 1alpha,25-dihydroxy-2beta-hydroxymethyl-19-nor-20-epicholecalciferol); LMST04030029; LMST04030164 (3alpha,7alpha,12alpha-trihydroxy-5beta-cholestan-26-al); LMST04030161 ((25R)-3alpha,7alpha,12alpha-trihydroxy-5beta-cholestan-26-al); LMST03020598 ((10R)-1alpha,19,25-trihydroxy-10,19-dihydrovitamin D3 / (10R)-1alpha,19,25-trihydroxy-10,19-dihydrocholecalciferol); LMST03020597 ((10S)-1alpha,19,25-trihydroxy-10,19-dihydrovitamin D3 / (10S)-1alpha,19,25-trihydroxy-10,19-dihydrocholecalciferol); LMST01010262; LMST01010263; LMST04030131; LMST04030130; LMST04030153 ((25R)-3alpha,7alpha-dihydroxy-5beta-cholestan-26-oic acid)": ["C27H46O4", "Sterol Lipids [ST] with formula: C27H46O4"],
        "LMST05020016 (cholesterol sulfate)": ["C27H46O4S", "Sterol Lipids [ST] with formula: C27H46O4S"],
        "LMST04030155 (3alpha,7alpha,12alpha,24-tetrahydroxy-5beta-cholestan-26-al); LMST04030151 ((25R)-3alpha,7alpha,12alpha-trihydroxy-5beta-cholestan-26-oic acid); LMST04030001; LMST04030152 ((25S)-3alpha,7alpha,12alpha-trihydroxy-5beta-cholestan-26-oic acid); LMST04030046; LMST04030082; LMST04030061; LMST04030063; LMST04030062; LMST04030084; LMST04030070": ["C27H46O5", "Sterol Lipids [ST] with formula: C27H46O5"],
        "LMST05020013 (26-hydroxycholesterol 3-sulfate)": ["C27H46O5S", "Sterol Lipids [ST] with formula: C27H46O5S"],
        "LMST04030043; LMST04030042; LMST04030047; LMST04030045; LMST04030044; LMST04030073; LMST04030067; LMST04030071": ["C27H46O6", "Sterol Lipids [ST] with formula: C27H46O6"],
        "LMST01010085": ["C27H48", "Sterol Lipids [ST] with formula: C27H48"],
        "LMST04030110 (Epi-coprostanol); LMST01010098 (Epi-cholestanol); LMST01010078 (Coprostanol); LMST01010077 (Dihydrocholesterol)": ["C27H48O", "Sterol Lipids [ST] with formula: C27H48O"],
        "LMST04030109; LMST04030111; LMST01010135 (6alpha-hydroxycholestanol); LMST01010273 (15alpha-hydroxycholestane); LMST01010275 (5alpha-hydroxycholesterol); LMST04030121": ["C27H48O2", "Sterol Lipids [ST] with formula: C27H48O2"],
        "LMST04030035; LMST04030102; LMST04030021; LMST04030020; LMST04030118; LMST04030090; LMST04030011; LMST04030022; LMST04030146; LMST01010052; LMST04030134 (3alpha,7alpha,12alpha-trihydroxycholestane)": ["C27H48O3", "Sterol Lipids [ST] with formula: C27H48O3"],
        "LMST04030033; LMST04030037; LMST04030034; LMST04030103; LMST04030010; LMST04030025; LMST04030024; LMST04030117; LMST04030031; LMST04030098; LMST04030093; LMST04030087; LMST04030028; LMST04030023; LMST04030160 ((25R)-5beta-cholestane-3alpha,7alpha,12alpha,26-tetrol); LMST04030159 ((25S)-5beta-cholestane-3alpha,7alpha,12alpha,26-tetrol); LMST04030008; LMST04030014; LMST04030013; LMST04030002": ["C27H48O4", "Sterol Lipids [ST] with formula: C27H48O4"],
        "LMST04030032; LMST04030027; LMST04030026; LMST04030177; LMST04030019; LMST04030041; LMST04030038; LMST04030039; LMST04030091; LMST04030092; LMST04030086; LMST04030018; LMST01010238; LMST04030009; LMST04030015; LMST04030016; LMST04030017; LMST04030012; LMST01010240; LMST01010241; LMST04030004; LMST04030003": ["C27H48O5", "Sterol Lipids [ST] with formula: C27H48O5"],
        "LMST04030173 (5beta-scymnol); LMST04030040; LMST04030030; LMST04030007; LMST04030006; LMST04030005": ["C27H48O6", "Sterol Lipids [ST] with formula: C27H48O6"],
        "LMST05020004 (5beta-Cyprinolsulfate)": ["C27H48O8S", "Sterol Lipids [ST] with formula: C27H48O8S"],
        "LMST05020017 (5beta-scymnol sulfate)": ["C27H48O9S", "Sterol Lipids [ST] with formula: C27H48O9S"],
        "LMST03010008 (26,26,26,27,27,27-hexafluoro-25-hydroxyvitamin D2 / 26,26,26,27,27,27-hexafluoro-25-hydroxyergocalciferol); LMST03010009 (26,26,26,27,27,27-hexafluoro-25-hydroxyvitamin D2 / 26,26,26,27,27,27-hexafluoro-25-hydroxyergocalciferol)": ["C28H38F6O2", "Sterol Lipids [ST] with formula: C28H38F6O2"],
        "LMST03020311 (1alpha-hydroxy-22-(4-hydroxyphenyl)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-22-(4-hydroxyphenyl)-23,24,25,26,27-pentanorcholecalciferol); LMST03020310 (1alpha-hydroxy-22-(3-hydroxyphenyl)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-22-(3-hydroxyphenyl)-23,24,25,26,27-pentanorcholecalciferol)": ["C28H38O3", "Sterol Lipids [ST] with formula: C28H38O3"],
        "LMST03020312 ((22E,24E,26E)-1alpha,26b-dihydroxy-22,23,24,25,26,26a-hexadehydro-26a,26b-dihomo-27-norvitamin D3 / (22E,24E,26E)-1alpha,26b-dihydroxy-22,23,24,25,26,26a-hexadehydro-26a,26b-dihomo-27-norcholecalciferol)": ["C28H40O3", "Sterol Lipids [ST] with formula: C28H40O3"],
        "LMST02030128 (Hydrocortisone butyrate propionate)": ["C28H40O7", "Sterol Lipids [ST] with formula: C28H40O7"],
        "LMST03010010 ((24RS)-28,28,28-trifluoro-25-hydroxyvitamin D2 / (24RS)-28,28,28-trifluoro-25-hydroxyergocalciferol)": ["C28H41F3O2", "Sterol Lipids [ST] with formula: C28H41F3O2"],
        "LMST01031002 (Ergosta-5,7,24(28)-trienol); LMST01031023 (Dehydroergosterol); LMST01031015 (ergosta-5,7,22,24(28)-tetraen-3beta-ol)": ["C28H42O", "Sterol Lipids [ST] with formula: C28H42O"],
        "LMST03020313 (calicoferol D)": ["C28H42O2", "Sterol Lipids [ST] with formula: C28H42O2"],
        "LMST03020314 ((22E,24E)-1alpha,25-dihydroxy-22,23,24,24a-tetradehydro-24a-homovitamin D3 / (22E,24E)-1alpha,25-dihydroxy-22,23,24,24a-tetradehydro-24a-homocholecalciferol); LMST03020577 (25-hydroxy-1beta-hydroxymethyl-23,23,24,24-tetradehydro-3-epivitamin D3 / 25-hydroxy-1beta-hydroxymethyl-23,23,24,24-tetradehydro-3-epicholecalciferol); LMST03020576 (25-hydroxy-1alpha-hydroxymethyl-23,23,24,24-tetradehydrovitamin D3 / 25-hydroxy-1alpha-hydroxymethyl-23,23,24,24-tetradehydrocholecalciferol)": ["C28H42O3", "Sterol Lipids [ST] with formula: C28H42O3"],
        "LMST03020315 ((22S)-1alpha,22,25-trihydroxy-23,24-tetradehydro-24a-homo-20-epivitamin D3 / (22S)-1alpha,22,25-trihydroxy-23,24-tetradehydro-24a-homo-20-epicholecalciferol); LMST03020591 (1alpha-hydroxy-18-(4-hydroxy-4-methyl-2-pentynyloxy)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-(4-hydroxy-4-methyl-2-pentynyloxy)-23,24,25,26,27-pentanorcholecalciferol)": ["C28H42O4", "Sterol Lipids [ST] with formula: C28H42O4"],
        "LMST03010011 ((24R)-24-fluoro-1alpha,25-dihydroxyvitamin D2 / (24R)-24-fluoro-1alpha,25-dihydroxyergocalciferol); LMST03010012 ((24S)-24-fluoro-1alpha,25-dihydroxyvitamin D2 / (24S)-24-fluoro-1alpha,25-dihydroxyergocalciferol)": ["C28H43FO3", "Sterol Lipids [ST] with formula: C28H43FO3"],
        "LMST03020316 (24,24-difluoro-1alpha,25-dihydroxy-24a-homovitamin D3 / 24,24-difluoro-1alpha,25-dihydroxy-24a-homocholecalciferol)": ["C28H44F2O3", "Sterol Lipids [ST] with formula: C28H44F2O3"],
        "LMST01030135 (5-dehydroepisterol); LMST03010001 (Vitamin D2); LMST03010015 (previtamin D2 / preergocalciferol); LMST03010014 ((5E)-vitamin D2 / 5,6-trans-vitamin D2 / (5E)-ergocalciferol / (5E)-ercalciol); LMST03010017 (isotachysterol2); LMST03010016 (tachysterol2); LMST03010019 ((5E)-isovitamin D2 / (5E)-isoergocalciferol); LMST03010018 ((5Z)-isovitamin D2 / 5,6-cis-isovitamin D2 / (5Z)-isoergocalciferol / 5,6-cis-isoergocalciferol); LMST03010068 (Suprasterol II); LMST01010237 (3-keto-4alpha-methyl-zymosterol); LMST01030093 (Ergosterol); LMST01010167 (3-dehydro-4-methylzymosterol)": ["C28H44O", "Sterol Lipids [ST] with formula: C28H44O"],
        "LMST03010028 (1alpha-hydroxyvitamin D2 / 1alpha-hydroxyergocalciferol); LMST03010029 (24-hydroxyvitamin D2 / 24-hydroxyergocalciferol); LMST03010032 (1alpha,25-dihydroxy-20-epivitamin D2 / 1alpha,25-dihydroxy-20-epiergocalciferol); LMST03010031 (24-epi-25-hydroxyvitamin D2 / 24-epi-25-hydroxyergocalciferol); LMST03010030 (25-hydroxyvitamin D2 / 25-hydroxyergocalciferol); LMST01010171 (zymosterol intermediate 1b); LMST01010226; LMST03010069 (Doxercalciferol); LMST03020319 (25-hydroxy-24-methyl-23,24-didehydrovitamin D3 / 25-hydroxy-24-methyl-23,24-didehydrocholecalciferol); LMST03020318 ((22E)-(25S)-25-hydroxy-26-methyl-22,23-didehydrovitamin D3 / (22E)-(25S)-25-hydroxy-26-methyl-22,23-didehydrocholecalciferol); LMST03020317 ((22E)-(25R)-25-hydroxy-26-methyl-22,23-didehydrovitamin D3 / (22E)-(25R)-25-hydroxy-26-methyl-22,23-didehydrocholecalciferol)": ["C28H44O2", "Sterol Lipids [ST] with formula: C28H44O2"],
        "LMST03010039; LMST03010038; LMST03010037 ((6S)-6,19-epidioxy-6,19-dihydrovitamin D2 / (6S)-6,19-epidioxy-6,19-dihydroergocalciferol); LMST03010036 ((6R)-6,19-epidioxy-6,19-dihydrovitamin D2 / (6R)-6,19-epidioxy-6,19-dihydroergocalciferol); LMST03010033 ((22Z)-1alpha,25-dihydroxy-20-epivitamin D2 / (22Z)-1alpha,25-dihydroxy-20-epiergocalciferol); LMST03020324 ((22E)-(25S)-1alpha,25-dihydroxy-26-methyl-22,23-didehydrovitamin D3 / (22E)-(25S)-1alpha,25-dihydroxy-26-methyl-22,23-didehydrocholecalciferol); LMST03020320 ((22E)-1alpha,25-dihydroxy-26-methyl-22,23-didehydrovitamin D3 / (22E)-1alpha,25-dihydroxy-26-methyl-22,23-didehydrocholecalciferol); LMST03020321 (1alpha,25-dihydroxy-18-methylidenevitamin D3 / 1alpha,25-dihydroxy-18-methylidenecholecalciferol); LMST03020322 ((22E)-1alpha,25-dihydroxy-22,23-didehydro-24a-homovitamin D3 / (22E)-1alpha,25-dihydroxy-22,23-didehydro-24a-homocholecalciferol); LMST03020323 ((22E)-(25R)-1alpha,25-dihydroxy-26-methyl-22,23-didehydrovitamin D3 / (22E)-(25R)-1alpha,25-dihydroxy-26-methyl-22,23-didehydrocholecalciferol); LMST03030003 (1,25-Dihydroxylumisterol(3)); LMST03010062 ((24S)-1alpha,24-dihydroxyvitamin D2 / (24S)-1alpha,24-dihydroxyergocalciferol); LMST01010152 (4alpha-carboxy-zymosterol); LMST03010048 ((24R)-24,25-dihydroxyvitamin D2 / (24R)-24,25-dihydroxyergocalciferol); LMST03010049 (24,25-dihydroxy-24-epivitamin D2 / 24,25-dihydroxy-24-epiergocalciferol); LMST03010046 (5(E)-1beta,25-dihydroxyvitamin D2 / 1beta,25-dihydroxyergocalciferol); LMST03010047 (5(E)-1beta,25-dihydroxy-24-epivitamin D2 / 5(E)-1beta,25-dihydroxy-24-epiergocalciferol); LMST03010044 (1beta,25-dihydroxyvitamin D2 / 1beta,25-dihydroxyergocalciferol); LMST03010045 (1beta,25-dihydroxy-24-epivitamin D2 / 1beta,25-dihydroxy-24-epiergocalciferol); LMST03010042 (5(E)-1alpha,25-dihydroxyvitamin D2 / 5(E)-1alpha,25-dihydroxyergocalciferol); LMST03010043 (5(E)-1alpha,25-dihydroxy-24-epivitamin D2 / 5(E)-1alpha,25-dihydroxy-24-epiergocalciferol); LMST03010040 (1alpha,,25-dihydroxyvitamin D2 / 1alpha,,25-dihydroxyergocalciferol); LMST03010041 (1alpha,25-dihydroxy-24-epivitamin D2 / 1alpha,25-dihydroxy-24-epiergocalciferol); LMST03020579 (25-hydroxy-1beta-hydroxymethyl-16,17-didehydro-3-epivitamin D3 / 25-hydroxy-1beta-hydroxymethyl-16,17-didehydro-3-epicholecalciferol); LMST03020578 (25-hydroxy-1alpha-hydroxymethyl-16,17-didehydrovitamin D3 / 25-hydroxy-1alpha-hydroxymethyl-16,17-didehydrocholecalciferol); LMST03010050 ((24R)-24,26-dihydroxyvitamin D2 / (24R)-24,26-dihydroxyergocalciferol); LMST03060003 (Carcinomedin)": ["C28H44O3", "Sterol Lipids [ST] with formula: C28H44O3"],
        "LMST03010035 ((6S)-vitamin D2 6,19-sulfur dioxide adduct / (6S)-ergocalciferol 6,19-sulfur dioxide adduct); LMST03010034 ((6R)-vitamin D2 6,19-sulfur dioxide adduct / (6R)-ergocalciferol 6,19-sulfur dioxide adduct)": ["C28H44O3S", "Sterol Lipids [ST] with formula: C28H44O3S"],
        "LMST03010051 ((24R)-1alpha,24,25-trihydroxyvitamin D2 / (24R)-1alpha,24,25-trihydroxyergocalciferol); LMST03010053 (1alpha,25,28-trihydroxyvitamin D2 / 1alpha,25,28-trihydroxyergocalciferol); LMST03010052 ((25S)-1alpha,25,26-trihydroxyvitamin D2 / (25S)-1alpha,25,26-trihydroxyergocalciferol)": ["C28H44O4", "Sterol Lipids [ST] with formula: C28H44O4"],
        "LMST03010055 (1alpha,24,25,28-tetrahydroxyvitamin D2 / 1alpha,24,25,28-tetrahydroxyergocalciferol); LMST03010054 ((24R)-1alpha,24,25,26-tetrahydroxyvitamin D2 / (24R)-1alpha,24,25,26-tetrahydroxyergocalciferol); LMST03020680 (24-Nor-9,11-seco-11-acetoxy-3,6-dihydroxycholest-7,22-dien-9-one)": ["C28H44O5", "Sterol Lipids [ST] with formula: C28H44O5"],
        "LMST03020327 (11alpha-(chloromethyl)-1alpha,25-dihydroxyvitamin D3 / 11alpha-(chloromethyl)-1alpha,25-dihydroxycholecalciferol)": ["C28H45ClO3", "Sterol Lipids [ST] with formula: C28H45ClO3"],
        "LMST03020328 ((24R)-25-fluoro-1alpha,24-dihydroxy-24-methylvitamin D3 / (24R)-25-fluoro-1alpha,24-dihydroxy-24-methylcholecalciferol); LMST03020329 (11alpha-(fluoromethyl)-1alpha,25-dihydroxyvitamin D3 / 11alpha-(fluoromethyl)-1alpha,25-dihydroxycholecalciferol)": ["C28H45FO3", "Sterol Lipids [ST] with formula: C28H45FO3"],
        "LMST03020185 (1alpha,25-dihydroxy-18-oxovitamin D3 / 1alpha,25-dihydroxy-18-oxocholecalciferol)": ["C28H45O4", "Sterol Lipids [ST] with formula: C28H45O4"],
        "LMST01030110; LMST01030111; LMST01030114; LMST01030115 (Episterol); LMST01030117; LMST01030109; LMST01060003; LMST01030137; LMST01030122; LMST03020335 ((5E,10E)-19-methylvitamin D3 / (5E,10E)-19-methylcholecalciferol); LMST03030001 (Vitamin D4); LMST03030002 (Provitamin D4); LMST01010236; LMST01010151 (4alpha-methyl-zymosterol); LMST01031022 (5-campestenone); LMST03020334 ((10E)-19-methylvitamin D3 / (10E)-19-methylcholecalciferol); LMST03020333 (6-methylprevitamin D3 / 6-methylprecholecalciferol); LMST01010208 (4alpha-methyl-5alpha-cholest-7-en-3-one); LMST01010202 (4alpha-methylzymosterol); LMST01060005; LMST03010057 (3-epidihydrotachysterol2 / (5E)-(10S)-10,19-dihydro-3-epivitamin D2 / (5E)-(10S)-10,19-dihydro-3-epiergocalciferol); LMST03010056 (dihydrotachysterol2 / (5E)-(10S)-10,19-dihydrovitamin D2 / (5E)-(10S)-10,19-dihydroergocalciferol); LMST01030099; LMST01030098 (Brassicasterol); LMST01030095 (Fecosterol); LMST01030094; LMST03060001 (Vitamin D7); LMST03060002 (Provitamin D7); LMST03020331 (6-methylvitamin D3 / 6-methylcholecalciferol)": ["C28H46O", "Sterol Lipids [ST] with formula: C28H46O"],
        "LMST01031004; LMST03020336 (1alpha,25-dihydroxy-3alpha-methyl-3-deoxyvitamin D3 /1alpha,25-dihydroxy-3alpha-methyl-3-deoxycholecalciferol); LMST03030004 (22-Hydroxy Vitamin D4); LMST01010234; LMST01010231; LMST01031014 (5alpha-ergosta-7,22-diene-3beta,5-diol); LMST01010169 (zymosterol intermediate 1a)": ["C28H46O2", "Sterol Lipids [ST] with formula: C28H46O2"],
        "LMST03020339 (25-methyl-1alpha,26-dihydroxyvitamin D3 / 25-methyl-1alpha,26-dihydroxycholecalciferol); LMST01010228; LMST03020540 (2alpha-methyl-1alpha,25-dihydroxyvitamin D3 / 2alpha-methyl-1alpha,25-dihydroxycholecalciferol); LMST03020360 (2beta-methyl-20-epi-1beta,25-dihydroxyvitamin D3 / 2beta-methyl-20-epi-1beta,25-dihydroxycholecalciferol); LMST03020361 (2alpha-methyl-3-epi-20-epi-1beta,25-dihydroxyvitamin D3 / 2alpha-methyl-3-epi-20-epi-1beta,25-dihydroxycholecalciferol); LMST03020364 (1alpha,25-dihydroxy-11beta-methylvitamin D3 / 1alpha,25-dihydroxy-11beta-methylcholecalciferol); LMST03020365 (1alpha,25-dihydroxy-18-methylvitamin D3 / 1alpha,25-dihydroxy-18-methylcholecalciferol); LMST03020366 (1alpha,25-dihydroxy-24a-homovitamin D3 / 1alpha,25-dihydroxy-24a-homocholecalciferol); LMST03020367 ((24R)-1alpha,25-dihydroxy-24-methylvitamin D3 /(24R)-1alpha,25-dihydroxy-24-methylcholecalciferol); LMST03020362 (2beta-methyl-3-epi-20-epi-1beta,25-dihydroxyvitamin D3 / 2beta-methyl-3-epi-20-epi-1beta,25-dihydroxycholecalciferol); LMST03020346 (1beta,25-dihydroxy-1alpha-methylvitamin D3 / 1beta,25-dihydroxy-1alpha-methylcholecalciferol); LMST03020345 (1alpha,25-dihydroxy-1beta-methylvitamin D3 / 1alpha,25-dihydroxy-1beta-methylcholecalciferol); LMST03020343 ((22S)-25-hydroxy-22-methoxyvitamin D3 / (22S)-25-hydroxy-22-methoxycholecalciferol); LMST03020371 (1alpha,25-dihydroxy-26-methylvitamin D3 / 1alpha,25-dihydroxy-26-methylcholecalciferol); LMST03020348 (2beta-methyl-1alpha,25-dihydroxyvitamin D3 / 2beta-methyl-1alpha,25-dihydroxycholecalciferol); LMST03020347 (1alpha,25-dihydroxy-8(14)a-homovitamin D3 / 1alpha,25-dihydroxy-8(14)a-homocholecalciferol); LMST03020344 (25-hydroxy-3,3-dimethyl-3-deoxy-A-homo-2,4-dioxavitamin D3 / 25-hydroxy-3,3-dimethyl-3-deoxy-A-homo-2,4-dioxacholecalciferol); LMST03020342 ((22R)-25-hydroxy-22-methoxyvitamin D3 / (22R)-25-hydroxy-22-methoxycholecalciferol); LMST03020340 ((1R)-25-hydroxy-1-(hydroxymethyl)vitamin D3 / (1R)-25-hydroxy-1-(hydroxymethyl)cholecalciferol); LMST03020341 ((1S)-25-hydroxy-1-(hydroxymethyl)vitamin D3 / (1S)-25-hydroxy-1-(hydroxymethyl)cholecalciferol); LMST03020349 (2alpha-methyl-3-epi-1alpha,25-dihydroxyvitamin D3 / 2alpha-methyl-3-epi-1alpha,25-dihydroxycholecalciferol); LMST03020636 (20(17+mm12beta)-abeo-1alpha,25-Dihydroxy-24-dihomo-21-norvitamin D3); LMST03020351 (2alpha-methyl-1beta,25-dihydroxyvitamin D3 / 2alpha-methyl-1beta,25-dihydroxycholecalciferol); LMST03020350 (2beta-methyl-3-epi-1alpha,25-dihydroxyvitamin D3 / 2beta-methyl-3-epi-1alpha,25-dihydroxycholecalciferol); LMST03020353 (2alpha-methyl-3-epi-1beta,25-dihydroxyvitamin D3 / 2alpha-methyl-3-epi-1beta,25-dihydroxycholecalciferol); LMST03020352 (2beta-methyl-1beta,25-dihydroxyvitamin D3 / 2beta-methyl-1beta,25-dihydroxycholecalciferol); LMST03020355 (2alpha-methyl-20-epi-1alpha,25-dihydroxyvitamin D3 / 2alpha-methyl-20-epi-1alpha,25-dihydroxycholecalciferol); LMST03020354 (2beta-methyl-3-epi-1beta,25-dihydroxyvitamin D3 / 2beta-methyl-3-epi-1beta,25-dihydroxycholecalciferol); LMST03020357 (2alpha-methyl-3-epi-20-epi-1alpha,25-dihydroxyvitamin D3 / 2alpha-methyl-3-epi-20-epi-1alpha,25-dihydroxycholecalciferol); LMST03020356 (2beta-methyl-20-epi-1alpha,25-dihydroxyvitamin D3 / 2beta-methyl-20-epi-1alpha,25-dihydroxycholecalciferol); LMST03020359 (2alpha-methyl-20-epi-1beta,25-dihydroxyvitamin D3 / 2alpha-methyl-20-epi-1beta,25-dihydroxycholecalciferol); LMST03020358 (2beta-methyl-3-epi-20-epi-1alpha,25-dihydroxyvitamin D3 / 2beta-methyl-3-epi-20-epi-1alpha,25-dihydroxycholecalciferol); LMST03020368 (1alpha,25-dihydroxy-24a-homo-20-epivitamin D3 / 1alpha,25-dihydroxy-24a-homo-20-epicholecalciferol); LMST03020629 (1alpha,25-Dihydroxy-2Z-ethylidene-19-norvitamin D3); LMST03020628 (1alpha,25-Dihydroxy-2E-ethylidene-19-norvitamin D3); LMST03020363 (1alpha,25-dihydroxy-11alpha-methylvitamin D3 / 1alpha,25-dihydroxy-11alpha-methylcholecalciferol); LMST03020330 (1alpha-hydroxy-25-methoxyvitamin D3 / 1alpha-hydroxy-25-methoxycholecalciferol)": ["C28H46O3", "Sterol Lipids [ST] with formula: C28H46O3"],
        "LMST03020338 ((6S)-6-methylvitamin D3 6,19-sulfur dioxide adduct / (6S)-6-methylcholecalciferol 6,19-sulfur dioxide adduct); LMST03020337 ((6R)-6-methylvitamin D3 6,19-sulfur dioxide adduct / (6R)-6-methylcholecalciferol 6,19-sulfur dioxide adduct); LMST03020369 (1alpha,25-dihydroxy-24a,24b-didihomo-22-thia-20-epivitamin D3 / 1alpha,25-dihydroxy-24a,24b-didihomo-22-thia-20-epicholecalciferol); LMST03020373 (1alpha,25-dihydroxy-26,27-dimethyl-22-thiavitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22-thiacholecalciferol); LMST03020370 (1alpha,25-dihydroxy-24a,24b-dihomo-22-thiavitamin D3 / 1alpha,25-dihydroxy-24a,24b-dihomo-22-thiacholecalciferol); LMST03020374 (1alpha,25-dihydroxy-26,27-dimethyl-22-thia-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22-thia-20-epicholecalciferol)": ["C28H46O3S", "Sterol Lipids [ST] with formula: C28H46O3S"],
        "LMST01030131 (3-Dehydroteasterone); LMST03020326 (1alpha,25-dihydroxy-26,27-dimethyl-20,21-didehydro-23-oxavitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-20,21-didehydro-23-oxacholecalciferol); LMST03020586 (1alpha-hydroxy-18-(4-hydroxy-4-methylpentyloxy)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-(4-hydroxy-4-methylpentyloxy)-23,24,25,26,27-pentanorcholecalciferol); LMST03020379 (1alpha,25-dihydroxy-11beta-methoxyvitamin D3 / 1alpha,25-dihydroxy-11beta-methoxycholecalciferol); LMST03020378 (1alpha,25-dihydroxy-11alpha-(hydroxymethyl)vitamin D3 / 1alpha,25-dihydroxy-11alpha-(hydroxymethyl)cholecalciferol); LMST03020377 (1alpha,25-dihydroxy-11alpha-methoxyvitamin D3 / 1alpha,25-dihydroxy-11alpha-methoxycholecalciferol); LMST03020376 ((24S)-1alpha,24-dihydroxy-26,27-dimethyl-22-oxavitamin D3 / (24S)-1alpha,24-dihydroxy-26,27-dimethyl-22-oxacholecalciferol); LMST03020375 ((24R)-1alpha,24-dihydroxy-26,27-dimethyl-22-oxavitamin D3 / (24R)-1alpha,24-dihydroxy-26,27-dimethyl-22-oxacholecalciferol); LMST03020603 (2beta-methoxy-1alpha,25-dihydroxyvitamin D3); LMST03020389 ((23R)-1alpha,23,25-trihydroxy-23-methylvitamin D3 / (23R)-1alpha,23,25-trihydroxy-23-methylcholecalciferol); LMST03020382 (1alpha,25-dihydroxy-24a,24b-dihomo-22-oxa-20-epivitamin D3 / 1alpha,25-dihydroxy-24a,24b-dihomo-22-oxa-20-epicholecalciferol); LMST03020383 (1alpha,25-dihydroxy-26,27-dimethyl-22-oxavitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22-oxacholecalciferol); LMST03020380 ((20S)-1alpha,25-dihydroxy-20-methoxyvitamin D3 / (20S)-1alpha,25-dihydroxy-20-methoxycholecalciferol); LMST03020381 (1alpha,25-dihydroxy-24a,24b-dihomo-22-oxavitamin D3 / 1alpha,25-dihydroxy-24a,24b-dihomo-22-oxacholecalciferol); LMST03020387 ((20S)-1alpha,20,25-trihydroxy-24a-homovitamin D3 / (20S)-1alpha,20,25-trihydroxy-24a-homocholecalciferol); LMST03020384 (1alpha,25-dihydroxy-24a,24b-dihomo-23-oxavitamin D3 / 1alpha,25-dihydroxy-24a,24b-dihomo-23-oxacholecalciferol); LMST03020385 (1alpha,25-dihydroxy-24a,24b-dihomo-23-oxa-20-epivitamin D3 / 1alpha,25-dihydroxy-24a,24b-dihomo-23-oxa-20-epicholecalciferol); LMST03060004 (KH 1049)": ["C28H46O4", "Sterol Lipids [ST] with formula: C28H46O4"],
        "LMST05020012 (24-methylene-cholesterol sulfate)": ["C28H46O4S", "Sterol Lipids [ST] with formula: C28H46O4S"],
        "LMST04040005": ["C28H46O5", "Sterol Lipids [ST] with formula: C28H46O5"],
        "LMST01031017 (makisterone B)": ["C28H46O7", "Sterol Lipids [ST] with formula: C28H46O7"],
        "LMST01150006 (Verazine)": ["C28H47NO", "Sterol Lipids [ST] with formula: C28H47NO"],
        "LMST01030113; LMST01030116; LMST01030118; LMST01030119; LMST01030105; LMST01010136; LMST01010197 (4alpha-methylcholest-8-en-3beta-ol); LMST01030123; LMST01010094; LMST01031016 (campest-4-en-3beta-ol); LMST01010138; LMST01010137; LMST01060006; LMST01030097 (Campesterol); LMST01030096": ["C28H48O", "Sterol Lipids [ST] with formula: C28H48O"],
        "LMST01030133 (6-oxocampestanol); LMST01010235; LMST01031003": ["C28H48O2", "Sterol Lipids [ST] with formula: C28H48O2"],
        "LMST01030132 (Cathasterone); LMST01030125 (3-Dehydro-6-deoxoteasterone)": ["C28H48O3", "Sterol Lipids [ST] with formula: C28H48O3"],
        "LMST04040009; LMST01030130 (Typhasterol); LMST01030121 (Teasterone)": ["C28H48O4", "Sterol Lipids [ST] with formula: C28H48O4"],
        "LMST04040002; LMST01030129 (Castasterone); LMST01010246 (Trihydroxycoprostanoic acid)": ["C28H48O5", "Sterol Lipids [ST] with formula: C28H48O5"],
        "LMST04040001; LMST01140002 (24-epi-brassinolide); LMST01140001 (Brassinolide)": ["C28H48O6", "Sterol Lipids [ST] with formula: C28H48O6"],
        "LMST01030103; LMST01030102; LMST01010140; LMST01010139": ["C28H50O", "Sterol Lipids [ST] with formula: C28H50O"],
        "LMST01030134 (6alpha-hydroxycampestanol); LMST01030124 (6-Deoxocathasterone); LMST01010270 (15-ketocholestane)": ["C28H50O2", "Sterol Lipids [ST] with formula: C28H50O2"],
        "LMST01030120 (6-deoxoteasterone); LMST01030126 (6-Deoxotyphasterol)": ["C28H50O3", "Sterol Lipids [ST] with formula: C28H50O3"],
        "LMST01030127 (6-Deoxocastasterone)": ["C28H50O4", "Sterol Lipids [ST] with formula: C28H50O4"],
        "LMST01030128 (6alpha-Hydroxycastasterone)": ["C28H50O5", "Sterol Lipids [ST] with formula: C28H50O5"],
        "LMST03020390 (1alpha-hydroxy-22-(3-methylphenyl)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-22-(3-methylphenyl)-23,24,25,26,27-pentanorcholecalciferol)": ["C29H40O2", "Sterol Lipids [ST] with formula: C29H40O2"],
        "LMST01040152 (ajugalactone)": ["C29H40O8", "Sterol Lipids [ST] with formula: C29H40O8"],
        "LMST01120013 (convallatoxin); LMST01120020 (adonitoxin)": ["C29H42O10", "Sterol Lipids [ST] with formula: C29H42O10"],
        "LMST03020391 ((17Z)-1alpha,25-dihydroxy-26,27-dimethyl-17,20,22,22,23,23-hexadehydrovitamin D3 / (17Z)-1alpha,25-dihydroxy-26,27-dimethyl-17,20,22,22,23,23-hexadehydrocholecalciferol); LMST03020392 (1alpha,25-dihydroxy-26,27-dimethyl-20,21,22,22,23,23-hexadehydrovitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-20,21,22,22,23,23-hexadehydrocholecalciferol)": ["C29H42O3", "Sterol Lipids [ST] with formula: C29H42O3"],
        "LMST03020393 (24a,24b-epoxy-23-tetradehydro-24a,24b-dihomo-1alpha,25-dihydroxyvitamin D3 / 24a,24b-epoxy-23-tetradehydro-24a,24b-dihomo-1alpha,25-dihydroxycholecalciferol)": ["C29H42O4", "Sterol Lipids [ST] with formula: C29H42O4"],
        "LMST02030121 (Hydrocortisone cypionate)": ["C29H42O6", "Sterol Lipids [ST] with formula: C29H42O6"],
        "LMST01031006 (4alpha-methyl-5alpha-ergosta-8,14,24(28)-trien-3beta-ol); LMST01031005": ["C29H44O", "Sterol Lipids [ST] with formula: C29H44O"],
        "LMST01120016 (antioside); LMST01120014 (lokundjoside)": ["C29H44O10", "Sterol Lipids [ST] with formula: C29H44O10"],
        "LMST01120022 (Ouabain)": ["C29H44O12", "Sterol Lipids [ST] with formula: C29H44O12"],
        "LMST03020395 ((22E,24E)-1alpha,25-dihydroxy-22,23,24,24a-tetradehydro-24a,24b-dihomovitamin D3 / (22E,24E)-1alpha,25-dihydroxy-22,23,24,24a-tetradehydro-24a,24b-dihomocholecalciferol); LMST03020394 (11alpha-ethynyl-1alpha,25-dihydroxyvitamin D3 / 11alpha-ethynyl-1alpha,25-dihydroxycholecalciferol); LMST03020397 (1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-20-epicholecalciferol); LMST03020396 (1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydrovitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-cholecalciferol); LMST03020623 (24a,24b-Dihomo-9,10-secocholesta-5,7,10(19),24a-tetraen-1alpha,3,25-triol); LMST03020583 ((20S)-20-cyclopropyl-1alpha,25-dihydroxy-16,17-didehydro-21-norvitamin D3 / (20S)-20-cyclopropyl-1alpha,25-dihydroxy-16,17-didehydro-21-norcholecalciferol)": ["C29H44O3", "Sterol Lipids [ST] with formula: C29H44O3"],
        "LMST03020399 ((22R)-1alpha,22,25-trihydroxy-23,24-tetradehydro-24a,24b-dihomo-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-23,24-tetradehydro-24a,24b-dihomo-20-epicholecalciferol); LMST03020398 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydrovitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydrocholecalciferol); LMST03020401 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-20-epicholecalciferol); LMST03020400 ((22S)-1alpha,22,25-trihydroxy-23,24-tetradehydro-24a,24b-dihomo-20-epivitamin D3 / (22S)-1alpha,22,25-trihydroxy-23,24-tetradehydro-24a,24b-dihomo-20-epicholecalciferol); LMST03020594 (1alpha-hydroxy-18-(5-hydroxy-5-methyl-3-hexynyloxy)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-(5-hydroxy-5-methyl-3-hexynyloxy)-23,24,25,26,27-pentanorcholecalciferol); LMST03020593 (1alpha-hydroxy-18-(5-hydroxy-5-methyl-2-hexynyloxy)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-(5-hydroxy-5-methyl-2-hexynyloxy)-23,24,25,26,27-pentanorcholecalciferol)": ["C29H44O4", "Sterol Lipids [ST] with formula: C29H44O4"],
        "LMST01040153 (cyasterone)": ["C29H44O8", "Sterol Lipids [ST] with formula: C29H44O8"],
        "LMST01120010 (rhodexin A)": ["C29H44O9", "Sterol Lipids [ST] with formula: C29H44O9"],
        "LMST03020612 (25-Hydroxyvitamin D3-bromoacetate)": ["C29H45BrO3", "Sterol Lipids [ST] with formula: C29H45BrO3"],
        "LMST03020681 (Ecalcidene)": ["C29H45NO3", "Sterol Lipids [ST] with formula: C29H45NO3"],
        "LMST03020676 (24,24-Difluoro-25-hydroxy-26,27-dimethylvitamin D3)": ["C29H46F2O2", "Sterol Lipids [ST] with formula: C29H46F2O2"],
        "LMST03020403 (24,24-difluoro-1alpha,25-dihydroxy-26,27-dimethylvitamin D3 / 24,24-difluoro-1alpha,25-dihydroxy-26,27-dimethylcholecalciferol)": ["C29H46F2O3", "Sterol Lipids [ST] with formula: C29H46F2O3"],
        "LMST01110001 (Calysterol); LMST03050002 (Provitamin D6); LMST03050001 (Vitamin D6); LMST01031020 (Delta 8,14 -Sterol); LMST01010149 (4,4-dimethylcholesta-8,11,24-trienol); LMST01040138; LMST01040132; LMST01040155 (5-Dehydro-avenasterol)": ["C29H46O", "Sterol Lipids [ST] with formula: C29H46O"],
        "LMST01010170 (zymosterol intermediate 1c); LMST01010229; LMST03010058 (1alpha-hydroxy-24-methylvitamin D2 / 1alpha-hydroxy-24-methylergocalciferol)": ["C29H46O2", "Sterol Lipids [ST] with formula: C29H46O2"],
        "LMST03020408 (1alpha,25-dihydroxy-26,27-ethanovitamin D3 / 1alpha,25-dihydroxy-26,27-ethanocholecalciferol); LMST03020405 (1alpha,25-dihydroxy-11alpha-vinylvitamin D3 / 1alpha,25-dihydroxy-11alpha-vinylcholecalciferol); LMST03020404 (18-acetoxy-vitamin D3 / 18-acetoxy-cholecalciferol); LMST03020407 (1alpha,25-dihydroxy-22,23-didehydro-24a,24b-dihomovitamin D3 /1alpha,25-dihydroxy-22,23-didehydro-24a,24b-dihomocholecalciferol); LMST03020406 ((22E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydrovitamin D3 / (22E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydrocholecalciferol); LMST03020624 (25-Hydroxy[26,27-methyl]vitamin D3 3beta-(1,2-epoxypropyl)ether); LMST01010150 (4alpha-carboxy-4beta-methyl-zymosterol); LMST03020596 ((24aE)-1alpha,25-dihydroxy-24a,24b-didehydro-24a,24b-dihomovitamin D3 /(24aE)-1alpha,25-dihydroxy-24a,24b-didehydro-24a,24b-dihomocholecalciferol); LMST03020595 ((24E)-1alpha,25-dihydroxy-24,24a-didehydro-24a,24b-dihomovitamin D3 /(24E)-1alpha,25-dihydroxy-24,24a-didehydro-24a,24b-dihomocholecalciferol); LMST03010059 (1alpha,25-dihydroxy-24-methylvitamin D2 / 1alpha,25-dihydroxy-24-methylergocalciferol)": ["C29H46O3", "Sterol Lipids [ST] with formula: C29H46O3"],
        "LMST03020412 (1alpha,25-dihydroxy-11alpha-[(1S)-oxiranyl]vitamin D3 / 1alpha,25-dihydroxy-11alpha-[(1S)-oxiranyl]cholecalciferol); LMST03020413 (1alpha,25-dihydroxy-26,27-dimethyl-20,21-methano-23-oxavitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-20,21-methano-23-oxacholecalciferol); LMST03020410 (18-acetoxy-25-hydroxyvitamin D3 / 18-acetoxy-25-hydroxycholecalciferol); LMST03020411 (1alpha,25-dihydroxy-11alpha-[(1R)-oxiranyl]vitamin D3 / 1alpha,25-dihydroxy-11alpha-[(1R)-oxiranyl]cholecalciferol); LMST03020409 (18-acetoxy-1alpha-hydroxyvitamin D3 / 18-acetoxy-1alpha-hydroxycholecalciferol)": ["C29H46O4", "Sterol Lipids [ST] with formula: C29H46O4"],
        "LMST03020414 (18-acetoxy-1alpha,25-dihydroxyvitamin D3 / 18-acetoxy-1alpha,25-dihydroxycholecalciferol)": ["C29H46O5", "Sterol Lipids [ST] with formula: C29H46O5"],
        "LMST01010191 (2-deoxy-20-hydroxy-5alpha-ecdysone 3-acetate)": ["C29H46O7", "Sterol Lipids [ST] with formula: C29H46O7"],
        "LMST01010188 (3-O-acetylecdysone 2-phosphate)": ["C29H47O10P", "Sterol Lipids [ST] with formula: C29H47O10P"],
        "LMST01030112; LMST03040003 (Provitamin D5); LMST03040002 (Vitamin D5); LMST01030100; LMST01030104; LMST01060004; LMST01030138; LMST01010176 (14-demethyllanosterol); LMST01010143; LMST01031019 (4a-Methylfecosterol); LMST01040123 (Stigmasterol); LMST01040120; LMST01040121; LMST01040126 (Chondrillasterol); LMST01040124 (Clerosterol); LMST01040137; LMST01040136; LMST01040131; LMST01040130 (Poriferasterol); LMST01010277; LMST01040140 (Spinasterol); LMST01040142; LMST01040143; LMST01040145 (Isofucosterol); LMST01040146 (Fucosterol); LMST01040154 (Delta7-Avenasterol); LMST01030144": ["C29H48O", "Sterol Lipids [ST] with formula: C29H48O"],
        "LMST03020416 (25-hydroxy-26,27-dimethylvitamin D3 / 25-hydroxy-26,27-dimethylcholecalciferol); LMST03020417 ((6S)-6,19-ethano-25-hydroxy-6,19-dihydrovitamin D3 / (6S)-6,19-ethano-25-hydroxy-6,19-dihydrocholecalciferol); LMST03020415 (1alpha-hydroxy-26,27-dimethylvitamin D3 / 1alpha-hydroxy-26,27-dimethylcholecalciferol); LMST03020418 ((6R)-6,19-ethano-25-hydroxy-6,19-dihydrovitamin D3 / (6R)-6,19-ethano-25-hydroxy-6,19-dihydrocholecalciferol); LMST03020673 (25-Hydroxy-6,19-dihydro-6,19-ethanovitamin D3); LMST03040004 (1-Hydroxyvitamin D5); LMST01010232; LMST01010230; LMST01010204 (3beta-hydroxy-4beta-methyl-5alpha-cholest-7-ene-4alpha-carbaldehyde); LMST01010245 (Cholesteryl acetate); LMST01040151 ((3beta,24R,24'R)-fucosterol epoxide)": ["C29H48O2", "Sterol Lipids [ST] with formula: C29H48O2"],
        "LMST03020422 (1alpha,25-dihydroxy-24a,24b-dihomo-20-epivitamin D3 / 1alpha,25-dihydroxy-24a,24b-dihomo-20-epicholecalciferol); LMST03020421 (1alpha,25-dihydroxy-24a,24b-dihomovitamin D3 / 1alpha,25-dihydroxy-24a,24b-dihomocholecalciferol); LMST03020420 (1alpha,25-dihydroxy-26,27-dimethylvitamin D3 / 1alpha,25-dihydroxy-26,27-dimethylcholecalciferol); LMST03020419 (11alpha-ethyl-1alpha,25-dihydroxyvitamin D3 / 11alpha-ethyl-1alpha,25-dihydroxycholecalciferol); LMST01010189 (3beta-hydroxy-4alpha-methyl-5alpha-cholest-7-ene-4beta-carboxylic acid); LMST01010175 (3beta-hydroxy-4beta-methyl-5alpha-cholest-7-ene-4alpha-carboxylic acid); LMST01010227": ["C29H48O3", "Sterol Lipids [ST] with formula: C29H48O3"],
        "LMST03020425 (1alpha,25-dihydroxy-24a,24b,24c-trihomo-22-thiavitamin D3 / 1alpha,25-dihydroxy-24a,24b,24c-trihomo-22-thiacholecalciferol); LMST03020424 (1alpha,25-dihydroxy-26,27-dimethyl-24a-homo-22-thia-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-24a-homo-22-thia-20-epicholecalciferol); LMST03020423 (1alpha,25-dihydroxy-24a-homo-26,27-dimethyl-22-thiavitamin D3 / 1alpha,25-dihydroxy-24a-homo-26,27-dimethyl-22-thiacholecalciferol); LMST03020426 (1alpha,25-dihydroxy-24a,24b,24c-trihomo-22-thia-20-epivitamin D3 / 1alpha,25-dihydroxy-24a,24b,24c-trihomo-22-thia-20-epicholecalciferol)": ["C29H48O3S", "Sterol Lipids [ST] with formula: C29H48O3S"],
        "LMST03020429 (1alpha,25-dihydroxy-24a,24b,24c-trihomo-22-oxavitamin D3 / 1alpha,25-dihydroxy-24a,24b,24c-trihomo-22-oxacholecalciferol); LMST03020428 ((20S)-1alpha,25-dihydroxy-20-methoxy-24a-homovitamin D3 / (20S)-1alpha,25-dihydroxy-20-methoxy-24a-homocholecalciferol); LMST03020475 ((20S)-1alpha,20,25-trihydroxy-26,27-dimethyl-24a-homovitamin D3 / (20S)-1alpha,20,25-trihydroxy-26,27-dimethyl-24a-homocholecalciferol); LMST03020427 (1alpha-hydroxy-2beta-(2-hydroxyethoxy)vitamin D3 / 1alpha-hydroxy-2beta-(2-hydroxyethoxy)cholecalciferol); LMST03020437 ((20S)-14alpha,20,25-trihydroxy-26,27-dimethylvitamin D3 / (20S)-1alpha,20,25-trihydroxy-26,27-dimethylcholecalciferol); LMST03020436 ((20S)-1alpha,20,25-trihydroxy-24a,24b-dihomovitamin D3 / (20S)-1alpha,20,25-trihydroxy-24a,24b-dihomocholecalciferol); LMST03020439 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethylvitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethylcholecalciferol); LMST03020588 (1alpha-hydroxy-18-(5-hydroxy-5-methylhexyloxy)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-(5-hydroxy-5-methylhexyloxy)-23,24,25,26,27-pentanorcholecalciferol); LMST03020434 (1alpha,25-dihydroxy-11beta-(2-hydroxyethyl)vitamin D3 / 1alpha,25-dihydroxy-11beta-(2-hydroxyethyl)cholecalciferol); LMST03020435 ((22R)-1alpha,22,25-trihydroxy-24a,24b-dihomo-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-24a,24b-dihomo-20-epicholecalciferol); LMST03020430 (1alpha,25-dihydroxy-26,27-dimethyl-24a-homo-22-oxavitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-24a-homo-22-oxacholecalciferol); LMST03020431 (1alpha,25-dihydroxy-20,26,27-trimethyl-23-oxavitamin D3 / 1alpha,25-dihydroxy-20,26,27-trimethyl-23-oxacholecalciferol); LMST03020432 (1alpha,25-dihydroxy-26,27-dimethyl-24a-homo-22-oxa-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-24a-homo-22-oxa-20-epicholecalciferol); LMST03020433 (1alpha,25-dihydroxy-11alpha-(2-hydroxyethyl)vitamin D3 / 1alpha,25-dihydroxy-11alpha-(2-hydroxyethyl)cholecalciferol); LMST03020438 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-20-epicholecalciferol)": ["C29H48O4", "Sterol Lipids [ST] with formula: C29H48O4"],
        "LMST03020440 (1alpha,25-dihydroxy-2beta-(2-hydroxyethoxy)vitamin D3 / 1alpha,25-dihydroxy-2beta-(2-hydroxyethoxy)cholecalciferol)": ["C29H48O5", "Sterol Lipids [ST] with formula: C29H48O5"],
        "LMST04080001": ["C29H48O7", "Sterol Lipids [ST] with formula: C29H48O7"],
        "LMST01030108; LMST01030139; LMST01040122 (Clionasterol); LMST01010225; LMST01010207 (4,4-dimethyl-5alpha-cholest-7-en-3beta-ol); LMST01030140; LMST01040125; LMST01040129 (Sitosterol); LMST01040135; LMST01040134; LMST01040133; LMST01040141; LMST01030145": ["C29H50O", "Sterol Lipids [ST] with formula: C29H50O"],
        "LMST03020441 (toxisterol3 B1/ (5E)-(10R)-10-ethoxy-10,19-dihydrovitamin D3 / (5E)-(10R)-10-ethoxy-10,19-dihydrocholecalciferol); LMST03020442 (toxisterol3 B2 / (5E)-(10S)-10-ethoxy-10,19-dihydrovitamin D3 / (5E)-(10S)-10-ethoxy-10,19-dihydrocholecalciferol); LMST01010233; LMST03020443 (toxisterol3 B3 / (10R)-10-ethoxy-10,19-dihydrovitamin D3 / (10R)-10-ethoxy-10,19-dihydrocholecalciferol); LMST01010203 (4beta-(hydroxymethyl)-4alpha-methyl-5alpha-cholest-7-en-3beta-ol); LMST01030143": ["C29H50O2", "Sterol Lipids [ST] with formula: C29H50O2"],
        "LMST03020627 (2alpha-(3-Hydroxypropyl)-1alpha,25-dihydroxy-19-norvitamin D3)": ["C29H50O4", "Sterol Lipids [ST] with formula: C29H50O4"],
        "LMST03020549 (1alpha,25-dihydroxy-2alpha-(3-hydroxypropoxy)-19-norvitamin D3 / 1alpha,25-dihydroxy-2alpha-(3-hydroxypropoxy)-19-norcholecalciferol); LMST03020550 (1alpha,25-dihydroxy-2beta-(3-hydroxypropoxy)-19-norvitamin D3 / 1alpha,25-dihydroxy-2beta-(3-hydroxypropoxy)-19-norcholecalciferol)": ["C29H50O5", "Sterol Lipids [ST] with formula: C29H50O5"],
        "LMST05040008": ["C29H51NO6S", "Sterol Lipids [ST] with formula: C29H51NO6S"],
        "LMST05040007; LMST05040006": ["C29H51NO7S", "Sterol Lipids [ST] with formula: C29H51NO7S"],
        "LMST01030146; LMST01040127; LMST01040128 (Dihydro-sitosterol); LMST01030147; LMST01030141": ["C29H52O", "Sterol Lipids [ST] with formula: C29H52O"],
        "LMST03020641 (VD 2656); LMST03020640 (VD 2716)": ["C30H42O3S", "Sterol Lipids [ST] with formula: C30H42O3S"],
        "LMST01010116 (Cucurbitacin S)": ["C30H42O6", "Sterol Lipids [ST] with formula: C30H42O6"],
        "LMST01010110 (Cucurbitacin I)": ["C30H42O7", "Sterol Lipids [ST] with formula: C30H42O7"],
        "LMST01130008 (Proscillaridin A)": ["C30H42O8", "Sterol Lipids [ST] with formula: C30H42O8"],
        "LMST03020643 (VD 2728); LMST03020644 (VD 2736); LMST03020446 (1alpha,25-dihydroxy-26,27-dimethyl-20,21,22,22,23,23-hexadehydro-24a-homovitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-20,21,22,22,23,23-hexadehydro-24a-homocholecalciferol); LMST03020445 ((17Z)-1alpha,25-dihydroxy-26,27-dimethyl-17,20,22,22,23,23-hexadehydro-24a-homovitamin D3 / (17Z)-1alpha,25-dihydroxy-26,27-dimethyl-17,20,22,22,23,23-hexadehydro-24a-homocholecalciferol); LMST03020444 ((17E)-1alpha,25-dihydroxy-26,27-dimethyl-17,20,22,22,23,23-hexadehydro-24a-homovitamin D3 / (17E)-1alpha,25-dihydroxy-26,27-dimethyl-17,20,22,22,23,23-hexadehydro-24a-homocholecalciferol); LMST03020447 ((22E,24E,24bE)-1alpha,25-dihydroxy-22,23,24,24a,24b,24c-hexadehydro-24a,24b,24c-trihomovitamin D3 / (22E,24E,24bE)-1alpha,25-dihydroxy-22,23,24,24a,24b,24c-hexadehydro-24a,24b,24c-trihomocholecalciferol)": ["C30H44O3", "Sterol Lipids [ST] with formula: C30H44O3"],
        "LMST03020448 (1alpha,25-dihydroxy-11-(3-hydroxy-1-propynyl)-9,11-didehydrovitamin D3 / 1alpha,25-dihydroxy-11-(3-hydroxy-1-propynyl)-9,11-didehydrocholecalciferol)": ["C30H44O4", "Sterol Lipids [ST] with formula: C30H44O4"],
        "LMST01010112 (Cucurbitacin L); LMST01010106 (Cucurbitacin D)": ["C30H44O7", "Sterol Lipids [ST] with formula: C30H44O7"],
        "LMST01010111 (Cucurbitacin J)": ["C30H44O8", "Sterol Lipids [ST] with formula: C30H44O8"],
        "LMST03020642 (EB 1129); LMST03020450 (1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a-homovitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a-homocholecalciferol); LMST03020451 (1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a-homo-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a-homo-20-epicholecalciferol); LMST03020449 ((22E,24E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23,24,24a-tetradehydro-24a-homovitamin D3 / (22E,24E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23,24,24a-tetradehydro-24a-homocholecalciferol); LMST03020638 (1alpha,24-Dihydroxy-22-ene-24-cyclopropylvitamin D3)": ["C30H46O3", "Sterol Lipids [ST] with formula: C30H46O3"],
        "LMST03020456 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a-homo-20-epivitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a-homo-20-epicholecalciferol); LMST03020454 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a-homo-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a-homo-20-epicholecalciferol); LMST03020455 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a-homovitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a-homocholecalciferol); LMST03020452 ((22R)-1alpha,25-dihydroxy-22-methoxy-26,27-dimethyl-23,23,24,24-tetradehydrovitamin D3 / (22R)-1alpha,25-dihydroxy-22-methoxy-26,27-dimethyl-23,23,24,24-tetradehydrocholecalciferol); LMST03020453 ((22S)-1alpha,25-dihydroxy-22-methoxy-26,27-dimethyl-23,24-tetradehydro-20-epivitamin D3 / (22S)-1alpha,25-dihydroxy-22-methoxy-26,27-dimethyl-23,24-tetradehydro-20-epicholecalciferol); LMST03020592 (1alpha-hydroxy-18-(4-hydroxy-4-ethyl-2-hexynyloxy)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-(4-hydroxy-4-ethyl-2-hexynyloxy)-23,24,25,26,27-pentanorcholecalciferol)": ["C30H46O4", "Sterol Lipids [ST] with formula: C30H46O4"],
        "LMST01010113 (Cucurbitacin O); LMST01010108 (Cucurbitacin F)": ["C30H46O7", "Sterol Lipids [ST] with formula: C30H46O7"],
        "LMST01120021 (neriifolin); LMST01010109 (Cucurbitacin H)": ["C30H46O8", "Sterol Lipids [ST] with formula: C30H46O8"],
        "LMST05010016 (6alpha-Glucuronosylhyodeoxycholate)": ["C30H47O10", "Sterol Lipids [ST] with formula: C30H47O10"],
        "LMST03020457 (24,24-difluoro-1alpha,25-dihydroxy-26,27-dimethyl-24a-homovitamin D3 / 24,24-difluoro-1alpha,25-dihydroxy-26,27-dimethyl-24a-homocholecalciferol)": ["C30H48F2O3", "Sterol Lipids [ST] with formula: C30H48F2O3"],
        "LMST01030107; LMST01050018 (24-isopropenyl-22E-dehydrocholesterol)": ["C30H48O", "Sterol Lipids [ST] with formula: C30H48O"],
        "LMST05010046 (Deoxycholic acid 3-glucuronide); LMST05010028; LMST05010022 (Chenodeoxycholic acid 3-glucuronide)": ["C30H48O10", "Sterol Lipids [ST] with formula: C30H48O10"],
        "LMST05010044 (Cholic acid glucuronide)": ["C30H48O11", "Sterol Lipids [ST] with formula: C30H48O11"],
        "LMST01010222 (32-oxolanosterol); LMST03010065 (26,27-Dihomo-1alpha-hydroxyvitamin D2); LMST03010066 (26,27-Dihomo-1alpha-hydroxy-24-epivitamin D2)": ["C30H48O2", "Sterol Lipids [ST] with formula: C30H48O2"],
        "LMST03020461 ((22Z)-1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydro-24a-homo-20-epivitamin D3 / (22Z)-1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydro-24a-homo-20-epicholecalciferol); LMST03020460 ((22E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydro-24a-homo-20-epivitamin D3 / (22E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydro-24a-homo-20-epicholecalciferol); LMST03020458 (1alpha,25-dihydroxy-22,23-didehydro-24a,24b,24c-trihomovitamin D3 /1alpha,25-dihydroxy-22,23-didehydro-24a,24b,24c-trihomocholecalciferol); LMST03020459 ((22E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydro-24a-homovitamin D3 / (22E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydro-24a-homocholecalciferol); LMST03020584 ((20S)-20-butyl-1alpha,25-dihydroxy-16,17-didehydro-21-norvitamin D3 / (20S)-20-butyl-1alpha,25-dihydroxy-16,17-didehydro-21-norcholecalciferol); LMST03020580 (25-hydroxy-1alpha-hydroxymethyl-26,27-dimethyl-16,17-didehydrovitamin D3 / 25-hydroxy-1alpha-hydroxymethyl-26,27-dimethyl-16,17-didehydrocholecalciferol); LMST03020581 (25-hydroxy-1beta-hydroxymethyl-26,27-dimethyl-16,17-didehydro-3-epivitamin D3 / 25-hydroxy-1beta-hydroxymethyl-26,27-dimethyl-16,17-didehydro-3-epicholecalciferol)": ["C30H48O3", "Sterol Lipids [ST] with formula: C30H48O3"],
        "LMST03020462 (26,27-diethyl-1alpha,25-dihydroxy-20,21-didehydro-23-oxavitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-20,21-didehydro-23-oxacholecalciferol)": ["C30H48O4", "Sterol Lipids [ST] with formula: C30H48O4"],
        "LMST01100005 (cimigenol)": ["C30H48O5", "Sterol Lipids [ST] with formula: C30H48O5"],
        "LMST01010114 (Cucurbitacin P)": ["C30H48O7", "Sterol Lipids [ST] with formula: C30H48O7"],
        "LMST06000001": ["C30H50", "Sterol Lipids [ST] with formula: C30H50"],
        "LMST01010017 (Lanosterol); LMST01050007 (29-methylisofucosterol); LMST01030101; LMST01030106; LMST01050013 (24-Isopropyl-22E-dehydrocholesterol); LMST01010141; LMST01010142; LMST01040119; LMST01040144 (24-ethylidene Iophenol); LMST01100008 (cycloartenol); LMST01100003; LMST01100011 (cycloeucalenol)": ["C30H50O", "Sterol Lipids [ST] with formula: C30H50O"],
        "LMST01010223; LMST01010124 (32-hydroxylanosterol)": ["C30H50O2", "Sterol Lipids [ST] with formula: C30H50O2"],
        "LMST03020544 (1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydro-24a,24b-dihomo-19-norvitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22,23-didehydro-24a,24b-dihomo-19-norcholecalciferol); LMST03020463 (1alpha,25-dihydroxy-24a,24b,24c-trihomovitamin D3 / 1alpha,25-dihydroxy-24a,24b,24c-trihomocholecalciferol); LMST03020465 (1alpha,25-dihydroxy-26,27-dimethyl-24a-homo-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-24a-homo-20-epicholecalciferol); LMST03020464 (1alpha,25-dihydroxy-26,27-dimethyl-24a-homovitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-24a-homocholecalciferol)": ["C30H50O3", "Sterol Lipids [ST] with formula: C30H50O3"],
        "LMST03020467 (26,27-diethyl-1alpha,25-dihydroxy-22-thia-20-epivitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-22-thia-20-epicholecalciferol); LMST03020466 (26,27-diethyl-1alpha,25-dihydroxy-22-thiavitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-22-thiacholecalciferol)": ["C30H50O3S", "Sterol Lipids [ST] with formula: C30H50O3S"],
        "LMST03020470 (26,27-diethyl-1alpha,25-dihydroxy-22-oxavitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-22-oxacholecalciferol); LMST03020471 (26,27-diethyl-1alpha,25-dihydroxy-23-oxavitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-23-oxacholecalciferol); LMST03020472 ((20S)-1alpha,25-dihydroxy-20-methoxy-26,27-dimethylvitamin D3 / (20S)-1alpha,25-dihydroxy-20-methoxy-26,27-dimethylcholecalciferol); LMST03020473 (1alpha,25-dihydroxy-26,27-dimethyl-24a,24b-dihomo-22-oxa-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-24a,24b-dihomo-22-oxa-20-epicholecalciferol); LMST03020474 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-24a-homo-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-24a-homo-20-epicholecalciferol); LMST03020476 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-24a-homovitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-24a-homocholecalciferol); LMST03020469 (1alpha,25-dihydroxy-2beta-(3-hydroxypropyl)vitamin D3 / 1alpha,25-dihydroxy-2beta-(3-hydroxypropyl)cholecalciferol); LMST03020468 (1alpha-hydroxy-2beta-(3-hydroxypropoxy)vitamin D3 / 1alpha-hydroxy-2beta-(3-hydroxypropoxy)cholecalciferol); LMST03020587 (1alpha-hydroxy-18-(4-hydroxy-4-ethylhexyloxy)-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-(4-hydroxy-4-ethylhexyloxy)-23,24,25,26,27-pentanorcholecalciferol); LMST03020626 (1alpha,25-Dihydroxy-2alpha-(3-hydroxypropyl)vitamin D3)": ["C30H50O4", "Sterol Lipids [ST] with formula: C30H50O4"],
        "LMST03020478 (1beta,25-dihydroxy-2beta-(3-hydroxypropoxy)vitamin D3 / 1beta,25-dihydroxy-2beta-(3-hydroxypropoxy)cholecalciferol); LMST03020477 (1alpha,25-dihydroxy-2beta-(3-hydroxypropoxy)vitamin D3 / 1alpha,25-dihydroxy-2beta-(3-hydroxypropoxy)cholecalciferol); LMST03020675 (1alpha,25-dihydroxy-2alpha-(3-hydroxypropoxy)vitamin D3); LMST03020571 (24alpha,25-dihydroxy-1beta-hydroxymethyl-26,27-dimethyl-24a-homo-22-oxa-3-epivitamin D3 / 24alpha,25-dihydroxy-1beta-hydroxymethyl-26,27-dimethyl-24a-homo-22-oxa-3-epicholecalciferol); LMST03020570 (24alpha,25-dihydroxy-1alpha-hydroxymethyl-26,27-dimethyl-24a-homo-22-oxavitamin D3 / 24alpha,25-dihydroxy-1alpha-hydroxymethyl-26,27-dimethyl-24a-homo-22-oxacholecalciferol)": ["C30H50O5", "Sterol Lipids [ST] with formula: C30H50O5"],
        "LMST03020684 (3'-O-Aminopropyl-25-hydroxyvitamin D3)": ["C30H51NO2", "Sterol Lipids [ST] with formula: C30H51NO2"],
        "LMST01050015 (24-ethyl-24-methyl-cholesterol); LMST01050014 (24-Isopropyl-cholesterol); LMST01060002; LMST01010087 (24,25-dihydrolanosterol); LMST01031021 (Dinosterol); LMST01040139; LMST01040148; LMST01100004; LMST01100002 (cycloartanol); LMST01040150; LMST01030142": ["C30H52O", "Sterol Lipids [ST] with formula: C30H52O"],
        "LMST01010224": ["C30H52O2", "Sterol Lipids [ST] with formula: C30H52O2"],
        "LMST03020651 (1alpha,25-Dihydroxyvitamin D3 25-trimethylsilyl ether)": ["C30H52O3Si", "Sterol Lipids [ST] with formula: C30H52O3Si"],
        "LMST01010190 (lanostane)": ["C30H54", "Sterol Lipids [ST] with formula: C30H54"],
        "LMST01040149; LMST01040147; LMST01030148": ["C30H54O", "Sterol Lipids [ST] with formula: C30H54O"],
        "LMST03020479 (1alpha-hydroxy-22-[3-(1-hydroxy-1-methylethyl)phenyl]-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-22-[3-(1-hydroxy-1-methylethyl)phenyl]-23,24,25,26,27-pentanorcholecalciferol)": ["C31H44O3", "Sterol Lipids [ST] with formula: C31H44O3"],
        "LMST03020614 (GS 1500)": ["C31H44O3S", "Sterol Lipids [ST] with formula: C31H44O3S"],
        "LMST03020682 (EB 1213)": ["C31H44O4", "Sterol Lipids [ST] with formula: C31H44O4"],
        "LMST03020480 ((17Z)-1alpha,25-dihydroxy-26,27-dimethyl-17,20,22,22,23,23-hexadehydro-24a,24b-dihomovitamin D3 / (17Z)-1alpha,25-dihydroxy-26,27-dimethyl-17,20,22,22,23,23-hexadehydro-24a,24b-dihomocholecalciferol)": ["C31H46O3", "Sterol Lipids [ST] with formula: C31H46O3"],
        "LMST03020484 (1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a,24b-dihomo-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a,24b-dihomo-20-epicholecalciferol); LMST03020481 (1alpha,25-dihydroxy-(26,26)-(27,27)-diethanovitamin D3 / 1alpha,25-dihydroxy-(26,26)-(27,27)-diethanocholecalciferol); LMST03020483 (1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a,24b-dihomovitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a,24b-dihomocholecalciferol); LMST03020482 ((22E,24E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23,24,24a-tetradehydro-24a,24b-dihomovitamin D3 / (22E,24E)-1alpha,25-dihydroxy-26,27-dimethyl-22,23,24,24a-tetradehydro-24a,24b-dihomocholecalciferol); LMST03020575 (25-hydroxy-1beta-hydroxymethyl-26,27-dimethyl-24a-homo-22,23,24,24a-tetradehydro-3-epivitamin D3 / 25-hydroxy-1beta-hydroxymethyl-26,27-dimethyl-24a-homo-22,23,24,24a-tetradehydro-3-epicholecalciferol); LMST03020574 (25-hydroxy-1alpha-hydroxymethyl-26,27-dimethyl-24a-homo-22,23,24,24a-tetradehydrovitamin D3 / 25-hydroxy-1alpha-hydroxymethyl-26,27-dimethyl-24a-homo-22,23,24,24a-tetradehydrocholecalciferol)": ["C31H48O3", "Sterol Lipids [ST] with formula: C31H48O3"],
        "LMST03020490 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a,24b-dihomo-20-epivitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a,24b-dihomo-20-epicholecalciferol); LMST03020491 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a,24b-dihomo-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a,24b-dihomo-20-epicholecalciferol); LMST03020485 ((22R)-1alpha,25-dihydroxy-22-methoxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a-homovitamin D3 / (22R)-1alpha,25-dihydroxy-22-methoxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a-homocholecalciferol); LMST03020487 ((22S)-1alpha,25-dihydroxy-22-ethoxy-26,27-dimethyl-23,24-tetradehydro-20-epivitamin D3 / (22S)-1alpha,25-dihydroxy-22-ethoxy-26,27-dimethyl-23,24-tetradehydro-20-epicholecalciferol); LMST03020486 ((22S)-1alpha,25-dihydroxy-22-methoxy-26,27-dimethyl-23,24-tetradehydro-24a-homo-20-epivitamin D3 / (22S)-1alpha,25-dihydroxy-22-methoxy-26,27-dimethyl-23,24-tetradehydro-24a-homo-20-epicholecalciferol); LMST03020489 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a,24b-dihomovitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a,24b-dihomocholecalciferol); LMST03020488 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a,24b-dihomovitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a,24b-dihomocholecalciferol); LMST03020656 (1-Hydroxyvitamin D3 diacetate); LMST03020659 (1-Hydroxyprevitamin D3 diacetate)": ["C31H48O4", "Sterol Lipids [ST] with formula: C31H48O4"],
        "LMST03020492 (1alpha,25-dihydroxy-22-oxavitamin D3 3-hemiglutarate/ 1alpha,25-dihydroxy-22-oxacholecalciferol 3-hemiglutarate)": ["C31H48O7", "Sterol Lipids [ST] with formula: C31H48O7"],
        "LMST01050016 (25-Methyl-24-isopropenyl-22E-dehydrocholesterol); LMST01050011 (Ophirasterol)": ["C31H50O", "Sterol Lipids [ST] with formula: C31H50O"],
        "LMST03020654 (Vitamin D3 butyrate)": ["C31H50O2", "Sterol Lipids [ST] with formula: C31H50O2"],
        "LMST03020493 ((10E)-19-(3-carboxylpropyl)vitamin D3 / (10E)-19-(3-carboxylpropyl)cholecalciferol); LMST03020494 ((5E,10E)-19-(3-carboxylpropyl)vitamin D3 / (5E,10E)-19-(3-carboxylpropyl)cholecalciferol)": ["C31H50O3", "Sterol Lipids [ST] with formula: C31H50O3"],
        "LMST03020495 (26,27-diethyl-1alpha,25-dihydroxy-20,21-methano-23-oxavitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-20,21-methano-23-oxacholecalciferol)": ["C31H50O4", "Sterol Lipids [ST] with formula: C31H50O4"],
        "LMST03020573 (1beta-(2-fluoroethyl)-25-hydroxy-26,27-dimethyl-24a-homo-22-oxa-3-epivitamin D3 / 1beta-(2-fluoroethyl)-25-hydroxy-26,27-dimethyl-24a-homo-22-oxa-3-epicholecalciferol); LMST03020572 (1alpha-(2-fluoroethyl)-25-hydroxy-26,27-dimethyl-24a-homo-22-oxavitamin D3 / 1alpha-(2-fluoroethyl)-25-hydroxy-26,27-dimethyl-24a-homo-22-oxacholecalciferol)": ["C31H51FO3", "Sterol Lipids [ST] with formula: C31H51FO3"],
        "LMST01050017 (25-Methyl-24-isopropenyl-cholesterol); LMST01050012 (24-Ethyl-24-methyl-22E-dehydrocholesterol); LMST01100001 (24-methylene-cycloartanol); LMST01100010 ((24R)-24-methylcycloart-25-en-3beta-ol)": ["C31H52O", "Sterol Lipids [ST] with formula: C31H52O"],
        "LMST03020498 (26,27-diethyl-1alpha,25-dihydroxyvitamin D3 / 26,27-diethyl-1alpha,25-dihydroxycholecalciferol); LMST03020499 (1alpha,25-dihydroxy-26,27-dimethyl-24a,24b-dihomovitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-24a,24b-dihomocholecalciferol); LMST03020496 (1beta-butyl-1alpha,25-dihydroxyvitamin D3 / 1beta-butyl-1alpha,25-dihydroxycholecalciferol); LMST03020497 (1alpha-butyl-1beta,25-dihydroxyvitamin D3 / 1alpha-butyl-1beta,25-dihydroxycholecalciferol)": ["C31H52O3", "Sterol Lipids [ST] with formula: C31H52O3"],
        "LMST03020504 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-24a,24b-dihomovitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-24a,24b-dihomocholecalciferol); LMST03020505 ((20S)-1alpha,25-dihydroxy-20-ethoxy-26,27-dimethylvitamin D3 / (20S)-1alpha,25-dihydroxy-20-ethoxy-26,27-dimethylcholecalciferol); LMST03020506 ((20S)-1alpha,20,25-trihydroxy-26,27-diethylvitamin D3 / (20S)-1alpha,20,25-trihydroxy-26,27-diethylcholecalciferol); LMST03020507 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-24a,24b-dihomo-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-24a,24b-dihomo-20-epicholecalciferol); LMST03020500 (1alpha-hydroxy-2beta-(4-hydroxybutoxy)vitamin D3 / 1alpha-hydroxy-2beta-(4-hydroxybutoxy)cholecalciferol); LMST03020501 (1alpha,25-dihydroxy-2beta-(4-hydroxybutyl)vitamin D3 / 1alpha,25-dihydroxy-2beta-(4-hydroxybutyl)cholecalciferol); LMST03020502 ((20S)-1alpha,25-dihydroxy-20-methoxy-26,27-dimethyl-24a-homovitamin D3 / (20S)-1alpha,25-dihydroxy-20-methoxy-26,27-dimethyl-24a-homocholecalciferol); LMST03020503 (26,27-diethyl-1alpha,25-dihydroxy-24a-homo-22-oxa-20-epivitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-24a-homo-22-oxa-20-epicholecalciferol); LMST03020509 (1alpha,25-dihydroxy-2beta-butoxyvitamin D3 / 1alpha,25-dihydroxy-2beta-butoxycholecalciferol)": ["C31H52O4", "Sterol Lipids [ST] with formula: C31H52O4"],
        "LMST03020508 (1alpha,25-dihydroxy-2beta-(4-hydroxybutoxy)vitamin D3 / 1alpha,25-dihydroxy-2beta-(4-hydroxybutoxy)cholecalciferol); LMST03020685 (1alpha,25-Dihydroxy-2-[3'-(methoxymethoxy)propylidene]-19-norvitamin D3)": ["C31H52O5", "Sterol Lipids [ST] with formula: C31H52O5"],
        "LMST01060001 (Gorgosterol)": ["C31H54O", "Sterol Lipids [ST] with formula: C31H54O"],
        "LMST03020632 ((20S)-24-Hydroxy-19-norgeminivitamin D3); LMST03020630 ((20R)-24-Hydroxy-19-norgeminivitamin D3)": ["C31H54O5", "Sterol Lipids [ST] with formula: C31H54O5"],
        "LMST03020510 (1alpha-hydroxy-23-[3-(1-hydroxy-1-methylethyl)phenyl]-22,22,23,23-tetradehydro-24,25,26,27-tetranorvitamin D3 / 1alpha-hydroxy-23-[3-(1-hydroxy-1-methylethyl)phenyl]-22,22,23,23-tetradehydro-24,25,26,27-tetranorcholecalciferol)": ["C32H42O3", "Sterol Lipids [ST] with formula: C32H42O3"],
        "LMST03020620 (1,25-Dihydroxy-20S-21-(3-hydroxy-3-methylbutyl)-23-yne-26,27-hexafluorovitamin D3)": ["C32H44F6O4", "Sterol Lipids [ST] with formula: C32H44F6O4"],
        "LMST01130007 (Scilliroside)": ["C32H44O11", "Sterol Lipids [ST] with formula: C32H44O11"],
        "LMST03020585 ((20R)-1alpha,25-dihydroxy-20-phenyl-16,17-didehydro-21-norvitamin D3 / (20R)-1alpha,25-dihydroxy-20-phenyl-16,17-didehydro-21-norcholecalciferol); LMST03020582 ((20S)-1alpha,25-dihydroxy-20-phenyl-16,17-didehydro-21-norvitamin D3 / (20S)-1alpha,25-dihydroxy-20-phenyl-16,17-didehydro-21-norcholecalciferol)": ["C32H44O3", "Sterol Lipids [ST] with formula: C32H44O3"],
        "LMST01010107 (Cucurbitacin E)": ["C32H44O8", "Sterol Lipids [ST] with formula: C32H44O8"],
        "LMST05010006 (17alpha-(N-Acetyl-D-glucosaminyl)-estradiol 3-D-glucuronide); LMST05010027 (17alpha-(N-acetyl-D-glucosaminyl)estradiol 3-glucosiduronic acid)": ["C32H45NO13", "Sterol Lipids [ST] with formula: C32H45NO13"],
        "LMST03020683 (Atocalcitol); LMST03020589 (1alpha-hydroxy-18-[m-(1-hydroxy-1-methylethyl)-benzyloxy]-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-[m-(1-hydroxy-1-methylethyl)-benzyloxy]-23,24,25,26,27-pentanorcholecalciferol)": ["C32H46O4", "Sterol Lipids [ST] with formula: C32H46O4"],
        "LMST03020622 (ZK 168281); LMST03020511 (11-(3-acetoxy-1-propynyl)-1alpha,25-dihydroxy-9,11-didehydrovitamin D3 / 11-(3-acetoxy-1-propynyl)-1alpha,25-dihydroxy-9,11-didehydrocholecalciferol)": ["C32H46O5", "Sterol Lipids [ST] with formula: C32H46O5"],
        "LMST01010104 (Cucurbitacin B)": ["C32H46O8", "Sterol Lipids [ST] with formula: C32H46O8"],
        "LMST01010103 (Cucurbitacin A)": ["C32H46O9", "Sterol Lipids [ST] with formula: C32H46O9"],
        "LMST03020512 ((22E,24E,24bE)-1alpha,25-dihydroxy-26,27-dimethyl-22,23,24,24a,24b,24c-hexadehydro-24a,24b,24c-trihomovitamin D3 / (22E,24E,24bE)-1alpha,25-dihydroxy-26,27-dimethyl-22,23,24,24a,24b,24c-hexadehydro-24a,24b,24c-trihomocholecalciferol)": ["C32H48O3", "Sterol Lipids [ST] with formula: C32H48O3"],
        "LMST03020621 (ZK 159222)": ["C32H48O5", "Sterol Lipids [ST] with formula: C32H48O5"],
        "LMST01010115 (Cucurbitacin Q); LMST01010105 (Cucurbitacin C)": ["C32H48O8", "Sterol Lipids [ST] with formula: C32H48O8"],
        "LMST03020514 (1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a,24b,24c-trihomo-20-epivitamin D3 / 1alpha,25-dihydroxy-26,27-dimethyl-22,22,23,23-tetradehydro-24a,24b,24c-trihomo-20-epicholecalciferol); LMST03020513 ((22E,24E)-1alpha,25-dihydroxy-26,27-diethyl-22,23,24,24a-tetradehydro-24a-homovitamin D3 / (22E,24E)-1alpha,25-dihydroxy-26,27-diethyl-22,23,24,24a-tetradehydro-24a-homocholecalciferol)": ["C32H50O3", "Sterol Lipids [ST] with formula: C32H50O3"],
        "LMST03020519 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a,24b,24c-trihomovitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a,24b,24c-trihomocholecalciferol); LMST03020518 ((22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a,24b,24c-trihomo-20-epivitamin D3 / (22S)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a,24b,24c-trihomo-20-epicholecalciferol); LMST03020517 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a,24b,24c-trihomovitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,23,24,24-tetradehydro-24a,24b,24c-trihomocholecalciferol); LMST03020516 ((22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a,24b,24c-trihomo-20-epivitamin D3 / (22R)-1alpha,22,25-trihydroxy-26,27-dimethyl-23,24-tetradehydro-24a,24b,24c-trihomo-20-epicholecalciferol); LMST03020515 ((22S)-1alpha,25-dihydroxy-22-ethoxy-26,27-dimethyl-23,24-tetradehydro-24a-homo-20-epivitamin D3 / (22S)-1alpha,25-dihydroxy-22-ethoxy-26,27-dimethyl-23,24-tetradehydro-24a-homo-20-epicholecalciferol)": ["C32H50O4", "Sterol Lipids [ST] with formula: C32H50O4"],
        "LMST03020634 (16-Glutaryloxy-1alpha,25-dihydroxyvitamin D3); LMST03020635 (16-Glutaryloxy-1alpha,25-dihydroxy-20-epivitamin D3)": ["C32H50O7", "Sterol Lipids [ST] with formula: C32H50O7"],
        "LMST05010048 (Glycochenodeoxycholic acid 3-glucuronide)": ["C32H51NO11", "Sterol Lipids [ST] with formula: C32H51NO11"],
        "LMST05010029": ["C32H51NO12", "Sterol Lipids [ST] with formula: C32H51NO12"],
        "LMST05040009 (Taurolithocholic acid 3-glucuronide)": ["C32H53NO11S", "Sterol Lipids [ST] with formula: C32H53NO11S"],
        "LMST05010023 (Glycocholic acid 3-glucuronide)": ["C32H53NO12", "Sterol Lipids [ST] with formula: C32H53NO12"],
        "LMST03020520 (1alpha,25-dihydroxy-2beta-pentylvitamin D3 / 1alpha,25-dihydroxy-2beta-pentylcholecalciferol); LMST03020521 (1alpha,25-dihydroxy-26,27-diethyl-24a-homovitamin D3 / 1alpha,25-dihydroxy-26,27-diethyl-24a-homocholecalciferol)": ["C32H54O3", "Sterol Lipids [ST] with formula: C32H54O3"],
        "LMST03020522 (1alpha-hydroxy-2beta-(5-hydroxypentoxy)vitamin D3 / 1alpha-hydroxy-2beta-(5-hydroxypentoxy)cholecalciferol); LMST03020523 (1alpha,25-dihydroxy-2beta-(5-hydroxypentyl)vitamin D3 / 1alpha,25-dihydroxy-2beta-(5-hydroxypentyl)cholecalciferol); LMST03020526 (26,27-diethyl-1alpha,25-dihydroxy-24a,24b-dihomo-23-oxa-20-epivitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-24a,24b-dihomo-23-oxa-20-epicholecalciferol); LMST03020524 ((20S)-1alpha,25-dihydroxy-20-methoxy-26,27-diethylvitamin D3 / (20S)-1alpha,25-dihydroxy-20-methoxy-26,27-diethylcholecalciferol); LMST03020525 ((20S)-1alpha,25-dihydroxy-20-ethoxy-26,27-dimethyl-24a-homovitamin D3 / (20S)-1alpha,25-dihydroxy-20-ethoxy-26,27-dimethyl-24a-homocholecalciferol); LMST03020613 (1alpha,25-Dihydroxy-21-(3-hydroxy-3-methylbutyl)vitamin D(3))": ["C32H54O4", "Sterol Lipids [ST] with formula: C32H54O4"],
        "LMST03020527 (1alpha,25-dihydroxy-2beta-(5-hydroxypentoxy)vitamin D3 / 1alpha,25-dihydroxy-2beta-(5-hydroxypentoxy)cholecalciferol); LMST03020633 ((20S)-24-Hydroxygeminivitamin D3); LMST03020631 ((20R)-24-Hydroxygeminivitamin D3)": ["C32H54O5", "Sterol Lipids [ST] with formula: C32H54O5"],
        "LMST03020528 (1alpha,25-dihydroxy-11alpha-phenylvitamin D3 / 1alpha,25-dihydroxy-11alpha-phenylcholecalciferol); LMST03020529 (1alpha,25-dihydroxy-11beta-phenylvitamin D3 / 1alpha,25-dihydroxy-11beta-phenylcholecalciferol)": ["C33H48O3", "Sterol Lipids [ST] with formula: C33H48O3"],
        "LMST05010020 ((23S)-23,25-dihydroxy-24-oxovitamin D3 23-(beta-glucuronide) / (23S)-23,25-dihydroxy-24-oxocholecalciferol 23-(beta-glucuronide))": ["C33H50O10", "Sterol Lipids [ST] with formula: C33H50O10"],
        "LMST03020551 (2alpha-(benzyloxy)-1alpha,25-dihydroxy-19-norvitamin D3 / 2alpha-(benzyloxy)-1alpha,25-dihydroxy-19-norcholecalciferol)": ["C33H50O4", "Sterol Lipids [ST] with formula: C33H50O4"],
        "LMST03020617 (11alpha-Hemiglutaryloxy-1,25-dihydroxyvitamin D3)": ["C33H52O6", "Sterol Lipids [ST] with formula: C33H52O6"],
        "LMST03020610 (Vitamin D3 glucosiduronate)": ["C33H52O7", "Sterol Lipids [ST] with formula: C33H52O7"],
        "LMST03020671 (1-Hydroxyvitamin D3 3-D-glucopyranoside)": ["C33H52O8", "Sterol Lipids [ST] with formula: C33H52O8"],
        "LMST01090002 (nuatigenin 3-beta-D-glucopyranoside); LMST01080006 (agavoside A)": ["C33H52O9", "Sterol Lipids [ST] with formula: C33H52O9"],
        "LMST01010192 (ecdysone 25-O-D-glucopyranoside)": ["C33H54O11", "Sterol Lipids [ST] with formula: C33H54O11"],
        "LMST05010043 (Cholesterol glucuronide)": ["C33H54O7", "Sterol Lipids [ST] with formula: C33H54O7"],
        "LMST01080008 ((25S)-5beta-spirostan-3beta-yl beta-D-glucoside); LMST03020611 (1,25-Dihydroxyvitamin D3 3-glycoside)": ["C33H54O8", "Sterol Lipids [ST] with formula: C33H54O8"],
        "LMST05010042": ["C33H56O10", "Sterol Lipids [ST] with formula: C33H56O10"],
        "LMST03020531 (1alpha,25-dihydroxy-26,27-dipropylvitamin D3 / 1alpha,25-dihydroxy-26,27-dipropylcholecalciferol); LMST03020533 (26,27-diethyl-1alpha,25-dihydroxy-24a,24b-dihomovitamin D3 / 26,27-diethyl-1alpha,25-dihydroxy-24a,24b-dihomocholecalciferol); LMST03020532 (1alpha,25-dihydroxy-26,26, 26,27,27,27-hexamethylvitamin D3 / 1alpha,25-dihydroxy-26,26,26,27,27,27-hexamethylcholecalciferol)": ["C33H56O3", "Sterol Lipids [ST] with formula: C33H56O3"],
        "LMST03020534 (1alpha,25-dihydroxy-2beta-(6-hydroxyhexyl)vitamin D3 / 1alpha,25-dihydroxy-2beta-(6-hydroxyhexyl)cholecalciferol)": ["C33H56O4", "Sterol Lipids [ST] with formula: C33H56O4"],
        "LMST01010173 (cholesteryl beta-D-glucoside)": ["C33H56O6", "Sterol Lipids [ST] with formula: C33H56O6"],
        "LMST01070001": ["C33H56O9", "Sterol Lipids [ST] with formula: C33H56O9"],
        "LMST03020535 (1alpha,25-dihydroxy-11-(4-hydroxymethylphenyl)-9,11-didehydrovitamin D3 / 1alpha,25-dihydroxy-11-(4-hydroxymethylphenyl)-9,11-didehydrocholecalciferol)": ["C34H48O4", "Sterol Lipids [ST] with formula: C34H48O4"],
        "LMST03020590 (1alpha-hydroxy-18-[m-(1-hydroxy-1-ethylpropyl)-benzyloxy]-23,24,25,26,27-pentanorvitamin D3 / 1alpha-hydroxy-18-[m-(1-hydroxy-1-ethylpropyl)-benzyloxy]-23,24,25,26,27-pentanorcholecalciferol)": ["C34H50O4", "Sterol Lipids [ST] with formula: C34H50O4"],
        "LMST03010072 (Vitamin D2 3-glucuronide); LMST03010070 (Vitamin D2 glucosiduronate)": ["C34H52O7", "Sterol Lipids [ST] with formula: C34H52O7"],
        "LMST05010021 (25-hydroxyvitamin D2 25-(beta-glucuronide) / 25 hydroxyergocalciferol 25-(beta-glucuronide)); LMST03010071 (25-Hydroxyvitamin D2 25-(beta-glucuronide))": ["C34H52O8", "Sterol Lipids [ST] with formula: C34H52O8"],
        "LMST03020537 ((6S)-vitamin D3 6,19-(4-phenyl-1,2,4-triazoline-3,5-dione) adduct / (6S)-cholecalciferol 6,19-(4-phenyl-1,2,4-triazoline-3,5-dione) adduct); LMST03020536 ((6R)-vitamin D3 6,19-(4-phenyl-1,2,4-triazoline-3,5-dione) adduct / (6R)-cholecalciferol 6,19-(4-phenyl-1,2,4-triazoline-3,5-dione) adduct)": ["C35H49N3O3", "Sterol Lipids [ST] with formula: C35H49N3O3"],
        "LMST03020538 (11alpha-(4-dimethylaminophenyl)-1alpha,25-dihydroxyvitamin D3 / 11alpha-(4-dimethylaminophenyl)-1alpha,25-dihydroxycholecalciferol)": ["C35H53NO3", "Sterol Lipids [ST] with formula: C35H53NO3"],
        "LMST03020539 (11-(4-acetoxymethylphenyl)-1alpha,25-dihydroxy-9,11-didehydrovitamin D3 / 11-(4-acetoxymethylphenyl)-1alpha,25-dihydroxy-9,11-didehydrocholecalciferol)": ["C36H50O5", "Sterol Lipids [ST] with formula: C36H50O5"],
        "LMST01130005 (Scillaren A)": ["C36H52O13", "Sterol Lipids [ST] with formula: C36H52O13"],
        "LMST01130006 (hellebrin)": ["C36H52O15", "Sterol Lipids [ST] with formula: C36H52O15"],
        "LMST01100009 (abrusoside A)": ["C36H54O10", "Sterol Lipids [ST] with formula: C36H54O10"],
        "LMST01120015 (digitalin)": ["C36H56O14", "Sterol Lipids [ST] with formula: C36H56O14"],
        "LMST03020543 (1alpha,25-dihydroxy-25,25-diphenyl-26,27-dinorvitamin D3 / 1alpha,25-dihydroxy-25,25-diphenyl-26,27-dinorcholecalciferol)": ["C37H48O3", "Sterol Lipids [ST] with formula: C37H48O3"],
        "LMST01100006 (cimicifoetiside A)": ["C37H58O10", "Sterol Lipids [ST] with formula: C37H58O10"],
        "LMST01130009 (Glucoscilliroside)": ["C38H54O16", "Sterol Lipids [ST] with formula: C38H54O16"],
        "LMST01100007 (cimicifoetiside B)": ["C39H60O11", "Sterol Lipids [ST] with formula: C39H60O11"],
        "LMST03020670 (1-Hydroxyvitamin D3 cellobioside)": ["C39H64O12", "Sterol Lipids [ST] with formula: C39H64O12"],
        "LMST01020001 (12:0 Cholesteryl ester)": ["C39H68O2", "Sterol Lipids [ST] with formula: C39H68O2"],
        "LMST01120018 (digitoxin)": ["C41H64O13", "Sterol Lipids [ST] with formula: C41H64O13"],
        "LMST01120017 (gitoxin); LMST01120023 (Digoxin)": ["C41H64O14", "Sterol Lipids [ST] with formula: C41H64O14"],
        "LMST01120012 (diginatin)": ["C41H64O15", "Sterol Lipids [ST] with formula: C41H64O15"],
        "LMST01020021 (14:1 Cholesteryl ester)": ["C41H70O2", "Sterol Lipids [ST] with formula: C41H70O2"],
        "LMST01020004 (14:0 Cholesteryl ester)": ["C41H72O2", "Sterol Lipids [ST] with formula: C41H72O2"],
        "LMST03020541 ((6R)-vitamin D3 6,19-[4-{2-(6,7-dimethoxy-4-methyl-3-oxo-3,4-dihydroquinoxalinyl)ethyl}-1,2,4-triazoline-3,5-dione] adduct / (6R)-cholecalciferol 6,19-[4-{2-(6,7-dimethoxy-4-methyl-3-oxo-3,4-dihydroquinoxalinyl)ethyl}-1,2,4-triazoline-3,5-dione] adduct); LMST03020542 ((6S)-vitamin D3 6,19-[4-{2-(6,7-dimethoxy-4-methyl-3-oxo-3,4-dihydroquinoxalinyl)ethyl}-1,2,4-triazoline-3,5-dione] adduct / (6S)-cholecalciferol 6,19-[4-{2-(6,7-dimethoxy-4-methyl-3-oxo-3,4-dihydroquinoxalinyl)ethyl}-1,2,4-triazoline-3,5-dione] adduct)": ["C42H59N5O6", "Sterol Lipids [ST] with formula: C42H59N5O6"],
        "LMST01120019 (thevetin A)": ["C42H64O19", "Sterol Lipids [ST] with formula: C42H64O19"],
        "LMST01120011 (thevetin B)": ["C42H66O18", "Sterol Lipids [ST] with formula: C42H66O18"],
        "LMST01020022 (15:1 Cholesteryl ester)": ["C42H72O2", "Sterol Lipids [ST] with formula: C42H72O2"],
        "LMST01020027 (15:0 Cholesteryl ester)": ["C42H74O2", "Sterol Lipids [ST] with formula: C42H74O2"],
        "LMST01020035 (zymosteryl palmitoleate); LMST01020024 (16:2 Cholesteryl ester)": ["C43H72O2", "Sterol Lipids [ST] with formula: C43H72O2"],
        "LMST01020006 (16:1 Cholesteryl ester); LMST03020653 (Vitamin D3 palmitate)": ["C43H74O2", "Sterol Lipids [ST] with formula: C43H74O2"],
        "LMST01020036 (ecdysone palmitate)": ["C43H74O7", "Sterol Lipids [ST] with formula: C43H74O7"],
        "LMST01020005 (16:0 Cholesteryl ester)": ["C43H76O2", "Sterol Lipids [ST] with formula: C43H76O2"],
        "LMST01031011 (ergosteryl palmitoleate)": ["C44H72O2", "Sterol Lipids [ST] with formula: C44H72O2"],
        "LMST01031013 (fecosteryl palmitoleate); LMST01031009 (episteryl palmitoleate)": ["C44H74O2", "Sterol Lipids [ST] with formula: C44H74O2"],
        "LMST01020023 (17:1 Cholesteryl ester)": ["C44H76O2", "Sterol Lipids [ST] with formula: C44H76O2"],
        "LMST01020026 (17:0 Cholesteryl ester)": ["C44H78O2", "Sterol Lipids [ST] with formula: C44H78O2"],
        "LMST01020009 (18:3 Cholesteryl ester)": ["C45H74O2", "Sterol Lipids [ST] with formula: C45H74O2"],
        "LMST01020028 (Cholesteryl nitrolinoleate)": ["C45H75NO4", "Sterol Lipids [ST] with formula: C45H75NO4"],
        "LMST01020008 (18:2 Cholesteryl ester); LMST01020034 (zymosteryl oleate)": ["C45H76O2", "Sterol Lipids [ST] with formula: C45H76O2"],
        "LMST01020003 (18:1 Cholesteryl ester)": ["C45H78O2", "Sterol Lipids [ST] with formula: C45H78O2"],
        "LMST01020007 (18:0 Cholesteryl ester)": ["C45H80O2", "Sterol Lipids [ST] with formula: C45H80O2"],
        "LMST01031010 (ergosteryl oleate)": ["C46H76O2", "Sterol Lipids [ST] with formula: C46H76O2"],
        "LMST01031012 (fecosteryl oleate); LMST01031008 (episteryl oleate); LMST01020033 (lanosteryl palmitoleate)": ["C46H78O2", "Sterol Lipids [ST] with formula: C46H78O2"],
        "LMST01020002 (19:0 Cholesteryl ester)": ["C46H82O2", "Sterol Lipids [ST] with formula: C46H82O2"],
        "LMST01020015 (20:5 Cholesteryl ester)": ["C47H74O2", "Sterol Lipids [ST] with formula: C47H74O2"],
        "LMST01020014 (20:4 Cholesteryl ester)": ["C47H76O2", "Sterol Lipids [ST] with formula: C47H76O2"],
        "LMST01020029 (Cholesteryl 11-hydroperoxy-eicosatetraenoate)": ["C47H76O4", "Sterol Lipids [ST] with formula: C47H76O4"],
        "LMST01020013 (20:3 Cholesteryl ester)": ["C47H78O2", "Sterol Lipids [ST] with formula: C47H78O2"],
        "LMST01020012 (20:2 Cholesteryl ester)": ["C47H80O2", "Sterol Lipids [ST] with formula: C47H80O2"],
        "LMST01020011 (20:1 Cholesteryl ester)": ["C47H82O2", "Sterol Lipids [ST] with formula: C47H82O2"],
        "LMST01020010 (20:0 Cholesteryl ester)": ["C47H84O2", "Sterol Lipids [ST] with formula: C47H84O2"],
        "LMST01010220": ["C48H78N7O19P3S", "Sterol Lipids [ST] with formula: C48H78N7O19P3S"],
        "LMST01010217; LMST01010219": ["C48H78N7O20P3S", "Sterol Lipids [ST] with formula: C48H78N7O20P3S"],
        "LMST01010216": ["C48H78N7O21P3S", "Sterol Lipids [ST] with formula: C48H78N7O21P3S"],
        "LMST01010221": ["C48H80N7O19P3S", "Sterol Lipids [ST] with formula: C48H80N7O19P3S"],
        "LMST01010218": ["C48H80N7O20P3S", "Sterol Lipids [ST] with formula: C48H80N7O20P3S"],
        "LMST01010215": ["C48H80N7O21P3S", "Sterol Lipids [ST] with formula: C48H80N7O21P3S"],
        "LMST01020032 (lanosteryl oleate)": ["C48H82O2", "Sterol Lipids [ST] with formula: C48H82O2"],
        "LMST01020019 (22:6 Cholesteryl ester)": ["C49H76O2", "Sterol Lipids [ST] with formula: C49H76O2"],
        "LMST01020031 (22:5 Cholesteryl ester)": ["C49H78O2", "Sterol Lipids [ST] with formula: C49H78O2"],
        "LMST01020018 (22:4 Cholesteryl ester)": ["C49H80O2", "Sterol Lipids [ST] with formula: C49H80O2"],
        "LMST01020017 (22:2 Cholesteryl ester)": ["C49H84O2", "Sterol Lipids [ST] with formula: C49H84O2"],
        "LMST01020025 (22:1 Cholesteryl ester)": ["C49H86O2", "Sterol Lipids [ST] with formula: C49H86O2"],
        "LMST01020016 (22:0 Cholesteryl ester)": ["C49H88O2", "Sterol Lipids [ST] with formula: C49H88O2"],
        "LMST01150015 (tomatine)": ["C50H83NO21", "Sterol Lipids [ST] with formula: C50H83NO21"],
        "LMST01020020 (24:1 Cholesteryl ester)": ["C51H90O2", "Sterol Lipids [ST] with formula: C51H90O2"],
        "LMST01080003 (digitonin)": ["C56H92O29", "Sterol Lipids [ST] with formula: C56H92O29"],
    },
}


# finalize compounds
try:
    for group in compounds:
        for name in compounds[group]:
            compound = mspy.compound(compounds[group][name][0])
            compound.description = compounds[group][name][1]
            compounds[group][name] = compound
except:
    compounds = {}