# MMAopts.py

import getopt
import sys
import MMAglobals;  gbl = MMAglobals
from MMAcommon import *
import MMAdocs

def opts():
	""" Option parser.
	
		This is a wrapper around the standard getopt package. Permits
		any order of options / filename / options.
	"""
	
	args = sys.argv[1:]
	
	while args:
		args = parse(args)
		if args:
			if gbl.infile:
				usage("Only one input filename is permitted.")
			gbl.infile = args.pop(0)
		
		
	
def parse(args):
	""" Parse loop. All the options are defined here. """
	
	try:
		opts, args = getopt.getopt(args, "dpsrwneom:f:cgvD:", [])
		
	except getopt.GetoptError:
		usage()

	for o,a in opts:
		if o == '-d':
			gbl.debug = 1
		elif o == '-o':
			gbl.showFilenames = 1
		elif o == '-p':
			gbl.pshow = 1
		elif o == '-s':
			gbl.seqshow = 1
		elif o == '-r':
			gbl.showrun = 1
		elif o == '-w':
			gbl.noWarn = 1
		elif o == '-n':
			gbl.noOutput = 1
		elif o == '-e':
			gbl.showExpand = 1
		elif o == '-c':
			gbl.chshow = 1
		elif o == '-f':
			gbl.outfile = a
		elif o == '-g':
			gbl.makeGrvDefs = 1
		elif o == '-m':
			try:
				a=int(a)
			except:
				error("Expecting -m arg to be a integer")
			gbl.maxBars = a
		elif o == '-v':
			print "%s" % gbl.version
			sys.exit()
		elif o == '-D':
			if a == 'x':
				gbl.docs = 1
				
			elif a == 'n':
				import MMAchords
				MMAchords.docs()
				sys.exit(0)
										
			elif a == 'da':
				MMAdocs.docDrumNames("a")
				sys.exit(0)
			
			elif a == 'dm':
				MMAdocs.docDrumNames("m")
				sys.exit(0)
						
			elif a == 'ia':
				MMAdocs.docInstNames("a")
				sys.exit(0)
				
			elif a == 'im':
				MMAdocs.docInstNames("m")
				sys.exit(0)

			else:
				print "Unknown argument for -D"
				usage()

	
		else:
			usage()	  # unreachable??

	return args


def usage(msg=''):
	""" Usage message. """
			
	txt=[
		"MMA - Musical Midi Accompaniment",
		"  Copyright 2003-4, Bob van der Poel. Version %s" % gbl.version ,
		"  Usage: mma [opts ...] INFILE [opts ...]",
		"",
		"Options:",		
		" -d    Enable LOTS of debugging messages",
		" -p    Display patterns as they are defined",
		" -s    Display sequence info during run",
		" -r    Display running progress",
		" -w    Disable warning messages",
		" -n    Disable generation of midi output",
		" -e    Show parsed/expanded lines",
		" -c    Display default channel assignments",
		" -m<x> Set maxBars (default == 500)",
		" -o    Show complete filenames when opened",
		" -g    create Groove dependency files",
		" -v    Display version number",
		" -D<> Extract documentation",
		"    <x>  extract doc blocks from file",
		"    <n>  Note/chord table",
		"    <dm> Midi drum names (by MIDI value)",
		"    <da> Midi drum names (alphabetical)",
		"    <im> Inst. names (ab MIDI value)",
		"    <ia> Inst. names (alphabetical)",
		" -f<file>  Set output Filename"	]

	for a in txt:
		print a		
			
	if msg:
		print
		print msg
			
	print
	sys.exit(1)
	

