"""
	MMAauto.py
	
	Various routines dealing with the library database.
	
"""
	

import os
import glob
import sys
import time
import MMAglobals;  gbl = MMAglobals
import MMAparse
from MMAcommon import *

grooveDir = {}
mmadir = "MMADIR"	# constant, name of the lib database file


def libUpdate():
	""" Update the mma library database file(s).
	
		This is called from the main loop after all the options have been
		parsed. 
		
	"""

	for l in gbl.libPath:
		libpath = os.path.expanduser(l)

		try:
			outpath = file(os.path.join(libpath, mmadir), 'w')
		except:
			error("Error creating lib-database file '%s'. CRITICAL!" % libpath)

		outpath.write(
			"# Auto-Created MMA Library Database File, do not edit.\n" 
			"# Date: %s\n" % time.ctime(time.time()) +
			"# Lib: %s\n" % libpath +
			"# The format of this file is quite simple...each line\n" 
			"# has a pathname followed by a list of grooves\n" 
			"# that are defined in the file. This info is used by the\n" 
			"# the auto-groove-find routines in MMA.\n\n"
			"# To update use: 'mma -g'\n\n" )

		dolibupdate(outpath, l, '')
		outpath.close()		
		
	sys.exit(0)
		
def dolibupdate(out, root, subdir):

	if subdir == '.':
		print "\tDirectory '.' is ignored in this option."
	else:
		print "\tProcessing library directory '%s'." % subdir
	

	# loop though all files in dir
			
	p = os.path.join(root,subdir)
	dirfiles = os.listdir(p)

	if dirfiles.count("MMAIGNORE"):
		print "\tIgnoring directory '%s'" % p
		out.write("# Directory '%s' ignored" % p)
		return
		
	for fn in dirfiles:
		f=os.path.join(root, subdir, fn)
		
		if os.path.isdir(f):
			dolibupdate(out, root, os.path.join(subdir,fn))
			
		if f.endswith(gbl.ext):
			print "\tCreating database entry for '%s'" % f
			gbl.mkGrooveList = []
			MMAparse.parseFile(f)
			out.write( os.path.join(subdir, fn)  + ' ' + ' '.join(gbl.mkGrooveList) + '\n' )

		else:
			print "\tIgnoring file '%s'" % f



def loadGrooveDir(g):
	""" Try to auto-load a groove from the library.
	
		The compliation of all the MMADIR files is stored in the dict
		grooveDir{}. 
	
		Each directory in the libpath is checked for a MMADIR file and
		the names of the files and corresponding grooves are extracted.
		This is stored in a dictionary with the filename as the key
		and a list of grooves as the data.
		
	"""

	# If the global dict grooveDir is empty we first load the MMADIR info.
	# Only done once!
	
	if not grooveDir:
		for l in gbl.libPath:		
			try:
				f=file(os.path.join(os.path.expanduser(l), mmadir), 'r') 
			except:
				continue

			for ln in f:
				ln=ln.strip()
				if ln and ln[0] != '#':
					ln=ln.split()
					if len(ln) >= 2:
						grooveDir[ln[0]] = ln[1:]
					
			f.close()

	# Search the dict for a match.
	#	 RETURN: Lib-Filename if found
	#   	     None if not found

	for l in grooveDir.keys():
		if grooveDir[l].count(g):
			return l
	
	return None


