/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 */

/*
 *	Definitions of data structures generated by the menu compiler
 *	and expected by the menu program. All offsets are from the
 *	beginning of the data area.
 */

/*
 *	Structure describing the data area, starts at 0.
 */
struct menu_header
{
	char		major, minor;	/* Versions */
	unsigned short	flags;		/* Capabilities */
	unsigned int	timeout;	/* Global timeout */
	unsigned int	selectprompt;	/* Offset of string saying Select... */
	unsigned int	confirmprompt;	/* Offset of string saying Confirm... */
	unsigned int	nmenus;		/* Number of menus stored */
	/* Here follow unsigned int offsets of menus */
};

/*
 *	Structure describing one menu. The number of items is one
 *	greater than the last valid index. The 0th item holds the
 *	data to be displayed before any user input.
 */
struct menu
{
	unsigned int	timeout;	/* Timeout for this menu */
	unsigned int	nitems;		/* Items in this menu */
	/* Here follow unsigned int offsets of items */
};

/*
 *	Structure describing one item in a menu.
 */
struct item
{
	unsigned int	title;
};
