#include <typeinfo>
#include <string>

#include "stdinc/types.H"
#include "stdinc/stlincludes.H"


#ifndef _memusage_h
#define _memusage_h

//#define CEBUG(bla)   {cout << bla; cout.flush(); }
//#define CEBUG(bla) 



/*************************************************************************
 *
 * Calculation routines
 *
 *************************************************************************/

// for strings
// this is a real cludge
inline void emuoc_statsOnType(const string & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer);

// for simple types (int, structs, unions, objects etc)
template<class myType>
inline void emuoc_statsOnType(const myType & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer);

// for containers without capacity
template<class myType>
inline void emuoc_statsOnType_sizeonly(const myType & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer, size_t overhead_elem);

// for containers with capacity (at the moment only vector?)
template<class myType>
inline void emuoc_statsOnType_sizeAndCapacity(const myType & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer);


/*************************************************************************
 *
 * Specialised hooks
 *
 *************************************************************************/

template<class myType>
inline void emuoc_statsOnType(const vector<myType> & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{

  emuoc_statsOnType_sizeAndCapacity(
    c,total_size,total_freecap, total_lostba, num_size, 
    bytes_size, overhead, lostbyalign, iscontainer);
  // overhead of each elem is 0
}

template<class myType>
inline void emuoc_statsOnType(const vector<string> & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{

  emuoc_statsOnType_sizeAndCapacity(
    c,total_size,total_freecap, total_lostba, num_size, 
    bytes_size, overhead, lostbyalign, iscontainer);
  // overhead of each elem is 0
}

template<class myType>
inline void emuoc_statsOnType(const list<myType> & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{

  emuoc_statsOnType_sizeonly(c,total_size,total_freecap, total_lostba, num_size, 
		bytes_size, overhead, lostbyalign, iscontainer,
		2*sizeof(void *));
  // overhead of each elem is a forward and a reverse pointer
}


//template<class myType>
//inline void emuoc_statsOnType(const slist<myType> & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
//{
//
//  emuoc_statsOnType_sizeonly(c,total_size,total_freecap, total_lostba, num_size, 
//		bytes_size, overhead, lostbyalign, iscontainer,
//		sizeof(void *));
//  // overhead of each elem is a forward pointer
//}

template<class myType>
inline void emuoc_statsOnType(const set<myType> & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{

  emuoc_statsOnType_sizeonly(c,total_size,total_freecap, total_lostba, num_size, 
		bytes_size, overhead, lostbyalign, iscontainer,
		4*sizeof(void *));
  // overhead of each elem is 
  //  - the tree color (padded to fill up void *)
  //  - a parent, a left and a right child
}

template<class myType>
inline void emuoc_statsOnType(const multiset<myType> & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{

  emuoc_statsOnType_sizeonly(c,total_size,total_freecap, total_lostba, num_size, 
		bytes_size, overhead, lostbyalign, iscontainer,
		4*sizeof(void *));
  // overhead of each elem is 
  //  - the tree color (padded to fill up void *)
  //  - a parent, a left and a right child
}


template<class myType1,class myType2>
inline void emuoc_statsOnType(const map<myType1,myType2> & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{

  emuoc_statsOnType_sizeonly(c,total_size,total_freecap, total_lostba, num_size, 
		bytes_size, overhead, lostbyalign, iscontainer,
		4*sizeof(void *));
  // overhead of each elem is 
  //  - the tree color (padded to fill up void *)
  //  - a parent, a left and a right child
}

template<class myType1,class myType2>
inline void emuoc_statsOnType(const multimap<myType1,myType2> & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{
  emuoc_statsOnType_sizeonly(c,total_size,total_freecap, total_lostba, num_size, 
		bytes_size, overhead, lostbyalign, iscontainer,
		4*sizeof(void *));
  // overhead of each elem is 
  //  - the tree color (padded to fill up void *)
  //  - a parent, a left and a right child
}




template<class myType>
size_t estimateMemoryUsageOfContainer(const myType & c, bool withoverhead, size_t & numelem, size_t & bytes_size, size_t & free_capacity, size_t & lostbyalign)
{
  CEBUG("dido called with: " << typeid(myType).name() << endl);
  
  numelem=0;
  bytes_size=0;
  free_capacity=0;
  lostbyalign=0;

  {
    size_t stats_s, stats_o, stats_lba;
    bool stats_isc;

    // specifying <myType> in the function call helps the compiler
    //  to resolve to the correct objetc type and only switch to
    //  generic if everything else fails
    emuoc_statsOnType(c,numelem,free_capacity,lostbyalign,
		stats_s,bytes_size,stats_o,stats_lba,stats_isc);

    if(!withoverhead) {
      bytes_size-=sizeof(myType);
    }

    CEBUG("Stats total size: " << numelem << endl);
    CEBUG("Stats byte size: " << bytes_size << endl);
    CEBUG("Stats total free cap: " << free_capacity << endl);
    CEBUG("Stats total lba: " << lostbyalign << endl);
    
    CEBUG("Stats size: " << stats_s << endl);
    CEBUG("Stats overhead: " << stats_o << endl);
    CEBUG("Stats lost b align: " << stats_lba << endl);
    CEBUG("Stats is container: " << stats_isc << endl);
  }

  return bytes_size;
}


template<class myType>
size_t estimateMemoryUsageOfContainer(const myType & c, bool withoverhead)
{
  CEBUG("dido called with: " << typeid(myType).name() << endl);
  
  size_t numelem, bytes_size, free_capacity, lostbyalign;

  numelem=0;
  bytes_size=0;
  free_capacity=0;
  lostbyalign=0;

  {
    size_t stats_s, stats_o, stats_lba;
    bool stats_isc;

    // specifying <myType> in the function call helps the compiler
    //  to resolve to the correct objetc type and only switch to
    //  generic if everything else fails
    emuoc_statsOnType(c,numelem,free_capacity,lostbyalign,
		stats_s,bytes_size,stats_o,stats_lba,stats_isc);

    if(!withoverhead) {
      bytes_size-=sizeof(myType);
    }

    CEBUG("Stats total size: " << numelem << endl);
    CEBUG("Stats byte size: " << bytes_size << endl);
    CEBUG("Stats total free cap: " << free_capacity << endl);
    CEBUG("Stats total lba: " << lostbyalign << endl);
    
    CEBUG("Stats size: " << stats_s << endl);
    CEBUG("Stats overhead: " << stats_o << endl);
    CEBUG("Stats lost b align: " << stats_lba << endl);
    CEBUG("Stats is container: " << stats_isc << endl);
  }

  return bytes_size;
}

//#define CEBUG(bla) 





/*************************************************************************
 *
 * Calculation routines
 *
 *************************************************************************/

// for strings
// this is a real cludge
inline void emuoc_statsOnType(const string & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{
  CEBUG("emuoc_statsOnType(string): " << typeid(c).name() << endl);

  (void) c;
  (void) total_freecap;
  (void) total_lostba;

  total_size++;
  num_size=1;
  // at least in gcc we seem to have:
  //  one pointer
  overhead=sizeof(c);
  //  and if the string has capacity, 3 class variables
  //  (round to 4 for alignment)
  if(c.capacity()>0) overhead+=4 * sizeof(size_t);
  bytes_size=overhead+c.capacity();
  iscontainer=true;

  lostbyalign=0;
  if(bytes_size%sizeof(void *)){
    lostbyalign=sizeof(void *)-bytes_size%sizeof(void *);
  }
  CEBUG("Lost by align: " <<lostbyalign << endl);

  return;
}



// for simple types (int, structs, unions, objects etc)
template<class myType>
inline void emuoc_statsOnType(const myType & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{
  CEBUG("emuoc_statsOnType(generic): " << typeid(myType).name() << endl);

  (void) c;
  (void) total_freecap;
  (void) total_lostba;

  total_size++;
  num_size=1;
  bytes_size=sizeof(c);
  overhead=0;
  iscontainer=false;

  lostbyalign=0;
  if(bytes_size%sizeof(void *)){
    lostbyalign=sizeof(void *)-bytes_size%sizeof(void *);
  }
  CEBUG("Lost by align: " <<lostbyalign << endl);

  return;
}


// for containers without capacity
template<class myType>
inline void emuoc_statsOnType_sizeonly(const myType & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer, size_t overhead_elem)
{
  CEBUG("emuoc_statsOnType(simple): " << typeid(list<myType>).name() << endl);

  (void) c;
  (void) total_freecap;
  num_size=0;
  overhead=sizeof(myType);
  bytes_size=overhead;
  lostbyalign=0;
  iscontainer=true;

  typename myType::const_iterator cI=c.begin();
  for(; cI != c.end(); cI++){
    size_t stats_s, stats_bs, stats_o, stats_lba;
    bool stats_isc;
    CEBUG("loop\n");
    emuoc_statsOnType(*cI,total_size,total_freecap,total_lostba,
		stats_s,stats_bs,stats_o,stats_lba,stats_isc);
    num_size+=stats_s;
    bytes_size+=stats_bs+stats_lba+overhead_elem;
  }
  return;
}

// for containers with capacity (at the moment only vector?)
template<class myType>
inline void emuoc_statsOnType_sizeAndCapacity(const myType & c, size_t & total_size, size_t & total_freecap, size_t & total_lostba, size_t & num_size, size_t & bytes_size, size_t & overhead, size_t & lostbyalign, bool & iscontainer)
{
  CEBUG("emuoc_statsOnType(vector): " << typeid(vector<myType>).name() << endl);

  (void) c;
  num_size=0;
  overhead=sizeof(myType);
  bytes_size=overhead;
  lostbyalign=0;
  iscontainer=true;

  CEBUG("overhead: " << overhead
	<< "\nbytes_size: " << bytes_size
	<< "\ntotal_freecap: " << total_freecap
	<< endl);

  typename myType::const_iterator cI=c.begin();

  bool subelem_is_container=true;
  for(; cI != c.end(); cI++){
    size_t stats_s, stats_bs, stats_o, stats_lba;
    CEBUG("loop ");
    emuoc_statsOnType(
      *cI,total_size,total_freecap,total_lostba,
      stats_s,stats_bs,stats_o,stats_lba,
      subelem_is_container);
    // no lost by align and no overhead of elements in vector
    bytes_size+=stats_bs;
    CEBUG(stats_bs << " " << bytes_size << endl);
  }
  num_size+=c.size();
  CEBUG("size: " << num_size << endl);
  CEBUG("capacity: " << c.capacity() << endl);
  if(c.capacity() != num_size){
    size_t vtype=sizeof(typename myType::value_type);
    CEBUG("empty element: " << vtype << endl);
    total_freecap+=vtype*(c.capacity()-num_size);
    bytes_size+=vtype*(c.capacity()-num_size);
  } 
  if(bytes_size%sizeof(void *)){
    lostbyalign=sizeof(void *)-bytes_size%sizeof(void *);
    bytes_size+=lostbyalign;
  }

  total_lostba+=lostbyalign;

  CEBUG("at end:"
	<< "\n\tbytes_size: " << bytes_size
	<< "\n\ttotal_freecap: " << total_freecap
	<< "\n\tlost by align: " << lostbyalign
	<< "\n\ttotal lba: " << total_lostba);
  CEBUG("\nv_out\n");

  return;
}


#endif
