/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 2003 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

#ifndef _bas_gffparse_h_
#define _bas_gffparse_h_

#include <iostream>
#include <string>

#include "boost/unordered_map.hpp" 

#include "stdinc/defines.H"
#include "errorhandling/errorhandling.H"

#include "mira/multitag.H"


class GFFParse
{
  //Variables
private:
  static const bool   GFFP_staticfeaturesinit;
  static const char * GFFP_featuretranslations[];

  // maps to convert GFF features to "gap4" features"
  typedef boost::unordered_map<std::string, std::string> strstrmap;
  static strstrmap GFFP_mapgff2gap4;
  static strstrmap GFFP_mapgap42gff;

  vector<string> GFFP_seqnames;
  vector<string> GFFP_sequences;
  vector<vector<multitag_t> > GFFP_sequencetags;

  // map to sequence names (GFFP_seqnames)
  typedef boost::unordered_map<std::string, size_t> strintmap;
  strintmap GFFP_snmap;

  int32 GFFP_errorstatus;

public:


  //Functions
private:
  void foolCompiler();
  static bool staticInitialiser();
  void init();
  void zeroVars();

  void parseNormalGFFLine(const string & line,
			  const uint64 lineno,
			  vector<string> & substrs);
  void checkTagsOnceLoaded();

public:
  GFFParse();
  GFFParse(GFFParse const &other);
  ~GFFParse();

  GFFParse const & operator=(GFFParse const & other);
  friend ostream & operator<<(ostream &ostr, GFFParse const &gffp);

  void discard();

  void loadFile(const string & filename);
  size_t getNumSequences() const { return GFFP_sequences.size();};
  const string & getSequenceName(uint32 i) const;
  const string & getSequence(uint32 i) const;
  const vector<multitag_t> & getTags(uint32 i) const;

  static const char * translateGFFfeat2GAP4feat(const string & feature);
  static const char * translateGAP4feat2GFFfeat(const string & feature);

};


#endif
