; $Id: id.scm,v 1.27 2007/07/28 08:52:25 schwicht Exp $
; 18. Inductive definitions
; =========================

; Tests of add-algs (introducing free algebras)

(add-param-alg "ytensor" 'tensor-typeop
	       '("TensorPair" "alpha1=>alpha2=>ytensor")) 

(add-param-alg "ypair" 'prod-typeop
	       '("CartPair" "(unit=>alpha1)=>(unit=>alpha2)=>unit=>ypair"))

(add-param-alg "yplus" 'sum-typeop
	       '("Inleft" "alpha1=>yplus")
	       '("Inright" "alpha2=>yplus"))

(add-algs (list "tree" "tlist")
	  '("Leaf" "tree")
	  '("Branch" "tlist=>tree")
	  '("Empty" "tlist")
	  '("Tcons" "tree=>tlist=>tlist"))

(add-param-algs (list "labtree" "labtlist") 'alg-typeop 2
		'("LabLeaf" "alpha1=>labtree")
		'("LabBranch" "labtlist=>alpha2=>labtree")
		'("LabEmpty" "labtlist")
		'("LabTcons" "labtree=>labtlist=>labtlist"))

; An ordinal notation scheme by W. Buchholz:

(mload "../lib/nat.scm")

(add-algs (list "hterm" "htermlist" "term")
	  '("One" "hterm")
	  '("Dn" "nat=>term=>hterm")
	  '("Hempty" "htermlist")
	  '("Hcons" "hterm=>htermlist=>htermlist")
	  '("Seq" "htermlist=>term"))

; An example for an infinitary algebra (s. ~benl/demo2.scm)

(add-algs (list "inftree" "inftlist")
	  '("Newleaf" "nat=>inftree")
          '("Infbranch" "nat=>inftlist=>inftree")
          '("Lim" "nat=>(nat=>inftree)=>inftree")
          '("Emptyinftlist" "inftlist")
          '("Inftcons" "inftree=>inftlist=>inftlist"))

; Tests of add-ids (introducing inductively defined predicates)

(add-ids (list (list "Even" (make-arity (py "nat")) "algEven"))
	 '("Even 0" "InitEven")
	 '("allnc n.Even n -> Even(n+2)" "GenEven"))

(map car (alg-name-to-typed-constr-names "algEven"))
; ("InitEven" "GenEven")

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst "Even" '() '()))

; There are no types, since the clauses do not contain type variables,
; and no cterms, since the clauses do not contain parameter predicate
; variables.

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; "Even 0"
(define aconst1 (number-and-idpredconst-to-intro-aconst 1 idpc))
(pp (aconst-to-formula aconst1))
; "allnc n.Even n -> Even(n+2)"

(define eterm1 (proof-to-extracted-term (make-proof-in-aconst-form aconst1)))
(pp (term-to-type eterm1)) 
; "algEven=>algEven"

(add-pvar-name "Q" (make-arity (py "nat")))

(define aconst (imp-formulas-to-elim-aconst (pf "Even m^ -> Q m^")))
(pp (aconst-to-formula aconst))
; "allnc m^.Q  0 -> (allnc n.Even n -> Q n -> Q (n+2)) -> Even m^ -> Q m^"

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; "alpha5=>(algEven=>alpha5=>alpha5)=>algEven=>alpha5"


(add-ids (list (list "Ev" (make-arity (py "nat")) "algEv")
	       (list "Od" (make-arity (py "nat")) "algOd"))
	 '("Ev 0" "InitEv")
	 '("allnc n.Od n -> Ev(n+1)" "GenEv")
	 '("Od 1" "InitOd")
	 '("allnc n.Ev n -> Od(n+1)" "GenOd"))

(map car (alg-name-to-typed-constr-names "algEv"))
; ("InitEv" "GenEv")
(map car (alg-name-to-typed-constr-names "algOd"))
; ("InitOd" "GenOd")

(define idpcev
  (idpredconst-name-and-types-and-cterms-to-idpredconst "Ev" '() '()))
(define idpcod
  (idpredconst-name-and-types-and-cterms-to-idpredconst "Od" '() '()))

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpcev))
(pp (aconst-to-formula aconst0))
; "Ev 0"
(define aconst1 (number-and-idpredconst-to-intro-aconst 1 idpcev))
(pp (aconst-to-formula aconst1))
; "allnc n.Od n -> Ev(n+1)"

(define aconst3 (number-and-idpredconst-to-intro-aconst 0 idpcod))
(pp (aconst-to-formula aconst3))
; "Od 1"

(define aconst4 (number-and-idpredconst-to-intro-aconst 1 idpcod))
(pp (aconst-to-formula aconst4))
; "allnc n.Ev n -> Od(n+1)"

(define eterm4 (proof-to-extracted-term (make-proof-in-aconst-form aconst4)))
(pp (term-to-type eterm4))
; "algEv=>algOd"

(define aconst (imp-formulas-to-elim-aconst (pf "Ev m^ -> Q1 m^")
					    (pf "Od m^ -> Q2 m^")))
(pp (aconst-to-formula aconst))
; "allnc m^.Q1 0 -> (allnc n.Od n -> Q2 n -> Q1(n+1)) -> 
;           Q2 1 -> (allnc n.Ev n -> Q1 n -> Q2(n+1)) -> Ev m^ -> Q1 m^"

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; "alpha8=>(algOd=>alpha9=>alpha8)=>
;  alpha9=>(algEv=>alpha8=>alpha9)=>algEv=>alpha8"


; - the transitive closure of a relation <.  Introduction axioms:

;   x<y -> TrCl(x,y)
;   TrCl(x,y) -> y<z -> TrCl(x,z)

(add-var-name "x" (py "alpha"))
(add-pvar-name "R" (make-arity (py "alpha") (py "alpha")))

; 2007-07-28 
; This should be formulated with uniform implication 
; R x^1 x^2 ->^U instead of R^'x^1 x^2 -> to allow arbitrary Rs
; However, presently an attempt with R^'x^1 x^2 -> does not work

; (add-ids (list (list "TrCl" (make-arity (py "alpha") (py "alpha")) "algTrCl"))
; 	 '("all x^1,x^2(R^'x^1 x^2 -> TrCl x^1 x^2)" "InitTrCl")
; 	 '("all x^1 allnc x^2,x^3(R^' x^1 x^2 -> TrCl x^2 x^3 -> TrCl x^1 x^3)"
;            "StepTrCl"))

; add-ids
; illegal clause
; all x^1 allnc x^2,x^3.R^'x^1 x^2 -> R'132 x^2 x^3 -> R'132 x^1 x^3

; Was
; (add-ids (list (list "TrCl" (make-arity (py "alpha") (py "alpha")) "algTrCl"))
; 	 '("allnc x^1,x^2.R^ x^1 x^2 -> TrCl x^1 x^2" "InitTrCl")
; 	 '("allnc x^1,x^2,x^3.R^ x^1 x^2 -> TrCl x^2 x^3 -> TrCl x^1 x^3"
;            "StepTrCl"))

; (map car (alg-name-to-typed-constr-names "algTrCl"))
; ("cInitTrCl" "cStepTrCl")

; Here the clauses contain the type variable alpha and the parameter
; predicate variable R^, which can be substituted by themselves.

; (define idpc
;   (idpredconst-name-and-types-and-cterms-to-idpredconst
;    "TrCl"
;    (list (py "alpha"))
;    (list (make-cterm (pv "x1") (pv "x2") (pf "R^ x1 x2")))))

; (define formula (make-predicate-formula idpc (pt "x3") (pt "x4")))
; (pp formula)
; ; (TrCl (cterm (x1,x2) R^x1 x2))x3 x4

; ; ... or else can be substituted e.g. by nat and {n1,n2|n1<n2}

; (define idpc-inst
;   (idpredconst-name-and-types-and-cterms-to-idpredconst
;    "TrCl"
;    (list (py "nat"))
;    (list (make-cterm (pv "n1") (pv "n2") (pf "n1<n2")))))

; (define formula (make-predicate-formula idpc-inst (pt "n3") (pt "n4")))
; (pp formula)
; ; (TrCl (cterm (n1,n2) n1<n2))n3 n4

; (define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
; (pp (aconst-to-formula aconst0))
; ; allnc x^1,x^2.R^ x^1 x^2 -> (TrCl (cterm (x70,x69) R^x70 x69))x^1 x^2

; (define aconst1 (number-and-idpredconst-to-intro-aconst 1 idpc))
; (pp (aconst-to-formula aconst1))
; ; allnc x^1,x^2,x^3.
; ;  R^x^1 x^2 -> 
; ;  (TrCl (cterm (x527,x526) R^x527 x526))x^2 x^3 -> 
; ;  (TrCl (cterm (x527,x526) R^x527 x526))x^1 x^3

; (define eterm1 (proof-to-extracted-term (make-proof-in-aconst-form aconst1)))
; (pp (term-to-type eterm1)) 
; ; algTrCl=>algTrCl

; ; (add-pvar-name "Q" (make-arity (py "nat")))

; (define aconst
;   (imp-formulas-to-elim-aconst
;    (pf "(TrCl (cterm (x70,x69) R x70 x69))x^1 x^2 -> R1 x^1 x^2")))
; (pp (aconst-to-formula aconst))
; ; allnc x^1,x^2.
; ;  (allnc x^1,x^2.R x^1 x^2 -> R 1 x^1 x^2) -> 
; ;  (allnc x^1,x^2,x^3.
; ;    R x^1 x^2 -> 
; ;    (TrCl (cterm (x537,x536) R x537 x536))x^2 x^3 -> 
; ;    R 1 x^2 x^3 -> R 1 x^1 x^3) -> 
; ;  (TrCl (cterm (x537,x536) R x537 x536))x^1 x^2 -> R 1 x^1 x^2

; (define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
; (pp (term-to-type eterm))
; ; "alpha12=>(algTrCl=>alpha12=>alpha12)=>algTrCl=>alpha12"

(remove-pvar-name "Q")
(add-pvar-name "Q" (make-arity (py "alpha")))

; We need two inductively defined existential quantifiers, one (ExID
; with D for double) for a kernel with computational content, and one
; (ExI) for a kernel without.  The reason is to avoid garbage in
; extracted programs.

; (remove-alg-name "algExID")
; (remove-pvar-name "ExID")
; (remove-alg-name "algExI")
; (remove-pvar-name "ExI")

(add-ids (list (list "ExID" (make-arity) "algExID"))
	 '("all x^(Q x^ -> ExID)" "GenExID"))
;new here: all x^, not allnc

(define idpc (predicate-form-to-predicate (pf "exid n n=m")))
(idpredconst-to-string idpc)
; "exid n n=m"

(define aconst (imp-formulas-to-elim-aconst (pf "exid n n=m -> k=0")))
(pp (aconst-to-formula aconst))
; allnc m,k.(all n^39.n^39=m -> k=0) -> exid n40 n40=m -> k=0

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; allnc m all n^42.n^42=m -> exid n43 n43=m

(define eterm0 (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm0))
; nat=>unit=>algExID nat unit


; 2007-07-28
; This should be formulated with uniform implication Q x^ ->^U instead
; of Q^'x^ ->.

(add-ids (list (list "ExI" (make-arity) "algExI"))
	 '("all x^(Q^'x^ -> ExI)" "GenExI")) 

(define idpc (predicate-form-to-predicate (pf "exi n n=m")))
(idpredconst-to-string idpc)
; "exi n n=m"

(define aconst (imp-formulas-to-elim-aconst (pf "exi n n=m -> k=0")))
(pp (aconst-to-formula aconst))
; allnc m,k.(all n^30.n^30=m -> k=0) -> exi n31 n31=m -> k=0

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; allnc m all n^33.n^33=m -> exi n34 n34=m

(define eterm0 (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm0))
; nat=>algExI nat


(add-var-name "y" (py "alpha"))

(add-ids (list (list "Acc" (make-arity (py "alpha")) "algAcc"))
	 '("allnc x.(all y.R^' y x -> Acc y) -> Acc x" "GenAccSup"))
(map car (alg-name-to-typed-constr-names "algAcc"))
; ("DummyalgAcc" "cGenAccSup")

; Here the clauses contain the type variable alpha and the parameter
; predicate variable R^, which can be substituted by themselves.

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "Acc"
   (list (py "alpha"))
   (list (make-cterm (pv "x1") (pv "x2") (pf "R^'x1 x2")))))

(define formula (make-predicate-formula idpc (pt "x3")))
(pp formula)
; (Acc (cterm (x1,x2) R^'x1 x2))x3

; ... or else can be substituted e.g. by nat and {n1,n2|n1<n2}

(define idpc-inst
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "Acc"
   (list (py "nat"))
   (list (make-cterm (pv "n1") (pv "n2") (pf "n1<n2")))))

(define formula (make-predicate-formula idpc-inst (pt "n3")))
(pp formula)
; (Acc (cterm (n1,n2) n1<n2))n3

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; allnc x.
;  (all y.R^'y x -> (Acc (cterm (x529,x528) R^'x529 x528))y) -> 
;  (Acc (cterm (x529,x528) R^'x529 x528))x

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm)) 
; (alpha=>algAcc alpha)=>algAcc alpha

(define aconst
  (imp-formulas-to-elim-aconst
   (pf "(Acc alpha (cterm (x70,x69) R^'x70 x69))x^ -> Q x^")))
(pp (aconst-to-formula aconst))
; allnc x^.
;  (allnc x.
;    (all y.R^'y x -> (Acc (cterm (x535,x534) R^'x535 x534))y) -> 
;    (all y.R^'y x -> Q y) -> Q x) -> 
;  (Acc (cterm (x535,x534) R^'x535 x534))x^ -> Q x^

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; ((alpha=>algAcc alpha)=>(alpha=>alpha11)=>alpha11)=>algAcc alpha=>alpha11


(add-ids (list (list "FalsityID" (make-arity) "algFalsityID")))

(pp (pf "FalsityID"))
(add-pvar-name "P" (make-arity))

(define aconst
  (imp-formulas-to-elim-aconst
   (pf "FalsityID -> P")))
(pp (aconst-to-formula aconst))
; FalsityID -> P

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; algFalsityID=>alpha18

(pp eterm)
; (Rec algFalsityID=>alpha18)


(add-ids (list (list "EqID" (make-arity (py "alpha") (py "alpha")) "algEqID"))
	 '("allnc x^ EqID x^ x^" "GenEqID"))

(map car (alg-name-to-typed-constr-names "algEqID"))
; ("GenEqID")

; Here the clauses contain the type variable alpha, which can be
; substituted by itselve.

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "EqID" (list (py "alpha")) '()))

(define formula (make-predicate-formula idpc (pt "x^1")  (pt "x^2")))
(pp formula)
; "x^1 eqid x^2"

; ... or else can be substituted e.g. by nat

(define idpc-inst
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "EqID" (list (py "nat")) '()))

(define formula (make-predicate-formula idpc-inst (pt "n1") (pt "n2")))
(pp formula)
; "n1 eqid n2"

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; allnc x^ x^eqid x^

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm))
; "algEqID"

(define aconst
  (imp-formulas-to-elim-aconst
   (pf "x^1 eqid x^2 -> R x^1 x^2")))
(pp (aconst-to-formula aconst))
; allnc x^1,x^2.allnc x^ R x^x^ -> x^1 eqid x^2 -> R x^1 x^2

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; alpha20=>algEqID=>alpha20


(add-ids (list (list "OrID" (make-arity) "algOrID"))
	 '("P1 -> OrID" "InlOrID")
	 '("P2 -> OrID" "InrOrID"))

(map car (alg-name-to-typed-constr-names "algOrID"))
; ("DummyalgOrID" "InlOrID" "InrOrID")

; Here the clauses contain the parameter predicate variables P1 and
; P2, which can be substituted by themselves.

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "OrID" '()
   (list (make-cterm (pf "P1")) (make-cterm (pf "P2")))))

(define formula (make-predicate-formula idpc))
(pp formula)
; P1 or P2

; ... or else can be substituted e.g. {|T} and {|F}

(define idpc-inst
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "OrID" '() (list  (make-cterm (pf "T")) (make-cterm (pf "F")))))

(define formula (make-predicate-formula idpc-inst))
(pp formula)
; T or F

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc))
(pp (aconst-to-formula aconst0))
; P1 -> P1 or P2

(define aconst1 (number-and-idpredconst-to-intro-aconst 1 idpc))
(pp (aconst-to-formula aconst1))
; P2 -> P1 or P2

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst0)))
(pp (term-to-type eterm))
; alpha24=>algOrID alpha24 alpha22

(define aconst
  (imp-formulas-to-elim-aconst
   (pf "P1 or P2 -> P")))
(pp (aconst-to-formula aconst))
; (P1 -> P) -> (P2 -> P) -> P1 or P2 -> P

(define eterm (proof-to-extracted-term (make-proof-in-aconst-form aconst)))
(pp (term-to-type eterm))
; (alpha24=>alpha19)=>(alpha22=>alpha19)=>algOrID alpha24 alpha22=>alpha19

(define idpc
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "OrID" '() (list (make-cterm (pf "P1")) (make-cterm (pf "P2")))))

(set-goal (pf "allnc n.Even n -> ex m n=m+m"))
(assume "n")
(elim)
(ex-intro (pt "0"))
(use "Truth-Axiom")
(assume "n1" "Even n1" "IH")
(by-assume-with "IH" "m" "n1=m+m")
(ex-intro (pt "m+1"))
(ng)
(use "n1=m+m")
; Proof finished.

(cdp)
(proof-to-expr (current-proof))

; (lambda (n)
;   (((|Elim| n) ((|Ex-Intro| 0) |Truth-Axiom|))
;    (lambda (n1)
;      (lambda (|Even n144|)
;        (lambda (|IH45|)
;          (((|Ex-Elim| n1) |IH45|)
;           (lambda (m)
;             (lambda (n1=m+m47)
;               (((|Ex-Intro| n1) (+ m 1)) n1=m+m47)))))))))

(proof-to-expr (np (current-proof)))

(lambda (n)
  (((|Elim| n) ((|Ex-Intro| 0) |Truth-Axiom|))
   (lambda (n214)
     (lambda (u51)
       (lambda (u52)
         (((|Ex-Elim| n214) u52)
          (lambda (n216) ((|Ex-Intro| n214) (+ n216 1)))))))))

(det)
(dnet) ;"(Rec algEven=>nat)0([algEven1]Succ)"

; Added 2005-02-25 Test for additional type parameters

(av "f" (py "alpha=>alpha"))
(add-ids (list (list "I" (make-arity (py "nat")) "algI"))
	 '("allnc x,f.Equal x(f x) -> I 0" "InitI"))

(pp (pf "(I alpha)0"))
(pp (pf "(I nat)0"))

(define idpc-inst
  (idpredconst-name-and-types-and-cterms-to-idpredconst
   "I"
   (list (py "nat"))
   '()))

(define formula (make-predicate-formula idpc-inst (pt "n3")))
(pp formula)
; "(I nat)n3"

(define aconst0 (number-and-idpredconst-to-intro-aconst 0 idpc-inst))
(pp (aconst-to-formula aconst0))
; allnc n160,(nat=>nat)_161.Equal n160((nat=>nat)_161 n160) -> (I nat)0
