; $Id: fiets.scm,v 1.3 2006/05/15 06:44:53 schwicht Exp $
; FI-Extracted terms
; ===================

(define SNL (string #\newline))

(define (nldisplay .  strings)  
  (display  #\newline) (display strings) (display #\newline))

(define (normalize-term-to-string term)
  (term-to-string (nbe-normalize-term term)))

; A generic procedure for catenating tuples of the same kind

(define (tuple-append tuple1 tuple2) 
  (if (or (null? tuple1) (null? tuple2))
      (myerror "tuple-append: both arguments must be non-empty lists" 
	       tuple1 tuple2)
      (if (not (eq? (car tuple1) (car tuple2)))
	  (myerror
	   "tuple-append: both arguments should be tuples of the same kind"
		   (car tuple1) (car tuple2))
	  (append tuple1 (cdr tuple2)))))

(define (nulltuple? tuple) (null? (cdr tuple)))



; DATATYPE tytuple == (list 'tytuple type1 ... typeN)

(define (tytuple? list) (eq? (car list) 'tytuple))

(define NULLtytuple (list 'tytuple))

(define (type-to-tytuple type) (list 'tytuple type))

(define (tytuple-to-string tytuple)
  (if (not (tytuple? tytuple))
      (myerror "tytuple-to-string: tytuple argument expected")
      (tylist-to-string (cdr tytuple))))

(define (tylist-to-string tylist)
  (string-append "< " (tylist-to-string-aux tylist)))

(define (tylist-to-string-aux tylist)
  (if (null? tylist) " >" 
      (let((car_tylist (car tylist)) 
           (cdr_tylist (cdr tylist)))
        (if (null? cdr_tylist) 
            (string-append (type-to-string car_tylist) " >")
            (string-append  (type-to-string  car_tylist) " TYPE "
                            (tylist-to-string-aux cdr_tylist))))))

(define (make-tytuple-arrow tytuple1 tytuple2)
  (if (or (null? tytuple1) (null? tytuple2))
      (myerror "make-tytuple-arrow: both arguments must be non-empty lists")
      (if (not (or (eq? (car tytuple1) 'tytuple)
		   (eq? (car tytuple2) 'tytuple)))
          (myerror "make-tytuple-arrow: both arguments should be tytuples")
          (cons 'tytuple (make-tylist-arrow (cdr tytuple1) (cdr tytuple2))))))

(define (make-tylist-arrow tylist1 tylist2)
  (if (null? tylist2) (list) 
      (cons (make-tylist-arrow-aux tylist1 (car tylist2))
            (make-tylist-arrow tylist1 (cdr tylist2)))))

(define (make-tylist-arrow-aux tylist type)
  (if (null? tylist) type
      (make-arrow (car tylist) (make-tylist-arrow-aux (cdr tylist) type))))




; DATATYPE vatuple == (list 'vatuple var1 ... varN)

(define (vatuple? list) (eq? (car list) 'vatuple))

(define NULLvatuple (list 'vatuple))

(define (var-to-vatuple var) (list 'vatuple var))

(define (var-to-zero var) (type-to-zero (var-to-type var)))

(define (tytuple-to-vatuple tytuple)
  (if (not (tytuple? tytuple))
      (myerror "tytuple-to-vatuple: tytuple argument expected")
      (cons 'vatuple (tylist-to-valist (cdr tytuple)))))

(define (tylist-to-valist tylist)
  (if (null? tylist) (list)
      (cons (type-to-new-var (car tylist)) 
            (tylist-to-valist (cdr tylist)))))

(define (vatuple-to-tytuple vatuple)
  (if (not (vatuple? vatuple))
      (myerror "vatuple-to-tytuple: vatuple argument expected")
      (cons 'tytuple (valist-to-tylist (cdr vatuple)))))

(define (valist-to-tylist valist)
  (if (null? valist) (list)
      (cons (var-to-type (car valist)) 
            (valist-to-tylist (cdr valist)))))

(define (vatuple-to-string vatuple)
  (if (not (vatuple? vatuple))
      (myerror "vatuple-to-string: vatuple argument expected")
      (valist-to-string (cdr vatuple))))

(define (valist-to-string valist)
  (string-append "< " (valist-to-string-aux valist)))

(define (valist-to-string-aux valist)
  (if (null? valist) " >" 
      (let ((car_valist (car valist)) (cdr_valist (cdr valist)))
        (if (null? cdr_valist) (string-append (var-to-string car_valist) " >")
            (string-append  (var-to-string car_valist) " VAR "
                            (valist-to-string-aux cdr_valist))))))




		 ; DATATYPE tmtuple == (list 'tmtuple term1 ... termN)

(define (tmtuple? list) (and (not (null? list)) 
                             (eq? (car list) 'tmtuple)))

(define (tmlist? list) (or (null? list) (and (term-form? (car list)) 
                                             (tmlist? (cdr list)))))

(define NULLtmtuple (list 'tmtuple))

(define  (tmtuple-to-tytuple tmtuple)
  (if (not (tmtuple? tmtuple))
      (myerror "tmtuple-to-tytuple: tmtuple argument expected")
      (cons 'tytuple (tmlist-to-tylist (cdr tmtuple)))))

(define (tmlist-to-tylist tmlist)
  (if (null? tmlist) (list)
      (cons (term-to-type (car tmlist)) 
            (tmlist-to-tylist (cdr tmlist)))))

(define  (vatuple-to-tmtuple vatuple)
  (if (not (vatuple? vatuple))
      (myerror "vatuple-to-tmtuple: vatuple argument expected")
      (cons 'tmtuple (valist-to-tmlist (cdr vatuple)))))

(define (valist-to-tmlist valist)
  (if (null? valist) (list)
      (cons (make-term-in-var-form (car valist)) 
            (valist-to-tmlist  (cdr valist)))))

(define (vatuple-to-zero-tmtuple vatuple)
  (if (not (vatuple? vatuple)) 
      (myerror "vatuple-to-zero-tmtuple: vatuple argument expected")
      (cons 'tmtuple (valist-to-zero-tmlist (cdr vatuple)))))

(define (valist-to-zero-tmlist valist)
  (if (null? valist) (list)
      (cons (var-to-zero (car valist)) 
            (valist-to-zero-tmlist  (cdr valist)))))

(define (tytuple-to-zero-tmtuple tytuple)
  (if (not (tytuple? tytuple)) 
      (myerror "tytuple-to-zero-tmtuple: tytuple argument expected")
      (cons 'tmtuple (tylist-to-zero-tmlist (cdr tytuple)))))

(define (tylist-to-zero-tmlist tylist)
  (if (null? tylist) (list)
      (cons (type-to-zero (car tylist)) 
            (tylist-to-zero-tmlist (cdr tylist)))))

(define (type-to-zero type) 
  (if (arrow-form? type) (make-term-in-abst-form 
                          (type-to-new-var (arrow-form-to-arg-type type))
                          (type-to-zero (arrow-form-to-val-type type)))
      (if (star-form? type) (make-term-in-pair-form 
                             (type-to-new-var (star-form-to-left-type type))
                             (type-to-zero (star-form-to-right-type type)))
          (type-to-canonical-inhabitant type))))

(define (tmtuple-substitute tmtuple subst)
  (if (not (tmtuple? tmtuple))
      (myerror "tmtuple-substitute: tmtuple argument expected")
      (cons 'tmtuple (tmlist-substitute (cdr  tmtuple) subst))))

(define (tmlist-substitute tmlist subst)
  (if (null? subst) tmlist
      (if (null? tmlist) tmlist
	  (cons (term-substitute (car tmlist) subst)  
		(tmlist-substitute (cdr tmlist) subst)))))

(define (tmtuple-to-free tmtuple)
  (if (not (tmtuple? tmtuple))
      (myerror "tmtuple-to-free: tmtuple argument expected")
      (tmlist-to-free (cdr tmtuple))))

(define (tmlist-to-free tmlist)
  (if (null? tmlist) tmlist
      (union (term-to-free (car tmlist))
	     (tmlist-to-free (cdr tmlist)))))

(define (term-to-tmtuple-aux term) (list 'tmtuple term))

(define (term-to-tmtuple term)
  (if (star-form? (term-to-type term))
      (tuple-append (term-to-tmtuple (make-term-in-lcomp-form term))
                    (term-to-tmtuple (make-term-in-rcomp-form term)))
      (term-to-tmtuple-aux term)))

(define (tmtuple-to-term tmtuple)
  (if (not (tmtuple? tmtuple))
      (myerror "tmtuple-to-term: tmtuple argument expected")
      (tmlist-to-term (cdr tmtuple))))

(define (tmlist-to-term tmlist)
  (if (null? tmlist) 
      (myerror "tmlist-to-term: non-empty list expected")
      (if (null? (cdr tmlist)) 
          (car  tmlist)
          (make-term-in-pair-form (car tmlist) 
                                  (tmlist-to-term (cdr tmlist))))))

(define (term-list? list) 
  (if (null? list) #t (and (term-form? (car list))   
                           (term-list? (cdr list)))))

(define (make-tmtuple-in-abst-form vatuple tmtuple)
  (if (not (and (vatuple? vatuple) (tmtuple? tmtuple)))
      (myerror "make-tmtuple-in-abst-form: first argument must be 
                          a vatuple and second argument must be a tmtuple")
      (cons 'tmtuple (make-tmlist-in-abst-form (cdr vatuple) (cdr tmtuple)))))

(define (make-tmlist-in-abst-form valist tmlist)
  (if (null? tmlist) (list)
      (cons (make-term-in-abst-form-tup valist (car tmlist))
            (make-tmlist-in-abst-form valist (cdr tmlist)))))

(define (make-term-in-abst-form-tup valist term)
  (if (null? valist) term 
      (make-term-in-abst-form (car valist) 
                              (make-term-in-abst-form-tup (cdr valist) term))))

(define (make-tmtuple-in-app-form tmtupleOP tmtupleARG)
  (if (not (and (tmtuple? tmtupleOP) (tmtuple? tmtupleARG)))
      (myerror "make-tmtuple-in-app-form: both arguments must be tmtuples")
      (cons 'tmtuple (make-tmlist-in-app-form
		      (cdr tmtupleOP) (cdr tmtupleARG)))))

(define (make-tmlist-in-app-form tmlistOP tmlistARG)
  (if (null? tmlistOP) (list)
      (cons (make-term-in-app-form-tup (car tmlistOP) tmlistARG)
            (make-tmlist-in-app-form (cdr tmlistOP) tmlistARG))))

(define (make-term-in-app-form-tup term tmlist)
  (if (null? tmlist) term 
      (make-term-in-app-form-tup (make-term-in-app-form term (car tmlist)) 
                                 (cdr tmlist))))

(define (nbe-normalize-tmtuple tmtuple)
  (if (not (tmtuple? tmtuple))
      (myerror "nbe-normalize-tmtuple: tmtuple argument expected")
      (cons 'tmtuple (nbe-normalize-tmlist (cdr tmtuple)))))

(define (nbe-normalize-tmlist tmlist)
  (if (null? tmlist) tmlist (cons (nbe-normalize-term (car tmlist))
                                  (nbe-normalize-tmlist (cdr tmlist)))))

(define (normalize-tmtuple-to-string tmtuple)
  (tmtuple-to-string (nbe-normalize-tmtuple tmtuple)))

(define (tmtuple-to-string tmtuple)
  (if (not (tmtuple? tmtuple))
      (myerror "tmtuple-to-string: tmtuple argument expected")
      (tmlist-to-string (cdr tmtuple))))

(define (tmlist-to-string tmlist)
  (string-append "< " (tmlist-to-string-aux tmlist)))

(define (tmlist-to-string-aux tmlist)
  (if (null? tmlist) " >" 
      (let((car_tmlist (car tmlist)) 
           (cdr_tmlist (cdr tmlist)))
        (if (null? cdr_tmlist)
	    (string-append (term-to-string  car_tmlist) " >")
            (string-append (term-to-string  car_tmlist) " TERM "
                           (tmlist-to-string-aux cdr_tmlist))))))



; DATATYPE tmtuplist == a list of tmtuples 

(define (tmtuplist? list) 
  (if (null? list) #t 
      (and (tmtuple? (car list)) 
           (tmtuplist? (cdr list)))))

(define (tmtuplist-to-string tmtuplist)
  (string-append "BEGIN<tmtuplist>" SNL "FIRST-TMTUPLE = "
                 (tmtuplist-to-string-aux tmtuplist)))

(define (tmtuplist-to-string-aux tmtuplist)
  (if (null? tmtuplist) (string-append SNL "END<tmtuplist>")
      (let((car_tmtuplist (car tmtuplist)) 
           (cdr_tmtuplist (cdr tmtuplist)))
        (if (null? cdr_tmtuplist) 
            (string-append (tmtuple-to-string  car_tmtuplist) 
                           SNL "END<tmtuplist>")
            (string-append (tmtuple-to-string  car_tmtuplist) 
                           SNL "NEXT-TMTUPLE = "
                           (tmtuplist-to-string-aux cdr_tmtuplist))))))

(define (normalize-tmtuplist-to-string tmtuplist)
  (string-append "BEGIN<tmtuplist>" SNL "FIRST-TMTUPLE = "
                 (normalize-tmtuplist-to-string-aux tmtuplist)))

(define (normalize-tmtuplist-to-string-aux tmtuplist)
  (if
   (null? tmtuplist) (string-append SNL "END<tmtuplist>")
   (let ((car_tmtuplist (car tmtuplist)) 
	 (cdr_tmtuplist (cdr tmtuplist)))
     (if (null? cdr_tmtuplist) 
	 (string-append (normalize-tmtuple-to-string  car_tmtuplist) 
			SNL "END<tmtuplist>")
	 (string-append (normalize-tmtuple-to-string  car_tmtuplist) 
			SNL "NEXT-TMTUPLE = "
			(normalize-tmtuplist-to-string-aux cdr_tmtuplist))))))

(define (make-tmtuplist-in-app-form tmtuplistOP tmtuplistARG)
  (if (null? tmtuplistOP) (list)
      (cons (make-tmtuple-in-app-form (car tmtuplistOP) tmtuplistARG)
            (make-tmtuplist-in-app-form (cdr tmtuplistOP) tmtuplistARG))))


; DATATYPE tmtuplealist == a list of associations of tmtuples to assumption
;                          variables

(define (tmtuplealist? list) 
  (if (null? list) #t 
      (and (avar-form? (caar list)) (tmtuple? (cdar list)) 
           (tmtuplealist? (cdr list)))))

(define NULLtmtuplealist (list))

(define (make-tmtuplealist-in-abst-form vatuple tmtuplealist)
  (if (not (vatuple? vatuple))
      (myerror "make-tmtuplealist-in-abst-form: 1st argument must be vatuple")
      (if (not (tmtuplealist? tmtuplealist))
	  (myerror
	   "make-tmtuplealist-in-abst-form: 2nd argument must be tuple-list")
	  (if (null? tmtuplealist) tmtuplealist
	      (cons
	       (cons (caar tmtuplealist) 
		     (make-tmtuple-in-abst-form vatuple (cdar tmtuplealist)))
	       (make-tmtuplealist-in-abst-form vatuple (cdr tmtuplealist)))))))

(define (make-tmtuplealist-in-app-form tmtuplealist tmtuple)
  (if (not (tmtuple? tmtuple))
      (myerror "make-tmtuplealist-in-app-form: 2nd argument must be tmtuple")
      (if (not (tmtuplealist? tmtuplealist))
	  (myerror
	   "make-tmtuplealist-in-app-form: 1st argument must be tuple-list")
	  (if (null? tmtuplealist) tmtuplealist
	      (cons
	       (cons (caar tmtuplealist) 
		     (make-tmtuple-in-app-form (cdar tmtuplealist) tmtuple))
	       (make-tmtuplealist-in-app-form (cdr tmtuplealist) tmtuple))))))


(define (alist-to-formula-free tmtuplealist)
  (if (null? tmtuplealist) (list)
      (union (formula-to-free (avar-to-formula (caar tmtuplealist)))
	     (alist-to-formula-free (cdr tmtuplealist)))))

(define (alist-to-tmtuple-free tmtuplealist)
  (if (null? tmtuplealist) (list)
      (union (tmtuple-to-free (cdar tmtuplealist))
	     (alist-to-tmtuple-free (cdr tmtuplealist)))))

(define (tmtuplealist-substitute tmtuplealist subst)
  (if (not (tmtuplealist? tmtuplealist))
      (myerror "tmtuplealist-substitute: 1st argument must be tmtuplealist")
      (if (null? subst) tmtuplealist
	  (if (null? tmtuplealist) tmtuplealist
	      (cons (cons (caar tmtuplealist) 
			  (tmtuple-substitute (cdar tmtuplealist) subst))
		    (tmtuplealist-substitute (cdr tmtuplealist) subst))))))


(define (tmtuplealist-to-string tmtuplealist) 
  (if (not (tmtuplealist? tmtuplealist))
      (myerror "tmtuplealist-to-string: argument must be tmtuplealist")
      (string-append "BEGIN<tmtuplealist>" SNL "FIRST-ASSOCIATION = " SNL
                     (tmtuplealist-to-string-aux tmtuplealist))))

(define (tmtuplealist-to-string-aux tmtuplealist)
  (if (null? tmtuplealist)  (string-append SNL "END<tmtuplealist>")
      (string-append
       "ASSOC-FORMULA = " (formula-to-string 
			   (avar-to-formula (caar tmtuplealist)))
       SNL "ASSOC-TMTUPLE= " (tmtuple-to-string (cdar tmtuplealist))
       SNL "NEXT-ASSOCIATION = " SNL
       (tmtuplealist-to-string-aux (cdr tmtuplealist)))))

(define (types-tmtuplealist-to-string tmtuplealist) 
  (if (not (tmtuplealist? tmtuplealist))
      (myerror "types-tmtuplealist-to-string: argument must be tmtuplealist")
      (string-append "BEGIN<tmtuplealist>" SNL "FIRST-ASSOCIATION = " SNL
                     (types-tmtuplealist-to-string-aux tmtuplealist))))

(define (types-tmtuplealist-to-string-aux tmtuplealist)
  (if (null? tmtuplealist)  (string-append SNL "END<tmtuplealist>")
      (string-append
       "ASSOC-FORMULA = " (formula-to-string 
			   (avar-to-formula (caar tmtuplealist)))
       SNL "ASSOC-TMTUPLE= " (tytuple-to-string 
			      (tmtuple-to-tytuple (cdar tmtuplealist)))
       SNL "NEXT-ASSOCIATION = " SNL
       (types-tmtuplealist-to-string-aux (cdr tmtuplealist)))))

(define (normalize-tmtuplealist-to-string tmtuplealist) 
  (if (not (tmtuplealist? tmtuplealist))
      (myerror
       "normalize-tmtuplealist-to-string: argument must be tmtuplealist")
      (string-append "BEGIN<tmtuplealist>" SNL "FIRST-ASSOCIATION = "
                     (normalize-tmtuplealist-to-string-aux tmtuplealist))))

(define (normalize-tmtuplealist-to-string-aux tmtuplealist)
  (if (null? tmtuplealist) "END<tmtuplealist>"
      (string-append
       "ASSOC-FORMULA = " (formula-to-string 
			   (avar-to-formula (caar tmtuplealist)))
       SNL "ASSOC-TMTUPLE= " (normalize-tmtuple-to-string 
			      (cdar tmtuplealist)) 
       SNL "NEXT-ASSOCIATION = "
       (normalize-tmtuplealist-to-string-aux (cdr tmtuplealist)))))


; DATATYPE typair == pair of tytuples

(define (make-typair tytuple1 tytuple2) (list 'typair tytuple1 tytuple2))

(define (typair-left typair) (cadr typair))

(define (typair-right typair) (caddr typair))

(define NULLtypair (make-typair NULLtytuple NULLtytuple))

(define (typair-to-string typair) 
  (string-append "BEGIN<typair>" 
                 SNL "TYPAIR-LEFT = "
                 (tytuple-to-string (typair-left typair)) 
                 SNL "TYPAIR-RIGHT = " 
                 (tytuple-to-string (typair-right typair)) 
                 SNL "END<typair>"))


				 ; DATATYPE vapair == pair of vatuples

(define (make-vapair vatuple1 vatuple2) (list 'vapair vatuple1 vatuple2))

(define (vapair-left vapair) (cadr vapair))

(define (vapair-right vapair)(caddr vapair))

(define (vapair? vapair)
  (and (eq? 'vapair (car vapair)) 
       (vatuple? (cadr vapair)) (vatuple? (caddr vapair))))

(define NULLvapair (make-vapair NULLvatuple NULLvatuple))

(define (vapair-to-string vapair) 
  (string-append "BEGIN<vapair>" 
                 SNL "VAPAIR-LEFT = "
                 (vatuple-to-string (vapair-left vapair)) 
                 SNL "VAPAIR-RIGHT = " 
                 (vatuple-to-string (vapair-right vapair)) 
                 SNL "END<vapair>"))




; DATATYPE tmpair == pair with left component tmtuple and right component
				   ;                    a tmtuple list

(define (make-tmpair tmtuple tmtuplealist) 
  (if (not (tmtuple? tmtuple))
      (myerror "make-tmpair: 1st argument must be tmtuple")
      (if (not (tmtuplealist? tmtuplealist))
          (myerror "make-tmpair: 2nd argument must be tmtuplealist")
          (list 'tmpair tmtuple tmtuplealist))))

(define (tmpair-to-tuple tmpair) (cadr tmpair))

(define (tmpair-to-alist tmpair) (caddr tmpair))

(define (tmpair-to-string tmpair) 
  (string-append "BEGIN<tmpair>" 
                 SNL "TMTUPLE = "
                 (tmtuple-to-string (tmpair-to-tuple tmpair)) 
                 SNL "ALIST = " 
                 (tmtuplealist-to-string (tmpair-to-alist tmpair)) 
                 SNL "END<tmpair>"))

(define (types-tmpair-to-string tmpair) 
  (string-append "BEGIN<tmpair>" 
                 SNL "TMTUPLE = "
                 (tytuple-to-string
		  (tmtuple-to-tytuple (tmpair-to-tuple tmpair)))
                 SNL "ALIST = " 
                 (types-tmtuplealist-to-string (tmpair-to-alist tmpair)) 
                 SNL "END<tmpair>"))

(define (normalize-tmpair-to-string tmpair) 
  (string-append "BEGIN<tmpair>" 
                 SNL "TMTUPLE = "
                 (normalize-tmtuple-to-string (tmpair-to-tuple tmpair)) 
                 SNL "ALIST = " 
                 (normalize-tmtuplealist-to-string (tmpair-to-alist tmpair)) 
                 SNL "END<tmpair>"))



; DATATYPE vatmpair == 
; pair of first component vapair and second component tmpair

(define (make-vatmpair vapair tmpair) (list 'vatmpair vapair tmpair))

(define (vatmpair-to-vapair vatmpair) (cadr vatmpair))

(define (vatmpair-to-tmpair vatmpair) (caddr vatmpair))

(define NULLvatmpair
  (make-vatmpair (make-vapair NULLvatuple  NULLvatuple) 
		 (make-tmpair NULLtmtuple NULLtmtuplealist)))

(define (notelem? var list)
  (if (null? list) #t
      (if (equal? var (car list)) #f
	  (notelem? var (cdr list)))))

(define (notsubset? listA listB)
  (if (null? listA) #f
      (if (notelem? (car listA) listB) #t
	  (notsubset? (cdr listA) listB))))

(define (check-free vatmpair formula)
  (let*((tmpair (vatmpair-to-tmpair vatmpair))
	(tmtuple (tmpair-to-tuple tmpair))
	(alist (tmpair-to-alist tmpair))
	(tmtuple-free (union (tmtuple-to-free tmtuple) 
			     (alist-to-tmtuple-free alist)))
	(formula-free (union (formula-to-free formula)
			     (alist-to-formula-free alist))))
    (if (notsubset? tmtuple-free formula-free) 
	(set-minus tmtuple-free formula-free) #f)))

(define (vatmpair-to-string vatmpair) 
  (string-append SNL "BEGIN<vatmpair>" SNL
                 (vapair-to-string (vatmpair-to-vapair vatmpair)) 
                 SNL  (tmpair-to-string (vatmpair-to-tmpair vatmpair))  
                 "END<vatmpair>"))

(define (normalize-vatmpair-to-string vatmpair) 
  (string-append  SNL "BEGIN<vatmpair>" SNL
                  (vapair-to-string (vatmpair-to-vapair vatmpair)) 
                  SNL  (normalize-tmpair-to-string
			(vatmpair-to-tmpair vatmpair))  
                  "END<vatmpair>" ))

(define (types-vatmpair-to-string vatmpair) 
  (string-append SNL "BEGIN<vatmpair>" SNL
                 (vapair-to-string (vatmpair-to-vapair vatmpair)) 
                 SNL  (types-tmpair-to-string (vatmpair-to-tmpair vatmpair))  
                 "END<vatmpair>"))



; FI-ASSOC-LIST als globale Liste, damit Zuordung pvar tvar festbleibt
; und einer Pvar auch zu einem spaeterem Zeitpunkt dieselbe tvar, die
; ja dann auch in einem Programm abgespeichert ist, zugeordnet wird.

(define  FI-ASSOC-LIST '())

(define (make-pvar-to-ptvar)
; returns a procedure associating type variables to predicate variables, 
; which remembers the assignment done so far.
; (let ((FI-assoc-list '())) ;now a global FI-assoc-list, M.S.
  (lambda (pvar)
    (let ((info (assoc pvar fi-assoc-list)))
      (if info (cadr info)
	  (let ((newptvar (make-typair (new-tvar) (new-tvar))))
	    (set! assoc-list (cons (list pvar newptvar) assoc-list))
	    newptvar)))))

; In FI-formula-to-typair we assign new typair of type variables to
; the predicate variables, be passing along a procedure pvar-to-ptvar
; which memorizes the assigments already done.  This is done by
; make-pvar-to-ptvar

(define (FI-formula-to-typair formula)
  (let ((pvar-to-tvar (make-pvar-to-tvar)))
    (FI-formula-to-typair-aux formula pvar-to-tvar)))

(define (FI-formula-to-typair-aux formula pvar-to-tvar)
  (case (tag formula)
    ((atom) NULLtypair)
    ((predicate)
     (let ((pred (predicate-form-to-predicate formula)))
       (if
	(predconst-form? pred) NULLtypair
	(if (pvar-form? pred) 
	    (if (= 0 (pvar-to-h-deg pred)) (pvar-to-ptvar pred)  NULLtypair)
	    (if (idpredconst-form? pred)
		(myerror "FI-formula-to-typair: inductive predicates 
                                                    not supported yet" pred)
		(myerror "FI-formula-to-typair: predicate expected" pred))))))
    ((imp)
     (make-arrow-fiet (FI-formula-to-typair-aux 
		       (imp-form-to-premise formula)  pvar-to-tvar)
		      (FI-formula-to-typair-aux 
		       (imp-form-to-conclusion formula) pvar-to-tvar)))
    ((and)
     (make-star-fiet (FI-formula-to-typair-aux 
		      (and-form-to-left formula) pvar-to-tvar)
		     (FI-formula-to-typair-aux 
		      (and-form-to-right formula) pvar-to-tvar)))
    ((all)
     (make-all-fiet (type-to-tytuple (var-to-type (all-form-to-var formula)))
		    (FI-formula-to-typair-aux 
		     (all-form-to-kernel formula) pvar-to-tvar)))
    ((allnc)
     (FI-formula-to-typair-aux (allnc-form-to-kernel formula) pvar-to-tvar))
    ((ex)
     (make-ex-fiet (type-to-tytuple  (var-to-type (ex-form-to-var formula)))
		   (FI-formula-to-typair-aux 
		    (ex-form-to-kernel formula) pvar-to-tvar)))
    ((exnc)
     (myerror "FI-formula-to-typair: exnc not implemented"))
    ((exca excl)
     (FI-formula-to-typair-aux (unfold-formula formula) pvar-to-tvar))
    ((tensor)
     (myerror "FI-formula-to-typair: tensor not implemented"))
    (else (myerror "FI-formula-to-typair: formula expected" formula))))

(define (make-arrow-fiet typairA typairB)
  (let*((x (typair-left typairA)) 
	(y (typair-right typairA))
	(u (typair-left typairB)) 
	(v (typair-right typairB))
	(xv (tuple-append x v))  
	(bigY (make-tytuple-arrow xv y))
	(bigU (make-tytuple-arrow x u)) 
	(YU (tuple-append bigY bigU)))
    (make-typair YU xv)))

(define (make-arrow-FI-vars vapairA vapairB)
  (let*((x (vapair-left vapairA)) 
	(typ_y (vatuple-to-tytuple (vapair-right vapairA)))
	(typ_u (vatuple-to-tytuple (vapair-left vapairB))) 
	(v (vapair-right vapairB))
	(xv (tuple-append x v))   
	(typ_xv (vatuple-to-tytuple xv)) 
	(typ_x (vatuple-to-tytuple x)) 
	(Y (tytuple-to-vatuple (make-tytuple-arrow typ_xv typ_y)))
	(U (tytuple-to-vatuple (make-tytuple-arrow typ_x typ_u)))
	(YU (tuple-append Y U)))
    (make-vapair YU xv)))

(define (make-star-fiet typairA typairB)
  (let*((x (typair-left typairA)) 
	(y (typair-right typairA))
	(u (typair-left typairB)) 
	(v (typair-right typairB))
	(xu (tuple-append x u))  
	(yv (tuple-append y v)))
    (make-typair xu yv))) 

(define (make-all-fiet z typairA)
  (let*((x (typair-left typairA)) 
	(y (typair-right typairA))
	(bigX (make-tytuple-arrow z x)) 
	(zy (tuple-append z y)))
    (make-typair bigX zy)))

(define (make-ex-fiet z typairA)
  (make-typair (tuple-append z (typair-left typairA)) 
	       (typair-right typairA)))


(define (aconst-to-repro-formula1 x) (cadr (cddddr x)))
(define (aconst-to-repro-formula2 x) (caddr (cddddr x)))

(define (ex-formula-to-ex-intro-vatmpair ex-formula pvar-to-tvar)
  (let*((z (var-to-vatuple (ex-form-to-var ex-formula)))
	(kernel (ex-form-to-kernel ex-formula))
	(kernel-typair (FI-formula-to-typair-aux kernel pvar-to-tvar))
	(x (tytuple-to-vatuple (typair-left kernel-typair))) 
	(y (tytuple-to-vatuple (typair-right kernel-typair)))
	(zx (tuple-append z x)) 
	(zxy (tuple-append zx y))
	(tm-Y (make-tmtuple-in-abst-form zxy (vatuple-to-tmtuple y)))
	(tm-ZU (make-tmtuple-in-abst-form 
		zx (vatuple-to-tmtuple (tuple-append z x))))
	(tm-YZU (tuple-append tm-Y tm-ZU))
	(rv (make-vatmpair (make-vapair zxy NULLvatuple) 
			   (make-tmpair tm-YZU NULLtmtuplealist))))
    (begin (nldisplay "ex-intro: " (formula-to-string ex-formula)) rv)))


(define (ex-formula-and-concl-to-ex-elim-vatmpair ex-formula concl
						  pvar-to-tvar)
  (let*((z (var-to-vatuple (ex-form-to-var ex-formula)))
	(kernel (ex-form-to-kernel ex-formula))
	(kernel-typair (FI-formula-to-typair-aux kernel pvar-to-tvar))
	(x (tytuple-to-vatuple (typair-left kernel-typair))) 
	(yp (tytuple-to-vatuple (typair-right kernel-typair)))
	(concl-typair (FI-formula-to-typair-aux concl pvar-to-tvar))
	(up (tytuple-to-vatuple (typair-left concl-typair)))
	(v (tytuple-to-vatuple (typair-right concl-typair)))
	(zx (tuple-append z x)) 
	(zxv (tuple-append zx v))
	(typ_y (make-tytuple-arrow (vatuple-to-tytuple zxv) 
				   (vatuple-to-tytuple yp)))
	(y (tytuple-to-vatuple typ_y))
	(typ_u (make-tytuple-arrow (vatuple-to-tytuple zx) 
				   (vatuple-to-tytuple up)))
	(u (tytuple-to-vatuple typ_u))  
	(zxy (tuple-append zx y))
	(zxyu (tuple-append zxy u))   
	(zxyuv (tuple-append zxyu v))
	(tm-yp (make-tmtuple-in-app-form (vatuple-to-tmtuple y)
					 (vatuple-to-tmtuple zxv)))
	(tm-ypz (tuple-append tm-yp (vatuple-to-tmtuple z)))
	(tm-xv (tuple-append (vatuple-to-tmtuple x) (vatuple-to-tmtuple v)))
	(tm-YZXV (make-tmtuple-in-abst-form zxyuv (tuple-append tm-ypz tm-xv)))
	(tm-U (make-tmtuple-in-abst-form 
	       zxyu (make-tmtuple-in-app-form (vatuple-to-tmtuple u)
					      (vatuple-to-tmtuple zx))))
	(tm-YZXVU (tuple-append tm-YZXV tm-U))
	(rv (make-vatmpair (make-vapair zxyuv NULLvatuple) 
			   (make-tmpair tm-YZXVU NULLtmtuplealist))))
    (begin (nldisplay "ex-elim: " (formula-to-string ex-formula)) rv)))

; make-FI-avar-or-ga-to-vapair returns a procedure assigning to
; assumption variables or constants (gas) whose types have
; computational content new object variables of the corresponding
; fiet-type.  It remembers the assignment done so far.

(define (make-FI-avar-or-ga-to-vapair pvar-to-tvar)
  (let ((avar-assoc-list '()) 
	(ga-assoc-list '()))
    (lambda (x)
      (let((info (if (avar-form? x) 
		     (assoc-wrt avar=? x avar-assoc-list)
		     (assoc-wrt aconst=? x ga-assoc-list))))
        (if info (cadr info)
            (let*((formula (if (avar-form? x) (avar-to-formula x) 
			       (aconst-to-formula x)))
		  (typair (FI-formula-to-typair-aux formula pvar-to-tvar))
		  (tytuple1 (typair-left typair))
		  (tytuple2 (typair-right typair))
		  (new-vatuple1 (tytuple-to-vatuple tytuple1))
		  (new-vatuple2 (tytuple-to-vatuple tytuple2))
		  (vapair (make-vapair new-vatuple1 new-vatuple2)))
	      (begin (if (avar-form? x)
			 (set! avar-assoc-list
			       (cons (list x vapair) avar-assoc-list))
			 (set! ga-assoc-list
			       (cons (list x vapair) ga-assoc-list)))
		     vapair)))))))


(define (FI-proof-to-extracted-vatmpair proof)
  (let*((pvar-to-tvar (make-pvar-to-tvar))
	(avar-or-ga-to-vapair (make-FI-avar-or-ga-to-vapair pvar-to-tvar)))
    (FI-proof-to-extracted-vatmpair-aux
     proof pvar-to-tvar avar-or-ga-to-vapair)))

(define (FI-proof-to-extracted-vatmpair-aux 
	 proof pvar-to-tvar avar-or-ga-to-vapair)
  (case (tag proof)
    ((proof-in-avar-form)
     (let*((avar (proof-in-avar-form-to-avar proof))
	   (vapair (avar-or-ga-to-vapair avar))
	   (x (vapair-left vapair))
	   (y (vapair-right vapair))
	   (xy (tuple-append x y))
	   (tx (vatuple-to-tmtuple x))
	   (ty (vatuple-to-tmtuple y))
	   (T-list (list (cons avar (make-tmtuple-in-abst-form xy ty))))
	   (T (make-tmtuple-in-abst-form x tx))
	   (rv (make-vatmpair (make-vapair y x) (make-tmpair T T-list))))
       rv))
    ((proof-in-aconst-form)
     (let*((aconst (proof-in-aconst-form-to-aconst proof)) 
	   (name (aconst-to-name aconst)))
       (case (aconst-to-kind aconst)
	 ((axiom) 
	  (cond 
	   ((string=? "Ind" name) 
	    (let ((all-formulas (aconst-to-repro-formulas aconst)))
	      (if
	       (not (null? (cdr all-formulas)))
	       (myerror "FI-proof-to-extracted-vatmpair: Ind: 
                                     only one universal formula allowed")
	       (let* ((all-formula (car all-formulas))
		      (variab (all-form-to-var all-formula))
		      (type (var-to-type variab)))
		 (if (or (not (alg-form? type)) 
			 (not (string=? "nat"  (alg-form-to-name type))))
		     (myerror "FI-proof-to-extracted-vatmpair: Ind: 
                                              only nat algebra allowed")
		     (let* ((kernel (all-form-to-kernel all-formula))
			    (tvariab (make-term-in-var-form variab))
			    (base (formula-subst  kernel variab (pt "0")))
			    (step (make-imp kernel
					    (formula-subst
					     kernel variab
					     (make-term-in-app-form
					      (pt "Succ") tvariab))))
			    (assumpt (make-and base (make-all variab step)))
			    (P1 (let ((avar (formula-to-new-avar assumpt)))  
				  (make-proof-in-imp-intro-form
				   avar 
				   (make-proof-in-and-elim-left-form
				    (make-proof-in-avar-form avar)))))
			    (Q (let ((avar (formula-to-new-avar assumpt)))  
				 (make-proof-in-imp-intro-form
				  avar
				  (make-proof-in-all-elim-form 
				   (make-proof-in-and-elim-right-form
				    (make-proof-in-avar-form avar)) tvariab))))
			    (P2 (let ((avarC (formula-to-new-avar assumpt)) 
				      (avarCAz (formula-to-new-avar 
						(make-imp assumpt kernel))))
				  (make-proof-in-all-intro-form
				   variab  
				   (make-proof-in-imp-intro-form
				    avarCAz 
				    (make-proof-in-imp-intro-form
				     avarC  
				     (make-proof-in-imp-elim-form
				      (make-proof-in-imp-elim-form
				       Q  
				       (make-proof-in-avar-form avarC))
				      (make-proof-in-imp-elim-form 
				       (make-proof-in-avar-form avarCAz)
				       (make-proof-in-avar-form avarC))))))))
			    (vatmp1 (FI-proof-to-extracted-vatmpair-aux 
				     P1 pvar-to-tvar avar-or-ga-to-vapair))
			    (vatmp2 (FI-proof-to-extracted-vatmpair-aux 
				     P2 pvar-to-tvar avar-or-ga-to-vapair))
			    (yp (vapair-left (vatmpair-to-vapair vatmp1)))
			    (Tp (tmpair-to-tuple (vatmpair-to-tmpair vatmp1)))
			    (Ts (cdr (split-tuple
				      yp 
				      (tmpair-to-tuple
				       (vatmpair-to-tmpair vatmp2)))))
			    (dp (split-list
				 Tp (cdr 
				     (vapair-left
				      (vatmpair-to-vapair vatmp2)))))
			    (t-z (make-term-in-var-form (caar dp))) 
			    (ys (valist-to-tmlist (cdar dp)))
			    (folded-ys (type-to-new-var
					(term-to-type 
					 (tmtuple-to-term
					  (cons 'tmtuple ys)))))
			    (unfolded-ys (term-to-tmtuple 
					  (make-term-in-var-form folded-ys)))
			    (t-zys (tuple-append (term-to-tmtuple-aux t-z)  
						 unfolded-ys))
			    (tTp (tmtuple-to-term Tp)) 
			    (tTs (make-term-in-abst-form
				  (caar dp) 
				  (make-term-in-abst-form
				   folded-ys
				   (tmtuple-to-term
				    (make-tmtuple-in-app-form 
				     Ts t-zys)))))
			    (R (make-term-in-const-form
				(type-info-to-rec-const
				 (make-arrow type (term-to-type tTp)))))
			    (tT (make-term-in-app-form
				 (make-term-in-app-form R tTp) 
				 tTs))
			    (T (term-to-tmtuple
				(make-term-in-app-form tT t-z)))
			    (x (tytuple-to-vatuple
				(typair-left 
				 (FI-formula-to-typair-aux
				  assumpt pvar-to-tvar))))
			    (t-x (vatuple-to-tmtuple x))
			    (realT (make-tmtuple-in-abst-form 
				    (tuple-append x (var-to-vatuple (caar dp)))
				    (make-tmtuple-in-app-form T t-x)))
			    (v (tytuple-to-vatuple 
				(typair-right
				 (FI-formula-to-typair-aux 
				  (make-imp assumpt all-formula)
				  pvar-to-tvar))))
			    (rv (make-vatmpair
				 (make-vapair v NULLvatuple) 
				 (make-tmpair realT NULLtmtuplealist))))
		       rv))))))
	   ((string=? "Cases" name)
	    (myerror "FI-proof-to-extracted-vatmpair: Cases not implemented"))
	   ((string=? "Ex-Intro" name)
	    (ex-formula-to-ex-intro-vatmpair
	     (aconst-to-repro-formula1 aconst) pvar-to-tvar))
	   ((string=? "Ex-Elim" name) 
	    (ex-formula-and-concl-to-ex-elim-vatmpair 
	     (aconst-to-repro-formula1 aconst)
	     (aconst-to-repro-formula2 aconst) pvar-to-tvar))
	   ((string=? "Exnc-Elim" name)
	    (myerror
	     "FI-proof-to-extracted-vatmpair: Exnc-Elim not implemented"))
	   ((string=? "Exnc-Intro" name)
	    (myerror
	     "FI-proof-to-extracted-vatmpair: Exnc-Intro not implemented"))
	   ((or (string=? "Intro" name) (string=? "Elim" name))
	    (myerror "FI-proof-to-extracted-vatmpair: Inductive Definitions 
                                                 not implemented"))
	   ((string=? "Eq-Compat" name)
	    (let*((formula (unfold-formula (aconst-to-inst-formula aconst)))
		  (kernel (imp-form-to-conclusion
			   (imp-form-to-conclusion formula)))
		  (typair (FI-formula-to-typair-aux kernel pvar-to-tvar))
		  (u (tytuple-to-vatuple (typair-left typair)))
		  (v (tytuple-to-vatuple (typair-right typair)))
		  (uv (tuple-append u v))
		  (Tv (make-tmtuple-in-abst-form uv (vatuple-to-tmtuple v)))
		  (Tu (make-tmtuple-in-abst-form u (vatuple-to-tmtuple u)))
		  (Tvu (tuple-append Tv Tu)))
	      (make-vatmpair (make-vapair uv NULLvatuple) 
			     (make-tmpair Tvu NULLtmtuplealist))))
	   ((string=? "Truth-Axiom" name)
	    (begin (nldisplay "Truth-Axiom:")
		   (make-vatmpair (make-vapair NULLvatuple  NULLvatuple) 
				  (make-tmpair NULLtmtuple NULLtmtuplealist))))
	   (else (myerror
		  "FI-proof-to-extracted-vatmpair-aux: axiom expected" name))))
	 ((theorem)
	  (FI-proof-to-extracted-vatmpair-aux
	   (theorem-aconst-to-inst-proof aconst)
	   pvar-to-tvar avar-or-ga-to-vapair))
	 ((global-assumption) 
	  (let((info (assoc name GLOBAL-ASSUMPTIONS)))
	    (if
	     info
	     (cond
	      ((string=? "Stab-Log" name)
	       (myerror
		"FI-proof-to-extracted-vatmpair: Stab-Log not allowed here"))
	      ((string=? "Efq-Log" name)
	       (let* ((formula (aconst-to-inst-formula aconst))
		      (kernel (imp-form-to-conclusion formula))
		      (kernel-typair (FI-formula-to-typair-aux
				      kernel pvar-to-tvar))
		      (Tx (tytuple-to-zero-tmtuple
			   (typair-left kernel-typair)))
		      (y (tytuple-to-vatuple (typair-right kernel-typair))))
		 (make-vatmpair (make-vapair y NULLvatuple) 
				(make-tmpair Tx NULLtmtuplealist))))
	      ((string=? "Efq" name)
	       (let* ((formula (aconst-to-inst-formula aconst))
		      (typair (FI-formula-to-typair-aux formula pvar-to-tvar))
		      (Tx (tytuple-to-zero-tmtuple (typair-left typair)))
		      (y (tytuple-to-vatuple (typair-right typair))))
		 (make-vatmpair (make-vapair y NULLvatuple)
				(make-tmpair Tx NULLtmtuplealist))))
	      ((or (and (<= (string-length "Eq-Compat-Rev")
			    (string-length name))
			(string=?
			 (substring name 0 (string-length "Eq-Compat-Rev"))
			 "Eq-Compat-Rev"))
		   (and (<= (string-length "Compat-Rev")  (string-length name))
			(string=?
			 (substring name 0 (string-length "Compat-Rev"))
			 "Compat-Rev")))
	       (let* ((formula
		       (unfold-formula (aconst-to-inst-formula aconst)))
		      (kernel
		       (imp-form-to-conclusion
			(imp-form-to-conclusion formula)))
		      (typair (FI-formula-to-typair-aux kernel pvar-to-tvar))
		      (u (tytuple-to-vatuple (typair-left typair)))
		      (v (tytuple-to-vatuple (typair-right typair)))
		      (uv (tuple-append u v))
		      (Tv (make-tmtuple-in-abst-form
			   uv (vatuple-to-tmtuple v)))
		      (Tu (make-tmtuple-in-abst-form u (vatuple-to-tmtuple u)))
		      (Tvu (tuple-append Tv Tu)))
		 (make-vatmpair (make-vapair uv NULLvatuple)
				(make-tmpair Tvu NULLtmtuplealist))))
	      (else (let* ((formula (unfold-formula (aconst-to-inst-formula aconst)))
			   (vapair (avar-or-ga-to-vapair aconst))
			   (Tx (vatuple-to-tmtuple (vapair-left vapair))) 
			   (y (vapair-right vapair)))
		      (make-vatmpair (make-vapair y NULLvatuple)
				     (make-tmpair Tx NULLtmtuplealist)))))
	     (myerror "FI-proof-to-extracted-vatmpair: global 
                                                  assumption expected" name))))
	 (else (myerror
		"FI-proof-to-extracted-vatmpair: unknown kind of aconst"
		(aconst-to-kind aconst))))))
    ((proof-in-imp-intro-form)
     (let*((avar (proof-in-imp-intro-form-to-avar proof))
	   (z (vapair-left (avar-or-ga-to-vapair avar)))
	   (kernel (proof-in-imp-intro-form-to-kernel proof))
	   (vatmpair (FI-proof-to-extracted-vatmpair-aux
		      kernel pvar-to-tvar avar-or-ga-to-vapair))
	   (kvapair (vatmpair-to-vapair vatmpair))
	   (y (vapair-left kvapair))
	   (xpx (vapair-right kvapair)) 
	   (t-xpxy (vatuple-to-tmtuple (tuple-append xpx  y)))
	   (ktmpair (vatmpair-to-tmpair vatmpair))
	   (T (tmpair-to-tuple ktmpair))
	   (kalist (tmpair-to-alist ktmpair))
	   (vatuple-tmtuplealist-tmtuplist 
	    (imp-intro-split avar kalist avar-or-ga-to-vapair))
	   (x (caar vatuple-tmtuplealist-tmtuplist)) 
	   (new-alist (cdar vatuple-tmtuplealist-tmtuplist))
	   (tmtuplist (make-tmtuplist-in-app-form 
		       (cdr vatuple-tmtuplealist-tmtuplist) t-xpxy))
	   (tmtuple (imp-intro-CondN tmtuplist z (avar-to-formula avar)))
	   (xz (tuple-append x z))
	   (xzy (tuple-append xz y))
	   (zy (tuple-append z y))
	   (zxy (tuple-append xpx y))
	   (St (make-tmtuple-in-abst-form xzy tmtuple))
	   (Ss (make-tmtuple-in-abst-form xz (make-tmtuple-in-app-form 
					      T (vatuple-to-tmtuple xpx))))
	   (S (tuple-append St Ss))
	   (uS (make-tmtuplealist-in-abst-form 
		xzy (make-tmtuplealist-in-app-form 
		     new-alist (vatuple-to-tmtuple zxy))))
	   (rv (make-vatmpair (make-vapair zy x) (make-tmpair S uS))))
       rv))
    ((proof-in-imp-elim-form)
     (let*((op (proof-in-imp-elim-form-to-op proof))
           (op-vatmpair (FI-proof-to-extracted-vatmpair-aux
                         op pvar-to-tvar avar-or-ga-to-vapair))
           (op-vapair (vatmpair-to-vapair op-vatmpair))
           (op-tmpair (vatmpair-to-tmpair op-vatmpair))
	   (op-tmtuplealist (tmpair-to-alist op-tmpair))
           (arg (proof-in-imp-elim-form-to-arg proof))
           (arg-vatmpair (FI-proof-to-extracted-vatmpair-aux
			  arg pvar-to-tvar avar-or-ga-to-vapair))
           (arg-vapair (vatmpair-to-vapair arg-vatmpair))
           (arg-tmpair (vatmpair-to-tmpair arg-vatmpair))
	   (arg-tmtuplealist (tmpair-to-alist arg-tmpair))
           (xp (vapair-right arg-vapair)) 
	   (xs (vapair-right op-vapair)) 
           (x (tuple-append xp xs))
           (ysy (vapair-left op-vapair))  
	   (yp (vapair-left arg-vapair))
	   (A (proof-to-formula arg)) 
	   (AlimpB (proof-to-formula op)) 
	   (B (proof-to-formula proof)) 
	   (valist (set-minus
		    (formula-to-free A)
		    (union (formula-to-free B)
			   (alist-to-formula-free op-tmtuplealist) 
			   (alist-to-formula-free arg-tmtuplealist))))
	   (subst (make-substitution valist (valist-to-zero-tmlist valist)))
	   (Tp (tmtuple-substitute (tmpair-to-tuple arg-tmpair) subst))
           (TsT (tmtuple-substitute (tmpair-to-tuple op-tmpair) subst))
           (xsTpxp (tuple-append
		    (vatuple-to-tmtuple xs)
		    (make-tmtuple-in-app-form Tp (vatuple-to-tmtuple xp))))
           (ys-y (split-tuple Tp ysy)) 
	   (ys (car ys-y)) 
	   (y (cdr ys-y)) 
	   (xy (tuple-append x y))
           (Ts-T (split-tuple yp TsT)) 
	   (Ts (car Ts-T)) 
	   (T (cdr Ts-T)) 
           (xsTpxpy (tuple-append xsTpxp (vatuple-to-tmtuple y)))
           (xpTsxsTpxpy
	    (tuple-append (vatuple-to-tmtuple xp) 
			  (make-tmtuple-in-app-form Ts xsTpxpy)))
           (S (make-tmtuple-in-abst-form
	       x (make-tmtuple-in-app-form T xsTpxp)))
           (uSarg (make-tmtuplealist-in-abst-form
		   xy 
		   (make-tmtuplealist-in-app-form
		    (tmtuplealist-substitute 
		     arg-tmtuplealist subst) xpTsxsTpxpy)))
           (uSop (make-tmtuplealist-in-abst-form
		  x 
		  (make-tmtuplealist-in-app-form
		   (tmtuplealist-substitute 
		    op-tmtuplealist subst) xsTpxp)))
           (uS (append uSarg uSop))
           (rv (make-vatmpair (make-vapair y x) (make-tmpair S uS))))
       rv))
    ((proof-in-and-intro-form)
     (let*((left (proof-in-and-intro-form-to-left proof))
           (right (proof-in-and-intro-form-to-right proof))
           (left-vatmpair (FI-proof-to-extracted-vatmpair-aux 
                           left pvar-to-tvar avar-or-ga-to-vapair))
           (left-vapair (vatmpair-to-vapair left-vatmpair)) 
           (yp (vapair-left left-vapair))
           (xp (vapair-right left-vapair))
           (left-tmpair (vatmpair-to-tmpair left-vatmpair))
           (Tp (tmpair-to-tuple left-tmpair))
           (uTp (tmpair-to-alist left-tmpair))
           (right-vatmpair (FI-proof-to-extracted-vatmpair-aux 
                            right pvar-to-tvar avar-or-ga-to-vapair))
           (right-vapair (vatmpair-to-vapair right-vatmpair))
           (ys (vapair-left right-vapair))
           (xs (vapair-right right-vapair))
           (right-tmpair (vatmpair-to-tmpair right-vatmpair))
           (Ts (tmpair-to-tuple right-tmpair))
           (uTs (tmpair-to-alist right-tmpair))
           (x (tuple-append xp xs))
           (y (tuple-append yp ys))
           (xy (tuple-append x y))
           (xpyp (tuple-append xp yp))
           (xsys (tuple-append xs ys))
           (uSA  (make-tmtuplealist-in-app-form uTp (vatuple-to-tmtuple xpyp)))
           (uSB  (make-tmtuplealist-in-app-form uTs (vatuple-to-tmtuple xsys)))
           (uS (make-tmtuplealist-in-abst-form xy (append uSA uSB)))
           (SA (make-tmtuple-in-abst-form
		x 
		(make-tmtuple-in-app-form Tp (vatuple-to-tmtuple xp))))
           (SB (make-tmtuple-in-abst-form
		x 
		(make-tmtuple-in-app-form Ts (vatuple-to-tmtuple xs))))
           (S (tuple-append SA SB))
           (rv (make-vatmpair (make-vapair y x) (make-tmpair S uS))))
       rv))
    ((proof-in-and-elim-left-form)
     (let*((kernel (proof-in-and-elim-left-form-to-kernel proof))
           (formula (proof-to-formula kernel))
           (A (and-form-to-left formula))
           (B (and-form-to-right formula))
           (typair (FI-formula-to-typair-aux (and-form-to-left formula)  
                                             pvar-to-tvar))
           (vatmpair (FI-proof-to-extracted-vatmpair-aux
                      kernel pvar-to-tvar avar-or-ga-to-vapair))
           (tmpair (vatmpair-to-tmpair vatmpair))
           (tmtuplealist (tmpair-to-alist tmpair))
           (vapair (vatmpair-to-vapair vatmpair))
           (Sp (car (split-tuple (typair-left typair) 
				 (tmpair-to-tuple tmpair))))
           (valist (set-minus (formula-to-free B)
			      (append (formula-to-free A) 
				      (alist-to-formula-free tmtuplealist))))
           (subst (make-substitution valist (valist-to-zero-tmlist valist)))
           (Tp (tmtuple-substitute Sp subst))
	   (tmtuplealist (tmtuplealist-substitute tmtuplealist subst))
           (dp (split-tuple (typair-right typair) 
			    (vapair-left vapair)))
           (yp (car dp)) 
	   (xyp (tuple-append (vapair-right vapair) yp))
           (zero-tmtuple (vatuple-to-zero-tmtuple (cdr dp)))
           (xypZero (tuple-append  (vatuple-to-tmtuple xyp) zero-tmtuple))
           (uS-aux (make-tmtuplealist-in-app-form tmtuplealist xypZero))
           (uS (make-tmtuplealist-in-abst-form xyp uS-aux))
           (rv (make-vatmpair (make-vapair yp (vapair-right vapair)) 
                              (make-tmpair Tp uS))))
       rv))
    ((proof-in-and-elim-right-form)
     (let*((kernel (proof-in-and-elim-right-form-to-kernel proof))
	   (formula (proof-to-formula kernel))
	   (A (and-form-to-left formula))
	   (B (and-form-to-right formula))
	   (typair (FI-formula-to-typair-aux (and-form-to-left formula) 
					     pvar-to-tvar))
	   (vatmpair (FI-proof-to-extracted-vatmpair-aux
		      kernel pvar-to-tvar avar-or-ga-to-vapair))
	   (tmpair (vatmpair-to-tmpair vatmpair))
	   (tmtuplealist (tmpair-to-alist tmpair))
	   (vapair (vatmpair-to-vapair vatmpair))
	   (Ss (cdr (split-tuple (typair-left typair) 
				 (tmpair-to-tuple tmpair))))
	   (valist (set-minus (formula-to-free A)
			      (append (formula-to-free B)
				      (alist-to-formula-free tmtuplealist))))
	   (subst (make-substitution valist (valist-to-zero-tmlist valist)))
	   (Ts (tmtuple-substitute Ss subst))
	   (tmtuplealist (tmtuplealist-substitute tmtuplealist subst))
	   (dp (split-tuple (typair-right typair) 
			    (vapair-left vapair)))
	   (ys (cdr dp)) 
	   (x (vapair-right vapair))
	   (xys (tuple-append x ys))
	   (zero (vatuple-to-zero-tmtuple (car dp)))
	   (uS (make-tmtuplealist-in-abst-form
		xys 
		(make-tmtuplealist-in-app-form
		 tmtuplealist
		 (tuple-append (vatuple-to-tmtuple x) 
			       (tuple-append zero (vatuple-to-tmtuple ys))))))
	   (rv (make-vatmpair (make-vapair ys x) (make-tmpair Ts uS))))
       rv)) 
    ((proof-in-all-intro-form)
     (let*((z (var-to-vatuple (proof-in-all-intro-form-to-var proof)))
           (kernel (proof-in-all-intro-form-to-kernel proof))
           (vatmpair (FI-proof-to-extracted-vatmpair-aux  
                      kernel pvar-to-tvar avar-or-ga-to-vapair))
           (tmpair (vatmpair-to-tmpair vatmpair)) 
	   (vapair (vatmpair-to-vapair vatmpair))
           (x (vapair-right vapair)) 
	   (t-x (vatuple-to-tmtuple x))
           (T (tmpair-to-tuple tmpair)) 
	   (uT (tmpair-to-alist tmpair))
           (xz (tuple-append x z)) 
	   (zy (tuple-append z (vapair-left vapair)))
           (S (make-tmtuple-in-abst-form
	       xz 
	       (make-tmtuple-in-app-form T (vatuple-to-tmtuple x))))
           (uS (make-tmtuplealist-in-abst-form
		xz
		(make-tmtuplealist-in-app-form uT (vatuple-to-tmtuple x))))
           (rv (make-vatmpair (make-vapair zy x) (make-tmpair S uS))))
       rv))
    ((proof-in-all-elim-form)
     (let*((op (proof-in-all-elim-form-to-op proof))
           (t (proof-in-all-elim-form-to-arg proof))
           (vatmpair (FI-proof-to-extracted-vatmpair-aux 
		      op pvar-to-tvar avar-or-ga-to-vapair))
           (tmpair (vatmpair-to-tmpair vatmpair)) 
	   (vapair (vatmpair-to-vapair vatmpair))
           (zy (vapair-left vapair)) 
	   (x (vapair-right vapair))
           (S (tmpair-to-tuple tmpair))  
           (uS (tmpair-to-alist tmpair))
           (tuple-t (term-to-tmtuple-aux t)) 
           (dp (split-tuple tuple-t zy))
           (y (cdr dp)) 
           (xt (tuple-append (vatuple-to-tmtuple x) tuple-t))
           (T (make-tmtuple-in-abst-form x (make-tmtuple-in-app-form S xt)))
           (uT (make-tmtuplealist-in-abst-form 
		x (make-tmtuplealist-in-app-form uS xt))) 
           (rv (make-vatmpair (make-vapair y x) (make-tmpair T uT))))
       rv))
    ((proof-in-allnc-intro-form)
     (FI-proof-to-extracted-vatmpair-aux
      (proof-in-allnc-intro-form-to-kernel
       proof)  pvar-to-tvar avar-or-ga-to-vapair))
    ((proof-in-allnc-elim-form)
     (FI-proof-to-extracted-vatmpair-aux (proof-in-allnc-elim-form-to-op proof)
					 pvar-to-tvar avar-or-ga-to-vapair))
    (else (myerror "FI-proof-to-extracted-vatmpair: proof expected" proof))))

; PROCEDURE split-list == returns a dotted pair, left being the 
;                         |counter| initial segment of the list and right 
;                         the remaining segment of the list 

(define (split-list counter list)
  (if (null? counter) (cons counter list)
      (if (null? list) (cons  list list)
	  (let((dp (split-list (cdr counter) (cdr list))))
	    (cons (cons (car list) (car dp)) (cdr dp))))))

(define (split-tuple  counter tuple)
  (let((dp (split-list (cdr counter) (cdr tuple))))
    (cons (cons (car tuple) (car dp)) 
	  (cons (car tuple) (cdr dp)))))

(define (imp-intro-split avar  tmtuplealist avar-or-ga-to-vapair)
  (if (not (avar-form? avar))
      (myerror "imp-intro-split: 1st argument must be avar")
      (if (not (tmtuplealist? tmtuplealist))
	  (myerror "imp-intro-split: 2nd argument must be tmtuplealist")
	  (if (null? tmtuplealist) (cons (cons NULLvatuple (list)) (list))
	      (let((recval (imp-intro-split avar (cdr tmtuplealist) 
					    avar-or-ga-to-vapair)))
		(if (avar=? avar (caar tmtuplealist))
		    (cons (car recval) (cons (cdar tmtuplealist) (cdr recval)))
		    (cons (cons (tuple-append 
				 (vapair-left (avar-or-ga-to-vapair
					       (caar tmtuplealist))) 
				 (caar recval))
				(cons (car tmtuplealist) (cdar recval)))
			  (cdr recval))))))))

(define (imp-intro-CondN-tmlist vatuple tmtuplist dp)
  (if (not (vatuple? vatuple))
      (myerror "imp-intro-CondN-tmlist: first argument must be vatuple")
      (if (not (tmtuplist? tmtuplist))
	  (myerror "imp-intro-CondN-tmlist: 2nd argument must be tmtuplist")
	  (if (not (and (term-form? (car dp)) (vapair? (cdr dp))))
	      (myerror "imp-intro-CondN-tmlist: 3rd argument must be 
                                   a dotted pair of a term and a vatuple")
	      (let*((tAD (car dp)) 
		    (vapair (cdr dp))
		    (vatupEX (vapair-left vapair)) 
		    (vatupFA (vapair-right vapair))
		    (new-tAD (term-substitute
			      tAD	
			      (make-substitution
			       (cdr vatupEX) 
			       (valist-to-tmlist (cdr vatuple))))))
		(imp-intro-CondN-tmlist-aux
		 new-tAD (cdr vatupFA) tmtuplist))))))

(define (imp-intro-CondN-tmlist-aux new-tAD valist tmtuplist)
  (if (null? tmtuplist) (list)
      (cons (term-substitute new-tAD
			     (make-substitution valist (cdar tmtuplist)))
	    (imp-intro-CondN-tmlist-aux new-tAD valist (cdr tmtuplist)))))

(define (imp-intro-CondN old-tmtuplist vatuple formula)
  (if (not (tmtuplist? old-tmtuplist)) 
      (myerror "imp-intro-CondN: 1st argument must be a tmtuplist")
      (if (not (vatuple? vatuple))
	  (myerror "imp-intro-CondN: 2nd argument must be a vatuple")
	  (if (not (formula-form? formula))
	      (myerror "imp-intro-CondN: 2nd argument must be a formula")
	      (if (null? old-tmtuplist) NULLtmtuple
		  (let*((term-and-vapair
			 (FI-formula-to-term-and-vapair formula))
			(tmlist (imp-intro-CondN-tmlist 
				 vatuple
				 (cdr old-tmtuplist) term-and-vapair))
			(LEGDUM
			 (if (not (tmlist? tmlist)) 
			     (myerror "imp-intro-CondN: tmlist expected")))
			(tmtuple (car old-tmtuplist)) 
			(tmtuplist (cdr old-tmtuplist))
			(LEGDUM
			 (if (not (eq? (length tmtuplist) (length tmlist)))
			     (myerror "CondN: 2nd and 3rd argument must be 
                                                  lists of equal length"))))
		    (imp-intro-CondN-aux tmtuple tmtuplist tmlist)))))))

(define (imp-intro-CondN-aux tmtuple tmtuplist tmlist)
  (if (null? tmlist) tmtuple
      (make-tmtuple-in-if-form 
       (car tmlist) (imp-intro-CondN-aux tmtuple (cdr tmtuplist) (cdr tmlist)) 
       (car tmtuplist))))

(define (make-tmtuple-in-if-form term tmtup1 tmtup2)
  (if (not (and (term-form? term) (tmtuple? tmtup1) (tmtuple? tmtup2)))
      (myerror "make-tmtuple-in-if-form: 1st argument must be term 
                                 and the other 2 tmtuples")
      (if (not (eq? (length tmtup1) (length tmtup2)))
	  (myerror "make-tmtuple-in-if-form: arguments 2 and 3 must be 
                                 tmtuples of equal length")
	  (cons 'tmtuple (make-tmlist-in-if-form 
			  term	(cdr tmtup1) (cdr tmtup2))))))

(define (make-tmlist-in-if-form term tmlist1 tmlist2)
  (if (null? tmlist2) (list)
      (cons (make-term-in-if-form term (list (car tmlist1) (car tmlist2)))
	    (make-tmlist-in-if-form term (cdr tmlist1) (cdr tmlist2)))))

; (FI-formula-to-term-and-vapair A) returns a dotted pair (t_A . <x,y>) 
; with 1st component a boolean term t_A built from the free
; variables of A, x and y and 2nd component a vapair <x,y> such that
; A_D(x; y;a) <-> atom(t_A)

(define (FI-formula-to-term-and-vapair formula)
  (case (tag formula)
    ((atom) 
     (cons (atom-form-to-kernel formula) NULLvapair))
    ((predicate)
     (if (formula=? falsity-log formula)
	 (cons (make-term-in-const-form false-const) NULLvapair)
	 (myerror "FI-formula-to-term-and-vapair: unexpected predicate"
		  (formula-to-string formula))))
    ((imp)
     (let* ((A (FI-formula-to-term-and-vapair (imp-form-to-premise formula)))
	    (tA (car A)) 
	    (vapairA (cdr A)) 
	    (x (vapair-left vapairA)) 
	    (y (vapair-right vapairA))
	    (typ_x (vatuple-to-tytuple x)) 
	    (typ_y (vatuple-to-tytuple y))  
	    (B (FI-formula-to-term-and-vapair
		(imp-form-to-conclusion formula)))
	    (tB (car B)) 
	    (vapairB (cdr B)) 
	    (u (vapair-left vapairB)) 
	    (v (vapair-right vapairB))
	    (typ_u (vatuple-to-tytuple u)) 
	    (xv (tuple-append x v))   
	    (typ_xv (vatuple-to-tytuple xv)) 
	    (bigY (tytuple-to-vatuple (make-tytuple-arrow typ_xv typ_y)))
	    (bigU (tytuple-to-vatuple (make-tytuple-arrow typ_x typ_u)))
	    (YU (tuple-append bigY bigU))
	    (Yxv (make-tmtuple-in-app-form (vatuple-to-tmtuple bigY) 
					   (vatuple-to-tmtuple xv)))
	    (Ux (make-tmtuple-in-app-form (vatuple-to-tmtuple bigU) 
					  (vatuple-to-tmtuple x)))
	    (new_tA (term-substitute tA (make-substitution (cdr y) (cdr Yxv))))
	    (new_tB (term-substitute tB (make-substitution (cdr u) (cdr Ux))))
	    (term  (mk-term-in-app-form  
		    (make-term-in-const-form imp-const) new_tA new_tB))
	    (vapair (make-vapair YU xv)))
       (cons term vapair)))
    ((and)
     (let*((A (FI-formula-to-term-and-vapair (and-form-to-left formula)))
           (tA (car A)) 
	   (vapairA (cdr A)) 
           (x (vapair-left vapairA)) 
	   (y (vapair-right vapairA))
           (B (FI-formula-to-term-and-vapair (and-form-to-right formula)))
           (tB (car B)) 
	   (vapairB (cdr B)) 
           (u (vapair-left vapairB)) 
	   (v (vapair-right vapairB))
           (xu (tuple-append x u)) 
	   (yv (tuple-append y v))
           (term (mk-term-in-app-form
		  (make-term-in-const-form and-const) tA tB))
           (vapair (make-vapair xu yv)))
       (cons term vapair)))
    ((all)
     (let*((A (FI-formula-to-term-and-vapair (all-form-to-kernel formula)))
           (tA (car A)) 
	   (vapairA (cdr A)) 
           (x (vapair-left vapairA)) 
	   (y (vapair-right vapairA))
           (z (var-to-vatuple (all-form-to-var formula)))
           (typ_x (vatuple-to-tytuple x))  
	   (typ_z (vatuple-to-tytuple z))
           (zy (tuple-append z y)) 
	   (bigX (tytuple-to-vatuple (make-tytuple-arrow typ_z typ_x)))
           (Xz (make-tmtuple-in-app-form (vatuple-to-tmtuple bigX)  
					 (vatuple-to-tmtuple z)))
           (term (term-substitute tA (make-substitution (cdr x) (cdr Xz))))
           (vapair (make-vapair bigX zy)))
       (cons term vapair)))
    ((allnc)
     (FI-formula-to-term-and-vapair  (allnc-form-to-kernel formula)))
    ((ex)
     (let*((A (FI-formula-to-term-and-vapair  (ex-form-to-kernel formula)))
           (vapairA (cdr A))
           (z (var-to-vatuple (ex-form-to-var formula))))
       (cons (car A) (make-vapair (tuple-append z (vapair-left vapairA)) 
				  (vapair-right vapairA)))))
    ((exnc)
     (let*((A (FI-formula-to-term-and-vapair (exnc-form-to-kernel formula)))
	   (vapairA (cdr A))
	   (z (var-to-vatuple (exnc-form-to-var formula))))
       (cons (car A) (make-vapair (tuple-append	z (vapair-left vapairA)) 
				  (vapair-right vapairA)))))
    ((tensor)
     (myerror "FI-formula-to-term-and-vapair: not implemented for tensor"))
    ((exca excl)
     (myerror "FI-formula-to-term-and-vapair: exca and excl should 
                                              be unfolded in formula"))
    (else (myerror "FI-formula-to-term-and-vapair:  syntactic error in formula"
		   (formula-to-string formula)))))

(define (imp-elim-ysy-to-Tpxpy-and-y Tpxp ysy)
  (if (not (and (tmtuple? Tpxp) (vatuple? ysy)))
      (myerror "imp-elim-ysy-to-Tpxpy-and-y: first argument must be 
                                tmtuple and second argument must be vatuple")
      (let((dottedpair (imp-elim-ysy-to-Tpxpy-and-y-aux (cdr Tpxp) (cdr ysy))))
	(cons (cons 'tmtuple (car dottedpair)) 
	      (cons 'vatuple (cdr dottedpair))))))

(define (imp-elim-ysy-to-Tpxpy-and-y-aux Tpxp-list ysy-list)
  (if (null? Tpxp-list) (cons (valist-to-tmlist ysy-list) ysy-list)
      (let ((dottedpair (imp-elim-ysy-to-Tpxpy-and-y-aux 
			 (cdr Tpxp-list) (cdr ysy-list))))
	(cons (cons (car Tpxp-list) (car dottedpair)) 
	      (cdr dottedpair)))))


(define (imp-elim-TsT-to-TsxsTpxp-and-TxsTpxp counter TsT tmtupleARG)
  (if (not (and (vatuple? counter) (tmtuple? TsT) (tmtuple? tmtupleARG)))
      (myerror "imp-elim-TsT-to-TsxsTpxp-and-TxsTpxp: first argument 
                   must be vatuple and both last arguments must be tmtuples")
      (let ((dottedpair (imp-elim-TsT-to-TsxsTpxp-and-TxsTpxp-aux 
			 (cdr counter) (cdr TsT) (cdr tmtupleARG))))
	(cons (cons 'tmtuple (car dottedpair)) 
	      (cons 'tmtuple (cdr dottedpair))))))


(define (imp-elim-TsT-to-TsxsTpxp-and-TxsTpxp-aux counter-list TsT-list
						  tmlistARG)
  (if (null? counter-list) 
      (cons (list) (make-tmlist-in-app-form TsT-list tmlistARG))
      (let((dottedpair (imp-elim-TsT-to-TsxsTpxp-and-TxsTpxp-aux 
			(cdr counter-list) (cdr TsT-list) tmlistARG)))
	(cons (cons (make-term-in-app-form-tup (car TsT-list) tmlistARG) 
		    (car dottedpair)) (cdr dottedpair)))))

(newline)
(display "Functional Interpretation extraction module loaded successfully")
(newline)


