; $Id: higman-finite.scm,v 1.7 2006/12/12 16:02:22 schimans Exp $
; higman-finite.scm: Higman's Lemma for a finite alphabet.

(exload "bar/bar.tac")
(animate "Prop1")
(animate "Bar-thm")

; 1. Inductive definition bar on letters (use small capitals)

(apc "ll" (py "(tsil nat)=>nat=>boole")  1)
; note have introduced ll (corresponds to Good(.,.)in the main text)
; program constant instead of an inductive predicate 
; since ll should be decidable.

(add-computation-rule (pt "ll(Lin nat) b")(pt "F"))
(add-computation-rule (pt "ll (as::a) b")
                      (pt "[if (a=b) T (ll as b)]"))

(add-ids (list (list "good" (make-arity word)))
	 '("allnc as,a. ll as a -> good (as::a)")
	 '("allnc as,a. good as -> good (as::a)"))

(add-ids (list (list "bar" (make-arity word) "lltree"))
	 '("allnc as. good as -> bar as" "leaf")
	 '("allnc as. (all a  bar (as::a)) -> bar as" "branch"))

; 2. Inductive definition of Bars

(define seqtsil (py "(tsil(tsil(tsil nat)))"))
(av "vss" "wss" seqtsil)

(apc "Insertfolder"(mk-arrow seqtsil word nat seqtsil) 1)
(add-computation-rule (pt "Insertfolder (vss::ws) w i")
                      (pt "[if (i=Lh vss)
                               (vss::(ws::w))
                               ((Insertfolder vss w i)::ws)]"))

(add-ids (list (list "Bars" (make-arity seqtsil) "trees"))
         '("allnc vss,i. i< Lh vss -> Good ((vss)__i) -> Bars vss" "Leafs")
	 '("allnc vss. (all w,i,n. n=Lh vss -> i< n -> 
                                   Bars(Insertfolder vss w i))
                       -> Bars vss" "Branchs"))

; 3. Definitions of lasts, bseq and Folder

(apc "lasts" (mk-arrow seq word)1)
(add-computation-rule (pt "lasts (Lin (tsil nat))")(pt "(Lin  nat)"))  
(add-computation-rule (pt "lasts (ws::(w::a))")(pt "(lasts ws)::a"))  

(apc "bseq" (mk-arrow word word) 1)
(add-computation-rule (pt "bseq (Lin nat)")(pt "(Lin  nat)")) 
(add-computation-rule (pt "bseq (as::a)")
                      (pt "[if (ll (bseq as) a)
                                (bseq as)
                               ((bseq as)::a)] "))

(apc "memb" (mk-arrow nat word nat) 1)
(add-computation-rule (pt "memb a (w::b)")(pt "[if (a=b) (Lh w) (memb a w)]"))
; (intuition: if a = b_i then memb a [b_0,...,b_n] = i otherwise not spec.)

(apc "folder" (mk-arrow seq seqtsil) 1)
(add-computation-rule (pt "folder (Lin (tsil nat))")
                      (pt "(Lin (tsil(tsil nat)))"))
(add-computation-rule (pt "folder (ws::(w::a))")
                      (pt "[if (ll (bseq (lasts ws)) a)
                               (Insertfolder (folder ws) w  
                                  (memb a (bseq (lasts ws))))
                               ((folder ws)::(ws::w))]"))   

; 4. Interactive proofs and Program extraction

; Lemma 1 (Lemma 5.7)

(aga "Lemma1" (pf "allnc vss,ws,i. i< Lh vss -> Good (vss__i) -> 
                                   folder ws= vss -> Good ws"))
; Lemma 2i (Lemma 5.8 i)

(set-goal (pf "Bars (Lin (tsil(tsil nat)))"))
(intro 1)
(ng)
(assume "w" "i" "n" 1)
(simp 1)
(ng)
(strip)
(use "Efq")
(use 2)
(save "Lemma2i")

; Lemma 2ii (Lemma 5.8ii)

(set-goal (pf " allnc ws.Bar ws -> allnc wss.Bars wss -> Bars (wss::ws)"))
(assume "ws0")

; 1. Ind(Bar).
(elim)

; 1.1
(strip)
(intro 0 (pt "Lh wss"))
(ng)
(use "Truth-Axiom")
(ng)
(use 1)

; 1.2
(assume "ws" "ih1a" "ih1b" "wss0")
(drop "ih1a")

; 2. Ind(Bars).
(elim)

; 2.1.
(strip)
(intro 0 (pt "i"))
(aga "Aux1" (pf "allnc i,j.i<j -> i<j+1"))
(use-with "Aux1" (pt "i")(pt "Lh vss") 3)
(ng)
(aga "Aux2" (pf "allnc i,j.i<j -> i=j->F"))
(inst-with  "Aux2" (pt "i")(pt "Lh vss") 3)
(simp 5)
(ng)
(use 4)

; 2.2 
(assume "wss" "ih2a" "ih2b")
(intro 1)
(assume "w" "i" "n" 5)
(simp 5)
(strip)
(ng)

; 6:i<Succ Lh wss, hence either i=Lh vss  or  i<Lh vss
; instead of cases on i=Lh wss, which is not allowed since wss is a cv-var,
; we do cases on i+1=n (Note: 5:n=Succ Lh wss). 

(cases (pt "i+1=n"))

; case1: i=Lh vss 
(simp 5)
(ng)
(strip)
(simp 7)
(ng)
(use "ih1b")
(intro 1)
(use "ih2a")

;case 2: i<Lh vss (= n-1)
(simp 5)
(ng)
(strip)
(simp 7)
(ng)
(use "ih2b" (pt "n-1"))
(simp 5)
(ng)
(use "Truth-Axiom")
(simp 5)
(ng)
(aga "Aux3" (pf "allnc i,k.i<k+1 -> (i=k -> F) -> i<k"))
(use "Aux3")
(use 6)
(use 7)
(save "Lemma2ii")

; Program extraction
(av "gc" (py "tsil nat=>trees=>trees"))
(av "gd" (py "tsil nat=>nat=>nat=>trees"))
(term-to-expr (nt (proof-to-extracted-term (current-proof))))

; ((|(Rec tree=>trees=>trees)| (lambda (trees2) |Leafs|))
;  (lambda (ga2)
;    (lambda (gc3)
;      ((|(Rec trees=>trees)| |Leafs|)
;       (lambda (gd5)
;         (lambda (gd6)
;           (|Branchs|
;             (lambda (w7)
;               (lambda (a8)
;                 (lambda (a9)
;                   ("if" ((|Succ| a8) "=" a9)
;                         ((gc3 w7) (|Branchs| gd5))
;                         (((gd6 w7) a8) (|Pred| a9)))))))))))))

; Higman's Lemma (Proposition 5.9)

(set-goal (pf "allnc as. bar as ->
               allnc vss. Bars vss ->
               all ws. bseq (lasts ws) = as ->
                       folder ws = vss ->
                       Bar ws"))  
(assume "as0")

; Ind(bar)
(elim)

; 1.1
(strip)
(use "Efq")
(aga "Aux4" (pf "allnc as,ws . good as -> bseq (lasts ws)=as -> F"))
(use-with "Aux4" (pt "as")(pt "ws") 1 3)

; 1.2
(assume "as" "ih1a" "ih1b" "vss0")
(drop "ih1a")

;Ind(Bars)
(elim)

; 2.1.
(strip)
(intro 0)
(use-with "Lemma1" (pt "vss")(pt "ws")(pt "i") 3 4 6)

; 2.2.
(assume "vss" "ih2a" "ih2b" "ws" 5 6)

(intro 1)

; Ind(w)
(ind)

; 3.1
(use "Prop1")

; 3.2
(assume "w" "a" "ih3")

; To show: Bar(ws::w::a)

(cases (pt "ll (bseq(lasts ws)) a"))

; case1: ll (bseq(lasts ws)) a
(strip)

(use "ih2b" (pt "w") (pt "memb a (bseq (lasts (ws::w::a)))") 
            (pt "Lh (folder ws)"))
(simp 6)
(ng)
(use "Truth-Axiom")

(aga "Aux5" (pf " allnc ws,a. ll(bseq(lasts ws))a -> 
                  memb a(bseq(lasts ws::a))<Lh(folder ws)"))
(use "Aux5")
(use 8)

; bseq(lasts(ws::w::a))=as from
(ng)
(simp 8)
(ng)
(use 5)

; folder(ws::w::a)=Insertfolder vss w(memb a(bseq(lasts(ws::w::a)))) from
(ng)
(simp 8)
(ng)
(simp 6)
(ng)
(use "Truth-Axiom")

; case2: (ll(bseq(lasts ws))a -> F)
(strip)
(use "ih1b" (pt "a")(pt "(folder ws)::(ws::w)"))

; Bars (folder ws)::(ws::w)
(use "Lemma2ii")

; Bar(ws::w)
(use "ih3")

; Bars vss
(simp 6)
(intro 1)
(use "ih2a")

; bseq(lasts(ws::w::a))=(as::a)
(ng)
(simp 8)
(ng)
(use 5)

;folder(ws::w::a)=(folder ws)::(ws::w)
(ng)
(simp 8)
(ng)
(use "Truth-Axiom")
(save "Theorem")

(av "ge" (py "nat=>lltree"))
(av "gf" (py "nat=>trees=>tsil(tsil nat)=>tree"))
(av "gg" (py "tsil nat=>nat=>nat=>tsil(tsil nat)=>tree"))
(define program (proof-to-extracted-term (current-proof)))
(term-to-expr (nt program))

; ((|(Rec lltree=>trees=>tsil(tsil nat)=>tree)|
;    (lambda (trees3) (lambda (ws4) |Leaf|)))
;  (lambda (ge3)
;    (lambda (gf4)
;      ((|(Rec trees=>tsil(tsil nat)=>tree)| (lambda (ws7) |Leaf|))
;       (lambda (gd7)
;         (lambda (gg8)
;           (lambda (ws9)
;             (|Branch|
;               ((|(Rec tsil nat=>tree)| (|Branch| (lambda (w11) |Leaf|)))
;                (lambda (w11)
;                  (lambda (a12)
;                    (lambda (tree13)
;                      ("if" ((ll (bseq (lasts ws9))) a12)
;                            ((((gg8 w11)
;                               ((memb a12)
;                                ("if" ((ll (bseq (lasts ws9))) a12)
;                                      (bseq (lasts ws9))
;                                      ((bseq (lasts ws9)) "::" a12))))
;                              ("Lh" (|folder| ws9)))
;                             (ws9 "::" (w11 "::" a12)))
;                            (((gf4 a12)
;                              ((|cLemmaTwoii| tree13) (|Branchs| gd7)))
;                             (ws9 "::" (w11 "::" a12))))))))))))))))
 
(animate "Theorem")
(animate "Lemma2i")
(animate "Lemma2ii")

; Since the given alphabet is finite, here for simplicity we assume
; a fixed number of letters, e.g., 5.

(aga "finitealphabet" (pf " all as. 5<Lh as -> good as"))

(set-goal (pf "bar (Lin nat)"))
(intro 1)(assume "a0")
(intro 1)(assume "a1")
(intro 1)(assume "a2")
(intro 1)(assume "a3")
(intro 1)(assume "a4")
(intro 1)(assume "a5")
(intro 0)(use "finitealphabet")
(ng)
(use "Truth-Axiom")
(save "barNil")
(animate "barNil")

; Higman's Lemma: Bar[]

(set-goal (pf "Bar (Lin (tsil nat))"))
(use "Theorem" (pt "(Lin nat)")(pt "(Lin (tsil (tsil nat)))"))
(use "barNil")
(use "Lemma2i")
(ng)
(use "Truth-Axiom")
(ng)
(use "Truth-Axiom")
(save "Higman-finite")
(animate "Higman-finite")

; Every infinite sequence has a good initial segment

(set-goal (pf "all f. ex m. Good (Init f m)"))
(assume "f")
(use "Bar-thm" (pt "(Lin (tsil nat))")(pt "0"))
(use "Higman-finite")
(ng)
(use "Truth-Axiom")

(define program (proof-to-extracted-term (current-proof)))
(define nprogram (nt program))

; 5. Test of the program

; We define sequences: nat->word via adding term rewriting rules.
; The extracted program yields a number n
; such the initial segment of length n is good.

(define (run-higman infinite-sequence)
  (dt (nt (mk-term-in-app-form nprogram infinite-sequence))))

; a. The sequence [4 1], [3 3 0], [0 4 0 1], [2], ...

(apc "Seq" (mk-arrow (py "nat")(py "(tsil nat)")) 1)
(add-rewrite-rule (pt "Seq 0")(pt ":4::1"))
(add-rewrite-rule (pt "Seq 1")(pt "(:3::3)::0"))
(add-rewrite-rule (pt "Seq 2")(pt "((:0::4)::0)::1"))
(add-rewrite-rule (pt "Seq (++(++(++ n)))")(pt ":2"))
(run-higman (pt "Seq"))
; ==> 3

; b. [0 0], [1], [1 0], [], [], ...

(apc "Interesting" (mk-arrow nat word))
(add-rewrite-rule (pt "Interesting 0")(pt ":0::0"))
(add-rewrite-rule (pt "Interesting 1")(pt ":1"))
(add-rewrite-rule (pt "Interesting 2")(pt ":1::0"))
(add-rewrite-rule (pt "Interesting (++(++(++ n)))")(pt "(Lin nat)"))
(run-higman (pt "Interesting"))
; ==> 5  
; Example that not the shortest good initial seqment is found!

; c. [1], [3], [5], [7], [9], [0], ...

(apc "Sixelts" (mk-arrow nat word))
(add-rewrite-rule (pt "Sixelts 0")(pt ":1"))
(add-rewrite-rule (pt "Sixelts 1")(pt ":3"))
(add-rewrite-rule (pt "Sixelts 2")(pt ":5"))
(add-rewrite-rule (pt "Sixelts 3")(pt ":7"))
(add-rewrite-rule (pt "Sixelts 4")(pt ":9"))
(add-rewrite-rule (pt "Sixelts 5")(pt ":0"))
(run-higman (pt "Sixelts"))

;==> 6
; Note by assumption there are only five different letters;
; So the proof yields that the sequence [[1] [3] [5] [7] [9] [0]] is good;
; i.e., two of the used numbers must be equal.



; 6. Proof of unproven assumptions.

; Note that up to now we have only written down those term rewriting rules
; which were necessary for the proofs given up to now. 
; In order to prove 
; Aux4: all as,ws . good as -> bseq (lasts ws)=as -> F,
; Aux5: all ws,a. ll(bseq(lasts ws))a -> 
                  memb a(bseq(lasts ws::a))<Lh(folder ws),
; we, in addition, either need term rewriting such as 
(add-computation-rule (pt "lasts (ws::(Lin nat))")
        	      (pt "(Lin  nat)"))
(add-computation-rule (pt "folder (ws::(Lin nat))")
                      (pt "(Lin (tsil (tsil nat)))"))
; or we have to exclude this case by assumptions such as
; (all i.i<Lh ws -> ws__i=(Lin nat) -> F) 
; We have chosen the first possiblity  since it leads to shorter proofs.

(set-goal (pf "all as,a. ll as a -> (memb a as) < Lh as"))
(ind)
(ng)
(search)

(assume "w" "b" "ih" "a")
(ng)
(cases (pt "b=a"))
(assume 2)
(simp 2)
(ng)
(simp 2)
(ng)
(search)

(assume 2)
(simp 2)
(ng)
(cut (pf "a=b ->F"))
(assume 3)
(simp 3)
(ng)
(assume 4)
(use "Aux1")
(use-with "ih" (pt "a") 4)

(assume 3)
(use 2)
(simp 3)
(ng)
(use "Truth-Axiom")
(save "Aux5a")

; Next, we prove the following invariant:
(set-goal (pf "all ws. Lh (folder ws) = Lh (bseq (lasts ws))"))
(ind)
(ng)
(use "Truth-Axiom")
(assume "ws")
(ind)
(ng)
(search)

(assume "w" "a" 1 2)
(ng)
(cases (pt "(ll(bseq(lasts ws))a)"))
(assume 3)
(simp 3)
(ng)
; ?_16: Lh(Insertfolder(folder ws)w(memb a(bseq(lasts ws))))=Lh(bseq(lasts ws)) from
(add-rewrite-rule (pt "Lh (Insertfolder vss w a)")(pt "Lh vss"))
(ng)
(use 2)

(ng)
(assume 3)
(simp 3)
(ng)
(use 2)
(save "Aux5b")

; Justification of the rewrite-rule:  Lh (Insertfolder vss w a)   ==>  Lh vss

(set-goal (pf "all vss,w,a. Lh (Insertfolder vss w a) = Lh vss"))
(ind)
(strip)
(ng)
(use "Truth-Axiom")

(assume "vss" "ws" "ih" "w" "a")
(ng)

(cases (pt "a= Lh vss"))
(assume 2)
(simp 2)
(ng)
(use "Truth-Axiom")

(assume 2)
(simp 2)
(ng)
(use "Truth-Axiom")


; Proof of Aux5:
(set-goal (pf "all ws,a. ll(bseq(lasts ws))a -> 
               memb a(bseq(lasts ws::a))<Lh(folder ws)"))
(strip)
(inst-with "Aux5b" (pt "ws"))
(ng)
(simp 1)
(ng)
(simp 2)
(ng)
(use "Aux5a")
(use 1)

; Proof of Aux4:

(set-goal (pf "all as. good as -> (Lin nat)=as -> F"))
(assume "as")
(elim)
(ng)
(search)
(assume "bs" "b" 1 2 3)
(ng)
(use 3)
(save "Aux4a")

(set-goal (pf "all w,a. (w::a)=w-> F"))
(ind)
(ng)
(search)
(assume "w" "b" "ih" "a" 2)
(use "ih" (pt "b"))
(aga "lemma1" (pf "all v,w,a,b. (v::a)=(w::b) -> v=w"))
(use "lemma1" (pt "a")(pt "b"))
(use 2)
(save "wa-ne-w")



(set-goal (pf "all as,a. good (as::a) -> all bs .(as::a)=bseq bs -> F"))
(assume "as1" "a1")
(elim)

; 1. allnc as,a.ll as a -> all bs.bseq bs=(as::a) -> F
(assume "as" "a" 1)
(ind)
; bs=[]
(ng)
(search)

; bs::b
(assume "bs" "b" 2)
(ng)

(cases (pt "(ll(bseq bs)b)"))
(assume 3)
(simp 3)
(ng)
(use 2)

; not ll(bseq bs)b.

(assume 3)
(simp 3)
(ng)
(strip)
(use 3)
(aga "first" (pf "all as,bs,a,b. (as::a)=(bs::b) -> bs=as"))
(aga "second" (pf "all as,bs,a,b. (as::a)=(bs::b) -> b=a"))
(inst-with "first" (pt "as")(pt "bseq bs")(pt "a")(pt "b") 4)
(inst-with "second" (pt "as")(pt "bseq bs")(pt "a")(pt "b") 4)
(simp 5)
(simp 6)
(use 1)

;allnc as,a.good as -> (all bs.as=bseq bs -> F) -> all bs.(as::a)=bseq bs -> F 
(assume "as" "a" 1 2)
(ind)
; bs=[]
(ng)
(search)

; bs::b
(assume "bs" "b" 2)
(ng)

(cases (pt "(ll(bseq bs)b)"))

(assume 4)
(simp 4)
(ng)
(use 3)

; not ll(bseq bs)b.

(assume 4)
(simp 4)
(ng)
(strip)

(inst-with "first" (pt "as")(pt "bseq bs")(pt "a")(pt "b") 5)
(inst-with "second" (pt "as")(pt "bseq bs")(pt "a")(pt "b") 5)
(drop 5)
(use 2 (pt "bs"))
(simp 6)
(ng)
(use "Truth-Axiom")
; Proof finished.
(save "Aux4b")



(set-goal (pf "all as. good as -> all bs .as=bseq bs -> F"))
(cases)
(strip)
(use "Aux4a" (pt "(Lin nat)"))
(use 1)
(ng)
(use "Truth-Axiom")
(use "Aux4b")
(save "Aux4c")


(set-goal (pf "all as,ws . good as -> bseq (lasts ws)=as -> F"))
(strip)
(use "Aux4c" (pt "as")(pt "lasts ws"))
(use 1)
(simp 2)
(ng)
(use "Truth-Axiom")
