/*======================================================================*\
|*		Editor mined						*|
|*		CJK character set <-> Unicode mapping tables		*|
\*======================================================================*/

#include "mined.h"
#include "charmaps.h"


#ifdef use_cjk_tables

static unsigned int jis2 [] = 
	{0x309A, 0x0300, 0x0301, 0x02E5, 0x02E9};

/**
   Current CJK encoding indication and flag
 */
char cjk_encoding = '-';
char * cjk_encoding_flag = "??";

/**
   Current CJK/Unicode mapping table and its length
 */
static struct cjk_table_entry * cjk_table = (struct cjk_table_entry *) 0;
static unsigned int cjk_table_len = 0;

static
void
set_cjk_encoding (tag, flag)
  char tag;
  char * flag;
{
  cjk_encoding = tag;
  cjk_encoding_flag = flag;
}

void
set_cjk_table (tag)
  char tag;
{
  mapped_text = False;
  switch (tag) {
	case 'B':
		set_cjk_encoding ('B', "B5");
		cjk_table = big5_table;
		cjk_table_len = big5_table_len;
		return;
	case 'G':
		set_cjk_encoding ('G', "GB");
		cjk_table = gb_table;
		cjk_table_len = gb_table_len;
		return;
	case 'C':
		set_cjk_encoding ('C', "CN");
		cjk_table = cns_table;
		cjk_table_len = cns_table_len;
		return;
	case 'J':
		set_cjk_encoding ('J', "JP");
		cjk_table = ejis_table;
		cjk_table_len = ejis_table_len;
		return;
	case 'S':
		set_cjk_encoding ('S', "sJ");
		cjk_table = sjis_table;
		cjk_table_len = sjis_table_len;
		return;
	case 'K':
		set_cjk_encoding ('K', "KR");
		cjk_table = uhc_table;
		cjk_table_len = uhc_table_len;
		return;
	case 'H':
		set_cjk_encoding ('H', "Jh");
		cjk_table = johb_table;
		cjk_table_len = johb_table_len;
		return;
	case 'V':
		set_cjk_encoding ('V', "VI");
		cjk_table = viscii_table;
		cjk_table_len = viscii_table_len;
		mapped_text = True;
		return;
  }
}

#ifdef split_map_entries
/*
   Decode CJK character value from split table entry.
 */
static
unsigned int
decode_cjk (entrypoi)
  struct cjk_table_entry * entrypoi;
{
  if (cjk_encoding == 'G') {
	if ((unsigned int) entrypoi->cjk_ext == 0xFF) {
		return entrypoi->cjk_base;
	} else {
		return ((entrypoi->cjk_base & 0x00FF) << 24)
			| (entrypoi->cjk_base & 0xFF00)
			| 0x00300030
			| ((((unsigned int) entrypoi->cjk_ext) & 0xF0) << 12)
			| (((unsigned int) entrypoi->cjk_ext) & 0x0F);
	}
  } else {
	if ((unsigned int) entrypoi->cjk_ext >= 0x90) {
		return 0x8E000000 | (((unsigned int) entrypoi->cjk_ext) << 16) | entrypoi->cjk_base;
	} else {
		return (((unsigned int) entrypoi->cjk_ext) << 16) | entrypoi->cjk_base;
	}
  }
}
#endif

/*
   Look up a Unicode value in a character set mapping table.
   @return CJK value, or -1 if not found
 */
unsigned long
unmap_char (unichar)
  unsigned long unichar;
{
#ifdef split_map_entries
	unsigned char unichar_high = unichar >> 16;
	unsigned short unichar_low = unichar & 0xFFFF;
#endif
	unsigned int i = 0;

	struct cjk_table_entry * cjk_table_poi = cjk_table;
	while (i ++ < cjk_table_len) {
#ifdef split_map_entries
		if (
		    unichar_low == cjk_table_poi->unicode_low
		 && unichar_high == cjk_table_poi->unicode_high
		   ) {
			return decode_cjk (cjk_table_poi);
		}
#else
		if (
		    unichar == cjk_table_poi->unicode
		   ) {
			return cjk_table_poi->cjk;
		}
#endif
		cjk_table_poi ++;
	}
	return -1;
}

/*
   Map a character in a character set mapping table.
   @return Unicode value, or -1 if not found
 */
unsigned int
map_char (cjk)
  unsigned int cjk;
{
	int low = 0;
	int high = cjk_table_len - 1;
	int i;

	unsigned int cjki;

	while (low <= high) {
		i = (low + high) / 2;
#ifdef split_map_entries
		cjki = decode_cjk (& cjk_table [i]);
#else
		cjki = cjk_table [i].cjk;
#endif
		if (cjki == cjk) {
#ifdef split_map_entries
			if ((cjk_encoding == 'J' || cjk_encoding == 'S')
			 && (cjk_table [i].unicode_high & 0x80)
			   ) {
				return 0x80000000 | (jis2 [cjk_table [i].unicode_high & 0x7F] << 16) | (cjk_table [i].unicode_low);
			} else {
				return (((unsigned int) cjk_table [i].unicode_high) << 16) | (cjk_table [i].unicode_low);
			}
#else
			if ((cjk_encoding == 'J' || cjk_encoding == 'S')
			 && (cjk_table [i].unicode & 0x800000)
			   ) {
				return 0x80000000 | (jis2 [(cjk_table [i].unicode >> 16) & 0x7F] << 16) | (cjk_table [i].unicode & 0xFFFF);
			} else {
				return cjk_table [i].unicode;
			}
#endif
		} else if (cjki >= cjk) {
			high = i - 1;
		} else {
			low = i + 1;
		}
	}
	return -1;
}

#else

char cjk_encoding = '-';
char * cjk_encoding_flag = "--";

void
set_cjk_table (tag)
  char tag;
{
}

unsigned long
unmap_char (unichar)
  unsigned long unichar;
{
	return -1;
}

unsigned int
map_char (cjk)
  unsigned int cjk;
{
	return -1;
}

#endif


/*======================================================================*\
|*				End					*|
\*======================================================================*/
