/*
 Copyright (C) 2007 Christian Dywan <christian@twotoasts.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

#ifndef __UI_H__
#define __UI_H__ 1

// -- Credits

static const gchar* credits_authors[] = { "Christian Dywan <christian@twotoasts.de>", NULL };
static const gchar* credits_documenters/*[]*/ = /*{ */NULL/* }*/;
static const gchar* credits_artists[] = { "Nancy Runge <nancy@twotoasts.de>", NULL };

// -- Licenses

static const gchar* license =
 "This library is free software; you can redistribute it and/or\n"
 "modify it under the terms of the GNU Lesser General Public\n"
 "License as published by the Free Software Foundation; either\n"
 "version 2.1 of the License, or (at your option) any later version.\n";

// -- User interface description

static const gchar* ui_markup =
 "<ui>"
  "<menubar>"
   "<menu action='File'>"
    "<menuitem action='WindowNew'/>"
    "<menuitem action='TabNew'/>"
    "<separator/>"
    "<menuitem action='Open'/>"
    "<separator/>"
    "<menuitem action='SaveAs'/>"
    "<separator/>"
    "<menuitem action='TabClose'/>"
    "<menuitem action='WindowClose'/>"
    "<separator/>"
    "<menuitem action='PageSetup'/>"
    "<menuitem action='PrintPreview'/>"
    "<menuitem action='Print'/>"
    "<separator/>"
    "<menuitem action='PrivateBrowsing'/>"
    "<menuitem action='WorkOffline'/>"
    "<separator/>"
    "<menuitem action='Quit'/>"
   "</menu>"
   "<menu action='Edit'>"
    "<menuitem action='Undo'/>"
    "<menuitem action='Redo'/>"
    "<separator/>"
    "<menuitem action='Cut'/>"
    "<menuitem action='Copy'/>"
    "<menuitem action='Paste'/>"
    "<menuitem action='Delete'/>"
    "<separator/>"
    "<menuitem action='SelectAll'/>"
    "<separator/>"
    "<menuitem action='ManageSearchEngines'/>"
    "<menuitem action='Preferences'/>"
   "</menu>"
   "<menu action='View'>"
    "<menu action='Toolbars'>"
     "<menuitem action='ToolbarNavigation'/>"
     "<menuitem action='ToolbarBookmarks'/>"
     "<menuitem action='ToolbarDownloads'/>"
     "<menuitem action='ToolbarStatus'/>"
    "</menu>"
    "<menuitem action='Panels'/>"
    "<separator/>"
    "<menuitem action='Refresh'/>"
    "<menuitem action='Stop'/>"
    "<menu action='RefreshEvery'>"
     "<menuitem action='RefreshEveryEnable'/>"
     "<separator/>"
     "<menuitem action='RefreshEvery30'/>"
     "<menuitem action='RefreshEvery60'/>"
     "<menuitem action='RefreshEvery300'/>"
     "<menuitem action='RefreshEvery900'/>"
     "<menuitem action='RefreshEvery1800'/>"
     "<menuitem action='RefreshEveryCustom'/>"
    "</menu>"
    "<separator/>"
    "<menuitem action='ZoomIn'/>"
    "<menuitem action='ZoomOut'/>"
    "<menuitem action='ZoomNormal'/>"
    "<separator/>"
    "<menuitem action='BackgroundImage'/>"
    "<menuitem action='SourceView'/>"
    "<menuitem action='Properties'/>"
   "</menu>"
   "<menu action='Go'>"
    "<menuitem action='Back'/>"
    "<menuitem action='Forward'/>"
    "<menuitem action='Home'/>"
    "<menuitem action='Location'/>"
    "<menuitem action='Websearch'/>"
    "<menuitem action='OpenInPageholder'/>"
    "<menu action='TabsClosed'>"
    // Closed tabs shall be prepended here
     "<separator/>"
     "<menuitem action='TabsClosedClear'/>"
    "</menu>"
    "<separator/>"
    "<menuitem action='Find'/>"
    "<menuitem action='FindNext'/>"
    "<menuitem action='FindPrevious'/>"
    "<separator/>"
    "<menuitem action='FormFill'/>"
   "</menu>"
   "<menu action='Bookmarks'>"
    "<menuitem action='BookmarkNew'/>"
    "<menuitem action='BookmarksManage'/>"
    "<separator/>"
    // Bookmarks shall be appended here
   "</menu>"
   "<menu action='Tools'>"
    "<menuitem action='PanelDownloads'/>"
    "<menuitem action='PanelBookmarks'/>"
    "<menuitem action='PanelHistory'/>"
    "<menuitem action='PanelTabs'/>"
    "<menuitem action='PanelPageholder'/>"
    "<menuitem action='PanelExtensions'/>"
    "<menuitem action='PanelConsole'/>"
    "<separator/>"
    // TODO: Insert widgets and custom tools here
   "</menu>"
   "<menu action='Window'>"
    "<menuitem action='SessionLoad'/>"
    "<menuitem action='SessionSave'/>"
    "<separator/>"
    "<menuitem action='TabPrevious'/>"
    "<menuitem action='TabNext'/>"
    "<menuitem action='TabOverview'/>"
    "<separator/>"
    // All open tabs shall be appended here
   "</menu>"
   "<menu action='Help'>"
    "<menuitem action='HelpContents'/>"
    "<menuitem action='About'/>"
   "</menu>"
  "</menubar>"
  "<toolbar name='toolbar_navigation'>"
   "<toolitem action='TabNew'/>"
   "<toolitem action='Back'/>"
   "<toolitem action='Forward'/>"
   "<toolitem action='RefreshStop'/>"
   "<toolitem action='Home'/>"
   "<toolitem action='FormFill'/>"
   "<placeholder name='Location'/>"
   "<placeholder name='WebSearch'/>"
   "<placeholder name='TabTrash'/>"
  "</toolbar>"
  "<toolbar name='toolbar_panels'>"
   "<toolitem action='PanelDownloads'/>"
   "<toolitem action='PanelBookmarks'/>"
   "<toolitem action='PanelHistory'/>"
   "<toolitem action='PanelTabs'/>"
   "<toolitem action='PanelPageholder'/>"
   "<toolitem action='PanelExtensions'/>"
   "<toolitem action='PanelConsole'/>"
  "</toolbar>"
  "<toolbar name='toolbar_bookmarks'>"
   "<toolitem action='BookmarkNew'/>"
   "<toolitem action='BookmarkEdit'/>"
   "<toolitem action='BookmarkDelete'/>"
  "</toolbar>"
  "<popup name='popup_bookmark'>"
   "<menuitem action='BookmarkOpen'/>"
   "<menuitem action='BookmarkOpenTab'/>"
   "<menuitem action='BookmarkOpenWindow'/>"
   "<separator/>"
   "<menuitem action='BookmarkEdit'/>"
   "<menuitem action='BookmarkDelete'/>"
  "</popup>"
  "<popup name='popup_webView'>"
   "<menuitem action='Back'/>"
   "<menuitem action='Forward'/>"
   "<menuitem action='Refresh'/>"
   "<menuitem action='Stop'/>"
   "<menu action='RefreshEvery'>"
    "<menuitem action='RefreshEveryEnable'/>"
    "<separator/>"
    "<menuitem action='RefreshEvery30'/>"
    "<menuitem action='RefreshEvery60'/>"
    "<menuitem action='RefreshEvery300'/>"
    "<menuitem action='RefreshEvery900'/>"
    "<menuitem action='RefreshEvery1800'/>"
    "<menuitem action='RefreshEveryCustom'/>"
   "</menu>"
   "<separator/>"
   "<menuitem action='SelectionLinksNewTabs'/>"
   "<menuitem action='SelectionTextTabNew'/>"
   "<menuitem action='SelectionTextTabCurrent'/>"
   "<menuitem action='SelectionTextWindowNew'/>"
   "<separator/>"
   "<menuitem action='UndoTabClose'/>"
   "<menuitem action='SaveAs'/>"
   "<menuitem action='BookmarkNew'/>"
   "<menuitem action='Print'/>"
   "<separator/>"
   "<menuitem action='SelectAll'/>"
   "<separator/>"
   "<menuitem action='BackgroundImage'/>"
   "<menuitem action='SourceView'/>"
   "<menuitem action='Properties'/>"
  "</popup>"
  "<popup name='popup_element'>"
   "<menuitem action='LinkTabNew'/>"
   "<menuitem action='LinkTabCurrent'/>"
   "<menuitem action='LinkWindowNew'/>"
   "<separator/>"
   "<menuitem action='LinkSaveAs'/>"
   "<menuitem action='LinkSaveWith'/>"
   "<menuitem action='LinkCopy'/>"
   "<menuitem action='LinkBookmarkNew'/>"
   "<separator/>"
   "<menuitem action='SelectionLinksNewTabs'/>"
   "<menuitem action='SelectionTextTabNew'/>"
   "<menuitem action='SelectionTextTabCurrent'/>"
   "<menuitem action='SelectionTextWindowNew'/>"
   "<separator/>"
   "<menuitem action='ImageViewTabNew'/>"
   "<menuitem action='ImageViewTabCurrent'/>"
   "<menuitem action='ImageSaveAs'/>"
   "<menuitem action='ImageSaveWith'/>"
   "<menuitem action='ImageCopy'/>"
   "<separator/>"
   "<menuitem action='ImageViewTabNew'/>"
   "<menuitem action='ImageViewTabCurrent'/>"
   "<separator/>"
   "<menuitem action='Copy_'/>"
   "<menuitem action='SelectionSearch'/>"
   "<menuitem action='SelectionSearchWith'/>"
   "<menuitem action='SelectionSourceView'/>"
   "<separator/>"
   "<menuitem action='Properties'/>"
  "</popup>"
  "<popup name='popup_editable'>"
   "<menuitem action='Undo'/>"
   "<menuitem action='Redo'/>"
   "<separator/>"
   "<menuitem action='Cut'/>"
   "<menuitem action='Copy'/>"
   "<menuitem action='Paste'/>"
   "<menuitem action='Delete'/>"
   "<separator/>"
   "<menuitem action='SelectAll'/>"
  "</popup>"
 "</ui>";

#endif /* !__UI_H__ */
