#ifndef SETTINGS_H
#define SETTINGS_H

/* url for web interface */
#define INTERFACEURL "mman"

/* maximum listening ports allowed */
#define MAXLISTENPORTS 20

/* maximum threads (thus, maximum connections) */
#define MAXTHREADS 1024

/* file mask for mkstemp */
#define TEMPMASK "mmanXXXXXX"

/* time in seconds to hold dns results in cache before purging */
#define DNS_EXPIRE 360

/* size of hashtable for cached dns results */
#define DNS_HASH_SIZE 8111

/* thread stack size */
#define STACKSIZE 65536

/* flags for regcomp */
#define REGFLAGS REG_EXTENDED | REG_ICASE | REG_NOSUB

/* flags for pcre_compile */
#define PCREFLAGS PCRE_CASELESS | PCRE_DOTALL | PCRE_MULTILINE | PCRE_EXTENDED

/* format of log timestamps, see strftime manpage for help */
#define TIMEFORMAT "%a %d %H:%M:%S"

/* format of time in HTTP headers (i.e. "Thu, 01 Dec 1994 16:00:00 GMT") */
#define HTTPTIMEFORMAT "%a, %d %b %Y %T GMT"

/* time formats in cookie headers */
#define COOKIETIMEFORMAT "%a, %d-%b-%Y %H:%M:%S GMT"
/* some idiotic websites send the year without the century */
#define COOKIETIMEFORMAT2 "%a, %d-%b-%y %H:%M:%S GMT"

/* maximum substrings for regexp's with backreferences (rewrite rules) */
#define PCRE_MAX_SUBSTRING 16

/* filebuf size will always be aligned to a multiple of this number, must be a power of 2.
   this reduces overhead due to excessive realloc'ing */
#define FILEBUF_ALIGNMENT 65536

/* same as above, except for cache files */
#define CACHE_ALIGNMENT 65536

/* size of blocks to read/write at once */
#define BLOCKSIZE 8096

/* default number of log entries to keep in memory for web interface */
#define LOGBUFFERSIZE 1000

/* mask of log entry types to _NOT_ show on the web interface */
#define LOGMASK MMLOG_DEBUG

/* the number of lines after a changed area that must match before considering it the end of the changed area 
   when displaying the changes made by rewrite rules to a file */
#define DIFF_HUNK 3

/* default HTTP port */
#define HTTP_PORT 80

/* default HTTPS port */
#define HTTPS_PORT 443

/* default FTP port */
#define FTP_PORT 21

/* cache hash table size */
#define CACHEMAP_HASH_SIZE 19997

/* htmlstream callback hash table size */
#define HSTREAM_HASH_SIZE 16

/* default anonymous ftp login */
#define ANONLOGIN "anonymous"

/* default anonymous ftp password */
#define ANONPASS "noone@nowhere.com"

/* maximum level of nesting in HTML parser */
#define HTML_NESTING_LIMIT 64

/* the User-Agent string when prefetching */
#define PREFETCH_USERAGENT "Mozilla/4.0 (compatible; MSIE 5.5; Windows 98; Win 9x 4.90)"

/* minimum interval between cache evictions */
#define CLEAN_INTERVAL 30

/* the number of cache journal entries before the journal file is rewritten */
#define JOURNAL_SIZE 128000

/* the fraction of the delta between the oldest and newest cache file the threshold is 
   incremented by on each pass when evicting the cache */
#define CACHE_INCREMENT_FRACTION 16

/* encoding types the proxy can accept */
#define ACCEPTED_ENCODINGS "gzip, deflate"

/* thread timeout when awaiting another connection to handle */
#define THREAD_TIMEOUT 10

/* maximum number of proxies to send ICP queries to at a time */
#define ICP_PEERS_MAX 100

#endif				/* SETTINGS_H */
