#ifndef COMPAT_H
#define COMPAT_H

#ifndef HAVE_PTHREAD_RWLOCK_INIT
/* pthread rwlock's aren't very portable, these will replace them with a slower alternative */
#define pthread_rwlock_t pthread_mutex_t
#define pthread_rwlock_init pthread_mutex_init
#define pthread_rwlock_destroy pthread_mutex_destroy
#define pthread_rwlock_rdlock pthread_mutex_lock
#define pthread_rwlock_wrlock pthread_mutex_lock
#define pthread_rwlock_unlock pthread_mutex_unlock
#endif /* HAVE_PTHREAD_RWLOCK_INIT */

#ifndef O_SYNC
#define O_SYNC O_FSYNC
#endif /* O_SYNC */

#ifndef HAVE_POLL

struct pollfd {
	int fd;
	short events;
	short revents;
};

#define POLLIN         0x0001
#define POLLNORM       POLLIN
#define POLLPRI                POLLIN
#define POLLOUT                0x0008
#define POLLERR                0x0010
#define POLLHUP                0x0020
#define POLLNVAL       0x0040
#define POLLRDNORM     POLLIN
#define POLLRDBAND     POLLIN
#define POLLWRNORM     POLLOUT
#define POLLWRBAND     POLLOUT
#define POLLMSG                0x0800

#define __INVALIDPOLL  ~(POLLIN | POLLOUT)

#endif				/* HAVE_POLL */

#endif				/* COMPAT_H */
