/***************************** LICENSE START ***********************************

 Copyright 2016 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <iostream>

#include "NcExaminer.h"
#include "Metview.h"
#include "MvQService.h"
#include "MvQServiceApplication.h"

using namespace std;

// Globals
int ac;
char** av;

class Base : public MvQService
{
protected:
    Base(char* a) :
        MvQService(a){};
};

class MvNcExaminer : public Base
{
public:
    MvNcExaminer(char* a) :
        Base(a){};
    void serve(MvRequest&, MvRequest&);
};

void MvNcExaminer::serve(MvRequest& in, MvRequest&)
{
    cout << "--------------NcExaminer::serve()--------------" << endl;
    in.print();

    //Create the qt application
    MvQServiceApplication app(ac, av);

    //Initialise resorces from a static library (libMvQtGui)
    Q_INIT_RESOURCE(examiner);
    Q_INIT_RESOURCE(keyDialog);
    Q_INIT_RESOURCE(window);
    Q_INIT_RESOURCE(find);

    // Get Netcdf file name
    const char* ncName = in("PATH");  //get Netcdf file name

    //Create the netcdf browser, initialize it and show it
    NcExaminer* browser = new NcExaminer;
    browser->setAppIcon("NETCDF");
    browser->initMetaData(ncName);
    browser->show();

    //Listen to the mars event loop!
    setupSocketNotifier();

    // Send message to Desktop (but not to MvExamineManager)
    // to turn the icon green; otherwise, it will stay orange.
    if (strcmp(getenv("METVIEW_MODE"), "examine") != 0) {
        acknowledgeGuiStartup();
    }

    //Enter the app loop
    app.exec();
}

int main(int argc, char** argv)
{
    ac = argc;
    av = argv;

    MvApplication theApp(argc, argv);

    MvNcExaminer nc1("NETCDF");
    MvNcExaminer nc2("SCM_INPUT_DATA");
    MvNcExaminer nc3("SCM_OUTPUT_DATA");
    MvNcExaminer nc4("NETCDF_RTTOV_INPUT");

    theApp.run();
}
