/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//=============================================================================

#ifndef CBUFR_H__
#define CBUFR_H__


#include "Cached.h"
#include "MvGeoPoints.h"


class CBufr  : public InPool {
	request *r;
	virtual void ToRequest(request* &);
	virtual int  Write(FILE*);
	virtual void ToBufr(CBufr* &x)  { x = this; }
public:
	CBufr(request  *r);
	CBufr(const char *name,int temp = 0);
	~CBufr();

	const char *GetFileName();
};

class CGeopts  : public InPool
{

	MvGeoPoints gpts;

	request *r;
	virtual void ToRequest(request* &);
	virtual void ToGeopts(CGeopts*   &x) { x = this; }
	virtual int  Write(FILE*);

public:

	void load(void);
	void unload(void);
	void sort(){ gpts.sort(); }
	void removeDuplicates(){ gpts.removeDuplicates(); }
	void offset( double dlat, double dlon ){ gpts.offset( dlat, dlon ); }

	void SetSize(int n)        { gpts.count( n );    }
	long Count(void)           { return gpts.count();}
	long indexOfFirstValidPoint(void) {return gpts.indexOfFirstValidPoint();}
	MvGeoP1& operator[](long n){ return gpts[ n ];   }
	void SetFormat( eGeoFormat f ){ gpts.format( f );   }
	eGeoFormat Format(void)    { return gpts.format();  }
	const char *GetFileName();

	MvGeoPoints::metadata_t &metadata()            {return gpts.metadata();}
	MvGeoPoints::metadata_t const &metadataConst() {return gpts.metadataConst();}
	bool const doesMetadataMatch(const request *r);

	string dbSystem() 	   { return gpts.dbSystem();}
	string dbPath() 	   { return gpts.dbPath();}
	string dbColumn(string c)  { return gpts.dbColumn(c);}
	string dbColumnAlias(string c)  { return gpts.dbColumnAlias(c);}
	const vector<string>&  dbQuery() { return gpts.dbQuery();}

	CGeopts(request  *r);
	CGeopts(long count);
	CGeopts(CGeopts *);
	CGeopts(fieldset*,int);
	CGeopts(CGeopts *,fieldset*,int, bool nearest=false);
	CGeopts(const char *name,int temp = 0);
	CGeopts(MvGeoPoints &gptsIn);
	~CGeopts();
};

#endif // CBUFR_H__
