/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQPalette_H
#define MvQPalette_H

#include <QColor>
#include <QRectF>

#include <string>
#include <vector>
#include <map>

using std::string;

class QPainter;
struct request;

class PaletteScanner {
public:
	virtual void next(const string&,QColor,bool) = 0;
};

struct MvQPaletteItem
{
    MvQPaletteItem() {}
	MvQPaletteItem(const std::string& name,QColor col,bool pseudo) : name_(name),col_(col),pseudo_(pseudo) {}
  	std::string name_;
	QColor col_;
	bool pseudo_;
};	

class MvQPalette 
{
public:
	MvQPalette(int);
	~MvQPalette();

	static  string toString(QColor);
    static  QString toRgbString(QColor);
    static  QString toHslString(QColor);
    static  QString toStringAsList(QList<QColor> colLst);
    static  QList<QColor> toColourList(QString txt);
	static  QColor magics(const string&); 

	static void scan(PaletteScanner&);
	static void load(request*);
	static bool isPseudo(const std::string& name);    
    static void toHclF(QColor c,float& hue, float& chroma,float& luminance);
    static QColor fromHclF(float hue, float chroma,float luminance);
    static void paintAlphaBg(QPainter* painter,QRect area);

protected:	
	static QColor hexaCharToColour(const char *);

private:
    MvQPalette(const MvQPalette&);
	MvQPalette& operator=(const MvQPalette&);
	
	static std::vector<string> names_;
	static std::vector<std::string> pseudoColourNames_;
	static std::map<string,MvQPaletteItem> items_;
};

#endif
