/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef InternalTask_H
#define InternalTask_H

#include "Task.h"
#include "Action.h"
#include "ReplyObserver.h"
#include "TaskObserver.h"
#include "IconObject.h"
#include "Dependancy.h"

class InternalTask : public TaskObserver, public Task 
{
public:
	InternalTask(const Action&,IconObject*);
	virtual ~InternalTask(); 
	
	virtual void addContext (const Request&) { };

protected:
	 void print(ostream&) const; 
	 
private:
	// No copy allowed
	InternalTask(const InternalTask&);
	InternalTask& operator=(const InternalTask&);

	void check();
	virtual void start();
	virtual void success(Task*,const Request&);
	virtual void failure(Task*,const Request&);
		
	Action      action_;
	IconObjectH object_;
	bool        error_;
	int         waiting_;

	typedef map<TaskH,DependancyH> Map;
	Map tasks_;
};

inline void destroy(InternalTask**) {}

#endif
