/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQKeyProfileModel_H
#define MvQKeyProfileModel_H

#include <QAbstractItemModel>
#include <QList>
#include <QPair>
#include <QSortFilterProxyModel>
#include <QStringList>

class GribMetaData;

#include "MvKeyProfile.h"

typedef QMap<QString, QStringList> MvQKeyFilter;

class MvQKeyProfileSortFilterModel : public QSortFilterProxyModel
{
public:
    MvQKeyProfileSortFilterModel(QObject* parent = 0);
    void setColumnFilter(QStringList);
    void setColumnFilter(QList<int>);
    //bool hasColumnFilter() const;

protected:
    enum FilterMode
    {
        StringFilter,
        PositionFilter
    };
    //bool lessThan ( const QModelIndex &, const QModelIndex &) const;
    bool filterAcceptsColumn(int source_column, const QModelIndex& source_parent) const;

    FilterMode filterMode_;
    QStringList filterStr_;
    QList<int> filterPos_;
};

class MvQKeyProfileModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    MvQKeyProfileModel(QObject* parent);
    ~MvQKeyProfileModel();

    enum CustomItemRole
    {
        SortRole  = Qt::UserRole + 1,
        ErrorRole = Qt::UserRole + 2
    };

    int columnCount(const QModelIndex& parent = QModelIndex()) const;
    int rowCount(const QModelIndex& parent = QModelIndex()) const;

    virtual QVariant data(const QModelIndex&, int role = Qt::DisplayRole) const;
    QVariant headerData(int, Qt::Orientation, int role = Qt::DisplayRole) const;

    QModelIndex index(int, int, const QModelIndex& parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex&) const;

    void keyProfileIsAboutToChange();
    void keyProfileChangeFinished();

    MvKeyProfile* keyProfile() const { return profile_; }
    void setKeyProfile(MvKeyProfile*);
    void reloadKeyProfile();
    virtual void clear();

    MvQKeyFilter keyFilter() const { return filter_; }
    void setKeyFilter(MvQKeyFilter);

    Qt::ItemFlags flags(const QModelIndex&) const;
    Qt::DropActions supportedDropActions() const;
    QStringList mimeTypes() const;
    QMimeData* mimeData(const QModelIndexList&) const;
    bool dropMimeData(const QMimeData* data,
                      Qt::DropAction action, int row, int column,
                      const QModelIndex& parent);
    void setShadeFirstColumn(bool b) { shadeFirstColumn_ = b; }

signals:
    void keysInserted(QList<MvKey*>, int);

protected:
    QString label(const int, const int) const;
    bool isPossibleStringKey(const std::string& name) const;
    void loadKeyFilter();

    bool isDataSet() const;
    MvKeyProfile* profile_;
    MvQKeyFilter filter_;
    QList<bool> messageFilterStatus_;
    bool shadeFirstColumn_;
    QStringList possibleStringKeys_;
};

#endif
