/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQFILELISTMODEL_H
#define MVQFILELISTMODEL_H

#include <QAbstractItemModel>

class MvQFileList;

class MvQFileListModel : public QAbstractItemModel
{
    Q_OBJECT

public:
    MvQFileListModel(QObject* parent = 0);

    virtual int columnCount(const QModelIndex& parent = QModelIndex()) const;
    virtual int rowCount(const QModelIndex& parent = QModelIndex()) const;

    virtual QVariant data(const QModelIndex&, int role = Qt::DisplayRole) const;
    virtual QVariant headerData(int, Qt::Orientation, int role = Qt::DisplayRole) const;

    QModelIndex index(int, int, const QModelIndex& parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex&) const;
    Qt::ItemFlags flags(const QModelIndex&) const;

    void setFileList(MvQFileList*);

    QString indexToPath(const QModelIndex&) const;
    QModelIndex pathToIndex(QString) const;

public slots:
    void slotDataAddRemoveBegin();
    void slotDataAddRemoveEnd();

protected:
    MvQFileList* data_;
};

#endif  // MVQFILELISTMODEL_H
