/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Family_H
#include "Family.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef Language_H
#include "Language.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#include "FamilyHelper.h"

Family::Family(Folder* parent,const IconClass& kind,
	const string& name,IconInfo* info):
	Basic(parent,kind,name,info) ,
	helper_(FamilyHelper::find(kind))
{
}

Family::~Family()
{
}

Request Family::request() const
{
	return language().expand(second());
}

void Family::request(const Request& r)
{
	Request f = first();
	f(helper_.keyword().c_str()) = r.getVerb();

	f = f + language().expand(r,EXPAND_NO_DEFAULT|EXPAND_2ND_NAME);

	f.save(path());

}

Request Family::first() const
{
	 Request r(path());               
	 return iconClass().language().expand(r.justOneRequest());    
}

Request Family::second() const
{
	 Request r(path());               
	 if(helper_.validate(r))
	 	r.save(path());
	 r.advance();
	 return r;
}

const IconClass& Family::editorClass() const
{
	return class_;
}

const IconClass& Family::iconClass() const
{
	return IconClass::find(second().getVerb()); 
}

static IconMaker<Family> maker("Family");
