/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// MvThermoParams.h - Nov2003/vk  - original file
// ParamsThermo.h   - Jan2014/fii - updated to the new Thermo application

#ifndef THERMOPARAM_H
#define THERMOPARAM_H

#include <string>

using namespace std;

enum EPointType { eAreaAverage, eGridPoint, eInterpolated };

struct ThermoParams
{
   string      dewPointFormulaType_;
   string      errorMsg_;
   int         uFieldId_;
   int         vFieldId_;
   int         tempId_;
   int         dewId_;
   int         lnPressId_;
   double      lat_;
   double      lon_;
   double      lat2_;
   double      lon2_;
   EPointType  pointType_;
};

#endif
