/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File MacroParamState.h
// Baudouin Raoult - ECMWF Jun 00

#ifndef MacroParamState_H
#define MacroParamState_H

#include "Request.h"

#ifndef IconObject_H
#include "IconObject.h"
#endif


class MacroParamState : public Counted {
public:

// -- Exceptions
	// None

// -- Contructors

	MacroParamState(IconObject*,IconObject*,const Request&);

// -- Destructor

	~MacroParamState(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	const IconClass& iconClass();
	IconObject* iconObject();

	IconObject* macro() const;
	void macro(IconObject*);

	Request request() const;
	void request(const Request&);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	MacroParamState(const MacroParamState&);
	MacroParamState& operator=(const MacroParamState&);

// -- Members
	
	IconObjectH owner_;
	IconObjectH temp_;
	IconObjectH macro_;
	Request     request_;
	IconClass*  class_;

// -- Methods

	Request requests() const;
	Request interface() const;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const MacroParamState& p)
	//	{ p.print(s); return s; }

};

class MacroParamStateH : public  Handle<MacroParamState> {
public:
	MacroParamStateH(MacroParamState* o = 0) : Handle<MacroParamState>(o) {}
};

#endif
