/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  CartesianView
//
// .AUTHOR:
//  Fernando Ii, Sylvie Thepaut
//
// .SUMMARY:
//  Describes the CartesianView class
//
// .CLIENTS:
//  Page
//
// .RESPONSIBILITY:
//
// .COLLABORATORS:
//
// .ASCENDENT:
//  PlotModView, PlotModTable
//
// .DESCENDENT:
//
//
#ifndef CartesianView_H
#define CartesianView_H

#include "MvIconDataBase.h"
#include "PlotModView.h"

class CartesianView;

class CartesianView: public PlotModView
{
   public:

	// Constructor
	CartesianView( Page&, const MvRequest&, const MvRequest&,
			const string &haxisName = "HORIZONTAL_AXIS",
			const string &vaxisName = "VERTICAL_AXIS",
			const string &viewName  = "cartesianview");

	CartesianView(const CartesianView&);
	virtual PlotModView *Clone() const { return new CartesianView(*this); }

	// Destructor
	~CartesianView();

	// Methods overriden from PlotModView class
	virtual string Name();

	// Update view
	virtual void UpdateView ( MvRequest& viewRequest);

	// Replace the current axis ( axis are the background of this view )
	void ReplaceAxis ( MvRequest& axisRequest );

	// Replace the current graph
//	void ReplacePgraph ( MvRequest& pgraphRequest );

	// Replace area
	//void ReplaceArea ( const Location&, int=-1 );

	// Decode the data Unit
	virtual void DecodeDataUnit ( MvIcon& dataUnit );

	// Draw the background (axis )
	virtual void DrawBackground ( ) { };
//	virtual bool EmptyShared() { return false; }

	// Draw the background (axis )
	virtual void DrawForeground ( ) { };

	virtual void Draw (SubPage *);

	// Describe the contents of the view
	virtual void DescribeYourself ( ObjectInfo& description );

	void Drop ( PmContext& context );

	void DescribeAxis ( ObjectInfo& description, MvRequest& axisRequest, const Cached& axisName );

   MvIconList InsertDataRequest ( MvRequest& dropRequest );

	virtual bool BackgroundFromData() const { return true; }  

	// Remove all visdefs when Page::EraseDraw is called. Segments
	// names does not correspond to visdefs in hierarchy
	virtual bool EraseAll() { return true; }

   protected:

     // Update X/Y axes type in the view
     void  UpdateAxisTypeView ( MvRequest& reqData );

	string hAxisName_, vAxisName_, viewName_;
//	AxisInfoMap axisInfoMap_;

//	void UpdateAxisForAll(MvRequest &givenRequest, SubPage *subpage );

//	void HandleAxisData(MvIcon &dataUnit,double,double,double,double);

//	void CheckAxisRequest(MvRequest&,double,double,double,double,bool&,bool&);

//	virtual bool FlipMinMax() { return false; }
//	virtual void CheckMinMax(double&,double&,double&,double&,AxisInfo&,bool&);
//	virtual void FindAxis(MvRequest&, MvIconList&,double,double,double,double);
//	virtual void UpdateAxisInfo();
	const char * CheckDataRequest(MvIcon &dataUnit,MvIconList &vdList);
//	void MergeAxisInfo(MvIcon &, MvRequest&, bool);

   private:
	// No assignment
	CartesianView& operator=(const CartesianView&);

};
#endif
