/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File RequestPanel.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef RequestPanel_H
#define RequestPanel_H

#ifndef Language_H
#include "Language.h"
#endif

#include "UIRequestPanel.h"

class RequestPanelLine;
class RequestPanelItem;
class IconClass;
class IconObject;

class RequestPanel : public UIRequestPanel_c, public LanguageScanner {
public:

// -- Exceptions
	// None

// -- Contructors

	RequestPanel(const IconClass&, Widget, const char* = 0);

// -- Destructor

	virtual ~RequestPanel(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	
	void changed(RequestPanelItem&,bool = true);
	void set(const char*,const string&);
	void clear(const char*);

	void registerObserver(RequestPanelItem*);
	const IconClass& iconClass();
	
	 
   	Widget where();
	Widget main();

   	void scan(); 

	void    apply();
    void    reset(IconObject*);
	void    edit(IconObject*);
	void    close();

	void 	replace(IconObject*);
	void 	merge(IconObject*);

	const Request& request(long = EXPAND_2ND_NAME);
	void  request(const Request&, long = EXPAND_2ND_NAME);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members

	vector<RequestPanelItem*> items_;
	const IconClass&	     class_;
	bool                      apply_;

// -- Methods
	
	typedef void (RequestPanelItem::*Method)();
	void call(Method);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	RequestPanel(const RequestPanel&);
	RequestPanel& operator=(const RequestPanel&);

// -- Members

	map<long,Request> cache_;

// -- Methods

// -- Overridden methods

	// From LanguageScanner

	virtual void next(const Parameter&);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const RequestPanel& p)
	//	{ p.print(s); return s; }

};

inline void destroy(RequestPanel**) {}

template<class T>
class XLEditor : public RequestPanel, public T {
public:
	XLEditor(IconClass& c): 
		RequestPanel(c)
	{
		T::create(main());
		XtManageChild(T::xd_rootwidget());
	}
};

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(RequestPanel);
//#endif

#endif
