/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
//   Methods for the Create Action class
//
#include "CreateAction.h"

#include <Assertions.hpp>
#include "ObjectList.h"
#include "PlotMod.h"
#include "PlotModBuilder.h"
#include "Presentable.h"

//
// This is the exemplar object for the Create Action class
// which is loaded in the prototype map
//
static CreateAction createActionInstance("Create");

PlotModAction& 
CreateAction::Instance()
{
   return createActionInstance;
}

void
CreateAction::Execute ( PmContext& context )
{
   // Build the Tree branch associated with the Request
   // First, find which builder will process the request
   const char* requestName = context.InRequest().getVerb();
   const char* builderName = ObjectList::Find ("request",  requestName, "builder");

   PlotModBuilder& builder = PlotModBuilder::Find ( builderName );

   // Execute the builder (return the tree node which has been created)
   Presentable* superpage = builder.Execute ( context );
   ensure (superpage != 0 );

   // Add output device to Superpage
   MvRequest deviceReq = PlotMod::Instance().OutputFormat()("OUTPUT_DEVICES");
   MvRequest spReq = superpage->Request();
   spReq("_OUTPUT_DEVICES") = deviceReq;
   superpage->SetRequest(spReq);
}
