/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQStringLine.h"

#include "MvQRequestPanelHelp.h"
#include "MvQLineEdit.h"

#include "LineFactory.h"
#include "Parameter.h"
#include "RequestPanel.h"

#include <QDebug>


MvQStringLine::MvQStringLine(RequestPanel& owner,const Parameter& param) :
		   MvQRequestPanelLine(owner,param) 
{
	lineEdit_ = new MvQLineEdit(parentWidget_);
	
	owner_.addWidget(lineEdit_,row_,3);	
	
	connect(lineEdit_,SIGNAL(textEdited(const QString&)),
		this,SLOT(slotTextEdited(const QString&)));
				
	connect(lineEdit_,SIGNAL(textCleared()),
		this,SLOT(slotCleared()));
	
}

void MvQStringLine::refresh(const vector<string>& values)
{
  	string s;
	for(vector<string>::const_iterator j = values.begin(); j != values.end(); ++j)
	{
			if(s.length()) s += "/";
			s += *j;
	}
	
	if(s.empty() || s != lineEdit_->text().toStdString())
	{
	  	if(s + "." != lineEdit_->text().toStdString())
		{
	  		lineEdit_->setText(s.c_str());
			updateHelper();
		}	
	}	
	//changed_ = false;
}

void MvQStringLine::dispatchChange()
{	  
	owner_.set(param_.name(),lineEdit_->text().toStdString());
}	

void MvQStringLine::updateHelper()
{
  	if(!helper_)
		return;
		
	vector<string> vals;
	vals.push_back(lineEdit_->text().toStdString());
	helper_->refresh(vals);		
}  		

void MvQStringLine::slotCleared()
{
 	dispatchChange();
	updateHelper();
}  

void MvQStringLine::slotTextEdited(const QString& /*text*/)
{
  	dispatchChange();
	updateHelper();
}  

void MvQStringLine::slotHelperEdited(const vector<string>& values)
{
	if(values.size() > 0) 
	{
	  	QString s(values[0].c_str());
		lineEdit_->setText(s);
		dispatchChange();
	}
}	

static LineMaker<MvQStringLine> maker1("string");