/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQPalette.h"

#include <ctype.h>

#include "ConfigLoader.h"
#include "Tokenizer.h"

static map<string,QColor> colors;
static vector<string>  names;

void MvQPalette::load(request* r)
{
	const char* fname = get_value(r,"colour_file",0);
	if(!fname) return;

	FILE *f = fopen(fname, "r");

	if (!f) return;

	char line[500];
	char color[80];
	char name[80];

	while(fgets(line,sizeof(line),f))
	{
		char *p = line;
		int  i = 0;

		sscanf(p,"%s ; %s",color,name);
		while(*p && !i)
		{
			
			if(*p == '#')
			{
				color[i++] = *p++;
				while(*p && isxdigit(*p))
					color[i++] = *p++;
				color[i] = 0;
				if(i != 4 && i != 7 && i != 13)
					i = 0;
			}
			p++;
		}
		if(i) 
		{
			names.push_back(name);
			colors[name]=MvQPalette::hexaCharToColour(color);		
		}
	}

	fclose(f);
}


QColor MvQPalette::hexaCharToColour(const char *hexaChar)
{
	if(strlen(hexaChar) == 13)
	{  
    		unsigned int r, g, b;		
		char cval[5];
		
    		strncpy(cval,hexaChar+1,4);
		cval[4]='\0';		
		sscanf(cval,"%x",&r);
		
		strncpy(cval,hexaChar+5,4);
		cval[4]='\0';		
		sscanf(cval,"%x",&g);
		
		strncpy(cval,hexaChar+9,4);
		cval[4]='\0';		
		sscanf(cval,"%x",&b);
		
		return QColor(r/256,g/256,b/256);		
	}
	
	return QColor();
}					
	
	
void MvQPalette::scan(PaletteScanner& p)
{
	for(vector<string>::iterator j = names.begin(); j != names.end(); ++j)
	{
	  	map<string,QColor>::iterator it=colors.find(*j);
		if(it != colors.end())
	  		p.next(*j,it->second);
	}	
}




/*Pixel XPalette::pixel(const string& name)
{
	static map<string,Pixel> cache;
	map<string,Pixel>::iterator j = cache.find(name);

	if(j != cache.end())
		return (*j).second;

	Pixel p = PaletteNamedColor(palette,name.c_str());
	cache[name] = p;
	return p;
}

void XPalette::scan(PaletteScanner& p)
{
	for(vector<string>::iterator j = names.begin(); j != names.end(); ++j)
		p.next(*j);
}

void XPalette::convert(const string& name,RGBColor& c)
{
	map<string,RGBColor>::iterator j = colors.find(name);
	if(j == colors.end())
		magics(name);

	c = colors[name];
}

bool XPalette::exists(const string& name)
{
	return colors.find(name) != colors.end();
}

inline bool same(double a,double b)
{
	return abs(a-b) < 0.001;
}

bool XPalette::convert(const RGBColor& c,string& name)
{
	RGBColor r;
	for(map<string,RGBColor>::iterator j = colors.begin(); j != colors.end(); ++j)
	{
		const RGBColor& r = (*j).second;
		if(same(c.red,r.red) && same(c.green,r.green) && same(c.blue,r.blue))
		{
			name = (*j).first;
			return true;
		}
	}
	return false;
}
*/

string MvQPalette::toString(QColor col)
{
 	for(map<string,QColor>::iterator it = colors.begin(); it != colors.end(); it++)
	{
	  	if(it->second == col)
		  	return it->first;
	}
	
	
  	QString s="RGB(";
    	s+=QString::number(col.redF(),'g',2)+ "," +
       		QString::number(col.greenF(),'g',2)+ "," +
       		QString::number(col.blueF(),'g',2)+ ")";
		
	return s.toStdString();	 
}  

QColor MvQPalette::magics(const string& name)
{
	QColor col;
	
	map<string,QColor>::iterator it = colors.find(name);
	if(it != colors.end())
	{
	  	col=it->second;
	}
	else
	{  	
		Tokenizer parse("(, )");
		vector<string> v;

		parse(name,v);

		// Try rgb, hsl
		if(v.size() == 4)
		{
			double x1 = atof(v[1].c_str());
			double x2 = atof(v[2].c_str());
			double x3 = atof(v[3].c_str());

			switch(v[0][0])
			{
			case 'r':
			case 'R':
				col = QColor::fromRgbF(x1,x2,x3);
				break;

			case 'h':
			case 'H':
				col = QColor::fromHslF(x1,x2,x3); 
				break;
				
			default: 
			  	break;
			}
			
			if(col.isValid())
			{	  	
				colors[name] = col;
			}					
		}
	}
	
		//colors[name] = c;
		//return PaletteRGBColor(palette,&c);
	
	return col;
}

/*
Pixel XPalette::pixel(const RGBColor& c)
{
	return PaletteRGBColor(palette,&c);
}

Pixel XPalette::pixel(const HSLColor& c)
{
	return PaletteHSLColor(palette,&c);
}

void XPalette::convert(const RGBColor& a,HSLColor& b)
{
	PaletteRGBToHSL(palette,&a,&b);
}

void XPalette::convert(const HSLColor& a,RGBColor& b)
{
	PaletteHSLToRGB(palette,&a,&b);
}

*/

static SimpleLoader<MvQPalette> load("resources",0);
