/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#ifndef MvQColourHelp_H
#define MvQColourHelp_H

#include "MvQPalette.h"
#include "MvQRequestPanelHelp.h"
#include "Parameter.h"

#include <QPen>
#include <QWidget>

class QLabel;
class QLineEdit;
class QPushButton;
class QSpinBox;
class QTabWidget;

class  RequestPanel;

class MvQColourGrid :  public QWidget, public PaletteScanner
{
Q_OBJECT  
  
public:
      MvQColourGrid(QWidget *parent=0);	
      void next(const string&,QColor);

signals:
      void selected(QColor);
  
  
protected:
      void paintEvent(QPaintEvent *event);
      void resizeEvent (QResizeEvent * event );
      void mousePressEvent(QMouseEvent *event);
      void mouseMoveEvent(QMouseEvent *event);
      void createGrid();
      int index(QPoint);
	
      QList<string> names_;
      QList<QColor> cols_;
      int gridSize_;
      int cellSize_;
      int cellsPerRow_;
      QPixmap pix_;
};


class MvQColourWheel :  public QWidget
{
Q_OBJECT

public: 	
  	MvQColourWheel(QWidget *parent=0);
 	void initColour(QColor);
 
public slots:	
	void slotSetColour(int,int,int);

signals:
    	void colourSelected(QColor colour);
	void hslSelected(int,int,int);

protected:
    	enum DragType {NoDrag,RingDrag,TriangleDrag};
	
  	void paintEvent(QPaintEvent *event);
    	void resizeEvent (QResizeEvent * event );
	void mousePressEvent(QMouseEvent *event);
    	void mouseMoveEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);
	
	void createRing();
	void createTriangle();
	void renderHueSelector(QPainter *);
	void renderLgtSatSelector(QPainter *);
	DragType checkPoint(QPoint);
	void dragRingSelector(QPoint);
	void dragTriangleSelector(QPoint);
	void setHue(int);
	void setLgtSat(int,int);
	bool lgtSatToPos(QPointF&);
	bool posToLgtSat(QPointF,int&,int&);
	bool projectPosToLgtSat(QPointF,int &, int &);
	int saturation(int,int);
	int chroma(int,int);		
	
private:
    	QPixmap ringPix_;
	QPixmap triPix_;
	int ringWidth_;
	int outerRadius_;
	int innerRadius_;
	int hue_;
	int sat_;
	int lgt_; 
	int lgtSatSelectorRadius_;
	QPen huePenBlack_;
	QPen huePenWhite_;
	QPoint centre_;
	DragType dragType_;
	QPoint lgtSatPos_;
	QPoint lgtSatOffset_;
	QPoint dragPos_;
};

class MvQColourSelectionWidget : public QWidget
{
Q_OBJECT

public:
    	MvQColourSelectionWidget(QWidget *parent = 0);
	void setColour(QColor);
	QColor currentColour() {return currentColour_;}
	
public slots:
    	void slotGridSelected(QColor);
	void slotWheelChanged(int, int, int);
	void slotWheelChanged(QColor);
    	void slotRgbChanged(int);
    	void slotHslChanged(int);
    	void slotHtmlChanged(QString);
    	void slotOk(bool);

signals:
    	void colourChanged(int,int,int);
    	void colourSelected(QColor);

private:
    	void setColourBox(QColor);
	
	QTabWidget* tab_;
	MvQColourWheel   *wheel_;
	MvQColourGrid* grid_;
    	QLabel      *selectedColorBox_;
    	QPushButton *okPb_;
    	QObject     *parentObject_;
    	QColor      currentColour_;
    
    	QList<QSpinBox*> rgbSpin_;
    	QList<QSpinBox*> hslSpin_;
   	QLineEdit* htmlEdit_;
    
    	bool ignoreRgbSpin_;
    	bool ignoreHslSpin_;
    	bool ignoreHtmlEdit_;
};


class MvQColourHelp : public MvQRequestPanelHelp
{
Q_OBJECT  

public:
	MvQColourHelp(RequestPanel& owner,const Parameter& param);
	~MvQColourHelp() {};
	
	void start() {};
	bool dialog() {return false;}	
	QWidget* widget() {return selector_;}

public slots:
    	void slotSelected(QColor);

protected:
  	virtual void refresh(const vector<string>&);

private:
	MvQColourSelectionWidget* selector_;
};	

#endif
